;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = OEMBLT.INC
;*
;* DESCRIPTIVE NAME = BitBlt Definitions
;*
;*
;* VERSION      V2.0
;*
;* DATE         11/18/90
;*
;* DESCRIPTION  BitBlt Definitions
;*
;* FUNCTIONS
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   11/18/90                     Written
;*   03/08/93              61778  pass style flags to Blt workers
;*
;*****************************************************************************/

;/*
;** The gray rop codes
;*/

GRAY_ROP        equ     80CAh                     ;At the API level

;/*
;** The Device Bitmap as a bitblt source
;*/

BLTMODE_SRC_HDBM equ    00100000h       ;At the DDI level
BLTMODE_SCR_DRAW equ    00200000h       ;At the DDI level

;/*
;** flag values for obba_fs
;**
;** Note: BBF_TRANS_NO_CC is a qualifier for BBF_TRANS and BBF_ANTI_TRANS.
;**       If has no meaning by itself.
;*/

BBF_SRC_BITMAP  equ     0001h                     ;Source is a bitmap
BBF_HAVE_SOURCE equ     0002h                     ;A source is required
BBF_GRAY_ROP    equ     0004h                     ;Rop is the gray rap
BBF_SAME_SD     equ     0008h                     ;Source and dest are same surfaces
BBF_REVERSE_BMP equ     0010h           ;A standard format bitmap's order is reverse
BBF_STRETCHBLT  equ     0020h           ;require stretchblt
BBF_COLOR_SRC   equ     0040h                     ;Source is color
BBF_CMEM_TO_SCR equ     0080h           ;color memory to screen blt
BBF_NO_COLOR_INFO equ   0100h           ;           add this flag
;               equ     0200h
;               equ     0400h
;               equ     0800h
BBF_IMAGE_DATA  equ     1000h                     ;This blt is an image data blt
BBF_TRANS_NO_CC equ     2000h                     ;Transparency without color conversion
BBF_ANTI_TRANS  equ     4000h                     ;Anti-transparency needed
BBF_TRANS       equ     8000h                     ;Transparency needed

;/*
;** Return codes from oem bitblt
;*/

BBRC_SKIP_PASS_TWO      equ                      5AA5h ;Skip pass two of image data
BBRC_NORMAL             equ                      0001h ;Normal return code

;/*
;** The actual frame for oem bitblt
;*/

OBB_ARGS        struct
obba_pddcDst    DWORD   ?
obba_xDst       DWORD   ?
obba_yDst       DWORD   ?
obba_psdSrc     DWORD   ?
obba_xSrc       DWORD   ?
obba_ySrc       DWORD   ?
obba_cxExt      DWORD   ?
obba_cyExt      DWORD   ?
obba_usMix      DWORD   ?
obba_ipcBkgnd   DWORD   ?
obba_fsBlt      DWORD   ?
OBB_ARGS        ends


;/*
;** Parameters and data passed to the oem strblt function
;*/

eto_args                struct
eto_lpDDC               DWORD   ?
eto_lpDestDev           DWORD   ?
eto_x                   DWORD                    ?
eto_y                   DWORD                    ?
eto_lpClipRect          DWORD                    ?
eto_lpString            DWORD                    ?
eto_count               DWORD                    ?
eto_npAttrs             DWORD   ?
eto_lpDX                DWORD                    ?
eto_lpOpaqueRect        DWORD                    ?
eto_Options             DWORD                    ?
eto_args                ends

;/*
;** The actual frame for OemDrawBits
;*/

ODB_ARGS        struct
odba_pddcDst    DWORD   ?
odba_xDst       DWORD   ?
odba_yDst       DWORD   ?
odba_psdSrc     DWORD   ?
odba_xSrc       DWORD   ?
odba_ySrc       DWORD   ?
odba_cxExt      DWORD   ?
odba_cyExt      DWORD   ?
odba_usMix      DWORD   ?
odba_ipcBkgnd   DWORD   ?
odba_fsBlt      DWORD   ?
ODB_ARGS        ends

        .errnz  OBB_ARGS.obba_cyExt   -ODB_ARGS.odba_cyExt
        .errnz  OBB_ARGS.obba_cxExt   -ODB_ARGS.odba_cxExt
        .errnz  OBB_ARGS.obba_ySrc    -ODB_ARGS.odba_ySrc
        .errnz  OBB_ARGS.obba_xSrc    -ODB_ARGS.odba_xSrc
        .errnz  OBB_ARGS.obba_psdSrc  -ODB_ARGS.odba_psdSrc
        .errnz  OBB_ARGS.obba_yDst    -ODB_ARGS.odba_yDst
        .errnz  OBB_ARGS.obba_xDst    -ODB_ARGS.odba_xDst
        .errnz  OBB_ARGS.obba_pddcDst -ODB_ARGS.odba_pddcDst

;/*
;** The actual frame for OemStrchBlt
;*/

OSB_ARGS        struct
osba_pddcDst    DWORD   ?
osba_xDst       DWORD   ?
osba_yDst       DWORD   ?
osba_psdSrc     DWORD   ?
osba_SPACER     DWORD      ?
osba_lpParm     DWORD   ?
osba_cxExt      DWORD   ?
osba_cyExt      DWORD   ?
OSB_ARGS        ends

        .errnz  OBB_ARGS.obba_usMix-(sizeof OSB_ARGS)
        .errnz  OBB_ARGS.obba_cyExt   -OSB_ARGS.osba_cyExt
        .errnz  OBB_ARGS.obba_cxExt   -OSB_ARGS.osba_cxExt
        .errnz  OBB_ARGS.obba_ySrc    -OSB_ARGS.osba_lpParm
        .errnz  OBB_ARGS.obba_psdSrc  -OSB_ARGS.osba_psdSrc
        .errnz  OBB_ARGS.obba_yDst    -OSB_ARGS.osba_yDst
        .errnz  OBB_ARGS.obba_xDst    -OSB_ARGS.osba_xDst
        .errnz  OBB_ARGS.obba_pddcDst -OSB_ARGS.osba_pddcDst

;/*
;** The stretchBlt parameter's structure pointed by OSB_ARGS.osba_lpParm
;*/

STBLT   struc
stb_lpRectl     DWORD   ?
stb_xSrcDel     DWORD   ?
stb_ySrcDel     DWORD   ?
stb_xDstDel     DWORD   ?
stb_yDstDel     DWORD   ?
STBLT   ends
