;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = FONTDRVR.INC
;*
;* DESCRIPTIVE NAME = DevEscape (DEVESC_DBE_FONTMANAGEMENT) function
;*
;*
;*
;*
;* The following IBM OS/2 2.1 source code is provided to you solely for
;* the purpose of assisting you in your development of OS/2 2.x device
;* drivers. You may use this code in accordance with the IBM License
;* Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;* Copyright statement may not be removed.
;*
;*
;* VERSION      V2.0
;*
;* DESCRIPTION  Load/Unload specified font driver as public/private.
;*              Return the Vio font attribute corresponding to the
;*              specified cellsize.
;*
;* SUB FUNCTIONS    LOAD_FD_PRIVATE     load font driver private
;*                  LOAD_FD_PUBLIC      load font driver public
;*                  UNLOAD_FD_PRIVATE   unload font driver private
;*                  UNLOAD_FD_PUBLIC    unload font driver public
;*                  QUERY_VIO_FONTATTRIBUTE
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;*****************************************************************************/

DEVESC_DBE_FONTMANAGEMENT EQU 24450   ; moved from OS2NLSFD.INC

CE_INVALID_PRESENTATION_SPACE   equ     -34

DBE_FDI_PARAMETERS struct 4
        fdi_lMatch      dd ?
        fdi_lFunctionID dd ?
        fdi_lCodePoint  dd ?
        fdi_pFontInfo   dd ?
DBE_FDI_PARAMETERS ends

; fdi_lFunctionID

LOAD_FD_PRIVATE         equ     8001h       ; load font driver private
LOAD_FD_PUBLIC          equ     8003h       ; load font driver public
UNLOAD_FD_PRIVATE       equ     8002h       ; unload font driver private
UNLOAD_FD_PUBLIC        equ     8004h       ; unload font driver public

VIOFONTATTRIBUTE struct 4
        vioa_ulRecordLength dd ?
        vioa_lFunctionID    dd ?
        vioa_cx             dd ?
        vioa_cy             dd ?
VIOFONTATTRIBUTE ends

        .errnz  (vioa_lFunctionID - fdi_lFunctionID)
        .errnz  (size VIOFONTATTRIBUTE - size DBE_FDI_PARAMETERS)

; vioa_lFunctionID

QUERY_VIO_FONTATTRIBUTE equ     4001h       ; returns FATTR structure

