;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = EXTERN.INC
;*
;* DESCRIPTIVE NAME = External References
;*
;*
;* VERSION      V2.0
;*
;* DATE         
;*
;* DESCRIPTION  This file contains all declarations necessary to make global 
;*              identifiers known to all modules that need them.
;*              
;*
;* FUNCTIONS    
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   10/04/91                      SL   Original
;*   10/04/91                      KEZ  Add externals & publics used in DATA.ASM
;*   12/06/92              SM12669 DAK  separate fonts into different HMODULE
;*   07/06/92               41616  DAK  model/submodel for nectarine and cursor type
;*   07/09/92                      DAK  some constants are DWORD in the generic DLL
;*   09/30/92                      had to conditionally compile an extern.
;*   11/26/92                     John Batty. Added DCAF changes.
;*   12/03/92              57589  32-Bit Semaphore Support
;*   11/17/93  Changeteam  75466  Added debug data definitions
;*
;*****************************************************************************/

IFNDEF   EXTERN_DEFD    ; Don't include if already included

EXTERN_DEFD EQU 1       ; Indicate it has been included

;/*
;** Instance Data
;*/

EXTERNDEF flPerProcInstance             :DWORD    ; per process init flag

;/*
;** Regular Data
;*/

EXTERNDEF _hModuleFnt                   :DWORD    ; handle to the font module
EXTERNDEF _hModuleDev                   :DWORD    ; handle to the device module
EXTERNDEF abAdjMixMapImage              :BYTE
EXTERNDEF abMixMapPattern               :BYTE     ; Mix map pattern table
EXTERNDEF adDevCapsData                 :DWORD
EXTERNDEF adDevVioCells                 :CellFont ; VIO cell font size table
EXTERNDEF abBasePatterns                :BYTE     ; Base brush patterns
EXTERNDEF adBitmapFormats               :DWORD    ; Ptr to QueryDeviceBitmaps table
EXTERNDEF adrgbDefault                  :DWORD
EXTERNDEF adrgbIndex                    :DWORD
EXTERNDEF adrgbSpecial                  :DWORD
EXTERNDEF aipcLookup                    :WORD
EXTERNDEF aipcSpecial                   :WORD
EXTERNDEF anpabBackMix                  :DWORD    ; Ptr to background mix mode
EXTERNDEF anpabForeMix                  :DWORD    ; Ptr to foreground mix mode
EXTERNDEF apfnDefDispatch               :DWORD    ; Default dispatch table
EXTERNDEF apfnOurDispatch               :DWORD

;/*
;** Link time constants describing the size and color format that the EGA will
;** be running in.
;*/

EXTERNDEF BitmapData                    :WORD
EXTERNDEF Bitmap_rop_flags              :BYTE   ; Special EGA drawing mode
                                                ; flags
EXTERNDEF Bitmap_rop_data_r             :BYTE   ; EGA Data Rotate Register
                                                ; value
EXTERNDEF Bitmap_rop_pen_and            :BYTE   ; Special EGA Drawing mode pen
                                                ; AND mask
EXTERNDEF Bitmap_rop_pen_xor            :BYTE   ; Special EGA Drawing mode pen
                                                ; XOR mask

IFNDEF DINCL_SKIP_DDC

EXTERNDEF bmc1Pixel1Plane               :BMC
EXTERNDEF bmc1Pixel4Plane               :BMC
EXTERNDEF bmc4Pixel1Plane               :BMC
EXTERNDEF bmc8Pixel1Plane               :BMC

ENDIF ; !DINCL_SKIP_DDC

EXTERNDEF bVGAtype                      :BYTE
EXTERNDEF cbHeap                        :DWORD    ; Heap size
EXTERNDEF CodeData                      :WORD     ; Our DS
EXTERNDEF Code_rop_data_r               :BYTE
EXTERNDEF Code_rop_flags                :BYTE     ; Special EGA drawing mode flags
EXTERNDEF Code_rop_pen_and              :BYTE
EXTERNDEF Code_rop_pen_xor              :BYTE
EXTERNDEF cPtrSizes                     :DWORD    ; Number of pointer sizes
EXTERNDEF cResource                     :DWORD    ; Number of resources to load
EXTERNDEF cxPointer                     :DWORD    ; X co-ordinate of pointer
EXTERNDEF cyPointer                     :DWORD    ; Y co-ordinate of pointer
EXTERNDEF dAdapter                      :DWORD    ; Adapter type

IFNDEF DINCL_SKIP_DDC

EXTERNDEF ddcInit                       :DDC      ; Initial ddc

ENDIF ; !DINCL_SKIP_DDC

EXTERNDEF dDisplay                      :DWORD    ; Display type
EXTERNDEF default_vio_cpid              :DWORD    ; The meaning of code page zero...

IFNDEF DINCL_SKIP_DDC

EXTERNDEF defFontChar                   :FONT_RES ; Default font
EXTERNDEF defFontMarker                 :FONT_RES ; Default marker

ENDIF ; !DINCL_SKIP_DDC

EXTERNDEF drgbSysClrWindow              :DWORD
EXTERNDEF drgbSysClrWindowText          :DWORD

IFDEF DRIVER_DEFD

EXTERNDEF drqVideo                      :vvdrq_s

ENDIF ; DRIVER_DEFD

EXTERNDEF FarHeap                       :DWORD    ; Pointer to driver's far heap
EXTERNDEF fbOffScreen                   :BYTE     ; Off-screen memory flags
EXTERNDEF fbRip                         :BYTE     ; RIP flag
EXTERNDEF fbShadowFlags                 :BYTE
EXTERNDEF fControllerMine               :BYTE     ; Set only when fControllerOwned is set by driver
EXTERNDEF fControllerNotify             :BYTE
EXTERNDEF fControllerOwned              :BYTE
EXTERNDEF fEnabled                      :BYTE     ; Logical Virgin flag
EXTERNDEF fGrimReaper                   :BYTE
EXTERNDEF fPhysEnabled                  :BYTE     ; Physical Virgin flag

IFNDEF DINCL_SKIP_DDC

ifdef DCAF                                                           ;          
EXTERNDEF gsbdev                        :BYTE                        ;          
endif; DCAF                                                          ;          
EXTERNDEF gsspScreen                    :GSSP     ; GSS structure for screen

ENDIF ; !DINCL_SKIP_DDC

EXTERNDEF hLocalHeap                    :DWORD    ; Handle to local heap

;/*
;** The following extern needed to be changed conditionally because several
;** files included extern.inc but did not include the FSRSEM structure
;**           
;*/

ifndef OS2_NOPMAPI
EXTERNDEF semDriver                     :FSRSEM
endif

EXTERNDEF hVideoVDD                     :DWORD
EXTERNDEF idBrush                       :DWORD    ; Initial brush ID
EXTERNDEF idBrushCache                  :DWORD    ; ID of brush stored in cache
EXTERNDEF InitSegData                   :DWORD
EXTERNDEF ipc_index_mask                :DWORD
EXTERNDEF ipcSysClrWindow               :WORD
EXTERNDEF ipcSysClrWindowText           :WORD
EXTERNDEF aipcLookup                    :WORD
EXTERNDEF lnbTotalScreenSize            :DWORD    ; Adapter memory size
EXTERNDEF nbOffScreenUsed               :DWORD    ; Size of offscreen mem. in use
EXTERNDEF padBitmapFormats              :DWORD    ; Ptr to QueryDeviceBitmaps table
EXTERNDEF pbmcColor                     :DWORD    ; Color bitmap format
EXTERNDEF pbmcDev                       :DWORD    ; Device's bitmap format
EXTERNDEF pbmcMono                      :DWORD    ; Mono bitmap format
EXTERNDEF pfnDefConvert                 :DWORD
EXTERNDEF pfnDefDisjointLines           :DWORD
EXTERNDEF pfnDefPolyLine                :DWORD
EXTERNDEF pfnDefSetCurrentPosition      :DWORD
EXTERNDEF pfnDefPolyMarker              :DWORD
ifdef   DCAF                                                         ;          
EXTERNDEF pfnDefGetRegionBox            :DWORD                       ;          
EXTERNDEF pfnDefGetRegionRects          :DWORD                       ;          
EXTERNDEF pfnDefCombineRectRegion       :DWORD                       ;          
EXTERNDEF pfnDefSetRectRegion           :DWORD                       ;          
EXTERNDEF pfnUnPackBuffer               :DWORD                       ;          
EXTERNDEF pfnGetScreenBits              :DWORD                       ;          
EXTERNDEF pfnSetScreenBits              :DWORD                       ;          
EXTERNDEF fDCAFEnabled                  :DWORD                       ;          
EXTERNDEF ulGlobalCOMFlags              :DWORD                       ;          
endif;  DCAF                                                         ;          

EXTERNDEF pDefVioFont                   :CellFont ; Default VIO font info.
EXTERNDEF pOffScreenScan                :DWORD
EXTERNDEF pOffScreenUsed                :DWORD    ; Addr. of current offscreen memory
IFDEF DRIVER_DEFD

EXTERNDEF PtrSizes                      :PTRSIZE  ; Array of pointer sizes

ENDIF ; DRIVER_DEFD

EXTERNDEF proc_stack_area               :DWORD    ; Ptr to instance data area
EXTERNDEF proc_initial_sp               :DWORD    ; Ptr to instance data area
                                                  ; used to build to store compiled
                                                  ; Bitblt code

ifdef   DCAF                                                         ;          
EXTERNDEF pStartSCA                     :DWORD                       ;          
endif;  DCAF                                                         ;          

IFNDEF DINCL_SKIP_DDC

EXTERNDEF rddcInit                      :RDDC     ; Initial ddc

ENDIF ; !DINCL_SKIP_DDC

IFNDEF DINCL_SKIP_DDC

EXTERNDEF sdIC                          :SURFACE  ; Surface definition for an IC
EXTERNDEF sdScreen                      :SURFACE

ENDIF ; !DINCL_SKIP_DDC

ifdef   DCAF                                                         ;          
EXTERNDEF  SeamlessCodeEnd         :DWORD                            ;          
EXTERNDEF  SeamlessSCA             :DWORD                            ;          
endif  ;DCAF                                                         ;          
EXTERNDEF selCompileCode                :DWORD
EXTERNDEF selCompileData                :DWORD
EXTERNDEF selDeathToUse                 :DWORD
EXTERNDEF selTextVram                   :DWORD
EXTERNDEF shadow_data                   :BYTE
EXTERNDEF ss_height                     :DWORD   ;# of scans to output
EXTERNDEF ss_next_scan                  :DWORD   ;Delta to next scan of a bitmap
EXTERNDEF ss_draw                       :DWORD   ;Function to do output
EXTERNDEF ss_draw_clipped               :DWORD   ;Function to do clipped output
EXTERNDEF ss_phases                     :DWORD   ;Phases for 4 character case
EXTERNDEF ss_colors                     :DWORD   ;Foreground/background colors
EXTERNDEF ss_p_frame                    :DWORD   ;Link to stack frame
EXTERNDEF ss_column_width               :DWORD   ;Width of character data column output
EXTERNDEF ss_clip_mask                  :BYTE    ;Clipping mask
EXTERNDEF ss_num_chars                  :BYTE    ;Number characters for n char case
EXTERNDEF szSQ                          :BYTE
EXTERNDEF szSvgaEntry                   :BYTE     ; "\SEM32\SVGAENTRY.MTX",0
EXTERNDEF szVideoVDD                    :BYTE
EXTERNDEF wSVGAtype                     :WORD
EXTERNDEF DosDevIOCTL                   :NEAR  

EXTERNDEF wAdapter                      :WORD    ; Adapter Type
EXTERNDEF wDisplay                      :WORD    ; Display type
EXTERNDEF yOffScreenScan                :DWORD

EXTERNDEF bModel                        :BYTE    ; machine model
EXTERNDEF bSubModel                     :BYTE    ; machine sub model
EXTERNDEF lCursorSize                   :DWORD   ; cursor type to use

IFDEF DBCS  ; DBCS AVio attribute support    ;IBMJ

DRVCOMPAT_1 EQU 1   ; compatibility = OS/2 J1.x
DRVCOMPAT_2 EQU 2   ; compatibility = OS/2 J2.x

EXTERNDEF swDrvFontRes   :WORD ; driver version compatibility
EXTERNDEF swFlags   :WORD ;sw flags, telling us sw config
IFDEF IBMJ  ; IBMJ application compatibility
EXTERNDEF swDrvAdjustCellSize  :DWORD
     ;adjust cellsize to 1.x compatibles
EXTERNDEF dPhysColor   :DWORD
ENDIF;IBMJ

EXTERNDEF lpDbcsFontSeg   :DWORD ; DBCS system font fontseg
EXTERNDEF lpSbcsFontSeg   :DWORD ; SBCS system font fontseg

EXTERNDEF pfnDefQueryWidthTable  :DWORD
EXTERNDEF pfnDefQueryCharPositions :DWORD

EXTERNDEF usSysFontHeight  :DWORD ; DBCS system font height
EXTERNDEF usSysFontWidth  :DWORD ; DBCS system font width
EXTERNDEF szSysFontName   :BYTE ; DBCS system font facename
EXTERNDEF szVioFontName   :BYTE ; DBCS vio font familyname

EXTERNDEF cDevVioCells   :DWORD ;# of elements in adDevVioCells

EXTERNDEF fsFont                        :DWORD ;Font profile flags

IFDEF JFIX        ;IBMJ
EXTERNDEF shadowed_graf_rot  :BYTE
ENDIF;JFIX        ;IBMJ

EXTERNDEF DeviceFontWidth  :DWORD

ifdef JTUNE        ;IBMJ
EXTERNDEF ClipRectsForBackup            :DWORD
endif;JTUNE        ;IBMJ
ENDIF;DBCS        ;IBMJ

;/*
;**             Error Values 
;** Declare these asEXTERNDEF PMERR_* :abs so that their values will be resolved 
;** at link time based on the value set in ERROR.ASM.                       
;** WAS -> errcode <INSUFFICIENT_MEMORY,BASE_ERROR>                         
;*/

EXTERNDEF PMERR_BASE_ERROR              :ABS
EXTERNDEF PMERR_BASE_ERROR              :ABS
EXTERNDEF PMERR_BITMAP_IS_SELECTED      :ABS
EXTERNDEF PMERR_BITMAP_NOT_SELECTED     :ABS
EXTERNDEF PMERR_COL_TABLE_NOT_REALIZABLE:ABS
EXTERNDEF PMERR_COL_TABLE_NOT_REALIZED  :ABS
EXTERNDEF PMERR_DATA                    :ABS
EXTERNDEF PMERR_DEV_FUNC_NOT_INSTALLED  :ABS
EXTERNDEF PMERR_FONT_NOT_LOADED         :ABS
EXTERNDEF PMERR_HUGE_FONTS_NOT_SUPPORTED:ABS
EXTERNDEF PMERR_INCORRECT_DC_TYPE       :ABS
EXTERNDEF PMERR_INSUFFICIENT_MEMORY     :ABS
EXTERNDEF PMERR_INV_BITBLT_MIX          :ABS
EXTERNDEF PMERR_INV_BITBLT_STYLE        :ABS
EXTERNDEF PMERR_INV_BITMAP_DIMENSION    :ABS
EXTERNDEF PMERR_INV_CODEPAGE            :ABS
EXTERNDEF PMERR_INV_COLOR_DATA          :ABS
EXTERNDEF PMERR_INV_COLOR_FORMAT        :ABS
EXTERNDEF PMERR_INV_COLOR_INDEX         :ABS
EXTERNDEF PMERR_INV_COLOR_OPTIONS       :ABS
EXTERNDEF PMERR_INV_COLOR_START_INDEX   :ABS
EXTERNDEF PMERR_INV_COORDINATE          :ABS
EXTERNDEF PMERR_INV_DC_TYPE             :ABS
IFDEF DBCS  ; DBCS codepage / DBCS device font support   ;IBMJ
EXTERNDEF PMERR_INV_FIRST_CHAR  :ABS
ENDIF;DBCS        ;IBMJ
EXTERNDEF PMERR_INV_FONT_ATTRS          :ABS
EXTERNDEF PMERR_INV_HBITMAP             :ABS
EXTERNDEF PMERR_INV_HDC                 :ABS
EXTERNDEF PMERR_INV_IMAGE_DATA_LENGTH   :ABS
EXTERNDEF PMERR_INV_IN_AREA             :ABS
EXTERNDEF PMERR_INV_IN_PATH             :ABS
EXTERNDEF PMERR_INV_INFO_TABLE          :ABS
EXTERNDEF PMERR_INV_LENGTH_OR_COUNT     :ABS
EXTERNDEF PMERR_INV_OR_INCOMPAT_OPTIONS :ABS
EXTERNDEF PMERR_INV_PATTERN_ATTR        :ABS
EXTERNDEF PMERR_INV_PATTERN_REF_PT_ATTR :ABS
EXTERNDEF PMERR_INV_PATTERN_SET_ATTR    :ABS
EXTERNDEF PMERR_INV_PATTERN_SET_FONT    :ABS
EXTERNDEF PMERR_INV_PICK_APERTURE_POSN  :ABS
EXTERNDEF PMERR_INV_RECT                :ABS
EXTERNDEF PMERR_INV_RGBCOLOR            :ABS
EXTERNDEF PMERR_INV_SCAN_START          :ABS
EXTERNDEF PMERR_INV_SETID               :ABS
EXTERNDEF PMERR_REALIZE_NOT_SUPPORTED   :ABS
EXTERNDEF PMERR_TTRS                    :ABS

EXTERNDEF shadowed_graf_mode           :vvreg_s  ; handle to the module
EXTERNDEF pfnDefGetPairKerningTable    :DWORD
EXTERNDEF pfnDefNotifyTransformChange  :DWORD
EXTERNDEF pfnDefNotifyClipChange       :DWORD
EXTERNDEF pfnDefGetClipRects           :DWORD
EXTERNDEF pfnDefRectVisible            :DWORD
EXTERNDEF pfnDefBitblt                 :DWORD
EXTERNDEF pfnDefDrawBits               :DWORD
EXTERNDEF pfnDefPtVisible              :DWORD
EXTERNDEF pfnDefQueryTextBox           :DWORD
EXTERNDEF pfnDefCharStringPos          :DWORD
ifdef DRIVER_DEFD
EXTERNDEF drqVideo                     :vvdrq_s
endif
EXTERNDEF adDitherPatterns             :DWORD
ENDIF ; EXTERN_DEFD
EXTERNDEF pVRAMInstance                :DWORD  ; instance ptr to VRAM
EXTERNDEF pVRAMConstant                :DWORD  ; instance ptr to VRAM

;/*
;******************* ABS SECTION *******************************************'
;*/

EXTERNDEF D15_00_DEVCAPS_PHYS_COLORS    :ABS
EXTERNDEF D31_16_DEVCAPS_PHYS_COLORS    :ABS
EXTERNDEF DEF_BMIX_CHAR                 :ABS
EXTERNDEF DEF_BMIX_IMAGE                :ABS
EXTERNDEF DEF_BMIX_LINE                 :ABS
EXTERNDEF DEF_BMIX_MARKER               :ABS
EXTERNDEF DEF_BMIX_PATTERN              :ABS
EXTERNDEF DEF_DISPATCH_TBL_SIZE         :ABS      ; Size of default dispatch table
EXTERNDEF DEF_FB_CHAR                   :ABS
EXTERNDEF DEF_FB_IMAGE                  :ABS
EXTERNDEF DEF_FB_LINE                   :ABS
EXTERNDEF DEF_FB_MARKER                 :ABS
EXTERNDEF DEF_FB_PATTERN                :ABS
EXTERNDEF DEF_FMIX_CHAR                 :ABS
EXTERNDEF DEF_FMIX_IMAGE                :ABS
EXTERNDEF DEF_FMIX_LINE                 :ABS
EXTERNDEF DEF_FMIX_MARKER               :ABS
EXTERNDEF DEF_FMIX_PATTERN              :ABS
EXTERNDEF DEF_FONT_FS_FLAGS             :ABS
EXTERNDEF DEF_IPC_BACK_CLR              :ABS
EXTERNDEF DEF_IPC_FORE_CLR              :ABS
EXTERNDEF DEF_LINE_ERROR                :ABS
EXTERNDEF DEF_LINE_MASK                 :ABS
EXTERNDEF DEF_LINE_STEP_X               :ABS
EXTERNDEF DEF_LINE_STEP_Y               :ABS
EXTERNDEF DEF_LINE_TYPE                 :ABS
EXTERNDEF DEF_LOG_BACK_CLR              :ABS
EXTERNDEF DEF_LOG_FORE_CLR              :ABS
EXTERNDEF DEF_MARKER_CODE_POINT         :ABS
EXTERNDEF DEF_MARKER_FB_FLAGS           :ABS
EXTERNDEF DEF_MARKER_FS_FLAGS           :ABS
EXTERNDEF DEF_PATTERN_CODE_POINT        :ABS
EXTERNDEF DEF_PATTERN_FB_FLAGS          :ABS
EXTERNDEF DEF_PATTERN_FS_FLAGS          :ABS
EXTERNDEF DEFAULT_SELTEXTVRAM           :ABS
EXTERNDEF DEV_DISPATCH_TBL_SIZE         :ABS      ; Size of dispatch table
EXTERNDEF DEVCAPS_CHAR_HEIGHT           :ABS
EXTERNDEF DEVCAPS_CHAR_WIDTH            :ABS
EXTERNDEF DEVCAPS_COLOR_INDEX           :ABS
EXTERNDEF DEVCAPS_COLOR_POINTER_SUPPORT :ABS
EXTERNDEF DEVCAPS_COLORS                :ABS
EXTERNDEF DEVCAPS_GRAPHICS_CHAR_HEIGHT  :ABS
EXTERNDEF DEVCAPS_GRAPHICS_CHAR_WIDTH   :ABS
EXTERNDEF DEVCAPS_HEIGHT_IN_CHARS       :ABS
EXTERNDEF DEVCAPS_HORIZONTAL_FONT_RES   :ABS
EXTERNDEF DEVCAPS_SMALL_CHAR_HEIGHT     :ABS
EXTERNDEF DEVCAPS_SMALL_CHAR_WIDTH      :ABS
EXTERNDEF DEVCAPS_VERTICAL_FONT_RES     :ABS
EXTERNDEF DEVCAPS_WIDTH_IN_CHARS        :ABS
EXTERNDEF DOS32FLATDS                   :ABS
EXTERNDEF IC_SDFB                       :ABS
EXTERNDEF IC_SDFB                       :ABS
EXTERNDEF shadow_size                   :ABS
EXTERNDEF DOSPAGESIZE                   :ABS

IFNDEF DBCS        ;IBMJ
EXTERNDEF cDevVioCells                  :ABS      ; Number of cell sizes in table
ENDIF;DBCS        ;IBMJ
EXTERNDEF COUNT_DEV_CAPS_DATA           :ABS
EXTERNDEF DEVCAPS_VERTICAL_RESOLUTION   :ABS
EXTERNDEF DEVCAPS_HORIZONTAL_RESOLUTION :ABS
EXTERNDEF SCREEN_CBSCAN                 :ABS      ;screen width in bytes
EXTERNDEF SCREEN_CX                     :ABS
EXTERNDEF SCREEN_CY                     :ABS
EXTERNDEF SCREEN_DSCAN                  :ABS
EXTERNDEF SCREEN_SDFB                   :ABS

EXTERNDEF   FirstImport                 :DWORD
EXTERNDEF   cImports                    :DWORD

EXTERNDEF COLOR_DONT_CARE               :ABS
EXTERNDEF INIT_POINTER_X                :ABS  ; Initial pointer x
EXTERNDEF INIT_POINTER_Y                :ABS  ; Initial pointer y
EXTERNDEF PTR_ROUND_LEFT                :ABS  ; Used to round left exclude
                                              ; X down
EXTERNDEF PTR_ROUND_RIGHT               :ABS  ; Used to round right
                                              ; exclude X up
EXTERNDEF PTR_HEIGHT                    :ABS  ; Height we expect pointer
                                              ; to be
EXTERNDEF PTR_WIDTH_BITS                :ABS  ; Width we expect pointer to
                                              ; be
EXTERNDEF SCREEN_CBRESERVED             :ABS
EXTERNDEF PATTERN_SCAN_UPDATE           :ABS
EXTERNDEF SS_VARIABLES_LEN              :ABS
EXTERNDEF VISIBLE_SIZE_WORDS            :ABS
EXTERNDEF DOSHUGEINCR                   :ABS

ifndef EGAMEM_AS_STRUCT
EXTERNDEF   abScreenImage               :ABS
EXTERNDEF   abPointerSave               :ABS
EXTERNDEF   abPointerWork               :ABS
EXTERNDEF   current_brush               :ABS
EXTERNDEF   known_word                  :ABS
EXTERNDEF   saved_latches               :ABS
EXTERNDEF   reserved_latches            :ABS
EXTERNDEF   plane_index                 :ABS
EXTERNDEF   enable_test                 :ABS
EXTERNDEF   tonys_bar_n_grill           :ABS
ifdef DBCS        ;IBMJ
EXTERNDEF   vert_grid_latches  :ABS
EXTERNDEF   horz_grid_latches  :ABS
endif ;DBCS        ;IBMJ
endif
ifdef SEAMLESS
EXTERNDEF   fVDMControllerMine          :BYTE
EXTERNDEF   wHeartbeat                  :WORD
EXTERNDEF   hWinVDD                     :DWORD
EXTERNDEF   fSeamless                   :BYTE
endif
EXTERNDEF   apfnDevDefDispatch          :DWORD
EXTERNDEF   tblDevHooks                 :DWORD
EXTERNDEF   vga32date                   :BYTE

EXTERNDEF   pdcGlobal                   :DWORD

EXTERNDEF   set_bank_select  :DWORD
EXTERNDEF   save_hw_state_rtns  :DWORD
EXTERNDEF   restore_hw_state_rtns :DWORD
EXTERNDEF   bank_switch_rtns  :DWORD
EXTERNDEF   cursor_bank_switch_rtns :DWORD
ifdef  JTUNE        ;IBMJ
EXTERNDEF   scr_to_scr_bitblt_rtns :DWORD
EXTERNDEF   scr_to_scr_bitblt  :DWORD
EXTERNDEF   cursor_hw_draw_rtns         :DWORD         ; pochi
EXTERNDEF   make_sprite_data_rtns       :DWORD         ; pochi
EXTERNDEF   make_sprite_data_rtn        :DWORD         ; pochi
endif ;JTUNE        ;IBMJ

ifdef FIREWALLS                                                          ;75466
                                                                         ;75466
EXTERNDEF numdebugrecords               :DWORD                           ;75466
EXTERNDEF debugdataarea                 :DWORD    ; handle to debug area ;75466
                                                                         ;75466
endif                                                                    ;75466

;/*
;**            START
;/*
ifdef FIREWALLS

EXTERNDEF   enter_flags                 :DWORD       

endif

;/*
;**            END
;/*
