;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = DRIVER.INC
;*
;* DESCRIPTIVE NAME = Driver function definitions
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION
;*
;*   This file contains the structure, flag, constant, and macro definitions
;*   for various driver functions.
;*
;*   Certain flags can be defined to include various definitions included in
;*   this file:
;*
;* DINCL_ENABLE    Include definitions for the enable function
;* DINCL_DEVBITMAP Include definitions for Create/Delete Bitmap
;* DINCL_ERROR     Include definitions for error routines
;* DINCL_CLR_TBL   Include Color table definitions
;* DINCL_VIO       Include VIO constant definitions
;* DINCL_ROP       Include old ROP2 definitions
;* DINCL_SKIP_DDC  Skip definition of the ddc structure
;*
;*
;* FUNCTIONS    NONE
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   09/18/92              DCR96  Multi-Media Support
;*   11/26/92                     John Batty. Added DCAF changes.
;*   12/03/92              57589  32-Bit Semaphore Support
;*   06/01/93  @vcb        67576  Add fields to ddc
;*
;*****************************************************************************/

IFNDEF   DRIVER_DEFD    ; Don't include if already included

include  typedefs.inc

DRIVER_DEFD EQU 1       ; Indicate it has been included

IFDEF INCL_OPTIONS       ;IBMJ
include options.inc ; driver specific options
ENDIF;INCL_OPTIONS       ;IBMJ

IFDEF DBCS  ; DBCS codepage / DBCS device font support   ;IBMJ
include pmnlsfm.inc
ENDIF;DBCS        ;IBMJ

;/*
;** Processor selection macros
;**
;** Enable assembly of a particular processor's instructions, and set a flag
;** which can be read for conditional assembly.
;**
;** Parameters:
;**        which_proc
;** Entry:
;**        none
;** Returns:
;**        none
;** Error Returns:
;**        none
;** Registers Destroyed:
;**        none
;** Registers Preserved:
;**        all
;** Calls:
;**        none
;*/

;/*
;** Some basic constants
;*/

MAXSHORT EQU      00007FFFh         ;Kinda majorly positive
MINSHORT EQU      0FFFF8000h        ;Kinda majorly negative
MAXLONG  EQU      07FFFFFFFh        ;Massively positive
MINLONG  EQU      080000000h        ;Massively negative

MAX_COORDINATE    EQU   007FFFFFFh  ;Limit width and height to 27 bits
MIN_COORDINATE    EQU   0F8000000h

SIZE_BYTE         EQU      1                 ;I hope you never use this!
SIZE_WORD         EQU      2                 ;# of bytes in a word
SIZE_DWORD        EQU      4                 ;# of bytes in a dword
SHIFT_BYTE        EQU      0                 ;I wish they had a power function
SHIFT_WORD        EQU      1
SHIFT_DWORD       EQU      2

INVALID_SEL     EQU     0FFFFh
INVALID_ADDRESS EQU   (-1)
IPC     STRUCT 2
        ipc_bClr WORD ?      ; THIS NEEDS TO STAY A WORD
IPC     ENDS

SIZE_IPC EQU      2                 ;Size of an internal physical color

INVALID_IPC       EQU     0ffffh             ;Invalid internal physical color
INVALID_IPC_DWORD EQU     0ffffffffh         ;Invalid internal physical color

WE_BE_DEAD        EQU      -1                ;Screen has been switched away

;/*
;** The next 2 symbols are used with "screen_busy", defined in CURSORSC.ASM
;*/


IS_BUSY  EQU      0                 ;  Pointer operation in progress
NOT_BUSY EQU      1                 ;  No pointer operation in progress

IFDEF INCL_GPITRANSFORMS

CVTC_SCREEN       EQU      CVTC_DEVICE+1     ;Internal device to screen conversion

ENDIF

;/*
;** Object Identifiers
;*/

DS_IDENT EQU 'dg' ;Identifier for our DGROUP
SM_IDENT EQU 'SM' ;Identifier for a semaphore
DDC_IDENT         EQU 'cd' ;Identifier for a ddc
RDDC_IDENT        EQU 'dr' ;Identifier for a rddc
SAVED_DDC_IDENT EQU 'ds' ;Identifier for a saved ddc
SURFACE_IDENT     EQU 'is' ;Identifier for a surface
HDBM_IDENT        EQU 'bh' ;Identifier for a handle to a bitmap
HDDC_IDENT        EQU 'dh' ;Identifier for a handle to a ddc
CT_IDENT EQU 'tc' ;Identifier for a color table
DELETED_IDENT     EQU 0     ;Dead objects have 0 for ident

;/*
;** Some structure definitions
;*/

OurRECTS       STRUCT   4 ;A better RECTS structure
   rcs_xLeft   DWORD  ?
   rcs_yBottom DWORD  ?
   rcs_xRight  DWORD  ?
   rcs_yTop    DWORD  ?
OurRECTS       ENDS

OurLONG  STRUCT     ;Used to access the low and
lo       WORD     ? ;   high words of a DWORD
hi       WORD     ?
OurLONG  ENDS


IFDEF DINCL_ENABLE

;/*
;** Equates needed by the enable function
;*/

PDEV_MAGIC_COOKIE EQU      'PDEV'   ;Physical ID returned from enable

;/*
;** INIT_VRAM is a parameter to the physical_enable routine indicating
;** that video memory should be set to some initial value
;*/

INIT_VRAM         EQU      1

;/*
;** Base symbol set resource constants for the default font and markers
;** contained within our .exe as resources and loaded on the first call
;** to enable.  The FONT_RES structure defines the data used to load
;** in the resources.  It may be written over at initialization time if
;** a .ini entry specifies a different font.
;*/

RT_OUR_MARKER EQU 2000     ;Default type for us
RT_OUR_FONT   EQU 1000
RES_ID_LOWER  EQU 100
RES_ID_HIGHER EQU 101

FONT_RES  STRUCT        4
fr_pp             dd       INVALID_ADDRESS ;Where resource pointer goes
fr_hModule        dd       -1                ;Module of the resource
fr_usType         dd       -1                ;Type of the resource
fr_usId  dd       -1                ;Id of the resource
FONT_RES  ENDS

PFONT_RES TYPEDEF PTR FONT_RES

;/*
;** GSSP is the structure passed to GetScreenSelector.  It contains the
;** physical starting address of video memory, the number of selectors
;** required (limited to 1 or 2), and the number of bytes to allocate
;** in the last segment (0=64K).
;**
;** The first structure element is the number of bytes of data in the
;** structure.  If this number doesn't equal the size of the GSSP
;** structure, no screen selector will be allocated by the Enable
;** function of the driver.
;*/

GSSP         STRUCT  4           ;Get Screen Selector Parameters
   ulSize   DWORD   sizeof GSSP ;   0 if no selector is needed
   cb        DWORD   0            ;   Size of memory in last selector
   pPhysMem DWORD   0             ;   Start of Physical Memory
GSSP         ENDS

PGSSP   TYPEDEF PTR GSSP

;/*
;** fun1_parm is the definition of the u32_param1 structure passed to the
;** driver for the fill_log_dev_blk call.  fun1_ret is the definition of
;** the structure passed for u32_param2.
;**
;**        fun1_ver is the version number of the Engine.
;**        fun1_cpfn         is the number of entries in the passed dispatch
;**                          table.   The driver can only write this many
;**                          entries into the table.
;**        fun1_pfb is a pointer to where the flags controlling
;**                          calls to fill_phys_dev_blk go.
;**        fun1_papfn        is the pointer to the default dispatch table
;**                          where we get the addresses of the default
;**                          handlers and where we return our handlers.
;*/

fun1_parm    STRUCT  4     ;!!! we shouldn't define this
   fun1_ver  DWORD  ?      ;!!! it should be in pmddi.inc
   fun1_cpfn DWORD  ?
fun1_parm    ENDS

fun1_ret      STRUCT  4    ;!!! we shouldn't define this
   fun1_pfb   DWORD  ?     ;!!! it should be in pmddi.inc
   fun1_papfn DWORD  ?
fun1_ret      ENDS


;/*
;** fun5_parm is the definition of the parameters passed to enable_dc
;** in pFun5Parm.
;**
;**        fun5_hState       is the handle to the PDevice block created in
;**                          fill_phys_dev_blk.
;**        fun5_type         is the DC type (memory, output, ect.), passed
;**                          to the OpenDC call.
;**        fun5_hdc          is the Engine's DC handle which will be
;**                          associated with this ddc.
;*/

fun5_parm      STRUCT  4   ;!!! we shouldn't define this
   fun5_hState DWORD  ?    ;!!! it should be in pmddi.inc
   fun5_type   DWORD  ?
   fun5_hdc    DWORD  ?
fun5_parm      ENDS


;/*
;** Logical device flags indicating how we want DDC to be managed.  The
;** values are returned in the location pointed to bu fun1_pfb.
;*/

MUSTHAVEPDEV      EQU 0001h ;!!! we shouldn't define this
LDEVSINGLEDC      EQU 0002h ;!!! it should be in pmddi.inc
LDEVIGNORENAMES   EQU 0004h

ENDIF

IFDEF DINCL_BITMAP

;/*
;** The BMC structure contains parameters for DeviceCreateBitmap
;** and DeviceDeleteBitmap.
;**
;** bmc_cbInfo      This is the number of bytes needed for a BITMAPINFO
;**                 structure for this format bitmap.  This is used for
;**                 the TRANSLATE option to DeviceDeleteBitmap.
;**
;** bmc_cBitCount   This is the BitCount field returned in the BITMAPINFO
;**                 structure when translating during DeviceDeleteBitmap.
;**                 The plane count is always returned as one.
;**
;** bmc_cRound      This value is used to round a scanline of the given
;**                 format to a double word.  It is added to sd_cx, and
;**                 then its inverse is ANDed with the sum.
;**
;** bmc_cShr        This value is a shift count used to shift the above
;**                 result to get the total number of bytes to allocate
;**                 for one scanline of one plane (sd_cbScan).
;**
;** bmc_cPlanes     This value is a multiplier used to multiply sd_cbScan
;**                 to give the size of all planes of one scan (sd_dScan).
;**
;** bmc_fbColor     This value is the color bit.  It is set to SD_COLOR
;**                 if the bitmap is color, else it is zero.
;*/

BMC                STRUCT 4
   bmc_cbInfo      DWORD   0
   bmc_cBitCount BYTE      0
   bmc_cRound      BYTE    0
   bmc_cShr        BYTE    0
   bmc_cPlanes     BYTE    0
   bmc_fbColor     BYTE    0
BMC                ENDS

PBMC TYPEDEF PTR BMC

ENDIF

IFDEF DINCL_ERROR

;/*
;** Device driver flags loaded from the environment at load time
;*/


DDF_RIP_ERROR     EQU 1
SVGAFLAGS_RIP      EQU <word ptr 'R'>
SVGAFLAGS_RIP_LC EQU <word ptr 'r'>

;/*
;** The base value of all driver errors reported to WinSetErrorInfo
;*/

DDIERR_BASE       EQU 6000h

ENDIF

IFDEF DINCL_CLR_TBL

;/*
;** color table constants
;** number of entries in default color table
;*/

DEFAULT_COLOR_TABLE_SIZE EQU 16     ; same on all devices

COLOR_TABLE  STRUCT 4
   ct_usId   DWORD  ?      ;Identifier
   ct_npargb DWORD  ?      ;Points to the rgb triplets
   ct_cSave  DWORD  ?      ;Number of reference for Save/RestoreDC
   ct_iMin   DWORD  ?      ;Minimum loaded color index
   ct_iMax   DWORD  ?      ;Maximum loaded color index
COLOR_TABLE  ENDS

ct_aipc  equ      size COLOR_TABLE ;The physical colors start here


IFDEF CLR256

;/*
;** number of entries in logical color table
;*/

LOGICAL_COLOR_TABLE_SIZE EQU 256

ELSE

LOGICAL_COLOR_TABLE_SIZE EQU 64

ENDIF

;/*
;** number of entries in logical color table
;*/

ENDIF

VGMT_OTHER                 EQU               000000001h
VGMT_GRAPHICS              EQU               000000002h
VGMT_DISABLEBURST EQU               000000004h

_VIOMODEINFO               STRUCT 4t
viomi_cb          USHORT            ?
viomi_fbType               UCHAR             ?
viomi_color                UCHAR             ?
viomi_col                  USHORT            ?
viomi_row                  USHORT            ?
viomi_hres                 USHORT            ?
viomi_vres                 USHORT            ?
_VIOMODEINFO               ENDS

TVIOMODEINFO               TYPEDEF           _VIOMODEINFO

PVIOMODEINFO               TYPEDEF           PTR TVIOMODEINFO

;/*
;**  viopal
;*/

_VIOPALSTATE               STRUCT 2t
cb                USHORT            ?
usType            USHORT            ?
iFirst            USHORT            ?
acolor            USHORT            16 DUP (?)
_VIOPALSTATE               ENDS

TVIOPALSTATE                TYPEDEF           _VIOPALSTATE

PVIOPALSTATE               TYPEDEF           PTR TVIOPALSTATE

;/*
;** Vio Font resource name ids are constructed by adding the font height to
;** RES_ID_VIO_FONT_BASE.
;*/

RES_ID_VIO_FONT_BASE EQU 2000

;/*
;** Selected offsets into the adDevCapsData structure
;*/

DEF_HEIGHT_OFFSET    EQU CAPS_CHAR_HEIGHT*4
DEF_WIDTH_OFFSET     EQU CAPS_CHAR_WIDTH *4

ALT_HEIGHT_OFFSET    EQU CAPS_SMALL_CHAR_HEIGHT*4
ALT_WIDTH_OFFSET     EQU CAPS_SMALL_CHAR_WIDTH *4

;/*
;** Code Page Mapping Constants
;*/

DEFAULTVIOCODEPAGE   EQU 850

IFDEF DINCL_ROPS

;/*
;** Various internal values for the mix modes
;*/

ROP_DDX      EQU 0      ;DDx        This is Window's ordering
ROP_DPON     EQU 1         ;DPon
ROP_DPNA     EQU 2         ;DPna
ROP_PN        EQU 3        ;Pn
ROP_PDNA     EQU 4         ;PDna
ROP_DN        EQU 5        ;Dn
ROP_DPX      EQU 6         ;DPx
ROP_DPAN     EQU 7         ;DPan
ROP_DPA      EQU 8         ;DPa
ROP_DPXN     EQU 9         ;DPxn
ROP_D         EQU 10       ;D
ROP_DPNO     EQU 11        ;DPno
ROP_P         EQU 12       ;P
ROP_PDNO     EQU 13        ;PDno
ROP_DPO      EQU 14        ;DPo
ROP_DDXN     EQU 15        ;DDxn

CHAR_ROP_DPO EQU 0         ;OR
CHAR_ROP_P   EQU 1         ;Overpaint
CHAR_ROP_D   EQU 2         ;Leave alone
CHAR_ROP_DPX EQU 3         ;XOR

ENDIF

IFDEF DINCL_BB_ROPS

;/*
;** Bitblt ROP (mixes) definitions
;*/
                           ; PMGPI.INC names
BB_ROP_D     EQU 0AAh      ; ---------------
BB_ROP_DDx   EQU 0h        ; ROP_ZERO
BB_ROP_DDxn  EQU 0FFh      ; ROP_ONE
BB_ROP_Dn    EQU 055h      ; ROP_DSTINVERT
BB_ROP_DPx   EQU 05Ah      ; ROP_PATINVERT
BB_ROP_DSa   EQU 088h      ; ROP_SRCAND
BB_ROP_DSan  EQU 077h
BB_ROP_DSna  EQU 022h
BB_ROP_DSno  EQU 0BBh      ; ROP_MERGEPAINT
BB_ROP_DSo   EQU 0EEh      ; ROP_SRCPAINT
BB_ROP_DSon  EQU 011h      ; ROP_NOTSRCERASE
BB_ROP_DSx   EQU 066h      ; ROP_SRCINVERT
BB_ROP_DSxn  EQU 099h
BB_ROP_P     EQU 0F0h      ; ROP_PATCOPY
BB_ROP_Pn    EQU 0Fh
BB_ROP_S     EQU 0CCh      ; ROP_SRCCOPY
BB_ROP_SDna  EQU 44h       ; ROP_SRCERASE
BB_ROP_SDno  EQU 0DDh
BB_ROP_Sn    EQU 33h       ; ROP_NOTSRCCOPY

ENDIF

IFDEF DINCL_SAVE_SCREEN_BITS

;/*
;** Allowed values for the function ("Options") RestoreScreenBits is
;** to perform.
;*/

RSB_FREE    EQU   00000001b
RSB_RESTORE EQU   00000010b

ENDIF

;/*
;** Flags for pattern caching
;*/

PAT_CACHE_INVALID  EQU     0  ; Pattern cache is invalid
PAT_CACHE_GRAY       EQU   1  ; Cache contains special gray pat 2-15 reserved
                           ; for us!
PAT_CACHE_FIRST_ID EQU     16 ; First user ID


IFNDEF   DINCL_SKIP_DDC

NUM_CLIP_RECTS EQU 16

;/*
;** A note on bitmap organization.
;**
;** A bitmap as an application sees it on the screen looks something
;** like:
;**
;**                   (0,n-1)                 (j-1,n-1)
;**                      -----------------------
;**                     |       scan n-1        |
;**                     |-----------------------|
;**                     |       scan 2          |
;**                     |-----------------------|
;**                     |       scan 1          |
;**                     |-----------------------|
;**                     |       scan 0          |
;**                      -----------------------
;**                   (0,0)                   (j-1,0)
;**                  first pel                last pel
;**
;**
;** The origin is in the lower left of the screen.  This unfortunately
;** is not how video memory is organized.  Video memory is organized:
;**
;**                   (0,0)                   (j-1,0)
;**                      -----------------------
;**                     |       scan 0          |
;**                     |-----------------------|
;**                     |       scan 1          |
;**                     |-----------------------|
;**                     |       scan 2          |
;**                     |-----------------------|
;**                     |       scan n-1        |
;**                      -----------------------
;**                   (0,n-1)                 (j-1,n-1)
;**                  first pel                last pel
;**
;** All internal drawing routines will convert Y coordinates from the first
;** format into the second format (subtract the given Y from the height of
;** the surface - 1).  The smallest address within the bitmap will be that
;** of pel (0,0).  The highest address within the bitmap will be that of
;** pel (m-1,n-1).
;**
;**
;** The actual organization of a memory bitmap will be as follows:
;**
;**   Bitmap characteristics:
;**
;**        1  plane of information, z bits per pel (z=1,4,8)
;**
;**        j  pels across
;**
;**        k  bytes per scan line.  This is rounded to a dword
;**           value and computed as k = (((j*p)+31)/8) & 0xFFFC.
;**
;**        l  scan lines fitting within a 64K segment.  This is
;**           computed as l = 65536/(k*1).  This field is only
;**           relevant for bitmaps which require more than 64K
;**           bytes of memory.
;**
;**        m  unused bytes per 64K segment.  This is computed as
;**           m = 65536 mod (k*1).  This field is only relevant
;**           for bitmaps which require more than 64K bytes of
;**           memory.
;**
;**        n  total scanlines
;**
;**
;**
;**                      <-------k bytes------->
;**                          (dword multiple)
;**
;**                   (0,0)                   (0,j-1)
;**    lowest  ---       -----------------------         ---           ---
;**    addr in  |       |       scan 0          |         |             |
;**    memory   |       |-----------------------|         |             |
;**             |       |       scan 1          |         |             |
;**             |       |-----------------------|                       |
;**                     |       scan 2          |     l scanlines       |
;**            64K      |-----------------------|                       |
;**                     |        ...            |         |             |
;**             |       |-----------------------|         |             |
;**             |       |       scan l-1        |         |             |
;**             |       |-----------------------         ---            |
;**             |       | (unused) |        (l-1,j-1)                   |
;**            ---      -----------                                     |
;**                                                                     |
;**                      <-m bytes->                                    |
;**                                                                     |
;**                                                                     |
;**                   (l,0)                 (l,j-1)                     |
;**            ---       -----------------------         ---            |
;**             |       |       scan l          |         |             |
;**             |       |-----------------------|         |
;**             |       |       scan l+1        |         |         h scans
;**             |       |-----------------------|
;**                     |       scan l+2        |     l scanlines       |
;**            64K      |-----------------------|                       |
;**                     |        ...            |         |             |
;**             |       |-----------------------|         |             |
;**             |       |       scan 2l-1       |         |             |
;**             |       |-----------------------         ---            |
;**             |       | (unused) |       (2l-1,j-1)                   |
;**            ---      -----------                                     |
;**                                                                     |
;**                                                                     |
;**                   (2l,0)                (2l,j-1)                    |
;**            ---       -----------------------         ---            |
;**             |       |       scan 2l         |         |             |
;**             |       |-----------------------|                       |
;**                     |       scan 2l+1       |     l scanlines       |
;**          > 64K      |-----------------------|                       |
;**                     |        ...            |         |             |
;**    highest  |       |-----------------------|         |             |
;**    addr in  |       |       scan n-1        |        ---            |
;**    memory  ---       -----------------------                       ---
;**                  (n-1,0)                (n-1,j-1)
;**
;**
;**   If the bitmap requires less than 64K of memory, only the last
;**   segment pictured is relevant.
;**
;**
;**   Bitmap characteristics:
;**
;**        4  planes of information, 1 bit per plane per pel
;**
;**        j  pels across
;**
;**        k  bytes per scan line.  This is rounded to a dword
;**           value and computed as k = (((j*1)+31)/8) & 0xFFFC.
;**
;**        l  scan lines fitting within a 64K segment.  This is
;**           computed as l = (65536 / (k*4)).  This field is
;**           only relevant for bitmaps which require more than
;**           64K total memory.
;**
;**           NOTE:  This calculation insures that all planes of
;**                   a given scanline are contained within the
;**                   same 64K segment.
;**
;**        m  unused bytes per 64K segment.  This is computed as
;**           m = 65536 mod (k*4).  This field is only relevant
;**           for bitmaps which require more than 64K total memory.
;**
;**        n  total scanlines
;**
;**
;**        For color bitmaps, each scan line consists of four planes
;**        of information.  Extra information is computed for color
;**        bitmaps:
;**
;**            d  bytes between scans of the same plane.  This is
;**               computed as d = (4 * k).
;**
;**                      -----------------------           ---          -----
;**                     |    scan 0, plane 0    |           |             |
;**                     |-----------------------|           |          this is
;**                     |    scan 0, plane 1    |                      refered
;**                     |-----------------------|       4 * k bytes    to as a
;**                     |    scan 0, plane 2    |                      c-scan
;**                     |-----------------------|           |          below
;**                     |    scan 0, plane 3    |           |             |
;**                     |-----------------------|          ---          -----
;**                     |    scan 1, plane 0    |           |
;**                     |-----------------------|           |
;**                     |    scan 1, plane 1    |
;**                     |-----------------------|       4 * k bytes
;**                     |    scan 1, plane 2    |
;**                     |-----------------------|           |
;**                     |    scan 1, plane 3    |           |
;**                     |-----------------------|          ---
;**                               ....
;**
;**                     |-----------------------|          ---
;**                     |    scan n-1, plane 0  |           |
;**                     |-----------------------|           |
;**                     |    scan n-1, plane 1  |
;**                     |-----------------------|       4 * k bytes
;**                     |    scan n-1, plane 2  |
;**                     |-----------------------|           |
;**                     |    scan n-1, plane 3  |           |
;**                      -----------------------           ---
;**
;**
;**                      <-------k bytes------->
;**                          (dword multiple)
;**
;**                   (0,0)                  (0,j-1)
;**    lowest  ---       -----------------------         ---           ---
;**    addr in  |       |     c-scan 0          |         |             |
;**    memory   |       |-----------------------|         |             |
;**             |       |     c-scan 1          |         |             |
;**             |       |-----------------------|                       |
;**                     |     c-scan 2          |     l scanlines       |
;**             64K     |-----------------------|                       |
;**                     |        ...            |         |             |
;**             |       |-----------------------|         |             |
;**             |       |     c-scan l-1        |         |             |
;**             |       |-----------------------         ---            |
;**             |       | (unused)  |       (l-1,j-1)                   |
;**            ---       -----------                                    |
;**                                                                     |
;**                      <-m bytes->                                    |
;**                                                                     |
;**                                                                     |
;**                   (l,0)                  (l,j-1)                    |
;**            ---       -----------------------         ---            |
;**             |       |     c-scan l          |         |             |
;**             |       |-----------------------|         |
;**             |       |     c-scan l+1        |         |         h scans
;**             |       |-----------------------|
;**                     |     c-scan l+2        |     l scanlines       |
;**            64K      |-----------------------|                       |
;**                     |        ...            |         |             |
;**             |       |-----------------------|         |             |
;**             |       |     c-scan 2l-1       |         |             |
;**             |       |-----------------------         ---            |
;**             |       | (unused)    |      (2l-1,j-1)                 |
;**            ---       -----------                                    |
;**                                                                     |
;**                      <-m bytes->                                    |
;**                                                                     |
;**                                                                     |
;**                   (2l,0)                (2l,j-1)                    |
;**            ---       -----------------------         ---            |
;**             |       |     c-scan 2l         |         |             |
;**             |       |-----------------------|                       |
;**                     |     c-scan 2l+1       |     l scanlines       |
;**          > 64K      |-----------------------|                       |
;**                     |        ...            |         |             |
;**    highest  |       |-----------------------|         |             |
;**    addr in  |       |     c-scan n-1        |        ---            |
;**    memory  ---       -----------------------                       ---
;**                  (n-1,0)                (n-1,j-1)
;**
;**
;**   If the bitmap requires less than 64K of memory, only the last
;**   segment pictured is relevant.
;**
;**
;** The same values computed for bitmaps can be applied to the video
;** adapter.  The values computed for the display treat it as if it
;** were a monochrome device, with special plane selection logic to
;** get between planes (we pretend to repeat the operation four times).
;**
;*/

;/*
;** The surface structure definition (sd_)
;**
;** The surface structure contains characteristics of the writing surface.
;** It is part of all memory bitmaps and device contexts.  It contains
;** the following information:
;**
;**
;** sd_usId         This field contains the identifier for the surface.
;**                 It will be SURFACE_IDENT.  It must be the first field
;**                 of the surface structure so that bitblt can do error
;**                 checking on the second hddc/hbm.
;**
;** sd_npsd         Pointer to the surface.  In a surface definition this
;**                 field points backwards to the sd_usId field (this
;**                 generally is of no use, but read on).  The equivalent
;**                 field in a ddc will point to the start of the real
;**                 surface definition.  This allows bitblt to use either
;**                 a bitmap or ddc as the source, dereferencing the same
;**                 offset to get to the real surface information.
;**
;**                    ddc              screen             bitmap
;**                  -------            -------            -------
;**                 |sd_usId|     ---> |sd_usId| <-       |sd_usId| <-
;**                  -------     |      -------    |       -------    |
;**                 |sd_npsd| ---      |sd_npsd| --       |sd_npsd| --
;**                  -------            -------            -------
;**
;** sd_fb           Flags as defined later
;**
;** sd_fbAccel      Flags as defined later
;**
;** sd_cx           This is the width of the surface in pels.
;**
;** sd_cy           This is the height of the surface in scans
;**
;** sd_cbScan       This is the width of a scan line in bytes.  It will
;**                 always be a multiple of four for a memory bitmap.
;**                 For the physical display, it will be the width of the
;**                 display in bytes.
;**
;**                 This number can be used to get to the next plane of a
;**                 scanline.
;**
;** sd_dScan        This is the index to the next scan of a plane in a color
;**                 bitmap (BITS_PEL * sd_cbScan).  For monochrome
;**                 bitmaps and the display, it will be 0.
;**
;** sd_cbFill       Number of unused bytes at the end of a 64K segment of
;**                 a huge bitmap.    This is used in computing if overflow
;**                 has occured into another segment of the bitmap.  This
;**                 field is valid if SD_HUGE is set in sd_fb.
;**
;** OR
;**
;** sd_pbmi         The far pointer to the caller-supplied bitmap info structure
;**                 describing the bits pointed by sd_pBits (see below) if it
;**                 is also caller-supplied.
;**
;*******************************************************************************
;** Warning:        The sd_dScan and sd_cbFill fields overlay the sd_pbmi field
;** ========        if sd_pBits actually points to the bits of the surface.
;*******************************************************************************
;**
;** sd_cySeg        Number of scanlines which fit within a 64K segment of
;**                 memory.
;**
;** sd_selIncr      For huge bitmaps, the sd_pBits field contains the 1st selector
;**                 and an increment is added to that to get to the 2nd selector.
;**                 The increment value is either 10h for the physical display
;**                 or DOSHUGEINCR for memory bitmaps.  This field contains
;**                 the appropriate increment value.
;**
;** OR
;**
;** sd_pClrTab      The far pointer to the color mapping table
;**                 if the pBits points to a caller-supplied bitmap
;**
;*******************************************************************************
;** Warning:        The sd_cySeg and sd_selIncr fields overlay the sd_pClrTab field
;** ========        if sd_pBits actually points to the bits of the surface.
;*******************************************************************************
;**
;** sd_pBits        This is the far pointer to the bits of the surface.
;**                 Scan sd_cy-1 is at this address (see picture above).
;**
;**                 Will be INVALID_ADDRESS if a bitmap surface is NULL (a width
;**                 or height of 0), if the ddc is for an information context
;**                 context, or the device doesn't require a selector.
;**
;** Flag values for sd_fb:
;**
;** SD_DEVICE       1 The surface is the physical display
;**                 0 ddc surface is a memory bitmap
;**
;** SD_COLOR        1 The surface is color
;**                 0 The surface is monochrome
;**
;** SD_HUGE         1 The surface is     a huge bitmap
;**                 0 The surface is not a huge bitmap
;**
;** SD_NONNULL      1 The surface is present.  This will be the case for
;**                   any normal display ddc, and for non-null bitmaps.
;**                 0 No surface present.  This will be the case for
;**                   null bitmaps (width or height of 0), and when the
;**                   ddc created was for an Information Context.
;*/

SURFACE       STRUCT  4
   sd_usId    DWORD  SURFACE_IDENT
   sd_npsd    DWORD  sdScreen

   sd_fb      BYTE   SCREEN_SDFB
   sd_fbAccel BYTE   0
   sd_cx      DWORD  SCREEN_CX
   sd_cy      DWORD  SCREEN_CY
   sd_cbScan  DWORD  SCREEN_CBSCAN
   sd_dScan   DWORD  SCREEN_DSCAN
   sd_cbFill  DWORD  0
   sd_cySeg   DWORD  0
   sd_selIncr DWORD  010h
   sd_pBits   DWORD  INVALID_ADDRESS ;WAS init'd WORD 0,INVALID_SEL
SURFACE       ENDS

PSURFACE TYPEDEF PTR SURFACE

sd_pbmi     TEXTEQU <sd_dScan>  ;DWORD field overlays sd_dScan&sd_cbFill
sd_pClrTab  TEXTEQU <sd_cySeg>  ;DWORD field overlays sd_cySeg&sd_selIncr

         .ERRNZ   (sizeof SURFACE) and 1

SD_DEVICE   EQU   10000000b ;sd_fb
SD_COLOR    EQU   01000000b
SD_HUGE     EQU   00100000b
SD_HEAPBITS EQU   00010000b
SD_NONNULL  EQU   00000001b


;/*
;** Bitmap Structure Definition (bm_)
;**
;** bm_sd  Surface definition as defined above
;**
;** bm_hddc         Handle of the hddc this bitmap is currently selected
;**                 into.  If the bitmap isn't selected into an hddc, this
;**                 field will be NULL.  This field will have to change
;**                 whenever a SaveDC/RestoreDC is performed if the
;**                 hddc changes.
;**
;**                 Should be NULL whenever bm_cSelect is zero.
;**
;** bm_cSelect      Number of times this bitmap is selected into a DC.
;**                 A bitmap can be selected into multiple levels of a
;**                 saved DC.  This count keeps us from considering the
;**                 bitmap free if a ddc was saved and another bitmap
;**                 selected into it.
;**
;*/

BITMAP         STRUCT 4
   bm_sd      SURFACE <>
   bm_hddc    DWORD   ? ; this is a pddc
   bm_cSelect DWORD   ?
BITMAP         ENDS

PBITMAP TYPEDEF PTR BITMAP

;/*
;** basic attributes structure (ba_)
;**
;** I wanted to call this the basica structure!  The basic attributes are
;** those attributes common to the five bundles (markers, lines, patterns,
;** characters, and image data).      The following fields are contained in
;** the structure:
;**
;** ba_clr          This is the foreground color as specified by the caller.
;**                 It is stored as passed in so that we can rerealize as
;**                 color table attributes change.      This value will always
;**                 be used for color mapping unless BA_CLR_DEF is set, in
;**                 which case the default color should be used.
;**
;** ba_clrBack      This is the background color as specified by the caller.
;**                 It is stored as passed in so that we can rerealize as
;**                 color table attributes change.      This value will always
;**                 be used for color mapping unless BA_CLR_BACK_DEF is set,
;**                 in which case the default color should be used.
;**
;** ba_ipc          This is the internal physical color representation of
;**                 ba_clr.  All drawing primitives will reference this value
;**                 instead of ba_clr.
;**
;** ba_ipcBack      This is the internal physical color representation of
;**                 ba_clrBack.  All drawing primimitives will reference
;**                 this value instead of ba_clrBack.
;**
;** ba_bmix         This is the foreground mix mode.  Mix modes will be
;**                 mapped into ranges appropriate for each of the attribute
;**                 bundles (e.g. text will have the passed mix mode mapped
;**                 into a range of 0:2 (assuming it supports overwrite, XOR,
;**                 and OR).
;**
;** ba_bkmix        This is the background mix mode.  Mix modes will be
;**                 mapped into ranges appropriate for each of the attribute
;**                 bundles (e.g. text will have the passed mix mode mapped
;**                 into a range of 0:2 (assuming it supports overwrite, XOR,
;**                 and OR).
;**
;** ba_fb  Flags as defined later.
;**
;**
;** Flag values for ba_fb:
;**
;** BA_CLR_INV               1 if ba_ipc is not the correct representation
;**                            of ba_clr.
;**                          0 if ba_ipc is the correct representation of
;**                            ba_clr.
;**
;** BA_CLR_BACK_INV          1 if ba_ipcBack is not the correct representation
;**                            of ba_clrback.
;**                          0 if ba_ipcBack is the correct representation of
;**                            ba_clrback.
;**
;** BA_CLR_DEF               1 if the default color should be used instead of
;**                            ba_ipc
;**                          0 if ba_ipc is to be used
;**
;** BA_CLR_BACK_DEF          1 if the default color should be used instead of
;**                            ba_ipc_back
;**                          0 if ba_ipc_back is to be used
;**
;** BA_XFORM_CHANGE          1 if a transform change has occured since the
;**                            last time this flag was cleared.
;**                          0 if no transform change has occured since
;**                            the last time this flag was cleared
;**
;** BA_REREALIZE             1 if for some reason the attribute must be
;**                            realized.
;**                          0 if the attribute is valid.
;**
;**                          This bit is included for optimizing performance.
;**                          Only this bit must be tested in the drawing
;**                          routines to see if some rerealization of the
;**                          attributes must be performed.
;**
;*/

BASIC_ATTRS       STRUCT 4
   ba_clr         DWORD  DEF_LOG_FORE_CLR
   ba_clrBack     DWORD  DEF_LOG_BACK_CLR
   ba_ipc         IPC    <DEF_IPC_FORE_CLR>
   ba_ipcBack     IPC    <DEF_IPC_BACK_CLR>
   ba_bReserved BYTE   0
   ba_fb BYTE   DEF_FB_IMAGE
   ba_bmix        BYTE   DEF_FMIX_IMAGE
   ba_bkmix       BYTE   DEF_BMIX_IMAGE
BASIC_ATTRS       ENDS

         .ERRNZ   (sizeof BASIC_ATTRS) and 3

BA_CLR_INVALID          EQU 10000000b ;ba_fb
BA_CLR_BACK_INV         EQU 01000000b
BA_CLR_DEF              EQU 00100000b
BA_CLR_BACK_DEF         EQU 00010000b
BA_XFORM_CHANGE         EQU 00001000b
BA_REREALIZE            EQU 00000100b
BA_IS_OPAQUE            EQU 00000001b
BA_IS_XPARENT           EQU 00000000b

;/*
;** image_attributes (ia_)
;**
;** ia_ba  Basic attributes as defined above.
;**
;*/

IMAGE_ATTRS STRUCT 4
   ia_ba    BASIC_ATTRS <>      ; init to standard basic attrs
IMAGE_ATTRS ENDS

         .ERRNZ   (sizeof IMAGE_ATTRS) and 3

IA_DSA_SAVE_LIM EQU sizeof IMAGE_ATTRS ;Setting attributes error recovery


;/*
;** About brushes (patterns)
;**
;** A brush contains whatever information is required to represent the
;** current fill attributes.  There are two distinct parts of the brush:
;** the color portion for color surfaces, and the mono portion for
;** monochrome surfaces.     Each brush is stored ready for use in opaque
;** mode (that is, the background color has already been placed into the
;** bits to be used for the brush).
;**
;** Brushes can come from many sources.  Monochrome sources which can
;** be used as patterns are codepoints within a font, base patterns,
;** and monochrome bitmaps.  For fonts and bitmaps, only the first
;** 8x8 bits are used.  !!! Be sure and get lower left 8 pels !!!!
;**
;** When a brush comes from a monochrome source, the color portion of the
;** brush is created from the foreground and background colors.  All pels
;** of the brush which are 1 are converted to the foreground color.  All
;** pels which are 0 are converted to the background color.  The brush
;** colors will change as the current foreground/background colors change.
;** For monochrome sources, the monochrome portion of the brush will also
;** track the foreground/background colors as they change.
;**
;** The original monochrome source will be saved for use as a transparency
;** mask.  When the background mode is set to transparent, only those pels
;** of the brush which have a corresponding 1 bit in the transparency mask
;** will be processed in the current foreground mix mode.  When the back-
;** ground mode is opaque, pels of the brush which have a corresponding 1
;** bit in the transparency mask will be drawn using the foreground mix.
;** The other pels will be written in the background color. !!! we don't
;** do it this way but that is the way the definition seems to be.!!!
;**
;** Color brushes can only come from one of our color bitmaps.  When a
;** color bitmap is the source of a brush, the color portion of the brush
;** doesn't track the foreground/background colors; the colors remain the
;** same.  The transparency mask is generated from the color brush.  All
;** pels of the color brush which match the background color will have
;** their corresponding transparency mask bit set to 0.  All other bits
;** in the transparency mask will be set to 1.  The transparency mask
;** will track the current foreground/background colors.
;**
;** Once the transparency mask has been generated from the color source,
;** the monochrome portion of the brush will be generated in the same
;** manner as for monochrome sources; 1 bits in the transparency mask
;** will be mapped to the foreground color and 0 bits will be mapped to
;** the background color.
;**
;** It can be argued that there should be certain brushes which don't
;** have any "background bits" (e.g. dithered brushes).  There is no
;** problem with bitblt since none of its rops handle transparency.
;** !!! which causes problems with image data !!!
;** There could be problems with polygon filling - there is no way to
;** turn off background filling.      If in transparent mode, some bits may
;** not show, while in opaque mode they don't have the raster-op applied
;** to them.  This indicates that there is a need for a class of "solid"
;** patterns so we don't try to synthesize a transparency mask.
;*/

;/*
;**
;** pattern_attributes (pa_)
;**
;** pa_ba           Basic attributes as defined above.
;**
;** pa_pFont        Pointer to a font to use for patterns or a handle to
;**                 the bitmap to use, as defined by the PA_BITMAP_SRC flag.
;**
;** pa_fs           Flags as defined for ca_fs.  Use of these flags allows
;**                 us to use the character bundle code for getting the
;**                 font
;**
;** pa_paus         Pointer to the code-point mapping array.  Used to map
;**                 850 fonts into other fonts.
;**
;** pa_ch           Code point to use for the pattern definition.
;**
;** pa_fb           Flags for the pattern as defined below.
;**
;** pa_ptlOrg       Origin for the pattern in WORLD coordinates.
;**
;** pa_ptsOrg       Origin for the pattern in DEVICE coordinates.
;**
;** pa_cRcr         Current right rotation of the pattern.
;**
;**                 The brush is rotated in X by the sum of the DC origin
;**                 and the transformed pa_ptlOrg.      Y rotation never occurs.
;**                 Y rotation is performed by adding the contents of
;**                 pa_ptsOrg.pts_y to the Y coordinate, then taking this
;**                 mod 8 for the pattern scan to use.
;**
;** pa_cxFill       The number of bits at the right and top, respectively,
;** pa_cyFill       of the color brush to fill with the background color.
;**                 These allow a program to select a color bitmap of arbitrary
;**                 size into the pattern bundle, by telling the brush
;**                 realization code which bits to change when the background
;**                 color changes.
;**
;** pa_idBrush      Reference count for this brush.
;**
;** pa_ipcFore      Current ipc of foreground bits in pa_abColor, pa_abMono.
;** pa_ipcBack      Current ipc of foreground bits in pa_abColor, pa_abMono.
;**
;**                 These two colors are part of the brush caching scheme.
;**                 If the new colors that the brush is to be created in
;**                 match these colors, then we don't have to rerealize the
;**                 bits which would force any hardware brush cache to be
;**                 invalidated.
;**
;** pa_abColor      The actual bits making up the brush for color surface.
;**
;** pa_abMono       The actual bits making up the brush for a mono surface.
;**
;** pa_abMask       The bits making up the transparency mask
;**
;** Flag values for pa_fb:
;**
;** PA_COLOR_TRUTH  1 if the color portion of the pattern was the
;**                   original pattern.  The monochrome portion of
;**                   the pattern must be synthesized from the color
;**                   portion of the pattern using the current
;**                   pattern foreground/background colors.
;**                 0 if the monochrome portion of the pattern was
;**                   the original pattern (as is the case when
;**                   fonts are used for filling).      The color
;**                   portion of the pattern must be synthesized from
;**                   the mono pattern using the current foreground
;**                   and background colors.
;**
;** PA_BITMAP_SRC   1 if the source came from a bitmap.
;**                 0 if the source came from a font.
;**
;** PA_SINGLE_CLR   1 if the brush consists of all 1 or all 0 in
;**                   each of its planes
;**                 0 if the brush is arbitrary
;**
;** PA_GRAY         1 if a gray brush (any given bit is the same
;**                   in all planes).
;**                 0 if the brush is arbitrary
;**
;** PA_HOLLOW       1 if the code point comes from the base symbol
;**                   set and is PATSYM_BLANK or PATSYM_NOSHADING
;**                 0 if the code point comes from a use symbol set,
;**                   or isn't PATSYM_BLANK or PATSYM_NOSHADING.
;*/

SIZE_PATTERN      EQU      8                 ;Patterns are 8 bits by 8 bytes


PATTERN_ATTRS     STRUCT 4
pa_ba             BASIC_ATTRS <DEF_LOG_FORE_CLR,DEF_LOG_BACK_CLR,<DEF_IPC_FORE_CLR>,<DEF_IPC_BACK_CLR>,0,DEF_FB_PATTERN,DEF_FMIX_PATTERN,DEF_BMIX_PATTERN>
pa_pFont DWORD  INVALID_ADDRESS
pa_paus  DWORD  INVALID_ADDRESS
pa_fs             DWORD  DEF_PATTERN_FS_FLAGS
pa_ch             BYTE   DEF_PATTERN_CODE_POINT
pa_fb             BYTE   DEF_PATTERN_FB_FLAGS
pa_ptlOrg         POINTL <0,0>
pa_ptsOrg         POINTL <0,0>
pa_cRcr           BYTE   0
pa_cxFill         BYTE   0
pa_cyFill         BYTE   0
                  BYTE   0
pa_idBrush        DWORD  PAT_CACHE_FIRST_ID
pa_ipcFore        IPC    <DEF_IPC_FORE_CLR>
pa_ipcBack        IPC    <DEF_IPC_BACK_CLR>
;pa_abColor        BYTE   (BITS_PEL * SIZE_PATTERN) dup (0)
pa_abColor        DWORD  INVALID_ADDRESS
pa_abMono         BYTE   SIZE_PATTERN dup (0)
pa_abMask         BYTE   SIZE_PATTERN dup (0FFh)
PATTERN_ATTRS     ENDS
         .ERRNZ   (sizeof PATTERN_ATTRS) and 3

IFNDEF DBCS        ;IBMJ
PA_DSA_SAVE_LIM EQU       ( sizeof PATTERN_ATTRS ) - (sizeof DWORD) - \
                                ( SIZE_PATTERN * 2 )   ;For SetAttrs error recovery
ELSE ;DBCS  ; DBCS codepage / DBCS device font support   ;IBMJ
PA_DSA_SAVE_LIM EQU       ( sizeof PATTERN_ATTRS ) - (sizeof DWORD) - \
                                ( SIZE_PATTERN * 2 ) + 12  ;For SetAttrs error recovery
ENDIF;DBCS        ;IBMJ


PA_SINGLE_CLR     EQU      10000000b         ;pa_fb
PA_GRAY  EQU      01000000b
PA_HOLLOW         EQU      00100000b
PA_COLOR_TRUTH    EQU      00010000b
PA_BITMAP_SRC     EQU      00001000b



;/*
;**
;** character_attributes (ca_)
;**
;** ca_ba           Basic attributes as defined above.
;**
;** ca_pFont        Pointer to the font to use.
;**
;** ca_fs           Flags as defined below.
;**
;** ca_paus         Pointer to the code-point mapping array.  Used to map
;**                 850 fonts into other fonts.
;**
;** ca_idCodePage   Current code page.  Affects tonly the default font
;**
;** ca_usTextAlign  Text alignment attribute from dc.
;**
;** ca_fxExtra      Character extra in fixed WORLD coordinates.
;**
;** ca_fxBreakExtra Character break extra in fixed WORLD coordinates.
;**
;**
;** Flag values for ca_fs.  Note that these flags are also used for
;** markers and patterns where appropriate:
;**
;** CA_USER_FONT             1 if user supplied font is in use
;**                          0 if default font is in use
;**
;** CA_VECTOR                1 if current font is vector or outline
;**                          0 if current font is a raster font
;**
;** CA_PREC_NOT_1            1 if precision is 2 or 3
;**                          0 if precision is 1
;**
;** CA_CHANGED               1 if the font or font attributes have changed
;**                          0 if the font or font attributes have not changed
;**
;**                          For markers and patterns, this bit will also
;**                          be set when the code point changes.
;**
;** CA_MUST_MAP              1 if the characters are to be mapped via the
;**                            code-page mapping array ca_paus
;**                          0 if no mapping is required
;**
;** CA_CHAR_EXTRA            1 if ca_cExtraPels contains the count of extra
;**                            pels needed per character
;**                          0 if no extra pels per character are needed
;**
;** CA_ABC_SPACE             1 if the font is an ABC spaced font.
;**                          0 if the font is proportional or fixed pitch.
;**
;**                          This flag takes precedence over CA_FIXED_PITCH
;**                          and CA_WIDTH_IS_8.
;**
;** CA_FIXED_PITCH           1 if the font is a fixed pitch font.
;**                          0 if the font is proportional.
;**
;** CA_WIDTH_IS_8            1 if the font is 8 pels wide.  Only valid if
;**                            CA_FIXED_PITCH is set.
;**                          0 if the font isn't 8 pels wide.
;**
;** CA_STRIKEOUT             Text simulation flag
;** CA_UNDERSCORE            Text simulation flag
;** CA_ITALIC                Text simulation flag
;** CA_BOLD                  Text simulation flag
;**
;** CA_DIRECTION             xx direction as specified by CHDIRN_*, -1
;*/

IFDEF DBCS  ; DBCS codepage / DBCS device font support   ;IBMJ

;-----------------------------------------------------------------------;
; ca_lCodePage Logical code page, which is associated to current font.
;
; ca_fsNls denotes the string parsing rule for current font.
;
; NLSCA_SBCS  Use SBCS parsing rule
; NLSCA_MBCS  Use MBCS parsing rule
; NLSCA_DBCS  Use DBCS parsing rule
;
; NLSCA_CONCAT  Parsing option. The parser will check the string
;   last byte is DBCS leading byte or not. If it is,
;   the parser returns with this bit kept on.
;   In this case, the last byte is left unprocessed.
;
; NLSCA_MAP_SBCS SBCS mapping vector available (= CA_MUST_MAP)
; NLSCA_MAP_DBCS DBCS mapping vector available
;
; ca_fsFont denotes the current font characteristics.
;
; NLSCA_FONT_SBCS font is SBCS font
; NLSCA_FONT_DBCS font is DBCS font
; NLSCA_FONT_MBCS font is MBCS font
; NLSCA_FONT_DBCS_USED DBCS portion of font is used
; NLSCA_FONT_CACHED cached fontseg (SBCS characters aren't resident)
; NLSCA_FONT_HUGE less than 256 characrters in fontseg at once
;
; ca_cCache Max number of characters which can be cached in fontseg
;  at once. Valid only when both flag of NLSCA_FONT_CACHED
;  and NLSCA_FONT_HUGE is specified.
;-----------------------------------------------------------------------;

NLSCA_SBCS EQU 0001h  ;ca_fsNls
NLSCA_DBCS EQU 0002h
NLSCA_MBCS EQU 0004h
NLSCA_CONCAT EQU 0008h
;  EQU 0010h
;  EQU 0020h
NLSCA_MAP_SBCS EQU 0040h
NLSCA_MAP_DBCS EQU 0080h

NLSCA_FONT_SBCS EQU 0001h  ;ca_fsFont
NLSCA_FONT_DBCS EQU 0002h
NLSCA_FONT_MBCS EQU 0004h
NLSCA_FONT_DBCS_USED EQU 0008h
;  EQU 0010h
;  EQU 0020h
NLSCA_FONT_CACHED EQU 0040h
NLSCA_FONT_HUGE EQU 0080h

CB_SBCS_MAP_TBL EQU 512
CB_DBCS_MAP_TBL EQU 256

CpMapTable STRUCT  ;ca_paus
cmt_CharToGlyph BYTE CB_SBCS_MAP_TBL dup (?) ; code-point to glyph-index
cmt_DBCSLeading BYTE CB_DBCS_MAP_TBL dup (?)
     ; code-point to DBCS leading byte
CpMapTable ENDS

ENDIF;DBCS        ;IBMJ

CHAR_ATTRS           STRUCT 4
   ca_ba    BASIC_ATTRS <DEF_LOG_FORE_CLR,DEF_LOG_BACK_CLR,<DEF_IPC_FORE_CLR>,<DEF_IPC_BACK_CLR>,0,DEF_FB_CHAR,DEF_FMIX_CHAR,DEF_BMIX_CHAR>
   ca_pFont        DWORD  INVALID_ADDRESS
   ca_paus         DWORD  INVALID_ADDRESS
   ca_fs           DWORD  DEF_FONT_FS_FLAGS
   ca_cExtraPels   DWORD  0
   ca_idCodePage   DWORD  DEFAULTVIOCODEPAGE
IFDEF DBCS  ; DBCS codepage / DBCS device font support   ;IBMJ
   ca_lCodePage    DWORD  DEFAULTVIOCODEPAGE
   ca_fsNls        DWORD  NLSCA_SBCS
   ca_fsFont       DWORD  NLSCA_FONT_SBCS
   ca_cCache       DWORD  0
ENDIF;DBCS        ;IBMJ
   ca_usTextAlign  DWORD  101h
   ca_fxExtra      DWORD  0
   ca_fxBreakExtra DWORD  0
CHAR_ATTRS           ENDS

         .ERRNZ   (sizeof CHAR_ATTRS) and 3

CA_DSA_SAVE_LIM EQU size CHAR_ATTRS

CA_USER_FONT      EQU 8000h                  ;ca_fs
CA_VECTOR         EQU 4000h
CA_PREC_NOT_1     EQU 2000h
CA_CHANGED        EQU 0800h
CA_MUST_MAP       EQU 0400h
CA_CHAR_EXTRA     EQU 0200h
CA_ABC_SPACE      EQU 0100h
CA_FIXED_PITCH    EQU 0080h
CA_WIDTH_IS_8     EQU 0040h
CA_STRIKEOUT      EQU 0020h
CA_UNDERSCORE     EQU 0010h
CA_ITALIC         EQU 0008h
CA_BOLD           EQU 0004h
CA_DIRECTION      EQU 0003h                  ;Note 00000011b

;/*
;** these will be defined somday in pmddi.  until then, define them
;** here.  They are passed to the driver in cdef_fFlags
;*/

CDEF_BOLD         EQU 0002h                  ; !!! move these to pmddi.h
CDEF_ITALIC       EQU 0004h                  ; when the dcr goes through.
CDEF_UNDERSCORE   EQU 0008h           ; don't forget to modify
CDEF_STRIKEOUT    EQU 0010h                  ; winstr,major16,major09

;/*
;**
;** marker_attributes (ma_)
;**
;** Markers are implemented using the character routines.  The marker
;** structure must contain enough information that it can be passed to
;** the character functions as if a normal character output operation
;** is to be performed.
;**
;** ma_ba           Basic attributes as defined above.
;**
;** ma_pFont        Pointer to the font to use.
;**
;** ma_fs           Flags as defined for ca_fs.  Use of these flags allow
;**                 us to skip many of the character attribute fields.
;**                 when using the character routine to draw the markers.
;**
;** ma_paus         Pointer to the code-point mapping array.  Used to map
;**                 850 fonts into other fonts.
;**
;** ma_ch           Code point to use for the marker
;**
;** ma_fb           Flags as defined below.
;**
;** Flag values for ma_fb:
;*/

MARKER_ATTRS STRUCT 4
   ma_ba     BASIC_ATTRS <DEF_LOG_FORE_CLR,DEF_LOG_BACK_CLR,<DEF_IPC_FORE_CLR>,<DEF_IPC_BACK_CLR>,0,DEF_FB_MARKER,DEF_FMIX_MARKER,DEF_BMIX_MARKER>
   ma_pFont  DWORD  INVALID_ADDRESS
   ma_paus   DWORD  INVALID_ADDRESS
   ma_fs     DWORD  DEF_MARKER_FS_FLAGS
   ma_ch     BYTE   DEF_MARKER_CODE_POINT
   ma_fb     BYTE   DEF_MARKER_FB_FLAGS
   ma_pad    WORD   ?
MARKER_ATTRS ENDS

         .ERRNZ   (sizeof MARKER_ATTRS) and 3

MA_DSA_SAVE_LIM EQU size MARKER_ATTRS



;/*
;**
;** line_attributes (la_)
;**
;** la_ba           Basic attributes as defined above.
;**
;** la_usType       Line style type.  Will be zero based.  API calls
;**                 are 1 based.
;**
;** la_bError       The line style error term.
;**
;** la_bMask        The line style mask position.
;**
;** la_bStepX       The style step in the x direction.
;**
;** la_bStepY       The style step in the y direction.
;**
;** la_sWidth       The line width
;**
;*/

LINE_ATTRS   STRUCT 4
   la_ba     BASIC_ATTRS <DEF_LOG_FORE_CLR,DEF_LOG_BACK_CLR,<DEF_IPC_FORE_CLR>,<DEF_IPC_BACK_CLR>,0,DEF_FB_LINE,DEF_FMIX_LINE,DEF_BMIX_LINE>
   la_usType DWORD  DEF_LINE_TYPE
   la_bError BYTE   DEF_LINE_ERROR
   la_bMask  BYTE   DEF_LINE_MASK
   la_bStepX BYTE   DEF_LINE_STEP_X
   la_bStepY BYTE   DEF_LINE_STEP_Y
   la_sWidth DWORD  LINEWIDTH_DEFAULT
LINE_ATTRS   ENDS

         .ERRNZ   (sizeof LINE_ATTRS) and 3

LA_DSA_SAVE_LIM EQU size LINE_ATTRS

;/*
;** ddc - device's device context (or state block)
;**
;** The following field are "above the line" in that RestoreDC/ResetDC
;** will not alter them.
;**
;** ddc_usId                 Identifier of a ddc.  Must be DDC_IDENT.
;**
;** ddc_npsd                 Near pointer to the surface definition.  This is
;**                          also the driver's handle to the bitmap currently
;**                          selected into this ddc if it is a memory ddc.
;**                          It will be INVALID_ADDRESS when no bitmap is
;**                          selected into a memory ddc.
;**
;** ddc_hdc                  The Engine's handle to this ddc as passed to
;**                          the Enable function.  Must match the hdc passed
;**                          as a parameter to the current function.
;**
;** ddc_ptsOrg               DC origin.  All DEVICE coordinates are offset
;**                          by this amount to get SCREEN coordinates.  All
;**                          SCREEN coordinates stored in the ddc must be
;**                          adjusted by the delta of the old and new DC
;**                          origin when it changes.
;**
;** ddc_crcsClip             The number of rectangles in the visible region
;**                          for this ddc.  If this number is 0, then nothing
;**                          is visible for this DDC.
;**
;** ddc_arcsClip             An array of clipping rectangles used to cache
;**                          small clipping regions.  If ddc_crcsClip is
;**                          less than NUM_CLIP_RECTS, then all rectangles
;**                          are contained here and no calls to the Engine
;**                          are required.
;**
;** ddc_fb                   Flags as defined later.
;**
;** ddc_fbAbove              Flags as defined later.
;**
;** The following field are "below the line" in that RestoreDC/ResetDC
;** will alter them.
;**
;** ddc_ia                   Image attributes as defined above
;**
;** ddc_pa                   Pattern attributes as defined above
;**
;** ddc_la                   Line attributes as defined above
;**
;** ddc_ca                   Character attributes as defined above
;**
;** ddc_ma                   Marker attributes as defined above
;**
;** ddc_fbBelow              Flags as defined later.
;**
;** ddc_fbClrTbl             Flags as defined later.
;**
;** ddc_iSysClr              Index of current system colors.  Incremented
;**                          each time a system color is changed.
;**
;** ddc_ptlWorldPos          Current position in WORLD coordinates.       Will
;**                          always be valid.
;**
;** ddc_ptsCurPos            Current position in SCREEN coordinates.  Will
;**                          always be valid.
;**
;** ddc_npddcPrev            Pointer to a previously saved version of the ddc.
;**                          Will be INVALID_ADDRESS if no previous version of
;**                          the ddc exists.
;**
;** ddc_cLevel               The ddc save level.  The first level is 1.
;**
;** ddc_pClrTbl              Address of the color table to use for mapping
;**                          API colors to internal physical colors (IPCs).
;**                          NOTE: This pointer is ALWAYS valid.  It points
;**                          to either a user's color table, if one is selected,
;**                          or the default table.  It points to the default
;**                          table even when we are in RGB mode.
;**
;** ddc_rcsGpiBound          Rectangle for GPI bounds accumulation. It is
;**                          accumulated in SCREEN coordinates when the
;**                          COM_BOUNDS command is set.
;**
;** ddc_rcsUsrBound          Rectangle for Window manager bounds accumulation.
;**                          Accumulated in SCREEN coordinates when the
;**                          COM_ALT_BOUNDS command is set.
;**
;** ddc_rclPick              Pick (correlation) rectangle in PAGE coordinates.
;**                          Only display drivers deal with correlation, so
;**                          this rectangle MUST be maintained by the driver
;**                          in PAGE coordinates so that it can be returned
;**                          without any round-off error.  The engine will not
;**                          keep a copy of this rectangle.
;**
;** ddc_rcsCorr              Correlation rectangle in DEVICE coordinates.
;**                          This form of the correlation rectangle is used by
;**                          the actual drawing primitives.      Correlation must
;**                          be performed against primitives clipped to the
;**                          actual visible region.     This will require the
;**                          lowest level routines to perform the correlation
;**                          (since they get each rectangle which is visible).
;**
;** ddc_npdevpal             Pointer to palette associated with ddc.
;**                          (will point to the default palette if none created)
;**
;** ddc_FontsLoaded          Pointer to font loaded in memory
;**
;** ddc_MapFontsLoaded       Pointer to the codepage mapping for font loaded.
;**
;** Flag values for ddc_fb:
;**
;** DDC_DEVICE               1 The surface is the physical display
;**                          0 ddc surface is a memory bitmap
;**
;**                            This bit will match the bit in the attached
;**                            surface definition.
;**
;** DDC_VISIBLE              1 if some portion of the writing surface is
;**                            visible.
;**                          0 if no portion of the writing surface is
;**                            visible.
;**
;**                            This flag is a combination of the DDC_PRESENT
;**                            flag, the SD_NONNULL flag, and the number of
;**                            rectangles in the current visible clip region.
;**
;**                            When there is a valid writing surface and some
;**                            part of the surface is visible, this flag will
;**                            be set.  It can then be used as a test mask
;**                            against the COM_DRAW bit to see drawing must
;**                            occur.
;**
;** DDC_CLIP_NOTIFY          1 NotifyClipChange has been received.
;**                          0 NotifyClipChange has not been received.
;**
;**                            This flag is cleared whenever a surface is
;**                            selected into a ddc, or on a CreateDC call.
;**                            This will be used for a FIREWALL which makes
;**                            sure that there is a clipping region selected
;**                            into the ddc.
;**
;** DDC_IDENT_XFORM          1 No transforming is needed.  Only translation by
;**                            the DC origin is needed.
;**                          0 Arbitrary transformation needed.
;**
;** DDC_CORR_INV             1 rcsCorr is invalid due to transform or DC origin
;**                            change.  Must transform rclPick to get new rcsCorr
;**                          0 rcsCorr is correct.
;**
;** DDC_SSB_CALL             1 SSB calling bitblt.  Allow blting from off-
;**                            screen memory.
;**                          0 Arbitrary call.  Clip to ddc_sd.sd_cy.
;**
;** DDC_PRESENT              1 if a   writing surface is selected into the ddc.
;**                          0 if no writing surface is selected into the ddc.
;**
;**                            For device DCs and ICs, this flag will always
;**                            be 1.  For memory bitmaps, this flag will be
;**                            1 whenever a bitmap is selected into the ddc,
;**                            and 0 whenever no bitmap is selected (it will
;**                            mirror the state of ddc_npsd).
;**
;**                            Any output call made while this bit is 0 will
;**                            be an error.
;**
;** DDC_FIRST_PEL            1 A SetCurrentPosition was the last "drawing"
;**                            function called.
;**                          0 Any line primitive call resets this flag.
;**
;**                            This flag is used to determine whether the first
;**                            pel of a fillet or line is to be drawn.  Only for
;**                            the first drawing primitive after a
;**                            SetCurrentPosition is the first pel drawn.
;**
;**
;** Flag values for ddc_fbAbove:
;**
;** DDC_INFO_DC              1 This is an info context
;**                          0 Normal DC
;**
;** DDC_DIRTY_VISRGN         1 The vis region has changed and pmwin should be
;**                              called to update it before using the ddc.
;**                          0 The vis region is correct.
;**
;** Flag values for ddc_fbClrTbl:
;**
;** DDC_REALIZED             1 RealizeColorTable in effect
;**                          0 Default palette/DACs in effect
;**
;** DDC_REALIZABLE           1 Logical color table may be realized
;**                          0 Logical color table may not be realized
;**
;** DDC_CLR_0_USERS          1 Color 0 in logical color table defined by user
;**                          0 Color 0 in logical color table is the default
;**
;** DDC_CLR_7_USERS          1 Color 7 in logical color table defined by user
;**                          0 Color 7 in logical color table is the default
;**
;** DDC_RGB_MODE             1 The ddc is in RGB mode
;**                          0 The ddc is in color table mode
;**
;** DDC_LOG_CLR_TBL          1 A user-defined color table has been selected
;**                          0 The default color table is in use
;**
;** DDC_DITHER               1 Dithering allowed for fill patterns
;**                          0 Dithering is not allowed for fill patterns
;**
;**     NOTE:  DDC_RGB_MODE and DDC_LOG_CLR_TBL are mutually exclusive.
;**
;**
;** Flag values for ddc_fbBelow:
;**
;** DDC_DIRTY_ATTRS          1 Attribute have changed which will require extra
;**                            copying in ResetDC.
;**                          0 No attributes have changed.
;**
;** DDC_PALETTE              1 The field ddc_npdevpal points to a custom palette.
;**                          0 The field ddc_npdevpal points to a default palette.
;**
;*/

EXTERNDEF SCREEN_CX                    :ABS
EXTERNDEF SCREEN_CY                    :ABS

DDC                STRUCT 4
   ddc_usId        DWORD DDC_IDENT
   ddc_npsd        DWORD sdScreen
   ddc_hdc         DWORD INVALID_ADDRESS
   ddc_crcsClip    DWORD 1
   ddc_fb          BYTE  DDC_PRESENT+DDC_DEVICE+DDC_UNIT_XFORM+DDC_VISIBLE+DDC_CLIP_NOTIFY+DDC_FIRST_PEL+DDC_CORR_INV
   ddc_fbAbove     BYTE  0
ifdef DBCS  ; DBCS codepage support     ;IBMJ
   ddc_idCodePage  DWORD DEFAULTVIOCODEPAGE ; codepage id at ddc enable time
endif;DBCS        ;IBMJ
   ddc_prddc       DWORD INVALID_ADDRESS

;/*
;** reset_ddc_state initializes only below
;*/

   ddc_ia          IMAGE_ATTRS    <>
   ddc_pa          PATTERN_ATTRS  <>
   ddc_la          LINE_ATTRS     <>
   ddc_ca          CHAR_ATTRS     <>
   ddc_ma          MARKER_ATTRS   <>
   ddc_fbBelow     BYTE  0
   ddc_fbClrTbl    BYTE  DDC_DITHER
   ddc_iSysClr     DWORD 0
   ddc_npddcPrev DWORD INVALID_ADDRESS
   ddc_cLevel      DWORD 1

   ddc_pClrTbl     DWORD 0
   ddc_npdevpal    DWORD 0
   ddc_pDefPal     DWORD 0
   ddc_ctMin       DWORD 0
   ddc_ctMax       DWORD 0
   ddc_ctSize      DWORD 0
   ddc_FontsLoaded DWORD 3 dup (0)                 ;vcb
   ddc_MapFontsLoaded DWORD 3 dup (0)              ;vcb
DDC              ENDS

PDDC    TYPEDEF PTR DDC
.ERRNZ   (sizeof DDC) and 1

RDDC                  STRUCT      4
   rddc_usId          DWORD  RDDC_IDENT
   rddc_npddc         DWORD  INVALID_ADDRESS
   rddc_ptsOrg        POINTL <0,0>
   .ERRE NUM_CLIP_RECTS EQ 16

;/*
;** there must be NUM_CLIP_RECTS of these with the first inited
;** like so and the rest set to 0's
;*/

   rddc_arcsClip    RECTL <0,0,SCREEN_CX,SCREEN_CY>
   rddc_Clip2       RECTL <0,0,0,0>
   rddc_Clip3       RECTL <0,0,0,0>
   rddc_Clip4       RECTL <0,0,0,0>
   rddc_Clip5       RECTL <0,0,0,0>
   rddc_Clip6       RECTL <0,0,0,0>
   rddc_Clip7       RECTL <0,0,0,0>
   rddc_Clip8       RECTL <0,0,0,0>
   rddc_Clip9       RECTL <0,0,0,0>
   rddc_Clip10      RECTL <0,0,0,0>
   rddc_Clip11      RECTL <0,0,0,0>
   rddc_Clip12      RECTL <0,0,0,0>
   rddc_Clip13      RECTL <0,0,0,0>
   rddc_Clip14      RECTL <0,0,0,0>
   rddc_Clip15      RECTL <0,0,0,0>
   rddc_Clip16      RECTL <0,0,0,0>
   rddc_rcsUsrBound RECTL <MAXSHORT,MAXSHORT,MINSHORT,MINSHORT>

;/*
;** reset_rddc_state initializes only below
;*/

   rddc_ptlWorldPos POINTL <0,0>
   rddc_ptsCurPos   POINTL <0,0>
   rddc_rclGpiBound RECTL <MAX_COORDINATE,MAX_COORDINATE,MIN_COORDINATE,MIN_COORDINATE>
   rddc_rclPick       RECTL <0,0,0,0>
   rddc_rcsCorr       RECTL <0,0,0,0>
RDDC                ENDS

PRDDC   typedef PTR RDDC

         .ERRNZ   (sizeof RDDC) and 3

         .ERRNZ   DDC.ddc_usId-SURFACE.sd_usId
         .ERRNZ   DDC.ddc_npsd-SURFACE.sd_npsd
RESET_DDC_BUNDLES      TEXTEQU <DDC.ddc_ia>
RESET_DDC_POST_BUNDLES TEXTEQU <DDC.ddc_fbBelow>

        .ERRNZ  RESET_DDC_BUNDLES       - DDC.ddc_ia
        .ERRNZ  RESET_DDC_POST_BUNDLES  - DDC.ddc_fbBelow

RESET_RDDC_START       TEXTEQU <RDDC.rddc_ptlWorldPos>
        .ERRNZ  RESET_RDDC_START        - RDDC.rddc_ptlWorldPos

DDC_DEVICE         EQU 10000000b ;ddc_fb
DDC_CLIP_NOTIFY  EQU 01000000b
DDC_FIRST_PEL      EQU 00100000b
DDC_UNIT_XFORM     EQU 00010000b
DDC_CORR_INV       EQU 00001000b
DDC_SSB_CALL       EQU 00000100b
DDC_PRESENT        EQU 00000010b
DDC_VISIBLE        EQU 00000001b

DDC_DIRTY_VISRGN EQU 00000010b
DDC_INFO_DC        EQU 00000001b

DDC_DIRTY_ATTRS  EQU 10000000b ;ddc_fbBelow

DDC_PALETTE        EQU 10000000b ;ddc_fbClrTbl

DDC_REALIZED       EQU 01000000b
DDC_REALIZABLE     EQU 00100000b
DDC_USER_CLR_0     EQU 00010000b
DDC_USER_CLR_7     EQU 00001000b
DDC_RGB_MODE       EQU 00000100b
DDC_LOG_CLR_TBL    EQU 00000010b
DDC_DITHER         EQU 00000001b

ENDIF

;/*
;** Various Display identifiers returned from VioGetConfig
;*/

DISPLAY_8503        EQU 3    ; Mono
DISPLAY_8514        EQU 9    ; 
DISPLAY_PLASMA      EQU 10   ; Mono
DISPLAY_8515        EQU 12   ; Dallas
DISPLAY_COLOR_LCD   EQU 1010 ; viogetconfig should never return this!
;MONITOR_851X_COLOR  EQU 13


SVGAstruct          struc
SVGAadaptertype     dw  ?
SVGAchiptype        dw  ?
SVGAmemory          dd  ?
SVGAstruct          ends

VIDEO7_ADAPTER      EQU 1
TRIDENT_ADAPTER     EQU 2
TSENG_ADAPTER       EQU 3
WESTERNDIG_ADAPTER  EQU 4
ATI_ADAPTER         EQU 5

VGA_EXPRESSWAY      EQU 0    ; VGA adapter is an ExpressWay card (bVGAtype)

MACHINE_NECTARINE   EQU 0F85Eh ; Nectarine notebook systems model/submodel
MACHINE_NECTARINEPR EQU 0F860h ; Nectarine Prime notebook systems model/submod
MACHINE_L40SX       EQU 0F823h ; L40SX laptop systems model/submodel

SFONT_RASTER_8515 EQU 102 ; Dallas System font

errnz    MACRO    x
   IF x
        errnz1 <x>,%(x)
   ENDIF
ENDM

errnz1   MACRO    x1,x2
        = *errnz* x1 = x2
        .ERR
ENDM

errn$    MACRO    l,x
LOCAL HERE
HERE EQU $
ifnb <x>
        .errnz HERE - l x
else
        .errnz HERE - l
endif
ENDM

;/*
;**---------------------------Macro---------------------------------------;
;** save_error_code
;**
;** Calls the appropriate routine to save the error code.
;**
;** Entry:
;**        AX = error code
;** Returns:
;**        nothing
;** Registers Destroyed:
;**        !!!
;*/

save_error_code   macro
         INVOKE  save_that_error
ENDM

;/*
;**---------------------------Macro---------------------------------------;
;** save_warning_code
;**
;** Calls the appropriate routine to save the warning code.
;**
;** Entry:
;**        AX = error code
;** Returns:
;**        nothing
;** Registers Destroyed:
;**        !!!
;** History:
;**  Fri Jun 24, 1988 10:36:00        -by-     Kent Settle       [kentse]
;** Created.
;*/

save_warning_code MACRO
         CALL     save_that_warning
ENDM

save_unrecoverable_code    MACRO
         CALL     save_that_unrecoverable_error
ENDM

;/*
;**-----------------------------------------------------------------------;
;** odd    --- macro for odd alignment, counterpart for masm's "even".
;**
;** Arguments:
;**        none
;** Returns:
;**        nothing
;** Alters:
;**        nothing
;** Calls:
;**        nothing
;**
;*/

odd      MACRO

IFE (offset $) AND 1
         NOP
ENDIF

ENDM

;/*
;**---------------------------macro---------------------------------------;
;** pushem
;** popem
;**
;** Allows giving a list of registers to push/pop on a single line.
;** Also allows easy verificaton that pushes and pops are balanced
;** because arguements are given in the same order:
;**
;**        pushem   AX,bx,cx   goes with
;**        popem    AX,bx,cx
;**
;** Arguments:
;**        registers to push/pop
;** Returns:
;**        nothing
;** Alters:
;**        nothing
;** Calls:
;**        nothing
;*/

pushem   MACRO    r1,r2,r3,r4,r5,r6,r7,r8,r9,rA,rB,rC,rD,rE,rF,r10,r11,r12
         IRP      x,<r1,r2,r3,r4,r5,r6,r7,r8,r9,rA,rB,rC,rD,rE,rF,r10,r11,r12>
         IFNB     <x>
         PUSH     x
ENDIF
ENDM
ENDM

popem    MACRO    r1,r2,r3,r4,r5,r6,r7,r8,r9,rA,rB,rC,rD,rE,rF,r10,r11,r12
         IRP      x,<r12,r11,r10,rF,rE,rD,rC,rB,rA,r9,r8,r7,r6,r5,r4,r3,r2,r1>
         IFNB     <x>
         POP      x
ENDIF
ENDM
ENDM

;/*
;**-----------------------------macro----------------------------------------;
;** abs_ax
;**        takes absolute value of AX
;** Entry:
;**        AX       = integer
;** Returns:
;**        AX       = abs(AX)
;** Error Returns:
;**        none
;** Registers Destroyed:
;**        DX,FLAGS
;** Registers Preserved:
;**        BX,CX,SI,DI,DS,ES,BP
;** Calls:
;**        none
;*/

abs_ax   MACRO
         CDQ
         XOR      EAX,EDX
         SUB      EAX,EDX
ENDM

;/*
;**---------------------------macro-----------------------------------------------;
;** usmin_ax
;**        returns unsigned min of AX and REG/MEM
;** Entry:
;**        AX       = unsigned integer
;**        REG/MEM  = unsigned integer
;** Returns:
;**        AX       = min(AX,REG/MEM)
;** Error Returns:
;**        none
;** Registers Destroyed:
;**        FLAGS
;** Registers Preserved:
;**        BX,CX,DX,SI,DI,DS,ES,BP
;** Calls:
;**        none
;*/

usmin_ax MACRO    REG
         LOCAL    got_it
         CMP      EAX,REG
         JB       got_it
         MOV      EAX,REG
got_it:
ENDM

;/*
;**--------------------------macro-------------------------------------------;
;** usmax_ax
;**        returns unsigned max of AX and REG/MEM
;** Entry:
;**        AX       = unsigned integer
;**        REG/MEM  = unsigned integer
;** Returns:
;**        AX       = max(AX,REG/MEM)
;** Error Returns:
;**        none
;** Registers Destroyed:
;**        FLAGS
;** Registers Preserved:
;**        BX,CX,DX,SI,DI,DS,ES,BP
;** Calls:
;**        none
;*/

usmax_ax MACRO    REG
         LOCAL    got_it
         CMP      EAX,REG
         JA       got_it
         MOV      EAX,REG
got_it:
ENDM


;/*
;**---------------------------macro------------------------------------------;
;** smin_ax
;**        returns signed min of AX and REG/MEM
;** Entry:
;**        AX       = signed integer
;**        REG/MEM  = signed integer
;** Returns:
;**        AX       = min(AX,REG/MEM)
;** Error Returns:
;**        none
;** Registers Destroyed:
;**        FLAGS
;** Registers Preserved:
;**        BX,CX,DX,SI,DI,DS,ES,BP
;** Calls:
;**        none
;*/

smin_ax  MACRO    REG
         LOCAL    got_it
         CMP      EAX,REG
         JL       got_it
         MOV      EAX,REG
got_it:
ENDM

;/*
;**---------------------------macro------------------------------------------;
;** smax_ax
;**        returns signed max of AX and REG/MEM
;** Entry:
;**        AX       = signed integer
;**        REG/MEM  = signed integer
;** Returns:
;**        AX       = max(AX,REG/MEM)
;** Error Returns:
;**        none
;** Registers Destroyed:
;**        FLAGS
;** Registers Preserved:
;**        BX,CX,DX,SI,DI,DS,ES,BP
;** Calls:
;**        none
;** History:
;**  Mon Apr 04 14:14:19 1988         -by-     Hock Lee [hockl]
;** wrote it
;*/

smax_ax  MACRO    REG
         LOCAL    got_it
         CMP      EAX,REG
         JG       got_it
         MOV      EAX,REG
got_it:
ENDM

;/*
;**---------------------------------Macro---------------------------------;
;** missing_code
;**
;** missing_code is a macro which will display a message on the screen
;** at assembly time.  It is used to flag code sequences which have not
;** been completed.
;**
;** usage
;**
;**        missing_code      <text>
;**
;** Entry:
;**        none
;** Returns:
;**        none
;** Error Returns:
;**        none
;** Registers Destroyed:
;**        none
;** Registers Preserved:
;**        ALL
;** Calls:
;**       none
;*/

missing_code MACRO x
         if1
         ??_out   <&! Missing Code &!  x>
ENDIF
ENDM

;/*
;**-------------------------------Public-Macro-----------------------------;
;** check
;**
;**  checks whether the given function has the correct parameters
;**
;** usage:
;**
;**  check  FunctionName,<parm1,parm2,parm3>
;**
;*/

check    MACRO    funcname,parms
         inner_check       %prm_&funcname,<parms>
ENDM

inner_check MACRO string1,string2
         .ERRDIF <string1>,<string2>
ENDM

;/*
;** The following macros pertain to firewall code
;*/

IFDEF FIREWALLS
ifndef SEI_STACKTRACE

;/*
;**  save the stack trace
;*/

SEI_STACKTRACE             EQU               0001h
endif
ifndef SEI_REGISTERS

;/*
;**  save the registers
;*/

SEI_REGISTERS              EQU               0002h
endif

SEIOptions = SEI_REGISTERS+SEI_STACKTRACE

ENDIF

;/*
;**---------------------------Macro---------------------------------------;
;** rip is the macro which invokes the error processor to perform the
;** call to WinSetErrorInfo to abort the process.
;**
;** Usage:
;**        rip      arg1,arg2
;** Where:
;**        if arg1 == text, arg2 contains the text of error message
;**        otherwise, arg1 is the name of the message it will be referenced by
;*/

rip      MACRO    arg1,arg2
         LOCAL    msg_offset
IFDEF FIREWALLS
Debug32Output PROTO SYSCALL, pszMsg:DWORD

  IFIDNI <arg1>,<text>
_DATA SEGMENT
       msg_offset BYTE     '&arg2',0
_DATA ENDS
       INVOKE   perform_rip,ADDR msg_offset
  ELSE
    IFNB  <arg2>
       .ERR
    ENDIF
_DATA SEGMENT
       EXTERN     msg_&arg1:byte
_DATA ENDS
       INVOKE     perform_rip,ADDR msg_&arg1
  ENDIF
ENDIF   ;Firewalls
ENDM


;/*
;**---------------------------Macro---------------------------------------;
;** DebugOutput is the macro which invokes the Win32DebugOutput to
;** print messages onto the debug terminal.
;**
;** Usage:
;**        DebugOutput,<String to print>
;*/

DebugMsg     MACRO         OutString:REQ
         LOCAL    msg_offset
IFDEF FIREWALLS

Debug32Output PROTO SYSCALL, pszMsg:DWORD

_DATA SEGMENT
       msg_offset BYTE     '&OutString',13,10,0
_DATA ENDS
SUPPRESS_MESSAGES EQU 1
ifndef SUPPRESS_MESSAGES
     PUSHAD
     INVOKE     Debug32Output,ADDR msg_offset
     POPAD
endif
ENDIF   ;Firewalls
ENDM

data_check MACRO reg
         LOCAL    all_cool
IFDEF FIREWALLS
         CMP      reg:[data_ident],DS_IDENT
         JZ       all_cool
         rip      BadDataSegment
all_cool:
ENDIF
ENDM

;/*
;**---------------------------Macro---------------------------------------;
;** This is a repeat of the DebugMsg macro.
;**
;** Usage:
;**        DebugMsg2,<String to print>
;*/

DebugMsgKZ MACRO OutString:REQ
ENDM

DebugMsg2 MACRO OutString:REQ
         LOCAL  msg_offset
IFDEF FIREWALLS

Debug32Output PROTO SYSCALL, pszMsg:DWORD

_DATA SEGMENT

       msg_offset BYTE     '&OutString',13,10,0

_DATA ENDS

        PUSHAD
        INVOKE     Debug32Output,ADDR msg_offset
        POPAD

ENDIF   ;Firewalls

ENDM ; DebugMsg2

data_check MACRO reg
         LOCAL    all_cool
IFDEF FIREWALLS
         CMP      reg:[data_ident],DS_IDENT
         JZ       all_cool
         rip      BadDataSegment
all_cool:
ENDIF
ENDM

;/*
;**-----------------------------Macro-------------------------------------------;
;** puts
;**
;** If FIREWALLS is nonzero, outputs a string to the debugging output screen.
;**
;** Entry:
;**        String    = string to output
;**
;** Example:
;**        puts     <*** StretchBlt: creating shadow bitmap>
;**
;** Registers Preserved:
;**        all
;**
;** Registers Destroyed:
;**        none
;**
;*/

puts     textequ <DebugOutput>

;/*
;**---------------------------Macro---------------------------------------;
;** ddc?
;**
;** ddc validation.
;**
;** A call is generated to the subroutine which performes a massive
;** FIREWALL check of the given ddc.  Parameters are allowed which
;** control how much checking is actually performed.
;**
;** Usage:
;**        ddc?     hddc,<cmds>
;**
;** Where:
;**        hddc     The handle to the ddc.     If it isn't a register, it is
;**                 assumed to be a dword parameter on the frame.  If it
;**                 is a register, HDDC_IDENT will be pushed on the stack
;**                 along with the register to fake an hddc.
;**
;**        cmds     Commands, which control extra ddc checking:
;**
;**                 MEMORYDDC  Must be a memory ddc
;**
;**                 LEVELS      Validate all levels of the ddc.  If not
;**                             given, validation is performed only on
;**                             the topmost level.
;**
;**                 SURFACE    The surface selected into the ddc is
;**                             checked.
;**
;** Destroys:
;**        30 bytes or so of stack space
;*/

MAKEULONG MACRO hipart:REQ,lopart:REQ
        EXITM %((hipart SHL 16) OR (lopart))
ENDM

IFDEF FIREWALLS
IFNDEF   DDC_VALIDATE_DEFINED
ENDIF
        .XCREF
        .XCREF ddc?_flags,DDC?MEMORYDDC,DDC?SURFACE,DDC?LEVELS
  DDC?MEMORYDDC EQU 00000001b
  DDC?SURFACE     EQU 00000010b
  DDC?LEVELS      EQU 00000100b
  ddc?_flags      =   0
        .CREF
ENDIF

ddc?     MACRO    thehddc,commands
IFDEF FIREWALLS
    ddc?_flags=0
    IFNB <commands>
      IRP x,<commands>
         ddc?_flags = ddc?_flags or DDC?&x
      ENDM
    ENDIF
        INVOKE  ddc_validate,
                thehddc,
                ddc?_flags
ENDIF
ENDM

rddc?    MACRO    reg
  LOCAL here
IFDEF FIREWALLS
    CMP     (RDDC PTR [reg]).rddc_usId,RDDC_IDENT
    JZ       here
    rip     text,<Bad RDDC>
    int 3
here:

ENDIF
ENDM

;/*
;**---------------------------Macro---------------------------------------;
;** fw_zero is a firewall macro which zeros the registers in the given
;** list.  It doesn't try to be smart about it.
;**
;** Usage:
;**        fw_zero <list>
;** Where:
;**        list - the register to be zeroed
;**
;** Restrictions:
;**        16-bit and 8-bit registers cannot be mixed in the same fw_zero.
;**        This is because of the optimization of moving between registers
;**        when possible.
;*/

fw_zero  MACRO    list
IFDEF FIREWALLS
    .XCREF
    .XCREF ?fw_zero
    .CREF
    ?fw_zero=1
    IRP x,<list>
      IFDIFI <x>,<es>
        IFDIFI <x>,<ds>
         ?fw_zero=0
         MOV      x,0                        ;;Don't alter 'Z'
         IRP y,<list>
           IFDIFI <y>,<x>
         MOV      y,x
ENDIF
ENDM
         EXITM
ENDIF
ENDIF
ENDM
    IF ?fw_zero
      IRP x,<list>
         PUSHd    0
         POP      x
ENDM
ENDIF
ENDIF
ENDM

;/*
;**---------------------------------Macro---------------------------------;
;** jmpnext
;** jmpnext stop
;**
;** jmpnext is used in the generation of fall through chains.  It
;** generates the opcode used to swallow the next two bytes of object
;** code (cmp ax,immediate word), and performs error checking to
;** ensure that only two bytes of object code exist between any
;** use of jmpnext.
;**
;** The chain is terminated by use of an optional parameter to jmpnext.
;** If this optional field is non-blank, the chain is terminated.
;**
;** WARNING:  jmpnext destroys your flags!
;**
;** Usage:
;**
;**        dog:
;**             mov    al,34
;**             jmpnext
;**        foo:
;**             mov     al,0
;**             jmpnext
;**        bar:
;**             mov     al,1
;**             jmpnext stop                   ;End of the chain
;** jmpcl
;** jmpcl  stop
;**
;** jmpcl is used like jmpnext, except that it skips over only one byte.
;** WARNING:  jmpcl destroys your CL!  (But not your flags.)
;**
;** Usage:
;**             clc
;**             jmpcl
;**        other_way:
;**             stc
;**             jmpcl  stop
;**
;** jmpcx
;** jmpcx  stop
;**
;** jmpcx is used like jmpnext, except that it destroys CX instead of
;** the flags.
;**
;** Entry:
;**        none
;** Returns:
;**        none
;** Error Returns:
;**        none
;** Registers Destroyed:
;**        FLAGS or CL or CX
;** Registers Preserved:
;**        AX,BX,CX,DX,SI,DI,BP,DS,ES
;** Calls:
;**       none
;/

??ji     =        0                          ;;Initial index value

jmpcl    macro e                    ;;mov cl,<next byte>
jn %??ji,%(??ji+1),0B1h,+1,e                 ;;Set next label
endm

jmpcx    macro e                    ;;mov cx,<next word>
jn %??ji,%(??ji+1),0B9h,+2,e                 ;;Set next label
endm

jmpnext macro e                     ;;cmp ax,<next two bytes>
jn %??ji,%(??ji+1),03Dh,+2,e                 ;;Set next label
endm

jn macro i,j,c,d,e
.sall
??ji&i:
.xall
ifb <e>                             ;;If not the end of the chain
         db       c
        errn$  ??ji&j d                      ;;next lable must be two bytes away
endif
??ji=j                                       ;;increment counter
endm

;/*
;**---------------------------Macro---------------------------------------;
;** access is a simple macro to check that we have access rights to the
;** given selector.  If we do not, gain_access_to_selector is called.
;**
;** Usage:
;**        access   reg,selector
;** Where:
;**        reg       - A work register
;**        selector - The selector we want access to.  Must not be the
;**                    same as reg
;** Restrictions:
;**        Uses AX if access is needed
;*/

;/*
;** This is not needed because the new engine gives us access
;** rights to everything in its globally allocated heap space upon
;** process initialization.
;*/

access   MACRO    reg,selector
ifndef 16BITWORLD
         LOCAL    xyzzy
        IFIDNI <reg>,<selector>
                 .ERR
        ENDIF
         CMP      selector,INVALID_SEL       ;Don't gain access to bogus selectors
         JE       xyzzy
         LAR      reg,selector
         JZ       xyzzy
         INVOKE   gain_access_to_selector,selector
xyzzy:
endif
ENDM

;/*
;**---------------------------Macro---------------------------------------;
;** pubabs is a simple macro to make an absolute value public
;**
;** Usage:
;**        pubabs   name,val
;** Where:
;**        name      - name of the equate
;**        val       - value it is to have
;*/

pubabs   MACRO    name,val
         PUBLIC   name
name     EQU      val
ENDM

IFDEF INCL_DDICOMFLAGS

;/*
;**-----------------------------------------------------------------------;
;** no_path_area
;**
;** this macro checks to make sure we are NOT in a path and/or an area.
;** if we are in what we shouldn't be, then we return an "invalid operation
;** in path" (or "in area", as appropriate) error and jump to the label
;** passed in.
;**
;** to indicate which checking is to be done, the macro is passed a
;** keyword as the second argument:  'area' for area only
;**                                      'path' for path only
;**                                      'both' for both area and path
;** The second paramter 'jumplabel':
;**  1. A label to jump to after save_error_code is called
;**     if the third parameter is 'error'.
;**  2. A label where the error handling is done if the third param is
;**     blank.
;**
;** The third parameter 'ret_type':
;**  1. Pass in 'error' to have the macro call save_error_code,
;**     mov eax,0, and jump to 'jumplabel'
;**  2. Pass in nothing (blank) to have it jump to the first parameter
;**     'jumplabel' without calling save_error_code or changing eax
;** Entry:
;**        FunN (on stack, at routine entry time)
;** Returns:
;**        None.
;** Error Returns:
;**        AX = 0.
;** Registers Destroyed:
;**        None.
;**
;*/

         .ERRNZ   HIGH COM_PATH
         .ERRNZ   HIGH COM_AREA

no_path_area MACRO jumplabel,patharea,ret_type
         LOCAL    nothing_here,its_a_path,save_the_error

IFIDNI   <patharea>,<path>          ;; disallow path only
         TEST     FunN,COM_PATH
         JZ       nothing_here
         MOV      EAX,PMERR_INV_IN_PATH
ELSE

IFIDNI   <patharea>,<area>          ;; disallow area only
         TEST     FunN,COM_AREA
         JZ       nothing_here
         MOV      EAX,PMERR_INV_IN_AREA
ELSE

IFIDNI   <patharea>,<both>          ;; disallow path and area
         TEST     FunN,COM_PATH OR COM_AREA
         JZ       nothing_here
         TEST     FunN,COM_PATH ;; which error do we have?
         JNZ      its_a_path
         MOV      EAX,PMERR_INV_IN_AREA
         JMP      save_the_error

its_a_path:
         MOV      EAX,PMERR_INV_IN_PATH
save_the_error:
ELSE
         .ERR
ENDIF             ;; both
ENDIF             ;; area
ENDIF             ;; path

IFDIFI  <ret_type>,<error>
         save_error_code
         mov      eax,0
        IFNB    <ret_type>
                .ERR
        ENDIF
ENDIF   ;IFDIFI
        jmp     jumplabel
nothing_here:
ENDM

ENDIF    ;ifdef INCL_DDICOMFLAGS

;/*
;** CellFont Structure                                                             ;
;**                                                                                ;
;** This structure defines an entry in the font cell table, adDevVioCells.;
;*/

CellFont     STRUCT 4
   cf_width  DWORD  ?      ; The width of a character cell.
   cf_height DWORD  ?      ; The height of a character cell.
   cf_ptr    DWORD  ?      ; Font definition address.
CellFont     ENDS

OFFSCR_VDD         EQU 00000001b ; using VDD to alloc off-screen memory
OFFSCR_TRASHED     EQU 00000010b ; off-screen memory has been trashed

;/*
;** Video VDD requests (WARNING: must be kept in sync with H\VVD.H)
;*/

SHADOW_DIRTYREGS   EQU 01h       ; video controller registers are dirty

VVDSYSREQ_COPYBITMAP    EQU 8    ; Copy bitmap data
VVDSYSREQ_SETDRQ        EQU 11       ; Set display requirements
VVDSYSREQ_REQMEM        EQU 12       ; Request off-screen video memory
VVDSYSREQ_FREEMEM       EQU 13       ; Free off-screen video memory
VVDSYSREQ_REQCTRL       EQU 14       ; Request video controller ownership
VVDSYSREQ_FREECTRL      EQU 15       ; Free video controller ownership

vvreg_s      STRUCT 4      ; Virtual Video Register entry
   vvr_port  USHORT ?      ; port #
   vvr_indx  BYTE   ?      ; register index #
   vvr_value BYTE   ?      ; last value written to register
vvreg_s      ENDS

vvdrq_s               STRUCT 4  ; structure for VVDSYSREQ_SETDRQ request
   pPhysVRAM            DWORD  ? ; physical address of VRAM
   nbReserved           DWORD  ? ; # of reserved bytes
   offLatchByte         DWORD  ? ; offset of available latch storage
   pfbShadowFlags       DWORD  ? ; pointer to flags (see SHADOW_* constants)
   pfControllerOwned    DWORD  ? ; address of driver's fControllerOwned flag
   pfControllerNotify   DWORD  ? ; address of driver's fControllerNotify flag
   nShadowRegs          DWORD  ? ; # of registers to shadow
   pShadowData          DWORD  ? ; address of first vvreg_s entry (see above)
vvdrq_s ENDS

;/*
;**
;** The following is the definition of new background mixmodes temporarily placed
;** here due to the confusion in the process of checking in constants to the
;** PMGPI.H file. A PTR will be raised for GPI to put them in, therefore, they
;** should be removed from here when they enter PMGPI.H.
;**
;*/

BM_AND         EQU  6
BM_SUBTRACT    EQU  7
BM_MASKSRCNOT  EQU  8
BM_ZERO        EQU  9
BM_NOTMERGESRC EQU 10
BM_NOTXORSRC   EQU 11
BM_INVERT      EQU 12
BM_MERGESRCNOT EQU 13
BM_NOTCOPYSRC  EQU 14
BM_MERGENOTSRC EQU 15
BM_NOTMASKSRC  EQU 16
BM_ONE         EQU 17

;/*
;**
;** The following is the definition of new background mixmodes temporarily placed
;** here due to the confusion in the process of checking in constants to the
;** PMDEV.H file. A PTR will be raised for GPI to put them in, therefore, they
;** should be removed from here when they enter PMDEV.H.
;**
;*/

CAPS_BM_AND                    EQU   32
CAPS_BM_GENERAL_BOOLEAN        EQU   64

CAPS_EXTRA_AREA_BACKGROUND_MIX EQU   41
CAPS_EXTRA_LINE_BACKGROUND_MIX EQU   42

LBB_BACK_COLOR                 EQU 0002h
LBB_BACK_MIX_MODE              EQU 0008h

;/*
;** The following structure defines a size for the pointer.  The driver may
;** support more than one pointer size.
;*/

PTRSIZE STRUCT
   PtrWidth  DWORD ?
   PtrHeight DWORD ?
PTRSIZE ENDS

;/*
;** This has been moved out of phycolor.asm because the assembler
;** won't take negative abs values in Dwords (just words)
;*/

MIN_SPECIAL_COLOR EQU (0FFFFFFceh)      ;was FFFFFFd1 sel 2-23
MIN_SYSTEM_COLOR  EQU (0FFFFFFceh)      ;was FFFFFFd1 sel 2-23

ENDIF

;/*
;** This was in scanline.inc but was device independent so it was moved here
;*/

ifdef DINCL_EXTENDEDCONTROL
NBR_RECTS       equ     100     ; # of clip-Rects in buffer on stack

EXTENDED_CONTROL struct
        ec_control      RGNRECT <>
        ec_buffer       DWORD   NBR_RECTS * ( SIZEOF RECTL / 4 ) dup (?)
        ec_rect_bound   RECTL   <>
EXTENDED_CONTROL ends
endif

INSURE_VISREGIONNOTIFY MACRO
;        INVOKE CheckVisRegion
ENDM

ENTER_DRIVER2 MACRO
        INVOKE enter_driver
ENDM

ALIASPARM   STRUC
ulLen       DD  ?                       ; Length of the parm block
dsel        DW  ?                       ; Data selector
ALIASPARM   ENDS

ALIAS16   STRUC
ap_len      DW  ?                       ; Length of the parm block
ap_ds       DW  ?                       ; Data selector
ALIAS16   ENDS
IFDEF SCAN_CNT
IF SCAN_CNT NE 768

;/*
;** Dummy macros that do nothing when NOT 1024x768
;*/

OVAccess MACRO
ENDM

OVRestore MACRO
ENDM
endif ;768

ENDIF

;/*
;**            Start
;*/

DEVESC_GETAPERTURE      EQU     33000
DEVESC_ACQUIREFB        EQU     33010
DEVESC_DEACQUIREFB      EQU     33020
DEVESC_SWITCHBANK       EQU     33030
AFB_SWITCH              EQU     1

_RESERVEADAPTER struc
        fAFBFlags         DWORD ?
        ulBankNumber      DWORD ?
        Exclude_xLeft     DWORD ?
        Exclude_yBottom   DWORD ?
        Exclude_xRight    DWORD ?
        Exclude_yTop      DWORD ?
_RESERVEADAPTER ends

RESERVEADAPTER  TYPEDEF _RESERVEADAPTER

_QUERYADAPTER struc
        ulApertureAddress DWORD ?
        ulApertureSize    DWORD ?
        ulScanlineSize    DWORD ?
        Screen_xLeft      DWORD ?
        Screen_yBottom    DWORD ?
        Screen_xRight     DWORD ?
        Screen_yTop       DWORD ?
_QUERYADAPTER ends

QUERYADAPTER  TYPEDEF _QUERYADAPTER

;/*
;**            End
;*/

;/*
;**            Start
;/*

;/*
;** MACRO GET_SEM
;*/

GET_SEM MACRO
        LOCAL SeamlessRetry


IFDEF  SEAMLESS

SeamlessRetry:

ENDIF ;SEAMLESS

        INVOKE  RAMSEMREQUEST32,
                ADDR semDriver

        or      eax,eax

ifdef  SEAMLESS

        jz      @F
        call    SeamlessHeartbeat
        jmp     SeamlessRetry

        ALIGN 4
@@:

endif ;SEAMLESS

ifdef FIREWALLS

        jz      @F
        rip     text,<Error on acquiring a semaphore>
@@:
        pushfd
        pop     enter_flags

endif ;FIREWALLS


        ENDM        ;GET_SEM

;/*
;** MACRO RELEASE_SEM
;*/

RELEASE_SEM MACRO

        INVOKE  RAMSEMCLEAR32,
                ADDR semDriver

ifdef FIREWALLS

        pushfd
        pop     enter_flags

endif ;FIREWALLS

        ENDM
;/*
;**            END
;/*

ifdef DCAF                                                           ;          
  include dcaf.inc                                                   ;          
endif ; DCAF                                                         ;          
