;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/

ifndef EXCLUDE_DCAF_INC

        PAGE    ,132
        TITLE   DCAF.INC
;/*****************************************************************************
;*
;* SOURCE FILE NAME = DCAF.INC
;*
;* DESCRIPTIVE NAME = Main include file for DCAF code
;*
;*
;* VERSION      V2.0
;*
;* DATE         04/28/92
;*
;* DESCRIPTION  Contains EQUates and structures used by DCAF code.
;*
;* FUNCTIONS
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   04/28/92                     Created for DCAF 1.3
;*   07/01/92                     Ported to 32-bit for DCAF 2.0
;*
;*****************************************************************************/


MAXULONG           EQU     0FFFFFFFFH
GSB_OPT_4BPP       EQU     0000H
GSB_OPT_8BPP       EQU     0001H
GSB_OPT_16BPP      EQU     0002H
GSB_OPT_LINEAR     EQU     0000H
GSB_OPT_PLANAR     EQU     0008H
GSB_OPT_HRGN       EQU     0010H
;COM_CLIP_BOUND     EQU     0400H
;COM_CLIP_TO_SCREEN EQU     0800H

; If NRECT has been specified then override the default number of
; rectangles (14).
ifdef NRECT
% NUM_SCA_RECTS equ NRECT
else
NUM_SCA_RECTS   EQU     14
endif

NUM_SCA_PLUS1   EQU     (NUM_SCA_RECTS+1)

; Define the Screen Change Area structure.
SCA     STRUC
sca_next        DD      ?
sca_cRects      DD      ?
sca_rect        DB      SIZE RECTL * NUM_SCA_PLUS1 DUP (?)
sca_size        DD      NUM_SCA_PLUS1 DUP (?)
SCA     ENDS


; Define the structure of the compressed data Packet Header.
PACKETHDR       STRUC
phd_length      DD      ?
phd_format      DW      ?
PACKETHDR       ENDS

; Define the GetScreenBits device description structure.
GSB_DEV_STRUCT  STRUC
gsb_fDirectDC           DWORD   ?
gsb_cxScreenWidth       DWORD   ?
gsb_cyScreenHeight      DWORD   ?
gsb_ulScreenBitsPerPel  DWORD   ?
gsb_fbScreenFormatFlags BYTE    ?
gsb_pad1                BYTE    ?
gsb_pad2                BYTE    ?
gsb_pad3                BYTE    ?
gsb_pScreenStart        DWORD   ?
gsb_cbScanLineDelta     DWORD   ?
gsb_cPlanes             DWORD   ?
GSB_DEV_STRUCT  ENDS

; Various constants used when compressing data.
CD_MAX_8BIT_RUN_LENGTH          EQU     7FH
CD_NON_REPEATING_DATA_FLAG_8    EQU     80H
CD_NON_REPEATING_DATA_FLAG_16   EQU     8000H

MAX_X_RESOLUTION        EQU     640
MAX_SCANLINE_BYTES      EQU     (MAX_X_RESOLUTION / 2 )

WORST_CASE_PLANE_EXPAND equ ((MAX_X_RESOLUTION+\
                           CD_MAX_8BIT_RUN_LENGTH-1)/CD_MAX_8BIT_RUN_LENGTH)

WORST_CASE_ROW_EXPANSION equ (4 * WORST_CASE_PLANE_EXPAND)

WORST_CASE_ROW_LENGTH   EQU     (MAX_SCANLINE_BYTES+WORST_CASE_ROW_EXPANSION)
MIN_BUFFER_SIZE equ (size PACKETHDR) + (size RECTS) +\
                    WORST_CASE_ROW_LENGTH

GSB_OPT_FLAGS equ   GSB_OPT_4BPP   or  GSB_OPT_8BPP   or \
                    GSB_OPT_16BPP  or  GSB_OPT_LINEAR or \
                    GSB_OPT_PLANAR or  GSB_OPT_HRGN

GSB_FORMAT_FLAGS equ   GSB_OPT_4BPP   or  GSB_OPT_8BPP   or \
                       GSB_OPT_16BPP  or  GSB_OPT_LINEAR or \
                       GSB_OPT_PLANAR

; We need to define this as in the 32-bit VGA "OurRECTS" has been defined
; to contain DWORDs!
RealRECTS       STRUCT
   rcs_xLeft   WORD  ?
   rcs_yBottom WORD  ?
   rcs_xRight  WORD  ?
   rcs_yTop    WORD  ?
RealRECTS       ENDS

; Define the ordinal numbers for the required imports from the IBMDEV32
; module. These are used to dynamically fetch the addresses (if present)
; at load time.
ORD_GETSCREENBITS  equ  4207
ORD_SETSCREENBITS  equ  4208
ORD_UNPACKBUFFER   equ  4209

endif ; ndef EXCLUDE_DCAF_INC
