;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = CURSORS.INC
;*
;* DESCRIPTIVE NAME = Cursor definitions
;*
;*
;* VERSION      V2.0
;*
;* DATE         11/05/91
;*
;* DESCRIPTION  This file contains definitions necessary for the two cursor modules. 
;*             
;*
;* FUNCTIONS    
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   11/05/91                     KEZ  Original
;*****************************************************************************/

IFNDEF CURSORS_DEFD     ; Don't include if already included

CURSORS_DEFD EQU 1      ; Indicate it has been included

;/*
;** ptr_flags values
;*/

PTR_OFF       EQU 10000000b     ; Null pointer has been specified
PTR_EXCLUDED  EQU 01000000b     ; Pointer has been excluded
PTR_REDRAW    EQU 00100000b     ; Pointer needs to be updated

PTRI_ANIMATE  EQU 2             ; Pointer is animated

;/*
;** The next 2 symbols are used with "exclude_count", defined in CURSORSC.ASM
;*/

RECT_PRES     EQU 1             ; Exclusion rectangle set
RECT_NOT_PRES EQU 0             ; No exclusion rectangle set but may not be 
                                ; currently excluded

_PtrData16 SEGMENT DWORD PUBLIC USE16 'DATA'

;/*
;** (cxCell,cyCell) is the location of the pointer on the screen.  These
;** locations are only updated whenever a pointer is drawn.
;**
;** (cxReal,cyReal) is the location of the pointer as specified by the user.
;** These locations are always kept current.
;**
;** These cells may not be the same if the pointer drawing takes a lot of time
;** and the mouse is moving quickly.  Therefore, after a pointer has been
;** drawn, a check must be made to see if the pointer has moved, and if so,
;** the pointer must be drawn again.
;*/

cxCell  DWORD   INIT_POINTER_X                   ; X cell of last drawn pointer
cyCell  DWORD   INIT_POINTER_Y                   ; Y cell of last drawn pointer
cxReal  DWORD   INIT_POINTER_X                   ; Real x location of pointer
cyReal  DWORD   INIT_POINTER_Y                   ; Real x location of pointer

;/*
;** cxHot and cyHot contain the hot spot adjustment for the pointer.
;**
;** These locations should be zeroed whenever a pointer is changing or has
;** been turned off, and should be set once a pointer has been defined.  When
;** the pointer is turned off, the hot spot adjustment should be added back to
;** the real pointer coordinates (cxReal, cyReal).  When a pointer is set,
;** they should be subtracted off.  This will keep the pointer based at the
;** hot spot during a change instead of the upper left corner.
;*/

cxHot   DWORD   0       ;X hot spot adjustment
cyHot   DWORD   0       ;Y hot spot adjustment

;/*
;** The following structure contains the bounding rectangle wherein the
;** pointer is not allowed to be displayed.  The values for left and right
;** will always be rounded to contain the entire byte (or word or dword if
;** working to those boundaries).
;**
;** These values will only be valid if exclude_count is non-zero.
;**
;** NOTE: Only one rectangle at a time may be set.
;*/

ExcludeRect RECTL <0,0,0,0>
ExcludeCt   BYTE  RECT_NOT_PRES ; Set non-zero if rectangle is valid

;/*
;** fbPtrFlags contains control flags indicating the pointer status.  Flags
;** are defined for the pointer being off, and the pointer being excluded.
;*/

fbPtrFlags BYTE PTR_OFF ;Pointer status, initially hidden

fwPrevFlags WORD 0
        
_PtrData16 ENDS

ENDIF ; CURSORS_DEFD

