;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = SCRBITS.ASM
;*
;* DESCRIPTIVE NAME = GetScreenBits and SetScreenBits Entry Points.
;*
;*
;* VERSION      V2.0
;*
;* DATE         04/22/92
;*
;* DESCRIPTION
;*             These are two of the main entry points for DCAF
;*
;*
;* FUNCTIONS   GetScreenBits
;*             SetScreenBits
;*             init_devinfo_struc
;*
;* NOTES       NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   04/22/92                     Created for DCAF 1.3
;*   08/01/92                     Changed to 32-bit for DCAF 2.0
;*
;*****************************************************************************/
;/*
;** Include DCAF macros
;*/
;** --------------------------Exported-Routine-------------------------;
;/**********************************************************************
;**
;** GetScreenBits
;** -------------
;**
;** A region of screen pixel data is saved into the memory provided by
;** the caller. It can be compressed, converted into a format suitable
;** for another supported display device and will stop either when:
;**
;**   - the supplied memory area is full
;**   - the requested region has been returned.
;**
;** The region can be specified as either:
;**
;**   - a pointer to a single rectangle (rcl - long values)
;**   - a region handle
;**
;** setting the GSB_OPT_RGN flag in the flCmd parameter accordingly.
;** If a RECTL is specified then it is assumed to be inclusive
;** (as provided by GetBoundsData(GBD_SCREEN)).
;**
;** The function modifies the supplied rectangle/region to indicate the
;** area that was NOT returned in the call. If the whole requested region
;** was returned the rectangle/region will be a null area.
;**
;** The supplied DC must be direct - it is the source of the pixel data.
;**
;** This is not a drawing primitive, therefore no correlation, boundary
;** accumulation or drawing will take place.
;**
;** Entry:
;**   None
;** Returns:
;**   DX:AX  = 1 => entire area was saved in buffer
;**   DX:AX  = 2 => a subset of the area was saved in buffer
;** Error Returns:
;**   DX:AX  = 0
;** Registers Preserved:
;**   EBX, EDI, ESI
;** Registers Destroyed:
;**   EAX,ECX,EDX,FLAGS
;** Calls:
;** History:
;**   Fri April 24, 1992, Andy Rogers. Created it
;**********************************************************************/
;/*
;** Check that the supplied hddc is valid
;*/
;/*
;** Ensure that the direction flag is cleared (i.e. inc pointers)
;*/
;/*
;** Enter the driver - grab semaphore etc.
;*/
;/*
;** Initialise the device structure
;*/
;/*
;** Perform some initial error checking
;**
;** Read COM flags into edi
;*/
;/*
;** This call is invalid in a path or area
;*/
;/*
;** Check that the DC is direct (i.e. the screen)
;*/
;/*
;** Now check the parameters
;** First make sure the buffer length is not too big (<= 64K)
;*/
;/*
;** Now check that the buffer size is big enough
;*/
;/*
;** Save buffer size
;*/
;/*
;** Check the flags supplied are ones we know about
;*/
;/*
;** Check whether we are dead
;*/
;/*
;** Call the common compression function
;*/
;/*
;** Check to see if a NULL region was passed in - the length
;** will not be in the buffer
;*/
;/*
;** Update the length of the buffer passed in
;*/
;/*
;** Error handlers
;*/
;/*
;** Release the Driver semaphore etc. before exiting.
;** (without losing return code)
;*/
;/*
;** Reset the VGA registers we have used
;*/
;/*
;** Recover return code and extend into dx
;*/
;--------------------------Exported-Routine-----------------------------;
;/*********************************************************************
;* SetScreenBits                                                      *
;*                                                                    *
;* A region of screen pixel data is reconstructed from the buffer     *
;* provided by the caller and copied into a memory bitmap of the      *
;* display device.  The buffer contains data provided by the          *
;* GetScreenBits function.                                            *
;*                                                                    *
;* The supplied DC must be of memory type with a bitmap selected.     *
;*                                                                    *
;* For performance reasons there is no clipping.  If a rectangle      *
;* exceeds the bitmap dimensions then the function will terminate     *
;* immediately with an error logged. The bitmap may be left in a      *
;* partially drawn state as prior rectangles may have been copied     *
;* into it.                                                           *
;*                                                                    *
;* This is a drawing primitive, therefore correlation, boundary       *
;* accumulation and drawing could take place.  However this is        *
;* essentially a private interface (at least the caller is well       *
;* behaved) so we will totally ignore the function bits, and will     *
; * always just do the drawing and nothing else.                      *
;*                                                                    *
;* The routine may be passed a region handle, in which case the area  *
;* defined by the set bits will be added to the region.               *
;*                                                                    *
;* The VGA driver will only ever be passed 4bpp data.                 *
;*                                                                    *
;**********************************************************************
;*
;* Entry:
;*       None
;* Returns:
;*       DX:AX = TRUE (1)
;* Error Returns:
;*       DX:AX = FALSE (0)
;*       Error logged
;* Registers Preserved:
;*       SI,DI,BP,DS
;* Registers Destroyed:
;*       AX,BX,CX,DX,ES,FLAGS
;* Calls:
;*       enter_driver
;*       leave_driver
;* History:
;*
;* Wed 22-Apr-1992       -by-    Mark Berry, Data Connection Ltd.
;*     Rewrote it.
;* Sat 20 Jul 1991,       by     Greg Loten.
;*     Created it for DCAF 1.2.
;*********************************************************************/
;/*
;** Grab the driver semaphore etc.
;*/
;/*
;** Perform some initial error checking
;*/
;/*
;** Do some checking of the passed data length
;** 0 is a valid data length - but we must not access the buffer
;** (but any other value < the header size is invalid)
;*/
;/*
;** Compare data length with length in buffer
;*/
        ;jmp     short ssb_log_error_in_eax
;/*
;** Release the driver semaphore
;*/
;/**********************************************************************
;**
;** init_devinfo_struc
;** ------------------
;**
;** A routine to initialise the DCAF devinfo struct for the VGA display
;** driver
;**
;** Fills in the following information:
;**
;**         fDirectDC
;**         cxScreenWidth
;**         cyScreenHeight
;**         usScreenBitsPerPel
;**         fbScreenFormatFlags
;**         pScreenStart
;**         cbScanLineDelta
;**         cPlanes
;**
;** Parameters:
;**         phdc - pointer to direct DC
;**
;** Returns:
;**         None
;** Registers Preserved:
;**         di, si
;** Registers Destroyed:
;**
;** Calls:
;** History:
;** Mon April 27, 1992, Andy Rogers. Created it
;**
;**********************************************************************/
;/*
;** Get access to DCAF structure
;*/
;/*
;** Fill in all values
;*/
;/*
;** See if we have a direct DC or not
;*/
;/*
;** Store pointer to the screen bits
;*/

end
