;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE     55,132
        TITLE    resolve.asm
        SUBTITLE Header
;/*****************************************************************************
;*
;* SOURCE FILE NAME =  RESOLVE.ASM
;*
;* DESCRIPTIVE NAME =  Device Specific Initialization.
;*
;*
;* VERSION      V2.0
;*
;* DATE         10/01/91
;*
;* DESCRIPTION  Device Specific Initialization.
;*
;*
;* FUNCTIONS    device_specific_init
;*              device_specific_post_init
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   10/01/91                     Written by Scott Lawson
;*   08/08/93              71432  Back out change that caused regression
;*                                defect 71432.
;*
;*****************************************************************************/

        .386
        .MODEL FLAT,SYSCALL
        ASSUME  SS:FLAT, DS:FLAT, CS:FLAT, ES:FLAT

;/
;** Included files
;*/

.xlist
OS2_NOBASEAPI           equ                      1
INCL_DDIBUNDLES         equ                      1
INCL_DEV                equ                      1
;INCL_DDIFONTSTRUCS     equ                      1
INCL_FONTFILEFORMAT     equ                      1
INCL_GRE_FONTS          equ                      1
        include pmgre.inc
DINCL_ENABLE            equ                      1
DINCL_ROPS              equ                      1
DINCL_BB_ROPS           equ                      1
DINCL_SAVE_SCREEN_BITS  equ                      1
DINCL_VIO               equ                      1
DINCL_BITMAP            equ                      1
        include driver.inc
        include extern.inc
        INCLUDE POINTER.INC
        include protos.inc
        include ega.inc
ifdef   CLR256
        include display.inc
endif
        .list
.DATA


if SCAN_CNT eq 480

        pubabs  SCREEN_CX,640                            ; Screen width in pixels

        ifdef   CLR256

        pubabs  SCREEN_CBSCAN,1024                       ; # bytes in one scanline
        pubabs  SCREEN_DSCAN,1024                        ; Delta to next scanline
        pubabs  SCREEN_LPB,64

        else

        pubabs  SCREEN_CBSCAN,80                         ; # bytes in one scanline
        pubabs  SCREEN_DSCAN,80                          ; Delta to next scanline

        endif

        pubabs  D15_00_DEVCAPS_PHYS_COLORS,16
        pubabs  D31_16_DEVCAPS_PHYS_COLORS,0
        pubabs  DEVCAPS_VERTICAL_RESOLUTION,2667
        pubabs  DEVCAPS_HORIZONTAL_RESOLUTION,2667
        pubabs  VISIBLE_SIZE_WORDS,640*480
;                  pubabs  DEF_LINE_STEP_X,256/1
;                  pubabs  DEF_LINE_STEP_Y,256/1
        pubabs  DEF_LINE_STEP_X,256/4
        pubabs  DEF_LINE_STEP_Y,256/4
        pubabs  DEVCAPS_GRAPHICS_CHAR_WIDTH,13
        pubabs  DEVCAPS_GRAPHICS_CHAR_HEIGHT,13
        pubabs  DEVCAPS_HORIZONTAL_FONT_RES,96
        pubabs  DEVCAPS_VERTICAL_FONT_RES,96
        pubabs  DEVCAPS_CHAR_WIDTH,8
        pubabs  DEVCAPS_CHAR_HEIGHT,14
        pubabs  DEVCAPS_SMALL_CHAR_WIDTH,8
        pubabs  DEVCAPS_SMALL_CHAR_HEIGHT,8
endif

if SCAN_CNT eq 600

        pubabs  SCREEN_CX,800                            ; Screen width in pixels

        ifdef   CLR256

        pubabs  SCREEN_CBSCAN,1024                       ; # bytes in one scanline
        pubabs  SCREEN_DSCAN,1024                        ; Delta to next scanline
        pubabs  SCREEN_LPB,64

        else

        pubabs  SCREEN_CBSCAN,100                        ; # bytes in one scanline
        pubabs  SCREEN_DSCAN,100                         ; Delta to next scanline

        endif

        pubabs  D15_00_DEVCAPS_PHYS_COLORS,16
        pubabs  D31_16_DEVCAPS_PHYS_COLORS,0
        pubabs  DEVCAPS_VERTICAL_RESOLUTION,2459       ;Temp value to match XGA so PTT results match
        pubabs  DEVCAPS_HORIZONTAL_RESOLUTION,2461     ;Temp value to match XGA so PTT results match
        pubabs  VISIBLE_SIZE_WORDS,100*600
        pubabs  INIT_FSHADOW_MEM,0                ;Don't use it for VGA
;                  pubabs  DEF_LINE_STEP_X,256/1
;                  pubabs  DEF_LINE_STEP_Y,256/1
        pubabs  DEF_LINE_STEP_X,256/4
        pubabs  DEF_LINE_STEP_Y,256/4
        pubabs  DEVCAPS_GRAPHICS_CHAR_WIDTH,13
        pubabs  DEVCAPS_GRAPHICS_CHAR_HEIGHT,13
        pubabs  DEVCAPS_HORIZONTAL_FONT_RES,96
        pubabs  DEVCAPS_VERTICAL_FONT_RES,96
        pubabs  DEVCAPS_CHAR_WIDTH,8
        pubabs  DEVCAPS_CHAR_HEIGHT,14
        pubabs  DEVCAPS_SMALL_CHAR_WIDTH,8
        pubabs  DEVCAPS_SMALL_CHAR_HEIGHT,8
endif

if SCAN_CNT eq 768

        pubabs  SCREEN_CX,1024         ; Screen width in pixels

        ifdef   CLR256

        pubabs  SCREEN_CBSCAN,1024                       ; # bytes in one scanline
        pubabs  SCREEN_DSCAN,1024                        ; Delta to next scanline
        pubabs  SCREEN_LPB,64

        else

        pubabs  SCREEN_CBSCAN,128                        ; # bytes in one scanline
        pubabs  SCREEN_DSCAN,128                         ; Delta to next scanline
        pubabs  SCREEN_LPB,512

        endif

        pubabs  D15_00_DEVCAPS_PHYS_COLORS,16
        pubabs  D31_16_DEVCAPS_PHYS_COLORS,0
        pubabs  DEVCAPS_VERTICAL_RESOLUTION,3622
        pubabs  DEVCAPS_HORIZONTAL_RESOLUTION,3622
        pubabs  VISIBLE_SIZE_WORDS,1024*768
        pubabs  INIT_FSHADOW_MEM,0                ;Don't use it for VGA
;                  pubabs  DEF_LINE_STEP_X,256/2
;                  pubabs  DEF_LINE_STEP_Y,256/2
        pubabs  DEF_LINE_STEP_X,256/4
        pubabs  DEF_LINE_STEP_Y,256/4
        pubabs  DEVCAPS_GRAPHICS_CHAR_WIDTH,16
        pubabs  DEVCAPS_GRAPHICS_CHAR_HEIGHT,16
        pubabs  DEVCAPS_HORIZONTAL_FONT_RES,120
        pubabs  DEVCAPS_VERTICAL_FONT_RES,120
        pubabs  DEVCAPS_CHAR_WIDTH,8
        pubabs  DEVCAPS_CHAR_HEIGHT,14
        pubabs  DEVCAPS_SMALL_CHAR_WIDTH,8
        pubabs  DEVCAPS_SMALL_CHAR_HEIGHT,14
endif

        pubabs  SCREEN_CY,SCAN_CNT     ; Screen height in scans

        pubabs  INIT_POINTER_X,SCREEN_CX/2  ; Initial pointer x
        pubabs  INIT_POINTER_Y,SCREEN_CY/2  ; Initial pointer x

        pubabs  PATTERN_SCAN_UPDATE,(SIZE_PATTERN-1) * SCREEN_CBSCAN


        pubabs  COLOR_DONT_CARE,%((MM_ALL shl 8)+GRAF_CDC)

ifdef   CLR256
        pubabs  DEVCAPS_COLOR_INDEX,255
else
        pubabs  DEVCAPS_COLOR_INDEX,16
endif

;/*
;** This driver supports color pointer
;*/

CAPS_COLOR_POINTER_SUPPORT      equ     128
        pubabs  DEVCAPS_COLOR_POINTER_SUPPORT,%(CAPS_COLOR_POINTER_SUPPORT)

ifdef   CLR256
        pubabs  DEVCAPS_COLORS,256
        pubabs  DEF_IPC_FORE_CLR,%(ONES_OR_ZEROS SHL 8)        ; For 8bpp
        pubabs  DEF_IPC_BACK_CLR,%(((ONES_OR_ZEROS OR MONO_BIT) SHL 8) OR 0FFH)
else
        pubabs  DEVCAPS_COLORS,16
        pubabs  DEF_IPC_FORE_CLR,100000b        ; For ega
        pubabs  DEF_IPC_BACK_CLR,111111b        ; For ega
endif
        pubabs  DEVCAPS_HEIGHT_IN_CHARS,SCREEN_CY/DEVCAPS_CHAR_HEIGHT
        pubabs  DEVCAPS_WIDTH_IN_CHARS,SCREEN_CX/DEVCAPS_CHAR_WIDTH

        pubabs  IC_SDFB,<SD_DEVICE or SD_COLOR>

ifdef   CLR256
        pubabs  SCREEN_SDFB,<SD_DEVICE or SD_COLOR or SD_NONNULL or SD_HUGE>
else
        pubabs  SCREEN_SDFB,<SD_DEVICE or SD_COLOR or SD_NONNULL>
endif

PUBLIC  abPointerWork
PUBLIC  current_brush
PUBLIC  known_word
PUBLIC  saved_latches
PUBLIC  reserved_latches
PUBLIC  plane_index
PUBLIC  enable_test
PUBLIC  tonys_bar_n_grill

abScreenImage     EQU 0

if SCAN_CNT EQ 768
abPointerSave     EQU abScreenImage + (SCREEN_CBSCAN*(SCREEN_LPB-4))
else
abPointerSave     EQU abScreenImage + (SCREEN_CBSCAN*SCREEN_CY)
endif

abPointerWork     = abPointerSave + (SAVE_BUFFER_WIDTH*SAVE_BUFFER_HEIGHT)
current_brush     = abPointerWork + MASK_LENGTH
known_word        = current_brush + 8
saved_latches     = known_word    + 2
reserved_latches  = saved_latches + 1
plane_index       = reserved_latches + 1
enable_test       = plane_index   + 1
tonys_bar_n_grill = enable_test   + 1
shadowed_mode     = tonys_bar_n_grill + 1
SCREEN_CBRESERVED = shadowed_mode + 1

.CODE

;/*
;** Public functions
;*/

;/***************************************************************************
;*
;* FUNCTION NAME = device_specific_init
;*
;* DESCRIPTION   = Device Specific Initialization routine
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

device_specific_init PROC SYSCALL

ifndef JTUNE        ;IBMJ
        mov     gsspScreen.cb,BANK_SIZE
else  ;JTUNE        ;IBMJ
 mov gsspScreen.cb,20000h ; 128KB for memory mapped reg. access
endif ;JTUNE        ;IBMJ
        mov     gsspScreen.pPhysMem,0A0000h
        mov     gsspScreen.ulSize,sizeof GSSP

        mov     padBitmapFormats,OFFSET adBitmapFormats
        mov     adDevCapsData[CAPS_MARKER_HEIGHT*SIZE_DWORD],MAKEULONG(0,9)
        mov     adDevCapsData[CAPS_MARKER_WIDTH*SIZE_DWORD],MAKEULONG(0,9)

        CALL    CursorInit

ifdef   PALMGR2
EXTERN  FudgePalettesAndGenerateTables:NEAR

        CALL    FudgePalettesAndGenerateTables

endif

        mov     ecx,1
        ret
device_specific_init ENDP

;/***************************************************************************
;*
;* FUNCTION NAME =  device_specific_post_init
;*
;* DESCRIPTION   =  Post- initialization routine
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

device_specific_post_init PROC SYSCALL

;/*
;** Initialize the GSSP structure for the EGA
;*/


        mov     eax,0                             ;Success
        ret

device_specific_post_init ENDP


HUGE_FONT       equ     8000h                     ;!!! define this in pmddi*
FD_VECTOR       equ     0000000000000001B

end
