;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE     55,132
        TITLE    QueryAp
        SUBTITLE Header

;/*****************************************************************************
;*
;* SOURCE FILE NAME = QUERYAP.ASM
;*
;* DESCRIPTIVE NAME = Querys aperture info for DCR96.
;*
;*
;* VERSION      V2.0
;*
;* DATE         10/09/92
;*
;* DESCRIPTION
;*
;*
;*
;* FUNCTIONS    QueryApertureInfo
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/

        .386
        .MODEL FLAT,SYSCALL
        ASSUME  SS:FLAT, DS:FLAT, CS:FLAT, ES:FLAT

        .xlist
DINCL_ENABLE equ 1
DINCL_BITMAP equ 1
        include pmgre.inc
        include driver.inc
        include extern.inc
        .list

;/***************************************************************************
;*
;* FUNCTION NAME = QueryApertureInfo
;*
;* DESCRIPTION   = Returns following structure that edi points to -
;*         struct
;*         {
;*            LONG physical address of the aperture
;*            LONG size of aperture
;*            LONG size of scanline
;*            RECTL screen coordinates
;*         }
;* INPUT         = edi:PTR QUERYADAPTER
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/
           .CODE

QueryApertureInfo        PROTO SYSCALL
public QueryApertureInfo

QueryApertureInfo        PROC SYSCALL

        ASSUME  edi:PTR QUERYADAPTER

        mov     eax,gsspScreen.pPhysMem
        mov     [edi].ulApertureAddress,eax

        mov     [edi].ulApertureSize,10000h
        mov     [edi].ulScanlineSize,SCREEN_CBSCAN
        mov     [edi].Screen_xLeft,0
        mov     [edi].Screen_yTop,0

if SCAN_CNT EQ 480
        mov     [edi].Screen_xRight,639
        mov     [edi].Screen_yBottom,479
endif

if SCAN_CNT EQ 600
        mov     [edi].Screen_xRight,799
        mov     [edi].Screen_yBottom,599
endif

if SCAN_CNT EQ 768
        mov     [edi].Screen_xRight,1023
        mov     [edi].Screen_yBottom,767
endif

        ret
QueryApertureInfo        ENDP

END
