;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132

;/*****************************************************************************
;*
;* SOURCE FILE NAME = PALDATA.ASM
;*
;* DESCRIPTIVE NAME = Palette Management Data
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION  Palette Management Data
;*
;*
;* FUNCTIONS    NONE
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   07/09/93              69006  Update default color tables to match XGA
;*                                and 8514.
;*
;*****************************************************************************/


        .386
        .MODEL FLAT,SYSCALL
        ASSUME  SS:FLAT, DS:FLAT, CS:FLAT, ES:FLAT

        .xlist

INCL_DDIMISC            equ                      1
INCL_GRE_BITMAPS        equ                      1
INCL_GPIBITMAPS         equ                      1
INCL_GPILOGCOLORTABLE   equ                      1
INCL_GRE_PALETTE        equ                      1
INCL_GRE_COLORTABLE     equ                      1
INCL_DEV                equ                      1
INCL_DDICOMFLAGS        equ                      1
INCL_WINPALETTE         equ                      1
INCL_WINSYS             equ                      1
        include pmgre.inc
DINCL_ENABLE            equ                      1
DINCL_BITMAP            equ                      1
DINCL_CLR_TBL           equ                      1
        include driver.inc
        include extern.inc
        include protos.inc
        include assert.mac
        include palette.inc
        .list
.DATA

;/*
;** We must keep Palette Manager palettes, and Realizable Logical
;** Color Tables separate. The best way to ensure this is to have
;** them each write to their own version of what they think is the
;** hardware palette.  This works file if the RealizedLCTPalette is
;** only used when the app is full screen, foreground (which it
;** should be).
;*/

RealizedLCTPalette      RGB2 HW_PAL_SIZE DUP (<>)

;/*
;** Globals used to speed up nearest color searches when we have a
;** realized logical color table.
;*/

RealizedWhiteIndex      ULONG   ?
RealizedBlackIndex      ULONG   ?
ulLastSearched          ULONG   ?
ulIndexLastSearched     ULONG   ?

CurrentDestPalette      PVOID   ?
CurrentSourcePalette    PVOID   ?
CurrentMappingValid     BOOL    ?
;fRealizeSupported       BOOL    ?
ColorTableRealized      HDC     0

;/*
;/* Global constants used by the color functions.  cPhysicalColors is
;/* always the same as SizeOfHWPalette except at 16bpp when
;/* SizeOfHWPalette is not set up.  MaxLogColorIndex is always 255.
;/* This all seems a bit duff!
;*/
cPhysicalColors         ULONG   ?
SizeOfHWPalette         ULONG   ?
;MaxLogColorIndex        ULONG   ?

;/*
;** The following point to the default color tables that will be used
;** by OD_DIRECT and OD_MEMORY device contexts respectively. The
;** one for OD_MEMORY is initialized at start of day and should not
;** change. The OD_DIRECT will also be initialized at start of day but
;** will change as the device default palette is resized when HW slots
;** are allocated to palette manager palettes.
;*/

DefaultDirectLogicalColorTable  PCOLORTABLE     ?
DefaultMemoryLogicalColorTable  PCOLORTABLE     ?

;/*
;** The following point to the device default palettes that will be
;** used by OD_DIRECT and OD_MEMORY device contexts respectively.  The
;** one for OD_MEMORY is initialized at start of day and should not
;** change.  The OD_DIRECT will also be initialized at start of day
;** but will change as the device default palette is resized when HW
;** slots are allocated to palette manager palettes. The size of the
;** current direct dc device default palette is stored in
;** ulDirectDeviceDefaultPalette.
;*/

MemoryDeviceDefaultPalette      ULONG           ? ;RGB2
DirectDeviceDefaultPalette      ULONG           ? ;RGB2
ulDirectDeviceDefaultPaletteSize ULONG          ?

ifdef PDP

;/*
;** plasma panel status (set during FillPdb
;*/

plasma_status   BOOL      0; 
endif ;/* PDP */

;/*
;** The 256 entry palette is the same as the default 8514 palette.
;**
;** The structure is as follows:
;**
;** The middle 32 entries form an increasing grey scale.
;** The colours are the entries 0-111 and 144-255.
;** The order of the colour entries is:
;**     for each Red value in the group       00,2B,55,80,AA,D5,FF
;**       for each Green value in the group   00,24,49,6D,92,B6,DB,FF
;**         for each Blue value in the group  00,55,AA,FF
;**           RGB is Red,Green,Blue
;**         endfor
;**       endfor
;**     endfor
;**
;*/

        public FullSizeDeviceDefaultPalette
FullSizeDeviceDefaultPalette LABEL RGB2

;/*
;** start off with the first half of the colors
;*/


;FORMAT IS flags:Red:Green:Blue
DWORD   080000000h, 080000055h, 0800000AAh, 0800000FFh,
        080002400h, 080002455h, 0800024AAh, 0800024FFh,
        080004900h, 080004955h, 0800049AAh, 0800049FFh,
        080006D00h, 080006D55h, 080006DAAh, 080006DFFh,
        080009200h, 080009255h, 0800092AAh, 0800092FFh,
        08000B600h, 08000B655h, 08000B6AAh, 08000B6FFh,
        08000DB00h, 08000DB55h, 08000DBAAh, 08000DBFFh,
        08000FF00h, 08000FF55h, 08000FFAAh, 08000FFFFh,

DWORD   0802B0000h, 0802B0055h, 0802B00AAh, 0802B00FFh,
        0802B2400h, 0802B2455h, 0802B24AAh, 0802B24FFh,
        0802B4900h, 0802B4955h, 0802B49AAh, 0802B49FFh,
        0802B6D00h, 0802B6D55h, 0802B6DAAh, 0802B6DFFh,
        0802B9200h, 0802B9255h, 0802B92AAh, 0802B92FFh,
        0802BB600h, 0802BB655h, 0802BB6AAh, 0802BB6FFh,
        0802BDB00h, 0802BDB55h, 0802BDBAAh, 0802BDBFFh,
        0802BFF00h, 0802BFF55h, 0802BFFAAh, 0802BFFFFh,

DWORD   080550000h, 080550055h, 0805500AAh, 0805500FFh,
        080552400h, 080552455h, 0805524AAh, 0805524FFh,
        080554900h, 080554955h, 0805549AAh, 0805549FFh,
        080556D00h, 080556D55h, 080556DAAh, 080556DFFh,
        080559200h, 080559255h, 0805592AAh, 0805592FFh,
        08055B600h, 08055B655h, 08055B6AAh, 08055B6FFh,
        08055DB00h, 08055DB55h, 08055DBAAh, 08055DBFFh,
        08055FF00h, 08055FF55h, 08055FFAAh, 08055FFFFh,

DWORD   080800000h, 080800055h, 0808000AAh, 0808000FFh,
        080802400h, 080802455h, 0808024AAh, 0808024FFh,
        080804900h, 080804955h, 0808049AAh, 0808049FFh,
        080806D00h, 080806D55h, 080806DAAh, 080806DFFh,

;/*
;** now come the group of 32 greys
;*/

DWORD   080080808h, 0800F0F0Fh, 080171717h, 0801F1F1Fh,
        080272727h, 0802E2E2Eh, 080363636h, 0803E3E3Eh,
        080464646h, 0804D4D4Dh, 080555555h, 0805D5D5Dh,
        080646464h, 0806C6C6Ch, 080747474h, 0807C7C7Ch,
        080838383h, 0808B8B8Bh, 080939393h, 0809B9B9Bh,
        080A2A2A2h, 080AAAAAAh, 080B2B2B2h, 080B9B9B9h,
        080C1C1C1h, 080C9C9C9h, 080D1D1D1h, 080D8D8D8h,
        080E0E0E0h, 080E8E8E8h, 080F0F0F0h, 080F7F7F7h,

;/*
;** now back to the colours again
;*/

DWORD   080809200h, 080809255h, 0808092AAh, 0808092FFh,
        08080B600h, 08080B655h, 08080B6AAh, 08080B6FFh,
        08080DB00h, 08080DB55h, 08080DBAAh, 08080DBFFh,
        08080FF00h, 08080FF55h, 08080FFAAh, 08080FFFFh,

DWORD   080AA0000h, 080AA0055h, 080AA00AAh, 080AA00FFh,
        080AA2400h, 080AA2455h, 080AA24AAh, 080AA24FFh,
        080AA4900h, 080AA4955h, 080AA49AAh, 080AA49FFh,
        080AA6D00h, 080AA6D55h, 080AA6DAAh, 080AA6DFFh,
        080AA9200h, 080AA9255h, 080AA92AAh, 080AA92FFh,
        080AAB600h, 080AAB655h, 080AAB6AAh, 080AAB6FFh,
        080AADB00h, 080AADB55h, 080AADBAAh, 080AADBFFh,
        080AAFF00h, 080AAFF55h, 080AAFFAAh, 080AAFFFFh,

DWORD   080D50000h, 080D50055h, 080D500AAh, 080D500FFh,
        080D52400h, 080D52455h, 080D524AAh, 080D524FFh,
        080D54900h, 080D54955h, 080D549AAh, 080D549FFh,
        080D56D00h, 080D56D55h, 080D56DAAh, 080D56DFFh,
        080D59200h, 080D59255h, 080D592AAh, 080D592FFh,
        080D5B600h, 080D5B655h, 080D5B6AAh, 080D5B6FFh,
        080D5DB00h, 080D5DB55h, 080D5DBAAh, 080D5DBFFh,
        080D5FF00h, 080D5FF55h, 080D5FFAAh, 080D5FFFFh,

DWORD   080FF0000h, 080FF0055h, 080FF00AAh, 080FF00FFh,
        080FF2400h, 080FF2455h, 080FF24AAh, 080FF24FFh,
        080FF4900h, 080FF4955h, 080FF49AAh, 080FF49FFh,
        080FF6D00h, 080FF6D55h, 080FF6DAAh, 080FF6DFFh,
        080FF9200h, 080FF9255h, 080FF92AAh, 080FF92FFh,
        080FFB600h, 080FFB655h, 080FFB6AAh, 080FFB6FFh,
        080FFDB00h, 080FFDB55h, 080FFDBAAh, 080FFDBFFh,
        080FFFF00h, 080FFFF55h, 080FFFFAAh, 080FFFFFFh,

;/*
;** The 128 entry palette has the following structure:
;**
;** The middle 8 entries form an increasing grey scale.
;** The colours are the entries 0-59 and 68-127.
;** The order of the colour entries is:
;**     for each Red value in the group       00,40,80,C0,FF
;**       for each Green value in the group   00,33,66,99,CC,FF
;**         for each Blue value in the group  00,55,AA,FF
;**           RGB is Red,Green,Blue
;**         endfor
;**       endfor
;**     endfor
;**
;*/
        public Reduced128DeviceDefaultPalette
Reduced128DeviceDefaultPalette LABEL RGB2

;/*
;** start off with the first half of the colors
;*/

DWORD   080000000h, 080000055h, 0800000AAh, 0800000FFh,
        080003300h, 080003355h, 0800033AAh, 0800033FFh,
        080006600h, 080006655h, 0800066AAh, 0800066FFh,
        080009900h, 080009955h, 0800099AAh, 0800099FFh,
        08000CC00h, 08000CC55h, 08000CCAAh, 08000CCFFh,
        08000FF00h, 08000FF55h, 08000FFAAh, 08000FFFFh,

DWORD   080400000h, 080400055h, 0804000AAh, 0804000FFh,
        080403300h, 080403355h, 0804033AAh, 0804033FFh,
        080406600h, 080406655h, 0804066AAh, 0804066FFh,
        080409900h, 080409955h, 0804099AAh, 0804099FFh,
        08040CC00h, 08040CC55h, 08040CCAAh, 08040CCFFh,
        08040FF00h, 08040FF55h, 08040FFAAh, 08040FFFFh,

DWORD   080800000h, 080800055h, 0808000AAh, 0808000FFh,
        080803300h, 080803355h, 0808033AAh, 0808033FFh,
        080806600h, 080806655h, 0808066AAh, 0808066FFh,

;/*
;** now the 8 gray scales
;*/

DWORD   0801C1C1Ch, 080383838h, 080545454h, 080707070h,
        0808C8C8Ch, 080A8A8A8h, 080C4C4C4h, 080E0E0E0h,

;/*
;** now the last half of the colors
;*/

DWORD   080809900h, 080809955h, 0808099AAh, 0808099FFh,
        08080CC00h, 08080CC55h, 08080CCAAh, 08080CCFFh,
        08080FF00h, 08080FF55h, 08080FFAAh, 08080FFFFh,

DWORD   080C00000h, 080C00055h, 080C000AAh, 080C000FFh,
        080C03300h, 080C03355h, 080C033AAh, 080C033FFh,
        080C06600h, 080C06655h, 080C066AAh, 080C066FFh,
        080C09900h, 080C09955h, 080C099AAh, 080C099FFh,
        080C0CC00h, 080C0CC55h, 080C0CCAAh, 080C0CCFFh,
        080C0FF00h, 080C0FF55h, 080C0FFAAh, 080C0FFFFh,

DWORD   080FF0000h, 080FF0055h, 080FF00AAh, 080FF00FFh,
        080FF3300h, 080FF3355h, 080FF33AAh, 080FF33FFh,
        080FF6600h, 080FF6655h, 080FF66AAh, 080FF66FFh,
        080FF9900h, 080FF9955h, 080FF99AAh, 080FF99FFh,
        080FFCC00h, 080FFCC55h, 080FFCCAAh, 080FFCCFFh,
        080FFFF00h, 080FFFF55h, 080FFFFAAh, 080FFFFFFh

;/*
;** The 64 entry palette has the following structure:
;**
;** The middle 4 entries form an increasing grey scale.
;** The colours are the entries 0-29 and 34-63.
;** The order of the colour entries is:
;**     for each Red value in the group       00,55,AA,FF
;**       for each Green value in the group   00,40,80,C0,FF
;**         for each Blue value in the group  00,80,FF
;**           RGB is Red,Green,Blue
;**         endfor
;**       endfor
;**     endfor
;**
;*/

        public Reduced64DeviceDefaultPalette
Reduced64DeviceDefaultPalette LABEL RGB2

;/*
;** start off with the first half of the colors
;*/
DWORD   080000000h, 080000080h, 0800000FFh,
        080004000h, 080004080h, 0800040FFh,
        080008000h, 080008080h, 0800080FFh,
        08000C000h, 08000C080h, 08000C0FFh,
        08000FF00h, 08000FF80h, 08000FFFFh,

DWORD   080550000h, 080550080h, 0805500FFh,
        080554000h, 080554080h, 0805540FFh,
        080558000h, 080558080h, 0805580FFh,
        08055C000h, 08055C080h, 08055C0FFh,
        08055FF00h, 08055FF80h, 08055FFFFh,

;/*
;** now the 4 gray scales (these are the same as 4 of the
;** grays in the 32 entry palette).
;*/

DWORD   080555555h, 080808080h, 080A6A6A6h, 080CCCCCCh,

;/*
;** now the last half of the colors
;*/

DWORD   080AA0000h, 080AA0080h, 080AA00FFh,
        080AA4000h, 080AA4080h, 080AA40FFh,
        080AA8000h, 080AA8080h, 080AA80FFh,
        080AAC000h, 080AAC080h, 080AAC0FFh,
        080AAFF00h, 080AAFF80h, 080AAFFFFh,

DWORD   080FF0000h, 080FF0080h, 080FF00FFh,
        080FF4000h, 080FF4080h, 080FF40FFh,
        080FF8000h, 080FF8080h, 080FF80FFh,
        080FFC000h, 080FFC080h, 080FFC0FFh,
        080FFFF00h, 080FFFF80h, 080FFFFFFh

;/*
;** The 32 entry palette is the is similar to the default VGA palette
;** in terms of its structure in that it is based around RxGxBxLevel.
;** The default VGA palette (16 entries) is 2x2x2x2. Here we will use
;** a 2x2x2x4 structure. Because the all the entires of the 16 entry
;** palette are incorporated into this palette then the change from
;** one to the other should be less horrible! The greys chosen here
;** are designed to fit in with the ones in the 16 entry palette (and
;** are the same ones also used in the 64 entry palette).
;*/

public Reduced32DeviceDefaultPalette
Reduced32DeviceDefaultPalette LABEL RGB2
DWORD           080000000h     ;/* black           0 */

DWORD           080000040h     ;/* very dark blue  1 */
DWORD           080004000h     ;/* very dark green   */
DWORD           080004040h     ;/* very dark cyan    */
DWORD           080400000h     ;/* very dark red     */
DWORD           080400040h     ;/* very dark magenta */
DWORD           080404000h     ;/* very dark yellow  */

DWORD           080000080h     ;/* dark blue       7 */
DWORD           080008000h     ;/* dark green        */
DWORD           080008080h     ;/* dark cyan         */
DWORD           080800000h     ;/* dark red          */
DWORD           080800080h     ;/* dark magenta      */
DWORD           080808000h     ;/* dark yellow       */

DWORD           0802B2B2Bh     ;/* very dark gray 13 */
DWORD           080555555h     ;/* dark gray         */
DWORD           080808080h     ;/* gray              */
DWORD           080A6A6A6h     ;/* quite light gray  */
DWORD           080CCCCCCh     ;/* light gray        */
DWORD           080E0E0E0h     ;/* very light gray   */

DWORD           0800000C0h     ;/* light blue     19 */
DWORD           08000C000h     ;/* light green       */
DWORD           08000C0C0h     ;/* light cyan        */
DWORD           080C00000h     ;/* light red         */
DWORD           080C000C0h     ;/* light magenta     */
DWORD           080C0C000h     ;/* light yellow      */

DWORD           0800000FFh     ;/* blue           25 */
DWORD           08000FF00h     ;/* green             */
DWORD           08000FFFFh     ;/* cyan              */
DWORD           080FF0000h     ;/* red               */
DWORD           080FF00FFh     ;/* magenta           */
DWORD           080FFFF00h     ;/* yellow            */

DWORD           080FFFFFFh     ;/* white          31 */

;/*
;** Under palette manager the default device palette is 256 entries
;** (the default 8514 palette). As HW palette slots are allocated to
;** palett manager logical palettes the device default palette is
;** reduced in size in stages of 128, 64, 32, and down to a minimum
;** size of 16 entries.  The result of mixes is not "what is expected"
;** in most cases, with the exception that inverses always come out as
;** the expected color.  These palettes are defined here in the
;** following arrays of RGB2 values (actually we use ULONGs to make
;** initialization easier).  Note that the fcOptions field is set to
;** PC_DEFAULT (0x80).  At 4 bits per pel the default palette is the
;** Reduced16DeviceDefaultPalette.
;**
;** If any of the palettes below are changed then the following
;** functions must also be changed:
;**      ExactLogicalIndexFromRGB
;*/

;/*
;** The 16 entry palette is the same as the default VGA palette.
;*/

public Reduced16DeviceDefaultPalette
Reduced16DeviceDefaultPalette LABEL RGB2
DWORD           080000000h     ;/* black        0 */
DWORD           080000080h     ;/* dark blue      */
DWORD           080008000h     ;/* dark green     */
DWORD           080008080h     ;/* dark cyan      */
DWORD           080800000h     ;/* dark red       */
DWORD           080800080h     ;/* purple         */
DWORD           080808000h     ;/* mustard        */
DWORD           080808080h     ;/* gray         7 */
DWORD           080CCCCCCh     ;/* light gray   8 */
DWORD           0800000FFh     ;/* blue           */
DWORD           08000FF00h     ;/* green          */
DWORD           08000FFFFh     ;/* cyan           */
DWORD           080FF0000h     ;/* red            */
DWORD           080FF00FFh     ;/* magenta        */
DWORD           080FFFF00h     ;/* yellow         */
DWORD           080FFFFFFh     ;/* white       15 */

;/*
;** The following tables conatin the RGB values of the default logical
;** color tables - these are always the same, but the indexes into the
;** palette differ depending on the bits per pel and the size of the
;** current device default palette.  For OD_MEMORY devices we will
;** always use the full size device default palette.  For OD_DIRECT
;** the size of the palette may change at eight bits per pel as HW
;** palette slots are allocated to palette manager palettes.  (This is
;** why there are the 5 different versions of the eight bit per pel
;** logical color table each of which corresponds to one of the
;** palettes defined above).
;*/

public DefaultEightBppTable16
DefaultEightBppTable16 LABEL COLORTABLETYPE

;/*
;**                 blue  green red  flags
;*/

COLORTABLETYPE  < < 0FFh, 0FFh, 0FFh, 0 > , 255 > ;/* Background   */
COLORTABLETYPE  < < 0FFh, 000h, 000h, 0 > , 249 > ;/* Blue         */
COLORTABLETYPE  < < 000h, 000h, 0FFh, 0 > , 252 > ;/* Red          */
COLORTABLETYPE  < < 0FFh, 000h, 0FFh, 0 > , 253 > ;/* Magenta      */
COLORTABLETYPE  < < 000h, 0FFh, 000h, 0 > , 250 > ;/* Green        */
COLORTABLETYPE  < < 0FFh, 0FFh, 000h, 0 > , 251 > ;/* Cyan         */
COLORTABLETYPE  < < 000h, 0FFh, 0FFh, 0 > , 254 > ;/* Yellow       */
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > ,   0 > ;/* Neutral      */
COLORTABLETYPE  < < 080h, 080h, 080h, 0 > ,   7 > ;/* Dark grey    */
COLORTABLETYPE  < < 080h, 000h, 000h, 0 > ,   1 > ;/* Dark blue    */
COLORTABLETYPE  < < 000h, 000h, 080h, 0 > ,   4 > ;/* Dark red     */
COLORTABLETYPE  < < 080h, 000h, 080h, 0 > ,   5 > ;/* Dark magenta */
COLORTABLETYPE  < < 000h, 080h, 000h, 0 > ,   2 > ;/* Dark green   */
COLORTABLETYPE  < < 080h, 080h, 000h, 0 > ,   3 > ;/* Dark cyan    */
COLORTABLETYPE  < < 000h, 080h, 080h, 0 > ,   6 > ;/* Brown        */
COLORTABLETYPE  < < 0CCh, 0CCh, 0CCh, 0 > , 248 > ;/* Light grey   */

public DefaultEightBppTable32
DefaultEightBppTable32 LABEL COLORTABLETYPE

;/*
;**                 blue  green red  flags
;*/

COLORTABLETYPE  < < 0FFh, 0FFh, 0FFh, 0 > , 255 > ;/* Background   */
COLORTABLETYPE  < < 0FFh, 000h, 000h, 0 > , 249 > ;/* Blue         */
COLORTABLETYPE  < < 000h, 000h, 0FFh, 0 > , 252 > ;/* Red          */
COLORTABLETYPE  < < 0FFh, 000h, 0FFh, 0 > , 253 > ;/* Magenta      */
COLORTABLETYPE  < < 000h, 0FFh, 000h, 0 > , 250 > ;/* Green        */
COLORTABLETYPE  < < 0FFh, 0FFh, 000h, 0 > , 251 > ;/* Cyan         */
COLORTABLETYPE  < < 000h, 0FFh, 0FFh, 0 > , 254 > ;/* Yellow       */
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > ,   0 > ;/* Neutral      */
COLORTABLETYPE  < < 080h, 080h, 080h, 0 > ,  14 > ;/* Dark grey    */
COLORTABLETYPE  < < 080h, 000h, 000h, 0 > ,   7 > ;/* Dark blue    */
COLORTABLETYPE  < < 000h, 000h, 080h, 0 > ,  10 > ;/* Dark red     */
COLORTABLETYPE  < < 080h, 000h, 080h, 0 > ,  11 > ;/* Dark magenta */
COLORTABLETYPE  < < 000h, 080h, 000h, 0 > ,   8 > ;/* Dark green   */
COLORTABLETYPE  < < 080h, 080h, 000h, 0 > ,   9 > ;/* Dark cyan    */
COLORTABLETYPE  < < 000h, 080h, 080h, 0 > ,  12 > ;/* Brown        */
COLORTABLETYPE  < < 0CCh, 0CCh, 0CCh, 0 > , 241 > ;/* Light grey   */

public DefaultEightBppTable64
DefaultEightBppTable64 LABEL COLORTABLETYPE
;/*
;**                 blue  green red  flags
;*/
COLORTABLETYPE  < < 0FFh, 0FFh, 0FFh, 0 > , 255 > ;/* Background   */
COLORTABLETYPE  < < 0FFh, 000h, 000h, 0 > ,   2 > ;/* Blue         */
COLORTABLETYPE  < < 000h, 000h, 0FFh, 0 > , 242 > ;/* Red          */
COLORTABLETYPE  < < 0FFh, 000h, 0FFh, 0 > , 244 > ;/* Magenta      */
COLORTABLETYPE  < < 000h, 0FFh, 000h, 0 > ,  12 > ;/* Green        */
COLORTABLETYPE  < < 0FFh, 0FFh, 000h, 0 > ,  14 > ;/* Cyan         */
COLORTABLETYPE  < < 000h, 0FFh, 0FFh, 0 > , 253 > ;/* Yellow       */
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > ,   0 > ;/* Neutral      */
COLORTABLETYPE  < < 080h, 080h, 080h, 0 > ,  31 > ;/* Dark grey    */
COLORTABLETYPE  < < 080h, 000h, 000h, 0 > ,   1 > ;/* Dark blue    */
COLORTABLETYPE  < < 000h, 000h, 080h, 0 > , 226 > ;/* Dark red     */
COLORTABLETYPE  < < 080h, 000h, 080h, 0 > , 227 > ;/* Dark magenta */
COLORTABLETYPE  < < 000h, 080h, 000h, 0 > ,   6 > ;/* Dark green   */
COLORTABLETYPE  < < 080h, 080h, 000h, 0 > ,   7 > ;/* Dark cyan    */
COLORTABLETYPE  < < 000h, 080h, 080h, 0 > , 232 > ;/* Brown        */
COLORTABLETYPE  < < 0CCh, 0CCh, 0CCh, 0 > , 225 > ;/* Light grey   */

public DefaultEightBppTable128
DefaultEightBppTable128 LABEL COLORTABLETYPE
;/*
;**                 blue  green red  flags
;*/
COLORTABLETYPE  < < 0FFh, 0FFh, 0FFh, 0 > , 255 > ;/* Background   */
COLORTABLETYPE  < < 0FFh, 000h, 000h, 0 > ,   3 > ;/* Blue         */
COLORTABLETYPE  < < 000h, 000h, 0FFh, 0 > , 232 > ;/* Red          */
COLORTABLETYPE  < < 0FFh, 000h, 0FFh, 0 > , 235 > ;/* Magenta      */
COLORTABLETYPE  < < 000h, 0FFh, 000h, 0 > ,  20 > ;/* Green        */
COLORTABLETYPE  < < 0FFh, 0FFh, 000h, 0 > ,  23 > ;/* Cyan         */
COLORTABLETYPE  < < 000h, 0FFh, 0FFh, 0 > , 252 > ;/* Yellow       */
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > ,   0 > ;/* Neutral      */
COLORTABLETYPE  < < 080h, 080h, 080h, 0 > ,  64 > ;/* Dark grey    */
COLORTABLETYPE  < < 080h, 000h, 000h, 0 > ,   2 > ;/* Dark blue    */
COLORTABLETYPE  < < 000h, 000h, 080h, 0 > ,  48 > ;/* Dark red     */
COLORTABLETYPE  < < 080h, 000h, 080h, 0 > ,  50 > ;/* Dark magenta */
COLORTABLETYPE  < < 000h, 080h, 000h, 0 > ,  12 > ;/* Dark green   */
COLORTABLETYPE  < < 080h, 080h, 000h, 0 > ,  14 > ;/* Dark cyan    */
COLORTABLETYPE  < < 000h, 080h, 080h, 0 > , 196 > ;/* Brown        */
COLORTABLETYPE  < < 0CCh, 0CCh, 0CCh, 0 > ,  66 > ;/* Light grey   */

public DefaultEightBppTable256
DefaultEightBppTable256 LABEL COLORTABLETYPE
;/*
;**                 blue  green red  flags
;*/
COLORTABLETYPE  < < 0FFh, 0FFh, 0FFh, 0 > , 255 > ;/* Background   */
COLORTABLETYPE  < < 0FFh, 000h, 000h, 0 > ,   3 > ;/* Blue         */
COLORTABLETYPE  < < 000h, 000h, 0FFh, 0 > , 224 > ;/* Red          */
COLORTABLETYPE  < < 0FFh, 000h, 0FFh, 0 > , 227 > ;/* Magenta      */
COLORTABLETYPE  < < 000h, 0FFh, 000h, 0 > ,  28 > ;/* Green        */
COLORTABLETYPE  < < 0FFh, 0FFh, 000h, 0 > ,  31 > ;/* Cyan         */
COLORTABLETYPE  < < 000h, 0FFh, 0FFh, 0 > , 252 > ;/* Yellow       */
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > ,   0 > ;/* Neutral      */
;                          < < 080h, 080h, 080h, 0 > , 128 > ;/* Dark grey    */
COLORTABLETYPE  < < 083h, 083h, 083h, 0 > , 128 > ;/* Dark grey    */           
;                          < < 080h, 000h, 000h, 0 > ,   2 > ;/* Dark blue    */
COLORTABLETYPE  < < 0AAh, 000h, 000h, 0 > ,   2 > ;/* Dark blue    */           
COLORTABLETYPE  < < 000h, 000h, 080h, 0 > ,  96 > ;/* Dark red     */
;                          < < 080h, 000h, 080h, 0 > ,  98 > ;/* Dark magenta */
COLORTABLETYPE  < < 0AAh, 000h, 080h, 0 > ,  98 > ;/* Dark magenta */           
;                          < < 000h, 080h, 000h, 0 > ,  16 > ;/* Dark green   */
COLORTABLETYPE  < < 000h, 092h, 000h, 0 > ,  16 > ;/* Dark green   */           
;                          < < 080h, 080h, 000h, 0 > ,  18 > ;/* Dark cyan    */
COLORTABLETYPE  < < 0AAh, 092h, 000h, 0 > ,  18 > ;/* Dark cyan    */           
;                          < < 000h, 080h, 080h, 0 > , 144 > ;/* Brown        */
COLORTABLETYPE  < < 000h, 092h, 080h, 0 > , 144 > ;/* Brown        */           
;                          < < 0CCh, 0CCh, 0CCh, 0 > , 138 > ;/* Light grey   */
COLORTABLETYPE  < < 0C9h, 0C9h, 0C9h, 0 > , 138 > ;/* Light grey   */           

;/*
;** The special colors table contains the RGB and physical indices for
;** negative logical indices - ie both special colors and system
;** colors. There are two versions of the table (one for memory DCs
;** and one for direct DCs) because the screen may have a different
;** device default palette than memory DCs (because of HW slots being
;** allocated to palette manager palettes).
;** The entry in the table x is for logical color (-x).
;*/

public DirectSpecialColorTable
DirectSpecialColorTable LABEL COLORTABLETYPE
;/*
;**                 blue  green red  flags
;*/
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > , CLR_NOPHYINDEX > ;zeroth entry
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > , 0              > ;CLR_BLACK
COLORTABLETYPE  < < 0FFh, 0FFh, 0FFh, 0 > , 255            > ;CLR_WHITE
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > , CLR_NOPHYINDEX > ;CLR_DEFAULT
COLORTABLETYPE  < < 0FFh, 0FFh, 0FFh, 0 > , 255            > ;CLR_TRUE
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > , 0              > ;CLR_FALSE
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > , CLR_NOPHYINDEX > ;(-6) invalid
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > , CLR_NOPHYINDEX > ;(-7) invalid
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > , CLR_NOPHYINDEX > ;(-8) invalid
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > , CLR_NOPHYINDEX > ;(-9) invalid
COLORTABLETYPE  (SPECIAL_COL_TAB_SIZE-10) DUP (<>)

;/* the remaining entries are set using CreateLogColorTable by PM */

public MemorySpecialColorTable
MemorySpecialColorTable LABEL COLORTABLETYPE
;/*
;**                 blue  green red  flags
;*/
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > , CLR_NOPHYINDEX > ;zeroth entry
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > , 0              > ;CLR_BLACK
COLORTABLETYPE  < < 0FFh, 0FFh, 0FFh, 0 > , 255            > ;CLR_WHITE
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > , CLR_NOPHYINDEX > ;CLR_DEFAULT
COLORTABLETYPE  < < 0FFh, 0FFh, 0FFh, 0 > , 255            > ;CLR_TRUE
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > , 0              > ;CLR_FALSE
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > , CLR_NOPHYINDEX > ;(-6) invalid
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > , CLR_NOPHYINDEX > ;(-7) invalid
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > , CLR_NOPHYINDEX > ;(-8) invalid
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > , CLR_NOPHYINDEX > ;(-9) invalid
COLORTABLETYPE  (SPECIAL_COL_TAB_SIZE-10) DUP (<>)

;/*
;** the remaining entries are set using CreateLogColorTable by PM
;*/

public DefaultFourBppTable
DefaultFourBppTable LABEL COLORTABLETYPE
;/*
;**                 blue  green red  flags
;*/
COLORTABLETYPE  < < 0FFh, 0FFh, 0FFh, 0 > , 15 > ;Background
COLORTABLETYPE  < < 0FFh, 000h, 000h, 0 > ,  9 > ;Blue
COLORTABLETYPE  < < 000h, 000h, 0FFh, 0 > , 12 > ;Red
COLORTABLETYPE  < < 0FFh, 000h, 0FFh, 0 > , 13 > ;Magenta
COLORTABLETYPE  < < 000h, 0FFh, 000h, 0 > , 10 > ;Green
COLORTABLETYPE  < < 0FFh, 0FFh, 000h, 0 > , 11 > ;Cyan
COLORTABLETYPE  < < 000h, 0FFh, 0FFh, 0 > , 14 > ;Yellow
COLORTABLETYPE  < < 000h, 000h, 000h, 0 > ,  0 > ;Neutral
COLORTABLETYPE  < < 080h, 080h, 080h, 0 > ,  7 > ;Dark grey
COLORTABLETYPE  < < 080h, 000h, 000h, 0 > ,  1 > ;Dark blue
COLORTABLETYPE  < < 000h, 000h, 080h, 0 > ,  4 > ;Dark red
COLORTABLETYPE  < < 080h, 000h, 080h, 0 > ,  5 > ;Dark magenta
COLORTABLETYPE  < < 000h, 080h, 000h, 0 > ,  2 > ;Dark green
COLORTABLETYPE  < < 080h, 080h, 000h, 0 > ,  3 > ;Dark cyan
COLORTABLETYPE  < < 000h, 080h, 080h, 0 > ,  6 > ;Brown
COLORTABLETYPE  < < 0CCh, 0CCh, 0CCh, 0 > ,  8 > ;Light grey



;/*
;** We need ready setup RGB2 values for black and white.
;*/

RGBWhite        RGB2    <0ffh, 0ffh, 0ffh, 0h>
RGBBlack        RGB2    <000h, 000h, 000h, 0h>


;/*
;** The AVIO Color Table contains the RGB values of the default
;** AVIO palette used for both foreground and background colours.
;*/

public  AVIOColorTable
AVIOColorTable LABEL RGB2

;/*
;**    blue  green red  options
;*/
db      000h, 000h, 000h, 000h              ; Black              */
db      080h, 000h, 000h, 000h              ; Dark blue          */
db      000h, 080h, 000h, 000h              ; Dark green         */
db      080h, 080h, 000h, 000h              ; Dark cyan          */
db      000h, 000h, 080h, 000h              ; Dark red           */
db      080h, 000h, 080h, 000h              ; Dark magenta       */
db      000h, 080h, 080h, 000h              ; Brown              */
db      0CCh, 0CCh, 0CCh, 000h              ; Light grey         */
db      080h, 080h, 080h, 000h              ; Dark grey          */
db      0FFh, 000h, 000h, 000h              ; Blue               */
db      000h, 0FFh, 000h, 000h              ; Green              */
db      0FFh, 0FFh, 000h, 000h              ; Cyan               */
db      000h, 000h, 0FFh, 000h              ; Red                */
db      0FFh, 000h, 0FFh, 000h              ; Magenta            */
db      000h, 0FFh, 0FFh, 000h              ; Yellow             */
db      0FFh, 0FFh, 0FFh, 000h              ; White              */


;/*
;** AVIOXlate tables translate from the VIO colour to the physical
;** index.  This info is filled in at boot time for the 256 color
;** table, and as required for the other tables.  Setting the first
;** entry to CLR_NOPHYINDEX marks the table as not yet setup.
;*/

public pAVIOColorXlate
pAVIOColorXlate                                  ULONG  ? ;RGB2

public AVIOXlate256
AVIOXlate256    dd      AVIO_PALETTE_SIZE        dup (CLR_NOPHYINDEX)

public AVIOXlate128
AVIOXlate128    dd      AVIO_PALETTE_SIZE        dup (CLR_NOPHYINDEX)

public AVIOXlate64
AVIOXlate64     dd      AVIO_PALETTE_SIZE        dup (CLR_NOPHYINDEX)

public AVIOXlate32
AVIOXlate32     dd      AVIO_PALETTE_SIZE        dup (CLR_NOPHYINDEX)

public AVIOXlate16
AVIOXlate16     dd      AVIO_PALETTE_SIZE        dup (CLR_NOPHYINDEX)


        END

