;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = PACKING.ASM
;*
;* DESCRIPTIVE NAME = DCAF packed/planar conversion code.
;*
;*
;* VERSION      V2.0
;*
;* DATE         04/30/92
;*
;* DESCRIPTION
;*             These routines convert VGA 4bpp data between packed
;*             and planar formats.
;*
;* FUNCTIONS   PackBuffer
;*             UnPackBuffer
;*
;* NOTES       NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   04/30/92                     Created for DCAF 1.3
;*   08/01/92                     Converted to 32-bit for DCAF 2.0
;*
;*****************************************************************************/
;/*
;** The pack table converts a 4 bit index into a 2 byte value holding
;** the same 4 bits spaced one per nibble.
;** The words are byte swapped, so that we can write them out using a
;** word write, but still get them in Motorola order.
;*/
;/*
;** The unpack table is split into 2 halves as we access it using
;** words.
;** The table again takes a 4 bit value, and returns the bits spaced 1 per
;** bytes.
;*/
                                ; This is the low word table
                                ;                 |
                                ;                 v
                                ; This is the high word table
                                ;            |
                                ;            v
;--------------------------Internal-Routine-----------------------------;
;/*********************************************************************
;* PackBuffer                                                         *
;*                                                                    *
;* This routine performs the planar to packed conversion.             *
;* It picks up the planar data directly from VRAM                     *
;*                                                                    *
;**********************************************************************
;*
;* Entry:
;*       None
;* Returns:
;*       None
;* Error Returns:
;*       None
;* Registers Preserved:
;*       16 bit  SI,DI,BP,DS,ES
;*       32 bit  ESI,EDI,EBX,EBP,DS,ES,FS,GS
;* Registers Destroyed:
;*       16 bit  AX,BX,CX,DX,FLAGS
;*       32 bit  EAX,ECX,EDX,FLAGS
;* History:
;*
;* Thur-30-Apr-1992       -by-    Mark Berry
;*     Wrote it.
;**********************************************************************/
;/*
;** This code assumes that the no of pels is a multiple of 8
;*/
;/*
;** Initialize the locals which provide our fast path route
;** NB. 0,0,0,0 is the packed version of 0,0,0,0 planar !
;*/
;/*
;** Because the pels are held in planes format, we have to read each
;** plane separately and then combine the planes to produce packed pels.
;** Each read will actually get 8 pels worth of information, so when
;** we've finished all four planes we will have 8 packed pels available.
;*/
;/*
;** Get the first plane
;*/
;/*
;** And the second plane
;*/
;/*
;** The third plane
;*/
;/*
;** The final plane
;*/
;/*
;** bx:cx now holds 8 planar pels.
;*/
;/*
;** Check if these 8 pels are the same as the last pels we
;** packed.
;** cmp mem, reg is faster than cmp reg, mem !
;*/
;/*
;** Save these for our fast path next time
;*/
;/*
;**
;** Looks like we really have to pack these pels!
;**
;** The planes data now needs to be packed, which basically involves
;** taking the four bits (one for each plane) of a pel and ORing them
;** together so that plane 3 ends up in the leftmost position and
;** plane 0 ends up in the rightmost position.
;*/
;/*
;** This is done 4 pels at a time using the PackTable
;*/
;/*
;** Now move the planes into dx:cx as required.
;*/
;/*
;** Register usage
;**   esi           points at PackTable
;**   bx            work register used to index PackTable
;**   dx:cx         planar data (unpacked pels)
;**   eax           working reg (holding up to 4 packed pels)
;**   di            used to store the first 4 packed pels
;*/
                                   ; (ie zero bh in the process)
                                   ; ready for the next plane to be ORed in
                                   ; the table and OR it with plane 3
                                   ; ready for the next plane to be ORed in
;/*
;** Save this value
;*/
;/*
;** Note we only shifted by 3 rather than by 4 because we actually
;** want the nibble value * 2 as a word index into a table.
;** Because they are nibbles, they can't overflow the byte when
;** multiplied by 2
;*/
;/*
;** At this point we have the pels in ax:di
;**
;** pel  7  6  5  4  3  2  1  0
;**       al    ah :     di
;** Save these pels in the packed buffer.
;*/
;--------------------------Internal-Routine-----------------------------;
;/*********************************************************************
;* UnPackBuffer                                                       *
;*                                                                    *
;* This routine performs the packed to planar conversion.             *
;* It puts the planar data into a memory planar arrangement.          *
;*                                                                    *
;**********************************************************************
;
; Entry:
;       None
; Returns:
;       None
; Error Returns:
;       None
; Registers Preserved:
;       16 bit  SI,DI,BP,DS,ES
;       32 bit  ESI,EDI,EBX,EBP,DS,ES,FS,GS
; Registers Destroyed:
;       16 bit  AX,BX,CX,DX,FLAGS
;       32 bit  EAX,ECX,EDX,FLAGS
; History:
;
; Thur-30-Apr-1992       -by-    Mark Berry
;     Wrote it.
;*********************************************************************/
;/*
;** This code assumes that the no of pels is a multiple of 8
;*/
;/*
;** 16 bit version of the code - converted to 32-bit.
;*/
;/*
;** Initialize the locals which provide our fast path route
;** NB. 0,0,0,0 is the packed version of 0,0,0,0 planar !
;*/
;/*
;** Get 8 packed pels
;*/
;/*
;** Check if these 8 bytes are the same as the last bytes we
;** unpacked.
;** cmp mem, reg is faster than cmp reg, mem !
;*/
        ; Save these for our fast path next time
;/*
;** The packed pels are in cx:pels0to3
;**
;** pel  7  6  5  4  3  2  1  0
;**       cl    ch : pels0to3
;*/
;/*
;** Register usage:
;**   bx            work register
;**   dx:ax         unpacked pels
;**   cx:pels0to3   packed pels
;*/
;/*
;** At this point we have the pels in dx:ax
;*/
;/*
;** Save these pels in the planar form
;*/

end
