;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = FUDGEPAL.ASM
;*
;* DESCRIPTIVE NAME = Fudge the WIN-OS2 palette
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION  Routines to calculate mappings and reorganise the 5 default
;*              palettes to put the         system colors in the right place
;*              for seamless.
;*
;* FUNCTIONS    NearestPaletteEntry
;*              FudgePaletteAndGenerateTable
;*              FudgeColorTable
;*              FudgePalettesAndGenerateTables
;*              FudgeDitherPattern
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/

        .386
        .MODEL FLAT,SYSCALL
        ASSUME  SS:FLAT, DS:FLAT, CS:FLAT, ES:FLAT

        .xlist

INCL_DDIMISC            equ                      1
INCL_GRE_BITMAPS        equ                      1
INCL_GPIBITMAPS         equ                      1
INCL_GPILOGCOLORTABLE   equ                      1
INCL_GRE_PALETTE        equ                      1
INCL_GRE_COLORTABLE     equ                      1
INCL_DEV                equ                      1
INCL_DDICOMFLAGS        equ                      1
INCL_WINPALETTE         equ                      1
INCL_WINSYS             equ                      1
        include pmgre.inc
DINCL_ENABLE    equ     1
DINCL_BITMAP            equ                      1
DINCL_CLR_TBL           equ                      1
        include driver.inc
        include extern.inc
        include protos.inc
        include assert.mac
        include palette.inc
        .list

SWAP_BYTE MACRO arg1,arg2
        mov     al,BYTE PTR arg1
        xchg    al,BYTE PTR arg2
        mov     BYTE PTR arg1,al
ENDM
SWAP_DWORD MACRO arg1,arg2
        mov     eax,DWORD PTR arg1
        xchg    eax,DWORD PTR arg2
        mov     DWORD PTR arg1,eax
ENDM

.DATA

PaletteFudgeTable256    BYTE    256     DUP(?)
PaletteFudgeTable128    BYTE    128     DUP(?)
PaletteFudgeTable64     BYTE    64      DUP(?)
PaletteFudgeTable32     BYTE    32      DUP(?)
PaletteFudgeTable16     BYTE    16      DUP(?)

PUBLIC  WindowsDefaultSysColors
WindowsDefaultSysColors LABEL RGB2
DWORD   080000000h,     ;/* Black   */
        080800000h,     ;/* Red     */
        080008000h,     ;/* Green   */
        080808000h,     ;/* Yellow  */

DWORD   080000080h,     ;/* Blue    */
        080800080h,     ;/* Magenta */
        080008080h,     ;/* Cyan    */
        080C0C0C0h,     ;/* Grey    */

;DWORD   080AAFF80h,
;        080AAC0FFh,
;        080E0E0E0h,
;        080A6A6A6h,

DWORD   080C0DCC0h,     ;/* These are the 4 wierd window 3.1 colors */
        080A6CAF0h,
        080FFFBF0h,
        080A0A0A4h,

DWORD   080808080h,
        080FF0000h,
        08000FF00h,
        080FFFF00h,

DWORD   0800000FFh,
        080FF00FFh,
        08000FFFFh,
        080FFFFFFh      ;/* White   */


.CODE

FudgePaletteAndGenerateTable PROTO SYSCALL,
        Palette :PTR RGB2,
        Table   :PBYTE,
        ulSize  :ULONG

FudgeColorTable PROTO SYSCALL,
        ColTable        :PTR COLORTABLETYPE,
        Palette         :PTR RGB2,
        ulSize          :ULONG


;/***************************************************************************
;*
;* FUNCTION NAME = NearestPaletteEntry
;*
;* DESCRIPTION   = Return closest match in palette for input color.
;*
;* INPUT         = NONE
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

NearestPaletteEntry PROC SYSCALL USES ECX EDX EBX ESI,
        RGBColor        :RGB2,
        Palette         :PTR RGB2,
        ulSize          :ULONG

;/*
;**{
;**    ULONG   i;
;**    ULONG   ulBestDiff;
;**    ULONG   ulNearestIndex;
;**
;**    ulBestDiff=0xFFFFFFFF;
;*/

        mov     edx,0FFFFFFFFh

;/*
;**    for (i=0; i<ulSize; i++)
;*/

        mov     ecx,0
        mov     ebx,Palette
        jmp     loop_entry
loop_top:

;/*
;**    {
;**        if (rgb2_diff(RGBColor, Palette[i]) < ulBestDiff)
;*/

        INVOKE  rgb2_diff,
                RGBColor,
                RGB2 PTR [ebx+ecx*sizeof RGB2]

        cmp     eax,edx
        jae     next

;/*
;**        {
;**            ulBestDiff = rgb2_diff(RGBColor, Palette[i]);
;*/

        mov     edx,eax

;/*
;**            ulNearestIndex = i;
;*/

        mov     esi,ecx
next:

;/*
;**        }
;*/

        inc     ecx
loop_entry:
        cmp     ecx,ulSize
        jb      loop_top

;/*
;**    }
;**
;**    return(ulNearestIndex);
;*/

        mov     eax,esi
        ret

;/*
;** }
;*/

NearestPaletteEntry ENDP


;/***************************************************************************
;*
;* FUNCTION NAME = FudgePaletteAndGenerateTable
;*
;* DESCRIPTION   = Adjusts the input palette and formats a table into
;*                 the input table pointer.
;*
;* INPUT         = Palette :PTR RGB2,
;*                 Table   :PBYTE,
;*                 ulSize  :ULONG
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

FudgePaletteAndGenerateTable PROC SYSCALL USES ESI EDI EBX,
        Palette :PTR RGB2,
        Table   :PBYTE,
        ulSize  :ULONG

LOCAL   InverseTable[256]    :BYTE,
        i                    :ULONG,
        ulNearestIndex       :ULONG


;/*
;** First set up a linear mapping table so that we can call our
;** nearest match color routines for the non-fudged palette.
;*/

        mov     ecx,0
        mov     edi,Table
        lea     esi,InverseTable
        mov     ebx,Palette
        jmp     loop1_entry
loop1_top:

;/*
;**    for (i=0; i<ulSize; i++)
;**    {
;**        Table[i] = (BYTE)i;
;*/

        mov     [edi+ecx],cl

;/*
;**        InverseTable[i] = (BYTE)i;
;*/

        mov     [esi+ecx],cl
        inc     ecx
loop1_entry:
        cmp     ecx,ulSize
        jb      loop1_top

;/*
;**    }
;**
;**    for (i=0; i<8; i++)
;*/

        mov     ecx,0
loop2_top:

;/*
;**    {
;**        bNearestIndex = (BYTE)NearestPaletteEntry(
;**                            *((PTR RGB2)&WindowsDefaultSysColors[i]),
;**                            &Palette[i],
;**                            ulSize-i)+i;
;*/

        mov     edx,ulSize

        sub     edx,ecx         ; @DMS just a simple bug

        INVOKE  NearestPaletteEntry,
                WindowsDefaultSysColors[ecx*sizeof RGB2],
                ADDR [ebx+ecx*sizeof RGB2],
                edx
        add     eax,ecx

;/*
;**        /**************************************************************/
;**        /* Convert from 0..256 range to 0..ulSize.                    */
;**        /**************************************************************/
;**        if (bNearestIndex>=128)
;*/

        cmp     eax,128
        jb      @F

;/*
;**        {
;**            bNearestIndex = (BYTE)(bNearestIndex-256+ulSize);
;*/

        sub     eax,256
        add     eax,ulSize
@@:

;/*
;**        }
;*/

        mov     edx,eax
        assert  edx,BE,0FFh
        mov     ulNearestIndex,edx

;/*
;**        RGBSwap = Palette[i];
;**        Palette[i] = Palette[bNearestIndex];
;**        Palette[bNearestIndex] = RGBSwap;
;*/

        SWAP_DWORD      <[ebx+ecx*sizeof RGB2]>,<[ebx+edx*sizeof RGB2]>

;/*
;**        bIndexSwap = InverseTable[i];
;**        InverseTable[i] = InverseTable[bNearestIndex];
;**        InverseTable[bNearestIndex] = bIndexSwap;
;*/


        SWAP_BYTE       <[esi+ecx]>,<[esi+edx]>

;/*
;**        Table[InverseTable[i]]=(BYTE)i;
;*/

        mov     eax,0
        mov     al,[esi+ecx]
        mov     [edi+eax],cl

;/*
;**        Table[InverseTable[bNearestIndex]]=bNearestIndex;
;*/

        mov     al,[esi+edx]
        mov     [edi+eax],dl

        inc     ecx
        cmp     ecx,8
        jb      loop2_top

;/*
;**    }
;**
;**    for (i=19; i>11; i--)
;*/

        mov     ecx,19
loop3_top:

;/*
;**    {
;**        bNearestIndex = (BYTE)NearestPaletteEntry(
;**                            *((PTR RGB2)&WindowsDefaultSysColors[i]),
;**                            &Palette[8],
;**                            ulSize-27+i)+8;
;*/

        mov     edx,ulSize
        sub     edx,27
        add     edx,ecx

        INVOKE  NearestPaletteEntry,
                WindowsDefaultSysColors[ecx*sizeof RGB2],
                ADDR [ebx+8*sizeof RGB2],
                edx
        add     eax,8

;/*
;**        /**************************************************************/
;**        /* Convert from 0..256 range to 0..ulSize.                    */
;**        /**************************************************************/
;**        if (bNearestIndex>=128)
;*/

        cmp     eax,128
        jb      @F

;/*
;**        {
;**            bNearestIndex = (BYTE)(bNearestIndex-256+ulSize);
;*/

        sub     eax,256
        add     eax,ulSize
@@:

;/*
;**        }
;*/

        mov     edi,eax
        mov     ulNearestIndex,edi

;/*
;**        RGBSwap = Palette[ulSize-20+i];
;**        Palette[ulSize-20+i] = Palette[bNearestIndex];
;**        Palette[bNearestIndex] = RGBSwap;
;*/

        mov     edx,ulSize
        sub     edx,20
        add     edx,ecx
        SWAP_DWORD      <[ebx+edi*sizeof RGB2]>,<[ebx+edx*sizeof RGB2]>

;/*
;**        bIndexSwap = InverseTable[ulSize-20+i];
;**        InverseTable[ulSize-20+i] = InverseTable[bNearestIndex];
;**        InverseTable[bNearestIndex] = bIndexSwap;
;*/

        SWAP_BYTE       <[esi+edi]>,<[esi+edx]>

        mov     edi,Table

;/*
;**        Table[InverseTable[ulSize-20+i]]=(BYTE)(ulSize-20+i);
;*/

        mov     eax,0
        mov     al,[esi+edx]
        mov     [edi+eax],dl

;/*
;**        Table[InverseTable[bNearestIndex]]=bNearestIndex;
;*/

        mov     edx,ulNearestIndex
        mov     al,[esi+edx]
        mov     [edi+eax],dl

        dec     ecx
        cmp     ecx,11
        ja      loop3_top

;/*
;**    }
;**
;**    if (ulSize>16)
;*/

        cmp     ulSize,16
        jbe     not_g16

;/*
;**    {
;**        for (i=8; i<10; i++)
;*/

        mov     ecx,8
loop4_top:

;/*
;**        {
;**            bNearestIndex = (BYTE)NearestPaletteEntry(
;**                                *((PTR RGB2)&WindowsDefaultSysColors[i]),
;**                                &Palette[i],
;**                                ulSize-i)+i;
;**
;*/

        mov     edx,ulSize
        sub     edx,ecx

        INVOKE  NearestPaletteEntry,
                WindowsDefaultSysColors[ecx*sizeof RGB2],
                ADDR [ebx+ecx*sizeof RGB2],
                edx
        add     eax,ecx

;/*
;**            /**************************************************************/
;**            /* Convert from 0..256 range to 0..ulSize.                    */
;**            /**************************************************************/
;**            if (bNearestIndex>=128)
;*/

        cmp     eax,128
        jb      @F

;/*
;**            {
;**                bNearestIndex = (BYTE)(bNearestIndex-256+ulSize);
;*/

        sub     eax,256
        add     eax,ulSize
@@:
        mov     edx,eax
        mov     ulNearestIndex,edx

;/*
;**            }
;**
;**            RGBSwap = Palette[i];
;**            Palette[i] = Palette[bNearestIndex];
;**            Palette[bNearestIndex] = RGBSwap;
;*/

        SWAP_DWORD      <[ebx+ecx*sizeof RGB2]>,<[ebx+edx*sizeof RGB2]>

;/*
;**            bIndexSwap = InverseTable[i];
;**            InverseTable[i] = InverseTable[bNearestIndex];
;**            InverseTable[bNearestIndex] = bIndexSwap;
;*/

        SWAP_BYTE       <[esi+ecx]>,<[esi+edx]>

;/*
;**            Table[InverseTable[i]]=(BYTE)i;
;*/

        mov     eax,0
        mov     al,[esi+ecx]
        mov     [edi+eax],cl

;/*
;**            Table[InverseTable[bNearestIndex]]=bNearestIndex;
;*/

        mov     al,[esi+edx]
        mov     [edi+eax],dl

        inc     ecx
        cmp     ecx,10
        jb      loop4_top

;/*
;**        }
;**
;**        for (i=11; i>9; i--)
;*/

        mov     ecx,11
loop5_top:

;/*
;**        {
;**            bNearestIndex = (BYTE)NearestPaletteEntry(
;**                                *((PTR RGB2)&WindowsDefaultSysColors[i]),
;**                                &Palette[10],
;**                                ulSize-27+i)+10;
;**
;*/

        mov     edx,ulSize
        sub     edx,27
        add     edx,ecx

        INVOKE  NearestPaletteEntry,
                WindowsDefaultSysColors[ecx*sizeof RGB2],
                ADDR [ebx+10*sizeof RGB2],
                edx
        add     eax,10

;/*
;**            /**************************************************************/
;**            /* Convert from 0..256 range to 0..ulSize.                    */
;**            /**************************************************************/
;**            if (bNearestIndex>=128)
;*/

        cmp     eax,128
        jb      @F

;/*
;**            {
;**                bNearestIndex = (BYTE)(bNearestIndex-256+ulSize);
;*/

        sub     eax,256
        add     eax,ulSize
@@:
        mov     edi,eax
        mov     ulNearestIndex,edi

;/*
;**            }
;**
;**            RGBSwap = Palette[ulSize-20+i];
;**            Palette[ulSize-20+i] = Palette[bNearestIndex];
;**            Palette[bNearestIndex] = RGBSwap;
;*/

        mov     edx,ulSize
        sub     edx,20
        add     edx,ecx
        SWAP_DWORD      <[ebx+edi*sizeof RGB2]>,<[ebx+edx*sizeof RGB2]>

;/*
;**            bIndexSwap = InverseTable[ulSize-20+i];
;**            InverseTable[ulSize-20+i] = InverseTable[bNearestIndex];
;**            InverseTable[bNearestIndex] = bIndexSwap;
;*/

        SWAP_BYTE       <[esi+edi]>,<[esi+edx]>

        mov     edi,Table

;/*
;**            Table[InverseTable[ulSize-20+i]]=(BYTE)(ulSize-20+i);
;*/

        mov     eax,0
        mov     al,[esi+edx]
        mov     [edi+eax],dl

;/*
;**            Table[InverseTable[bNearestIndex]]=bNearestIndex;
;*/

        mov     edx,ulNearestIndex
        mov     al,[esi+edx]
        mov     [edi+eax],dl

        dec     ecx
        cmp     ecx,9
        ja      loop5_top

;/*
;**        }
;*/

not_g16:

;/*
;**    }
;** }
;*/

        ret
FudgePaletteAndGenerateTable ENDP


;/***************************************************************************
;*
;* FUNCTION NAME = FudgeColorTable
;*
;* DESCRIPTION   = Adjusts the WIN-OS2 color table
;*
;* INPUT         = ColTable:PTR COLORTABLETYPE
;*                 Palette :PTR RGB2
;*                 ulSize  :ULONG
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

FudgeColorTable PROC SYSCALL USES EDI,
        ColTable        :PTR COLORTABLETYPE,
        Palette         :PTR RGB2,
        ulSize          :ULONG

;/*
;** {
;**    ULONG   i;
;**    ULONG   ulNewIndex;
;*/


        mov     edi,ColTable
        mov     edx,ulSize
        shr     edx,1

;/*
;**    for (i=0; i<DFLT_LOG_COL_TABLE_SIZE; i++)
;*/

        mov     ecx,0
        .ERRE   DFLT_LOG_COL_TABLE_SIZE
loop_top:

;/*
;**    {
;**        ulNewIndex = NearestPaletteEntry(ColTable[i].LogRGB, Palette, ulSize);
;*/

        INVOKE  NearestPaletteEntry,
                [edi+ecx*sizeof COLORTABLETYPE].COLORTABLETYPE.LogRGB,
                Palette,
                ulSize


;/*
;**        if (ulNewIndex >= (ulSize/2))
;*/

        cmp     eax,edx
        jb      no_change

;/*
;**        {
;**            ulNewIndex = ulNewIndex+256-ulSize;
;*/

        add     eax,256
        sub     eax,ulSize
no_change:

;/*
;**        }
;**
;**        ColTable[i].PhyIndex = ulNewIndex;
;*/

        mov     [edi+ecx*sizeof COLORTABLETYPE].COLORTABLETYPE.PhyIndex,eax

;/*
;**    }
;*/

        inc     ecx
loop_entry:
        cmp     ecx,DFLT_LOG_COL_TABLE_SIZE
        jb      loop_top
        ret

FudgeColorTable ENDP



;/***************************************************************************
;*
;* FUNCTION NAME = FudgePalettesAndGenerateTables
;*
;* DESCRIPTION   = Adjusts the palette and formats a table
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

FudgePalettesAndGenerateTables PROC SYSCALL

;/*
;**{
;**    FudgePaletteAndGenerateTable(FullSizeDeviceDefaultPalette,
;**                                 PaletteFudgeTable256,
;**                                 256);
;*/

        INVOKE  FudgePaletteAndGenerateTable,
                ADDR FullSizeDeviceDefaultPalette,
                ADDR PaletteFudgeTable256,
                256

;/*
;**    FudgePaletteAndGenerateTable(Reduced128DeviceDefaultPalette,
;**                                 PaletteFudgeTable128,
;**                                 128);
;*/


        INVOKE  FudgePaletteAndGenerateTable,
                ADDR Reduced128DeviceDefaultPalette,
                ADDR PaletteFudgeTable128,
                128

;/*
;**    FudgePaletteAndGenerateTable(Reduced64DeviceDefaultPalette,
;**                                 PaletteFudgeTable64,
;**                                 64);
;*/

        INVOKE  FudgePaletteAndGenerateTable,
                ADDR Reduced64DeviceDefaultPalette,
                ADDR PaletteFudgeTable64,
                64

;/*
;**    FudgePaletteAndGenerateTable(Reduced32DeviceDefaultPalette,
;**                                 PaletteFudgeTable32,
;**                                 32);
;*/

        INVOKE  FudgePaletteAndGenerateTable,
                ADDR Reduced32DeviceDefaultPalette,
                ADDR PaletteFudgeTable32,
                32

;/*
;**    FudgePaletteAndGenerateTable(Reduced16DeviceDefaultPalette,
;**                                 PaletteFudgeTable16,
;**                                 16);
;*/

        INVOKE  FudgePaletteAndGenerateTable,
                ADDR Reduced16DeviceDefaultPalette,
                ADDR PaletteFudgeTable16,
                16

;/*
;**    FudgeColorTable(DefaultEightBppTable256,
;**                    FullSizeDeviceDefaultPalette,
;**                    256);
;*/

        INVOKE  FudgeColorTable,
                ADDR DefaultEightBppTable256,
                ADDR FullSizeDeviceDefaultPalette,
                256

;/*
;**    FudgeColorTable(DefaultEightBppTable128,
;**                    Reduced128DeviceDefaultPalette,
;**                    128);
;*/

        INVOKE  FudgeColorTable,
                ADDR DefaultEightBppTable128,
                ADDR Reduced128DeviceDefaultPalette,
                128

;/*
;**    FudgeColorTable(DefaultEightBppTable64,
;**                    Reduced64DeviceDefaultPalette,
;**                    64);
;*/

        INVOKE  FudgeColorTable,
                ADDR DefaultEightBppTable64,
                ADDR Reduced64DeviceDefaultPalette,
                64

;/*
;**    FudgeColorTable(DefaultEightBppTable32,
;**                    Reduced32DeviceDefaultPalette,
;**                    32);
;*/

        INVOKE  FudgeColorTable,
                ADDR DefaultEightBppTable32,
                ADDR Reduced32DeviceDefaultPalette,
                32

;/*
;**    FudgeColorTable(DefaultEightBppTable16,
;**                    Reduced16DeviceDefaultPalette,
;**                    16);
;*/

        INVOKE  FudgeColorTable,
                ADDR DefaultEightBppTable16,
                ADDR Reduced16DeviceDefaultPalette,
                16

;/*
;**
;**    FudgeColorTable(DefaultFourBppTable,
;**                    Reduced16DeviceDefaultPalette,
;**                    16);
;**
;** }
;*/

        ret
FudgePalettesAndGenerateTables ENDP

;/***************************************************************************
;*
;* FUNCTION NAME = FudgeDitherPattern
;*
;* DESCRIPTION   = Adjusts a WIN-OS2 dither pattern.
;*
;* INPUT         = Entry ESI -> ddc
;*                       EDI -> Dither Pattern
;*                       ECX # bytes in dither pattern
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

FudgeDitherPattern PROC SYSCALL USES ESI EDI EBX


        mov     edx,256
        test    [esi].DDC.ddc_fb,DDC_DEVICE
        jz      not_device
        mov     edx,ulDirectDeviceDefaultPaletteSize

not_device:

;/*
;**    switch (ulPaletteSize)
;**    {
;**        case 256:
;**            TranslateTable = PaletteFudgeTable256;
;**            break;
;**
;*/

        cmp     edx,256
        jne     @F
        lea     esi,PaletteFudgeTable256
        jmp     end_switch

;/*
;**        case 128:
;**            TranslateTable = PaletteFudgeTable128;
;**            break;
;**
;*/

@@:     cmp     edx,128
        jne     @F
        lea     esi,PaletteFudgeTable128
        jmp     end_switch

;/*
;**        case 64:
;**            TranslateTable = PaletteFudgeTable64;
;**            break;
;**
;*/

@@:     cmp     edx,64
        jne     @F
        lea     esi,PaletteFudgeTable64
        jmp     end_switch

;/*
;**        case 32:
;**            TranslateTable = PaletteFudgeTable32;
;**            break;
;**
;*/

@@:     cmp     edx,32
        jne     @F
        lea     esi,PaletteFudgeTable32
        jmp     end_switch

;/*
;**        case 16:
;**            TranslateTable = PaletteFudgeTable16;
;**            break;
;**
;*/

@@:     cmp     edx,16
        jne     @F
        lea     esi,PaletteFudgeTable16
        jmp     end_switch
ifdef FIREWALLS

;/*
;**        default:
;**            haltproc();
;**            ulPaletteSize = 256;
;**            TranslateTable = PaletteFudgeTable256;
;*/

@@:
        mov     edx,256
        lea     esi,PaletteFudgeTable256
endif

;/*
;**    }
;*/

@@:
end_switch:

;/*
;**    for (y=0; y<DITHMATRIX_YSIZE; y++)
;*/

        mov     eax,0
        mov     ebx,edx
        shr     ebx,1
loop_top:

;/*
;**    {
;**        for (x=0; x<DITHMATRIX_XSIZE; x++)
;**        {
;**            /**********************************************************/
;**            /* Get the existing physical index for this entry in the  */
;**            /* dither matrix.  (At 8bpp this will be a range from     */
;**            /* 0 to 255).                                             */
;**            /**********************************************************/
;**            bOldPhyIndex = ColorPat[x][y];
;*/

        mov     al,BYTE PTR[edi]

;/*
;**            /**********************************************************/
;**            /* Convert from 0 to 255 range to 0 to ulPaletteSize      */
;**            /* range and use the translation tables to obtain a new   */
;**            /* physical index (also in the 0 to ulPaletteSize range). */
;**            /**********************************************************/
;**            if (bOldPhyIndex>=128)
;*/

        cmp     al,128
        jb      do_else

;/*            {
;**                bNewPhyIndex = TranslateTable[bOldPhyIndex-256+ulPaletteSize];
;*/

        add     eax,edx
        sub     eax,256
        jmp     endif1

;/*
;**            }
;**            else
;*/

do_else:

;/*
;**            {
;**                bNewPhyIndex = TranslateTable[bOldPhyIndex];
;**            }
;*/

endif1:
                movzx   eax,BYTE PTR [esi+eax]

;/*
;**            /**********************************************************/
;**            /* If we are at 8bpp then we must convert our index to    */
;**            /* the 0 to 256 palette range.                            */
;**            /**********************************************************/
;**            if ((DDT.BitCount==8) && (bNewPhyIndex>=(BYTE)(ulPaletteSize/2)))
;*/

                cmp     al,bl
                jb      endif2

;/*
;**            {
;**                bNewPhyIndex += (BYTE)(256-ulPaletteSize);
;*/

                add     eax,256
                sub     eax,edx

;/*
;**            }
;*/

endif2:

;/*
;**            /**********************************************************/
;**            /* Put the new physical index into the dither matrix.     */
;**            /**********************************************************/
;**            ColorPat[x][y] = bNewPhyIndex;
;*/

        mov     BYTE PTR[edi],al
        inc     edi
        dec     ecx
        jnz     loop_top

;/*
;**        }
;**    }
;** }
;*/

        ret
FudgeDitherPattern ENDP
END
