;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = EGAMEM.INC
;*
;* DESCRIPTIVE NAME = EGA Memory utilization structure
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION  EGA Memory utilization structure
;*
;*
;*
;*
;*
;* FUNCTIONS
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/

;/*
;** The following structure defines the utilization of video memory for the
;** VGA adapter.  Use is made of the free (non-displayed) video RAM for
;** certain working data.  This has the following benefits:
;**
;**    1. Advantage can be taken of the video adapter hardware's ability to
;**       perform logical operations on the data.
;**
;**    2. Memory read/writes can be performed on up to four bytes (all planes)
;**       at a time.
;**
;**    3. Otherwise wasted memory is utilized.
;*/

ifdef EGAMEM_IS_STRUCT
EGAMem  STRUCT
   abScreenImage     BYTE (SCREEN_CBSCAN*SCREEN_CY) dup (?)
   abPointerSave     BYTE (SAVE_BUFFER_WIDTH*SAVE_BUFFER_HEIGHT) dup (?)
   abPointerWork     BYTE MASK_LENGTH dup (?)
   current_brush     BYTE 8 dup (?)
   known_word        WORD ?
   saved_latches     BYTE ?
   reserved_latches  BYTE ?
   plane_index       BYTE ?
   enable_test       BYTE ?
   tonys_bar_n_grill BYTE ?
EGAMem  ENDS

SCREEN_CBRESERVED EQU sizeof EGAMem
else

endif

