;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = DISPLAY.INC
;*
;* DESCRIPTIVE NAME = OEM defined objects used by the driver
;*
;*
;* VERSION      V2.0
;*
;* DATE         02/17/87
;*
;* DESCRIPTION  This file contains definitions of OEM defined objects used by
;*              the driver.
;*
;*
;* FUNCTIONS    NONE
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   02/17/87                     Written by Walt Moore
;*
;*****************************************************************************/

;/*
;**       The color structure is how this driver stores its physical
;**       colors in memory.  The color consists of two bytes, a
;**       byte which is a combination of one bit from each plane, plus
;**       other special information, and a second byte which indicates
;**       whether or not the color information is valid.
;**
;**       IPC = Internal Physical Color
;*/


IPC2            struct
ipc_bClr        db      ?                         ;color information
ipc_bStatus     db      ?                         ;validity status of ipc_bClr
IPC2            ends

;/*
;**       Definitions for the ipc_bClr byte of the physical color
;**
;**       Some of these definitions have limitations as to when they
;**       are valid.  They are as follows:
;**
;**       C0_BIT          color device, phys color, solid brushes if SOLID_COLOR
;**       C1_BIT          color device, phys color, solid brushes if SOLID_COLOR
;**       C2_BIT          color device, phys color, solid brushes if SOLID_COLOR
;**       C3_BIT          color device, phys color, solid brushes if SOLID_COLOR
;**       MONO_BIT        mono  device, phys color
;**       ONES_OR_ZEROS   color device, phys color, solid brushes if SOLID_COLOR
;*/

C0_BIT          equ     00000001b                ;  C0 color
C1_BIT          equ     00000010b                ;  C1 color
C2_BIT          equ     00000100b                ;  C2 color
C3_BIT          equ     00001000b                ;  C3 color
C4_BIT          equ     00010000b                ;  C4 color
C5_BIT          equ     00100000b                ;  C5 color
C6_BIT          equ     01000000b                ;  C6 color
C7_BIT          equ     10000000b                ;  C7 color
MM_ALL          equ     C0_BIT + C1_BIT + C2_BIT + C3_BIT + C4_BIT + C5_BIT + C6_BIT + C7_BIT ; See EGA.INC
MONO_BIT        equ     00000001b                ;  Monochrome bit
ONES_OR_ZEROS   equ     00000010b                ;  Color is really all 1's or all 0's

        .errnz  (sizeof IPC) - 2                 ;Must be a word

;/*
;**       Height and width in pels of one color plane of physical brush.
;*/

PATTERN_WIDTH   equ     8
PATTERN_HEIGHT  equ     8

;/*
;**       IPB = Internal Physical Brush
;*/

IPB             struc
ipb_abPlane0    db      (PATTERN_WIDTH*PATTERN_HEIGHT) dup (?)
IPB             ends


;/*
;** single pass flag
;*/

SINGLE_OK       equ     1

        BANK_SIZE EQU   00010000h       ;64k
