;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = C256TO16.INC
;*
;* DESCRIPTIVE NAME = Fixed 256 color to 16 color convert table
;*
;*
;* VERSION      V2.0
;*
;* DATE         
;*
;* DESCRIPTION   This file is included by compress.asm
;*
;* FUNCTIONS    NONE
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/

PACKED_BLACK           EQU      0
PACKED_DARK_BLUE       EQU      1
PACKED_DARK_GREEN      EQU      2
PACKED_DARK_CYAN       EQU      3
PACKED_DARK_RED        EQU      4
PACKED_DARK_PURPLE     EQU      5
PACKED_DARK_YELLOW     EQU      6
PACKED_DARK_GRAY       EQU      7
PACKED_LIGHT_GRAY      EQU      8
PACKED_LIGHT_BLUE      EQU      9
PACKED_LIGHT_GREEN     EQU     10
PACKED_LIGHT_CYAN      EQU     11
PACKED_LIGHT_RED       EQU     12
PACKED_LIGHT_PURPLE    EQU     13
PACKED_LIGHT_YELLOW    EQU     14
PACKED_WHITE           EQU     15

PUBLIC Packed256toPacked16Table
Packed256toPacked16Table LABEL BYTE 

;                  <16 INDEX>              <xxRRGGBB>   <No.>
        BYTE       PACKED_BLACK           ;080000000h     0
        BYTE       PACKED_BLACK           ;080000055h     1
        BYTE       PACKED_DARK_BLUE       ;0800000AAh     2
        BYTE       PACKED_LIGHT_BLUE      ;0800000FFh     3
        BYTE       PACKED_BLACK           ;080002400h     4
        BYTE       PACKED_BLACK           ;080002455h     5
        BYTE       PACKED_DARK_BLUE       ;0800024AAh     6
        BYTE       PACKED_LIGHT_BLUE      ;0800024FFh     7
        BYTE       PACKED_DARK_GREEN      ;080004900h     8
        BYTE       PACKED_DARK_CYAN       ;080004955h     9
        BYTE       PACKED_DARK_BLUE       ;0800049AAh     A
        BYTE       PACKED_LIGHT_BLUE      ;0800049FFh     B
        BYTE       PACKED_DARK_GREEN      ;080006D00h     C
        BYTE       PACKED_DARK_GREEN      ;080006D55h     D
        BYTE       PACKED_DARK_CYAN       ;080006DAAh     E
        BYTE       PACKED_LIGHT_BLUE      ;080006DFFh     F
        BYTE       PACKED_DARK_GREEN      ;080009200h    10
        BYTE       PACKED_DARK_GREEN      ;080009255h    11
        BYTE       PACKED_DARK_CYAN       ;0800092AAh    12
        BYTE       PACKED_LIGHT_BLUE      ;0800092FFh    13
        BYTE       PACKED_LIGHT_GREEN     ;08000B600h    14
        BYTE       PACKED_LIGHT_GREEN     ;08000B655h    15
        BYTE       PACKED_LIGHT_CYAN      ;08000B6AAh    16
        BYTE       PACKED_LIGHT_CYAN      ;08000B6FFh    17
        BYTE       PACKED_LIGHT_GREEN     ;08000DB00h    18
        BYTE       PACKED_LIGHT_GREEN     ;08000DB55h    19
        BYTE       PACKED_LIGHT_CYAN      ;08000DBAAh    1A
        BYTE       PACKED_LIGHT_CYAN      ;08000DBFFh    1B
        BYTE       PACKED_LIGHT_GREEN     ;08000FF00h    1C
        BYTE       PACKED_LIGHT_GREEN     ;08000FF55h    1D
        BYTE       PACKED_LIGHT_GREEN     ;08000FFAAh    1E
        BYTE       PACKED_LIGHT_CYAN      ;08000FFFFh    1F

        BYTE       PACKED_BLACK           ;0802B0000h    20
        BYTE       PACKED_DARK_BLUE       ;0802B0055h    21
        BYTE       PACKED_DARK_BLUE       ;0802B00AAh    22
        BYTE       PACKED_LIGHT_BLUE      ;0802B00FFh    23
        BYTE       PACKED_BLACK           ;0802B2400h    24
        BYTE       PACKED_BLACK           ;0802B2455h    25
        BYTE       PACKED_DARK_BLUE       ;0802B24AAh    26
        BYTE       PACKED_LIGHT_BLUE      ;0802B24FFh    27
        BYTE       PACKED_DARK_GREEN      ;0802B4900h    28
        BYTE       PACKED_DARK_GREEN      ;0802B4955h    29
        BYTE       PACKED_DARK_BLUE       ;0802B49AAh    2A
        BYTE       PACKED_LIGHT_BLUE      ;0802B49FFh    2B
        BYTE       PACKED_DARK_GREEN      ;0802B6D00h    2C
        BYTE       PACKED_DARK_GREEN      ;0802B6D55h    2D
        BYTE       PACKED_DARK_CYAN       ;0802B6DAAh    2E
        BYTE       PACKED_LIGHT_BLUE      ;0802B6DFFh    2F
        BYTE       PACKED_DARK_GREEN      ;0802B9200h    30
        BYTE       PACKED_DARK_GREEN      ;0802B9255h    31
        BYTE       PACKED_DARK_CYAN       ;0802B92AAh    32
        BYTE       PACKED_LIGHT_BLUE      ;0802B92FFh    33
        BYTE       PACKED_LIGHT_GREEN     ;0802BB600h    34
        BYTE       PACKED_LIGHT_GREEN     ;0802BB655h    35
        BYTE       PACKED_DARK_CYAN       ;0802BB6AAh    36
        BYTE       PACKED_LIGHT_BLUE      ;0802BB6FFh    37
        BYTE       PACKED_LIGHT_GREEN     ;0802BDB00h    38
        BYTE       PACKED_LIGHT_GREEN     ;0802BDB55h    39
        BYTE       PACKED_LIGHT_GREEN     ;0802BDBAAh    3A
        BYTE       PACKED_LIGHT_CYAN      ;0802BDBFFh    3B
        BYTE       PACKED_LIGHT_GREEN     ;0802BFF00h    3C
        BYTE       PACKED_LIGHT_GREEN     ;0802BFF55h    3D
        BYTE       PACKED_LIGHT_GREEN     ;0802BFFAAh    3E
        BYTE       PACKED_LIGHT_CYAN      ;0802BFFFFh    3F

        BYTE       PACKED_DARK_RED        ;080550000h    40
        BYTE       PACKED_DARK_PURPLE     ;080550055h    41
        BYTE       PACKED_DARK_PURPLE     ;0805500AAh    42
        BYTE       PACKED_LIGHT_BLUE      ;0805500FFh    43
        BYTE       PACKED_BLACK           ;080552400h    44
        BYTE       PACKED_DARK_RED        ;080552455h    45   <- DARK_PURPLE
        BYTE       PACKED_DARK_BLUE       ;0805524AAh    46
        BYTE       PACKED_LIGHT_BLUE      ;0805524FFh    47
        BYTE       PACKED_DARK_YELLOW     ;080554900h    48
        BYTE       PACKED_DARK_GRAY       ;080554955h    49
        BYTE       PACKED_DARK_BLUE       ;0805549AAh    4A
        BYTE       PACKED_LIGHT_BLUE      ;0805549FFh    4B
        BYTE       PACKED_DARK_GREEN      ;080556D00h    4C
        BYTE       PACKED_DARK_GREEN      ;080556D55h    4D
        BYTE       PACKED_DARK_CYAN       ;080556DAAh    4E
        BYTE       PACKED_LIGHT_BLUE      ;080556DFFh    4F
        BYTE       PACKED_DARK_GREEN      ;080559200h    50
        BYTE       PACKED_DARK_GREEN      ;080559255h    51
        BYTE       PACKED_DARK_CYAN       ;0805592AAh    52
        BYTE       PACKED_LIGHT_BLUE      ;0805592FFh    53
        BYTE       PACKED_DARK_GREEN      ;08055B600h    54
        BYTE       PACKED_DARK_GREEN      ;08055B655h    55
        BYTE       PACKED_DARK_CYAN       ;08055B6AAh    56
        BYTE       PACKED_LIGHT_BLUE      ;08055B6FFh    57
        BYTE       PACKED_LIGHT_GREEN     ;08055DB00h    58
        BYTE       PACKED_LIGHT_GREEN     ;08055DB55h    59
        BYTE       PACKED_LIGHT_GREEN     ;08055DBAAh    5A
        BYTE       PACKED_LIGHT_CYAN      ;08055DBFFh    5B
        BYTE       PACKED_LIGHT_GREEN     ;08055FF00h    5C
        BYTE       PACKED_LIGHT_GREEN     ;08055FF55h    5D
        BYTE       PACKED_LIGHT_GREEN     ;08055FFAAh    5E
        BYTE       PACKED_LIGHT_CYAN      ;08055FFFFh    5F

        BYTE       PACKED_DARK_RED        ;080800000h    60
        BYTE       PACKED_DARK_RED        ;080800055h    61
        BYTE       PACKED_LIGHT_PURPLE    ;0808000AAh    62
        BYTE       PACKED_LIGHT_PURPLE    ;0808000FFh    63
        BYTE       PACKED_DARK_RED        ;080802400h    64
        BYTE       PACKED_DARK_RED        ;080802455h    65
        BYTE       PACKED_DARK_PURPLE     ;0808024AAh    66
        BYTE       PACKED_LIGHT_PURPLE    ;0808024FFh    67
        BYTE       PACKED_DARK_YELLOW     ;080804900h    68
        BYTE       PACKED_DARK_RED        ;080804955h    69
        BYTE       PACKED_DARK_PURPLE     ;0808049AAh    6A
        BYTE       PACKED_LIGHT_PURPLE    ;0808049FFh    6B
        BYTE       PACKED_DARK_YELLOW     ;080806D00h    6C
        BYTE       PACKED_DARK_GRAY       ;080806D55h    6D
        BYTE       PACKED_DARK_PURPLE     ;080806DAAh    6E
        BYTE       PACKED_LIGHT_BLUE      ;080806DFFh    6F

        BYTE       PACKED_BLACK           ;080080808h    70
        BYTE       PACKED_BLACK           ;0800F0F0Fh    71
        BYTE       PACKED_BLACK           ;080171717h    72
        BYTE       PACKED_BLACK           ;0801F1F1Fh    73
        BYTE       PACKED_BLACK           ;080272727h    74
        BYTE       PACKED_BLACK           ;0802E2E2Eh    75
        BYTE       PACKED_BLACK           ;080363636h    76
        BYTE       PACKED_BLACK           ;0803E3E3Eh    77
        BYTE       PACKED_DARK_GRAY       ;080464646h    78
        BYTE       PACKED_DARK_GRAY       ;0804D4D4Dh    79
        BYTE       PACKED_DARK_GRAY       ;080555555h    7A
        BYTE       PACKED_DARK_GRAY       ;0805D5D5Dh    7B
        BYTE       PACKED_DARK_GRAY       ;080646464h    7C
        BYTE       PACKED_DARK_GRAY       ;0806C6C6Ch    7D
        BYTE       PACKED_DARK_GRAY       ;080747474h    7E
        BYTE       PACKED_DARK_GRAY       ;0807C7C7Ch    7F
        BYTE       PACKED_DARK_GRAY       ;080838383h    80
        BYTE       PACKED_DARK_GRAY       ;0808B8B8Bh    81
        BYTE       PACKED_DARK_GRAY       ;080939393h    82
        BYTE       PACKED_DARK_GRAY       ;0809B9B9Bh    83
        BYTE       PACKED_LIGHT_GRAY      ;080A2A2A2h    84
        BYTE       PACKED_LIGHT_GRAY      ;080AAAAAAh    85
        BYTE       PACKED_LIGHT_GRAY      ;080B2B2B2h    86
        BYTE       PACKED_LIGHT_GRAY      ;080B9B9B9h    87
        BYTE       PACKED_LIGHT_GRAY      ;080C1C1C1h    88
        BYTE       PACKED_LIGHT_GRAY      ;080C9C9C9h    89
        BYTE       PACKED_LIGHT_GRAY      ;080D1D1D1h    8A
        BYTE       PACKED_LIGHT_GRAY      ;080D8D8D8h    8B
        BYTE       PACKED_LIGHT_GRAY      ;080E0E0E0h    8C
        BYTE       PACKED_WHITE           ;080E8E8E8h    8D
        BYTE       PACKED_WHITE           ;080F0F0F0h    8E
        BYTE       PACKED_WHITE           ;080F7F7F7h    8F

        BYTE       PACKED_DARK_YELLOW     ;080809200h    90
        BYTE       PACKED_DARK_YELLOW     ;080809255h    91
        BYTE       PACKED_DARK_GRAY       ;0808092AAh    92
        BYTE       PACKED_LIGHT_BLUE      ;0808092FFh    93
        BYTE       PACKED_DARK_GREEN      ;08080B600h    94
        BYTE       PACKED_DARK_GREEN      ;08080B655h    95
        BYTE       PACKED_DARK_CYAN       ;08080B6AAh    96
        BYTE       PACKED_LIGHT_BLUE      ;08080B6FFh    97
        BYTE       PACKED_LIGHT_GREEN     ;08080DB00h    98
        BYTE       PACKED_LIGHT_GREEN     ;08080DB55h    99
        BYTE       PACKED_LIGHT_GREEN     ;08080DBAAh    9A
        BYTE       PACKED_LIGHT_CYAN      ;08080DBFFh    9B
        BYTE       PACKED_LIGHT_GREEN     ;08080FF00h    9C
        BYTE       PACKED_LIGHT_GREEN     ;08080FF55h    9D
        BYTE       PACKED_LIGHT_GREEN     ;08080FFAAh    9E
        BYTE       PACKED_LIGHT_CYAN      ;08080FFFFh    9F

        BYTE       PACKED_DARK_RED        ;080AA0000h    A0
        BYTE       PACKED_DARK_RED        ;080AA0055h    A1
        BYTE       PACKED_DARK_PURPLE     ;080AA00AAh    A2
        BYTE       PACKED_LIGHT_PURPLE    ;080AA00FFh    A3
        BYTE       PACKED_DARK_RED        ;080AA2400h    A4
        BYTE       PACKED_DARK_RED        ;080AA2455h    A5
        BYTE       PACKED_DARK_PURPLE     ;080AA24AAh    A6
        BYTE       PACKED_LIGHT_PURPLE    ;080AA24FFh    A7
        BYTE       PACKED_DARK_RED        ;080AA4900h    A8
        BYTE       PACKED_DARK_RED        ;080AA4955h    A9
        BYTE       PACKED_DARK_PURPLE     ;080AA49AAh    AA
        BYTE       PACKED_LIGHT_PURPLE    ;080AA49FFh    AB
        BYTE       PACKED_DARK_YELLOW     ;080AA6D00h    AC
        BYTE       PACKED_DARK_RED        ;080AA6D55h    AD
        BYTE       PACKED_DARK_PURPLE     ;080AA6DAAh    AE
        BYTE       PACKED_LIGHT_PURPLE    ;080AA6DFFh    AF
        BYTE       PACKED_DARK_YELLOW     ;080AA9200h    B0
        BYTE       PACKED_DARK_YELLOW     ;080AA9255h    B1
        BYTE       PACKED_DARK_PURPLE     ;080AA92AAh    B2
        BYTE       PACKED_LIGHT_BLUE      ;080AA92FFh    B3
        BYTE       PACKED_DARK_YELLOW     ;080AAB600h    B4
        BYTE       PACKED_DARK_YELLOW     ;080AAB655h    B5
        BYTE       PACKED_LIGHT_GRAY      ;080AAB6AAh    B6
        BYTE       PACKED_DARK_CYAN       ;080AAB6FFh    B7
        BYTE       PACKED_LIGHT_GREEN     ;080AADB00h    B8
        BYTE       PACKED_LIGHT_GREEN     ;080AADB55h    B9
        BYTE       PACKED_LIGHT_GREEN     ;080AADBAAh    BA
        BYTE       PACKED_LIGHT_CYAN      ;080AADBFFh    BB
        BYTE       PACKED_LIGHT_GREEN     ;080AAFF00h    BC
        BYTE       PACKED_LIGHT_GREEN     ;080AAFF55h    BD
        BYTE       PACKED_LIGHT_GREEN     ;080AAFFAAh    BE
        BYTE       PACKED_LIGHT_CYAN      ;080AAFFFFh    BF

        BYTE       PACKED_LIGHT_RED       ;080D50000h    C0
        BYTE       PACKED_LIGHT_RED       ;080D50055h    C1
        BYTE       PACKED_LIGHT_PURPLE    ;080D500AAh    C2
        BYTE       PACKED_LIGHT_PURPLE    ;080D500FFh    C3
        BYTE       PACKED_LIGHT_RED       ;080D52400h    C4
        BYTE       PACKED_LIGHT_RED       ;080D52455h    C5
        BYTE       PACKED_LIGHT_PURPLE    ;080D524AAh    C6
        BYTE       PACKED_LIGHT_PURPLE    ;080D524FFh    C7
        BYTE       PACKED_LIGHT_RED       ;080D54900h    C8
        BYTE       PACKED_LIGHT_RED       ;080D54955h    C9
        BYTE       PACKED_LIGHT_PURPLE    ;080D549AAh    CA
        BYTE       PACKED_LIGHT_PURPLE    ;080D549FFh    CB
        BYTE       PACKED_DARK_YELLOW     ;080D56D00h    CC
        BYTE       PACKED_DARK_RED        ;080D56D55h    CD
        BYTE       PACKED_LIGHT_PURPLE    ;080D56DAAh    CE
        BYTE       PACKED_LIGHT_PURPLE    ;080D56DFFh    CF
        BYTE       PACKED_DARK_YELLOW     ;080D59200h    D0
        BYTE       PACKED_DARK_YELLOW     ;080D59255h    D1
        BYTE       PACKED_LIGHT_PURPLE    ;080D592AAh    D2
        BYTE       PACKED_LIGHT_PURPLE    ;080D592FFh    D3
        BYTE       PACKED_DARK_YELLOW     ;080D5B600h    D4
        BYTE       PACKED_DARK_YELLOW     ;080D5B655h    D5
        BYTE       PACKED_DARK_PURPLE     ;080D5B6AAh    D6
        BYTE       PACKED_LIGHT_PURPLE    ;080D5B6FFh    D7
        BYTE       PACKED_DARK_YELLOW     ;080D5DB00h    D8
        BYTE       PACKED_DARK_YELLOW     ;080D5DB55h    D9
        BYTE       PACKED_LIGHT_YELLOW    ;080D5DBAAh    DA
        BYTE       PACKED_LIGHT_GRAY      ;080D5DBFFh    DB
        BYTE       PACKED_LIGHT_GREEN     ;080D5FF00h    DC
        BYTE       PACKED_LIGHT_GREEN     ;080D5FF55h    DD
        BYTE       PACKED_LIGHT_GREEN     ;080D5FFAAh    DE
        BYTE       PACKED_LIGHT_CYAN      ;080D5FFFFh    DF

        BYTE       PACKED_LIGHT_RED       ;080FF0000h    E0
        BYTE       PACKED_LIGHT_RED       ;080FF0055h    E1
        BYTE       PACKED_LIGHT_RED       ;080FF00AAh    E2
        BYTE       PACKED_LIGHT_PURPLE    ;080FF00FFh    E3
        BYTE       PACKED_LIGHT_RED       ;080FF2400h    E4
        BYTE       PACKED_LIGHT_RED       ;080FF2455h    E5
        BYTE       PACKED_LIGHT_RED       ;080FF24AAh    E6
        BYTE       PACKED_LIGHT_PURPLE    ;080FF24FFh    E7
        BYTE       PACKED_LIGHT_RED       ;080FF4900h    E8
        BYTE       PACKED_LIGHT_RED       ;080FF4955h    E9
        BYTE       PACKED_LIGHT_PURPLE    ;080FF49AAh    EA
        BYTE       PACKED_LIGHT_PURPLE    ;080FF49FFh    EB
        BYTE       PACKED_LIGHT_RED       ;080FF6D00h    EC
        BYTE       PACKED_LIGHT_RED       ;080FF6D55h    ED
        BYTE       PACKED_LIGHT_PURPLE    ;080FF6DAAh    EE
        BYTE       PACKED_LIGHT_PURPLE    ;080FF6DFFh    EF
        BYTE       PACKED_DARK_YELLOW     ;080FF9200h    F0
        BYTE       PACKED_DARK_YELLOW     ;080FF9255h    F1
        BYTE       PACKED_LIGHT_PURPLE    ;080FF92AAh    F2
        BYTE       PACKED_LIGHT_PURPLE    ;080FF92FFh    F3
        BYTE       PACKED_DARK_YELLOW     ;080FFB600h    F4
        BYTE       PACKED_LIGHT_YELLOW    ;080FFB655h    F5
        BYTE       PACKED_LIGHT_PURPLE    ;080FFB6AAh    F6
        BYTE       PACKED_LIGHT_PURPLE    ;080FFB6FFh    F7
        BYTE       PACKED_DARK_YELLOW     ;080FFDB00h    F8
        BYTE       PACKED_LIGHT_YELLOW    ;080FFDB55h    F9
        BYTE       PACKED_LIGHT_YELLOW    ;080FFDBAAh    FA
        BYTE       PACKED_LIGHT_PURPLE    ;080FFDBFFh    FB
        BYTE       PACKED_LIGHT_YELLOW    ;080FFFF00h    FC
        BYTE       PACKED_LIGHT_YELLOW    ;080FFFF55h    FD
        BYTE       PACKED_LIGHT_YELLOW    ;080FFFFAAh    FE
        BYTE       PACKED_WHITE           ;080FFFFFFh    FF
