;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
validate_bm_ptr equ     1

        PAGE     55,132
        TITLE    BitBlt2
        SUBTITLE Header
;----------------------------Module-Header------------------------------;
; Module Name: BITBLT2.ASM
;
; BitBLT2 at level of device driver.
;
; This is the main module of those comprising the source to BitBLT
; (Bit BLock Transfer) for Microsoft         display drivers. It
; defines the procedure, and performs general preprocessing for all BLT
; requests.
;
; BitBLT  transfers a rectangle of bits from source to destination,
; doing some useful operations on the way, namely:
;
; o     excluding the cursor;
;
; o     performing a user-specified raster operation, out of
;       a vast array of choices, which takes the form
;
;       D = f(S,D,P)
;
;       where S = source bit, D = destination bit, P = pattern
;       bit, and  f  is a sequence of logical operations (AND, OR,
;       XOR, NOT) on S, D, and P;
;
; o     recognizing common special cases for accelerated processing.
;
; For a detailed explanation of the contortions BitBLT goes through
; to put your bits in place, see the file COMMENT.BLT.
;
;
; BitBLT consists of the following files:
;
;       BITBLT.ASM              procedure definition
;       CBLT.ASM                procedure to compile arbitrary BLT on stack
;
;       FRAME.BLT               function parameters and locals
;       CONSTANT.BLT            constants
;       DATADEFS.BLT            compiled code templates and data
;       ROPTABLE.BLT            table of ROP templates and definitions
;       SURFACE.BLT             Surface processing
;       PATTERN.BLT             pattern preprocessing
;
;       COMPUTEY.BLT            compute y-related values
;       EXIT.BLT                device-specific cleanup before exiting
;
;       SPECIAL.BLT             special case code
;       COMMENT.BLT             overview of history and design
;-----------------------------------------------------------------------;

        .386
        .MODEL FLAT,SYSCALL
        ASSUME  SS:FLAT, DS:FLAT, CS:FLAT, ES:FLAT

        .errnz  BITS_PEL - 8            ;Some uses of BITS_PEL expect it
                                        ;  to be 4  --  should clean up
        .xlist
;INCL_GPIPRIMITIVES      equ     1
INCL_GPIBITMAPS         equ     1
        include pmgre.inc
DINCL_BB_ROPS   equ     1
DINCL_BITMAP    equ     1
DINCL_ENABLE    equ     1
        include driver.inc
        include extern.inc
        include protos.inc
        include display.inc
        include egafam.inc
        include oemblt.inc
        include assert.mac
        include pointer.inc
        .list

.DATA
EXTERNDEF work_buf:BYTE
EXTERNDEF pfnSolidScanline:DWORD
EXTERNDEF pfnXORScanline:DWORD
EXTERNDEF pfnCopyScanline:DWORD
EXTERNDEF bkclr:BYTE
EXTERNDEF bkmix:BYTE
EXTERNDEF sd_paltrans:SURFACE ;          

ifdef  JTUNE        ;IBMJ
EXTERNDEF scr_to_scr_bitblt:DWORD
EXTERNDEF BGAFillRectangleSpecial:NEAR
EXTERNDEF BGAXorRectangleSpecial:NEAR
EXTERNDEF BGAMemoryToScreenSpecial:NEAR
EXTERNDEF CL26XorRectangleSpecial:NEAR
EXTERNDEF CL26MemoryToScreenSpecial:NEAR
EXTERNDEF CL26PatternFillSpecial:NEAR
endif ;JTUNE        ;IBMJ

ifdef  IBMJ        ;IBMJ
set_d_pointer  proto syscall
set_d_pointer_dec proto syscall
set_s_pointer  proto syscall
set_s_pointer_dec proto syscall
set_s_pointer_cmap proto syscall
set_s_pointer_map proto syscall
endif ;IBMJ        ;IBMJ

.CODE
        include constant.blt

OPTION PROLOGUE:NONE
OPTION EPILOGUE:NONE

far_do_cblt     PROTO   SYSCALL
setup_pattern   PROTO   SYSCALL

BM_SRCTRANSPARENT EQU 18 ;tmp
BM_DESTTRANSPARENT EQU 19 ;tmp
        include special8.blt            ;non-compiled blt subroutines

end
