;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
ifdef FIREWALLS
        PAGE     55,132
        TITLE    VALIDATE.ASM
        SUBTITLE Header
;/*****************************************************************************
;*
;* SOURCE FILE NAME = VALIDATE.ASM
;*
;* DESCRIPTIVE NAME = DDC VALIDATION ROUTINE
;*
;*
;* VERSION      V2.0
;*
;* DATE         10/01/91
;*
;* DESCRIPTION  DDC VALIDATION ROUTINE  
;*
;* FUNCTIONS    ddc_validate
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   10/01/91                     Written by Scott Lawson
;*
;*****************************************************************************/

           .386
           .MODEL FLAT,SYSCALL
ASSUME  SS:FLAT, DS:FLAT, CS:FLAT, ES:FLAT

;/*
;** Included files
;*/

        .xlist
        include pmgre.inc
        DDC_VALIDATE_DEFINED    equ     1
        DINCL_ENABLE            equ     1
        include driver.inc
        include protos.inc
        .list

.CODE
;/*
;** Public functions
;*/
           SUBTITLE 
           PAGE +

;/***************************************************************************
;*
;* FUNCTION NAME = validate_ddc 
;*
;* DESCRIPTION   = SURFACE     validate that the surface parameters are consistant 
;*                             in the given ddc.                                   
;*                                                                                 
;*                 MEMORYDDC   validate that the ddc is a memory ddc               
;*                                                                                 
;*                 LEVELS      validate all the levels of the ddc.  If not given,  
;*                             only the topmost level is validated                 
;*                 
;*                 Registers modified
;*                     EBX,ESI,EDI   
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

;/*
;** Code
;*/


ASSUME  EBX:PDDC
                public  ddc_validate
ALIGN 4
ddc_validate PROC SYSCALL,
        pddc:           DWORD,
        flCommand:      DWORD

        pushad
        pushfd

;/*
;** Always validate the hddc to make sure the handle type is correct
;** and that the memory pointed to is a ddc.
;*/

        mov     edx,DDC_IDENT
        mov     ebx,pddc

ddcv_level_loop:
        cmp     [ebx].ddc_usId,edx
        je      @F
        rip     text,<Validate - ddc does not point to a ddc>
        jmp     validate_exit
@@:

;/*
;** If this is supposed to be a memory ddc, make sure it is.
;*/

        test    flCommand,DDC?MEMORYDDC
        jz      @F
        test    [ebx].ddc_fb,DDC_DEVICE
        jz      @F
        rip     text,<Validate - ddc is not a memory ddc>
        jmp     validate_exit
@@:

;/*
;** Validate the surface if requested
;*/

        test    flCommand,DDC?SURFACE
        jnz     @F
        jmp     surface_validated
@@:
        mov     esi,[ebx].ddc_npsd               ;INVALID_ADDRESS if no surface selected
        test    [ebx].ddc_fb,DDC_PRESENT
        jnz     need_a_surface

;/*
;** Validate that no surface is selected into the ddc.
;**
;** We don't want to find a surface selected into the ddc.  We also don't
;** want to find a non-zero ddc_crcsClip, which would be inconsistant with
;** the DDC_VISIBLE flag.
;*/

        inc     esi
        jz      @F
        .errnz  INVALID_ADDRESS+1
        rip     text,<Validate - Pointer to surface should be null>
        jmp     validate_exit
@@:
        test    [ebx].ddc_fb,DDC_VISIBLE
        jz      @F
        rip     text,<Validate - A null surface was marked visible>
        jmp     validate_exit
@@:
        jmp     surface_validated

;/*
;** Validate that a surface is selected into the ddc.
;**
;**       The pointer to surface should be non-null and have a
;**       SURFACE_IDENT id.
;**
;**       If this is a bitmap, it must be owned by the ddc and have a
;**       non-zero select count.
;**
;**       DDC_DEVICE and SD_DEVICE must be the same.
;**
;**       If either extent of the surface is 0, then SD_NONNULL must be
;**       clear.  If both extents are non-zero, then SD_NONNULL must be
;**       set.
;**
;**       If SD_NONNULL is clear, then the DDC_VISIBLE flag must be clear
;*/

need_a_surface:
        inc     esi
        jnz     @F
        rip     text,<Validate - Pointer to surface should not be null>
        jmp     validate_exit
@@:
        dec     esi                               ;Must have the correct ident
        cmp     [esi].SURFACE.sd_usId,SURFACE_IDENT
        .errnz  BITMAP.bm_sd.sd_usId
        .errnz  SURFACE.sd_usId
        je      @F
        rip     text,<Validate - The Id field of the selected surface is invalid>
        jmp     validate_exit
@@:
        mov     al,[esi].SURFACE.sd_fb           ;If a bitmap, must be owned
        test    al,SD_DEVICE                      ;  by this ddc and have a
        jnz     surface_check_cont               ;  non-zero select count
        cmp     [ebx].ddc_usId,SAVED_DDC_IDENT ; saved DDC can't own a bitmap!
        jz      @F
        cmp     [esi].BITMAP.bm_hddc,ebx
        je      @F
        rip     text,<Validate - The bitmap selected into the ddc is owned by a different ddc>
        jmp     validate_exit
@@:
        cmp     [esi].BITMAP.bm_cSelect,0
        jne     @F
        rip     text,<Validate - The bitmap selected into the ddc has a lock count of 0>
        jmp     validate_exit
@@:

surface_check_cont:
        xor     al,[ebx].ddc_fb                   ;The DDC_DEVICE and SD_DEVICE
        test    al,DDC_DEVICE                     ;  flags must be consistant
        jz      @F                                ;  with each other
        .errnz  DDC_DEVICE-SD_DEVICE
        rip     text,<Validate - Device flags in ddc and surface do not match>
        jmp     validate_exit
@@:
        xor     ecx,ecx                           ;Set CX = 0 if surface should
        cmp     [esi].BITMAP.bm_sd.sd_cx,ecx     ; be null, else 0FFFFh
        je      @F
        cmp     ecx,[esi].BITMAP.bm_sd.sd_cy
        je      @F
        dec     ecx
@@:
        test    [esi].SURFACE.sd_fb,SD_NONNULL
        jnz     surface_is_flagged_nonnull

surface_is_flagged_null:
        ;Surface pointer must be null
        cmp     [esi].SURFACE.sd_pBits,INVALID_ADDRESS 
        je      @F                                ;  if flagged as null
        rip     text,<Validate - A null surface with a selector was detected>
        jmp     validate_exit
@@:


        jecxz   @F                                ;Null surface with a non-zero
                                                  ;  extent is wrong
        test    [ebx].ddc_fbAbove,DDC_INFO_DC    ;INFO DC now have a surface
        jnz     @F                                 ;  size see data.asm
        rip     text,<Validate - A null surface with non-zero extents was detected>
        jmp     validate_exit
@@:

        test    [ebx].ddc_fb,DDC_VISIBLE ;Null surface can never be
        jz      @F                                ;  visible
        rip     text,<Validate - A null surface was marked visible>
        jmp     validate_exit
@@:
        jmp     surface_validated


surface_is_flagged_nonnull:
        inc     ecx                               ;Non-null with a zero extent
        jz      @F                                ;  is wrong
        rip     text,<Validate - A non-null surface with zero extents was detected>
        jmp     validate_exit
@@:
surface_validated:

;/*
;** Some general validations of the ddc fields
;**
;**       If the save level is 1, there should be no previous link.  If
;**       the save level isn't 1, then there should be a previous link
;**       which points to a SAVED_DDC_IDENT type ddc.
;**
;**       If DDC_CLIP_NOTIFY is clear, then DDC_VISIBLE must be clear.
;**
;**       If DDC_VISIBLE is clear, then ddc_crcsClip must be 0.
;**
;**       Validate the color table pointer and mapping function
;*/

general_validations:
        cmp     [ebx].ddc_cLevel,1
        je      ddc_at_level_1
        mov     esi,[ebx].ddc_npddcPrev
        inc     esi
        jz      ddc_bad_link
        dec     esi
        cmp     [esi].DDC.ddc_usId,SAVED_DDC_IDENT
        je      @F
ddc_bad_link:
        rip     text,<Validate - The pointer to a save level of the ddc is invalid>
        jmp     validate_exit
ddc_at_level_1:
        cmp     [ebx].ddc_npddcPrev,INVALID_ADDRESS
        jne     ddc_bad_link
@@:
        mov     al,[ebx].ddc_fb
        test    al,DDC_CLIP_NOTIFY
        jnz     @F
        test    al,DDC_VISIBLE
        jz      @F
        rip     text,<Validate - ddc marked visible with no clip notification>
        jmp     validate_exit
@@:
        cmp     [ebx].ddc_crcsClip,0
        jne     @F
        test    al,DDC_VISIBLE
        jz      @F
        rip     text,<Validate - ddc marked visible with no clip rectangles present>
        jmp     validate_exit
@@:

;/*
;** If VALIDATE_LEVELS was specified, then all saved levels of the ddc
;** are to be validated.
;*/

        test    flCommand,DDC?LEVELS
        jz      @F
        mov     ebx,[ebx].ddc_npddcPrev
        inc     ebx
        jz      @F
        dec     ebx
        mov     edx,SAVED_DDC_IDENT
        jmp     ddcv_level_loop
@@:
validate_exit:
        popfd
        popad
        ret     
ddc_validate    ENDP
endif ; FIREWALLS
end
