;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE     55,132
        TITLE    
        SUBTITLE Header

;/*****************************************************************************
;*
;* SOURCE FILE NAME = SCANCORR.ASM
;*
;* DESCRIPTIVE NAME = Scanline sub-function of output
;*
;*
;* VERSION      V2.0
;*
;* DATE         03/06/88
;*
;* DESCRIPTION  This module contains routines from SCANLINE.ASM which are common to
;*              all drivers.                                                       
;*                                                                                 
;*              This module contains the scanline sub-function of Output.          
;*
;* FUNCTIONS    do_sl_corr
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   03/06/88                     Mike Harrington [mikehar] wrote it
;*   05/12/88                     Kent Settle [kentse] fixed invalid pointer 
;*                                passed to RectVisible
;*   07/19/88                     Tony Pisculli [tonyp] complete rewrite
;*   09/02/88                     Lee A. Newberg [leen] Rewrote the final 
;*                                intersection checking.  Moved intersect_range
;*                                in line.  Added Pseudo code.
;*
;*****************************************************************************/

        .386

        .xlist

        OPTION  OLDSTRUCTS

INCL_GRE_CLIP           equ     1
INCL_GRE_SCANS          equ     1
INCL_GPIREGIONS         equ     1
INCL_DDIMISC            equ     1
INCL_DEV                equ     1
INCL_DDICOMFLAGS        equ     1
DINCL_ENABLE            equ     1
DINCL_BITMAP            equ     1

        include pmgre.inc
        include driver.inc
        include assert.mac
        include extern.inc
        include protos.inc

        .list

        .MODEL FLAT
    
        ASSUME  CS:FLAT,SS:FLAT,DS:FLAT,ES:FLAT

        .DATA

        .CODE

;/*
;**       Special tables used for setting up the EGA for performing
;**       certain Rops in one pass
;*/

;/***************************************************************************
;*
;* FUNCTION NAME = do_sl_corr 
;*
;* DESCRIPTION   = scanline correlation routine called by enumerate_clip_rects 
;*
;*                 Registers Preserved:  
;*                       SI,DI,DS,ES,BP  
;*                 Registers Destroyed:  
;*                       BX,DX           
;*
;* INPUT         = BX      = clip RECTL   
;*                 SI      = npddc        
;*                 DI      = nplpScansData
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = AX      = 0 when done (correlate hit or early out) 
;*                 CX      = 2 if correlate, 0 if no correlate        
;* RETURN-ERROR  = NONE
;*
;*             --------Pseudo-Code-----
;* do_sl_corr
;* rclClip FAR *SS:BX;
;* ddc NEAR *SI;
;* ScansData FAR * FAR * SS:DI;
;*
;* For each Scans Pair
;*     - Intersect the clip rectange, the pick window, and the Scan Pair
;*       Bounding Box.
;*     - Compute the leftmost part of the scan pair in this rectangle.
;*     - Compute the rightmost part of the scan pair in this rectangle.
;*     - Check if this range intersects the X range of the pick window.
;*
;**************************************************************************/

ALIGN 4
do_sl_corr      PROC    SYSCALL
        LOCAL   cCount          :DWORD
        LOCAL   nprclClip       :DWORD
        LOCAL   rclBBox         :RECTL

        cld
        mov     nprclClip,ebx

;/*
;** intersect clip rect with correlation rect
;*/

        INVOKE  intersect_with_corr,
                ebx


        mov     ebx,nprclClip
        or      eax,eax
        jnz     dsc_intersected
        jmp     exit_do_sl_corr
ALIGN 4
dsc_intersected:

;/*
;** get number of shortline pairs and first pair
;*/

        mov     esi,dword ptr [edi]               ; DS:SI = lpScansData

        ASSUME  esi:PTR SCANDATA

        mov     eax,[esi].sd_c
        mov     cCount,eax
        assert  WORD PTR [esi].sd_c[2],E,0
        assert  WORD PTR [esi].sd_c[0],GE,0

        mov     edi,[esi].sd_pslFirstRight       ; ES:DI = right-hand shortline
        mov     esi,[esi].sd_pslFirstLeft         ; DS:SI = left-hand shortline

        ASSUME  esi:PTR SHORTLINE
        ASSUME  edi:PTR SHORTLINE

;/*
;** get bounding box of shortline pair
;*/

dsc_get_bbox:
        mov     eax,[esi].sl_slh.slh_lxLeft
        mov     rclBBox.rcl_xLeft,eax
        mov     eax,[esi].sl_slh.slh_ptlStart.ptl_y
        mov     rclBBox.rcl_yBottom,eax

        mov     eax,[edi].sl_slh.slh_lxRight
        mov     rclBBox.rcl_xRight,eax

        mov     eax,[edi].sl_slh.slh_ptlStop.ptl_y
        mov     rclBBox.rcl_yTop,eax

;/*
;** intersect correlation rectangle with shortline-pair bounding box
;*/

        push    esi
        push    edi
        mov     esi,nprclClip                     ; DS:SI = clip rect
        lea     edi,rclBBox                       ; ES:DI = shortline-pair bounding box
        mov     ebx,1
        INVOKE  intersect_rcl
        pop     edi
        pop     esi
        or      eax,eax
        jnz     dsc_this_pair
        jmp     dsc_next_pair
ALIGN 4
dsc_this_pair:

;/*
;** All the excitement is happening in rclBBox which is an inclusive-exclusive
;** rectangle.  The scanline is  inclusive-exclusive, too.
;*/

        mov     ebx,rclBBox.rcl_yBottom
        sub     ebx,[esi].sl_slh.slh_ptlStart.ptl_y
        assert  GE

        mov     ecx,[esi].sl_ax[4*ebx]
        mov     edx,[edi].sl_ax[4*ebx]

        mov     ebx,rclBBox.rcl_yTop
        dec     ebx                                ; Because it's exclusive
        assert  NO
        sub     ebx,[esi].sl_slh.slh_ptlStart.ptl_y
        assert  GE

        cmp     ecx,[esi].sl_ax[4*ebx]
        jl      @F
        mov     ecx,[esi].sl_ax[4*ebx]
@@:
        cmp     edx,[edi].sl_ax[4*ebx]
        jg      @F
        mov     edx,[edi].sl_ax[4*ebx]
@@:

;/*
;** CX = the leftmost point the scanline gets to.  (inclusive)
;** DX = the rightmost point the scanline gets to.  (exclusive)
;*/

        mov     ebx,nprclClip

        ASSUME  ebx:PTR RECTL

        mov     eax,[ebx].rcl_xLeft             ; (inclusive)
        mov     ebx,[ebx].rcl_xRight             ; (exclusive)

;/*
;** Check whether the x ranges,[CX,DX) and [AX,BX), intersect.
;*/

        assert  EAX,LE,EBX
        assert  ECX,LE,EDX
        cmp     eax,edx
        mov     eax,0                             ; Preserve flags.
        jge     dsc_next_pair
        cmp     ecx,ebx
        jge     dsc_next_pair
        mov     al,2
        jmp     exit_do_sl_corr
ALIGN 4

dsc_next_pair:
        dec     cCount
        jz      exit_do_sl_corr
        mov     esi,[esi].sl_slh.slh_pslhNext
        mov     edi,[edi].sl_slh.slh_pslhNext
        jmp     dsc_get_bbox
ALIGN 4

exit_do_sl_corr:
        mov     ecx,eax                           ; correlate info returned in CX
        xor     al,2                              ; tell enumerate_clip_rects to stop
        ret                                       ; if correlation hit occurs.
do_sl_corr ENDP

end
