;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = RESOLVEC.ASM
;*
;* DESCRIPTIVE NAME = Resolve Undefined externals
;*
;*
;* VERSION      V2.0
;*
;* DATE         08/18/88
;*
;* DESCRIPTION  Extracted routines from RESOLVE.ASM which are common to all drivers 
;*              
;*
;* FUNCTIONS    SetCharFont  
;*              SetMarkerFont
;*                           
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   08/18/88                     Written by Robert J. Carragher [t-robc]
;*
;*****************************************************************************/

        .386

        .xlist

        OPTION  OLDSTRUCTS

INCL_DDIBUNDLES     equ     1
INCL_DEV            equ     1
INCL_FONTFILEFORMAT equ     1
INCL_GRE_FONTS      equ     1
INCL_GPIERRORS      equ     1

        include pmgre.inc

DINCL_ENABLE    equ     1
DINCL_ROPS      equ     1
DINCL_BB_ROPS   equ     1
DINCL_SAVE_SCREEN_BITS  equ   1
DINCL_VIO       equ     1
DINCL_ENABLE    equ     1
DINCL_BITMAP    equ     1

        include driver.inc
        include fontseg.inc
        include extern.inc
        include protos.inc

        .list

        .MODEL FLAT
    
        ASSUME  CS:FLAT,SS:FLAT,DS:FLAT,ES:FLAT

        .DATA

ALIGN 4
        pubabs  DEF_LOG_FORE_CLR,7
        pubabs  DEF_LOG_BACK_CLR,0

        pubabs  DEF_FB_LINE,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_FMIX_LINE,%(ROP_P)
        pubabs  DEF_BMIX_LINE,%(ROP_D)
        pubabs  DEF_LINE_TYPE,%(LINETYPE_SOLID-1)
        pubabs  DEF_LINE_ERROR,0
        pubabs  DEF_LINE_MASK,0

        pubabs  DEF_FB_MARKER,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_FMIX_MARKER,%(CHAR_ROP_P)
        pubabs  DEF_BMIX_MARKER,%(BA_IS_XPARENT)
        pubabs  DEF_MARKER_FB_FLAGS,0
        pubabs  DEF_MARKER_FS_FLAGS,0
        pubabs  DEF_MARKER_CODE_POINT,%(MARKSYM_CROSS)

        pubabs  DEF_FB_CHAR,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_FMIX_CHAR,%(CHAR_ROP_P)
        pubabs  DEF_BMIX_CHAR,%(BA_IS_XPARENT)
        pubabs  DEF_FONT_FS_FLAGS,0

        pubabs  DEF_FB_PATTERN,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_FMIX_PATTERN,%(ROP_P)
        pubabs  DEF_BMIX_PATTERN,%(ROP_D)
        pubabs  DEF_PATTERN_FB_FLAGS,(PA_SINGLE_CLR)
        pubabs  DEF_PATTERN_FS_FLAGS,0
        pubabs  DEF_PATTERN_CODE_POINT,%(PATSYM_SOLID)

        pubabs  DEF_FB_IMAGE,%(BA_CLR_DEF or BA_CLR_BACK_DEF)
        pubabs  DEF_FMIX_IMAGE,%(FM_OVERPAINT-1)
        pubabs  DEF_BMIX_IMAGE,%(BA_IS_XPARENT)

FD_VECTOR       equ    0000000000000001B

        .CODE

;/***************************************************************************
;*
;* FUNCTION NAME = SetCharFont
;*
;* DESCRIPTION   = Invoke the routine which deals with font selection. 
;*                 We expect this routine to set BA_REREALIZE if it is appropriate.
;*                 We can ignore the offset to the font because we FIREWALLed 
;*                 it to be zero, and all our code would fall apart if it wasn't.
;*                 We don't need to worry about writing into the ddc and then 
;*                 detecting an error because DeviceSetAttributes saved the 
;*                 contents of the bundle for error recovery.
;*                
;*
;* INPUT         = EBX --> ddc                         
;*                 DX:AX  =  font handle / font pointer
;*                 BP     =  attr index for characters 
;*                 CX     =  ca_fs, most flags cleared 
;*                 ES:SI --> attribute bundle          
;*
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = EAX = 1
;* RETURN-ERROR  = EAX = 0
;*
;**************************************************************************/

ALIGN 4
SetCharFont     PROC SYSCALL USES esi edi

        DebugMsg <SetCharFont, resolvec, CLIFFL>

        ASSUME  ebx:PTR DDC

ifdef FIREWALLS


        mov     [ebx].ddc_ca.ca_paus,INVALID_ADDRESS
endif

ifdef DBCS  ; DBCS device font support     ;IBMJ

; The Engine give us null fontseg when display driver itself manages
; device font and the SetCharFont is called with device default font.
; We should supply valid fontseg address for this request.

 or eax,eax   ;Device default font?
 jnz scf_font_specified ;no...
 mov eax,ddcInit.ddc_ca.ca_pFont
 mov [ebx].ddc_ca.ca_pFont,eax

scf_font_specified:
 INVOKE DbcsQueryFontProfile ;Know our font profile...
 mov [ebx].ddc_ca.ca_fsFont,eax
 mov [ebx].ddc_ca.ca_cCache,edx
     ;Restore fontseg
 mov eax,[ebx].ddc_ca.ca_pFont

endif;DBCS        ;IBMJ

;/*
;** Get all the data from the defs bundle while we still have it's pointer
;** If this is a user supplied font, the code page will be in the defs
;** bundle.  If it is the default, the code page is in ddc_ca.ca_idCodePage
;*/

ifndef JFIX        ;IBMJ
        ASSUME  esi:PTR DCHARBUNDLE

        mov     eax,[esi].dcbnd_cdef.cdef_charSpacing
else  ;JFIX        ;IBMJ
 mov eax,[esi].dcbnd_cAttr
 lea esi,[esi].dcbnd_cbnd
 add esi,eax

 ASSUME esi:PTR CHARDEFS

 mov eax,[esi].cdef_charSpacing
endif ;JFIX        ;IBMJ
        movzx   eax,al                            ;Cheat - Keep small for now
        mov     [ebx].ddc_ca.ca_cExtraPels,eax
        neg     eax                               ;'C' if non-zero
        sbb     eax,eax                           ;FFFF if non-zero char extra
        and     eax,CA_CHAR_EXTRA
        or      ecx,eax

ifndef JFIX        ;IBMJ
        mov     eax,[esi].dcbnd_cdef.cdef_CodePage
else  ;JFIX        ;IBMJ
 mov eax,[esi].cdef_CodePage
endif ;JFIX        ;IBMJ
        or      cx,cx
        js      scf_have_desired_code_page

        .errnz  CA_USER_FONT-8000h

        mov     eax,[ebx].ddc_ca.ca_idCodePage

scf_have_desired_code_page:

        mov     esi,eax                           ;Save desired code page in SI

;/*
;** Now reach into the font and pull out lots of good information so we
;** can set a bunch of different CA_ flags.
;*/

        ASSUME  edx:PTR FOCAFONT

        mov     edx,[ebx].ddc_ca.ca_pFont
        xor     eax,eax

        or      ecx,CA_VECTOR
        test    [edx].ff_fmMetrics.foca_fsDefn,FD_VECTOR
        jne     scf_all_done                     
        and     ecx,not CA_VECTOR                ;It is raster

;/*
;** its a raster font, the display driver can't handle huge fonts
;** (but the engine now can handle huge vectore fonts)
;*/

        test    [edx].ff_fmMetrics.foca_fsTypeFlags,FM_TYPE_64K
        jnz     scf_log_huge_error;Font is huge, don't accept it

        cmp     [edx].ff_fdDefinitions.fdh_xCellWidth,8
        jne     @F
        or      ecx,CA_WIDTH_IS_8
@@:
        test    [edx].ff_fmMetrics.foca_fsTypeFlags,FM_FIXED_PITCH
        jz      @F
        or      ecx,CA_FIXED_PITCH
@@:
        cmp     [edx].ff_fdDefinitions.fdh_fsChardef,FONTDEFCHAR3
        jne     @F
        or      ecx,CA_ABC_SPACE
@@:

ifndef DBCS        ;IBMJ

;/*
;** If the font is not in the default code page (850), then no mapping
;** is possible.If the font is the default code page and a different
;** code page is to be used, get the mapping array.  If getting the
;** mapping array fails, return an error.
;*/

        cmp     [edx].ff_fmMetrics.foca_usCodePage,DEFAULTVIOCODEPAGE
        jne     scf_all_done
        cmp     esi,DEFAULTVIOCODEPAGE
        je      scf_all_done
        or      esi,esi                           ;0 = use the default in the font
        je      scf_all_done

;/*
;** Get the mapping vector for this code page.  Don't bother to get access
;** now since the access test has to be made at output time.
;*/

        push    ebx
        push    ecx

        INVOKE  Gre32Entry3, esi, 0, NGreQueryCodePageVector

        pop     ecx
        pop     ebx
        mov     [ebx].ddc_ca.ca_paus,eax
        or      eax,eax
        jz      scf_exit                         ;Error, return 0
        or      ecx,CA_MUST_MAP

scf_all_done:

else ;DBCS  ; DBCS codepage / DBCS device font support   ;IBMJ
scf_all_done:

;-----------------------------------------------------------------------;
; Get parsing flags and mapping vector for specified font
;
;   Desired codepage is taken from
;   a. ddc    (ca_idCodePage) if current font is default font (lcid=0)
;   b. bundle (cdef_CodePage) if current font isn't default font (lcid!=0)
;   (when current font is not the default font, CA_USER_FONT flag is set)
;
;   The desired codepage may be 0 when the RealizeFont is called with
;   codepage=0 (use font codepage) for user font.
;   In this case, font codepage defined in font metrics, or application
;   natural codepage (ca_idCodePage) will be taken.
;   This result will be saved to logical codepage (ca_lCodePage) in ddc.
;
;   The logical codepage will be used for two purposes:
;   (1) string parsing rule
; The rule to devide a string into isolated code-points.
;   (2) code-point mapping to glyph-index
; Mapping of isolated code-point to glyph-index.
; The mapping vectors are supported only for codepage 850 (or 0)
; font, and the mapping for any other type of fonts falls into
; "no mapping", so also affected by font codepage.
;
;   Operation Details:
;
;   1. Get logical codepage.
;      If desired codepage is 0 (not specified), use font codepage.
;      In the case font codepage is 850 (MBCS/DBCS, multi-linguel 850),
;      we can use the font for many MBCS/DBCS codepages (e.g. 932,942).
;      So we will take application natual codepage stored in ddc.
;
; Ŀ
;  font codepage      desired codepage  logical codepage 
; Ĵ
;  any       non 0   desired codepage 
;  850 (SBCS)      0    font codepage  
;  850 (MBCS/DBCS)  0    ca_idCodePage (app.cp)
;  other (SBCS)      0    font codepage  
;  other (MBCS/DBCS)  0    font codepage  
; 
;
;   2. Get parsing rule and mapping vector.
;      The parsing rule is detected only by logical codepage, while
;      the mapping vector availability is affected by font codepage.
;
;      If font codepage is 850 (or 0), mapping vector is available.
; Ŀ
;  logical codepage   parsing rule  mapping to 850 
; Ĵ
;  850 (SBCS)      SBCS   no (from codepage 850)
;  other (SBCS)      SBCS   from logical codepage 
;  other (MBCS/DBCS)  MBCS/DBCS   from logical codepage 
; 
;
;      If font codepage is not 850 (or 0), mapping vector is not available.
; Ŀ
;  logical codepage   parsing rule  mapping to 850 
; Ĵ
;  850 (SBCS)      SBCS   no   
;  other (SBCS)      SBCS   no   
;  other (MBCS/DBCS)  MBCS/DBCS   no   
; 
;-----------------------------------------------------------------------;

 push ecx   ; save character attributes

; The desired codepage defines the string parsing rule. When codepage 0
; is specified, actual desired codepage will be taken from font metrics.

 or esi,esi   ; SI = desired codepage
 jnz scf_check_codepage
 movzx esi,[edx].ff_fmMetrics.foca_usCodePage
 cmp esi,DEFAULTVIOCODEPAGE
 jne scf_check_codepage

; The codepage in the font metrics is 850. If the font is multi-lingual
; 850 (MBCS/DBCS 850), we will use current application codepage in ddc
; as desired codepage.

 test [edx].ff_fmMetrics.foca_fsTypeFlags,(FM_TYPE_MBCS or FM_TYPE_DBCS)
 jz scf_check_codepage
 mov esi,[ebx].ddc_ca.ca_idCodePage

; Check if the codepage is valid or not. If it is invalid, we WILL handle
; it as codepage 850 (SBCS parsing, no mapping).

scf_check_codepage:
 mov eax,esi
 push edx
 INVOKE DbcsQueryCodePageVectors
 pop edx
 or eax,eax
 jnz scf_have_codepage
 mov esi,DEFAULTVIOCODEPAGE ; force to codepage 850
 jmp scf_check_codepage

; Now we have valid desired codepage for string parsing.
; Save it as logical codepage, which will be used later in parsing logic.

scf_have_codepage:
 mov [ebx].ddc_ca.ca_lCodePage,esi
 mov [ebx].ddc_ca.ca_paus,eax
 mov eax,ecx   ; EAX = parsing/mapping flags
 pop ecx   ; restore character attributes

; Check if SBCS code point mapping is necessary / possible or not.
; If the desired codepage is equal to the codepage in the font metrics,
; or the codepage in the font is not 850, force to no mapping.

 test eax,NLSCA_MAP_SBCS
 jz scf_have_flags  ; no mapping necessary
 or ecx,CA_MUST_MAP

 cmp [edx].ff_fmMetrics.foca_usCodePage,si
 je scf_no_mapping
 cmp [edx].ff_fmMetrics.foca_usCodePage,DEFAULTVIOCODEPAGE
 je scf_have_flags
scf_no_mapping:
 and eax,not NLSCA_MAP_SBCS
 and ecx,not CA_MUST_MAP
scf_have_flags:
 mov [ebx].ddc_ca.ca_fsNls,eax

endif;DBCS        ;IBMJ

        or      [ebx].ddc_ca.ca_ba.ba_fb,BA_REREALIZE
        mov     eax,1

scf_exit:

        RET

scf_log_huge_error:

        mov     eax,PMERR_HUGE_FONTS_NOT_SUPPORTED

        save_error_code

        xor     eax,eax

        jmp     scf_exit

SetCharFont     ENDP

;/***************************************************************************
;*
;* FUNCTION NAME =
;*
;* DESCRIPTION   = Invoke the routine which deals with marker selection. 
;*                 We expect this routine to set BA_REREALIZE if it is appropriate.      
;*                                                                                       
;*                 We can ignore the offset to the font because we firewalled it to 
;*                 be zero, and all our code would fall apart if it wasn't.
;*                                                                                       
;*                 We don't need to worry about writing into the ddc and then
;*                 detecting an error because DeviceSetAttributes saved the 
;*                 contents of the bundle for error recovery.                                                   
;*                 
;* INPUT         = DS:BX --> ddc                       
;*                 DX:AX  =  font handle / font pointer
;*                 BP     =  attr index for characters 
;*                 CX     =  pa_fs                     
;*                 ES:SI --> attribute bundle          
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = EAX = 1
;* RETURN-ERROR  = EAX = 0
;*
;**************************************************************************/

ALIGN 4
SetMarkerFont   PROC SYSCALL USES edi

        DebugMsg <SetMarkerFont, resolvec, CLIFFL>

ifdef FIREWALLS

        mov     [ebx].ddc_ma.ma_paus,INVALID_SEL

endif

;/*
;** Get all the data from the defs bundle while we still have it's pointer
;** If this is a user supplied font, the code page will be in the defs
;** bundle.  If it is the default, we want to set the default code page
;** so we don't try for the mapping vector.
;*/

        ASSUME  esi:PTR DMARKERBUNDLE

        mov     edx,[ebx].ddc_ma.ma_pFont

        ASSUME  edx:PTR FOCAFONT

ifndef JFIX        ;IBMJ
        mov     esi,[esi].dmbnd_mdef.mdef_CodePage
        or      ecx,ecx
else  ;JFIX        ;IBMJ
 lea eax,[esi].dmbnd_mbnd
 add eax,[esi].dmbnd_cAttr
 mov     esi,[eax].mdef_CodePage
 or cx,cx
endif ;JFIX        ;IBMJ
        js      @F

        .errnz  CA_USER_FONT-8000h

        mov     esi,DEFAULTVIOCODEPAGE
@@:

;/*
;** Now reach into the font and pull out lots of good information so we
;** can set a bunch of different CA_ flags.  It seems a little unusual
;** to execute this code even for the default marker, but someday we
;** might allow the font to be set at initialization time.
;*/

        xor     eax,eax

        or      ecx,CA_VECTOR
        test    [edx].ff_fmMetrics.foca_fsDefn,FD_VECTOR
        jne     smf_all_done                     
        and     ecx,not CA_VECTOR;It is raster

;/*
;** its a raster font, the display driver can't handle huge fonts
;** (but the engine now can handle huge vectore fonts)
;*/

        test    [edx].ff_fmMetrics.foca_fsTypeFlags,FM_TYPE_64K
        jnz     smf_log_huge_error;Font is huge, don't accept it

        cmp     [edx].ff_fdDefinitions.fdh_xCellWidth,8
        jne     @F
        or      ecx,CA_WIDTH_IS_8
@@:
        test    [edx].ff_fmMetrics.foca_fsTypeFlags,FM_FIXED_PITCH
        jz      @F
        or      ecx,CA_FIXED_PITCH
@@:
        cmp     [edx].ff_fdDefinitions.fdh_fsChardef,FONTDEFCHAR3
        jne     @F
        or      ecx,CA_ABC_SPACE
@@:

;/*
;** If the font is not in the default code page (850), then no mapping
;** is possible.If the font is the default code page and a different
;** code page is to be used, get the mapping array.  If getting the
;** mapping array fails, return an error.
;*/

        cmp     [edx].ff_fmMetrics.foca_usCodePage,DEFAULTVIOCODEPAGE
        jne     smf_all_done
        cmp     esi,DEFAULTVIOCODEPAGE
        je      smf_all_done
        or      esi,esi                           ;0 = use the default in the font
        je      smf_all_done

;/*
;** Get the mapping vector for this code page.  Don't bother to get access
;** now since the access test has to be made at output time.
;*/

ifdef  JFIX        ;IBMJ
 push ecx
 push edx
endif ;JFIX        ;IBMJ
        INVOKE  Gre32Entry3, esi, 0, NGreQueryCodePageVector
ifdef  JFIX        ;IBMJ
 pop edx
 pop ecx
endif ;JFIX        ;IBMJ

        mov     [ebx].ddc_ma.ma_paus,eax
        or      eax,eax
        jz      smf_exit                         ;Error, return 0
        or      ecx,CA_MUST_MAP

smf_all_done:

        or      [ebx].ddc_ma.ma_ba.ba_fb,BA_REREALIZE
        mov     eax,1

smf_exit:

        RET

smf_log_huge_error:

        mov     eax,PMERR_HUGE_FONTS_NOT_SUPPORTED

        save_error_code

        xor     eax,eax

        jmp     smf_exit

SetMarkerFont   ENDP

end
