;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = OEMINIT.ASM
;*
;*
;* VERSION      V2.0
;*
;* DATE         08/02/91
;*
;* DESCRIPTION  This is part of the DBCS-NLS support dependent sourcesfor OEM.
;*              This module offers the mechanism to the display driver,
;*              to support both SBCS/DBCS OS/2 system environment.
;*
;* FUNCTIONS    OEM_DbcsGetRuntimeOptions
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   08/02/91                     Written by Soh Ohta [jl09057 @ ymtvm3]
;*
;*****************************************************************************/

        .386

        .MODEL FLAT

         ASSUME  CS:FLAT,SS:FLAT,DS:FLAT,ES:FLAT

        .XLIST

INCL_DOSNLS             equ     1
INCL_FONTFILEFORMAT     equ     1
INCL_GRE_FONTS          equ     1
INCL_DEV                equ     1
INCL_VIO                equ     1
INCL_DDIMISC            equ     1

INCL_DDIFONTSTRUCS EQU 1

        OPTION  OLDSTRUCTS

        include pmgre.inc

DINCL_VIO       equ     1
DINCL_ERROR     equ     1
DINCL_ENABLE    equ     1
DINCL_BITMAP    equ     1

        include driver.inc
        include fontseg.inc
        include extern.inc
        include protos.inc

        .LIST

        .DATA

public          swDrvCompat
public          swDrvFontRes
swDrvCompat     dw      0          ; driver version compatibility
swDrvFontRes    dw      0          ; driver version compatibility

szAppDisplay    db      'PMNLS_Display',0
szKeyCompat     db      'Compatibility',0
szKeyFontRes    db      'FontResolution',0
szKeySysFont    db      'SystemFont',0
szKeyVioFont    db      'VioFonts',0
szAppTemp       db      'PMNLSFNT_TMP',0
szKeyDirect     db      'DIRECTION',0

ifdef IBMJ  ; IBMJ application compatibility

public          swDrvSaveScreenBits
public          swDrvAdjustCellSize
swDrvSaveScreenBits dd  0   ; enable debugging PM app w/CodeView
swDrvAdjustCellSize dd  0   ; adjust cellsize to 1.x compatibles

szOn            db      'ON',0
szKeySaveScreenBits db  'SAVESCREENBITS',0
szKeyAdjustCellSize db  'ADJUSTCELLSIZE',0

endif;IBMJ

CB_SYSFONT_LO   equ     64              ; profile string max length
CB_SYSFONT_HI   equ     0
HINI_USER_LO    equ     -1
HINI_USER_HI    equ     -1
                .errnz  (HINI_USERPROFILE - HINI_USER_LO)

        .CODE

page

;---------------------------Public-Routine------------------------------;
; OEM_DbcsGetRuntimeOptions
;
;   This entry is called only from one_time_init() at initialization,
;   when DBCS conditional compile flag is set.
;
;   At the time this entry is called:
;   - swFlags is set, according to the system DBCS NLS support condition
;   - ddcInit is set, according to the system codepage
;   - system fonts are not modified yet
;   - device specific initialization is not done yet
;
;   So we can do things here, such as:
;   - system font size and facename override, according to hardware
;     resolution, or any other user selected options
;   - etc.
;
; Entry:
;       none.
; Returns:
;       EAX = 0
; Error Returns:
;       EAX <> 0
; Registers Destroyed:
;       EAX,EBX,ECX,EDX,FLAGS
; Registers Preserved:
;       ESI,EDI,EBP
; Calls:
; History:
;   02-Aug-1991 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;   02-Mar-1992 -by- Soh Ohta [jl09057 @ ymtvm3]
; GDDM OS2-Link compatibility is added.
;   20-Apr-1992 -by- Soh Ohta [jl09057 @ ymtvm3]
; CodeView and OS2-Link compatibility setting is now in config.sys.
;-----------------------------------------------------------------------;

OEM_DbcsGetRuntimeOptions PROC SYSCALL uses ESI EDI EBX
        LOCAL   szDefault[CB_SYSFONT_LO] :BYTE,
                szSysFont[CB_SYSFONT_LO] :BYTE

        test    swFlags,SW_DISPLAY_DBCS
        jz      oem_options_done        ; work as SBCS driver
        cld

; Get generic driver compatibility option from user profile.

        mov     eax,adDevCapsData[SIZE_DWORD*CAPS_DRIVER_VERSION]
        shr     eax,8                    ; AX = major driver version
        mov     swDrvCompat,ax           ; ... is the default value.

        INVOKE  PrfQueryProfileInt,
                HINI_USER,
                ADDR szAppDisplay,
                ADDR szKeyCompat,
                swDrvCompat
        mov     swDrvCompat,ax
        mov     swDrvFontRes,ax

; Override each option selections. If an option is not specified,
; use the driver version as a default compatibility version.

        INVOKE  PrfQueryProfileInt,
                HINI_USER,
                ADDR szAppDisplay,
                ADDR szKeyFontRes,
                swDrvFontRes
        mov     swDrvFontRes,ax

ifdef IBMJ  ; IBMJ application compatibility

; Application compatibility key is set in config.sys file.

        lea     edi,szOn                ; EDI --> 'ON'

        lea     eax,szKeySaveScreenBits ; EAX --> 'SAVESCREENBITS'
        INVOKE  CheckEnvironmentSwitch
        mov     swDrvSaveScreenBits,eax ; config.sys setting: 1 or 0

        lea     eax,szKeyAdjustCellSize ; EAX --> 'ADJUSTCELLSIZE'
        INVOKE  CheckEnvironmentSwitch
        mov     swDrvAdjustCellSize,eax ; config.sys setting: 1 or 0

endif;IBMJ

; Get Vio font selection from user profile.
; The string format must be: "familyname"

oem_get_viofont:
        lea     eax,szSysFont
        lea     ebx,szDefault
        lea     ecx,szAppDisplay
        lea     edx,szKeyVioFont
        mov     byte ptr [ebx][0],0   ; default Vio font familyname

        INVOKE  PrfQueryProfileString,
                HINI_USER,
                ecx,
                edx,
                ebx,
                eax,
                FACESIZE
        or      eax,eax
        jz      oem_get_sysfont         ; not specified. use driver default.

        mov     ebx,FACESIZE
        sub     ebx,eax
        mov     ecx,eax                 ; ECX = profile string length
        lea     edi,szVioFontName       ; EDI --> usVioFontName
        lea     esi,szSysFont           ; ESI --> usSysFont
        rep     movs byte ptr [edi],byte ptr [esi]
        mov     ecx,ebx
        xor     al,al
        rep     stosb

; Get system font selection from user profile.
; The string format must be: "facename,width,height"

oem_get_sysfont:
        lea     eax,szSysFont
        lea     ebx,szDefault
        lea     ecx,szAppDisplay
        lea     edx,szKeySysFont
        mov     byte ptr [ebx][0],0        ; default system font facename

        INVOKE  PrfQueryProfileString,
                HINI_USER,
                ecx,
                edx,
                ebx,
                eax,
                CB_SYSFONT_LO
        or      eax,eax
        jz      oem_have_options        ; not specified. use driver default.

        lea     esi,szSysFont           ; ESI --> profile string
        mov     ecx,eax                 ; ECX = profile string length
        xor     edi,edi                 ; EDI = facename string length
        xor     ebx,ebx                 ; EBX = font width
        xor     edx,edx                 ; EDX = font height
        xor     eax,eax                 ; EAX = 0
oem_get_facename:
        lods    byte ptr [esi]
        dec     ecx
        cmp     al,','
        je      oem_get_width
        inc     edi                     ; facename string length++
        cmp     edi,FACESIZE
        ja      oem_err_sysfont         ; facename too long
        jcxz    oem_err_sysfont         ; width/height not specified
        jmp     oem_get_facename

        public  oem_get_width
oem_get_width::
        lods    byte ptr [esi]
        dec     ecx
        cmp     al,','
        je      oem_get_height
        sub     al,'0'
        cmp     al,9
        ja      oem_err_sysfont         ; non digit data specified
        imul    ebx,ebx,10
        jo      oem_err_sysfont         ; value overflowed
        add     ebx,eax
        jo      oem_err_sysfont         ; value overflowed
        jcxz    oem_err_sysfont         ; height not specified
        jmp     oem_get_width
oem_get_height:
        lods    byte ptr [esi]
        cmp     al,0
        je      oem_have_sysfont
        sub     al,'0'
        cmp     al,9
        ja      oem_err_sysfont         ; non digit data specified
        imul    edx,edx,10
        jo      oem_err_sysfont         ; value overflowed
        add     edx,eax
        jo      oem_err_sysfont         ; value overflowed
        loop    oem_get_height
oem_have_sysfont:
        mov     usSysFontWidth,ebx      ; system font width
        mov     usSysFontHeight,edx     ; system font height

        mov     ebx,FACESIZE
        sub     ebx,edi
        mov     ecx,edi                 ; ECX = system font facename length
        lea     edi,szSysFontName       ; EDI --> usSysFontName
        lea     esi,szSysFont           ; ESI --> usSysFont
        rep     movs byte ptr [edi],byte ptr [esi]
        mov     ecx,ebx
        xor     al,al
        rep     stosb

oem_have_options:
        xor     eax,eax                 ; show success
        jmp     oem_options_done

oem_err_sysfont:
        mov     eax,-1                  ; show error
oem_options_done:
        ret
OEM_DbcsGetRuntimeOptions ENDP

page

;---------------------------Public-Routine------------------------------;
; CheckEnvironmentSwitch
;
;   Check setting in environment variable for shell process.
;
; Entry:
;   EDI   = value to be compared      (must be in upper-cases)
;   EAX   = environment variable name (must be in upper-cases)
; Returns:
;   EAX   = 1   switch on
;   EAX   = 0   switch off
; Registers Destroyed:
;   EAX,EBX,ECX,EDX,ESI,EDI,FLAGS
; Registers Preserved:
;   EBP
; Calls:
; History:
;   20-Apr-1992 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;-----------------------------------------------------------------------;

CheckEnvironmentSwitch PROC SYSCALL
        LOCAL   pszValue  :DWORD

; Get value in environment variable for shell process.

        mov     ebx,eax
        INVOKE  DosScanEnv,
                ebx,
                ADDR pszValue
        or      eax,eax
        jnz     ces_switch_off          ; variable is not set

; Remove proceeding white spaces.

        mov     esi,pszValue             ; ESI --> value
        cld
ces_pre_whites:
        lodsb
        cmp     al,20h                  ; space
        je      ces_pre_whites
        cmp     al,09h                  ; horizontal tab
        je      ces_pre_whites
        cmp     al,00h                  ; null-terminator
        je      ces_switch_off
        dec     esi                     ; undo last lodsb

; Perform stricmp.

ces_icomp_loop:
        lodsb
        sub     al,'a'
        cmp     al,'z'
        ja      @f
        sub     al,'a'-'A'
    @@: add     al,'a'                  ; AL = uppercase
        scasb
        jnz     ces_switch_off          ; not equal
        or      al,al
        jz      ces_switch_on           ; equal, null terminator
        jmp     ces_icomp_loop    ; equal, continue

ces_switch_on:
        mov     eax,1                   ; indicate switch is on
        jmp     ces_done
ces_switch_off:
        xor     eax,eax                 ; indicate switch is off
ces_done:
        ret
CheckEnvironmentSwitch ENDP

end
