;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
ifdef FIREWALLS
;/*****************************************************************************
;*
;* SOURCE FILE NAME = FIREWALL.ASM
;*
;* DESCRIPTIVE NAME = Firewalls debug code
;*
;*
;* VERSION      V2.0
;*
;* DATE         
;*
;* DESCRIPTION  Contains the code to process a rip,  Assemebled only if FIREWALL is    
;*              defined.                                                               
;*
;* FUNCTIONS    
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/

.386
.MODEL FLAT
ASSUME  SS:FLAT, DS:FLAT, CS:FLAT, ES:FLAT

        .xlist
        include pmgre.inc
DINCL_ENABLE    equ     1
        include driver.inc
        include protos.inc
        .list

        externdef Win32SetErrorInfo:PROC ;STJ

SEIOptions  = SEI_NOBEEP + SEI_NOPROMPT

;/*
;**             --------------Macro-----------
;** ErrMsg is the macro which will define each errro message.  Each
;** error message will have is offset from the start of the table
;** defined as an absolute which can be accessed by an ExternA
;** declaration.
;**
;** Usage:
;**       errmsg name,text
;** Where:
;**       name - the name it will be referenced by
;**       text - the contents of the error message
;*/

errmsg  macro   name,text
public  msg_&name
msg_&name BYTE '&text',0
endm

.DATA
error_messages  label   byte

;/*
;** These are the new ones which are used in the driver to date.
;*/

errmsg  ColorTableNotDefault,<Validate - Color table should be the default but is not>
errmsg  BadPolySLPair,<Start/Stop Y values must match in the 2 PolyShortLines>
errmsg  BitBltError,<BitBlt returned an unexpected error>
errmsg  assert,<Generic assertion failure>
.CODE

;/***************************************************************************
;*
;* FUNCTION NAME = perform_rip 
;*
;* DESCRIPTION   = The given error message is passed to WinSetErrorInfo with the
;*                 abort flag set                                               
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

perform_rip PROC SYSCALL,
        npError:DWORD
        LOCAL   Sev_Error:DWORD

        pushfd
        pushad

        mov     WORD PTR Sev_Error[0],1               ; Firewall: %s
        mov     WORD PTR Sev_Error[2],SEVERITY_SEVERE ; =0Ch

        push    npError                 ;STJ
        push    SEIOptions              ;STJ
        push    Sev_Error               ;STJ
        call    Win32SetErrorInfo       ;STJ
        add     esp,12                  ;STJ

        popad
        popfd

        ret
perform_rip ENDP

endif ;FIREWALLS

end
