;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = ERROR.ASM
;*
;* DESCRIPTIVE NAME = Error declarations
;*
;*
;* VERSION      V2.0
;*
;* DATE         09/01/90
;*
;* DESCRIPTION  Contains the display driver error declarations
;*
;* FUNCTIONS  save_that_warning 
;*            save_that_error 
;*            save_that_unrecoverable_error 
;*            save_that_severe_error 
;*            save_that_???_error
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   09/01/90                      Rewrite for 32 bit OS/2 - ScottL @ Micrografx
;*****************************************************************************/

.386
.MODEL FLAT
ASSUME  SS:FLAT, DS:FLAT, CS:FLAT, ES:FLAT


        .xlist
INCL_GPIERRORS  equ     1
INCL_WINSEI     equ     1
OS2_NOBASEAPI   equ     1
        include pmgre.inc
        include pmsei.inc
DINCL_ERROR             equ     1
SAVE_THAT_ERROR_DEFINED equ     1
SAVE_THAT_WARNING_DEFINED       equ     1
SAVE_THAT_UNRECOVERABLE_DEFINED equ     1
DINCL_ENABLE            equ     1
        include driver.inc
        include protos.inc
        .list

        PUBLIC  PMERR_INV_FONT_ATTRS
        PUBLIC  PMERR_FONT_NOT_LOADED
        PUBLIC  PMERR_INV_SETID
        PUBLIC  PMERR_BASE_ERROR
        PUBLIC  PMERR_BITMAP_IS_SELECTED
        PUBLIC  PMERR_BITMAP_NOT_SELECTED
        PUBLIC  PMERR_COL_TABLE_NOT_REALIZABLE
        PUBLIC  PMERR_COORDINATE_OVERFLOW
        PUBLIC  PMERR_INCORRECT_DC_TYPE
        PUBLIC  PMERR_INSUFFICIENT_MEMORY
        PUBLIC  PMERR_INV_BACKGROUND_COL_ATTR
        PUBLIC  PMERR_INV_BACKGROUND_MIX_ATTR
        PUBLIC  PMERR_INV_BITBLT_MIX
        PUBLIC  PMERR_INV_CHAR_DIRECTION_ATTR
        PUBLIC  PMERR_INV_CHAR_MODE_ATTR
        PUBLIC  PMERR_INV_COLOR_ATTR
        PUBLIC  PMERR_INV_COLOR_DATA
        PUBLIC  PMERR_INV_COLOR_FORMAT
        PUBLIC  PMERR_INV_COLOR_OPTIONS
        PUBLIC  PMERR_INV_COLOR_INDEX
        PUBLIC  PMERR_INV_COLOR_START_INDEX
        PUBLIC  PMERR_INV_COORDINATE
        PUBLIC  PMERR_INV_DC_TYPE
        PUBLIC  PMERR_INV_HBITMAP
        PUBLIC  PMERR_INV_HDC
        PUBLIC  PMERR_INV_BITMAP_DIMENSION
        PUBLIC  PMERR_INV_INFO_TABLE
        PUBLIC  PMERR_INV_IN_PATH
        PUBLIC  PMERR_INV_IN_AREA
        PUBLIC  PMERR_INV_LENGTH_OR_COUNT
        PUBLIC  PMERR_INV_LINE_TYPE_ATTR
        PUBLIC  PMERR_INV_MIX_ATTR
        PUBLIC  PMERR_INV_PATTERN_ATTR
        PUBLIC  PMERR_INV_PICK_APERTURE_POSN
        PUBLIC  PMERR_INV_QUERY_ELEMENT_NO
        PUBLIC  PMERR_INV_RECT
        PUBLIC  PMERR_INV_RGBCOLOR
        PUBLIC  PMERR_INV_SCAN_START
        PUBLIC  PMERR_INV_CODEPAGE
        PUBLIC  PMERR_KERNING_NOT_SUPPORTED
        PUBLIC  PMERR_REALIZE_NOT_SUPPORTED
        PUBLIC  PMERR_COL_TABLE_NOT_REALIZED
        PUBLIC  PMERR_BOUNDS_OVERFLOW
        PUBLIC  PMERR_PEL_IS_CLIPPED
        PUBLIC  PMERR_INV_FIRST_CHAR
        PUBLIC  PMERR_DEV_FUNC_NOT_INSTALLED
        PUBLIC  PMERR_HUGE_FONTS_NOT_SUPPORTED
        PUBLIC  PMERR_INV_CURSOR_BITMAP
        PUBLIC  PMERR_INV_DRAW_BORDER_OPTION
        PUBLIC  PMERR_INV_IMAGE_DATA_LENGTH
        PUBLIC  PMERR_INV_PATTERN_REF_PT_ATTR
        PUBLIC  PMERR_PEL_NOT_AVAILABLE
        PUBLIC  PMERR_INV_PATTERN_SET_ATTR
        PUBLIC  PMERR_INV_PATTERN_SET_FONT
        PUBLIC  PMERR_INV_BITBLT_STYLE
        PUBLIC  PMERR_HARDWARE_INIT_FAILURE             
        PUBLIC  PMERR_PALETTE_SELECTED
        PUBLIC  PMERR_INV_OR_INCOMPAT_OPTIONS
        PUBLIC  PMERR_INV_CHAR_ALIGN_ATTR
ifdef DBCS  ; DBCS device font support     ;IBMJ
 PUBLIC PMERR_INV_ESCAPE_DATA
endif;DBCS        ;IBMJ

        externdef Win32SetErrorInfo:PROC ;STJ
.DATA
        externdef       fbRip:BYTE
        externdef       CodeData:WORD
.CODE

;/***************************************************************************
;*
;* FUNCTION NAME = save_that_warning
;*
;* DESCRIPTION   = Sets up a severity level and jumps to save_that_???_error
;*
;*                 Registers Destroyed:
;*                    AX,BX,CX,DX,ES
;*
;* INPUT         = AX = Error code             
;*                 BX = (maybe) DOS error code 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

fOptions        equ     SEI_NOBEEP + SEI_NOPROMPT
fDosOptions     equ     SEI_NOBEEP + SEI_NOPROMPT + SEI_DOSERROR
OPTION PROLOGUE:None
OPTION EPILOGUE:None

save_that_warning PROC  SYSCALL
        mov     cl,SEVERITY_WARNING
        jmp     save_that_???_error
save_that_warning ENDP

;/***************************************************************************
;*
;* FUNCTION NAME = save_that_error
;*
;* DESCRIPTION   = Sets up a severity level and jumps to save_that_???_error
;*
;*                 Registers Destroyed:
;*                    AX,BX,CX,DX,ES
;*
;* INPUT         = AX = Error code             
;*                 BX = (maybe) DOS error code 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

save_that_error PROC    SYSCALL
        mov     cl,SEVERITY_ERROR
        jmp     save_that_???_error
save_that_error ENDP

;/***************************************************************************
;*
;* FUNCTION NAME = save_that_unrecoverable_error
;*
;* DESCRIPTION   = Sets up a severity level and jumps to save_that_???_error
;*
;*                 Registers Destroyed:
;*                    AX,BX,CX,DX,ES
;*
;* INPUT         = AX = Error code             
;*                 BX = (maybe) DOS error code 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

save_that_unrecoverable_error PROC      SYSCALL
        mov     cl,SEVERITY_UNRECOVERABLE
        jmp     save_that_???_error
save_that_unrecoverable_error ENDP

;/***************************************************************************
;*
;* FUNCTION NAME = save_that_severe_error
;*
;* DESCRIPTION   = Sets up a severity level and jumps to save_that_???_error
;*
;*                 Registers Destroyed:
;*                    AX,BX,CX,DX,ES
;*
;* INPUT         = AX = Error code             
;*                 BX = (maybe) DOS error code 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

save_that_severe_error PROC     SYSCALL
        mov     cl,SEVERITY_SEVERE
        jmp     save_that_???_error
save_that_severe_error ENDP

OPTION PROLOGUE:PROLOGUEDEF
OPTION EPILOGUE:EPILOGUEDEF

;/***************************************************************************
;*
;* FUNCTION NAME = save_that_???_error
;*
;* DESCRIPTION   = Calls WinSetErrorInfo to save away the error code.  If AX is    
;*                 PMERR_BASE_ERROR then we save BX as the DOS error code as well. 
;*
;*                 Registers Destroyed:
;*                    AX,BX,CX,DX,ES
;*
;* INPUT         = AX = Error code             
;*                 BX = (maybe) DOS error code 
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

save_that_???_error PROC SYSCALL USES EBX
LOCAL   Error_Options:DWORD
LOCAL   Sev_Error:DWORD
LOCAL   Rip_Error:DWORD
LOCAL   Rip_Options:DWORD
LOCAL   Error_Code:WORD

;/*
;**In the messagetable in the display.rc file are the messages
;**that get printed out for a rip.
;*/
        xor     ch,ch
        mov     Error_Code,ax
        mov     WORD PTR Sev_Error[0],ax     ; Error Code PMERR_*
        mov     WORD PTR Sev_Error[2],cx     ; Severity (0, 4, 8, C, or 10h)

;/*
;** Do this in case we need it later
;*/

        mov     WORD PTR Error_Options[0],fDosOptions
        mov     WORD PTR Error_Options[2],bx     ; Dos Error Code PMERR_*
;/*
;** handle non DOS case
;*/

        cmp     Error_Code,PMERR_BASE_ERROR
        jz      save_dos_error


        push    fOptions                ;        
        push    Sev_Error               ;        
        call    Win32SetErrorInfo       ;        
        add     esp,8                   ;        

        test    fbRip,DDF_RIP_ERROR               ; check rip flag
        jnz     do_int3
        jmp     error_is_saved

save_dos_error:

;/*
;** handle DOS case
;*/

        push    Error_Options           ;        
        push    Sev_Error               ;        
        call    Win32SetErrorInfo       ;        
        add     esp,8                   ;        

        test    fbRip,DDF_RIP_ERROR               ; check rip flag
        jz      error_is_saved
do_int3:
        int 3

error_is_saved:
        ret
save_that_???_error ENDP

        end
