;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = DISPATCH.ASM
;*
;* DESCRIPTIVE NAME = Default function handler dispatch table
;*
;*
;* VERSION      V2.0
;*
;* DATE         01/12/88
;*
;* DESCRIPTION  This file contains the default function handler dispatch table.
;*              The table initially contains the address of each function the
;*              driver will hook.  Upon the very first enable call, the contents
;*              of the table will be replaced with the default dispatch table
;*              passed to us by the Engine, and any address in the table which is
;*              non-null will be placed in the Engine's table.  All communications
;*              between the engine and the driver will then take place through this
;*              table.
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   01/12/88                     Written by Walt Moore
;*   08/05/92                     DAK some more stuff needs to be at ring 2,
;*                                DAK49283
;*   11/26/92                     John Batty. Added DCAF changes.
;*   01/12/93                     Eric Farr. Remove Defect 59009. See def 60027.
;*   08/20/93                     Torgny Stadler.  Change major code F1->DE.
;*
;*****************************************************************************/

.386
.MODEL FLAT
ASSUME  SS:FLAT, DS:FLAT, CS:FLAT, ES:FLAT

        .xlist
INCL_GPIBITMAPS equ     1        ; needed for palette structures
;/*                                                                  ;          
;** Define all of the components that need to be included            ;          
;** individually to minimise the amount of symbol space required.    ;          
;** (rather that using the "lazy" INCL_GREALL).                      ;          
;*/                                                                  ;          
INCL_GRE_BITMAPS   equ 1                                             ;          
INCL_GRE_LINES     equ 1                                             ;          
INCL_GRE_XFORMS    equ 1                                             ;          
INCL_GRE_MARKERS   equ 1                                             ;          
INCL_GRE_CLIP      equ 1                                             ;          
INCL_GRE_DEVMISC1  equ 1                                             ;          
INCL_GRE_DEVMISC2  equ 1                                             ;          
INCL_GRE_STRINGS   equ 1                                             ;          
INCL_GRE_PALETTE   equ 1                                             ;          
INCL_GRE_REGIONS   equ 1                                             ;          
ifdef DCAF                                                           ;          
;/*                                                                  ;          
;** Set these flags so that the DCAF prototypes in PROTOS.INC and    ;          
;** the main DCAF.INC file are not included. This is because on      ;          
;** some systems the DEKKO build fails with an "out of near memory"  ;          
;** error.                                                           ;          
;** See defect 61002 for more details.                               ;          
;*/                                                                  ;          
EXCLUDE_DCAF_PROTOS equ 1                                            ;          
EXCLUDE_DCAF_INC    equ 1                                            ;          
endif ;DCAF                                                          ;          
        include pmgre.inc

        include driver.inc
        include protos.inc

ifdef DCAF                                                           ;          
OpenScreenChangeArea            PROTO SYSCALL                        ;          
GetScreenChangeArea             PROTO SYSCALL                        ;          
CloseScreenChangeArea           PROTO SYSCALL                        ;          
GetScreenBitsStub               PROTO SYSCALL                        ;          
SetScreenBitsStub               PROTO SYSCALL                        ;          
endif ;DCAF                                                          ;          


;DEKKO_BUILD EQU 1               ;used to enable or disable dekko builds
                                 ;comment out if not a dekko build

IFDEF DEKKO_BUILD
;        include dekmac3.inc

_Dekko32Trace PROTO SYSCALL,
        usMajor         :WORD,
        usMinor         :WORD,
        usLength        :WORD,
        fpData          :DWORD

ENDIF ;DEKKO_BUILD
        .list

;/*
;** The following macros are used to create the dispatch table, perform
;** error checking on entries' position within the table, and generate
;** a public label of the form pfnDefxxxx where xxxx is the function name.
;*/

.DATA

        PUBLIC  OS2_PM_DRV_ENABLE_LEVELS
        PUBLIC  OS2_PM_DRV_RING_LEVELS

OS2_PM_DRV_ENABLE_LEVELS BYTE   16  DUP (2)
                        BYTE    0               ;end of table

_TABLE  SEGMENT PUBLIC 'DATA'
;OS2_PM_DRV_RING_LEVELS
;
;BYTE    255 DUP (2)
;                        BYTE    0               ;end of table
_TABLE  ENDS


IFDEF DEKKO_BUILD

ALIGN 4
        DBUF_RECORD     STRUCT  1t
                InUse           DWORD   0
                FunN            DWORD   0
                Return          DWORD   0
                ; CALL [DekkoLeavePtr]
                CallGate        WORD    015ffh
                CallTo          DWORD   OFFSET  DekkoLeavePtr
        DBUF_RECORD ENDS
        PDBUF_RECORD typedef PTR DBUF_RECORD

;/*
;** This allows for up to 50 threads to re-enter us at a time
;** any more and all calling threads will start looping until
;** one of the BUF_RECORD's becomes available...
;*/

        PUBLIC Dekko_Buf, Dekko_BufEnd, DekkoLeavePtr

        Dekko_Buf       DBUF_RECORD  50 DUP  (<>)
        Dekko_BufEnd    Label  DWORD

        DekkoLeavePtr   DWORD   OFFSET DekkoLeave

        HookCounter = 0
ENDIF ;DEKKO_BUILD

table_start     macro   myname
        public  myname
myname  equ     this dword
?mystart = myname
_TABLE  SEGMENT PUBLIC 'DATA'
OS2_PM_DRV_RING_LEVELS   equ this byte
_TABLE  ENDS

        endm

table_entry     macro   myname,realname
ifdif <myname>,<-1>
        ifdif <myname>,<0>
IFDEF DEKKO_BUILD
                dd      myname&dekko
.CODE
                PUBLIC myname&dekko
                myname&dekko::
                PUSH    OFFSET myname
                PUSH    HookCounter
                JMP     DekkoEnter      ;DekkoEnter(HookCounter,myname)
.DATA
ELSE  ;DEKKO_BUILD
        dd      myname
ENDIF ;DEKKO_BUILD

        _TABLE  SEGMENT PUBLIC 'DATA'   ;;
ifdif <realname>,<2>                    ;;
        db      1       ;Conforming     ;;
else                                    ;;
        db      2       ;run at ring2   ;;
endif                                   ;;
        _TABLE  ENDS                    ;;

        else ;ifdif <myname>,<0>

        _TABLE  SEGMENT PUBLIC 'DATA'           ;;

        db      2       ;ring2
        _TABLE  ENDS                            ;;

                dd      myname
        endif
else ;ifdif <myname>,<-1>
        ;Doesn't happen
        dd      0
endif ;ifdif <myname>,<-1>
IFDEF DEKKO_BUILD
        HookCounter = HookCounter + 1
ENDIF ;DEKKO_BUILD
endm

table_end       macro   myname
        public  myname&_size
myname&_size    =       ($ - ?mystart)/4
_TABLE  SEGMENT PUBLIC 'DATA'
        BYTE    0               ;end of table
_TABLE  ENDS
        endm


;/*
;** The following defines the entries of the dispatch table
;*/

dispatch_of_death       macro   name
        table_start     name
        table_entry     0,GetArcParameters
        table_entry     0,SetArcParameters
        table_entry     0,Arc
        table_entry     0,PartialArc
        table_entry     0,FullArcInterior
        table_entry     0,FullArcBoundary
        table_entry     0,FullArcBoth
        table_entry     0,BoxInterior
        table_entry     0,BoxBoundary
        table_entry     0,BoxBoth
        table_entry     0,PolyFillet
        table_entry     0,PolyFilletSharp
        table_entry     0,PolySpline
        table_entry     0,DrawConicsInPath
        table_entry     0,CookWholePath
        table_entry     0,CookPathCurves
        table_entry     0,OK
        table_entry     0,RenderPath
ifdef DCAF
ifdef DEKKO_BUILD
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
else ; DEKKO_BUILD
        table_entry     OpenScreenChangeArea,2         ;NO R3        ;          
        table_entry     GetScreenChangeArea,2          ;NO R3        ;          
        table_entry     CloseScreenChangeArea,2        ;NO R3        ;          
endif ; DEKKO_BUILD
else ; DCAF                                                          ;          
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
endif ; DCAF                                                         ;          
        table_entry     0,OK

        table_entry     DisjointLines,2                 ;NO R3
        table_entry     GetCurrentPosition,2            ;NO R3
        table_entry     SetCurrentPosition,2            ;NO R3
        table_entry     PolyLine,2                      ;NO R3
        table_entry     DrawLinesInPath,2               ;NO R3
        table_entry     PolyShortLine,2                 ;NO R3
        table_entry     PolyScanline,2                  ;NO R3
ifdef DCAF                                                           ;          
ifdef DEKKO_BUILD
        table_entry     0,OK
        table_entry     0,OK
else ; DEKKO_BUILD
        table_entry     GetScreenBitsStub,2             ;NO R3       ;          
        table_entry     SetScreenBitsStub,2             ;NO R3       ;          
endif ; DEKKO_BUILD
else ; DCAF                                                          ;          
        table_entry     0,OK
        table_entry     0,OK
endif ; DCAF                                                         ;          
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     DrawBits,2                      ;NO R3       ;          
        table_entry     DeviceCreateBitmap,2            ;NO R3
        table_entry     DeviceDeleteBitmap,2            ;NO R3
        table_entry     DeviceSelectBitmap,2            ;NO R3
        table_entry     Bitblt,2                        ;NO R3
        table_entry     GetPel,2                        ;NO R3
        table_entry     SetPel,2                        ;NO R3
        table_entry     ImageData,2                     ;NO R3
        table_entry     0,OK
        table_entry     0,OK
        table_entry     SaveScreenBits,2                ;NO R3
        table_entry     RestoreScreenBits,2             ;NO R3
        table_entry     DrawBorder,2                    ;NO R3
        table_entry     DeviceSetCursor,2               ;NO R3
        table_entry     GetBitmapBits,2                 ;           R3  OK
        table_entry     SetBitmapBits,2                 ;           R3  OK
        table_entry     SetColorCursor,2                ;NO R3
        table_entry     0,OK
        table_entry     0,OK

        table_entry     CharString,2                    ;NO R3
        table_entry     CharStringPos,2                 ;NO R3
ifndef DBCS        ;IBMJ
        table_entry     0,QueryTextBox
        table_entry     0,QueryCharPositions
        table_entry     0,QueryWidthTable
else ;DBCS  ; DBCS device font support     ;IBMJ
 table_entry QueryTextBox
 table_entry QueryCharPositions
 table_entry QueryWidthTable
endif;DBCS        ;IBMJ
        table_entry     PolyMarker,2                    ;NO R3
        table_entry     CharRect,2                      ;NO R3
        table_entry     CharStr,2                       ;NO R3
        table_entry     ScrollRect,2                    ;NO R3
        table_entry     UpdateCursor,2                  ;NO R3
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK

        table_entry     0,BeginArea
        table_entry     0,EndArea
        table_entry     0,BeginPath
        table_entry     0,EndPath
        table_entry     0,CloseFigure
        table_entry     0,FillPath
        table_entry     0,OutlinePath
        table_entry     0,ModifyPath
        table_entry     0,StrokePath
        table_entry     0,SelectClipPath
        table_entry     0,SavePath
        table_entry     0,RestorePath
        table_entry     0,Clip1DPath
        table_entry     0,DrawRawPath
        table_entry     0,DrawCookedPath
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK

        table_entry     0,GetRegionBox
        table_entry     0,GetRegionRects
        table_entry     0,OffsetRegion
        table_entry     0,PtInRegion
        table_entry     0,RectInRegion
        table_entry     0,CreateRectRegion
        table_entry     0,DestroyRegion
        table_entry     0,SetRectRegion
        table_entry     0,CombineRegion
        table_entry     0,CombineRectRegion
        table_entry     0,CombineShortLineRegion
        table_entry     0,EqualRegion
        table_entry     0,PaintRegion
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK

        table_entry     0,GetClipBox
        table_entry     0,GetClipRects
        table_entry     0,OffsetClipRegion
        table_entry     0,PtVisible
        table_entry     0,RectVisible
        table_entry     0,QueryClipRegion
        table_entry     0,SelectClipRegion
        table_entry     0,IntersectClipRectangle
        table_entry     0,ExcludeClipRectangle
        table_entry     0,SetXformRect
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,SaveRegion
        table_entry     0,RestoreRegion
        table_entry     0,ClipPathCurves
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK

        table_entry     0,GetPageUnits
        table_entry     0,SetPageUnits
        table_entry     0,GetModelXform
        table_entry     0,SetModelXform
        table_entry     0,GetWindowViewportXform
        table_entry     0,SetWindowViewportXform
        table_entry     0,GetGlobalViewingXform
        table_entry     0,SetGlobalViewingXform
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,GetPageViewport
        table_entry     0,SetPageViewport
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,GetGraphicsField
        table_entry     0,SetGraphicsField
        table_entry     0,GetViewingLimits
        table_entry     0,SetViewingLimits
        table_entry     0,QueryViewportSize
        table_entry     0,Convert
        table_entry     0,ConvertPath
        table_entry     0,SaveXform
        table_entry     0,RestoreXform
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK

        table_entry     DeviceGetAttributes,2           ;NO R3
        table_entry     DeviceSetAVIOFont2,2            ;           R3  OK
        table_entry     0,OK
        table_entry     GetPairKerningTable,2           ;           R3  OK
        table_entry     0,OK
        table_entry     DeviceSetAttributes,2           ;NO R3
        table_entry     DeviceSetGlobalAttribute,2      ;NO R3
        table_entry     NotifyClipChange,2              ;NO R3
        table_entry     NotifyTransformChange,2         ;NO R3
        table_entry     RealizeFont,2                   ;NO R3
        table_entry     ErasePS,2                       ;NO R3
        table_entry     SetStyleRatio,2                 ;NO R3
        table_entry     DeviceQueryFontAttributes,2     ;           R3  OK
        table_entry     DeviceQueryFonts,2              ;NO R3
        table_entry     DeviceInvalidateVisRegion,2     ;           R3  OK
        table_entry     GetPickWindow,2                 ;NO R3
        table_entry     SetPickWindow,2                 ;NO R3

        table_entry     ResetBounds,2                   ;NO R3
        table_entry     GetBoundsData,2                 ;NO R3
        table_entry     AccumulateBounds,2              ;NO R3
        table_entry     0,OK                            ;Was SetPatternOrigin
        table_entry     0,OK                            ;SetPatternOrigin
        table_entry     GetCodePage,2                   ;           R3  OK
        table_entry     SetCodePage,2                   ;NO R3
        table_entry     LockDevice,2                    ;NO R3
        table_entry     UnlockDevice,2                  ;           R3  OK
        table_entry     Death,2                         ;NO R3
        table_entry     Resurrection,2                  ;NO R3
        table_entry     0,OK
        table_entry     GetDCOrigin,2                   ;NO R3
        table_entry     DeviceSetDCOrigin,2             ;NO R3
        table_entry     GetLineOrigin,2                 ;NO R3
        table_entry     SetLineOrigin,2                 ;NO R3
        table_entry     GetStyleRatio,2                 ;NO R3
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK

        table_entry     QueryColorData,2                ;NO R3
        table_entry     QueryLogColorTable,2            ;NO R3
        table_entry     CreateLogColorTable,2           ;NO R3
        table_entry     RealizeColorTable,2             ;NO R3
        table_entry     UnrealizeColorTable,2           ;NO R3
        table_entry     QueryRealColors,2               ;NO R3
        table_entry     QueryNearestColor,2             ;NO R3
        table_entry     QueryColorIndex,2               ;NO R3
        table_entry     QueryRGBColor,2                 ;NO R3
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK

        table_entry     QueryDeviceBitmaps,1            ;R3 OK
        table_entry     QueryDeviceCaps,1               ;R3 OK
        table_entry     Escape,2                        ;           R3 OK
        table_entry     QueryHardcopyCaps,1             ;R3 OK
        table_entry     QueryDevResource2,1             ;R3 OK

        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK
        table_entry     0,OK

        table_end       name
        endm

;/*
;** The apfnDefDispatch table defines the set of default dispatch functions
;** that the display driver must call back to after processing a hooked
;** function.
;**
;** Each entry in the table is initialized with the index into the default
;** table of the function we want, which will be replaced with the appropriate
;** function address by Enable().
;*/

defdispatch_entry     macro   realname

public  pfnDef&realname
        pfnDef&realname equ this dword

;/*
;** LOOK IN PMDDIM.INC for NGre????? stuff
;*/

        dd      ((NGre&realname and 1ffh) * 4)
endm


.DATA

ALIGN 4
public  apfnDefDispatch
        apfnDefDispatch equ this dword

        defdispatch_entry Bitblt
        defdispatch_entry DrawBits
        defdispatch_entry Convert
        defdispatch_entry DisjointLines
        defdispatch_entry SetCurrentPosition
        defdispatch_entry PolyLine
        defdispatch_entry PolyMarker
        defdispatch_entry PtVisible
        defdispatch_entry RectVisible
        defdispatch_entry SelectClipRegion
        defdispatch_entry GetClipRects
        defdispatch_entry NotifyClipChange
        defdispatch_entry NotifyTransformChange
        defdispatch_entry GetPairKerningTable
        defdispatch_entry CharStringPos
        defdispatch_entry QueryTextBox
        defdispatch_entry QueryCharPositions
        defdispatch_entry GetVisRects
ifdef DCAF                                                           ;          
        ; scrarea.asm and scrbits.asm need to call the region code   ;          
        ; NB This next line is used in a MACRO and MUST NOT have the ;          
        ; DCAF tag at the end of the line or the macro will go       ;          
        defdispatch_entry SetRectRegion
        defdispatch_entry GetRegionBox
        defdispatch_entry GetRegionRects
        defdispatch_entry CombineRectRegion
endif ; DCAF                                                         ;          
ifdef DBCS  ; DBCS device font support     ;IBMJ
 defdispatch_entry QueryWidthTable
endif;DBCS        ;IBMJ
        public  DEF_DISPATCH_TBL_SIZE
DEF_DISPATCH_TBL_SIZE  = ($ - apfnDefDispatch) / 4; 

;/*
;** The following defines the dword label apfnOurDispatch, checks the
;** offsets of all the functions in the table, and defines the absolute
;** apfnDefDispatch_size, which is the count of the entries.
;**
;** This is the table where our handler's address will come from
;*/

.DATA
ALIGN 4
        dispatch_of_death apfnOurDispatch

        public          DEV_DISPATCH_TBL_SIZE
DEV_DISPATCH_TBL_SIZE = apfnOurDispatch_size

IFDEF DEKKO_BUILD
.CODE
ALIGN 4
PUBLIC DekkoEnter
DekkoEnter::
        ;(myname,HookCounter) on the stack

;/*
;**Get Struct in EAX *************************************************
;*/

        ASSUME  EAX:PDBUF_RECORD
SearchStart:
        Mov     EAX,OFFSET Dekko_Buf
        jmp     SearchLoop
ALIGN 4
TryAgain:
        ADD     EAX,SIZEOF DBUF_RECORD
        cmp     EAX,OFFSET Dekko_BufEnd
        JGE     SearchStart     ;Start Over
SearchLoop:
        MOV     ECX,1
        XCHG    ECX,[EAX].InUse
        JECXZ   GotOne
        jmp     TryAgain
ALIGN 4
GotOne: ;************************************************************
        ;EAX NOW POINTS TO RECORD
        POP     ECX                     ;FunN = HookCounter
        MOV     [EAX].FunN,ECX          ;Save it
        INVOKE  _Dekko32Trace,  ;ENTER
                0DE00h,         ;usMajor           
                CX,             ;usMinor
                0,              ;usLength
                0               ;fpData


        POP     ECX                     ;Where to go
        ;Return Addr on top of stack now
        POP     [EAX].Return            ;Return Address
        LEA     EAX,[EAX].CallGate
        PUSH    EAX                     ;Back to our "CallGate"
        jmp     ECX
ALIGN 4
;END of DekkoEnter

PUBLIC DekkoLeave
ALIGN 4
DekkoLeave::
;Address of the end of our structure on the top of the stack
        XCHG    EAX,DWORD PTR [ESP]     ;EAX points to End of the structure
        SUB     EAX,SIZEOF DBUF_RECORD  ;The Start of the structure
        ASSUME  EAX:PDBUF_RECORD

        PUSH    ECX
        MOV     ECX,[EAX].FunN
        INVOKE  _Dekko32Trace,  ;LEAVE
                0DE80h,         ;usMajor           
                CX,             ;usMinor
                0,              ;usLength
                0               ;fpData

        POP     ECX

        PUSH    [EAX].Return
        MOV     [EAX].InUse,0           ;Free The Structure
        POP     EAX
        XCHG    EAX,DWORD PTR [ESP]
        RET
;END of DekkoLeave
ENDIF ;DEKKO_BUILD

end
