;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/

;/*****************************************************************************
;*
;* SOURCE FILE NAME = DEKMAC3.INC
;*
;* DESCRIPTIVE NAME = Dekko Macros
;*
;*
;* VERSION      V2.0
;*
;* DATE         
;*
;* DESCRIPTION Dekko Macros   
;*
;* FUNCTIONS    
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/



;/*
;** Values for masking the Systrace flags to determine whether a major code is on
;*/

DEKFMASK0 EQU 0080h
DEKFMASK1 EQU 0040h
DEKFMASK2 EQU 0020h
DEKFMASK3 EQU 0010h
DEKFMASK4 EQU 0008h
DEKFMASK5 EQU 0004h
DEKFMASK6 EQU 0002h
DEKFMASK7 EQU 0001h
DEKFMASK8 EQU 8000h
DEKFMASK9 EQU 4000h
DEKFMASKA EQU 2000h
DEKFMASKB EQU 1000h
DEKFMASKC EQU 0800h
DEKFMASKD EQU 0400h
DEKFMASKE EQU 0200h
DEKFMASKF EQU 0100h

;/*
;** Generic dekko hook macro
;** This allows the use of any major/minor code pair, does all systrace
;** checking, and allows for up to 5 words of hook data
;** Inputs:
;**   maj1 - 1st hex digit of major code
;**   maj2 - 2nd hex digit of major code
;**   minor - 2 hex digits of minor code
;**   numwords - number of words of hook data (can be zero) (must be a constant
;**        or equate)
;**   word1 through word5 - word data to be hooked
;*/

EXTERNDEF DOS16LOCALINFO:ABS

DEKKO_HK macro maj1, maj2, minor, numwords, word1, word2, word3, word4, word5
  local   maj_off, mmio_off ,EXIT_SEG_TOO_SHORT       ;local labels
IFDEF DEKKO_BUILD

        push    esi
        push    eax

;/*
;** Establish addressability to the local infoseg.
;*/

        mov     esi,DOS16LOCALINFO
        lsl     ax,SI                           ;LSL on selector
        cmp     ax,04ah
        jl      EXIT_SEG_TOO_SHORT

        shr     esi,3                           ;CRMA ESI
        shl     esi,16                          ;ESI is FLAT PTR LINFOSEG
        
        MOV     AX, WORD PTR [ESI+04Ah]         ;dekko selector
        shr     eax,3   ;CRMA it
        shl     eax,16

;/*
;** EAX is flat ptr to dekko selector
;** if major code is on
;*/
        test    word ptr [ESI+38+(0&maj1&h*2)],DEKFMASK&maj2
        jz      maj_off
        test    word ptr [esi+38],DEKFMASK1     ;if mmio hooks are on
        jz      mmio_off

        MOV     ESI,EAX

;/*
;** ESI is flat ptr to dekko selector
;*/

        mov     word ptr [ESI+04h],0maj1&maj2&minor&h
        mov     word ptr [ESI+0Ch],numwords*2
IFDIF <numwords>,<0>
        mov     ax,word1
        mov     word ptr [ESI+0Ch],ax
IFDIF <numwords>,<1>
        mov     ax,word2
        mov     word ptr [ESI+0Ch],ax
IFDIF <numwords>,<2>
        mov     ax,word3
        mov     word ptr [ESI+0Ch],ax
IFDIF <numwords>,<3>
        mov     ax,word4
        mov     word ptr [ESI+0Ch],ax
IFDIF <numwords>,<4>
        mov     ax,word5
        mov     word ptr [ESI+0Ch],ax
ELSE
        ERROR: DEKKO_HK numwords must be a value from 0 to 5
ENDIF
ENDIF
ENDIF
ENDIF
ENDIF
EXIT_SEG_TOO_SHORT:
mmio_off:                               ;endif
maj_off:                                ;endif
        POP     EAX
        POP     ESI
ENDIF
endm

