;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = DEKKO32.ASM
;*
;* DESCRIPTIVE NAME =  32 bit dekko hook support  
;*
;*
;* VERSION      V2.0
;*
;* DATE         8/14/91
;*
;* DESCRIPTION  To build a version that will run without a dekko card, include 
;*              the parameter "-DDEBUGDEKKO" when assembling this file. All
;*              data will be written to the local variable DEBUG_BUFFER instead
;*              of the dekko card. Also the trace test on the global bit will
;*              NOT be performed since this bit cannot be turned on by the
;*              TRACE command in non-MMIO kernels.                                              
;*
;* FUNCTIONS    _Dekko32Trace
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   08/14/91                     MikeWalsh    Created
;*   11/15/91                     MikeWalsh    Removed thunk, Calls DOSQUERYRASINFO
;*   01/07/92                     Mike Walsh   Fixes for changed DOSQUERYRASINFO
;*                                             function
;*
;*****************************************************************************/
        TITLE   $dekko32.asm

        .386
        .MODEL FLAT,SYSCALL
        ASSUME  SS:FLAT, DS:FLAT, CS:FLAT, ES:FLAT

DEKKO_ADDR  struc
            resv0       DD      ?               ; +0 Reserved double word
            maj_code    DW      ?               ; +4 Major code buffer
            resv1       DW      ?               ; +6 Reserved
            data_buff_4 DD      ?               ; +8 Data buffer - 4 byte area
            data_buff   DW      ?               ; +C Data buffer - 2 byte area
DEKKO_ADDR  ends


PUBLIC  _Dekko32Trace
EXTRN   DosQueryRASInfo:NEAR

;---------------------------------------------------------------------------;

;---------------------------------------------------------------------------;

;.DATA
_INSTANCEDATA SEGMENT PARA PUBLIC USE32 'INSTDATA'

MEC_Table               DD      0
Dekko_Buffer            DD      0
bDekko_Init             DW      0
        ALIGN 4

ifdef DEBUGDEKKO
DEBUG_BUFFER            DW      14 DUP (0)      ;; DEBUG DEBUG DEBUG
endif

_INSTANCEDATA ENDS
.CODE
;/***************************************************************************
;*
;* FUNCTION NAME = _Dekko32Trace 
;*
;* DESCRIPTION   = Provides 32-bit service for dekko hooks. Counterpart to the 
;*                 _DekkoTrace routine found in DEKTRACE.C file. Initialization
;*                 is provided by the undocumentated DOSQUERYRASINFO API
;* INPUT         = USHORT  usMajor
;*                 USHORT  usMinor
;*                 USHORT  usLength
;*                 FPCHAR  fpData
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;**************************************************************************/

ALIGN 4
_Dekko32Trace   PROC SYSCALL FORCEFRAME
        pushad                                  ; save all general regs

        cmp     bDekko_Init, WORD PTR 0         ; check if initialization done
        jne     INIT_DONE

   ifdef DEBUGDEKKO
        int     3                               ;; DEBUG DEBUG DEBUG
        lea     eax,DEBUG_BUFFER                ;; DEBUG DEBUG DEBUG
        mov     Dekko_Buffer,eax                ;; DEBUG DEBUG DEBUG
   else
        lea     eax, Dekko_Buffer               ; load addr of dekko area ptr
        push    eax                             ; 
        push    0                               ; 0 indicates MMIO addr request
        call    DosQueryRASInfo                 ; make the request
        add     esp,8                           ; remove params off stack
        cmp     eax,0                           ; check return code for error
        jne     EXIT_TRACE                      ; 
   endif
        mov     eax, Dekko_Buffer               ; Check that there was a valid
        cmp     eax, 0                          ;  dekko card address
        je      EXIT_TRACE                      ;  if not, then abort the init
                                                ; 
        lea     eax, MEC_Table                  ; load addr of MEC Table ptr
        push    eax                             ; 
        push    1                               ; 1 indicates MEC Table request
        call    DosQueryRASInfo                 ; make the request
        add     esp,8                           ; remove params off stack
        cmp     eax,0                           ; check return code for error
        jne     EXIT_TRACE                      ; 

        mov     bDekko_Init, WORD PTR 1         ; set initialization done

INIT_DONE:
        mov     eax, MEC_Table
        cmp     eax, 0                          ; check pointer to MEC table
        je      EXIT_TRACE

   ifndef DEBUGDEKKO
        test    BYTE PTR [eax], 64              ; test if tracing is on
        je      EXIT_TRACE
   endif

        mov     cl, BYTE PTR [ebp+9]            ; calculate address of
        shr     cl, 3                           ;   major code's byte in
        movzx   ecx, cl                         ;   the MEC table
        add     eax, ecx                        ; 
        movsx   eax, BYTE PTR [eax]             ; 
        mov     edx, 128                        ; 
        mov     cl, BYTE PTR [ebp+9]            ; 
        and     cl, 7                           ; 
        sar     edx, cl                         ; 
        and     eax, edx                        ; test if tracing major code
        je      EXIT_TRACE

        mov     edx, Dekko_Buffer               ; Load dekko buffer address
        ASSUME  EDX:PTR DEKKO_ADDR
        mov     cx, WORD PTR [ebp+8]            ; load major code
        mov     [edx].maj_code, cx              ; write major code to dekko buf

        mov     cx, WORD PTR [ebp+16]           ; load the data length
        add     cx, WORD PTR 3                  ; include the minor code length
        and     cx, WORD PTR 65534              ; make it even
        mov     [edx].data_buff, cx             ; write the adjusted length

        mov     cl, BYTE PTR [ebp+13]           ; load the minor code bytes in
        mov     ch, BYTE PTR [ebp+12]           ;   the order that dekko expects
        mov     [edx].data_buff, cx             ; write the minor code

                                                ; prepare to dump any data
        mov     ax, WORD PTR [ebp+16]           ; EAX = data length
        mov     ebx, DWORD PTR [ebp+20]         ; EBX = data address
        jmp     SHORT TEST_COUNT
ALIGN 4

WRITE_DWORD:
        sub     ax, 4                           ; subtract 4 from the count
        mov     ecx, DWORD PTR [ebx]
        mov     [edx].data_buff_4, ecx          ; write out the data
        add     ebx,4                           ; point to the next data item
        jmp     SHORT TEST_COUNT
ALIGN 4

WRITE_WORD:
        sub     ax, 2                           ; subtract 2 from the count
        mov     cx, WORD PTR [ebx]
        mov     [edx].data_buff, cx             ; write out the data
        add     ebx,2                           ; point to the next data item

TEST_COUNT:
        cmp     ax, 1                           ; 
        jg      SHORT WRITE_WORD                ; jmp if 2 or more bytes left
        jl      SHORT EXIT_TRACE                ; jmp if no bytes left

        xor     cx,cx                           ; one byte left, clear CX
        mov     ch, BYTE PTR [ebx]              ; load the odd byte
        mov     [edx].data_buff, cx             ; and write it out, and exit
        ASSUME  EDX:NOTHING
EXIT_TRACE:
        popad                                   ; restore general regs

        ret
        NOP
_Dekko32Trace   ENDP

END
