;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = DBCSINIT.ASM
;*
;*
;* VERSION      V2.0
;*
;* DATE         11/10/90
;*
;* DESCRIPTION  This is part of the DBCS-NLS support dependent sources.
;*              This module offers the mechanism to the display driver,
;*              to support both SBCS/DBCS OS/2 system environment.
;*
;* FUNCTIONS    DbcsGetRuntimeOptions
;*              DbcsModifySystemFonts
;*              DbcsValidateSystemFonts
;*
;* NOTES        DbcsGetRuntimeOptions checks the runtime environment and setup
;*              runtime options.
;*              When DBCS options is selected, the display driver works with
;*              DBCS support functions using PMNLSFM.DLL
;*              (DBCS device font manager).
;*              Also this module provides the extended option to change the
;*              DBCS system fonts. The exported font description is used to
;*              select font at initialization time, and these descriptions can
;*              be changed at the installation/initialzation time.
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              usSysFontHeight
;*              usSysFontWidth
;*              szSysFontName
;*              szVioFontName
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   11/10/90                     Written by Soh Ohta [jl09057 @ ymtvm3]
;*   08/26/93  @Y1                Yuji Watanabe fixed a DBCS font problem.
;*                                PJS05698
;*
;*****************************************************************************/

        .386

        .MODEL FLAT,SYSCALL

        ASSUME  CS:FLAT,SS:FLAT,DS:FLAT,ES:FLAT

        .xlist

INCL_DOSNLS             equ     1
INCL_FONTFILEFORMAT     equ     1
INCL_GRE_FONTS          equ     1
INCL_DEV                equ     1
INCL_VIO                equ     1
INCL_DDIMISC            equ     1
INCL_DOSMISC            equ     1

INCL_DDIFONTSTRUCS EQU 1

        OPTION  OLDSTRUCTS

        include pmgre.inc

DINCL_VIO       equ     1
DINCL_ERROR     equ     1
DINCL_ENABLE    equ     1
DINCL_BITMAP    equ     1

        include driver.inc
        include fontseg.inc

KC_DBCSRSRVD2   equ     0               ; unresolved but not used.

        include fontmap.inc
        include extern.inc
        include protos.inc

        .list

        .DATA

FD_VECTOR       equ     0000000000000001B   ;!!! define this in pmddi*
DEVFONT_SIM_REQ equ     CAPS_DEV_FONT_SIM_BOLD+\
                        CAPS_DEV_FONT_SIM_ITALIC+\
                        CAPS_DEV_FONT_SIM_UNDERSCORE+\
                        CAPS_DEV_FONT_SIM_STRIKEOUT

CP_UGL_FONT     equ     850             ; UGL font codepage

        public  DeviceFontWidth         ; Device specific VIO font width
        public  usSysFontHeight         ; DBCS system font height
        public  usSysFontWidth          ; DBCS system font width
        public  szSysFontName           ; DBCS system font facename
        public  szVioFontName           ; DBCS vio font familyname

;       globalW swFlags,0               ; sw flags, telling us sw config
        public  swFlags
swFlags         dw      0

;-----------------------------------------------------------------------;
; System default fonts
; following definitions can be overwritten.
;-----------------------------------------------------------------------;

DeviceFontWidth dd      0
usSysFontHeight dd      DBCS_SYSTEM_FONT_HEIGHT
usSysFontWidth  dd      DBCS_SYSTEM_FONT_WIDTH
szSysFontName   db      DBCS_SYSTEM_FONT_FACENAME
        .errnz  $-szSysFontName-FACESIZE
szVioFontName   db      DBCS_VIO_FONT_FAMILYNAME
        .errnz  $-szVioFontName-FACESIZE

        .CODE

page

;---------------------------Public-Routine------------------------------;
; DbcsGetRuntimeOptions
;
;   Get DBCS environment runtime option flags (swFlags, SW_*).
;
;   This entry is called only from one_time_init() at initialization,
;   when DBCS conditional compile flag is set.
;
;   The following runtime option flags are raised conditionally:
;
;       SW_DISPLAY_DBCS - driver can display DBCS font set
;       - DBCS font manager exists, and
;       - NLS codepage support is available
;
;       SW_SYSTEM_DBCS - system default codepage is MBCS/DBCS.
;       ... DBCS font set will be used for system font.
;       - SW_DISPLAY_DBCS flag is on, and
;       - system default codepage is MBCS/DBCS
;
; Entry:
;       EAX = system default codepage
;       EDX = system default country code
; Returns:
;       EAX = 0
;       ddcInit.ddc_ca.ca_idCodePage = system default codepage id
;       ddcInit.ddc_ca.ca_fsNls      = system default codepage type (NLSCA_*)
;       cResource                    = number of SBCS resources to be loaded
;
; Error Returns:
;       EAX <> 0
; Registers Destroyed:
;       EAX,EBX,ECX,EDX,FLAGS
; Registers Preserved:
;       ESI,EDI,EBP
; Calls:
;       OEM_DbcsGetRuntimeOptions
; History:
;   10-Nov-1990 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;   02-Aug-1991 -by- Soh Ohta [jl09057 @ ymtvm3]
; Add OEM support.
;   14-Apr-1992 -by- Soh Ohta [jl09057 @ ymtvm3]
; Support DBCS fonts on SBCS environment.
;-----------------------------------------------------------------------;

ifdef GRE32
DBCSEVLEN       equ     10
PURESBCSCODEPAGE equ    00000h          ; pure SBCS codepage
PUREDBCSCODEPAGE equ    0ff00h          ; pure DBCS codepage
endif

DbcsGetRuntimeOptions PROC SYSCALL uses ESI EDI EBX
        LOCAL   cp_system :DWORD,
                cc_system :DWORD
ifdef GRE32
        LOCAL   idCodePage            :DWORD,
                ctrycode[COUNTRYCODE] :BYTE,
                DBCSEv[DBCSEVLEN]     :BYTE
endif

        mov     cp_system,eax           ; system default codepage
        mov     cc_system,edx           ; system default country code
        mov     swFlags,0

; Try to load the DBCS font manager.

        INVOKE  DbcsLoadFontManager
        or      eax,eax
        jnz     force_system_sbcs       ; DBCS font manager not exists.

; Initialize code-point mapping tables (requires SW_DISPLAY_DBCS flag)

        or      swFlags,SW_DISPLAY_DBCS
        INVOKE  DbcsInitCodePageVectors ; create DBCS-NLS support vectors.
        or      eax,eax
        jnz     force_system_sbcs       ; cannot handle DBCS codepage correctly

        mov     eax,cp_system           ; system default codepage
ifndef GRE32
        INVOKE  DbcsQueryCodePageVectors
        or      eax,eax                 ; codepage infotmation flags --> CX
        jz      force_system_sbcs       ; cannot handle DBCS codepage correctly
else
; We cannot use GreQueryCodpageVector at this timing when working with
; 32 bit engine.

        mov     word ptr DBCSEv[0],0       ; play it safe
        mov     ctrycode.ctryc_country,0    ; default country code
        mov     ctrycode.ctryc_codepage,eax

        INVOKE  DosQueryDBCSEnv, DBCSEVLEN, ADDR ctrycode, ADDR DBCSEv

        mov     ecx,NLSCA_SBCS          ; assumes SBCS codepage
        or      ax,ax                   ; no ev vector provided by base
        jnz     @F                      ; error. handle it as SBCS codepage
        cmp     word ptr DBCSEv[0],PURESBCSCODEPAGE
        je      @F                      ; SBCS codepage
        mov     ecx,NLSCA_DBCS          ; assumes DBCS codepage
        cmp     word ptr DBCSEv[0],PUREDBCSCODEPAGE
        je      @F                      ; DBCS codepage
        mov     ecx,NLSCA_MBCS          ; MBCS codepage
@@:
endif

; Check our default codepage is MBCS/DBCS or not.

        mov     eax,cp_system           ; system default codepage
        mov     ddcInit.ddc_ca.ca_idCodePage,eax; codepage id
        mov     ddcInit.ddc_ca.ca_lCodePage,eax ; logical codepage id for default font
ifndef GRE32
        mov     ddcInit.ddc_ca.ca_fsNls,ecx     ; codepage type

        and     ddcInit.ddc_ca.ca_fs,not CA_MUST_MAP
        test    ecx,NLSCA_MAP_SBCS      ; SBCS mapping required ?
        jz      @f                      ; no..
        or      ddcInit.ddc_ca.ca_fs,CA_MUST_MAP
else
; Are you putting ca_fsNls and ca_fs when createing ddc (ENABLE.ASM) ?
endif

@@:     test    ecx,NLSCA_SBCS
        jnz     check_dbcs_done         ; SBCS system codepage

; When system codepage is DBCS, load DBCS resources instead.
        mov     eax,FM_PUBLIC
        INVOKE  DbcsQueryFontCount      ; touch the device fonts
        or      edx,edx                 ; number of MBCS/DBCS fonts available
        jz      check_dbcs_done         ; no DBCS system fonts
        or      swFlags,SW_SYSTEM_DBCS  ; DBCS resources will be used...
        mov     cResource,2             ; restrict SBCS resources (1Font/1Marker)
        jmp     check_dbcs_done

; Force system to SBCS anyway.

force_system_sbcs:
        and     swFlags,not (SW_SYSTEM_DBCS+SW_DISPLAY_DBCS)

check_dbcs_done:

        INVOKE  OEM_DbcsGetRuntimeOptions   ; OEM option over-ride

        ret
DbcsGetRuntimeOptions ENDP

page

;---------------------------Public-Routine------------------------------;
; DbcsModifySystemFonts
;
;   Modify system (Gpi default, Vio) font resource definitions,
;   using the list of available fonts provided by the font manager.
;
;   This entry is called only from one_time_init() at initialization,
;   when DBCS conditional compile flag is set.
;   If SW_SYSTEM_DBCS flag is cleared, we do nothing.
;
; Entry:
;       none
; Returns:
;       EDX = system font fontseg address.
;       ddcInit.ddc_ca.ca_pFont = our default UGL font
;       ddcInit.ddc_ca.ca_fsFont= default font characteristics (NLSCA_FONT_*)
;       ddcInit.ddc_ca.ca_cCache= fontseg cache size (if NLSCA_FONT_CACHED)
;       cDevVioCells            = number of DBCS Vio fonts available
;       pDefVioFont             = address of default DBCS Vio font (largest one)
;       adDevCapsData:
;         CAPS_SMALL_CHAR_HEIGHT    = smallest Vio font height
;         CAPS_SMALL_CHAR_WIDTH     = smallest Vio font width
;         CAPS_CHAR_HEIGHT          = largest  Vio font height
;         CAPS_CHAR_WIDTH           = largest  Vio font width
;         CAPS_GRAPHICS_CHAR_HEIGHT = default  Gpi font charbox
;         CAPS_GRAPHICS_CHAR_WIDTH  = default  Gpi font charbox
;         CAPS_ADDITIONAL_GRAPHICS  = clear CAPS_FONT_IMAGE_MANAGE bit
;         CAPS_DEVICE_FONT_SIM      = DEVFONT_SIM_REQ (defined above)
;         CAPS_VIO_LOADABLE_FONTS   = ?
;         CAPS_DEVICE_FONTS         = ?
;         CAPS_VERTICAL_FONT_RES    = ? (according to .INI options)
;         CAPS_HORIZONTAL_FONT_RES  = ? (according to .INI options)
;
;       We will use device fonts and manage them by ourself. However,
;       we will not process simulations (such as bold) so request them
;       to Engine.
;
; Registers Destroyed:
;       EAX,EBX,ECX,EDX,FLAGS
; Registers Preserved:
;       ESI,EDI,EBP
; Calls:
; History:
;   10-Nov-1990 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;   02-Aug-1991 -by- Soh Ohta [jl09057 @ ymtvm3]
; Change font selection logic for OEM support.
;   14-Apr-1992 -by- Soh Ohta [jl09057 @ ymtvm3]
; Support DBCS fonts on SBCS environment.
;-----------------------------------------------------------------------;
;-----------------------------------------------------------------------;
; Font Resource Definition
;
;   Display driver font resources are defined like this (DATA.ASM):
;
;       cResource    =  number of FONT_RES structures
;       defFontChar     FONT_RES (system font) -------------> ddcInit
;       defFontMarker   FONT_RES (marker font) -------------> fontseg field
;                       FONT_RES (other font1)------+
;                       FONT_RES (other font2)------|---+
;                       FONT_RES (other font3)------|---|---+
;                           :                       |   |   |
;                                                   |   |   | CellSize
;       adDevVioCells   CellSize (vio font 1) <-----+   |   | fontseg field
;                       CellSize (vio font 2) <---------+   |
;       pDefVioFont     CellSize (vio font 3) <-------------+
;                           :
;       cDevVioCells =  ($-adDevVioCells)/(SIZE CellFont)
;
;   Structures:
;
;       FONT_RES      = combines resource type (font, marker, etc),
;                       resource id and the location of fontseg field.
;       CellSize      = combines cell width/height and the location
;                       of fontseg field.
;
;   Label meanings:
;
;       defFontChar   = address of the system font information
;       defFontMarker = address of the marker font information
;       pDefVioFont   = address of the default Vio cell size information
;                       The cell size values are returned in
;                       DEVESC_QUERYVIOCELLSIZES.
;
;   Note that the display driver assumes the following things:
;
;   1. The system font is the first item in the FONT_RES structure array.
;      So the system font information is located just after the cResource.
;   2. The adDevVioCells table is sorted by height within width.
;
;
; Font Resource Runtime Modification using DBCS Font Manager
;
;   The array of FONT_RES is the font resources to be loaded using
;   DosGetResource. The font resources, which are not binded to display
;   driver, are not nessesary to register into this structure array.
;
;   While, adDevVioCells table contains the list of font resources which
;   can be used as Vio font. This table MUST contains any Vio fonts,
;   which are not to binded to display driver, but loaded by font manager.
;
;   Display driver font resources are modified like:
;
;       cResource    =  2 (number of FONT_RES structures)
;       defFontChar     FONT_RES (system font) -------------> ddcInit
;       defFontMarker   FONT_RES (marker font) -------------> fontseg field
;
;       adDevVioCells   CellSize (vio font 1) <---- font manager font
;                       CellSize (vio font 2) <---- font manager font
;                       CellSize (vio font 3) <---- font manager font
;                           :
;       cDevVioCells =  number of Vio fonts provided by font manager
;       pDefVioFont  =  address of CellSize structure which defines the
;                       default Vio font
;
;       To change font resource definition at runtime, 'pDefVioFont' and
;       'cDevVioCells' are changed to variable. See DATA.ASM.
;-----------------------------------------------------------------------;

DbcsModifySystemFonts PROC SYSCALL uses ESI EDI EBX
        LOCAL   cDevFonts     :DWORD    ; number of device fonts available
        LOCAL   lpDevFonts    :DWORD    ; pointer to the array of device fonts
        LOCAL   maxVioCells   :DWORD    ; CellFont buffer size
        LOCAL   maxCellHeight :DWORD    ; max cell height
        LOCAL   maxCellWidth  :DWORD    ; max cell width
        LOCAL   fat           :FATTRS
        LOCAL   FontsegSave   :DWORD
        LOCAL   pszResult     :DWORD

        mov     edi,defFontChar.fr_pp
        mov     eax,[edi]               ; assumes SBCS system font

        mov     lpSbcsFontSeg,eax       ; save SBCS system font segment

        test    swFlags,SW_DISPLAY_DBCS
        jz      use_sbcs_sys_font       ; work as SBCS driver

; Get the list of device fonts, including font manager font and resource font.

        mov     eax,FM_PUBLIC
        INVOKE  DbcsGetFontList         ; list allocated --> EAX
        jc      use_sbcs_sys_font       ; unexpected error.

        mov     cDevFonts,ecx
        mov     lpDevFonts,eax

; Update Caps definition - Driver's generic.

        mov     ecx,cDevFonts
        mov     adDevCapsData[SIZE_DWORD*CAPS_DEVICE_FONTS],ecx
        and     adDevCapsData[SIZE_DWORD*CAPS_ADDITIONAL_GRAPHICS ],not CAPS_FONT_IMAGE_MANAGE
        mov     adDevCapsData[SIZE_DWORD*CAPS_DEVICE_FONT_SIM     ],DEVFONT_SIM_REQ

        test    swFlags,SW_SYSTEM_DBCS
        jz      use_sbcs_sys_font       ; return SBCS system font

; If 1.x compatible font resolution is specified, the driver must use
; the VGA compatible resolution definitions anyway.
; See also: DbcsFixFontMetrics() in dbcsfont.asm for compatibility.

        cmp     swDrvFontRes,DRVCOMPAT_1; OS/2 J1.x compatibility?
        jne     caps_devicefonts_done   ; no..
        mov     adDevCapsData[SIZE_DWORD*CAPS_VERTICAL_FONT_RES  ],ALTCAPS_VERTICAL_FONT_RES
        mov     adDevCapsData[SIZE_DWORD*CAPS_HORIZONTAL_FONT_RES],ALTCAPS_HORIZONTAL_FONT_RES

        public  caps_devicefonts_done
caps_devicefonts_done::

;-----------------------------------------------------------------------;
; Prepare Vio Fonts
;-----------------------------------------------------------------------;

        mov     eax,DeviceFontWidth
        or      eax,eax
        jz      @F
        mov     maxCellWidth,eax
        mov     maxCellHeight,24
        jmp     lets_modify_sys_fonts   ;+++
@@:

; Compute range of Vio cellsize valid for current system configuration.

        lea     esi,adDevVioCells
        mov     eax,[esi].CellFont.cf_height
        mov     maxCellHeight,eax
        mov     eax,[esi].CellFont.cf_width
        mov     maxCellWidth,eax
        add     esi,sizeof CellFont
        mov     ecx,cDevVioCells
        dec     ecx
scan_maxsize_loop:
        mov     eax,[esi].CellFont.cf_height
        cmp     eax,maxCellHeight
        jbe     @F
        mov     maxCellHeight,eax
@@:     mov     eax,[esi].CellFont.cf_width
        cmp     eax,maxCellWidth
        jbe     @F
        mov     maxCellWidth,eax
@@:     add     esi,sizeof CellFont
        loop    scan_maxsize_loop

        mov     eax,adDevCapsData[SIZE_DWORD*CAPS_HEIGHT]
        xor     edx,edx
        div     adDevCapsData[SIZE_DWORD*CAPS_HEIGHT_IN_CHARS]
        cmp     eax,maxCellHeight
        jae     @f
        mov     maxCellHeight,eax       ; computed max cell height
@@:
        mov     eax,adDevCapsData[SIZE_DWORD*CAPS_WIDTH]
        div     adDevCapsData[SIZE_DWORD*CAPS_WIDTH_IN_CHARS]
        cmp     eax,maxCellWidth
        jbe     @f
        mov     eax,maxCellWidth
    @@: cmp     eax,MIN_VIOCELL_WIDTH   ; make sure computed_max >= min
        jae     @f
        mov     eax,MIN_VIOCELL_WIDTH
    @@: mov     maxCellWidth,eax        ; computed max cell width

lets_modify_sys_fonts:                  ;+++

; Copy Vio Fonts to adDevVioCells, and fix pDefVioFont and cDevVioCells.
; Be sure that the adDevVioCells table is sorted by height within width.

        movzx   eax,word ptr cDevVioCells
        mov     maxVioCells,eax         ; keep buffer size
        mov     cDevVioCells,0          ; reset number of Vio fonts

        mov     ecx,cDevFonts           ; number of FMFONTINFO32 structure
        mov     edi,lpDevFonts          ; list   of FMFONTINFO32 structure
        lea     esi,adDevVioCells       ; list of CellFont structure
        cld

; Copy valid Vio fonts to adDevVioCells table.
; Our Vio font is:
;   familyname = szVioFontName
;   codepage   = UGL font
;   definition = raster, fixed pitch font

        public  check_next_vio_font
check_next_vio_font::
        push    edi
        push    esi
        push    ecx
        mov     edi,[edi].FMFONTINFO32.fmfont32_pFont
        mov     FontsegSave,edi

        xor     eax,eax                 ; assumes invalid vio font
        movzx   ebx,[edi].FOCAFONT.ff_fdDefinitions.fdh_xCellWidth
                                        ; EBX = cell width
        movzx   edx,[edi].FOCAFONT.ff_fdDefinitions.fdh_yCellHeight
                                        ; EDX = cell height

        cmp     ebx,MIN_VIOCELL_WIDTH
        jb      not_vio_font            ; invalid cell width
        cmp     ebx,maxCellWidth
        ja      not_vio_font            ; invalid cell width
        and     edx,edx
        jz      not_vio_font            ; invalid cell height
        cmp     ebx,maxCellHeight
        ja      not_vio_font            ; invalid cell height
        cmp     [edi].FOCAFONT.ff_fmMetrics.foca_usCodePage,CP_UGL_FONT
        jne     not_vio_font
        test    [edi].FOCAFONT.ff_fmMetrics.foca_fsDefn,FD_VECTOR
        jnz     not_vio_font
        test    [edi].FOCAFONT.ff_fmMetrics.foca_fsTypeFlags,FM_FIXED_PITCH
        jz      not_vio_font

        lea     edi,[edi].FOCAFONT.ff_fmMetrics.foca_szFamilyname
        lea     esi,szVioFontName
        cmp     byte ptr [esi],0         ; null familyname ?
        je      its_vio_font            ; always match
        mov     ecx,FACESIZE
        repz    cmpsb
        jne     not_vio_font            ; familynames are not match

its_vio_font:
        mov     eax,FontsegSave         ; EAX = fontseg
not_vio_font:
        pop     ecx
        pop     esi
        pop     edi

        mov     [edi].FMFONTINFO32.fmfont32_hfm,eax  ; mark this font will be used..
        or      eax,eax
        jz      invalid_vio_font
        mov     [esi].CellFont.cf_ptr,eax      ; fontseg
        mov     [esi].CellFont.cf_width,ebx    ; cell width
        mov     [esi].CellFont.cf_height,edx   ; cell height
        inc     cDevVioCells                   ; number of Vio fonts + 1

        movzx   eax,word ptr cDevVioCells
        cmp     maxVioCells,eax
        jbe     sort_vio_cells          ; buffer is full

        add     esi,size CellFont
invalid_vio_font:
        add     edi,size FMFONTINFO32
        loop    check_next_vio_font2
        jmp     sort_vio_cells
check_next_vio_font2:
        jmp     check_next_vio_font

; Sort CellFont list as required using bubble sort method.
; The list is sorted by cell width, and sorted by cell height within the
; CellFonts which are same cell height (width is more significant).
; We assumes both cell width and height are less than 256 pels.

        public  sort_vio_cells
sort_vio_cells::
        lea     esi,adDevVioCells       ; list of CellFont structure
        movzx   ecx,word ptr cDevVioCells        ; number of Vio fonts
        lea     edi,[esi+(size CellFont)]
        dec     ecx
        jz      sort_vio_cells_done     ; only 1 font available

sort_outer_loop:
        push    ecx
        mov     al,byte ptr [esi].CellFont.cf_height
        mov     ah,byte ptr [esi].CellFont.cf_width

sort_inner_loop:
        mov     bl,byte ptr [edi].CellFont.cf_height
        mov     bh,byte ptr [edi].CellFont.cf_width
        cmp     ax,bx
        jbe     its_valid_order

        mov     eax,[edi].CellFont.cf_ptr
        mov     ebx,[edi].CellFont.cf_width
        mov     edx,[edi].CellFont.cf_height
        xchg    eax,[esi].CellFont.cf_ptr
        xchg    ebx,[esi].CellFont.cf_width
        xchg    edx,[esi].CellFont.cf_height
        mov     [edi].CellFont.cf_ptr,eax
        mov     [edi].CellFont.cf_width,ebx
        mov     [edi].CellFont.cf_height,edx
        mov     al,byte ptr [esi].CellFont.cf_height
        mov     ah,byte ptr [esi].CellFont.cf_width

its_valid_order:
        add     edi,size CellFont
        loop    sort_inner_loop

        add     esi,size CellFont
        lea     edi,[esi+(size CellFont)]
        pop     ecx
        loop    sort_outer_loop

sort_vio_cells_done:

; Now we have sorted list of Vio fonts.
; Fix device caps data for modified Vio cell size.

ifndef TMP
        lea     esi,adDevVioCells       ; list of CellFont structure
        movzx   ecx,word ptr cDevVioCells        ; number of vio cells
        xor     ebx,ebx
find_sysfont_size_loop:
        mov     eax,[esi+ebx].CellFont.cf_height
        cmp     eax,usSysFontHeight
        jne     @F
        mov     eax,[esi+ebx].CellFont.cf_width
        cmp     eax,usSysFontWidth
        je      find_just_sys_font_size
@@:
        add     ebx,sizeof CellFont
        loop    find_sysfont_size_loop
endif ;not TMP

        lea     esi,adDevVioCells       ; list of CellFont structure
        movzx   ebx,word ptr cDevVioCells        ; number of vio cells - 1
        dec     ebx
        imul    ebx,ebx,(size CellFont)

find_just_sys_font_size:                ; +++

; Update Caps definition - Vio cell sizes.

        mov     eax,[esi].CellFont.cf_height
        mov     ecx,[esi].CellFont.cf_width
        mov     adDevCapsData[SIZE_DWORD*CAPS_SMALL_CHAR_HEIGHT],eax
        mov     adDevCapsData[SIZE_DWORD*CAPS_SMALL_CHAR_WIDTH ],ecx
        mov     eax,[esi+ebx].CellFont.cf_height
        mov     ecx,[esi+ebx].CellFont.cf_width
        mov     adDevCapsData[SIZE_DWORD*CAPS_CHAR_HEIGHT],eax
        mov     adDevCapsData[SIZE_DWORD*CAPS_CHAR_WIDTH ],ecx

;       lea     eax,[esi+ebx]
;       mov     dword ptr pDefVioFont,eax   ; default Vio font = large font.

;-----------------------------------------------------------------------;
; Prepare Driver's Default Font
;-----------------------------------------------------------------------;

; Search Gpi system font and set it as system default font.

        mov     ecx,cDevFonts           ; number of FMFONTINFO32 structure
        mov     edi,lpDevFonts          ; list   of FMFONTINFO32 structure
        cld

; Search specified DBCS font from the list of font manager fonts.
; Our system font is:
;   cellheight = usSysFontHeight
;   cellwidth  = usSysFontWidth
;   facename   = szSysFontName
;   codepage   = UGL font
;   definition = raster font
;   other      = xRes:yRes (font) == xRes:yRes (driver)

check_next_sys_font:
        push    edi
        push    ecx
        mov     edi,[edi].FMFONTINFO32.fmfont32_pFont
        mov     FontsegSave,edi

        xor     ecx,ecx                 ; assumes invalid sys font
        movzx   eax,[edi].FOCAFONT.ff_fmMetrics.foca_xDeviceRes
        mul     adDevCapsData[SIZE_DWORD*CAPS_VERTICAL_FONT_RES  ]
        div     adDevCapsData[SIZE_DWORD*CAPS_HORIZONTAL_FONT_RES]
        xchg    ecx,eax                 ; ECX = yRes (font)
        cmp     cx,[edi].FOCAFONT.ff_fmMetrics.foca_yDeviceRes
        jne     not_sys_font
        or      edx,edx
        jnz     not_sys_font

        movzx   ebx,[edi].FOCAFONT.ff_fmMetrics.foca_xAveCharWidth
                                        ; BX = font width
        movzx   edx,[edi].FOCAFONT.ff_fmMetrics.foca_yMaxBaselineExt
                                        ; DX = font height

        cmp     edx,usSysFontHeight     ; same height ?
        jne     not_sys_font
        cmp     ebx,usSysFontWidth      ; same width ?
        jne     not_sys_font
        cmp     [edi].FOCAFONT.ff_fmMetrics.foca_usCodePage,CP_UGL_FONT
        jne     not_sys_font
        test    [edi].FOCAFONT.ff_fmMetrics.foca_fsDefn,FD_VECTOR
        jnz     not_sys_font

        lea     edi,[edi].FOCAFONT.ff_fmMetrics.foca_szFacename
        lea     esi,szSysFontName
        cmp     byte ptr [esi],0        ; null facename ?
        je      its_sys_font            ; always match
        mov     ecx,FACESIZE
        repz    cmpsb
        jne     not_sys_font            ; facenames are not match

its_sys_font:
        mov     eax,FontsegSave         ; EAX = fontseg
not_sys_font:
        pop     ecx
        pop     edi

        or      [edi].FMFONTINFO32.fmfont32_hfm,eax    ; mark this font will be used...
        or      eax,eax
        jnz     valid_sys_font
        add     edi,size FMFONTINFO32
        loop    check_next_sys_font2
        jmp     @f

check_next_sys_font2:
        jmp     check_next_sys_font
@@:

; No matching system font found (should never be happened!).
; Will use 1st font manager font.

        mov     edi,lpDevFonts              ; list of FMFONTINFO32 structure
        mov     eax,[edi].FMFONTINFO32.fmfont32_pFont      ; EAX = 1st font fontseg
        or      [edi].FMFONTINFO32.fmfont32_hfm,eax        ; mark this font will be used...

; SBCS resource loadings may override our device font defintion.
; Update ddcInit with DBCS system font.

valid_sys_font:
        mov     lpDbcsFontSeg,eax
        mov     ddcInit.ddc_ca.ca_pFont,eax

; Update Caps definition - Driver's default font.

        mov     edi,eax
        movzx   eax,[edi].FOCAFONT.ff_fmMetrics.foca_xEmInc
        movzx   ecx,[edi].FOCAFONT.ff_fmMetrics.foca_yEmHeight
        mov     adDevCapsData[SIZE_DWORD*CAPS_GRAPHICS_CHAR_WIDTH ],eax
        mov     adDevCapsData[SIZE_DWORD*CAPS_GRAPHICS_CHAR_HEIGHT],ecx

; Set font profile into default ddc.

        mov     eax,edi
        INVOKE  DbcsQueryFontProfile
        mov     ddcInit.ddc_ca.ca_fsFont,eax
        mov     ddcInit.ddc_ca.ca_cCache,edx

; Open fonts which the system will use.

        lea     ebx,fat                 ; EBX --> FATTRS strucure
        xor     ax,ax                   ; initialize it
        mov     word ptr [ebx].FATTRS.fat_usRecordLength,size FATTRS
        mov     [ebx].FATTRS.fat_fsSelection,ax
        mov     [ebx].FATTRS.fat_fsType,ax
        mov     [ebx].FATTRS.fat_fsFontUse,ax

        mov     ecx,cDevFonts           ; number of FMFONTINFO32 structure
        mov     edi,lpDevFonts          ; list   of FMFONTINFO32 structure
        cld

        public open_next_font
open_next_font::
        cmp     [edi].FMFONTINFO32.fmfont32_hfm,0 ; is this font used by system?
        je      goto_next_font          ; no...
        mov     eax,[edi].FMFONTINFO32.fmfont32_lMatch
        mov     [ebx].FATTRS.fat_lMatch,eax
        mov     eax,ebx
        INVOKE  DbcsRealizeFont         ; open font using match number
goto_next_font:
        add     edi,size FMFONTINFO32
        loop    open_next_font

        INVOKE  DosFreeMem,lpDevFonts
        mov     edx,lpDbcsFontSeg       ; return DBCS system font fontseg
        jmp     load_sysfont_done

use_sbcs_sys_font:
        mov     edx,lpSbcsFontSeg       ; return SBCS system font fontseg

load_sysfont_done:
        ret

DbcsModifySystemFonts ENDP

page

;---------------------------Public-Routine------------------------------;
; DbcsValidateSystemFonts
;
;   Validate DBCS font resources for current process.
;
;   This entry is called only from fill_log_dev_blk() at DDC enabling,
;   when DBCS conditional compile flag is set.
;   If SW_SYSTEM_DBCS flag is cleared, we do nothing.
;
; Entry:
;       none.
; Returns:
;       none.
; Registers Destroyed:
;       EAX,EBX,ECX,EDX,FLAGS
; Registers Preserved:
;       ESI,EDI,EBP
; Calls:
; History:
;   10-Nov-1990 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;-----------------------------------------------------------------------;

DbcsValidateSystemFonts PROC SYSCALL uses ESI EDI EBX

        test    swFlags,SW_DISPLAY_DBCS
        jz      vali_sysfont_done       ; work as SBCS driver

; Load DBCS font manager and validate the fonts for this process.

        INVOKE  DbcsLoadFontManager

        mov     eax,FM_PUBLIC
        INVOKE  DbcsQueryFontCount      ; touch the device fonts

; SBCS resource loadings may override our device font defintion.
; Save SBCS system font address and update ddcInit with DBCS system font.

        test    swFlags,SW_SYSTEM_DBCS
        jz      vali_sysfont_done       ; SBCS system font

        mov     eax,lpDbcsFontSeg
        push    ddcInit.ddc_ca.ca_pFont
        mov     ddcInit.ddc_ca.ca_pFont,eax
ifdef  TMP
; See @Y1 in enable.asm for the reason of the following change          ;@Y1A
;       pop     lpSbcsFontSeg                                           ;@Y1D
        pop     esi                                                     ;@Y1A
endif ;TMP

vali_sysfont_done:
        ret

DbcsValidateSystemFonts ENDP

page

;---------------------------Public-Routine------------------------------;
; szcomp
;
;   compare string
;
; Entry:
;   ECX   = string max length
;   ESI   = string 1
;   EDI   = string 2
; Return:
;   ZR    = equal
;   NZ    = not equal
; Registers Destroyed:
;   ECX,ESI,EDI,FLAGS
; Registers Preserved:
; Calls:
; History:
;   10-Nov-1990 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;-----------------------------------------------------------------------;

        OPTION  PROLOGUE:NONE
        OPTION  EPILOGUE:NONE

szcomp PROC SYSCALL

        cld
szcomp_loop:
        lodsb
        scasb
        jnz     szcomp_done             ; not equal
        or      al,al
        jz      szcomp_done             ; null terminate, equal
        loop    szcomp_loop
        or      ecx,ecx                 ; full length, equal
szcomp_done:
        ret

szcomp ENDP

        OPTION  PROLOGUE:PrologueDef
        OPTION  EPILOGUE:EpilogueDef

end
