;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = DBCSFONT.ASM
;*
;*
;* VERSION      V2.0
;*
;* DATE         11/18/90
;*
;* DESCRIPTION  This is part of the DBCS-NLS support dependent sources.
;*              This module includes the interface routines to access
;*              font manager.
;*
;* FUNCTIONS    DbcsLoadFontManager
;*              DbcsQueryFontCount
;*              DbcsGetFontList
;*              DbcsRealizeFont
;*              DbcsUnRealizeFont
;*              DbcsQueryMatchNum
;*              DbcsFixFontMetrics
;*              DbcsQueryFontProfile
;*              DbcsMapCharGlyph
;*              DbcsValidateFontSeg
;*              DbcsLoadFontDriver
;*              DbcsValidateVioChar
;*
;* NOTE         These modules absorbs the difference between SBCS device
;*              resource fonts and DBCS font manager fonts.
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        PTR    CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   11/18/90                     Written by Soh Ohta [jl09057 @ ymtvm3]
;*   10/21/92  @Y1         04268  Fixed DeviceQueryFonts of private font only
;*   11/04/93  @NI1        none.  Remove redundant thunk to callback DosLoadModule.
;*   11/04/93  @NI2      PJ11007  Modified to load FM at the per-proc init time.
;*****************************************************************************/

        .386

        .MODEL FLAT,SYSCALL

        ASSUME  CS:FLAT,SS:FLAT,DS:FLAT,ES:FLAT

        .XLIST

INCL_DOSNLS             equ     1
INCL_FONTFILEFORMAT     equ     1
INCL_GRE_FONTS          equ     1
INCL_DEV                equ     1
INCL_VIO                equ     1
INCL_DDIMISC            equ     1

INCL_DDIFONTSTRUCS EQU 1

        OPTION  OLDSTRUCTS

        include pmgre.inc

DINCL_VIO       equ     1
DINCL_ERROR     equ     1
DINCL_ENABLE    equ     1
DINCL_BITMAP    equ     1

        include driver.inc
        include fontseg.inc
        include fontmap.inc
        include extern.inc
        include protos.inc

KC_DBCSRSRVD2   equ     0               ; unresolved but not used.

        include fontdrvr.inc
        include bsememf.inc

        .LIST

        .DATA

; When a cell refers to an LCID that's not loaded, we draw it
; as a blank in the default font (LCID 0).  SURROGATE_CHARACTER
; is the assumed glyph index for blank. See DbcsValidateVioChar.

SURROGATE_CHARACTER     equ     20h

LMATCH_SYS_SBCS equ     0ffffffffh      ; SBCS system font match number

        public  szFmDispatchTbl         ; font manager dispatch table entry name
        public  alpFm                   ; font manager dispatch table
        public  pszPMNLSFM

        public  lpDbcsFontSeg           ; DBCS system font address
        public  lpSbcsFontSeg           ; SBCS system font address

;-----------------------------------------------------------------------;
; word <-> dword convert table
;-----------------------------------------------------------------------;
align 4
ArrayConvTable  dw      512     dup(?)

;-----------------------------------------------------------------------;
; DBCS fonts available
;-----------------------------------------------------------------------;

lpDbcsFontSeg   dd      0               ; DBCS font manager system font
lpSbcsFontSeg   dd      0               ; SBCS resource     system font

;-----------------------------------------------------------------------;
; DBCS device font support module
;-----------------------------------------------------------------------;

szFmDispatchTbl db      'DDFM_DISPATCH_TABLE32',0
alpFm           dd      (size FMDISPATCH32)/4 dup (0)

PUBLIC  szPMNLSFM               ; Made public for external refference.  ;@NI2
szPMNLSFM       db      'PMNLSFM',0
pszPMNLSFM      dd      ?

        .CODE

page

ERRBUFLEN       equ     100                                             ;@NI1

        .errdef LOADFM_THUNK            ; Flag for old compatibility.   ;@NI1
ifndef LOADFM_THUNK                                                     ;@NI1
;---------------------------------------------------------------------------
; ring3_DosLoadModule
;
;   ENTRY
;       EDX = Address of ASCIIZ for the module name to be loaded.
;   RETURN
;       EAX = Return Value from DosLoadModule
;       EDX = Module Handle (if success)
;             NULL (if error)
; History:
;   4th.Nov.1993 N.Ichikawa [JL25003@ymtvm4]
;   Created.
;---------------------------------------------------------------------------

ring3_DosLoadModule     PROC SYSCALL USES EBX ECX
        LOCAL   szErrObjNames[ERRBUFLEN]:BYTE,
                hModule:DWORD

        LEA     ECX,szErrObjNames       ; ECX -> szErrObjName
        LEA     EBX,hModule             ; EBX : PHMODULE

        INVOKE  DosLoadModule,
                ECX,                    ; pszErrObjNames
                DWORD PTR ERRBUFLEN,    ; length of buffer
                EDX,                    ; pszModName
                EBX                     ; PHMODULE

        XOR     EDX,EDX                 ; assume error
        OR      EAX,EAX                 ; any error ?
        JNZ     r3_DLM_error_exit       ; yes..
        MOV     EDX,hModule             ; EDX = hModule
r3_DLM_error_exit:
        RET
ring3_DosLoadModule     ENDP
endif ;LOADFM_THUNK                                                     ;@NI1

;---------------------------Public-Routine------------------------------;
; DbcsLoadFontManager
;
;   Load DBCS font manager for current DbcsLoadFontManager process.
;   Font manager dispatch table will be copied.
;
; Return:
;   EAX    = 0 else error code
; Registers Destroyed:
;   EAX,EBX,ECX,EDX
; Registers Preserved:
;   ESI,EDI
; Calls:
; History:
;   10-Nov-1990 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;-----------------------------------------------------------------------;

;;ERRBUFLEN     equ     100     ;@NI1 Moved to above for another routine's use.

EXTERNDEF       _hModuleFM:DWORD                                        ;@NI2

DbcsLoadFontManager PROC SYSCALL uses ESI EDI EBX
        LOCAL   lpEntry     :DWORD,
                hModule     :DWORD,
                ErrObjNames[ERRBUFLEN] :BYTE

        mov     edx,_hModuleFM  ; Get the handle (in instance data).    ;@NI2
        mov     hModule,edx                                             ;@NI2
        or      edx,edx                 ; We've already had it ?        ;@NI2
        jnz     Get_dispatch_table      ; OK, go to next.               ;@NI2

        mov     eax,cs
        and     eax,1           ;at R3?
        jnz     Case_R3         ;Yes

; Load DBCS font manager (from Ring 2).

ifdef LOADFM_THUNK      ; -> NO LONGER USED.                            ;@NI1

        call    R2LoadFontMgr32

; Check return code

        or      ax,ax
        jnz     loadfm_done
        mov     hModule,edx

else  ;LOADFM_THUNK                                                     ;@NI1
                                                                        ;@NI1
        ; Call back the Dos32LoadModule directly without 32-16 thunk    ;@NI1
        ; via Vga32CallBack.                                            ;@NI1
                                                                        ;@NI1
        LEA     EDX,szPMNLSFM           ; EDX -> "PMNLSFM"              ;@NI1
        INVOKE  Vga32CallBack,                                          ;@NI1
                OFFSET ring3_DosLoadModule                              ;@NI1
                                                                        ;@NI1
        OR      EAX,EAX                 ; any error ?                   ;@NI1
        JNZ     loadfm_done             ; yes..                         ;@NI1
        MOV     hModule,EDX                                             ;@NI1
                                                                        ;@NI1
endif ;LOADFM_THUNK                                                     ;@NI1

        jmp     Get_dispatch_table


; Load DBCS font manager (from Ring 3).

Case_R3:
        INVOKE  DosLoadModule,
                ADDR ErrObjNames,
                ERRBUFLEN,
                ADDR szPMNLSFM,
                ADDR hModule

        or      ax,ax
        jnz     loadfm_done

        public Get_dispatch_table
Get_dispatch_table::

; Get font manager dispatch table.

        INVOKE  DosQueryProcAddr,
                hModule,
                0,
                ADDR szFmDispatchTbl,
                ADDR lpEntry

        or      ax,ax
        jnz     loadfm_done

; Copy font manager dispatch table.

        mov     esi,lpEntry
        lea     edi,alpFm
        mov     ecx,(size FMDISPATCH32)/4
        cld
        rep     movsd
        xor     ax,ax

loadfm_done:
        movzx   eax,ax
        ret
DbcsLoadFontManager ENDP

page

;---------------------------Public-Routine------------------------------;
; DbcsQueryFontCount
;
;   Returns the number of device fonts available.
;   After this call, the all font segments listed here are validated
;   for this process.
;
; Entry:
;   EAX   = options (FM_PUBLIC,FM_PRIVATE)
; Return:
;   ECX   = number of fonts found
;   EDX   = number of MBCS/DBCS fonts found
; Registers Destroyed:
;       EAX,ECX,EDX,FLAGS
; Registers Preserved:
;       EBX,ESI,EDI,EBP
; Calls:
; History:
;   14-Apr-1992 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;-----------------------------------------------------------------------;

DbcsQueryFontCount PROC SYSCALL uses EBX
        LOCAL   options   :DWORD        ; search option

        mov     options,eax             ; keep options

; Query all of requested type of fonts which are provided by font manager.

        INVOKE  ALPFMfmdisp32_Fm32QueryFonts PTR alpFm.fmdisp32_Fm32QueryFonts,
                eax, 0, 0, 1, -1

        mov     edx,eax                 ; number of MBCS/DBCS fonts available
        mov     ecx,eax

        test    options,FM_PUBLIC
        jz      qfc_done
        inc     ecx                     ; also SBCS font is available

qfc_done:
        ret
DbcsQueryFontCount ENDP

page

;---------------------------Public-Routine------------------------------;
; DbcsGetFontList
;
;   Get a list of device fonts available.
;   Returns both DBCS font manager font and SBCS resource fonts.
;   After this call, the all font segments listed here are validated
;   for this process.
;
; Entry:
;   EAX   = options (FM_PUBLIC,FM_PRIVATE)
; Return:
;   EAX   = long pointer to font list available (FMFONTINFO32 structure)
;           (allocated here)
;           null if ecx is zero (We cannot alloc zero-sized mem block)  :@Y1A
;   ECX   = number of fonts found
;   CY    = error (EAX = error code)
; Registers Destroyed:
;       EAX,ECX,EDX,FLAGS
; Registers Preserved:
;       EBX,ESI,EDI,EBP
; Calls:
; History:
;   10-Nov-1990 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;-----------------------------------------------------------------------;

DbcsGetFontList PROC SYSCALL uses EBX
        LOCAL   options :DWORD,
                lpFonts :DWORD,         ; list   of fonts found
                cFonts  :DWORD          ; number of fonts found

        mov     options,eax             ; keep options

        cld                             ; cleanup
        xor     eax,eax
        mov     cFonts,eax
        mov     lpFonts,eax

; Query all of requested type of fonts which are provided by font manager.

        INVOKE  ALPFMfmdisp32_Fm32QueryFonts PTR alpFm.fmdisp32_Fm32QueryFonts,
                options, 0, 0, 1, -1

        mov     cFonts,eax              ; number of fonts available

        test    options,FM_PUBLIC
        jz      @f                      ; public fonts are not requested
        inc     eax                     ; room for SBCS resource font

@@:                                                                     ;@Y1A
        or      eax,eax                 ; eax may be zero at this point  @Y1A
        jz      qflist_exit             ; if so, we have nothing to do   @Y1A
                                        ; let's go to normal exit        @Y1A
        imul    eax,eax,size FMFONTINFO32 ; required memory size        ;@Y1C

        INVOKE  DosAllocMem,
                ADDR lpFonts,
                eax,
                fALLOC
        or      eax,eax
        jnz     qflist_error            ; error, cannot allocate memory

        mov     eax,cFonts
        or      eax,eax                 ; any DBCS fonts ?
        jz      gfl_add_sbcs_font       ; no...

        INVOKE  ALPFMfmdisp32_Fm32QueryFonts PTR alpFm.fmdisp32_Fm32QueryFonts,
                options, lpFonts, 0, 1, eax

        or      eax,eax
        jnz     qflist_error            ; error

; Add SBCS resource font to the list if PUBLIC font is requested.

gfl_add_sbcs_font:
        test    options,FM_PUBLIC
        jz      qflist_verify           ; public fonts are not requested

        mov     ebx,lpFonts
        mov     edx,cFonts
        imul    edx,edx,size FMFONTINFO32
        add     ebx,edx

        mov     eax,lpSbcsFontSeg


        mov     [ebx].fmfont32_hfm,eax    ; font handle == font addres
        mov     [ebx].fmfont32_pFont,eax

        mov     [ebx].fmfont32_lMatch,LMATCH_SYS_SBCS
        mov     [ebx].fmfont32_flType.lo,Low  FM_PM_FONT
        mov     [ebx].fmfont32_flType.hi,High FM_PM_FONT

        mov     [ebx].fmfont32_ulLen,0ffffh
        mov     [ebx].fmfont32_szGlyphlist,0
        inc     cFonts

; If the font resolutions defined in the font manager font metrics are
; different from the resolutions in device caps, we must fix the point
; sizes and related metrics.

qflist_verify:
        mov     ecx,cFonts
        jcxz    qflist_exit             ; no fonts detected
        mov     ebx,lpFonts             ; EBX --> FMFONTINFO32 table

qflist_verify_next:
        mov     eax,[ebx].fmfont32_pFont  ; EAX --> fontseg
        dec     ecx
        jz      qflist_exit
        add     ebx,size FMFONTINFO32     ; EBX --> next FMFONTINFO32 entry
        jmp     qflist_verify_next


qflist_error:
        cmp     lpFonts,0
        jz      @f
        INVOKE  DosFreeMem,lpFonts
@@:     stc
        jmp     qflist_done

qflist_exit:
        mov     ecx,cFonts
        mov     eax,lpFonts
        clc
qflist_done:
        ret

DbcsGetFontList ENDP

page

;---------------------------Public-Routine------------------------------;
; DbcsRealizeFont
;
;   Realize the specified SBCS/DBCS device font.
;   Search SBCS font first, and if not found, then call font manager
;   to search DBCS font.
;
; Entry:
;   EAX = logical font (FATTRS structure)
; Return:
;   EAX = font handle (=fontseg)
; Error Return:
;   EAX = 0  (not found)
;   EAX = -1 (error)
; Registers Destroyed:
;   EAX,EDX,FLAGS
; Registers Preserved:
;   EBX,ECX,EBP,ESI,EDI
; Calls:
; History:
;   10-Nov-1990 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;-----------------------------------------------------------------------;

DbcsRealizeFont PROC SYSCALL uses EBX ECX ESI EDI
        LOCAL   lpLogFont   :DWORD,
                FontInfo    :FMFONTINFO32

        mov     lpLogFont,eax
        mov     edi,lpLogFont           ; EDI --> logical font

        mov     eax,[edi].FATTRS.fat_lMatch
        or      eax,eax
        js      rf_search_matchnum      ; lMatch<0, search by match number
        or      eax,eax
        jnz     rf_no_match_found       ; lMatch>0, engine font. do nothing

; Serach SBCS device by logical font definition (lMatch==0).
; Current check points are szFacename and MaxBaselineExt.

rf_search_logfont:
        mov     esi,lpSbcsFontSeg       ; ESI --> SBCS resource fontseg

        movzx   eax,[esi].FOCAFONT.ff_fmMetrics.foca_yMaxBaselineExt
        cmp     eax,[edi].FATTRS.fat_lMaxBaselineExt
        jne     @f                      ; height not match
        lea     edi,[edi].FATTRS.fat_szFacename
        lea     esi,[esi].FOCAFONT.ff_fmMetrics.foca_szFacename
        mov     ecx,FACESIZE
        INVOKE  szcomp                  ; compare facenames
        mov     edi,lpLogFont           ; EDI --> logical font

@@:
        jne     rf_search_dbcs_font     ; logical font not match
        jmp     rf_return_sbcs_font

; Search SBCS device font by match number (font identifier).

rf_search_matchnum:
        cmp     [edi].FATTRS.fat_lMatch,LMATCH_SYS_SBCS
        jne     rf_search_dbcs_font
        jmp     rf_return_sbcs_font

; Search DBCS device font using DBCS font manager.

rf_search_dbcs_font:

        INVOKE  ALPFMfmdisp32_Fm32OpenFont PTR alpFm.fmdisp32_Fm32OpenFont,
                edi, ADDR FontInfo

        cmp     eax,FM_FONT_FOUND
        je      rf_return_dbcs_font
        or      eax,eax
        jz      rf_no_match_found
        .errnz  FM_FONT_NOT_FOUND

rf_error:
        mov     eax,-1                      ; error occurred.
        jmp     rf_done
rf_no_match_found:
        xor     eax,eax                     ; no match found.
        jmp     rf_done
rf_return_sbcs_font:
        mov     eax,lpSbcsFontSeg           ; return SBCS device font.
        jmp     rf_done
rf_return_dbcs_font:
        mov     eax,FontInfo.fmfont32_hfm     ; return DBCS device font.
rf_done:
        ret
DbcsRealizeFont ENDP

page

;---------------------------Public-Routine------------------------------;
; DbcsUnRealizeFont
;
;   Unrealize the specified SBCS/DBCS device font.
;   We assumes that the SBCS device font is not a font manager font,
;   and do nothing for it.
;
; Entry:
;   EAX = font handle (=fontseg)
; Return:
;   none
; Registers Destroyed:
; Registers Preserved:
; Calls:
; History:
;   10-Nov-1990 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;-----------------------------------------------------------------------;

DbcsUnRealizeFont PROC SYSCALL uses EDI

;       verr    eax                     ; unexpectedly, the engine give us
;       jnz     urf_invalid             ; the unknown or invalid font handle.
        or      eax,eax                 ; we will check its validity here...
        jnz     urf_invalid

        mov     edi,eax                 ; EDI --> fontseg

        test    [edi].FOCAFONT.ff_fmMetrics.foca_fsDefn,FM_DEFN_GENERIC
        jnz     urf_done                ; engine font
        test    [edi].FOCAFONT.ff_fmMetrics.foca_fsTypeFlags,(FM_TYPE_MBCS or FM_TYPE_DBCS)
        jz      urf_done                ; device SBCS font

        INVOKE  ALPFMfmdisp32_Fm32CloseFont PTR alpFm.fmdisp32_Fm32CloseFont,
                eax

        jmp     urf_done

urf_invalid:
ifdef FIREWALLS
        rip     text,<DbcsUnRealizeFont - Invalid font handle encountered>
endif
urf_done:
        RET

DbcsUnRealizeFont ENDP

page

;---------------------------Public-Routine------------------------------;
; DbcsQueryMatchNum
;
;   Return the match number for the specified SBCS/DBCS device font.
;   We assumes that the SBCS device font is not a font manager font.
;
; Entry:
;   EAX = font handle (=fontseg)
; Return:
;   EAX = match number (nagative value)
; Error Return:
;   EAX = 0
; Registers Destroyed:
; Registers Preserved:
; Calls:
; History:
;   10-Nov-1990 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;-----------------------------------------------------------------------;

DbcsQueryMatchNum PROC SYSCALL uses EDI
        LOCAL   FontInfo    :FMFONTINFO32

        mov     edi,eax                 ; EDI --> fontseg

        test    [edi].FOCAFONT.ff_fmMetrics.foca_fsDefn,FM_DEFN_GENERIC
        jnz     qmn_not_found           ; engine font
        test    [edi].FOCAFONT.ff_fmMetrics.foca_fsTypeFlags,(FM_TYPE_MBCS or FM_TYPE_DBCS)
        jnz     qmn_query_dbcs_font     ; font manager DBCS font

qmn_query_sbcs_font:
        cmp     lpSbcsFontSeg,eax
        jne     qmn_not_found

        mov     eax,LMATCH_SYS_SBCS
        jmp     qmn_done                ; return SBCS font match number

qmn_query_dbcs_font:

        lea     ebx,FontInfo
        INVOKE  ALPFMfmdisp32_Fm32QueryFonts PTR alpFm.fmdisp32_Fm32QueryFonts,
                (FM_PRIVATE+FM_PUBLIC),
                ebx,
                edi,
                1,
                -1

        or      eax,eax
        jnz     qmn_not_found           ; not our font.

        mov     eax,FontInfo.fmfont32_lMatch
        jmp     qmn_done                ; return DBCS font match number

qmn_not_found:
        xor     eax,eax                 ; font not found
qmn_done:
        RET

DbcsQueryMatchNum ENDP

page

;---------------------------Public-Routine------------------------------;
; DbcsFixFontMetrics
;
;   Fix point sizes and the related metrics when the display driver's
;   fontres and the font manager font's fontres are different.
;
;   - yDeviceRes (yFontFontres) = yDispFontres
;   - xDeviceRes (xFontFontres) = xFontFontres*yDispFontres/yFontFontres
;   - usNominalPointSize  = usNominalPointSize*yFontFontres/yDispFontres
;   - usMinimumPointSize  = usMinimumPointSize*yFontFontres/yDispFontres
;   - usMaximumPointSize  = usMaximumPointSize*yFontFontres/yDispFontres
;
;   Be sure this routine assumes that the FONTMETRICS structure is
;   described in device coordinate. If coordiate translation is needed,
;   the translation must be done after this routine is called.
;
;   See also: far_DbcsModifySystemFonts() in dbcsinit.asm.
;
; Entry:
;   ESI   = font metrics (FONTMETRICS structure)
; Return:
;   none
; Registers Destroyed:
;   EAX,EBX,ECX,EDX,FLAGS
; Registers Preserved:
;   EBP,ESI,EDI
; Calls:
; History:
;   19-Dec-1991 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;-----------------------------------------------------------------------;

DbcsFixFontMetrics PROC SYSCALL

        mov     ebx,adDevCapsData[SIZE_DWORD*CAPS_VERTICAL_FONT_RES]
        mov     cx,[esi].fm_sYDeviceRes
        cmp     bx,cx                   ; yDispFontres==yFontFontres?
        je      ffm_done

; Y-Resolutions are different. Compute point sizes using driver's fontres.
; Be sure that point sizes should be saved in decipoint.

        mov     ax,[esi].fm_sXDeviceRes
        mul     bx
        div     cx                      ; AX = xDeviceRes, DX = remainder
        add     dx,dx
        cmp     cx,dx                   ; 'C' if remainder > divisor/2
        adc     ax,0
        mov     [esi].fm_sXDeviceRes,ax
        mov     [esi].fm_sYDeviceRes,bx

        imul    bx,bx,10

        mov     ax,[esi].fm_sNominalPointSize
        mul     cx
        div     bx                      ; AX = point size, DX = remainder
        add     dx,dx
        cmp     bx,dx                   ; 'C' if remainder > divisor/2
        adc     ax,0
        imul    ax,ax,10                ; get result in decipoint
        mov     [esi].fm_sNominalPointSize,ax

        mov     ax,[esi].fm_sMinimumPointSize
        mul     cx
        div     bx                      ; AX = point size, DX = remainder
        add     dx,dx
        cmp     bx,dx                   ; 'C' if remainder > divisor/2
        adc     ax,0
        imul    ax,ax,10                ; get result in decipoint
        mov     [esi].fm_sMinimumPointSize,ax

        mov     ax,[esi].fm_sMaximumPointSize
        mul     cx
        div     bx                      ; AX = point size, DX = remainder
        add     dx,dx
        cmp     bx,dx                   ; 'C' if remainder > divisor/2
        adc     ax,0
        imul    ax,ax,10                ; get result in decipoint
        mov     [esi].fm_sMaximumPointSize,ax

ffm_done:
        RET

DbcsFixFontMetrics ENDP

page

;---------------------------Public-Routine------------------------------;
; DbcsQueryFontProfile
;
;   Return font characteristic flags (NLSCA_FONT_*) for specifiled font.
;   We assumes that the SBCS device font is not a font manager font.
;
; Entry:
;   EAX = font handle (=fontseg)
; Return:
;   EAX   = flags
;   EDX   = number of characters to be able to be cached at once
;           (valid only when NLSCA_FONT_HUGE is returned)
; Registers Destroyed:
; Registers Preserved:
; Calls:
; History:
;   10-Nov-1990 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;-----------------------------------------------------------------------;

DbcsQueryFontProfile PROC SYSCALL uses EBX ECX EDI
        LOCAL   fsfont      :WORD,
                FontInfo    :FMFONTINFO32

        mov     edi,eax                 ; EDI --> fontseg

        mov     ax,NLSCA_FONT_SBCS      ; assumes SBCS font
        mov     dx,[edi].FOCAFONT.ff_fmMetrics.foca_fsTypeFlags
        and     dx,(FM_TYPE_MBCS or FM_TYPE_DBCS)
        jz      qfp_have_font_type
        mov     ax,NLSCA_FONT_DBCS      ; assumes DBCS font
        cmp     dx,FM_TYPE_DBCS
        je      qfp_have_font_type
        mov     ax,NLSCA_FONT_MBCS      ; MBCS font

qfp_have_font_type:
        test    [edi].FOCAFONT.ff_fmMetrics.foca_fsDefn,FM_DEFN_GENERIC
        jnz     qfp_done                ; engine font
        test    ax,NLSCA_FONT_MBCS+NLSCA_FONT_DBCS
        jz      qfp_done                ; SBCS device font

; Font is font manager font (DBCS device font).

        mov     fsfont,ax               ; save flags

        INVOKE  ALPFMfmdisp32_Fm32QueryFonts PTR alpFm.fmdisp32_Fm32QueryFonts,
                (FM_PRIVATE+FM_PUBLIC),
                ADDR FontInfo,
                edi,
                1,
                -1

        or      ax,ax
        mov     ax,fsfont               ; restore flags
        jnz     qfp_done                ; not our font.

        test    FontInfo.fmfont32_flType.lo,FM_CACHE_FONT
        jz      qfp_done
        or      ax,NLSCA_FONT_CACHED
        mov     edx,FontInfo.fmfont32_cbCache
        cmp     edx,256
        jae     qfp_done
        or      ax,NLSCA_FONT_HUGE      ; less than 256 chars in fontseg
qfp_done:
        movzx   eax,ax
        RET

DbcsQueryFontProfile ENDP

page

;---------------------------Public-Routine------------------------------;
; DbcsMapCharGlyph
;
;   Get non-resident device (font manager) fonts from font cache
;   and validate fontseg structure.
;
; Entry:
;   EAX   = codepage
;   ECX   = string length in bytes
;   ESI   = DBCS device font (font manager font) font segment
;   EDI   = string
; Return:
;   EAX    = return code (error on !0)
; Registers Destroyed:
;       EAX,EBX,ECX,EDX,FLAGS
; Registers Preserved:
;       EBP,ESI,EDI
; Calls:
; History:
;   10-Nov-1990 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;-----------------------------------------------------------------------;

DbcsMapCharGlyph PROC SYSCALL uses esi edi
        local   count           :DWORD
        local   pstr            :DWORD
        local   codepage        :DWORD
        local   fontseg         :DWORD

        mov     count,ecx
        mov     pstr,edi
        mov     codepage,eax
        mov     fontseg,esi
 xor eax,eax    ;           
 or ecx,ecx    ;           
 jz mcg_exit   ;           
        mov     esi,edi
        lea     edi,ArrayConvTable
        inc     ecx
        shr     ecx,1
@@:
        lodsd
        stosw
        loop    @B
        lea     edi,ArrayConvTable
        INVOKE  ALPFMfmdisp32_Fm32MapCharGlyph PTR alpFm.fmdisp32_Fm32MapCharGlyph,
                fontseg, codepage, edi, edi, count
        mov     bx,ax
        mov     ecx,count
        inc     ecx
        shr     ecx,1
        lea     esi,ArrayConvTable
        mov     edi,pstr
        xor     eax,eax
@@:
        lodsw
        stosd
        loop    @B
        movzx   eax,bx
mcg_exit:     ;           
        RET
DbcsMapCharGlyph ENDP

page

;---------------------------Public-Routine------------------------------;
; DbcsValidateFontSeg
;
;   Get non-resident device (font manager) fonts from font cache
;   and validate fontseg structure.
;
; Entry:
;   ECX   = signed character count
;   ESI   = DBCS device font (font manager font) font segment
;   EDI   = array of mixed SBCS glyph-index / DBCS code-point string
;
;   note:   ECX > 0  = request for whole fonts
;           ECX < 0  = request for font information only
; Return:
;   EAX   = return code (error on !0)
; Registers Destroyed:
;       EAX,EBX,ECX,EDX,FLAGS
; Registers Preserved:
;       EBP,ESI,EDI
; Calls:
; History:
;   10-Nov-1990 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;   14-Apr-1992 -by- Soh Ohta [jl09057 @ ymtvm3]
; Handle FmCharStr error case, which would be caused by insufficent
; system resources.
;-----------------------------------------------------------------------;

DbcsValidateFontSeg PROC SYSCALL uses ESI EDI
        LOCAL   lpIndices :DWORD,       ; array  of glyph indices
                cIndices  :DWORD,       ; number of glyph indices
                selFont   :DWORD,       ; fontseg selector
                flOptions :DWORD

 xor eax,eax    ;           
 or ecx,ecx    ;           
 jz vfs_have_indices  ;           

        mov     flOptions,FM_WITH_FONT
                                ; assume request for information and font
        or      ecx,ecx             ; really ?
        jns     @f                  ; yes...
        mov     flOptions,FM_WITHOUT_FONT ; request only for information.
        neg     ecx                 ; (font image won't be moved from cache)
@@:
        mov     cIndices,ecx
        mov     lpIndices,edi
        mov     selFont,esi
        cld
        mov     esi,esp         ; push esp
        mov     esp,edi
        lea     edi,ArrayConvTable
@@:
        pop     eax
        stosw
        loop    @B
        mov     esp,esi         ; pop esp
        INVOKE  ALPFMfmdisp32_Fm32CharStr PTR alpFm.fmdisp32_Fm32CharStr,
                selFont, flOptions, ADDR ArrayConvTable, cIndices

        or      eax,eax
        jnz     vfs_sbcs_font
        xor     eax,eax
        mov     ecx,cIndices
        lea     esi,ArrayConvTable      ; ESI --> word array of glyph indices
        mov     edi,lpIndices           ; EDI --> dword array of glyph indices
@@:
        lodsw
        stosd
        loop    @B
        xor     eax,eax
        jmp     vfs_have_indices

; The fontseg validation failed, so we will replace all of DBCS glyph
; indices with SBCS default character.

vfs_sbcs_font:
        mov     esi,selFont             ; ESI = fontseg
        mov     dx,[esi].FOCAFONT.ff_fmMetrics.foca_usDefaultChar
        mov     bx,[esi].FOCAFONT.ff_fmMetrics.foca_usFirstChar
        add     bx,[esi].FOCAFONT.ff_fmMetrics.foca_usLastChar
        xor     eax,eax
        mov     ecx,cIndices
        lea     esi,ArrayConvTable      ; ESI --> word array of glyph indices
        mov     edi,lpIndices           ; EDI --> dword array of glyph indices
vfs_sbcs_loop:
        lodsw
        cmp     ax,bx
        ja      vfs_sbcs_substitute
@@:     stosd
        loop    vfs_sbcs_loop
        mov     eax,-1                  ; indicate default substituted
        jmp     vfs_have_indices
vfs_sbcs_substitute:
        mov     ax,dx                   ; do default substitution
        jmp     @b

vfs_have_indices:
        ret
DbcsValidateFontSeg ENDP

page

;---------------------------Public-Routine------------------------------;
; DbcsLoadFontDriver
;
; Entry:
;   ECX   = reqest code
;   EAX   = font driver full path name, or module name (*.DLL)
; Return:
;   EAX   = 0
; Error Return:
;   EAX   = -1
; Registers Destroyed:
; Registers Preserved:
; Calls:
; History:
;   10-Nov-1990 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;-----------------------------------------------------------------------;

DbcsLoadFontDriver PROC SYSCALL

        mov     ebx,FM_PRIVATE        ; assumes for private use
        cmp     ecx,LOAD_FD_PRIVATE
        je      lfd_load
        cmp     ecx,UNLOAD_FD_PRIVATE
        je      lfd_unload
        mov     ebx,FM_PUBLIC         ; assumes for public use
        cmp     ecx,LOAD_FD_PUBLIC
        je      lfd_load
        cmp     ecx,UNLOAD_FD_PUBLIC
        je      lfd_unload
        jmp     lfd_error         ; unknown request

lfd_load:
        INVOKE  ALPFMfmdisp32_Fm32LoadFontDriver PTR alpFm.fmdisp32_Fm32LoadFontDriver,                ebx,eax

        jmp     lfd_done                ; EAX = result code

lfd_unload:
        INVOKE  ALPFMfmdisp32_Fm32UnLoadFontDriver PTR alpFm.fmdisp32_Fm32UnloadFontDriver,            ebx,eax

        jmp     lfd_done                ; EAX = result code

lfd_error:
        mov     eax,-1
lfd_done:
        ret
DbcsLoadFontDriver ENDP

page

;---------------------------Public-Routine------------------------------;
; DbcsValidateVioChar
;
;   Get non-resident device (font manager) fonts from font cache
;   and validate fontseg structure.
;
; Entry:
;   ECX     = number of DBCS chars
;   EAX     = fontseg (SBCS or MBCS)
;   EDI     = array of DBCS code-points
;   FLAGS   = upward (cld)
; Return:
;   EAX     = offset to get DBCS 2nd byte
;   NC      = mapped to DBCS characters
;   CY      = mapped to SBCS default characters
; Registers Destroyed:
;       EAX,EBX,ECX,EDX,ESI,EDI,FLAGS
; Registers Preserved:
;       EBP
; Calls:
; History:
;   10-Nov-1990 -by- Soh Ohta [jl09057 @ ymtvm3]
; Created.
;   14-Apr-1992 -by- Soh Ohta [jl09057 @ ymtvm3]
; Handle FmCharStr error case, which would be caused by insufficent
; system resources.
;-----------------------------------------------------------------------;

DbcsValidateVioChar PROC SYSCALL,
                lpIndices :DWORD,       ; array  of glyph indices
                cIndices  :DWORD,       ; number of glyph indices
                selFont   :DWORD        ; fontseg selector

        cld
        mov     lpIndices,edi
        mov     cIndices,ecx
        mov     selFont,eax

        or      eax,eax                 ; tell us the invalid font handle.
        jz      vvc_invalid_font        ; we will check its validity here...

        test    [eax].FOCAFONT.ff_fmMetrics.foca_fsTypeFlags,(FM_TYPE_MBCS or FM_TYPE_DBCS)
        jz      vvc_sbcs_font

; MBCS/DBCS fontseg. Try to validate fontseg and to get the glyph indices
; for validated DBCS characters.

 or ecx,ecx  ;           
 jz vvc_skip1 ;           
        mov     esi,esp         ; push esp
        mov     esp,edi
        lea     edi,ArrayConvTable
@@:
        pop     eax
        stosw
        loop    @B
        mov     esp,esi         ; pop esp
vvc_skip1:   ;           
        INVOKE  ALPFMfmdisp32_Fm32CharStr PTR alpFm.fmdisp32_Fm32CharStr,
                selFont,
                FM_WITH_FONT,
                ADDR ArrayConvTable,
                cIndices

        or      eax,eax
        jnz     vvc_sbcs_font2         ; insufficient system resources...

        mov     ecx,cIndices
        lea     esi,ArrayConvTable
        mov     edi,lpIndices           ; EDI --> array of glyph indices
        xor     eax,eax
 or ecx,ecx  ;           
 jz vvc_skip2 ;           
@@:
        lodsw
        stosd
        loop    @B
vvc_skip2:   ;           
        mov     esi,selFont            ; ESI = fontseg
        mov     bx,[esi].FOCAFONT.ff_fmMetrics.foca_yMaxBaselineExt
        mov     ax,[esi].FOCAFONT.ff_fmMetrics.foca_xAveCharWidth
        shr     ax,3
        mul     bx              ; DBCS offset = (charwidth%8) * charheight
        clc
        jmp     vvc_have_indices

; SBCS fontseg. Substitute SBCS default char for all DBCS indices.
; Be sure that here we should not destroy the SBCS glyph indices.

vvc_sbcs_font:
        mov     esi,selFont            ; ESI = fontseg
        mov     dx,[esi].FOCAFONT.ff_fmMetrics.foca_usDefaultChar
        mov     bx,[esi].FOCAFONT.ff_fmMetrics.foca_usFirstChar
        add     bx,[esi].FOCAFONT.ff_fmMetrics.foca_usLastChar
        mov     edi,lpIndices           ; EDI --> array of glyph indices
        mov     ecx,cIndices
vvc_sbcs_loop:
        mov     eax,[edi]
        cmp     ax,bx
        ja      vvc_sbcs_substitute
@@:     stosd
        loop    vvc_sbcs_loop
        xor     eax,eax                 ; DBCS offset = 0
        stc                             ; indicate default substituted
        jmp     vvc_have_indices
vvc_sbcs_substitute:
        mov     ax,dx                   ; do default substitution
        jmp     @b

vvc_sbcs_font2:
        mov     esi,selFont            ; ESI = fontseg
        mov     dx,[esi].FOCAFONT.ff_fmMetrics.foca_usDefaultChar
        mov     bx,[esi].FOCAFONT.ff_fmMetrics.foca_usFirstChar
        add     bx,[esi].FOCAFONT.ff_fmMetrics.foca_usLastChar
        mov     ecx,cIndices
        lea     esi,ArrayConvTable
        mov     edi,lpIndices           ; EDI --> array of glyph indices
        xor     eax,eax
vvc_sbcs_loop2:
        lodsw
        cmp     ax,bx
        ja      vvc_sbcs_substitute2
@@:     stosd
        loop    vvc_sbcs_loop2
        xor     eax,eax                 ; DBCS offset = 0
        stc                             ; indicate default substituted
        jmp     vvc_have_indices
vvc_sbcs_substitute2:
        mov     ax,dx                   ; do default substitution
        jmp     @b

; Invalid fontseg. Substitute default's default char for all indices.

vvc_invalid_font:
        mov     eax,SURROGATE_CHARACTER
        rep     stosd                   ; fill with SBCS default char
        xor     eax,eax                 ; DBCS offset = 0
        stc                             ; indicate default substituted

vvc_have_indices:
        ret
DbcsValidateVioChar ENDP

end
