;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        page    ,132
;/*****************************************************************************
;*
;* SOURCE FILE NAME = DBCSCP.ASM
;*
;*
;* VERSION      V2.0
;*
;* DATE         11/24/90
;*
;* DESCRIPTION  This is part of the DBCS-NLS support dependent sources.
;*              This module contains the DBCS codepage handling functions.
;*
;* FUNCTIONS    DbcsQueryCodePageVectors
;*              DbcsCreateCodePageVectors
;*              DbcsInitCodePageVectors
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   11/24/90                     Written by Soh Ohta [jl09057 @ ymtvm3]
;*
;*****************************************************************************/

        .386

        .MODEL FLAT,SYSCALL

        ASSUME  CS:FLAT,SS:FLAT,DS:FLAT,ES:FLAT

        .XLIST

INCL_DOSERRORS          equ     1
INCL_DOSNLS             equ     1
INCL_FONTFILEFORMAT     equ     1
INCL_GRE_FONTS          equ     1
INCL_DEV                equ     1
INCL_VIO                equ     1
INCL_DDIMISC            equ     1

INCL_DDIFONTSTRUCS EQU 1

        OPTION  OLDSTRUCTS

        include pmgre.inc

DINCL_VIO       equ     1
DINCL_ERROR     equ     1
DINCL_ENABLE    equ     1
DINCL_BITMAP equ     1

        include driver.inc
        include fontseg.inc
        include fontmap.inc
        include extern.inc
        include protos.inc
        include bsememf.inc

        .LIST

;       errcode <INV_CODEPAGE,INSUFFICIENT_MEMORY>

        .DATA

DBCSEVLEN       equ     10
PURESBCSCODEPAGE equ    00000h          ; pure SBCS codepage
PUREDBCSCODEPAGE equ    0ff00h          ; pure DBCS codepage

; DosNls functions have been made the indirect call, to reduce reload time
; at memory shortage case. Because our DBCS enabled display driver should
; work as well as also under the SBCS environment, we'll make all DosNls
; functions also indirect.

        public  lpCpMapList
        public  nCpMapList
        public  maxCpMapList
        public  npCpMapFree

;-----------------------------------------------------------------------;
; DBCS code-point mapping tables
;-----------------------------------------------------------------------;

CpMapEntry      struct  4
cme_idCodePage  dd      ?               ; codepage
cme_fsNls       dd      ?               ; NLS codepage info flags --> ca_fsNls
cme_lpCpMapTbl  dd      ?               ; code-point mapping table address
CpMapEntry      ends

lpCpMapList     dd      0               ; list of code-point mapping tables
nCpMapList      dd      0               ; current length of CpMapList
maxCpMapList    dd      0               ; max length of CpMapList
npCpMapFree     dd      0               ; high water of CpMapList buffer

        .CODE

;---------------------------Public-Routine------------------------------;
; DbcsQueryCodePageVectors
;
;   Return the code-point mapping tables for the specified codepage.
;   The table format is upper-compatible to the vector returned by
;   the GreQueryCodePageVector call.
;
;   The table is consist of two part of code-point mapping tables:
;
;   cmt_CharToGlyph --> Ŀ
;                        SBCS code-point   fsNls & NLSCA_MAP_SBCS != 0
;                        to glyph-index    when this table is available
;                        mapping table    
;   cmt_DBCSLeading --> Ĵ
;                        DBCS leading byte fsNls & NLSCA_MAP_DBCS != 0
;                        mapping table     when this table is available
;                                         
;                       
;
;   Note that the cmt_DBCSLeading should be used under the cases of:
;   (1) codepage=SBCS and NLSCA_MAP_DBCS is set ... DBCS range is invalid
;   (2) codepage=MBCS                           ... SBCS/DBCS determination
;   (3) codepage=DBCS and NLSCA_MAP_DBCS is set ... SBCS range is invalid
;
; Entry:
;       EAX = codepage
; Returns:
;       EAX = code-point mapping tables (CpMapTable structure)
;       ECX = codepage NLS infotmation flags (NLSCA_*)
; Error Returns:
;       EAX = 0  (errors already logged)
; Registers Destroyed:
;       AX,CX,DX,FLAGS
; Registers Preserved:
;       BX,SI,DI,BP,DS,ES
; Calls:
; History:
;   24-Nov-90 by Soh Ohta [jl09057 @ ymtvm3]
;   Created.
;-----------------------------------------------------------------------;

DbcsQueryCodePageVectors PROC SYSCALL uses EBX ESI EDI
        LOCAL   idCodePage  :DWORD,
                lpEntry     :DWORD

        cld
        mov     idCodePage,eax

        test    swFlags,SW_DISPLAY_DBCS ; system has DBCS capability ?
        jnz     qcpv_dbcs_path

; System is SBCS based. Normal SBCS processing.

;       check   QueryCodePageVector,<idCP,hddc,ulFunN>

        INVOKE  Gre32Entry3,
                eax,
                0,
                NGreQueryCodePageVector
        mov     ecx,NLSCA_SBCS
        jmp     qcpv_exit               ; error already logged

; Search specified codepage from CpMapList table.

qcpv_dbcs_path:
        mov     edi,lpCpMapList

        mov     eax,idCodePage
        mov     ecx,nCpMapList
        jcxz    entry_not_defined

search_entry:
        cmp     [edi].cme_idCodePage,eax
        je      entry_found
        add     edi,size CpMapEntry
        loop    search_entry

; The codepage is not found in the list of codepages.
; Check whether the codepage is valid or not, and add new entry to the table.

entry_not_defined:
        mov     lpEntry,edi

        mov     ebx,nCpMapList
        cmp     maxCpMapList,ebx
        jbe     qcpv_insufficient_memory

        mov     eax,idCodePage
        mov     [edi].cme_idCodePage,eax
        INVOKE  DbcsCreateCodePageVectors
        or      eax,eax
        jz      qcpv_error              ; error already logged

        mov     edi,lpEntry
        mov     [edi].cme_fsNls,ecx
        mov     [edi].cme_lpCpMapTbl,eax
        inc     nCpMapList
        jmp     qcpv_exit

; The codepage is found in the table.
; Check whether the code-point mapping tables have been already created or not.

entry_found:
        mov     lpEntry,edi

        cmp     [edi].cme_lpCpMapTbl,0
        je      entry_not_allocated

        mov     ecx,[edi].cme_fsNls
        mov     eax,[edi].cme_lpCpMapTbl
        jmp     qcpv_exit

; Create code-point mapping tables for this codepage.

entry_not_allocated:
        mov     eax,[edi].cme_idCodePage
        INVOKE  DbcsCreateCodePageVectors
        or      eax,eax
        jz      qcpv_error              ; error already logged

        mov     edi,lpEntry
        mov     [edi].cme_fsNls,ecx
        mov     [edi].cme_lpCpMapTbl,eax
        jmp     qcpv_exit


qcpv_insufficient_memory:
        mov     eax,PMERR_INSUFFICIENT_MEMORY
        save_error_code
qcpv_error:
        xor     eax,eax
qcpv_exit:
        ret
DbcsQueryCodePageVectors ENDP

page

;---------------------------Public-Routine------------------------------;
; DbcsCreateCodePageVectors
;
;   Create the code-point mapping tables for the specified codepage.
;
; Entry:
;       EAX = codepage
; Returns:
;       EAX = code-point mapping tables (CpMapTable structure)
;       ECX = codepage NLS infotmation flags (NLSCA_*)
; Error Returns:
;       EAX = 0  (error already logged)
; Registers Destroyed:
;       EAX,EBX,ECX,EDX,FLAGS
; Registers Preserved:
;       ESI,EDI,EBP
; Calls:
; History:
;   24-Nov-90 by Soh Ohta [jl09057 @ ymtvm3]
;   Created.
;-----------------------------------------------------------------------;

DbcsCreateCodePageVectors PROC SYSCALL uses ESI EDI EBX
        LOCAL   idCodePage  :DWORD,
                ctrycode    :COUNTRYCODE,
                fsNls       :DWORD,
                lpCpMapTbl  :DWORD,
                DBCSEv[DBCSEVLEN] :BYTE

        cld
        mov     idCodePage,eax
        mov     fsNls,0
        mov     lpCpMapTbl.hi,INVALID_ADDRESS
        mov     lpCpMapTbl.lo,INVALID_ADDRESS

; First we will check the type of codepage specified.

        mov     word ptr DBCSEv[0],0        ; play it safe
        mov     ctrycode.ctryc_country,0    ; default country code
        mov     ctrycode.ctryc_codepage,eax

;       lea     eax,DBCSEv
;       push    eax
;       lea     eax,ctrycode
;       push    eax
;       pushd   DBCSEVLEN
;       call    lpfnGetDBCSEv
;       add     esp,3*4
        INVOKE  DosQueryDBCSEnv, DBCSEVLEN, ADDR ctrycode, ADDR DBCSEv

        mov     edx,NLSCA_SBCS          ; assumes SBCS codepage
        or      eax,eax                 ; no ev vector provided by base
        jnz     ccpv_have_type          ; error. handle it as SBCS codepage
        cmp     word ptr DBCSEv[0],PURESBCSCODEPAGE
        je      ccpv_have_type          ; SBCS codepage
        mov     edx,NLSCA_DBCS          ; assumes DBCS codepage
        cmp     word ptr DBCSEv[0],PUREDBCSCODEPAGE
        je      ccpv_have_type          ; DBCS codepage
        mov     edx,NLSCA_MBCS          ; MBCS codepage

ccpv_have_type:
        mov     fsNls,edx               ; save codepage type flag

; Check if we should prepare SBCS code-point to glyph-index mapping table
; or not. We need not to prepare it when the specified codepage is:
; (1) DEFAULTVIOCODEPAGE (=850, UGL codepage)
; (2) pure DBCS codepage (no SBCS code range)

        cmp     idCodePage,DEFAULTVIOCODEPAGE
        je      ccpv_sbcs_no_mapping
        cmp     word ptr DBCSEv[0],PUREDBCSCODEPAGE
        je      ccpv_sbcs_no_mapping

;       check   QueryCodePageVector,<idCP,hddc,ulFunN>

        INVOKE  Gre32Entry3,
                idCodePage,
                0,
                NGreQueryCodePageVector
        or      eax,eax
        jz      ccpv_error              ; invalid codepage (error logged)

        mov     lpCpMapTbl,eax
        or      fsNls,NLSCA_MAP_SBCS    ; SBCS mapping table available

ccpv_sbcs_no_mapping:
        mov     ecx,fsNls
        test    ecx,NLSCA_SBCS
        jnz     ccpv_have_all_tables    ; no DBCS mapping table required

; The specified codepage has the DBCS code-point range, so we will create
; the code-point to DBCS leading byte mapping table for fast ev vector access.

        mov     ebx,npCpMapFree
        mov     eax,size CpMapTable
        add     eax,ebx
        jc      ccpv_insufficient_memory    ; assumes buffer size = 64KB
        add     ebx,lpCpMapList             ; EBX --> table to be copied

        test    fsNls,NLSCA_MAP_SBCS        ; SBCS mapping table exists ?
        jz      ccpv_create_dbcs_maptable

        lea     edi,[ebx].cmt_CharToGlyph
        mov     esi,lpCpMapTbl
        mov     ecx,CB_SBCS_MAP_TBL/4
        rep     movsd                       ; copy SBCS mapping table

ccpv_create_dbcs_maptable:
        lea     edi,[ebx].cmt_DBCSLeading
        xor     esi,esi
        xor     eax,eax
        xor     ebx,ebx

ev_entry_loop:
        mov     dx,word ptr DBCSEv[esi]
        or      dx,dx                   ; no ev entry remained ?
        jz      clean_up                ; yes...
clear_dbcs:
        cmp     bl,dl                   ; start of DBCS code-point range ?
        jae     set_dbcs                ; yes...
        stosb
        inc     bl
        jz      ev_entry_loop_done
        jmp     clear_dbcs
set_dbcs:
        cmp     bl,dh                   ; end of DBCS code-point range ?
        ja      next_ev_entry           ; no...
        mov     [edi],bl
        inc     di
        inc     bl
        jz      ev_entry_loop_done
        jmp     set_dbcs
next_ev_entry:
        add     esi,2
        jmp     ev_entry_loop
clean_up:
        mov     cx,CB_DBCS_MAP_TBL
        sub     cx,bx
        rep     stosb

ev_entry_loop_done:
        or      fsNls,NLSCA_MAP_DBCS
        mov     ebx,npCpMapFree
        add     ebx,lpCpMapList             ; EBX --> table to be copied
        mov     lpCpMapTbl,ebx
        add     npCpMapFree,size CpMapTable

; We have now all of code-point mapping tables.
; Return the table address and NLS support codepage info flags.

ccpv_have_all_tables:
        mov     ecx,fsNls
        mov     eax,lpCpMapTbl
        jmp     ccpv_exit


ccpv_insufficient_memory:
        mov     eax,PMERR_INSUFFICIENT_MEMORY
        save_error_code
ccpv_error:
        xor     eax,eax                 ; error. no vector
ccpv_exit:
        ret
DbcsCreateCodePageVectors ENDP

page

;---------------------------Public-Routine------------------------------;
; DbcsInitCodePageVectors
;
;   Intialize the list of code-point mapping tables.
;   This entry should be called under the shell context (one_time_init).
;
; Entry:
;       none
; Returns:
;       EAX = 0
; Error Returns:
;       EAX = -1
; Registers Destroyed:
;       EAX,EBX,ECX,EDX,FLAGS
; Registers Preserved:
;       ESI,EDI,EBP
; Calls:
; History:
;   24-Nov-90 by Soh Ohta [jl09057 @ ymtvm3]
;   Created.
;-----------------------------------------------------------------------;

DbcsInitCodePageVectors PROC SYSCALL uses ESI EDI EBX

        cld

; Allocate 64KB for codepage vector cache buffer.

        INVOKE  SSAllocMem,
                ADDR lpCpMapList,
                010000h,
                fALLOC
        cmp     eax,NO_ERROR            ; Allocated?
        jnz     icpv_error

        mov     ebx,(size CpMapEntry)+(size CpMapTable)
        mov     eax,10000h              ; EAX = 64KB
        xor     edx,edx
        div     ebx
        mov     maxCpMapList,eax        ; max number of codepages in the list
        imul    eax,eax,size CpMapEntry
        mov     npCpMapFree,eax         ; mapping vector base address

; Clear allocated codepage vector cache buffer.

        mov     edi,lpCpMapList
        mov     ecx,maxCpMapList
        xor     eax,eax

init_CpMap_entry:
        mov     [edi].cme_idCodePage,eax
        mov     [edi].cme_fsNls,eax
        mov     [edi].cme_lpCpMapTbl,eax
        add     edi,size CpMapEntry
        loop    init_CpMap_entry
        jmp     icpv_exit         ; success (EAX=0)

icpv_error:
        mov     eax,-1
icpv_exit:
        ret
DbcsInitCodePageVectors ENDP

end
