;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = CELLCP.ASM
;*
;* DESCRIPTIVE NAME =  Code for managing code pages and their mapping vectors.  
;*
;*
;* VERSION      V2.0
;*
;* DATE         01/26/87
;*
;* DESCRIPTION  The code in this file takes care of coercing code page  
;*              ids to usable values and constructing mapping vectors        
;*              for converting code points to glyph points.                  
;*
;* FUNCTIONS    Force_Valip_CP
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   01/26/87                     Written by Ron Murray
;*   xx/xx/92                     SEL - This file sucks. The original file was
;*                                completely brain dead. I hope to come back later
;*                                and fix this whole codepage mess.
;*
;*
;*****************************************************************************/
        .386
        .MODEL FLAT,SYSCALL
        ASSUME  SS:FLAT, DS:FLAT, CS:FLAT, ES:FLAT

        .xlist
INCL_GRE_FONTS  equ    1
        include        pmgre.inc
DINCL_ENABLE            equ     1
DINCL_BITMAP            equ     1
        include driver.inc
        include protos.inc
        include extern.inc
ifdef DBCS ; DBCS codepage support     ;IBMJ
        include cellblt.inc
endif;DBCS        ;IBMJ
        .list
page
.CODE
;/***************************************************************************
;*
;* FUNCTION NAME = Force_Valid_CP
;*
;* DESCRIPTION   =  This routine attempts to coerce the code page variable denoted 
;*                  by *pcpid to a usable code page.  In this context a code page 
;*                  is usable if we can retrieve its mapping vector via Get_CP_Map.
;*                  If the given code page is unusable, we substitute the default 
;*                  code page, which will always be the last code page in the chain
;*                  of mapping vectors. The explicit result will be 1 if no 
;*                  usable code page can be found and zero otherwise.  When 
;*                  the coercion succeeds, *pmapcp will be set to the VioSegData 
;*                  relative address of the corresponding mapping vector.
;*                 
;*
;* INPUT         =  pcpid - pointer to codepage to try to validate  
;* OUTPUT        =  pmapcp - codepoint mapping for *pcpid  
;*
;* RETURN-NORMAL =  NONE
;* RETURN-ERROR  =  NONE
;*
;**************************************************************************/

ALIGN 4
Force_Valid_CP  PROC SYSCALL USES ebx esi,
        pcpid   :DWORD,
        pmapcp  :DWORD

ifndef DBCS ; DBCS codepage support     ;IBMJ
        mov        ebx,pcpid

        INVOKE  Gre32Entry3,            ; This was Get_CP_Map
                [ebx],
                0,                      ; Null HDDC
                NGreQueryCodePageVector

        or        eax,eax
        jnz        found_cp_map

        INVOKE  Gre32Entry3,            ; This was Get_CP_Map
                default_vio_cpid,       ; set to the default
                0,                      ; Null HDDC
                NGreQueryCodePageVector

        or        eax,eax
        jnz        found_cp_map

else ;DBCS  ; DBCS codepage support     ;IBMJ

 mov eax,[ebx]  ; This was Get_CP_Map
 mov esi,eax
 INVOKE DbcsQueryCodePageVectors

 or eax,eax
 jnz dbcs_found_cp_map

 mov eax,default_vio_cpid ; set to the default
 mov esi,eax
 INVOKE DbcsQueryCodePageVectors

 or eax,eax
 jnz dbcs_found_cp_map

default_sbcs_cp:
endif;DBCS        ;IBMJ

        INVOKE  Gre32Entry3,            ; This was Get_CP_Map
                437,                    ; if all else fails maybe this wont
                0,                      ; Null HDDC
                NGreQueryCodePageVector

        or        eax,eax
        jnz        found_cp_map

        INVOKE  Gre32Entry3,            ; This was Get_CP_Map
                850,                    ; if all else fails maybe this wont
                0,                      ; Null HDDC
                NGreQueryCodePageVector

        ; Just fail but return ok

found_cp_map:
ifdef DBCS ; DBCS codepage support     ;IBMJ
 mov CellBLTBlock.cb_fsNls,ecx
endif;DBCS        ;IBMJ

        mov        ebx,pmapcp
        mov        [ebx],eax
        mov        eax,0

exit_Force_Valid_CP:
        ret

ifdef DBCS ; DBCS codepage support     ;IBMJ
dbcs_found_cp_map:
 cmp eax,-1
 jne found_cp_map

        INVOKE  Gre32Entry3,            ; This was Get_CP_Map
                esi,                    ; if all else fails maybe this wont
                0,                      ; Null HDDC
                NGreQueryCodePageVector
 mov ecx,NLSCA_SBCS

 or eax,eax
 jnz found_cp_map
 jmp default_sbcs_cp
endif;DBCS        ;IBMJ

Force_Valid_CP  ENDP
end
