;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = CURSTRC.INC
;*
;* DESCRIPTIVE NAME = Cursor related structures
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION  Cursor related structures
;*
;*
;* FUNCTIONS    NONE
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   02/04/93              55847  Save GRAF_ADDR index in save_hw_regs and
;*                                restore in restore_hw_regs ( this also
;*                                requires a fix in VVID, being made under
;*                                seperate defect # ).
;*   04/13/93              63750  Avoid video corruption on GDC Misc restore
;*
;*****************************************************************************/

;/*
;** Equates
;*/

PD_CLIP_BOTTOM EQU 10000000b
PD_CLIP_TOP    EQU 01000000b
PD_CLIP_RIGHT  EQU 00100000b
PD_CLIP_LEFT   EQU 00010000b
PD_VALID       EQU 00001000b




PD_CLIPPED EQU PD_CLIP_BOTTOM OR PD_CLIP_TOP OR PD_CLIP_RIGHT OR PD_CLIP_LEFT

PTRI_ANIMATE EQU 2      ; Indicates pointer is animated.

FBPTR_COLOR EQU 00000001b
FB_OLD_PTR   EQU 10000000b
FB_NEW_PTR   EQU 01000000b
FB_FLUSH_X   EQU 00100000b
FB_FLUSH_Y   EQU 00010000b
FB_OVERLAP   EQU 00001000b
FB_READ_X    EQU 00000100b
FB_READ_Y    EQU 00000010b
FB_WORK_RECT EQU 00000001b

;/*
;** Structures
;*/
;/*
;** POINTB is used for points with a range of -128..+127.
;*/

POINTB  STRUC
   ptb_x db     0
   ptb_y db     0
POINTB  ENDS

;/*
;** SIZEB is used for extents with a range of -128..+127.
;*/

SIZEB   STRUC
   sizb_cx db   0
   sizb_cy db   0
SIZEB   ENDS

;/*
;** SIZES is used for extents with a range of +/- 32K.
;*/

SIZES   STRUC
   sizs_cx dw   0
   sizs_cy dw   0
SIZES   ENDS


;/*
;** POINTB is used for points with a range of -128..+127.
;*/

POINTB  STRUCT
   ptb_x BYTE 0
   ptb_y BYTE 0
POINTB  ENDS

        .ERRNZ  sizeof POINTB AND 1

;/*
;** The RECT_DATA structure is used for describing the rectangles which will
;** be manipulated by this code.  The fields are:
;**
;** ptbSave     This is the (X,Y) origin of the given rectangle in the save
;**                area.
;**
;** ptlScreen   This is the (X,Y) origin of the given rectangle on the screen.
;**
;** sizb        This is the extents of the rectangle.
;**
;** ptbWork     This is the (X,Y) origin of the given rectangle in the work
;**                area.
;*/

RECT_DATA STRUCT 1
   ptbSave   POINTB <0,0>
   ptlScreen POINTL <0,0>
   sizb      SIZEB  <0,0>
   ptbWork   POINTB <0,0>
RECT_DATA ENDS

        .ERRNZ  sizeof RECT_DATA AND 1

;/*
;** The POINTER_DATA structure is used for describing the actual pointer's
;** rectangle.  It also contains clipping information and control flags.  The
;** fields are:
;**
;** rd               RECT_DATA structure as defined above
;**
;** fb            Flags as follows:
;**
;** PD_VALID         1 The rectangle contains valid data.
;**                  0 The rectangle data is invalid.
;**
;** PD_CLIP_BOTTOM   1 Clip the bottom
;**                  0 No bottom clipping needed
;**
;** PD_CLIP_TOP      1 Clip the top
;**                  0 No top clipping needed
;**
;** PD_CLIP_LEFT     1 Clip the lhs
;**                  0 No lhs clipping needed
;**
;** PD_CLIP_RIGHT    1 Clip the rhs
;**                  0 No rhs clipping needed
;*/

POINTER_DATA STRUCT 1
   rd   RECT_DATA <>
   fb   BYTE      0
        BYTE      0
POINTER_DATA ENDS

CURSORSTRUCT STRUCT 4


;/*
;** cxPointer is the width of the pointer in bits.  The size must be a correct
;** multiple for the PTR_ROUND_* values given above (e.g. if rounding to byte
;** boundaries, then this must be a multiple of 8.
;**
;** cyPointer is the height of the pointer in scans.
;**
;** These values are returned from the move_pointers routine.
;*/

cxPointer DWORD PTR_WIDTH_BITS
cyPointer DWORD PTR_HEIGHT

;/*
;** (cxCell,cyCell) is the location of the pointer on the screen.  These
;** locations are only updated whenever a pointer is drawn.
;**
;** (cxReal,cyReal) is the location of the pointer as specified by the user.
;** These locations are always kept current.
;**
;** These cells may not be the same if the pointer drawing takes a lot of time
;** and the mouse is moving quickly.  Therefore, after a pointer has been
;** drawn, a check must be made to see if the pointer has moved, and if so,
;** the pointer must be drawn again.
;*/

cxCell  DWORD   INIT_POINTER_X                   ; X cell of last drawn pointer
cyCell  DWORD   INIT_POINTER_Y                   ; Y cell of last drawn pointer
cxReal  DWORD   INIT_POINTER_X                   ; Real x location of pointer
cyReal  DWORD   INIT_POINTER_Y                   ; Real x location of pointer

;/*
;** cxHot and cyHot contain the hot spot adjustment for the pointer.
;**
;** These locations should be zeroed whenever a pointer is changing or has
;** been turned off, and should be set once a pointer has been defined.  When
;** the pointer is turned off, the hot spot adjustment should be added back to
;** the real pointer coordinates (cxReal, cyReal).  When a pointer is set,
;** they should be subtracted off.  This will keep the pointer based at the
;** hot spot during a change instead of the upper left corner.
;*/

cxHot   DWORD   0       ;X hot spot adjustment
cyHot   DWORD   0       ;Y hot spot adjustment

;/*
;** The following structure contains the bounding rectangle wherein the
;** pointer is not allowed to be displayed.  The values for left and right
;** will always be rounded to contain the entire byte (or word or dword if
;** working to those boundaries).
;**
;** These values will only be valid if exclude_count is non-zero.
;**
;** NOTE: Only one rectangle at a time may be set.
;*/

ExcludeRect RECTL <0,0,0,0>

fwPrevFlags WORD  0

ExcludeCt   BYTE  RECT_NOT_PRES ; Set non-zero if rectangle is valid

;/*
;**       screen_busy is a flag used for critical section code to
;**       indicate that the screen is busy.  Since pointer operations
;**       take a very long time (e.g. drawing a pointer), the screen_busy
;**       flag is set to 0 to show that the screen is busy, and then
;**       interrupts are enabled to allow other interrupts.  The basic
;**       operation for the semephore is:
;**
;**               xor     cx,cx
;**               xchg    screen_busy,cx
;**               jecxz   operation_in_progress
;*/

screen_busy             BYTE                     NOT_BUSY ;Show screen not busy

;/*
;** fbPtrFlags contains control flags indicating the pointer status.  Flags
;** are defined for the pointer being off, and the pointer being excluded.
;*/

fbPtrFlags BYTE PTR_OFF ;Pointer status, initially hidden


;/*
;** Start of structures for pointer.asm
;*/


rdFlushX  RECT_DATA    <>       ; Flush from save area to screen
rdFlushY  RECT_DATA    <>       ; Flush from save area to screen
rdOverlap RECT_DATA    <>       ; AND from save area to work area
rdReadX   RECT_DATA    <>       ; Read from screen to save, XOR to work
rdReadY   RECT_DATA    <>       ; Read from screen to save, XOR to work
rdWork    RECT_DATA    <>       ; XOR from work to screen

if SCAN_CNT EQ 768

;/*
;** The following structures are used when the cursor
;** spans the bank boundaries.
;*/

rdBank0         RECT_DATA <>
rdBank1         RECT_DATA <>
rdWorkBank0     RECT_DATA <>
rdWorkBank1     RECT_DATA <>

;/*
;** Following are memory variables used to do call_through's.
;** The right hand edge needs special handling of the inner loop.
;** A separate routine is used for the right hand edge.
;**
;*/

pfnXorToScreen DWORD  INVALID_ADDRESS

;/*
;** Right hand side bit vector array .
;** The overhang is 0 relative.  When a column of the pointer reaches the
;** the screen width then that column and all columns to the right of it
;** will overhang.  The overhang will never exceed the width of the pointer.
;*/

abRhsOverhang BYTE  00011111b, 00011110b, 00011100b, 00011000b, 00010000b, 00000000b

;/*
;** Left hand side bit vector array and scalar.
;** The overhang is 0 relative.  When a column of the pointer reaches the
;** the screen width then that column and all columns to the right of it
;** will overhang.  The overhang will never exceed the width of the pointer.
;*/

abLhsOverhang BYTE  00011111b, 00001111b, 00000111b, 00000011b, 00000001b, 00000000b
bRLhsOverhang BYTE  00000000b


endif
;/*
;** ptlBotRightClip is the coordinate where rhs or bottom clipping will first
;** occur.  It is basically the screen width - pointer width.
;*/

ptlBotRightClip POINTL <SCREEN_CBSCAN-WORK_WIDTH,SCREEN_CY-WORK_HEIGHT>

;/*
;** ppdOld is the pointer to the old pointer's POINTER_DATA structure.
;*/

;/*
;** ppdNew is the pointer to the new pointer's POINTER_DATA structure.
;*/

;/*
;** These are used as indices now
;*/

ppdOld  DWORD   0
ppdNew  DWORD   SIZEOF POINTER_DATA

;/*
;** pAndXor is the pointer to which AND/XOR mask is to be used.  It is based
;** on the 3 least significant bits of the pointer's X coordinate.  pColor is
;** the pointer to which COLOR mask is to be used.
;*/

pAndXor DWORD   INVALID_ADDRESS
pColor  DWORD   INVALID_ADDRESS

;/*
;** The following are the masks which make up the pointer image.  There will
;** be one AND/XOR/COLOR mask trio for each possible alignment.  On
;** move_pointers call, all the alignments will be generated to save time
;** processing the interrupt.
;*/

BaseAndMasks   BYTE (MASK_LENGTH * 8)     dup (?)
BaseXorMasks   BYTE (MASK_LENGTH * 8)     dup (?)
        .ERRNZ  CURSORSTRUCT.BaseXorMasks-CURSORSTRUCT.BaseAndMasks-(MASK_LENGTH*8)
BaseColorMasks BYTE (CLR_MASK_LENGTH * 8) dup (?)

;/*
;** pabAndMasks is an array which points to the start of the mask for each X
;** rotation.  It is indexed into using the low 3 bits of the pointer's X
;** coordinate.
;**
;** Distance from start of BaseAndMasks
;*/

pabAndMasks  DWORD (0*MASK_LENGTH)
        bxyz DWORD (1*MASK_LENGTH)
        cxyz DWORD (2*MASK_LENGTH)
        dxyz DWORD (3*MASK_LENGTH)
        exyz DWORD (4*MASK_LENGTH)
        fxyz DWORD (5*MASK_LENGTH)
        gxyz DWORD (6*MASK_LENGTH)
        hxyz DWORD (7*MASK_LENGTH)
;/*
;** pabClrMasks is an array which points to the start of the mask for each X
;** rotation.  It is indexed into using the low 3 bits of the pointer's X
;** coordinate.
;**
;** Distance from start of BaseColorMasks
;/*

pabClrMasks  DWORD (0*CLR_MASK_LENGTH)
        ixyz DWORD (1*CLR_MASK_LENGTH)
        jxyz DWORD (2*CLR_MASK_LENGTH)
        kxyz DWORD (3*CLR_MASK_LENGTH)
        lxyz DWORD (4*CLR_MASK_LENGTH)
        mxyz DWORD (5*CLR_MASK_LENGTH)
        nxyz DWORD (6*CLR_MASK_LENGTH)
        oxyz DWORD (7*CLR_MASK_LENGTH)

;/*
;** siz?Mask contains the width and height of the working portion of the
;** current AND and XOR mask.  Use of this allows us to manipulate less memory
;** when parts of the pointer won't alter the screen image.
;*/

sizsMask SIZES  <WORK_WIDTH,PTR_HEIGHT>
sizbMask SIZEB  <WORK_WIDTH,PTR_HEIGHT>

;/*
;** sizsMaxDelta is the maximum distance the old and new pointers may be
;** before they are considered disjoint.
;*/

sizsMaxDelta SIZES <WORK_WIDTH,WORK_HEIGHT>

;/*
;** This is the initial origin in the save buffer (in WORDs.
;*/


ptbInitOrigin POINTB <0,0>

;/*
;** These are used as indices now
;*/

pdPtr0    POINTER_DATA <>       ; Old/New pointer's data
pdPtr1    POINTER_DATA <>       ; Old/New pointer's data


;/*
;** The following flags and flag bytes are used to control which rectangles
;** are used for what.
;**
;** fbFlush controls which rectangles are to be copied from the save area to
;** the screen.  Valid flags are:
;**
;**   FB_OLD_PTR, FB_FLUSH_X, FB_FLUSH_Y
;**
;**   FB_OLD_PTR is mutually exclusive of all other flags
;**
;** fbAndRead controls which rectangles are to be ANDed into the work area
;** from the screen or save area, and which rectangles are to be copied from
;** the screen to the save area.  Valid flags are:
;**
;**   FB_NEW_PTR, FB_OVERLAP, FB_READ_X, FB_READ_Y, FB_WORK_RECT,
;**
;**   FB_NEW_PTR and FB_WORK_RECT are mutually exclusive of all other flags.
;**   Note that FB_OVERLAP doesn't apply when coping into the save area.
;**
;** fbXor describes which rectangle is to be XORed from the work area into the
;** screen.  Valid flags are:
;**
;**   FB_NEW_PTR, FB_WORK_RECT
;**
;**   FB_NEW_PTR and FB_WORK_RECT are mutually exclusive
;*/

fbFlush   BYTE  0
fbAndRead BYTE  0
fbXor     BYTE  0


;/*
;** fbPointer tells us if the pointer is color.
;*/

fbPointer BYTE  0
SaveESI         DWORD 0
selScreenPtr    DWORD INVALID_ADDRESS
pVRAMRing0      DWORD INVALID_ADDRESS

vga_header           db     0EEH          ; to find this easily
vga_grf_indx         db     ?             ;             55847
vga_seq_indx         db     ?             ;           
vga_seq_map_mask     db     ?
vga_grf_set          db     ?
vga_grf_enable_set   db     ?
vga_grf_color_cmp    db     ?
vga_grf_rotate       db     ?
vga_grf_read_map     db     ?
vga_grf_mode         db     ?
vga_grf_misc         db     ?
vga_grf_color        db     ?
vga_grf_bitmask      db     ?
vga_svgatype         dw     0             ;           


CURSORSTRUCT ENDS

PCURSORSTRUCT typedef PTR CURSORSTRUCT

