;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE     55,132
        TITLE    
        SUBTITLE Header
;/*****************************************************************************
;*
;* SOURCE FILE NAME = CMPLCODE.ASM
;*
;* DESCRIPTIVE NAME = Contains the definition of the compile code data segment.
;*
;*
;* VERSION      V2.0
;*
;* DATE         03/23/87
;*
;* DESCRIPTION  The driver has the need to maintain per process information    
;*              such as a Screen Selector, CS Alias, and a shared segment      
;*              where bitblt can compile code into and execute from.  Other    
;*              information, as determined may also be needed on a per process 
;*              basis.                                                         
;*              
;*              This file and CMPLCODE.INC must be kept synchronized! 
;*              
;* FUNCTIONS    NONE
;*              
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   03/23/87                     Written by Walt Moore
;*   08/14/90                     Viroon Touranachun [viroont] Switched from
;*                                Instance Data Segment to Compile Code segment.
;*
;*****************************************************************************/

        .386
        .MODEL FLAT,SYSCALL
        ASSUME  SS:FLAT, DS:FLAT, CS:FLAT, ES:FLAT

        .xlist
INCL_DEV        equ     1
        include pmgre.inc
DINCL_VIO       equ     1
        include driver.inc
        .list

        public  asDDARun
        public  asPlaneBuff
        public  proc_stack_area

;/*
;**       INITIAL_STACK_SIZE is the amount of space required as long as
;**       we're not compiling onto the stack.
;*/

;/*
;**       CBLT_STACK_SIZE is the amount of space required for the largest
;**       generated bitblt, plus any working stack space
;*/


INITIAL_STACK_SIZE      equ                      1024
.DATA

;/*
;**       asDDARun is a static array of word-size number that records the
;**       horizontal DDA runlength when a stretch/compressBlt is performed
;**       in the display driver level
;*/

SCREEN_WIDTH    EQU     1024

asDDARun        DWORD      SCREEN_WIDTH    dup (?)

;/*
;**       asPlaneBuff is three array of bytes to record the plane 1,2 and 3
;**       of the stretched/compressed bitmap. This is required for EGA/VGA
;**       drivers only.
;**
;*/

asPlaneBuff     dw      SCREEN_WIDTH/8*3    dup (?); 3*screen width (in bytes)

;/*
;**       proc_stack_area is where bitblt will compile it's code into.
;**       The area must be big enough for the largest generated bitblt,
;**       plus all frame variables.  Room must also be left for the
;**       return address and any pushes which may occur.
;**
;*/

align 4
proc_stack_area dd      INITIAL_STACK_SIZE dup (?)

end
