;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE     55,132
        TITLE    BitBlt2
        SUBTITLE Header
;/*****************************************************************************
;*
;* SOURCE FILE NAME = BITBLT2.ASM
;*
;* DESCRIPTIVE NAME = BitBLT at level of device driver.   
;*
;*
;* VERSION      V2.0
;*
;* DATE         
;*
;* DESCRIPTION  
;*
;*       This is the main module of those comprising the source to BitBLT
;*       (Bit BLock Transfer) for display drivers. It
;*       defines the procedure, and performs general preprocessing for all BLT
;*       requests.
;*      
;*       BitBLT  transfers a rectangle of bits from source to destination,
;*       doing some useful operations on the way, namely:
;*      
;*       o     excluding the cursor;
;*      
;*       o     performing a user-specified raster operation, out of
;*             a vast array of choices, which takes the form
;*      
;*             D = f(S,D,P)
;*      
;*             where S = source bit, D = destination bit, P = pattern
;*             bit, and  f  is a sequence of logical operations (AND, OR,
;*             XOR, NOT) on S, D, and P;
;*                     
;*       o     recognizing common special cases for accelerated processing.
;*      
;*       For a detailed explanation of the contortions BitBLT goes through
;*       to put your bits in place, see the file COMMENT.BLT.
;*      
;*      
;*       BitBLT consists of the following files:
;*      
;*             BITBLT.ASM        procedure definition
;*             CBLT.ASM          procedure to compile arbitrary BLT on stack
;*      
;*             FRAME.BLT         function parameters and locals
;*             CONSTANT.BLT      constants
;*             DATADEFS.BLT      compiled code templates and data
;*             ROPTABLE.BLT      table of ROP templates and definitions
;*             SURFACE.BLT       Surface processing
;*             PATTERN.BLT       pattern preprocessing
;*      
;*             COMPUTEY.BLT      compute y-related values
;*             EXIT.BLT          device-specific cleanup before exiting
;*      
;*             SPECIAL.BLT       special case code
;*             COMMENT.BLT       overview of history and design
;*              
;*
;* FUNCTIONS   OemBitblt 
;*             phase_processing 
;*             far_do_cblt 
;*
;* NOTES       NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   08/27/90                     Viroon Touranachun [viroont] Subroutinized
;*                                phase_processing from OEMBitBlt
;*
;*****************************************************************************/

        .386
        .MODEL FLAT,SYSCALL
        ASSUME  SS:FLAT, DS:FLAT, CS:FLAT, ES:FLAT

        .errnz  BITS_PEL - 4                      ;Some uses of BITS_PEL expect it
                                                  ;  to be 4  -- should clean up
        .xlist
        include pmgre.inc
DINCL_BB_ROPS   equ     1
DINCL_BITMAP    equ     1
DINCL_ENABLE    equ     1
        include driver.inc
        include extern.inc
        include protos.inc
        include egafam.inc
        include oemblt.inc
        include assert.mac
        .list

        include constant.blt
.list

;/*
;** This is the BitBlt entry point.
;** Therefore we DO need to generate a stack frame
;*/

far_do_cblt PROTO SYSCALL,
 pddcDst  :DWORD, ;Destination ddc
 xDst     :DWORD, ;Destination x origin
 yDst     :DWORD, ;Destination y origin
 psdSrc   :DWORD, ;Source surface definition
 xSrc     :DWORD, ;Source x origin
 ySrc     :DWORD, ;Source y origin
 cxExt    :DWORD, ;x extent of the BLT
 cyExt    :DWORD, ;y extent of the BLT
 usMix    :DWORD, ;Mix mode
 ipcBkgnd :DWORD, ;Color to mono background match color
 fsBlt    :DWORD

.CODE

OPTION PROLOGUE:NONE
OPTION EPILOGUE:NONE

;/*
;**       Subroutines.  These have been included with the aim of
;**       segregating device dependent code from independent code,
;**       while cleanly preserving the local variable frame.
;*/
ifdef IBMJ        ;IBMJ
        include special.blt                       ;non-compiled blt subroutines
endif;IBMJ        ;IBMJ

end
