;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = @(#)xgasubep.inc        6.1 91/04/26

; ****************************************************************************
; *                                                                          *
; *                                                                          *
; *                                                                          *
; ****************************************************************************

;********************** START OF SPECIFICATIONS ****************************
;*                                                                         *
;* SOURCE FILE NAME:    XGASUBEP.INC                                       *
;*                                                                         *
;* DESCRIPTIVE NAME:    BUFFERUPDATE subroutine for DBCS Codepage          *
;*                                                                         *
;* COPYRIGHT:   na                                                         *
;*                                                                         *
;* STATUS:      OS/2 version 2.0                                           *
;*                                                                         *
;* CHANGE HISTORY:                                                         *
;*                                                                         *
;* NOTES:       Ring 2 conforming code segment                             *
;*                                                                         *
;*    DEPENDENCIES:     None                                               *
;*                                                                         *
;*    RESTRICTIONS:     None                                               *
;*                                                                         *
;*    PATH LABEL:       na                                                 *
;*                                                                         *
;* ENTRY POINTS:                                                           *
;*                                                                         *
;*                                                                         *
;* EXTERNAL REFERENCES: included XGASUBAX.ASM                              *
;*                                                                         *
;********************** END OF SPECIFICATIONS ******************************

Erase1e macro
        local   er1x_end

        cmp     di,0                    ; first cell ?
        jbe     er1x_end                ; exit if yes

        test    byte ptr es:[di+1],epochDBCSTrail
        jz      er1x_end                ; exit if not

        mov     byte ptr es:[di-2],CharBlank ; copy blank into this cell
        and     byte ptr es:[di-1],NOT epochDBCSLead+epochDBCSTrail; and clear
                                                                   ; trailbyte bit
        or      [bp].j_dbcsstatus,BisectDBCS_START

er1x_end:
        endm

Erase2e macro
        local   er2x_end

        cmp     di,[bp].j_lvbsize       ; outside LVB
        jae     er2x_end                ; skip if yes

        test    byte ptr es:[di+1],epochDBCSTrail
        jz      er2x_end                ; skip if not

        mov     byte ptr es:[di],CharBlank   ; copy blank into this cell
        and     byte ptr es:[di+1],NOT epochDBCSLead+epochDBCSTrail; and clear
                                                                   ; trailbyte bit
        or      [bp].j_dbcsstatus,BisectDBCS_LAST

er2x_end:
        endm

Erase5e macro
        local   er5x_end

        push    ds                      ; save source selector
        mov     ds,[bp].j_dbcslvbsel    ; use DBCS flag LVB

        test    byte ptr ds:[si+1],TrailByteFlag ; CF = 0
        jz      er5x_end                ; exit if not

        mov     al,CharBlank            ; AL = blank
        stc                             ; CF set if was trailing byte

er5x_end:
        pop     ds                      ; restore source selector
        endm

Erase6e macro
        local   er6x_end

        push    ds                      ; save source selector
        mov     ds,[bp].j_dbcslvbsel    ; use DBCS flag LVB

        test    byte ptr ds:[si+1],DBCSFlag     ; CF = 0
        jz      er6x_end                ; exit if not DBCS

        test    byte ptr ds:[si+1],TrailByteFlag
        jnz     er6x_end                ; exit if trail byte

        mov     al,CharBlank            ; AL = blank
        stc                             ; CF set if was lead byte

er6x_end:
        pop     ds                      ; restore source selector
        endm

;  SetSystemByteE
;
;       maintain the DBCS and trail byte flags in the system byte.
;       arguments are used to obtain the system byte to be modified.
;
;
;       INPUT
;               AL  -  Character to be Tested for lead byte range
;               DH  -  Previous Character first byte of DBCS status
;                      (return value of previous macro invocation)
;       USES
;               DX  -  to maintain the Lead/TrailByte State information
;
;       RETURNS
;               AX  -  [copied 2nd attribute (AL) and] New SystemByte (AH)
;               DH  -  1 if character first byte of DBCS
;
;       ALGORITHM
;
;
;           if( LeadingByte )
;               ThisIsLeadByteFlag = 1
;           if( PrevWasLeadByteFlag )
;               ThisIsLeadByteFlag = 0
;
;           <process attribute>
;
;           system byte = ThisIsLeadByteFlag
;           swap( ThisIsLeadByteFlag, PrevWasLeadByteFlag )
;           system byte |= ThisIsLeadByteFlag
;                       { which is true if PREV was lead byte }
;
;
SetSystemByteE macro  instruction

        xor     dl,dl           ; DL = 0
        push    ds
        push    si
        CheckLeadByte           ; Cy set if leading byte in AL
        pop     si
        pop     ds
        adc     dl,dl           ; DL = 1 if this was leading byte

        IFNB <instruction>
                &instruction    ; optional code to load AH (or AX)
        ENDIF
                                ; [AL = 2nd attr,] AH = system byte
        mov     ah,dl           ; set DBCS bit in system byte
        or      ah,dh           ; " " " if previous was lead_byte
        sub     dl,dh           ; dl = 0 if previous was leading byte already
        adc     dl,0
        xchg    dl,dh           ; save dl for next char, use dh now
;;      ror     dl,1            ; rotate to get tail_byte bit 0 into bit 7
        shl     dl,1            ; rotate to get tail_byte bit 0 into bit 7
        or      ah,dl           ; or TrailBYTE bit into system byte

        endm


IFDEF EPOCH
;Entry
;  ds:si - user cells pointer
;  es:di - LVB pointer
;  cx    - cell length (in byte)


UBCellToLVB1E   PROC
        public  UBCellToLVB1E

; check to see whether we are about to overwrite to a trailing byte
; and if so, erase preceding lead byte.
        Erase1e

        shr     cx,1                    ; convert bytes to number of cell
        xor     dx,dx                   ; clear DH for use as flag in loop

; write cells.
        .repeat
            mov     bx,word ptr es:[di] ; Save for restoring the previous
                                        ; cp & attr#1 for tail exception
            lodsw                       ; AL = char, AH = 1st attribute
            stosw                       ; write char and 1st attribute
            xor     ah,ah               ; ignore attr#2(including lcid),
                                        ; which means using a default
                                        ; dbcs env. vector.
            SetSystemByteE              ; AH = system byte
            and     byte ptr es:[di-1],NOT epochDBCSLead+epochDBCSTrail
            or      byte ptr es:[di-1],ah       ; store system byte
        .loop

; Check to see if the last char written was a lead byte, if so, erase
        .if     <bit dh and 1>          ; last char copied was lead byte
            mov     word ptr es:[di-2],bx ; Undo
            shl     dh,1
        .endif

; Check if next cell contains a trail byte, if so, erase
        .if     <dh ne 2>               ; When dbcs 1st has been ignored,
                                        ; forget the exception handling.
            Erase2e
        .endif

        ret
UBCellToLVB1E   ENDP


;Entry
;  ds:si - user chars pointer
;  es:di - LVB pointer
;  cx    - char length (in byte)

UBCharToLVB1E   PROC
        public  UBCharToLVB1E

; check to see whether we are about to overwrite to a trailing byte
; and if so, erase preceding lead byte.
        Erase1e

        xor     dx,dx                   ; clear DH for use as flag in loop

; write characters
        .repeat
            mov     bl,byte ptr es:[di] ; Save for restoring the previous
            lodsb                       ; copy char
            stosb
            xor     ah,ah               ; ignore attr#2(including lcid),
                                        ; which means using a default
                                        ; dbcs env. vector.
            SetSystemByteE              ; AH = system byte
;;          mov     byte ptr es:[di],ah ; store system byte                     ;;KY01D
            and     byte ptr es:[di],NOT epochDBCSLead+epochDBCSTrail           ;;KY01A
            or      byte ptr es:[di],ah ; store system byte                     ;;KY01A
            inc     di                  ; skip 1st attribute
        .loop

; Check to see if the last char written was a lead byte, if so, erase
        .if     <bit dh and 1>          ; last char copied was lead byte
            mov     byte ptr es:[di-2],bl ; undo ; restore the prev. cp.
            shl     dh,1
        .endif

; Check if next cell contains a trail byte, if so, erase
        .if     <dh ne 2>               ; When dbcs 1st has been ignored,
                                        ; forget the exception handling.
            Erase2e
        .endif

        ret
UBCharToLVB1E   ENDP


;Entry
;  ah    - 1st attribute
;  dl    - 2nd attribute (if WorldFormat)
;  dh    - system byte   (if WorldFormat)
;  ds:si - user chars pointer
;  es:di - LVB pointer
;  cx    - char length (in byte)

UBCharAttToLVB1E PROC
        public  UBCharAttToLVB1E

; check to see whether we are about to overwrite to a trailing byte
; and if so, erase preceding lead byte.

        Erase1e
        ;25Sep91 +
        test    [bp].shadow_Flags,CGAAttr ; CGA Translation
        .if <nz>
            push    ax
            xchg    ah,al
            mov     ah,dl
            ;06Nov91 +
            mov     ax,[bp].shadowAttribute ; Get ANSI's attributes
            ;06Nov91 -
            Call    Translate           ; Common AX -> Epoch AL
            mov     bl,al               ; BL = 1st attribute
            pop     ax
        .else
            mov     bl,ah                   ; BL = 1st attribute
        .endif
        ;25Sep91 -

        xor     dx,dx                   ; clear DH for use as flag in loop

; write characters and attributes
        .repeat
            mov     ax,word ptr es:[di] ; save cp+attr in lvb for retrieve
            mov     word ptr [bp].wSaveCpAttr1,ax
            lodsb                       ; char = AL
            mov     ah,bl               ; AH = first attribute
            stosw                       ; write char and 1st attribute
            xor     ah,ah               ; ignore attr#2(including lcid),
                                        ; which means using a default
                                        ; dbcs env. vector.
            SetSystemByteE              ; AH = system byte
            ;js01542 jc20 +
            and     byte ptr es:[di-1],NOT epochDBCSLead+epochDBCSTrail
            ;js01542 jc20 -
            or      byte ptr es:[di-1],ah       ; store system byte
        .loop

; Check to see if the last char written was a lead byte, if so, erase
        .if     <bit dh and 1>          ; last char copied was lead byte

            .if     <bit <word ptr [bp].shadow_Flags> and CGAAttr>
                mov     byte ptr es:[di-2],CharBlank
                                            ; write a blank at
                                            ; the last character

                and     byte ptr es:[di-1],NOT epochDBCSLead+epochDBCSTrail
                                            ; clear system byte
            .else
                mov     ax,word ptr [bp].wSaveCpAttr1    ; retrieve
                mov     word ptr es:[di-2],ax
                shl     dh,1
            .endif
        .endif

; Check if next cell contains a trail byte, if so, erase
        .if     <dh ne 2>               ; When dbcs 1st has been ignored,
                                        ; forget the exception handling.
            Erase2e
        .endif

        ret
UBCharAttToLVB1E ENDP


;Entry
;  al    - leading character or SBCS character
;  ah    - trailing character
;  es:di - LVB pointer
;  cx    - char count

UBNCharToLVB1E  PROC
        public  UBNCharToLVB1E

; check to see whether we are about to overwrite to a trailing byte
; and if so, erase preceding lead byte.
        Erase1e

        xor     dx,dx                   ; clear DX (system byte)

; branch by DBCS character or SBCS character
        push    ax                      ; keep ah(trailing byte)
        xor     ah,ah                   ; can ignore lcid because of
                                        ; char code only
        push    ds
        push    si
        lds     si,[bp].lpNLSExt
        CheckLeadByte                   ; is it leading byte?
        pop     si
        pop     ds
        pop     ax

; write DBCS characters
        .if     <c>                     ; yes
            mov     dl,epochDBCSLead         ; system byte
            mov     dh,epochDBCSTrail OR epochDBCSLead
;07Oct91    push    ds                  ; save source selector
;07Oct91    mov     ds,[bp].j_dbcslvbsel; use DBCS flag LVB
            shr     cx,1                ; CX = a pair of lead and trail byte
            pushf                       ; save frag whether DBCS bisect
            jcxz    @F                  ; 1990-08-02 updated
                                        ;     fix for starting from max point
            .repeat
                stosb                           ; copy leading character
;07Oct91        mov     byte ptr ds:[di],dl     ; store leading system byte
                mov     byte ptr es:[di],dl     ; store leading system byte ;07Oct91
                inc     di
                xchg    ah,al                   ; flip lead/trail char
                stosb                           ; copy trailing character
;07Oct91        mov     byte ptr ds:[di],dh     ; store trailing system byte
                mov     byte ptr es:[di],dh     ; store trailing system byte;07Oct91
                inc     di
                xchg    ah,al                   ; flip lead/trail char
            .loop

; if the char count cause DBCS bisecting, store blank character
@@:                                     ; 1990-08-02 updated
                                        ;     fix for starting from max point
            popf                        ; restore frag whether DBCS bisect
            .if     <c>                 ; last char is pointed to lead byte
                mov     al,CharBlank    ; last character is blank
                stosb                   ; copy blank character
;07Oct91        and     byte ptr ds:[di],NOT epochDBCSLead+epochDBCSTrail
                and     byte ptr es:[di],NOT epochDBCSLead+epochDBCSTrail   ;07Oct91
                inc     di
            .endif
;07Oct91    pop     ds                  ; restore source selector

; write SBCS characters
        .else short                     ; no
;07Oct91    push    ds                  ; save source selector
;07Oct91    mov     ds,[bp].j_dbcslvbsel; use DBCS flag LVB
            .repeat
                stosb                           ; copy char
;07Oct91        mov     byte ptr ds:[di],dl     ; store system byte
                mov     byte ptr es:[di],dl     ; store system byte         ;07Oct91
                inc     di
            .loop
;07Oct91    pop     ds                  ; restore source selector
        .endif

; Check if next cell contains a trail byte, if so, erase
        Erase2e

        ret
UBNCharToLVB1E  ENDP

;Entry
;  al    - 1st attribute
;  ds:si - 2nd attribute pointer
;  es:di - LVB pointer
;  cx    - attr count


UBNAttToLVB1E   PROC NEAR
        public  UBNAttToLVB1E

; write attributes
        and     al,NOT epochDBCSLead+epochDBCSTrail ;clear dbcs bits
        mov     ah,al
        .repeat
            inc     di                  ; skip character
            mov     al,byte ptr es:[di] ; get target attribute
            and     al,epochDBCSLead+epochDBCSTrail
            or      al,ah               ; merge them
            stosb                       ; copy attribute
        .loop

        ret
UBNAttToLVB1E   ENDP

;Entry
;  al    - character
;  ah    - 1st attribute
;  ds:si - Trailing byte character or 2nd attribute pointer
;  es:di - LVB pointer
;  cx    - cell count


UBNCellToLVB1E  PROC
        public  UBNCellToLVB1E

; check to see whether we are about to overwrite to a trailing byte
; and if so, erase preceding lead byte.
        Erase1e

        xor     dx,dx                   ; clear DX (system byte)

; branch by DBCS character or SBCS character
        push    ax                      ; keep ah(trailing byte)
        xor     ah,ah                   ; Don't need lcid check ;07Oct91
        push    ds
        push    si
        lds     si,[bp].lpNLSExt
        CheckLeadByte                   ; is it leading byte?
        pop     si
        pop     ds
        pop     ax

; write DBCS cells
        .if     <c>                     ; yes
            xchg    ax,bx               ; BX = Leading Byte
            mov     dl,epochDBCSLead         ; system byte
            mov     dh,epochDBCSTrail OR epochDBCSLead
            lodsw                       ; AX = Trailing Byte
            shr     cx,1                ; CX = a pair of lead and trail byte
            pushf                       ; save frag whether DBCS bisect
            jcxz    @F                  ; 1990-08-02 updated
                                        ;     fix for starting from max point
            .repeat
                xchg    ax,bx                   ; flip trail/lead byte
                stosw                           ; copy leading char and 1st attr
;@B01           mov     byte ptr es:[di-1],dl   ; store leading system byte
                and     byte ptr es:[di-1],NOT epochDBCSLead+epochDBCSTrail  ;@B01
                or      byte ptr es:[di-1],dl   ; store leading system byte  ;@B01
                xchg    ax,bx                   ; flip lead/trail byte
                stosw                           ; copy trailing char and 1st attr
;@B01           mov     byte ptr es:[di-1],dh   ; store trailing system byte
                and     byte ptr es:[di-1],NOT epochDBCSLead+epochDBCSTrail  ;@B01
                or      byte ptr es:[di-1],dh   ; store trailing system byte ;@B01
            .loop

; if the cell count cause DBCS bisecting, store attribute only.
@@:                                     ; 1990-08-02 updated
                                        ;     fix for starting from max point
            popf                        ; restore frag whether DBCS bisect
            .if     <c>                 ; last cell is pointed to lead byte
                mov     al,CharBlank    ; last character is blank
                mov     ah,bh           ; last attribute is leading it
                stosw                   ; copy char and 1st attr
                and     byte ptr es:[di-1],NOT epochDBCSLead+epochDBCSTrail   ;@A04
                                        ; store and system byte
            .endif

; write SBCS characters
        .else short                     ; no
IFDEF EPOCH
            .if     <bit <word ptr [bp].shadow_Flags> and CGAAttr>
                push    cx
                push    ax
                xor     al,al           ; Ignore character byte
                xchg    al,ah
                                        ; AL - Attr1
                Call    Translate       ; Common AX -> Epoch AL
                mov     cl,al           ; CL=AL
                pop     ax
                mov     ah,cl           ; AH=CL ( New Attr )
                pop     cx
            .endif
ENDIF
            .repeat
                stosw                           ; copy char and 1st attr
                and     byte ptr es:[di-1],NOT epochDBCSLead+epochDBCSTrail  ;@B02
                or      byte ptr es:[di-1],dh   ; store system byte ;@A01
;@A01           mov     byte ptr es:[di-1],dh   ; store system byte
            .loop
        .endif

; Check if next cell contains a trail byte, if so, erase
        Erase2e

        ret
UBNCellToLVB1E  ENDP


;Entry
;  ds:si - LVB pointer
;  es:di - user buffer pointer
;  cx    - char length (in byte)


LVBCharToUB1E   PROC
        public  LVBCharToUB1E

; Check if first cell to copy contains a trail byte, if so, erase
        mov     al,byte ptr [si]        ; AL = first character
        Erase5e                         ; replace AL by blank if trail byte
        dec     cx                      ; count down this character

        .if     <ncxz>                  ; branch if only 1 char total
            stosb                       ; store character
            add     si,2                ; skip 2 attributes
            jmp short @F                ; jump into loop to do cx-1 iterations

            .repeat
                movsb                   ; copy character
                inc     si              ; skip 1 attribute
@@:
            .loop

; Check if last cell to copy contains lead byte, if so, erase
; We check the source before copy, as then the following trail byte
; is still attached and we can use the system byte epochDBCSTrail to check.
            mov al,[si]                 ; last character
        .endif
        Erase6e                         ; replace AL by blank if lead byte
        stosb                           ; store character

        ret
LVBCharToUB1E   ENDP


;Entry
;  ds:si - LVB pointer
;  es:di - user buffer pointer
;  cx    - cell length (in byte) / 2


LVBCellToUB1E   PROC
        public  LVBCellToUB1E

; Check if first cell to copy contains a trail byte, if so, erase
        mov     ax,[si]                 ; AL = first char, AH = first attr
        Erase5e                         ; replace AL by blank if trail byte
        dec     cx                      ; count down this cell

        .if     <ncxz>                  ; branch if this only cell to copy
            stosw                       ; store character and attribute
            add     si,2                ; skip first cell
            jmp short @F                ; do cx-1 iterations

            .repeat
                movsw                   ; copy character and attribute
@@:
            .loop

; Check if last cell to copy contains lead byte, if so, erase
; We check the source before copy, as then the following trail byte
; is still attached and we can use the system byte epochDBCSTrail to check.
            mov     ax,[si]             ; last cell
        .endif
        Erase6e                         ; replace AL by blank if lead byte
        stosw                           ; store character and attribute

        ret
LVBCellToUB1E   ENDP


;Entry
;  ds:si - source LVB pointer
;  es:di - destination LVB pointer
;  cx    - cell length (in byte) / 2
;  dx    - reserved


LVBCellToLVB1IE PROC NEAR
        public  LVBCellToLVB1IE

; Check if first source cell to copy contains a trail byte
; and if so, erase this DBCS character.
        .if     <si ae 2> and
        .if     <bit <byte ptr ds:[si+1]> and epochDBCSTrail>
            mov     byte ptr ds:[si],CharBlank
                                        ; copy blank into this trailing char
            and     byte ptr ds:[si+1],NOT epochDBCSLead+epochDBCSTrail
                                        ; and clear trailing bit
            mov     byte ptr ds:[si-2],CharBlank
                                        ; copy blank into this leading char
            and     byte ptr ds:[si-1],NOT epochDBCSLead+epochDBCSTrail
                                        ; and clear leading bit
            or      [bp].j_dbcsstatus,BisectDBCS_LEFT
        .endif

; check to see whether we are about to overwrite to a trailing byte
; and if so, erase preceding lead byte.
        .if     <di ae 2 > and
        .if     <bit <byte ptr es:[di+1]> and epochDBCSTrail>
            mov     byte ptr es:[di-2],CharBlank
                                        ; copy blank into this leading char
            and     byte ptr es:[di-1],NOT epochDBCSLead+epochDBCSTrail

                                        ; and clear leading bit
            or      [bp].j_dbcsstatus,BisectDBCS_LEFT
        .endif

; move cells and DBCS flags
        rep     movsw                   ; copy all remaining cells

; Check if last source cell to copy contains a lead byte
; and if so, erase this DBCS character and leading character stored.
        .if     <si b [bp].j_lvbsize> and
        .if     <bit <byte ptr ds:[si+1]> and epochDBCSTrail>
            mov     byte ptr ds:[si],CharBlank
                                        ; copy blank into this trailing char
            and     byte ptr ds:[si+1],NOT epochDBCSLead+epochDBCSTrail
                                        ; and clear trailing bit
            mov     byte ptr ds:[si-2],CharBlank
                                        ; copy blank into this leading char
            and     byte ptr ds:[si-1],NOT epochDBCSLead+epochDBCSTrail
                                        ; and clear leading bit
            and     byte ptr ds:[di-1],NOT epochDBCSLead+epochDBCSTrail
                                        ; and clear stored leading bit
            mov     byte ptr ds:[di-2],CharBlank
                                        ; copy blank into stored leading char
            or      [bp].j_dbcsstatus,BisectDBCS_RIGHT
        .endif

; Check if next destination cell contains a trail byte, if so, erase
        .if     <di b [bp].j_lvbsize> and
        .if     <bit <byte ptr es:[di+1]> and epochDBCSTrail>
            mov     byte ptr es:[di],CharBlank
                                        ; copy blank into this trailing char
            and     byte ptr es:[di+1],NOT epochDBCSLead+epochDBCSTrail
                                        ; and clear trailing bit
            or      [bp].j_dbcsstatus,BisectDBCS_RIGHT
        .endif

        ret
LVBCellToLVB1IE ENDP


;Entry
;  ds:si - source LVB pointer
;  es:di - destination pointer
;  cx    - cell length (in byte) / 2
;  dx    - reserved


LVBCellToLVB1DE PROC
        public  LVBCellToLVB1DE

; calculate the valid last cell pointer
        mov     ax,[bp].j_lvbsize
        .if     <ax eq 0FFFFh>          ; 64KB on AVIO
            sub     ax,1
        .else
            sub     ax,2
        .endif
        push    ax                      ; save valid last cell pointer

; Check if first source cell to copy contains a lead byte
; and if so, erase this DBCS character.
        .if     <si b ax> and
        .if     <bit <byte ptr ds:[si+3]> and epochDBCSTrail>
            mov     byte ptr ds:[si],CharBlank
                                        ; copy blank into this leading char
            and     byte ptr ds:[si+1],NOT epochDBCSLead+epochDBCSTrail
                                        ; and clear leading bit
            mov     byte ptr ds:[si+2],CharBlank
                                        ; copy blank into this trailing char
            and     byte ptr ds:[si+3],NOT epochDBCSLead+epochDBCSTrail
                                        ; and clear trailing bit
            or      [bp].j_dbcsstatus,BisectDBCS_RIGHT
        .endif

; check to see whether we are about to overwrite to a leading byte
; and if so, erase next trail byte.
        pop     ax                      ; restore valid last cell pointer
        .if     <di b ax > and
        .if     <bit <byte ptr es:[di+3]> and epochDBCSTrail>
            mov     byte ptr es:[di+2],CharBlank
                                        ; copy blank into this leading char
            and     byte ptr es:[di+3],NOT epochDBCSLead+epochDBCSTrail
                                        ; and clear leading bit
            or      [bp].j_dbcsstatus,BisectDBCS_RIGHT
        .endif

; move cells and DBCS flags
        rep     movsw                   ; copy all remaining cells

; Check if last source cell to copy contains a trail byte
; and if so, erase this DBCS character and trailing character stored.
        .if     <si ge 0> and
        mov     al,byte ptr ds:[si+1]
        and     al,(epochDBCSTrail or epochDBCSLead)
        .if     <al eq epochDBCSLead>
            mov     byte ptr ds:[si],CharBlank
                                        ; copy blank into this leading char
            and     byte ptr ds:[si+1],NOT epochDBCSLead+epochDBCSTrail
                                        ; and clear leading bit
            mov     byte ptr ds:[si+2],CharBlank
                                        ; copy blank into this trailing char
            and     byte ptr ds:[si+3],NOT epochDBCSLead+epochDBCSTrail
                                        ; and clear trailing bit
            and     byte ptr ds:[di+3],NOT epochDBCSLead+epochDBCSTrail
                                        ; and clear stored trailing bit
            mov     byte ptr ds:[di+2],CharBlank
                                        ; copy blank into stored trailing char
            or      [bp].j_dbcsstatus,BisectDBCS_LEFT
        .endif

; Check if next destination cell contains a lead byte, if so, erase
        .if     <di ge 0> and
        mov     al,byte ptr es:[di+1]
        and     al,(epochDBCSTrail or epochDBCSLead)
        .if     <al eq epochDBCSLead>
            mov     byte ptr es:[di],CharBlank
                                        ; copy blank into this leading char
            and     byte ptr es:[di+1],NOT epochDBCSLead+epochDBCSTrail
                                        ; and clear trailing bit
            or      [bp].j_dbcsstatus,BisectDBCS_LEFT
        .endif

        ret
LVBCellToLVB1DE ENDP


; support CheckCharType of DBCS
;Entry
;  ds:si - LVB pointer
;  es:di - user buffer pointer

TypeSBCS        equ     0
TypeDBCSLead    equ     2
TypeDBCSTrail   equ     3


LVBCharTypeToUB1E   PROC
        public  LVBCharTypeToUB1

        mov     ah,byte ptr ds:[si+1]   ; get DBCS flag                 ;07Oct91
        and     ah,(epochDBCSTrail or epochDBCSLead)
                                        ; mask

        mov     al,TypeSBCS             ; default SBCS
        .if     <ah eq epochDBCSLead>
            mov     al,TypeDBCSLead     ; leading byte
        .elseif <ah eq <epochDBCSTrail or epochDBCSLead>>
            mov     al,TypeDBCSTrail    ; trailing byte
        .endif

        xor     ah,ah
        stosw                           ; store character type

        ret
LVBCharTypeToUB1E   ENDP

ENDIF ;EPOCH

;@A01 12Feb92 AN jc20 js02613
;@B01 25Feb92 AN jc20 js02800
;@B02 25Feb92 AN jc20 js02841

;11/20/1992     KY01    Changed the codes accoring to Nakada-san's modification ;;KY01A
;                       to fix PTR #JS04457 by K. Yokomizo.                     ;;KY01A
