;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;       SCCSID = @(#)xgasubax.inc        6.1 91/04/26

; ****************************************************************************
; *                                                                          *
; *                                                                          *
; *                                                                          *
; ****************************************************************************

;********************** START OF SPECIFICATIONS ****************************
;*                                                                         *
;* SOURCE FILE NAME:    XGASUBAX.INC                                       *
;*                                                                         *
;* DESCRIPTIVE NAME:    BUFFERUPDATE subroutine for DBCS Codepage          *
;*                                                                         *
;* COPYRIGHT:   na                                                         *
;*                                                                         *
;* STATUS:      OS/2 version 2.0                                           *
;*                                                                         *
;* CHANGE HISTORY:                                                         *
;*                                                                         *
;* NOTES:       Ring 2 conforming code segment                             *
;*                                                                         *
;*    DEPENDENCIES:     None                                               *
;*                                                                         *
;*    RESTRICTIONS:     None                                               *
;*                                                                         *
;*    PATH LABEL:       na                                                 *
;*                                                                         *
;* ENTRY POINTS:
;*                                                                         *
;*                                                                         *
;* EXTERNAL REFERENCES: included XGASUBAX.ASM                              *
;*                                                                         *
;********************** END OF SPECIFICATIONS ******************************




;Entry
;  ds:si - user cells pointer
;  es:di - LVB pointer
;  cx    - cell length (in byte)


UBCellToLVB1    PROC
        public  UBCellToLVB1

; check to see whether we are about to overwrite to a trailing byte
; and if so, erase preceding lead byte.
        Erase1x

        shr     cx,1                    ; convert bytes to number of cell
        xor     dx,dx                   ; clear DH for use as flag in loop

; write cells.
        .repeat
            mov     bx,word ptr es:[di] ; Save for restoring the previous ;@A00
                                        ; cp & attr#1 for tail exception  ;@A00
            lodsw                       ; AL = char, AH = 1st attribute
            stosw                       ; write char and 1st attribute
            push    ds                  ; save source selector
            mov     ds,[bp].j_dbcslvbsel; use DBCS flag LVB
            xor     ah,ah               ; ignore attr#2(including lcid),  ;@A01
                                        ; which means using a default     ;@A01
                                        ; dbcs env. vector.               ;@A01
            SetSystemByte               ; AH = system byte
            mov     byte ptr ds:[di-1],ah       ; store system byte
            pop     ds                  ; restore source selector
        .loop

; Check to see if the last char written was a lead byte, if so, erase
        .if     <bit dh and 1>          ; last char copied was lead byte
            push    ds                  ; save source selector
            mov     ds,[bp].j_dbcslvbsel; use DBCS flag LVB
;@A00       mov     byte ptr es:[di-2],CharBlank
;@A00                                   ; write a blank into the last character
;@A00       mov     byte ptr ds:[di-1],SBCS_BYTE
;@A00                                   ; clear system byte
            mov     word ptr es:[di-2],bx ; Undo                          ;@A00
            shl     dh,1                                                  ;@A00
            pop     ds                  ; restore source selector
        .endif

; Check if next cell contains a trail byte, if so, erase
        .if     <dh ne 2>               ; When dbcs 1st has been ignored, ;@A00
                                        ; forget the exception handling.  ;@A00
            Erase2x
        .endif                                                            ;@A00

        ret
UBCellToLVB1    ENDP


;Entry
;  ds:si - user chars pointer
;  es:di - LVB pointer
;  cx    - char length (in byte)

UBCharToLVB1    PROC
        public  UBCharToLVB1

; check to see whether we are about to overwrite to a trailing byte
; and if so, erase preceding lead byte.
        Erase1x

        xor     dx,dx                   ; clear DH for use as flag in loop

; write characters
        .repeat
            mov     bl,byte ptr es:[di] ; Save for restoring the previous ;@A01
            lodsb                       ; copy char
            stosb
            push    ds                  ; save source selector
            mov     ds,[bp].j_dbcslvbsel; use DBCS flag LVB
            xor     ah,ah               ; ignore attr#2(including lcid),  ;@A01
                                        ; which means using a default     ;@A01
                                        ; dbcs env. vector.               ;@A01
            SetSystemByte               ; AH = system byte
            mov     byte ptr ds:[di],ah ; store system byte
            pop     ds                  ; restore source selector
            inc     di                  ; skip 1st attribute
        .loop

; Check to see if the last char written was a lead byte, if so, erase
        .if     <bit dh and 1>          ; last char copied was lead byte
            push    ds                  ; save source selector
            mov     ds,[bp].j_dbcslvbsel; use DBCS flag LVB
;@A01       mov     byte ptr es:[di-2],CharBlank
;@A01                                   ; write a blank into the last character
;@A01       mov     byte ptr ds:[di-1],SBCS_BYTE
;@A01                                   ; clear system byte
            mov     byte ptr es:[di-2],bl ; undo ; restore the prev. cp.  ;@A01
            shl     dh,1                                                  ;@A01
            pop     ds                  ; restore source selector
        .endif

; Check if next cell contains a trail byte, if so, erase
        .if     <dh ne 2>               ; When dbcs 1st has been ignored, ;@A00
                                        ; forget the exception handling.  ;@A00
            Erase2x
        .endif                                                            ;@A00

        ret
UBCharToLVB1    ENDP


;Entry
;  ah    - 1st attribute
;  dl    - 2nd attribute (if WorldFormat)
;  dh    - system byte   (if WorldFormat)
;  ds:si - user chars pointer
;  es:di - LVB pointer
;  cx    - char length (in byte)

UBCharAttToLVB1 PROC
        public  UBCharAttToLVB1

; check to see whether we are about to overwrite to a trailing byte
; and if so, erase preceding lead byte.
        Erase1x

        mov     bl,ah                   ; BL = 1st attribute
        xor     dx,dx                   ; clear DH for use as flag in loop

; write characters and attributes
        .repeat
            mov     ax,word ptr es:[di]              ; save for retrieve ;@A01
            mov     word ptr [bp].wSaveCpAttr1,ax                        ;@A01
            lodsb                       ; char = AL
            mov     ah,bl               ; AH = first attribute
            stosw                       ; write char and 1st attribute
            push    ds                  ; save source selector
            mov     ds,[bp].j_dbcslvbsel; use DBCS flag LVB
            xor     ah,ah               ; ignore attr#2(including lcid),  ;@A01
                                        ; which means using a default     ;@A01
                                        ; dbcs env. vector.               ;@A01
            SetSystemByte               ; AH = system byte
            mov     byte ptr ds:[di-1],ah       ; store system byte
            pop     ds                  ; restore source selector
        .loop

; Check to see if the last char written was a lead byte, if so, erase
        .if     <bit dh and 1>          ; last char copied was lead byte
            push    ds                  ; save source selector
            mov     ds,[bp].j_dbcslvbsel; use DBCS flag LVB
;@A01       mov     byte ptr es:[di-2],CharBlank
;@A01                                   ; write a blank into the last character
;@A01       mov     byte ptr ds:[di-1],SBCS_BYTE
;@A01                                   ; clear system byte

            .if     <bit <word ptr [bp].shadow_Flags> and CGAAttr>       ;@A03
                mov     byte ptr es:[di-2],CharBlank                     ;@A03
                                            ; write a blank at           ;@A03
                                            ; the last character         ;@A03
                                                                         ;@A03
;@A04           mov     byte ptr es:[di-1],SBCS_BYTE                     ;@A03
                and     byte ptr es:[di-1],NOT DBCSFlag+TrailByteFlag    ;@A04
                                            ; clear system byte          ;@A03
            .else                                                        ;@A03
                mov     ax,word ptr [bp].wSaveCpAttr1    ; retrieve      ;@A01
                mov     word ptr es:[di-2],ax                            ;@A01
                shl     dh,1                                             ;@A01
            .endif                                                       ;@A03
            pop     ds                  ; restore source selector
        .endif

; Check if next cell contains a trail byte, if so, erase
        .if     <dh ne 2>               ; When dbcs 1st has been ignored, ;@A00
                                        ; forget the exception handling.  ;@A00
            Erase2x
        .endif                                                            ;@A00

        ret
UBCharAttToLVB1 ENDP



;Entry
;  al    - leading character or SBCS character
;  ah    - trailing character
;  es:di - LVB pointer
;  cx    - char count

UBNCharToLVB1   PROC
        public  UBNCharToLVB1

; check to see whether we are about to overwrite to a trailing byte
; and if so, erase preceding lead byte.
        Erase1x

        xor     dx,dx                   ; clear DX (system byte)

; branch by DBCS character or SBCS character
        push    ax                      ; keep ah(trailing byte)
        xor     ah,ah                   ; can ignore lcid because of
                                        ; char code only
        push    ds
        push    si
        lds     si,[bp].lpNLSExt
        CheckLeadByte                   ; is it leading byte?
        pop     si
        pop     ds
        pop     ax

; write DBCS characters
        .if     <c>                     ; yes
            mov     dl,DBCSFlag         ; system byte
            mov     dh,TrailByteFlag OR DBCSFlag
            push    ds                  ; save source selector
            mov     ds,[bp].j_dbcslvbsel; use DBCS flag LVB
            shr     cx,1                ; CX = a pair of lead and trail byte
            pushf                       ; save frag whether DBCS bisect
            jcxz    @F                  ; 1990-08-02 updated
                                        ;     fix for starting from max point
            .repeat
                stosb                           ; copy leading character
                mov     byte ptr ds:[di],dl     ; store leading system byte
                inc     di
                xchg    ah,al                   ; flip lead/trail char
                stosb                           ; copy trailing character
                mov     byte ptr ds:[di],dh     ; store trailing system byte
                inc     di
                xchg    ah,al                   ; flip lead/trail char
            .loop

; if the char count cause DBCS bisecting, store blank character
@@:                                     ; 1990-08-02 updated
                                        ;     fix for starting from max point
            popf                        ; restore frag whether DBCS bisect
            .if     <c>                 ; last char is pointed to lead byte
                mov     al,CharBlank    ; last character is blank
                stosb                   ; copy blank character
;@A04           mov     byte ptr ds:[di],SBCS_BYTE      ; store system byte
                and     byte ptr ds:[di],NOT DBCSFlag+TrailByteFlag     ;@A04
                inc     di
            .endif
            pop     ds                  ; restore source selector

; write SBCS characters
        .else short                     ; no
            push    ds                  ; save source selector
            mov     ds,[bp].j_dbcslvbsel; use DBCS flag LVB
            .repeat
                stosb                           ; copy char
                mov     byte ptr ds:[di],dl     ; store system byte
                inc     di
            .loop
            pop     ds                  ; restore source selector
        .endif

; Check if next cell contains a trail byte, if so, erase
        Erase2x

        ret
UBNCharToLVB1   ENDP


;Entry
;  al    - 1st attribute
;  ds:si - 2nd attribute pointer
;  es:di - LVB pointer
;  cx    - attr count


UBNAttToLVB1    PROC NEAR
        public  UBNAttToLVB1

; write attributes
        .repeat
            inc     di                  ; skip character
            stosb                       ; copy attribute
        .loop

        ret
UBNAttToLVB1    ENDP


;Entry
;  al    - character
;  ah    - 1st attribute
;  ds:si - Trailing byte character or 2nd attribute pointer
;  es:di - LVB pointer
;  cx    - cell count


UBNCellToLVB1   PROC
        public  UBNCellToLVB1

; check to see whether we are about to overwrite to a trailing byte
; and if so, erase preceding lead byte.
        Erase1x

        xor     dx,dx                   ; clear DX (system byte)

; branch by DBCS character or SBCS character
        push    ax                      ; keep ah(trailing byte)
        xor     ah,ah                   ; Don't need lcid check ;@AN01
        push    ds
        push    si
        lds     si,[bp].lpNLSExt
        CheckLeadByte                   ; is it leading byte?
        pop     si
        pop     ds
        pop     ax

; write DBCS cells
        .if     <c>                     ; yes
            xchg    ax,bx               ; BX = Leading Byte
            mov     dl,DBCSFlag         ; system byte
            mov     dh,TrailByteFlag OR DBCSFlag
            lodsw                       ; AX = Trailing Byte
            push    ds                  ; save source selector
            mov     ds,[bp].j_dbcslvbsel; use DBCS flag LVB
            shr     cx,1                ; CX = a pair of lead and trail byte
            pushf                       ; save frag whether DBCS bisect
            jcxz    @F                  ; 1990-08-02 updated
                                        ;     fix for starting from max point
            .repeat
                xchg    ax,bx                   ; flip trail/lead byte
                stosw                           ; copy leading char and 1st attr
                mov     byte ptr ds:[di-1],dl   ; store leading system byte
                xchg    ax,bx                   ; flip lead/trail byte
                stosw                           ; copy trailing char and 1st attr
                mov     byte ptr ds:[di-1],dh   ; store trailing system byte
            .loop

; if the cell count cause DBCS bisecting, store attribute only.
@@:                                     ; 1990-08-02 updated
                                        ;     fix for starting from max point
            popf                        ; restore frag whether DBCS bisect
            .if     <c>                 ; last cell is pointed to lead byte
                mov     al,CharBlank    ; last character is blank
                mov     ah,bh           ; last attribute is leading it
                stosw                   ; copy char and 1st attr
;@A04           mov     byte ptr ds:[di-1],SBCS_BYTE
                and     byte ptr ds:[di-1],NOT DBCSFlag+TrailByteFlag   ;@A04
                                        ; store and system byte
            .endif
            pop     ds                  ; restore source selector

; write SBCS characters
        .else short                     ; no
            push    ds                  ; save source selector
            mov     ds,[bp].j_dbcslvbsel; use DBCS flag LVB
            .repeat
                stosw                           ; copy char and 1st attr
                mov     byte ptr ds:[di-1],dh   ; store system byte
            .loop
            pop     ds                  ; restore source selector
        .endif

; Check if next cell contains a trail byte, if so, erase
        Erase2x

        ret
UBNCellToLVB1   ENDP


;Entry
;  ds:si - LVB pointer
;  es:di - user buffer pointer
;  cx    - char length (in byte)


LVBCharToUB1    PROC
        public  LVBCharToUB1

; Check if first cell to copy contains a trail byte, if so, erase
        mov     al,byte ptr [si]        ; AL = first character
        Erase5x                         ; replace AL by blank if trail byte
        dec     cx                      ; count down this character

        .if     <ncxz>                  ; branch if only 1 char total
            stosb                       ; store character
            add     si,2                ; skip 2 attributes
            jmp short @F                ; jump into loop to do cx-1 iterations

            .repeat
                movsb                   ; copy character
                inc     si              ; skip 1 attribute
@@:
            .loop

; Check if last cell to copy contains lead byte, if so, erase
; We check the source before copy, as then the following trail byte
; is still attached and we can use the system byte TrailByteFlag to check.
            mov al,[si]                 ; last character
        .endif
        Erase6x                         ; replace AL by blank if lead byte
        stosb                           ; store character

        ret
LVBCharToUB1    ENDP


;Entry
;  ds:si - LVB pointer
;  es:di - user buffer pointer
;  cx    - cell length (in byte) / 2


LVBCellToUB1    PROC
        public  LVBCellToUB1

; Check if first cell to copy contains a trail byte, if so, erase
        mov     ax,[si]                 ; AL = first char, AH = first attr
        Erase5x                         ; replace AL by blank if trail byte
        dec     cx                      ; count down this cell

        .if     <ncxz>                  ; branch if this only cell to copy
            stosw                       ; store character and attribute
            add     si,2                ; skip first cell
            jmp short @F                ; do cx-1 iterations

            .repeat
                movsw                   ; copy character and attribute
@@:
            .loop

; Check if last cell to copy contains lead byte, if so, erase
; We check the source before copy, as then the following trail byte
; is still attached and we can use the system byte TrailByteFlag to check.
            mov     ax,[si]             ; last cell
        .endif
        Erase6x                         ; replace AL by blank if lead byte
        stosw                           ; store character and attribute

        ret
LVBCellToUB1    ENDP


;Entry
;  ds:si - source LVB pointer
;  es:di - destination LVB pointer
;  cx    - cell length (in byte) / 2
;  dx    - reserved


LVBCellToLVB1I  PROC NEAR
        public  LVBCellToLVB1I

; Check if first source cell to copy contains a trail byte
; and if so, erase this DBCS character.
        push    es                      ; save dest sel
        mov     es,[bp].j_dbcslvbsel    ; use DBCS flag LVB
        .if     <si ae 2> and
        .if     <bit <byte ptr es:[si+1]> and TrailByteFlag>
            mov     byte ptr ds:[si],CharBlank
                                        ; copy blank into this trailing char
;@A04       mov     byte ptr es:[si+1],SBCS_BYTE
            and     byte ptr es:[si+1],NOT DBCSFlag+TrailByteFlag       ;@A04
                                        ; and clear trailing bit
            mov     byte ptr ds:[si-2],CharBlank
                                        ; copy blank into this leading char
;@A04       mov     byte ptr es:[si-1],SBCS_BYTE
            and     byte ptr es:[si-1],NOT DBCSFlag+TrailByteFlag       ;@A04
                                        ; and clear leading bit
            or      [bp].j_dbcsstatus,BisectDBCS_LEFT
        .endif
        pop     es                      ; restore dest sel

; check to see whether we are about to overwrite to a trailing byte
; and if so, erase preceding lead byte.
        push    ds                      ; save src sel
        mov     ds,[bp].j_dbcslvbsel    ; use DBCS flag LVB
        .if     <di ae 2 > and
        .if     <bit <byte ptr ds:[di+1]> and TrailByteFlag>
            mov     byte ptr es:[di-2],CharBlank
                                        ; copy blank into this leading char
;@A04       mov     byte ptr ds:[di-1],SBCS_BYTE
            and     byte ptr ds:[di-1],NOT DBCSFlag+TrailByteFlag       ;@A04

                                        ; and clear leading bit
            or      [bp].j_dbcsstatus,BisectDBCS_LEFT
        .endif
        pop     ds                      ; restore src sel

; move cells and DBCS flags
        push    si
        push    di
        push    cx
        rep     movsw                   ; copy all remaining cells
        pop     cx
        pop     di
        pop     si

        push    ds
        push    es
        mov     ds,[bp].j_dbcslvbsel    ; use DBCS flag LVB
        mov     es,[bp].j_dbcslvbsel    ; use DBCS flag LVB
        rep     movsw                   ; copy all remaining DBCS flags
        pop     es
        pop     ds

; Check if last source cell to copy contains a lead byte
; and if so, erase this DBCS character and leading character stored.
        push    es                      ; save dest sel
        mov     es,[bp].j_dbcslvbsel    ; use DBCS flag LVB
        .if     <si b [bp].j_lvbsize> and
        .if     <bit <byte ptr es:[si+1]> and TrailByteFlag>
            mov     byte ptr ds:[si],CharBlank
                                        ; copy blank into this trailing char
;@A04       mov     byte ptr es:[si+1],SBCS_BYTE
            and     byte ptr es:[si+1],NOT DBCSFlag+TrailByteFlag       ;@A04
                                        ; and clear trailing bit
            mov     byte ptr ds:[si-2],CharBlank
                                        ; copy blank into this leading char
;@A04       mov     byte ptr es:[si-1],SBCS_BYTE
            and     byte ptr es:[si-1],NOT DBCSFlag+TrailByteFlag       ;@A04
                                        ; and clear leading bit
;@A04       mov     byte ptr es:[di-1],SBCS_BYTE
            and     byte ptr es:[di-1],NOT DBCSFlag+TrailByteFlag       ;@A04
                                        ; and clear stored leading bit
            pop     es                  ; restore dest sel
            mov     byte ptr es:[di-2],CharBlank
                                        ; copy blank into stored leading char
            push    es                  ; for adjust stack
            or      [bp].j_dbcsstatus,BisectDBCS_RIGHT
        .endif
        pop     es                      ; restore dest sel

; Check if next destination cell contains a trail byte, if so, erase
        push    ds                      ; save src sel
        mov     ds,[bp].j_dbcslvbsel    ; use DBCS flag LVB
        .if     <di b [bp].j_lvbsize> and
        .if     <bit <byte ptr ds:[di+1]> and TrailByteFlag>
            mov     byte ptr es:[di],CharBlank
                                        ; copy blank into this trailing char
;@A04       mov     byte ptr ds:[di+1],SBCS_BYTE
            and     byte ptr ds:[di+1],NOT DBCSFlag+TrailByteFlag       ;@A04
                                        ; and clear trailing bit
            or      [bp].j_dbcsstatus,BisectDBCS_RIGHT
        .endif
        pop     ds                      ; restore src sel

        ret
LVBCellToLVB1I  ENDP


;Entry
;  ds:si - source LVB pointer
;  es:di - destination pointer
;  cx    - cell length (in byte) / 2
;  dx    - reserved


LVBCellToLVB1D  PROC
        public  LVBCellToLVB1D

; calculate the valid last cell pointer
        mov     ax,[bp].j_lvbsize
        .if     <ax eq 0FFFFh>          ; 64KB on AVIO
            sub     ax,1
        .else
            sub     ax,2
        .endif
        push    ax                      ; save valid last cell pointer

; Check if first source cell to copy contains a lead byte
; and if so, erase this DBCS character.
        push    es                      ; save dest sel
        mov     es,[bp].j_dbcslvbsel    ; use DBCS flag LVB
        .if     <si b ax> and
        .if     <bit <byte ptr es:[si+3]> and TrailByteFlag>
            mov     byte ptr ds:[si],CharBlank
                                        ; copy blank into this leading char
;@A04       mov     byte ptr es:[si+1],SBCS_BYTE
            and     byte ptr es:[si+1],NOT DBCSFlag+TrailByteFlag       ;@A04
                                        ; and clear leading bit
            mov     byte ptr ds:[si+2],CharBlank
                                        ; copy blank into this trailing char
;@A04       mov     byte ptr es:[si+3],SBCS_BYTE
            and     byte ptr es:[si+3],NOT DBCSFlag+TrailByteFlag       ;@A04
                                        ; and clear trailing bit
            or      [bp].j_dbcsstatus,BisectDBCS_RIGHT
        .endif
        pop     es                      ; restore dest sel

; check to see whether we are about to overwrite to a leading byte
; and if so, erase next trail byte.
        pop     ax                      ; restore valid last cell pointer
        push    ds                      ; save src sel
        mov     ds,[bp].j_dbcslvbsel    ; use DBCS flag LVB
        .if     <di b ax > and
        .if     <bit <byte ptr ds:[di+3]> and TrailByteFlag>
            mov     byte ptr es:[di+2],CharBlank
                                        ; copy blank into this leading char
;@A04       mov     byte ptr ds:[di+3],SBCS_BYTE
            and     byte ptr ds:[di+3],NOT DBCSFlag+TrailByteFlag       ;@A04
                                        ; and clear leading bit
            or      [bp].j_dbcsstatus,BisectDBCS_RIGHT
        .endif
        pop     ds                      ; restore src sel

; move cells and DBCS flags
        push    si
        push    di
        push    cx
        rep     movsw                   ; copy all remaining cells
        pop     cx
        pop     di
        pop     si

        push    ds
        push    es
        mov     ds,[bp].j_dbcslvbsel    ; use DBCS flag LVB
        mov     es,[bp].j_dbcslvbsel    ; use DBCS flag LVB
        rep     movsw                   ; copy all remaining DBCS flags
        pop     es
        pop     ds

; Check if last source cell to copy contains a trail byte
; and if so, erase this DBCS character and trailing character stored.
        push    es                      ; save dest sel
        mov     es,[bp].j_dbcslvbsel    ; use DBCS flag LVB
        .if     <si ge 0> and
        mov     al,byte ptr es:[si+1]
        and     al,(TrailByteFlag or DBCSFlag)
        .if     <al eq DBCSFlag>
            mov     byte ptr ds:[si],CharBlank
                                        ; copy blank into this leading char
;@A04       mov     byte ptr es:[si+1],SBCS_BYTE
            and     byte ptr es:[si+1],NOT DBCSFlag+TrailByteFlag       ;@A04
                                        ; and clear leading bit
            mov     byte ptr ds:[si+2],CharBlank
                                        ; copy blank into this trailing char
;@A04       mov     byte ptr es:[si+3],SBCS_BYTE
            and     byte ptr es:[si+3],NOT DBCSFlag+TrailByteFlag       ;@A04
                                        ; and clear trailing bit
;@A04       mov     byte ptr es:[di+3],SBCS_BYTE
            and     byte ptr es:[di+3],NOT DBCSFlag+TrailByteFlag       ;@A04
                                        ; and clear stored trailing bit
            pop     es                  ; restore dest sel
            mov     byte ptr es:[di+2],CharBlank
                                        ; copy blank into stored trailing char
            push    es                  ; for adjust stack
            or      [bp].j_dbcsstatus,BisectDBCS_LEFT
        .endif
        pop     es                      ; restore dest sel

; Check if next destination cell contains a lead byte, if so, erase
        push    ds                      ; save src sel
        mov     ds,[bp].j_dbcslvbsel    ; use DBCS flag LVB
        .if     <di ge 0> and
        mov     al,byte ptr ds:[di+1]
        and     al,(TrailByteFlag or DBCSFlag)
        .if     <al eq DBCSFlag>
            mov     byte ptr es:[di],CharBlank
                                        ; copy blank into this leading char
;@A04       mov     byte ptr ds:[di+1],SBCS_BYTE
            and     byte ptr ds:[di+1],NOT DBCSFlag+TrailByteFlag       ;@A04
                                        ; and clear trailing bit
            or      [bp].j_dbcsstatus,BisectDBCS_LEFT
        .endif
        pop     ds                      ; restore src sel

        ret
LVBCellToLVB1D  ENDP


; support CheckCharType of DBCS
;Entry
;  ds:si - LVB pointer
;  es:di - user buffer pointer

TypeSBCS        equ     0
TypeDBCSLead    equ     2
TypeDBCSTrail   equ     3


LVBCharTypeToUB1 PROC
        public  LVBCharTypeToUB1

        push    ds                      ; save src sel
        mov     ds,[bp].j_dbcslvbsel    ; use DBCS flag LVB
        mov     ah,byte ptr ds:[si+1]   ; get DBCS flag
        pop     ds                      ; restore src sel
        and     ah,(TrailByteFlag or DBCSFlag)
                                        ; mask

        mov     al,TypeSBCS             ; default SBCS
        .if     <ah eq DBCSFlag>
            mov     al,TypeDBCSLead     ; leading byte
        .elseif <ah eq <TrailByteFlag or DBCSFlag>>
            mov     al,TypeDBCSTrail    ; trailing byte
        .endif

        xor     ah,ah
        stosw                           ; store character type

        ret
LVBCharTypeToUB1        ENDP

;@AN01 12Feb92 AN jc20 js02683
