;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = VDHSTRUCT.INC
;*
;* DESCRIPTIVE NAME = Structure definitions for base video
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION  Structure definitions for base video
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   03/25/89              132    DCR 132 changes
;*   04/11/91              1348   NAKADA, Enable DBCS support in Vio-Window, DCR 1348
;*
;*****************************************************************************/

VDHBUF  STRUC                           ; VDH BufferUpdate stack frame

;/*
;** this is the saved BP from the caller                                ;          
;*/
                dw      ?               ; BP of BVS

;/*
;** these are local variables used by Buffer updated functions          ;          
;*/

PVB_Sel         dw      ?               ; Selector to the PVB or 0      ;          
LVB_Sel         dw      ?               ; Selector to the LVB or 0      ;          

IFDEF D1348                             ;/prepare the 2nd LVB for DBCS flag
j_dbcslvbsel    dw      0               ; DBCS flag LVB selector
                                        ; save LVB size
j_lvbsize       dw      0               ; LVB size (LVB and PS)
                                        ; if 64K, set 0FFFFh
j_funcindx      dw      0               ; function index for DBCS BufferUpdate
                                        ;/DBCS BufferUpdate (bisecting DBCS
                                        ; character status)
j_dbcsstatus    dw      0               ; bisecting DBCS character status
flgDBCS         dw      ?               ; flag to indicate some DBCS exists
shadow_Flags    dw      ?               ; to see it's from wrttty
lpNLSExt        dd      ?               ; pointer to NLS extended env.
wSaveCpAttr1    dw      ?
wSaveAttr2Attr3 dw      ?
IFDEF EPOCH
shadowFMTID     dw      ?
shadowColor     dw      ?
shadowAttribute dw      ?               ; This word is used only when   ;@A1
                                        ; the request is ANSIcall's     ;@A1
                                        ; WrtTTY and Scroll.            ;@A1
                                        ; In those cases, common format ;@A1
                                        ; attr. to epoch format attr    ;@A1
                                        ; conversion is needed.         ;@A1
ENDIF
ENDIF ;D1348

mincol          dw      ?               ; left most column of the LVB   ;          
minrow          dw      ?               ; top most row of the LVB       ;          
maxcol          dw      ?               ; rigth most column of the LVB  ;          
maxrow          dw      ?               ; bottom most row of the LVB    ;          

cellsize        dw      ?               ; number of bytes per cell in LVB ;          
lvb_width       dw      ?               ; number of cells wide the LVB is ;          

ScrollFlags     dw      ?               ; flags for Scroll functions    ;          
FillCellLow     dw      ?               ; low word of the default cell  ;          
FillCellHigh    dw      ?               ; high word of the default cell ;          

RowsToFill      dw      ?               ; number of rows left blank by scroll ;          

LVBFillCount    dw      ?               ; number of bytes per fill row in LVB ;          
LVBFillSkip     dw      ?               ; number of bytes to next line in LVB ;          
LVBFillOff      dw      ?               ; beginning offset of fill rect in LVB ;          

PVBFillCount    dw      ?               ; number of bytes per fill row in PVB ;          
PVBFillSkip     dw      ?               ; number of bytes to next line in PVB ;          
PVBFillOff      dw      ?               ; beginning offset of fill rect in PVB ;          

RowsToMove      dw      ?               ; number of rows in rectangle to move ;          

LVBMoveCount    dw      ?               ; number of bytes per move row in LVB ;          
LVBMoveSkip     dw      ?               ; number of bytes to next row in LVB ;          
LVBMoveSrcOff   dw      ?               ; beginning of source move rect in LVB ;          
LVBMoveDestOff  dw      ?               ; beginning of dest move rect in LVB ;          

PVBMoveCount    dw      ?               ; number of bytes per move row in LVB ;          
PVBMoveSkip     dw      ?               ; number of bytes to next row in LVB ;          
PVBMoveSrcOff   dw      ?               ; beginning of source move rect in LVB ;          
PVBMoveDestOff  dw      ?               ; beginning of dest move rect in LVB ;          

leftfill        dw      ?               ; left most column of fill rectangle ;          
topfill         dw      ?               ; top most row of fill rectangle   ;          
rightfill       dw      ?               ; right most column of fill rectangle ;          
bottomfill      dw      ?               ; bottom most row of fill rectangle ;          

leftscroll      dw      ?               ; left most column of source rectangle ;          
topscroll       dw      ?               ; top most row of source rectangle ;          
rightscroll     dw      ?               ; right most column of source rectangle ;          
bottomscroll    dw      ?               ; bottom most row of source rectangle ;          

leftdest        dw      ?               ; left most column of destination rect ;          
topdest         dw      ?               ; top most row of destination rect ;          
rightdest       dw      ?               ; right most column of destination rect ;          
bottomdest      dw      ?               ; bottom most row of destination rect ;          

;/*
;** this was on the stack before we got here
;*/
                dw      ?               ; IP of BVS                     ;          
                dw      ?               ; CS of BVS                     ;          
FuncNumLo       dw      ?               ; BufferUpdate function number  ;          
FuncNumHi       dw      ?               ; 
ParmBuf         dd      ?               ; Selector:offset of paramter buffer ;          
EnvBufParm      dd      ?               ; Selector:offset of environment buffer ;          

VDHBUF  ENDS

;/*
;**   The Read and Write routines use a different set or local variables  ;          
;**   than the Scroll functions do.  The following are aliases for elements ;          
;**   of the local variable frame used by the Read and Write routines.    ;          
;*/

lvb_height      equ     ScrollFlags     ; number of rows in LVB         ;          
FirstRow        equ     RowsToFill      ; number of cells or bytes in first row ;          
RowLength       equ     LVBFillSkip     ; number of cells or bytes in later rows ;          
LVBCount        equ     LVBFillCount    ; number of cells or bytes to move, LVB ;          
LVBOff          equ     LVBFillOff      ; offset for read or write in LVB ;          
PVBSkip         equ     PVBFillSkip     ; number of bytes to next row in PVB ;          
PVBCount        equ     PVBFillCount    ; number of cells or bytes to move, PVB ;          
PVBOff          equ     PVBFillOff      ; offset for read or write in LVB ;          

;/*
;**   The following are equates used for the archaic CGA routines.        ;          
;**   This is only to avoid build problems until the routines get updated.;          
;*/

BottomRow       equ     ScrollFlags                                       ;          
LeftCol         equ     RowsToFill                                        ;          
LineLength      equ     LVBFillSkip                                       ;          
Retrace         equ     LVBFillCount                                      ;          
RightCol        equ     LVBFillOff                                        ;          
ScrollCount     equ     PVBFillSkip                                       ;          
SkipLength      equ     PVBFillCount                                      ;          
TopRow          equ     PVBFillOff                                        ;          

IFDEF D1348
defaultDBCS     equ     00000001b       ; default code page is of DBCS
AvioDBCS        equ     00000010b       ; a code page for Avio lcid 1 to 3 is
                                        ; of DBCS
anyDBCS         equ     defaultDBCS+AvioDBCS
ENDIF ;D1348


VDHPARM STRUC                           ; VDH BufferUpdate parameter structure

ParmLength      dw      ?               ; Length parameter block buffer
Flags           dw      ?               ; Source/target buffer (LVB, PVB)
AppDataAddr     dd      ?               ; Address of application data buffer
AppCellAddr     dd      ?               ; Address of char, attr, or cell
FuncIndex       dw      ?               ; Sub-function number
Row             dw      ?               ; Starting row
Col             dw      ?               ; Starting column
Row2            dw      ?               ; Secondary row or ending row
Col2            dw      ?               ; Secondary column or ending column
RepeatFactor    dw      ?               ; # of chars, cells, rows, or cols
LogicalBufSel   dw      ?               ; LVB selector
TouchXLeft      dw      ?               ; left most col touched by the write)   ;          
TouchYTop       dw      ?               ; top most col touched by the write)    ;          
TouchXRight     dw      ?               ; right most col touched by the write)  ;          
TouchYBottom    dw      ?               ; bottom most col touched by the write) ;          
LVBRowOff       dw      ?               ; row offset of the LVB relative to PVB ;          
LVBColOff       dw      ?               ; col offset of the LVB relative to PVB ;          
LVBWidth        dw      ?               ; width of the LVB in cells             ;          
LVBHeight       dw      ?               ; height of the LVB in cells            ;          
LVBFormatID     db      ?               ; format id of the LVB                  ;          
LVBAttrCount    db      ?               ; number of attributes in the LVB       ;          

VDHPARM ENDS


VDHENV  STRUC                           ; VDH environment buffer structure

ModeDataOff     dw      ?               ; Offset to mode data in env. buffer

VDHENV  ENDS


MODEDAT STRUC                           ; VDH mode data structure

ModeLength      dw      ?               ; Length of parameter buffer
ModeType        db      ?               ; Mode type bits
Color           db      ?               ; Color value
TextCols        dw      ?               ; # of text columns in current mode
TextRows        dw      ?               ; # of text rows in current mode
HorizRes        dw      ?               ; Horizontal pel resolution
VertRes         dw      ?               ; Vertical pel resolution
AttrFormat      db      ?               ; Attribute format
NAttributes     db      ?               ; # of attribute in character cell
BufferAddrLo    dw      ?               ; Physical address of PVB
BufferAddrHi    dw      ?               ; 
BufferLenLo     dw      ?               ; Length of PVB in current mode
BufferLenHi     dw      ?               ; 
FullBufSizeLo   dw      ?               ; Size of LVB for PVB save
FullBufSizeHi   dw      ?               ; 
PartBufSize     dd      ?               ;          
ExtData         dd      ?               ;          
ScrlRectLeft    dw      ?               ;          
ScrlRectTop     dw      ?               ;          
ScrlRectRight   dw      ?               ;          
ScrlRectBottom  dw      ?               ;          

MODEDAT ENDS

;@A1  = 11/06/91  NAKADA, ANSI's request in Epoch format
