;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = VDHCTL.INC
;*
;* DESCRIPTIVE NAME = flags definitions for base video
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION  flags definitions for base video
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx   xxxxxxx
;*   12/19/88             P3250 Allow set border color for CGA compatible modes
;*   04/14/89             B701111 Remove negative logic and synch with .H file
;*
;*****************************************************************************/

;/*
;**        Define flags not set on command line
;*/

IFNDEF VDHINIT
        VDHINIT         equ     0
ENDIF
IF VDHINIT
        VDHVGA          equ     1
ENDIF
IFNDEF VDHVGA
        VDHVGA          equ     0
ENDIF
IFNDEF VDHEGA
        VDHEGA          equ     0
ENDIF
IFNDEF VDHCGA
        VDHCGA          equ     0
ENDIF
IFNDEF VDHMPA
        VDHMPA          equ     0
ENDIF
IFNDEF VDH8514A
        VDH8514A        equ     0
ENDIF
IFNDEF CGA_ALWAYS_FAST
        CGA_ALWAYS_FAST equ     0
ENDIF
IFNDEF DEBUG
        DEBUG           equ     0
ENDIF

;/*
;**        Check switch combinations (on first pass only)
;*/

IF1
IF     ( (VDHVGA + VDHEGA + VDHCGA + VDHMPA + VDH8514A) NE 1)
%out Error in assembly command line parameters
%err No valid video device specified
ENDIF
ENDIF

;/*
;**        Set feature switches
;*/

BLINK_SUPPORT           equ     ( VDHVGA OR VDHEGA OR VDHCGA )
FONT_SUPPORT            equ     ( VDHVGA OR VDHEGA )
OVERSCAN_SUPPORT        equ     ( VDHVGA OR VDHEGA OR VDHCGA )
PALETTE_SUPPORT         equ     ( VDHVGA OR VDHEGA )
ROMFONT_SUPPORT         equ     ( VDHVGA OR VDHEGA OR VDHCGA )
UNDERSCORE_SUPPORT      equ     ( VDHVGA OR VDHEGA )

