/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = VDHSUBS.c
 *
 * DESCRIPTIVE NAME = Base video device handlers - Private routines
 *
 *
 * VERSION      V2.0
 *
 * DATE
 *
 * DESCRIPTION  Base video device handlers - Private routines
 *
 *              This source file contains routines which are not public.
 *              They are called by various VDH routines to perform I/O
 *              functions.
 *
 *              These routines execute as ring 2 conforming
 *
 * FUNCTIONS    PhysToUVirt, FreePhysToUVirt, BitNum
 *              SaveRestorePVB, ExamineConfig, SaveRestoreHW,
 *              getBIOSfonts
 *
 * NOTES        NONE
 *
 * STRUCTURES   NONE
 *
 * EXTERNAL REFERENCES  DosDevIOCtl, DosDevConfig
 *                      AccessHardware, AccessRegister
 *
 * EXTERNAL FUNCTIONS
 *
 *              NONE
 *
*/

/*
 +----------------------------------------------------------------------------+
 |  Include files                                                             |
 +----------------------------------------------------------------------------+
*/
#define INCL_BASE               /* ALL of OS/2 Base                */
#define INCL_DOSDEVICES         /* Device specific, ring 2 support */
#include <os2.h>
#include <memory.h>                                                     /*@T42*/

#include "vdhctl.h"             /* Conditional compilation control */
#include "vdh.h"                /* Type definitions                */

/*
 +----------------------------------------------------------------------------+
 |  Externally defined global variables                                       |
 +----------------------------------------------------------------------------+
*/
extern VIDEOMODE  Modes[];                  /* Supported modes                */
extern FONTBUFFER Fonts[];                  /* Supported fonts                */
extern MEMORYMAPS MemoryMaps[];             /* Memory map info for each mode  */
extern short HugeShift;                     /* Huge shift value               */
extern USHORT ConfigFlag;
extern ULONG PartialSaveSize;   /* Room required to save entire PVB in the popup mode */
extern UCHAR READABLE;          /* Flag to determine if hardware is write-only */
extern USHORT VGA_PRESENT;      /* TRUE if VGA VDH has been installed */
extern VDHCONFIGINFO VGAConfigData;
extern USHORT (APIENTRY *ChainedCallVectorTable[MaxFn])();           /* @T24 */
extern VIDEOHARDWARE VideoHardware;  /* installed video hardware */
#ifdef  J_INSTALL                                                       //J-TS00V
extern VIDEOHARDWAREJ VideoHardwareJ;  /* installed video hardware */   //J-TS00V
#endif  //J_INSTALL                                                     //J-TS00V
extern USHORT OEMFlags;                                                 //MS27
extern USHORT SVGAPresent;                                              // @drw
extern ENVIRONMENT Env1;        /* Popup environment address */   /*@T42,@T42f*/
extern ENVIRONMENT Env2;        /* Harderr environment address */ /*@T42,@T42f*/

USHORT PASCAL near GetBIOSfonts(void);  /* get BIOS character font table */

extern CLUTDATA far SumCLUT;    /* @BB1 */
extern CLUTDATA far *LCLUT;     /* @BB1 */

extern UCHAR HarderrFlag;   // Harderr Flag - During HardError          @KK0622

extern SEL   CommonSelector;                /* Common Sel to XVIO     J-KK0929*/

extern HW_DEFAULT HW_Default[];            /* Default HW Data Table */  //J-TS00

/*
 +----------------------------------------------------------------------------+
 |  Internally defined global variables                                       |
 +----------------------------------------------------------------------------+
*/
extern USHORT hScreenDD; /* Handle to screen device driver ( for DosDevIOCtl ) */

/*
 +----------------------------------------------------------------------------+
 |  Parameters to ring 2 routines                                             |
 +----------------------------------------------------------------------------+
*/
extern USHORT IStart;

/**********************  START OF SPECIFICATIONS  ***********************/
/*                                                                      */
/*  SUBROUTINE NAME: PhysToUVirt                                        */
/*                                                                      */
/*  DESCRIPTIVE NAME: Allocate an LDT sel:off to physical memory        */
/*                                                                      */
/*  FUNCTION: PhysToUVirt is called by routines who need access to      */
/*            either the physical display buffer, or the ROM font.      */
/*            This routine calls the screen device driver (SCREEN$)     */
/*            via DosDevIOCtl who, in turn, issues a                    */
/*            DevHlp_PhysToUVirt call.                                  */
/*                                                                      */
/*  ENTRY POINT: PhysToUVirt                                            */
/*    LINKAGE:   CALL FAR                                               */
/*                                                                      */
/*  INPUT: (Passed on stack)                                            */
/*             FAR *PhysicalAddress ( Physical address )                */
/*             FAR *LDTAddress      ( Place to return LDT sel:off )     */
/*             USHORT Length        ( Size of physical memory area )    */
/*                                                                      */
/*  EXIT-NORMAL: AX = 0                                                 */
/*               LDT sel:off is returned to caller                      */
/*                                                                      */
/*  EXIT-ERROR: AX = DosDevIOCtl error                                  */
/*                                                                      */
/*  EFFECTS: NONE                                                       */
/*                                                                      */
/*  INTERNAL REFERENCES:                                                */
/*    ROUTINES: NONE                                                    */
/*                                                                      */
/*  EXTERNAL REFERENCES:                                                */
/*    ROUTINES: DosDevIOCtl                                             */
/*                                                                      */
/***********************  END OF SPECIFICATIONS  ************************/
USHORT near PhysToUVirt( PhysicalAddress, LDTAddress, Length ) /*@B15*/ /*@T30*/
FarAddress PhysicalAddress;
FarAddress far *LDTAddress;                                             /*@T30*/
USHORT Length;
{
USHORT rc;                                                              /*@T30*/
USHORT rc2,ActionTaken;                                                //SM04339
FarAddress ParmBlock;                                                   /*@T30*/

struct {
  FarAddress PhysicalAddress;
  short Length;
  } ParmList;

ParmList.PhysicalAddress.FullAddress = PhysicalAddress.FullAddress;
ParmList.Length                      = Length;

if ( !(rc = DosDevIOCtl( (PVOID)&ParmBlock, (PVOID)&ParmList,
                         0x75, 0x3, (HFILE)hScreenDD )) )               /*@T30*/
  *LDTAddress = ParmBlock;                                              /*@T30*/

/***********************************************************/          //SM04339
/* The following code was added to accomodate those apps   */          //SM04339
/* which may close file handles 0, 1 and 2.                */          //SM04339
/***********************************************************/          //SM04339

if (rc == ERROR_INVALID_HANDLE) {    /* reopen SCREEN$ */              //SM04339
    rc2 = DosOpen( SCREENDD_NAME, (PHFILE)&hScreenDD,                  //SM04339
        (PUSHORT)&ActionTaken, NO_SIZE, NO_ATTRIBUTES, OPEN_IF_EXISTS, //SM04339
        NO_INHERIT+DENY_NONE+READ_WRITE, RESERVED_LONG );              //SM04339

    if (!rc2) {
       if ( !(rc = DosDevIOCtl( (PVOID)&ParmBlock, (PVOID)&ParmList,   //SM04339
                            0x75, 0x3, (HFILE)hScreenDD )) )           //SM04339
         *LDTAddress = ParmBlock;                                      //SM04339
    } /* endif */
} /* endif */

return( rc );
}

/**********************  START OF SPECIFICATIONS  ***********************/
/*                                                                      */
/*  SUBROUTINE NAME: FreePhysToUVirt                                    */
/*                                                                      */
/*  DESCRIPTIVE NAME: Deallocate an LDT selector to physical memory     */
/*                                                                      */
/*  FUNCTION: FreePhysToUVirt is called by routines who are done        */
/*            accessing the memory allocated by PhysToUVirt.  This is   */
/*            done by calling the screen device driver (SCREEN$) via    */
/*            DosDevIOCtl who, in turn, issues a DevHlp_PhysToUVirt.    */
/*                                                                      */
/*  ENTRY POINT: FreePhysToUVirt                                        */
/*    LINKAGE:   CALL FAR                                               */
/*                                                                      */
/*  INPUT: (Passed on stack)                                            */
/*             USHORT LDTSelector  ( LDT selector to be deallocated )   */
/*                                                                      */
/*  EXIT-NORMAL: LDT selector is deallocated                            */
/*                                                                      */
/*  EFFECTS: NONE                                                       */
/*                                                                      */
/*  INTERNAL REFERENCES:                                                */
/*    ROUTINES: NONE                                                    */
/*                                                                      */
/*  EXTERNAL REFERENCES:                                                */
/*    ROUTINES: DosDevIOCtl                                             */
/*                                                                      */
/***********************  END OF SPECIFICATIONS  ************************/
void near FreePhysToUVirt( LDTSelector ) /*@B15*/
USHORT LDTSelector;
{
DosDevIOCtl( (PVOID)NULL, (PVOID)&LDTSelector, 0x71, 0x3, (HFILE)hScreenDD );
}

/**********************  START OF SPECIFICATIONS  ***********************/
/*                                                                      */
/*  SUBROUTINE NAME: SaveRestoreHW                                      */
/*                                                                      */
/*  DESCRIPTIVE NAME: Save or restore hardware state                    */
/*                                                                      */
/*  FUNCTION: SaveRestoreHW is called to save or restore the hardware   */
/*            state.                                                    */
/*                                                                      */
/*  ENTRY POINT: SaveRestoreHW                                          */
/*    LINKAGE:   CALL FAR                                               */
/*                                                                      */
/*  INPUT: (Passed on stack)                                            */
/*             ENVIRONMENT far *Environment                             */
/*             USHORT Direction  ( GET(for SAVE) or SET(for RESTORE) )  */
/*                                                                      */
/*  EXIT-NORMAL: Hardware state is saved or restored to or from the     */
/*               environment buffer.                                    */
/*                                                                      */
/*  EFFECTS: NONE                                                       */
/*                                                                      */
/*  INTERNAL REFERENCES:                                                */
/*    ROUTINES: NONE                                                    */
/*                                                                      */
/*  EXTERNAL REFERENCES:                                                */
/*    ROUTINES: AccessHardware, AccessRegister, AccessCLUT              */
/*                                                                      */
/***********************  END OF SPECIFICATIONS  ************************/
void PASCAL near SaveRestoreHW( Environment, Direction ) /*@B15*/
ENVIRONMENT far *Environment;
USHORT Direction;
{
REGDATA RegData;
REGADDRESS RegAddress;
USHORT ColorMode;
UCHAR One = 0x01;
USHORT VideoEnable;
UCHAR TempChar;
UCHAR TempMiscOut;

int SumCLUT_found,i,j;                                                  /*@BB1*/

#ifdef   XVIO                                                           //J-TS00
USHORT         Mode;                                                    //J-TS00
VIDEOMODE far *pCurMode;                                                //J-TS00
XVS_SETMODE    XvioMode;                                                //J-TS00
USHORT         xrc;                                                     //J-TS00
#endif                                                                  //J-TS00


  ColorMode = 1; /* All video mode are emulated by color hardware mode J-TS00 */

  if ( Direction == SET )                                               //J-TS00
    ForceToVGA( Environment );                                          //J-TS00
/*
 +----------------------------------------------------------------------------+
 |  Turn the video signal off to reduce snow                                  |
 +----------------------------------------------------------------------------+
*/
VideoEnable = 0; /* Turn video off */
AccessVideoEnable( ColorMode, SET, &VideoEnable );        /* ring 2 callgate */

#ifdef  XVIO                                                            //J-TS00
if ( Direction == SET ) {                                               //J-TS00
//------------------------------------------------------------------    //J-TS00
// BXVS Call SetMode                                                    //J-TS00
//------------------------------------------------------------------    //J-TS00
  Mode     = Environment->ModeIndex;                                    //J-TS00
  pCurMode = (VIDEOMODE far *)&Modes[Mode].cb;                          //J-TS00
  XvioMode.Length    = sizeof(XvioMode);                                //J-TS00
  XvioMode.Option    = FG_Session;              // Foreground           //J-TS00
  XvioMode.fbType    = pCurMode->fbType;                                //J-TS00
  XvioMode.color     = pCurMode->color;                                 //J-TS00
  XvioMode.col       = pCurMode->col;                                   //J-TS00
  XvioMode.row       = pCurMode->row;                                   //J-TS00
  XvioMode.hres      = pCurMode->hres;                                  //J-TS00
  XvioMode.vres      = pCurMode->vres;                                  //J-TS00
  XvioMode.fmt_ID    = pCurMode->fmt_ID;                                //J-TS00
  XvioMode.attrib    = pCurMode->attrib;                                //J-TS00
                                                                        //J-TS00
  XvioMode.BufferAddress =                                              //J-TS00
              MemoryMaps[pCurMode->MemMap].Start.FullAddress;           //J-TS00
  XvioMode.BufferLength  =                                              //J-TS00
              MemoryMaps[pCurMode->MemMap].TotalSize;                   //J-TS00
                                                                        //J-TS00
  if (( XvioMode.col == 82 ) ||     // 82x25 Mode ?                     //J-TS00
      ( Mode == ModeIndex_Real ))   // Real Mode ?                      //J-TS00
    XvioMode.SystemReserve = 0;                                         //J-TS00
  else                                                                  //J-TS00
    XvioMode.SystemReserve = SystemReserveLine;                         //J-TS00
                                                                        //J-TS00
  if ( XvioMode.fbType & GRAPHICS ) // Graphic Mode                     //J-TS00
    XvioMode.HWMode = 0;    // Means Current is the same as HW mode     //J-TS00
  else {                                                                //J-TS00
    if ( Mode  < ModeIndex_Real ) XvioMode.HWMode = 1;                  //J-TS00
    else                          XvioMode.HWMode = 0;                  //J-TS00
  }                                                                     //J-TS00
                                                                        //J-TS00
  XvioMode.Default_CursorColor                                          //J-TS00
                  = HW_Default[pCurMode->HW_Index].CursorColor;         //J-TS00
                                                                        //J-TS00
  XvioMode.Session = (UCHAR)Environment->SessionNum;                    //J-TS00
  xrc = XVIOVDHIF( XvsSetMode, (PUSHORT)&XvioMode );                    //J-TS00
}                                                                       //J-TS00
#endif                                                                  //J-TS00
                                                                        //J-TS00
/*                                                                      //J-TS00
 +--------------------------------------------------------------------+ //J-TS00
 |  Save the cursor color                                             | //J-TS00
 +--------------------------------------------------------------------+ //J-TS00
*/                                                                      //J-TS00
if ( Direction == GET ) {                                               //J-TS00
   Environment->CursorColor = GetCursorColor();                         //J-TS00
}                                                                       //J-TS00
                                                                        //J-TS00
/*                                                                      //J-TS00
 +--------------------------------------------------------------------+ //J-TS00
 |  Save the grid color                                               | //J-TS00
 +--------------------------------------------------------------------+ //J-TS00
*/                                                                      //J-TS00
if ( Direction == GET ) {                                               //J-TS00
   Environment->GridColor = GetGridDrawColor();                         //J-TS00
}                                                                       //J-TS00

/*   @tb25
 +----------------------------------------------------------------------------+
 |  If restore, set misc output reg to 25 MHz clock                           |
 +----------------------------------------------------------------------------+
*/
if ( Direction == SET ) {

   RegAddress.DataPort    = MiscOutputRegWrite;
   TempMiscOut = Environment->Hardware.MiscOutputReg;
   Environment->Hardware.MiscOutputReg &= 0xF3;
   AccessRegister( &RegAddress, Direction, &Environment->Hardware.MiscOutputReg );
}
/* end @tb25 */

/*
 +----------------------------------------------------------------------------+
 |  Save/Restore the sequencer registers                                      |
 +----------------------------------------------------------------------------+
*/
RegAddress.AddressPort = SeqAddressPort;
RegAddress.DataPort    = SeqDataPort;
RegAddress.ColorAdjust = NONE;
RegAddress.Flags       = Sequencers_CMD;

RegData.DataArea =
  &Environment->Hardware.Sequencers.All[ RegData.FirstEntry = 0x00 ];
RegData.NumEntries = 0x04+1;                           /* All registers   */
AccessHardware( &RegAddress, BYTES, ColorMode, Direction, &RegData );

/*
 +----------------------------------------------------------------------------+
 |  Save/Restore the CRT registers                                            |
 +----------------------------------------------------------------------------+
*/
RegAddress.AddressPort = CRTAddressPort;
RegAddress.DataPort    = CRTDataPort;
RegAddress.ColorAdjust = ColorAdjustment;
RegAddress.Flags       = NONE;

if ( Direction == SET ) {
  RegData.DataArea =
    &Environment->Hardware.CRTCtlRegs.All[ RegData.FirstEntry = 0x11 ];
  RegData.DataArea[0] &= 0x0F;             /* Clear b4-b7 of vert retrace end */
  RegData.NumEntries   = 1;                               /* vert retrace end */

  AccessHardware( &RegAddress, BYTES, ColorMode, SET, &RegData );
  }

RegData.DataArea =
  &Environment->Hardware.CRTCtlRegs.All[ RegData.FirstEntry = 0x00 ];

if ( Direction == SET )
  RegData.DataArea[0x11] |= 0x80;            /* Set b4-b7 of vert retrace end */

RegData.NumEntries = 0x18+1;                               /* All registers   */

AccessHardware( &RegAddress, BYTES, ColorMode, Direction, &RegData );

/*  @tb25
 +----------------------------------------------------------------------------+
 |  Save/Restore the miscellaneous output register                            |
 +----------------------------------------------------------------------------+
*/

RegAddress.DataPort    = Direction == GET ?
                            MiscOutputRegRead : MiscOutputRegWrite;

if ( Direction == SET )                                         /* @tb25  */
   Environment->Hardware.MiscOutputReg = TempMiscOut;           /* @tb25  */
AccessRegister( &RegAddress, Direction, &Environment->Hardware.MiscOutputReg );

/*
 +----------------------------------------------------------------------------+
 |  Save/Restore the attribute registers                                      |
 +----------------------------------------------------------------------------+
*/
RegAddress.AddressPort = AttAddressPort;
RegAddress.DataPort    = Direction == GET ?
                            AttDataReadPort : AttDataWritePort;
RegAddress.ColorAdjust = NONE;
RegAddress.Flags       = Attributes_CMD;

RegData.DataArea =
  &Environment->Hardware.Attributes.All[ RegData.FirstEntry = 0x00 ];
RegData.NumEntries = NUM_ATT_REGS;                         /* All registers   */

AccessHardware( &RegAddress, BYTES, ColorMode, Direction, &RegData );

/*
 +----------------------------------------------------------------------------+
 |  Save/Restore the graphics registers                                       |
 +----------------------------------------------------------------------------+
*/
RegAddress.AddressPort = GraphAddressPort;
RegAddress.DataPort    = GraphDataPort;
RegAddress.ColorAdjust = NONE;
RegAddress.Flags       = NONE;

RegData.DataArea =
  &Environment->Hardware.GraphicsRegs[ RegData.FirstEntry = 0x00 ];
RegData.NumEntries = 0x08+1;                               /* All registers   */

AccessHardware( &RegAddress, BYTES, ColorMode, Direction, &RegData );

/*
 +----------------------------------------------------------------------------+
 |  Save/Restore the color lookup table                                       |
 +----------------------------------------------------------------------------+
*/
RegData.DataArea =
  (UCHAR far *)&Environment->LookupTable[ RegData.FirstEntry = 0x00 ];
RegData.NumEntries = 0xFF+1;                               /* All registers   */

AccessCLUT( Direction, (CLUTDATA far * far *)&RegData );   /* ring 2 callgate */

/*
 +----------------------------------------------------------------------------+
 |  If the current CLUT is equivalent to SumCLUT set NO_CLR_BRST in fbtype    |
 +----------------------------------------------------------------------------+
*/

if ( ( Direction == SET )                                               /*@BB1*/
       && (( Environment->ModeData.fbType & NOT_MONO ) == NOT_MONO ) ){ /*@BB1*/

  SumCLUT_found=0;  /* Preset good return code BB1*/
  LCLUT = &SumCLUT; /* Set LCLUT equal to Summed CLUT for compare BB1*/

  for (i= 0x00; i < 0xFF+1; ) {                                         /*@BB1*/
    for (j= 0x00; j < 0x3F+1; i++, j++) {                               /*@BB1*/
      if((Environment->LookupTable[i].Red  != LCLUT[j].Red)             /*@BB1*/
          || (Environment->LookupTable[i].Green!= LCLUT[j].Green)       /*@BB1*/
             || (Environment->LookupTable[i].Blue != LCLUT[j].Blue)){   /*@BB1*/
           SumCLUT_found = 1;                                           /*@BB1*/
      }                                                                 /*@BB1*/
    }                                                                   /*@BB1*/
  }                                                                     /*@BB1*/
                                                                        /*@BB1*/
  if ( SumCLUT_found == 0 ){                                            /*@BB1*/
     Environment->ModeData.fbType |= NO_CLR_BRST;                       /*@BB1*/
  }                                                                     /*@BB1*/

}                                                                       /*@BB1*/

/*
 +----------------------------------------------------------------------------+
 |  Turn the video signal back on if Env flag is set  @C21                    |
 +----------------------------------------------------------------------------+
*/
if ( Environment->VideoEnable ) {                                       /*@C21*/
   VideoEnable = 1; /* Turn video on */
   AccessVideoEnable( ColorMode, SET, &VideoEnable );         /* ring 2 callgate */
}                                                                       /*@C21*/

Environment->Hardware.Sequencers.Regs.ClockingMode &= 0xDF;

/*
 +----------------------------------------------------------------------------+
 |  Interpret registers and update the mode data structure in the ENVB        |
 +----------------------------------------------------------------------------+
*/
if ( ( Environment->EnvFlags & ENVFLAG_3xBOX ) &&                       /*@T70*/
     ( Direction == GET ) ) {                                           /*@T70*/
}

}

/**********************  START OF SPECIFICATIONS  ***********************/
/*                                                                      */
/*  SUBROUTINE NAME: ExamineConfig                                      */
/*                                                                      */
/*  DESCRIPTIVE NAME: Examine display adapter configuration             */
/*                                                                      */
/*  FUNCTION: ExamineConfig is called by DevInit in order to verify     */
/*            the presence of the appropriate display adapter.          */
/*            In addition, info is obtained for late use by             */
/*            RetConfigInfo.  Starting addresses for ROM fonts are      */
/*            obtained.                                                 */
/*                                                                      */
/*  ENTRY POINT: ExamineConfig                                          */
/*    LINKAGE:   CALL FAR                                               */
/*                                                                      */
/*  INPUT: (Passed on stack)                                            */
/*             NONE                                                     */
/*         (Referenced)                                                 */
/*             Modes[] (global data - table of supported video modes )  */
/*             Fonts[] (global data - table of font areas )             */
/*                                                                      */
/*  EXIT-NORMAL: AX = 0                                                 */
/*                                                                      */
/*  EXIT-ERROR: AX = ERROR_VIO_BAD_ADAPTER or                           */
/*                   DosDevConfig error                                 */
/*                                                                      */
/*  EFFECTS: NONE                                                       */
/*                                                                      */
/*  INTERNAL REFERENCES:                                                */
/*    ROUTINES: PhysToUVirt, FreePhysToUVirt                            */
/*                                                                      */
/*  EXTERNAL REFERENCES:                                                */
/*    ROUTINES: DosDevConfig, CharFontBegin, CharFontEnd                */
/*                                                                      */
/***********************  END OF SPECIFICATIONS  ************************/
short PASCAL near ExamineConfig() /*@B15*/
{

USHORT        rc;
VDH_CONFIG VGAParmBlock;

#ifdef  J_INSTALL                                                       //J-TS00V
    if (!getVideoTypeJ()) {      /* ATLAS is installed ? */             //J-TS00V
        getVideoType();                                                 //J-TS00V
        VideoHardware.display    = VideoHardwareJ.Display;              //J-TS00V
        VideoHardware.memory     = VideoHardwareJ.Memory;               //J-TS00V
        VideoHardware.popupMode  = ModeIndex_ATLASCO80VGA;              //J-TS00V
        ConfigFlag              |= POWERUP;                             //J-TS00V
        PartialSaveSize          = 80L * 25L * 2L ;                     //J-TS00V
        VGA_PRESENT              = FALSE;                               //J-TS00V
        return NO_ERROR;                                                //J-TS00V
    } else {                                                            //J-TS00V
        VideoHardwareJ.Display = NoDisplay;     /* means no ATLAS */    //J-TS00V
    }                                                                   //J-TS00V
#endif  //J_INSTALL                                                     //J-TS00V

READABLE = TRUE;

rc = INIT_ERROR;                /* Initially, assume error */

/* getvideoType fails only if something is seriously       with the video system */
if ( getVideoType() != VDHERROR_NO_ADAPTER) {

/*
 +----------------------------------------------------------------------------+
 |  Display types:                                                            |
 |                 0 - 5151 mono             5 - IBM Japan 5550 mono          |
 |                 1 - 5153 color            6 - IBM Japan 5550 color         |
 |                 2 - 5154 enhanced         7 - IBM Japan 5570 color         |
 |                 3 - 8503 mono             8 - IBM Japan 5570 full page     |
 |                 4 - 8512/8513 color       9 - 8514 color                   |
 |                                          10 - PDP (Plasma Display Panel)   |
 |                                          11 - 8507_8604 mono               |
 |                                          12 - 8515 color                   |
 +----------------------------------------------------------------------------+
*/

  if (VideoHardware.fVideoType & VGA_BITS) {

      rc = NO_ERROR; /* at this point the installation will work */

/*
 +----------------------------------------------------------------------------+
 |  If the VGA doesn't have a display attatched to it, the VDH should fail    |
 |  to install UNLESS an 8514/A is present and has a display.                 |
 +----------------------------------------------------------------------------+
*/
      if ( VideoHardware.display == NoDisplay && !(VideoHardware.fVideoType & A8514_BITS) )
          rc = INIT_ERROR;
  }

  if ( !rc ) { /* Error Check #2 */
/*
 +----------------------------------------------------------------------------+
 |  Determine mode table starting point                                       |
 |  ( This is index 0 for all adapters except for the EGA, which can vary in  |
 |    memory size.  In this case, the index is 2 for memory size = 64K )      |
 +----------------------------------------------------------------------------+
*/

    IStart = 0;                            /* Start at begining of mode table */

/*----------------------------------------------------------------------*/
/*  Initialize values used in RetConfigInfo and GetMode                 */
/*----------------------------------------------------------------------*/
/*  All devices which support text modes can be powerup displays, @S16  */
/*----------------------------------------------------------------------*/

    ConfigFlag |= POWERUP;          /*@S16*/

/*
 +----------------------------------------------------------------------------+
 |  The presence of the VGA VDH is determined by a successful call to         |
 |  RetConfigInfo in the call vector table                                    |
 +----------------------------------------------------------------------------+
*/
    VGAParmBlock.Length        = sizeof( VDH_CONFIG );
    VGAParmBlock.Flags               = NONE;
    VGAParmBlock.ConfigDataPTR = (VDHCONFIGINFO far *)&VGAConfigData;

    VGAConfigData.cb = MinDLen_Config_PartSaveSz; /* Only need display type and partial save size */

    VGA_PRESENT = !ChainedVDHRetConfigInfo( (ENVIRONMENT far *)NULL,
                                          (VDH_INITENV far *)&VGAParmBlock,
                                          FnReturnConfigInfo );
/*
 +----------------------------------------------------------------------------+
 |  If power-up display, partial save size = 80x25x2 + maximum font length    |
 |  If not power-up display, partial save size = 0 ( never a popup )          |
 +----------------------------------------------------------------------------+
*/

    PartialSaveSize = 80L * 25L * 2L ;                  /* 80x25 text PVB */

    } /* Error Check #2 */
  } /* Error Check #1 */

return( rc );
}

/************************************************************************/
/*                                                                      */
   UCHAR PASCAL near ReadCMOS(Index)
/*                                                                      */
/* This function is used to read a byte out of CMOS configuration       */
/* memory.                                                              */
/*                                                                      */
/* INPUT:                                                               */
   UCHAR        Index;          // Index into CMOS
/*                                                                      */
/* OUTPUT:      None                                                    */
/*                                                                      */
/* RETURNS:     Value read from CMOS                                    */
/*                                                                      */
/************************************************************************/
{
HFILE   hDev;
USHORT  usAction;
UCHAR   CMOSRqst[2];
UCHAR   CMOSByte;

   CMOSRqst[0] = Index;
   CMOSRqst[1] = 1;     // Read 1 byte
   CMOSByte = 0;        // default to 0 if error occurs

   if (!DosOpen("CLOCK$",
                (PHFILE)&hDev,
                (PUSHORT)&usAction,
                NO_SIZE,
                NO_ATTRIBUTES,
                FILE_OPEN,
                OPEN_ACCESS_READONLY | OPEN_SHARE_DENYNONE,
                RESERVED_LONG)) {
        DosDevIOCtl(    (PVOID)&CMOSByte,
                        (PVOID)CMOSRqst,
                        (USHORT)0x60,   // function
                        (USHORT)13,     // category
                        hDev);
        DosClose(hDev);
   }
   return(CMOSByte);
}                                                              //MS25 - END

/*** J-KKJ ************  START OF SPECIFICATIONS  ***********************/
/*                                                                      */
/*  SUBROUTINE NAME: RestoreLVB                         J-KK            */
/*                                                                      */
/*  DESCRIPTIVE NAME: Restore Logical display buffer                    */
/*                                                                      */
/*  FUNCTION: RestoreLVB     is called by             RestoreEnv        */
/*            when either a partial or full display buffer save or      */
/*            restore is requested.                                     */
/*                                                                      */
/*  ENTRY POINT: RestoreLVB                                             */
/*    LINKAGE:   CALL FAR                                               */
/*                                                                      */
/*  INPUT: (Passed on stack)                                            */
/*             FAR *ParmBlock ( SaveEnv/RestoreEnv parameter block )    */
/*                                                                      */
/*  EXIT-NORMAL: AX = 0                                                 */
/*               LVB is restored.                                       */
/*                                                                      */
/*  EXIT-ERROR: AX = ERROR_VIO_MODE                                     */
/*                                                                      */
/*  EFFECTS: NONE                                                       */
/*                                                                      */
/*  INTERNAL REFERENCES:                                                */
/*                                                                      */
/*  EXTERNAL REFERENCES:                                                */
/*    ROUTINES: BufferUpdate                                            */
/*                                                                      */
/***********************  END OF SPECIFICATIONS  ************************/

USHORT PASCAL near RestoreLVB( ParmBlock, Environment )        /*J-KK129*/
VDH_SAVEREST far *ParmBlock;
ENVIRONMENT far *Environment;
{
USHORT rc;
ULONG Function;
VDH_BUFUP far *PShow;
VDH_BUFUP Show;

    Clear_PVB( Environment );       /* clear shadow & APA */            //J-TS00

    PShow                = &Show;
    Function             = FnTextBufferUpdate;
    PShow->Length        = 26;
    PShow->Flags         = 3;                   /* Both LVB and PVB */
    PShow->AppDataAddr   = MakeFarPTR( ParmBlock->PVBHugeSEL, 0 );
    PShow->LogicalBufSel = ParmBlock->PVBHugeSEL;
    PShow->Index         = 7;                   /* Write Cell String */
    PShow->StartRow      = 0;                   /* Start - TopLeft*/
    PShow->StartCol      = 0;
    PShow->RepeatFactor  = Environment->ModeData.col
                         * Environment->ModeData.row
                         * (Environment->ModeData.attrib+1);

    if ( HarderrFlag ) {    // During HardError Popup ?                @KK0622
                            // RestoreLVB request during HardError Popup.@KK0622
        Environment->Option |= Spe_Redrawn;                          //@KK0622
        rc = JBUFFERUPDATE( Environment, PShow, Function );          //@KK0622
        Environment->Option &= ~(USHORT)Spe_Redrawn; // Clear Bit      @KK0622
        HarderrFlag = 0;    // Clear Flag --> HardError End !!!        @KK0622

    } else {                                                       //@KK0622

        Environment->Option |= All_Redrawn;   // All Redrawn by Xvio. J-KK0206
        rc = JBUFFERUPDATE( Environment, PShow, Function );       /*J-KK0821*/
        Environment->Option &= ~(USHORT)All_Redrawn; // Clear Redrawn Bit.J-KK0206

    } /* endif */                                                  //@KK0622

    return( rc );
}

/**********************  START OF SPECIFICATIONS  ***********************/
/*                                                                      */
/*  SUBROUTINE NAME: ForceToVGA                                         */
/*                                                                      */
/*  DESCRIPTIVE NAME: Set Video mode VGA text (from SVGA)               */
/*                                                                      */
/*  FUNCTION: This routine calls chained BVHSVGA to set video mode      */
/*            VGA text mode from SVGA graphics mode.                    */
/*                                                                      */
/*  ENTRY POINT: ForceToVGA                                             */
/*    LINKAGE:   CALL FAR                                               */
/*                                                                      */
/*  INPUT: (Passed on stack)                                            */
/*             FAR *Environment ( Environment buffer for the session )  */
/*                                                                      */
/*  EXIT-NORMAL: AX = 0                                                 */
/*                                                                      */
/*  EXIT-ERROR: AX = ERROR_XXX                                          */
/*                                                                      */
/*  EFFECTS: NONE                                                       */
/*                                                                      */
/*  INTERNAL REFERENCES:                                                */
/*                                                                      */
/*  EXTERNAL REFERENCES:                                                */
/*    ROUTINES: None                                                    */
/*                                                                      */
/***********************  END OF SPECIFICATIONS  ************************/

USHORT PASCAL near ForceToVGA(Environment)
ENVIRONMENT far *Environment;
{
    static VIOMODEINFO ModeData  = { MinDLen_Mode_FormatID,             //J-TS00
                                     1, 4, 80, 25, 720, 400,            //J-TS00
                                     0, 1 };                            //J-TS00
    static VDH_MODE ParmBlockVGA = { sizeof(ParmBlockVGA),              //J-TS00
                                     UPDATE_HARDWARE,                   //J-TS00
                                     &ModeData };                       //J-TS00
    USHORT rc = NO_ERROR;                                               //J-TS00
                                                                        //J-TS00
    if (VGA_PRESENT && SVGAPresent)                                     //J-TS00
        rc = ChainedVDHSetMode(                                         //J-TS00
                (ENVIRONMENT far *)&Environment->VGAEnvironment,        //J-TS00
                &ParmBlockVGA, FnSetMode );                             //J-TS00
                                                                        //J-TS00
    return rc;                                                          //J-TS00
}                                                                       //J-TS00
