;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = VDHSTRUCT.INC
;*
;* DESCRIPTIVE NAME = Structure definitions for base video
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION  Structure definitions for base video
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*   03/25/89              132    DCR 132 changes
;*   04/11/91              1348   NAKADA, Enable DBCS support in Vio-Window, DCR 1348
;*   06/21/89  J-KKJ              KKJ, Norikae
;*   10/05/89  J-KK1005           KKJ, Sub_AttrState -> Sub_Option
;*   10/12/89  J-KK1012           KKJ, Get STRUC form VDHEQU.INC
;*   10/16/89  J-KK1016           KKJ, Add Hide and Redraw Structure
;*   10/17/89  J-KK1017           KKJ, Delete Japan Structure
;*   10/23/89  j-ys1023           for MS-Xvio support.
;*   10/25/89  J-KK1025           KKJ, Add Sub_attrnum and UserFont.
;*   10/26/89  J-KK1026           KKJ, Add LVB_Selector.
;*   11/01/89  J-KK1101           KKJ, Add Sub_attribute2
;*   11/17/89  J-KK1117           KKJ, Add CLSBUF structure
;*   11/20/89  J-KK1120           KKJ, Add EnvBuffID field
;*   02/13/90  J-KK0213           KKJ, Add XVS_LVBSelR field for Redraw.
;*
;*****************************************************************************/

;STJFMT,,16

DBCSEv_Size     equ     10              ;                              ;J-KK1213

VDHBUF          STRUC                   ; VDH BufferUpdate stack frame

; this is the saved BP from the caller                                  ;@P1

                dw      ?               ; BP of BVS

; these are local variables used by Buffer updated functions            ;@P1

PVB_Sel         dw      ?               ; Selector to the PVB or 0      ;@P1
LVB_Sel         dw      ?               ; Selector to the LVB or 0      ;@P1

mincol          dw      ?               ; left most column of the LVB   ;@P1
minrow          dw      ?               ; top most row of the LVB       ;@P1
maxcol          dw      ?               ; rigth most column of the LVB  ;@P1
maxrow          dw      ?               ; bottom most row of the LVB    ;@P1

cellsize        dw      ?               ; number of bytes per cell in LVB ;@P1
lvb_width       dw      ?               ; number of cells wide the LVB is ;@P1

ScrollFlags     dw      ?               ; flags for Scroll functions    ;@P1
FillCellLow     dw      ?               ; low word of the default cell  ;@P1
FillCellHigh    dw      ?               ; high word of the default cell ;@P1

RowsToFill      dw      ?               ; number of rows left blank by scroll ;@P1

LVBFillCount    dw      ?               ; number of bytes per fill row in LVB ;@P1
LVBFillSkip     dw      ?               ; number of bytes to next line in LVB ;@P1
LVBFillOff      dw      ?               ; beginning offset of fill rect in LVB ;@P1

PVBFillCount    dw      ?               ; number of bytes per fill row in PVB ;@P1
PVBFillSkip     dw      ?               ; number of bytes to next line in PVB ;@P1
PVBFillOff      dw      ?               ; beginning offset of fill rect in PVB ;@P1

RowsToMove      dw      ?               ; number of rows in rectangle to move ;@P1

LVBMoveCount    dw      ?               ; number of bytes per move row in LVB ;@P1
LVBMoveSkip     dw      ?               ; number of bytes to next row in LVB ;@P1
LVBMoveSrcOff   dw      ?               ; beginning of source move rect in LVB ;@P1
LVBMoveDestOff  dw      ?               ; beginning of dest move rect in LVB ;@P1

PVBMoveCount    dw      ?               ; number of bytes per move row in LVB ;@P1
PVBMoveSkip     dw      ?               ; number of bytes to next row in LVB ;@P1
PVBMoveSrcOff   dw      ?               ; beginning of source move rect in LVB ;@P1
PVBMoveDestOff  dw      ?               ; beginning of dest move rect in LVB ;@P1

leftfill        dw      ?               ; left most column of fill rectangle ;@P1
topfill         dw      ?               ; top most row of fill rectangle   ;@P1
rightfill       dw      ?               ; right most column of fill rectangle ;@P1
bottomfill      dw      ?               ; bottom most row of fill rectangle ;@P1

leftscroll      dw      ?               ; left most column of source rectangle ;@P1
topscroll       dw      ?               ; top most row of source rectangle ;@P1
rightscroll     dw      ?               ; right most column of source rectangle ;@P1
bottomscroll    dw      ?               ; bottom most row of source rectangle ;@P1

leftdest        dw      ?               ; left most column of destination rect ;@P1
topdest         dw      ?               ; top most row of destination rect ;@P1
rightdest       dw      ?               ; right most column of destination rect ;@P1
bottomdest      dw      ?               ; bottom most row of destination rect ;@P1

;;--------------  Japan Unique Work Area --------------------           ;J-KKJ
Sub_Format      dw      ?               ; Saved Format                  ;J-KK0828
Sub_Flags       dw      ?               ; Saved Request Flags           ;J-KK0828
Sub_Option      dw      ?               ; Option                        ;J-KK1005
Sub_index       dw      ?               ; Saved Function Index          ;J-KKJ
Sub_length      dw      ?               ; Adjusted Length               ;J-KKJ
Sub_offset      dw      ?               ; Adjusted Start Offset of LVB  ;J-KKJ
Sub_attribute   dw      ?               ; Attribute Save Area           ;J-KKJ
Sub_attribute2  dw      ?               ; Attribute Save Area No.2      ;J-KK1101
Sub_cols        dw      ?               ; Buffer (defaults LVB) Cols    ;J-KKJ
Sub_colors      dw      ?               ; Color number color / mono     ;j-ys711
Sub_attrnum     dw      ?               ; Attribute Number              ;J-KK1025
Sub_Buffsize    dw      ?               ; Buffer (defaults LVB) Size    ;J-KKJ
Sub_FONT        dw      ?               ; DBCS Chars Count              ;J-KKJ
Sub_FONTD       dw      ?               ; Buffer (Internal<->Regen)     ;J-KKJ
Sub_PVBend      dw      ?               ; Buffer ( PVB ) size           ;j-ys1023

Sub_DBCSEv      db      DBCSEv_Size dup (?) ; DBCS Environment          ;J-KK1213

;; For Scroll Operation                 ; Hide and Redraw               ;J-KK1016
XVS_Length      dw      ?               ;                               ;J-KK1016
XVS_Option      db      ?               ;                               ;J-KK1016
XVS_Session     db      ?               ;                               ;J-KK1016
XVS_StartRow    dw      ?               ;                               ;J-KK1016
XVS_EndRow      dw      ?               ;                               ;J-KK1016
XVS_LVBSelR     dw      ?               ;                               ;J-KK0213

;; For conversion from shadow buffer to APA (used in UpdateRegen)
APA_from        dw      ?               ; APA must be updated from ...  ;J-TS00
APA_cnt         dw      ?               ; Updated character counter     ;J-TS00
APA_ColorMono   dw      ?               ; display mode                  ;J-TS00

;; variables for scroll function
APAMoveCount    dw      ?               ; number of bytes per move row in APA  ;J-TS00
APAMoveSkip     dw      ?               ; number of bytes to next row in APA   ;J-TS00
APAMoveSrcOff   dw      ?               ; beginning of source move rect in APA ;J-TS00
APAMoveDestOff  dw      ?               ; beginning of dest move rect in APA   ;J-TS00

MoveSrcOff      dw      ?               ; source offset exchange area   ;J-TS00
MoveDestOff     dw      ?               ; dest   offset exchange area   ;J-TS00

MoveFlag        dw      ?               ; dirty flag for shadow scroll  ;J-TS00
ColSrcHead      db      ?               ; source head clear color       ;J-TS00
ColSrcTail      db      ?               ; source tail clear color       ;J-TS00
ColDstHead      db      ?               ; dest   head clear color       ;J-TS00
ColDstTail      db      ?               ; dest   tail clear color       ;J-TS00

;; variables for fill rect function
APAFillCount    dw      ?               ; number of bytes per fill row in APA  ;J-TS00
APAFillSkip     dw      ?               ; number of bytes to next line in APA  ;J-TS00
APAFillOff      dw      ?               ; beginning offset of fill rect in APA ;J-TS00

;; variables for set APA write color
APAPrevColor    dw      ?               ; previously setted color back up ;J-TS00

DBCSGetStrucLen dw      ?               ; FNTGETIMAGEADDR param struc length
DBCSFont        dd      ?               ; DBCS font image address

WORK_END        dw      ?               ; Dummy                         ;J-KKJ
;;-----------------------------------------------------------           ;J-KKJ

; this was on the stack before we got here

                dw      ?               ; IP of BVS                     ;@P1
;;J-KK129       dw      ?               ; CS of BVS                     ;@P1
FuncNumLo       dw      ?               ; BufferUpdate function number  ;@P1
FuncNumHi       dw      ?               ; 
ParmBuf         dd      ?               ; Selector:offset of paramter buffer ;@P1
EnvBufParm      dd      ?               ; Selector:offset of environment buffer ;@P1

VDHBUF          ENDS


;   The following are equates used for the Xvio Interface.              J-KK1017
XVS_LVBSel      equ     XVS_StartRow    ; LVB Selecter for Xvio         J-KK1017


;   The Read and Write routines use a different set or local variables  ;@P1
;   than the Scroll functions do.  The following are aliases for elements ;@P1
;   of the local variable frame used by the Read and Write routines.    ;@P1

lvb_height      equ     ScrollFlags     ; number of rows in LVB         ;@P1
FirstRow        equ     RowsToFill      ; number of cells or bytes in first row ;@P1
RowLength       equ     LVBFillSkip     ; number of cells or bytes in later rows ;@P1
LVBCount        equ     LVBFillCount    ; number of cells or bytes to move, LVB ;@P1
LVBOff          equ     LVBFillOff      ; offset for read or write in LVB ;@P1
PVBSkip         equ     PVBFillSkip     ; number of bytes to next row in PVB ;@P1
PVBCount        equ     PVBFillCount    ; number of cells or bytes to move, PVB ;@P1
PVBOff          equ     PVBFillOff      ; offset for read or write in LVB ;@P1

;   The following are equates used for the archaic CGA routines.        ;@P1
;   This is only to avoid build problems until the routines get updated.;@P1

BottomRow       equ     ScrollFlags     ;                               ;@P1
LeftCol         equ     RowsToFill      ;                               ;@P1
LineLength      equ     LVBFillSkip     ;                               ;@P1
Retrace         equ     LVBFillCount    ;                               ;@P1
RightCol        equ     LVBFillOff      ;                               ;@P1
ScrollCount     equ     PVBFillSkip     ;                               ;@P1
SkipLength      equ     PVBFillCount    ;                               ;@P1
TopRow          equ     PVBFillOff      ;                               ;@P1

;   These are the values used in the Read and Write routines            ;@P1
;
; [bp].PVB_Sel
; [bp].LVB_Sel
;
; [bp].EnvBufParm
; [bp].FirstRow
; [bp].FuncNumHi
; [bp].FuncNumLo
; [bp].LVBCount
; [bp].LVBOff
; [bp].PVBSkip
; [bp].PVBCount
; [bp].PVBOff
; [bp].ParmBuf
; [bp].RowLength

; [bp].PVB_Sel
; [bp].cellsize
; [bp].lvb_height
; [bp].lvb_width
; [bp].mincol
; [bp].minrow
; [bp].maxcol
; [bp].maxrow
;
;
;   These are the values used in the Scrollxx routines

; [bp].PVB_Sel
; [bp].LVB_Sel

; [bp].maxcol
; [bp].maxrow
; [bp].mincol
; [bp].minrow

; [bp].cellsize
; [bp].lvb_width

; [bp].ScrollFlags
; [bp].FillCellHigh
; [bp].FillCellLow

; [bp].RowsToFill

; [bp].LVBFillCount
; [bp].LVBFillOff
; [bp].LVBFillSkip

; [bp].PVBFillCount
; [bp].PVBFillSkip
; [bp].PVBFillOff

; [bp].RowsToMove

; [bp].LVBMoveCount
; [bp].LVBMoveSkip
; [bp].LVBMoveDestOff
; [bp].LVBMoveSrcOff

; [bp].PVBMoveCount
; [bp].PVBMoveDestOff
; [bp].PVBMoveSkip
; [bp].PVBMoveSrcOff

; [bp].leftdest
; [bp].topdest
; [bp].rightdest
; [bp].bottomdest

; [bp].leftfill
; [bp].topfill
; [bp].rightfill
; [bp].bottomfill

; [bp].leftscroll
; [bp].topscroll
; [bp].rightscroll
; [bp].bottomscroll


VDHPARM         STRUC                   ; VDH BufferUpdate parameter structure

ParmLength      dw      ?               ; Length parameter block buffer
Flags           dw      ?               ; Source/target buffer (LVB, PVB)
AppDataAddr     dd      ?               ; Address of application data buffer
AppCellAddr     dd      ?               ; Address of char, attr, or cell
FuncIndex       dw      ?               ; Sub-function number
Row             dw      ?               ; Starting row
Col             dw      ?               ; Starting column
Row2            dw      ?               ; Secondary row or ending row
Col2            dw      ?               ; Secondary column or ending column
RepeatFactor    dw      ?               ; # of chars, cells, rows, or cols
LogicalBufSel   dw      ?               ; LVB selector
TouchXLeft      dw      ?               ; left most col touched by the write) ;@P1
TouchYTop       dw      ?               ; top most col touched by the write) ;@P1
TouchXRight     dw      ?               ; right most col touched by the write) ;@P1
TouchYBottom    dw      ?               ; bottom most col touched by the write) ;@P1
LVBRowOff       dw      ?               ; row offset of the LVB relative to PVB ;@P1
LVBColOff       dw      ?               ; col offset of the LVB relative to PVB ;@P1
LVBWidth        dw      ?               ; width of the LVB in cells     ;@P1
LVBHeight       dw      ?               ; height of the LVB in cells    ;@P1
LVBFormatID     db      ?               ; format id of the LVB          ;@P1
LVBAttrCount    db      ?               ; number of attributes in the LVB ;@P1

VDHPARM         ENDS


;;ͻ
;; Caution !!! This area must be identical to ENVIRONMENT structure in VDH.H.
;;ͼ
VDHENV          STRUC                   ; VDH environment buffer structure

ModeDataOff     dw      ?               ; Offset to mode data in env. buffer

ModeIndex_Env   db      ?               ; Mode Index in Mode Table
EnvBuffID       dd      ?               ; Environment Buffer ID         J-KK1120
EnvFlags        dw      ?               ; Enviroment Flags
SessionNum_Env  dw      ?               ; To support the Font and Xvio.
Physaddrsel     dw      2 dup (?)       ; To support Real Mode
Phxplanessel    dw      8 dup (?)       ; 

FormatIndex     dw      ?               ; Format Index for BufferUpdate J-KK1017
ScreenSize      dw      ?               ; Screen Size 80*25*2           J-KK1017
Option          dw      ?               ; Blink/Hint & FontCall Option  J-KK1017
FormatChanged   db      ?               ; Format Changed Flag           J-KK1017
DBCSEvBuff      db      DBCSEvBuffSize dup (?) ; DBCS Ev Buffer         J-KK1017
UserFont        dw      ?               ; -1  - SELECTABLE, -2 - NOT_SELECTABLE
                                        ; 0   - None                    J-KK1025
LVB_Selector    dw      ?               ; LVB Selector (Not CA Selector)J-KK1026
VDHENV          ENDS


MODEDAT         STRUC                   ; VDH mode data structure

ModeLength      dw      ?               ; Length of parameter buffer
ModeType        db      ?               ; Mode type bits
Color           db      ?               ; Color value
TextCols        dw      ?               ; # of text columns in current mode
TextRows        dw      ?               ; # of text rows in current mode
HorizRes        dw      ?               ; Horizontal pel resolution
VertRes         dw      ?               ; Vertical pel resolution
AttrFormat      db      ?               ; Attribute format
NAttributes     db      ?               ; # of attribute in character cell
BufferAddrLo    dw      ?               ; Physical address of PVB
BufferAddrHi    dw      ?               ; 
BufferLenLo     dw      ?               ; Length of PVB in current mode
BufferLenHi     dw      ?               ; 
FullBufSizeLo   dw      ?               ; Size of LVB for PVB save
FullBufSizeHi   dw      ?               ; 
PartBufSize     dd      ?               ;@P1
ExtData         dd      ?               ;@P1
ScrlRectLeft    dw      ?               ;@P1
ScrlRectTop     dw      ?               ;@P1
ScrlRectRight   dw      ?               ;@P1
ScrlRectBottom  dw      ?               ;@P1

MODEDAT         ENDS

;;                                      ;                               J-KK1117
CLSBUF          STRUC                   ; Clear LVB stack frame
                dw      ?               ; BP
                dw      ?               ; IP
CLS_LVBSize     dw      ?               ; LVB Size
CLS_LVBSel      dw      ?               ; LVB Selector
CLS_Format      dw      ?               ; Format ID
CLSBUF          ENDS
