;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = VDHPRT.INC
;*
;* DESCRIPTIVE NAME = DEFINITIONS FOR SCREEN PRINT FUNCTION
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR    CHANGE DESCRIPTION
;*   --------  ----------  -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx   xxxxxxx
;*   10/25/89  J-KK1025            KKJ, Add Prt_UserFont
;*   10/27/89  J-KK1027            KKJ, Add Prt_Session
;*   11/10/89  J-KK1110            KKJ, Add USER_SBCS
;*   04/19/90  @KK0419             KKJ, Add Remote_Handle EQU  ( PTR702 )
;*   02/17/92  J-TS0217            TSO, PTR B729215 of CP20
;*
;*****************************************************************************/

;STJFMT,,16

PRTSC           equ     0               ;; <=====

Remote_Handle   equ     8000h           ; Remote Handle Bit             @KK0419

fn_PrintScreen  equ     115h
MAX_OUTBUF      equ     164
CRLF            EQU     0A0DH           ;eol marker

;; Print Cell Attribute
DBCS_CHAR2      equ     80h
UNDERLINE       equ     40h
H_GRID          equ     20h
V_GRID          equ     10h
H_INT           equ     08h
USER_SBCS       equ     04h             ; User SBCS Font                J-KK1110
EXT_SBCS        equ     02h             ; Extra SBCS
DBCS_CHAR       equ     01h
GRID            equ     H_GRID+V_GRID


;; Sub_Real
PReal_Mode      equ     1
PGraphic_Mode   equ     2


VDHPRT          STRUC                   ; VDH Print Screen stack frame
; this is the saved BP from the caller                                  ;@P1

                dw      ?               ; BP of BVS

; these are local variables used by Print Screen functions

Prt_Flags       dw      ?               ; 
Prt_LVB_Sel     dw      ?               ; LVB Selecter (For Real)
Prt_Handle      dw      ?               ; Printer Handle
Prt_Format      dw      ?               ; Format Index
Prt_cols        dw      ?               ; Cols
Prt_rows        dw      ?               ; Rows
Prt_colors      dw      ?               ; Rows
Prt_attr        dw      ?               ; Attribute Count
Prt_formatid    dw      ?               ; Format
Prt_Length      dw      ?               ; Buffer Length
Prt_RetLen      dw      ?               ; Return Length
Prt_UserFont    dw      ?               ; User Font                     J-KK1025
Prt_Session     dw      ?               ; Session Number                J-KK1027

IFNDEF INSTALL                                                           ;J-EA44
;; For PrtSc  Operation                 ; Hide and Redraw                ;J-EA44
Ptr_XVS_Length      dw      ?           ;                                ;J-EA44
Ptr_XVS_Option      db      ?           ;                                ;J-EA44
Ptr_XVS_Session     db      ?           ;                                ;J-EA44
Ptr_XVS_StartRow    dw      ?           ;                                ;J-EA44
Ptr_XVS_EndRow      dw      ?           ;                                ;J-EA44
Ptr_XVS_LVBSelR     dw      ?           ;                                ;J-EA44
ENDIF   ;IFNDEF INSTALL                                                  ;J-EA44

Prt_WORK_END    dw      ?               ; Dummy                         ;J-KKJ
;;-----------------------------------------------------------           ;J-KKJ

; this was on the stack before we got here

                dw      ?               ; IP of BVS                     ;@P1
Prt_FuncNumLo   dw      ?               ; BufferUpdate function number  ;@P1
Prt_FuncNumHi   dw      ?               ; 
Prt_ParmBuf     dd      ?               ; Selector:offset of paramter buffer ;@P1
Prt_EnvBufParm  dd      ?               ; Selector:offset of environment buffer ;@P1

VDHPRT          ENDS


VDHPRTSC_PARM         STRUC                   ; VDH BufferUpdate parameter structure

PSC_ParmLength  dw      ?               ; Length parameter block buffer
PSC_Flags       dw      ?               ; 
PSC_LVB_Sel     dw      ?               ; LVB Selecter
PSC_Handle      dw      ?               ; Printer Handle

VDHPRTSC_PARM         ENDS
