;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE    60,132
        TITLE   VDHPRT.ASM -- Print Screen

;/*****************************************************************************
;*
;* SOURCE FILE NAME = VDHPRT.ASM
;*
;* DESCRIPTIVE NAME = BVS Print Screen
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION
;*
;* FUNCTIONS    VDHPrtSc
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES  NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVIY =
;*   DATE      FLAG       APAR    CHANGE DESCRIPTION
;*   --------  ---------- -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx xxxxx   xxxxxxx
;*   10/17/89  J-KK1017           KKJ, Delete JapanOFFOFF
;*   10/18/89  J-KK1018           KKJ, Fixed Bug
;*   10/25/89  J-KK1025           KKJ, Print of User Font.
;*   10/27/89  J-KK1027           KKJ, Implement User Font Handling with ESC SEQ (08H Extra)
;*   11/10/89  J-KK1110           KKJ, Change User Font Print Logic.
;*   11/27/89  J-KK1127           KKJ, DBCS 2nd may be 20h.
;*   12/11/89  J-KK1211           KKJ, DCR28 - Print Screen to LAN Server.
;*   03/14/90  J-EA44             EA,  Fixed invisible XVIO window in 3XBOX when PTRSC.
;*   04/19/90  @KK0419            KKJ, Check Remote or Local. PTR702
;*   05/10/90  @kk0510            KKJ,     fix in Common DBCS/ATLAS 3 byte mode.
;*   07/25/90  @KK0725            KKJ, Minor     fix in CheckHandleType.
;*   01/11/91  @XVIO              KKJ, DCR JC13 131.1 DosLoadModule of XVIO
;*   11/26/91  @KK1126            KKJ, PRT IOCTL returns ERROR under 2.0  JC20-JS02233
;*   03/03/94  KAZZ01             KAZZ,BUSY bit of the printer status should NOT be checked.
;****************************************************************************/

        .286p                           ; 286 protect mode instructions

        .xlist
        INCLUDE struc.inc               ; Structure macro
        INCLUDE error.inc               ; Subsystem error equates       @KK1126
        INCLUDE error2.inc              ; Subsystem error equates
        INCLUDE vdhprt.inc              ; Print Screen  data structures and equ
        INCLUDE vdhequ.inc              ; Buffer update equates
        INCLUDE vdhstruc.inc            ; Buffer update data structures
        INCLUDE xgamac.inc              ;                               @P1
        .list

;STJFMT,,16

                EXTRN   DOSWRITE:FAR    ;Dos Write via File Handle
                EXTRN   DOSDEVIOCTL:FAR ;DOS IOCtl (DevDrvr interface)
                EXTRN   DOSQHANDTYPE:FAR ;Check Handle Type         ;@KK0419

IFDEF           FONT_SUPPORT
                EXTRN   FNTGETSOURCE:FAR ;To FNTCALLS
ENDIF

IFNDEF          INSTALL
                EXTRN   XVIOVDHIF:NEAR  ;                                @XVIO
ENDIF                                   ;IFNDEF INSTALL

IFDEF           PRTSC
_DATA           SEGMENT WORD PUBLIC 'DATA' ; 

PrtSc_Buffer    db      MAX_OUTBUF dup (' ') ;PrtScr Work Buffer
                public  PrtSc_Buffer
PrtSc_Buffer_End label  byte

PrtSc_CellBuffer db     MAX_OUTBUF dup (' ') ;PrtScr Cell Buffer
                public  PrtSc_CellBuffer

;; Uni-direct Mode and Grid
;; Must set grid line length & parameters
cmn_uni_grid    db      1bh,25h,55h     ;\87-05-13 mak
                db      1bh,7eh,16h,00h,00h,01h ; XXXXX         ;\87-05-13 mak
;;                                  A   A           A
;;                                  |   |           |
;;                      Caution =>  Hi  Low         |
;;                                   Length Bytes  Grid Attribute
cmn_uni_grid_Len equ    $-cmn_uni_grid


;; CRLF and Bi-direct Mode
cmn_crlf_bi     db      0dh,0ah,1bh,25h,42h ;\87-05-13 mak
cmn_crlf_bi_Len equ     $-cmn_crlf_bi

;; Set/Reset UnderLine
cmn_start_ulne  db      1bh,7eh,11h,00h,01h,01h ;\87-05-13 mak
cmn_start_ulne_Len equ  $-cmn_start_ulne
cmn_end_ulne    db      1bh,7eh,11h,00h,01h,00h ;\87-05-13 mak
cmn_end_ulne_Len equ    $-cmn_end_ulne

;; Set/Reset Double Strike
cmn_start_dstk  db      1bh,7eh,0eh,00h,01h,19h ;\87-05-13 mak
cmn_start_dstk_Len equ  $-cmn_start_dstk
cmn_end_dstk    db      1bh,7eh,0eh,00h,01h,1ah ;\87-05-13 mak
cmn_end_dstk_Len equ    $-cmn_end_dstk

;; Set/Reset EXTRA SBCS
                                        ;must set extension font id
;;J-KK1027 cmn_start_exfnt db      1bh,7eh,64h,00,06,00,01,00,00,00,00 ;
cmn_start_exfnt db      1bh,7eh,64h,00,08,00,00,00,00,00,00,00,00 ;     J-KK1027
cmn_start_exfnt_Len equ $-cmn_start_exfnt ; 
;;J-KK1027 cmn_end_exfnt   db      1bh,7eh,64h,00,06,00,00,00,00,00,00 ;
cmn_end_exfnt   db      1bh,7eh,64h,00,08,00,00,00,00,00,00,00,00 ;     J-KK1027
cmn_end_exfnt_Len equ   $-cmn_end_exfnt ; 

;; Set/Reset User Font SBCS
                                        ;must set extension font id
cmn_start_uffnt db      1bh,7eh,64h,00,08,00,00,00,00,00,00,00,00 ;     J-KK1027
cmn_start_uffnt_Len equ $-cmn_start_uffnt ;                             J-KK1027
cmn_end_uffnt   db      1bh,7eh,64h,00,08,00,00,00,00,00,00,00,00 ;     J-KK1027
cmn_end_uffnt_Len equ   $-cmn_end_uffnt ;                               J-KK1027

;; Print All Characters
cmn_tr_1byte    db      1bh,7eh,08h,00h,01h ;\87-05-13 mak
cmn_tr_1byte_Len equ    $-cmn_tr_1byte


ESC_Table       label   word
CRLF_BI         equ     0
Set_UL          equ     1
Reset_UL        equ     2
Set_DS          equ     3
Reset_DS        equ     4
Set_EXT         equ     5
Reset_EXT       equ     6
Set_UF          equ     7
Reset_UF        equ     8
Prt_Transp      equ     9

;; CRLF and Bi-direct Mode
                dw      cmn_crlf_bi_Len
                dw      offset cmn_crlf_bi

;; Set/Reset UnderLine
                dw      cmn_start_ulne_Len
                dw      offset cmn_start_ulne
                dw      cmn_end_ulne_Len
                dw      offset cmn_end_ulne

;; Set/Reset Double Strike
                dw      cmn_start_dstk_Len
                dw      offset cmn_start_dstk
                dw      cmn_end_dstk_Len
                dw      offset cmn_end_dstk

;; Set/Reset EXTRA SBCS
                dw      cmn_start_exfnt_Len
                dw      offset cmn_start_exfnt
                dw      cmn_end_exfnt_Len
                dw      offset cmn_end_exfnt

;; Set/Reset User Font
                dw      cmn_start_uffnt_Len
                dw      offset cmn_start_uffnt
                dw      cmn_end_uffnt_Len
                dw      offset cmn_end_uffnt

;; All Print
                dw      cmn_tr_1byte_Len
                dw      offset cmn_tr_1byte

;; Current Printer Mode
cmn_pmode       db      0

;; IOCTL Params
cmn_prtsc_ioctl dw      0               ;For printer IOCtrl PrtScr
cmn_ioctl_flag  dw      0               ;For printer IOCtrl PrtScr
cmn_prtsc_parm  db      0               ;For printer IOCtrl PrtScr

;; Handle Type                   ;Check Printer Handle Type @KK0419
PrtSc_HandleType dw     0               ;@KK0419
PrtSc_HandleFlag dw     0               ;@KK0419

_DATA           ENDS
ENDIF

R2CSEG          SEGMENT WORD    PUBLIC 'CODE'
                ASSUME  CS:R2CSEG,DS:NOTHING,ES:NOTHING



JVdhPrtSc       PROC    near
                public  JVDHPRTSC
IFDEF           PRTSC

                sub     sp, Prt_WORK_END-Prt_Flags+2 ;Allocate storage for: PVB selector J-KKJ
                push    bp              ; Save caller's BP
                mov     bp, sp          ; Establish parameter addressability
                pusha                   ; Save all registers
                push    ds              ; 
                push    es              ; 

                mov     ax,-1           ;Preset PMERR_DEV_FUNC_NOT_INSTALLED
                .if     <[bp].Prt_FuncNumLo e fn_PrintScreen> near

                    lds     si, [bp].Prt_ParmBuf ; DS:SI -> parameter buffer
                    mov     ax, [si].PSC_Flags ; Get  Flags
                    mov     [bp].Prt_Flags, ax ; Save
                    mov     ax, [si].PSC_LVB_Sel ; Get  LVB Sel
                    mov     [bp].Prt_LVB_Sel, ax ; Save
                    mov     ax, [si].PSC_Handle ; Get  Printer Handle
                    mov     [bp].Prt_Handle, ax ; 

                    les     di, [bp].Prt_EnvBufParm ; ES:DI -> environment buffer
                    push    di
                    add     di, es:[di].ModeDataOff ; ES:DI -> mode data structure
                    xor     ah, ah      ; 
                    mov     al, es:[di].mode_colors ; Colors
                    mov     [bp].Prt_colors, ax ; 
                    test    byte ptr es:[di].mode_type, GRAPHICS_MODE
                    pop     di
                    .if     < nz >      ; Graphic Mode

IFNDEF                  V20             ;                               @KK1126
                        test    byte ptr es:[di].EnvFlags, ENVFLAG_3xBOX
                        .if     < nz >  ; Real
;;
;; Real Graphic Mode
;;

IFNDEF                      INSTALL     ;                               J-EA44
;                                       ;; Suspend XVIO during print screen J-EA44
                            mov     byte ptr [bp].Ptr_XVS_Option,0 ;    J-EA44
                            mov     ax,es:[di].SessionNum_Env ;Session ID;J-EA44
                            mov     [bp].Ptr_XVS_Length,4 ;Length       ;J-EA44
                            mov     [bp].Ptr_XVS_Session,al ;           ;J-EA44
                            mov     byte ptr [bp].Ptr_XVS_Option,0 ;    @XVIO
                            push    XvsSuspend ;                         J-EA44
                            push    ss  ;                                J-EA44
                            lea     ax,[bp].Ptr_XVS_Length ;             J-EA44
                            push    ax  ;                                J-EA44
                            Call    XVIOVDHIF ;                          J-EA44
ENDIF                                   ;IFNDEF INSTALL                 ;J-EA44

;--- If graphic mode then call PrtIOCtrl -----------------------;
                            mov     ax, _DATA
                            mov     ds, ax
                            mov     ds:[cmn_ioctl_flag], 0002h ; Graphic Mode
                            .if     < <byte ptr [bp].Prt_colors> ne 1 >
                                or      byte ptr ds:[cmn_ioctl_flag], 4 ; Color
                            .endif
                            mov     ds:[cmn_prtsc_ioctl],0604h ;Len=4 S-Func=6 ;
                            push    ds  ; 
                            push    offset cmn_prtsc_ioctl ; 
                            push    ds  ; 
                            push    offset cmn_prtsc_parm ; 
                            push    47h ; 
                            push    05h ; 
                            push    [bp].Prt_Handle ; 
                            Call    DOSDEVIOCTL ; 

IFNDEF                      INSTALL     ;                                J-EA44
                            push    ax  ;                                J-EA44
                                        ;; Resume XVIO                   J-EA44
                            mov     byte ptr [bp].Ptr_XVS_Option,0 ;     J-EA44
                            mov     ax,es:[di].SessionNum_Env ;Session ID J-EA44
                            mov     [bp].Ptr_XVS_Session,al ;            J-EA44
                            mov     [bp].Ptr_XVS_Length,4 ;Length        J-EA44
                            mov     byte ptr [bp].Ptr_XVS_Option,0 ;     @XVIO
                            push    XvsResume ;                          J-EA44
                            push    ss  ;                                J-EA44
                            lea     ax,[bp].Ptr_XVS_Length ;             J-EA44
                            push    ax  ;                                J-EA44
                            Call    XVIOVDHIF ;                          J-EA44
                            pop     ax  ;                                J-EA44
ENDIF                                   ;IFNDEF INSTALL                  J-EA44

                            .if     < nonzero ax >
                                jmp     Error_PrtSc
                            .endif
                        .endif
ENDIF                                   ;                               @KK1126

                    .else   near        ; Text Mode
;; Set Parameters
                        les     di, [bp].Prt_EnvBufParm ; ES:DI -> environment buffer

                        mov     ax, es:[di].FormatIndex ; Get Format  J-KK1017
                        mov     [bp].Prt_Format, ax ; Save Format Index
                        mov     ax, es:[di].UserFont ; User Font Flag
                        mov     [bp].Prt_UserFont, ax ; Save
                        mov     ax, es:[di].SessionNum_Env ; Get Session Number
                        mov     [bp].Prt_Session, ax ; Save

                        add     di, es:[di].ModeDataOff ; ES:DI -> mode data structure
                        xor     ah, ah
                        mov     al, es:[di].mode_attrcount ; Attribute#
                        mov     [bp].Prt_attr, ax ; 
                        mov     al, es:[di].mode_formatid ; Format ID
                        mov     [bp].Prt_formatid, ax ; 
                        mov     ax, es:[di].mode_cols ; Cols
                        mov     [bp].Prt_cols, ax ; 
                        mov     ax, es:[di].mode_rows ; Rows
                        mov     [bp].Prt_rows, ax ; 

;; Set DS & ES to _DATA
                        mov     ax, _DATA
                        mov     ds, ax
                        mov     es, ax

;; Check Printer Handle Type                                            ;@KK0419
                        push    [bp].Prt_Handle ; Printer Handle        ;@KK0419
                        push    ds      ;                               ;@KK0419
                        push    offset PrtSc_HandleType ;               ;@KK0419
                        push    ds      ;                               ;@KK0419
                        push    offset PrtSc_HandleFlag ;               ;@KK0419
                        Call    DOSQHANDTYPE ;                          ;@KK0419
                        .if     < nonzero ax > ;                        ;@KK0419
;;@KK0725                   mov     word ptr ds:[PrtSc_HandleFlag], 0 ; Clear Handle Type ;@KK0419
                            mov     word ptr ds:[PrtSc_HandleType], 0 ; Clear Handle Type ;@KK0725
                        .endif          ;                                       ;@KK0419

;; Set Font-ID for Extra Hankaku
                        mov     ax, [bp].Prt_Session ; Get Session Number
                        mov     ah, 2   ; Extra Hankaku
                        mov     di, Offset cmn_start_exfnt + 5 ; Offset to save
                        Call    Set_FontID ; Get Font ID

;; Set Font-ID for User  Hankaku
                        .if     < [bp].Prt_UserFont e -1 > ; User Font Active
                            mov     ax, [bp].Prt_Session ; Get Session Number
                            mov     ah, 1 ; Base Hankaku
                            mov     di, Offset cmn_start_uffnt + 5 ; Offset to save
                            Call    Set_FontID ; Get Font ID
                        .endif

;-----------------------------------------------------------------------
; Read lines from the screen and write them to the printer
;-----------------------------------------------------------------------
                        sub     dx,dx   ;start the line counter at zero
                        mov     byte ptr ds:[cmn_pmode], 0

                        .repeat
                            mov     ax, [bp].Prt_cols ; 
                            mov     [bp].Prt_Length, ax ;Set the print screen length
                            mov     cx,ax ; 

                            mul     dl  ; AX - Source Offset
                            mov     di, offset PrtSc_CellBuffer
                            shl     ax,1 ; 
                            mov     si, ax ; 

;; Read One Line & Convert Data to PrtCell Format.
                            push    ds  ; Save
                            push    [bp].Prt_LVB_Sel ; 
                            pop     ds  ; DS - LVB
                            Call    To_Print_Attr ; Attribute Conversion
                            pop     ds  ; Restore

;; Strip Data
                            mov     si,[bp].Prt_Length ;Get length of returned data
                            mov     cx,si
                            shl     si, 1
                            lea     si,[si].PrtSc_CellBuffer-2 ;Get offset of last Cell
                            std         ;Scan backwards
                            .repeat
                                lodsw
                                .if     < al ne 20h > or ; Non Blank
                                .if     < bit ah and GRID+UNDERLINE+DBCS_CHAR2 >
                                .leave  ; DBCS 2nd may be 20h.          J-KK1127
                                .endif
                            .loop
                            cld         ;Restore direction flag

;; Out Data to Printer
                            lea     cx,[si+2] ;CX <-- end of buffer offset
                            mov     si,offset PrtSc_CellBuffer ;DI<-- buffer offset
                            sub     cx,si ;CX <-- length of buffer
                            shr     cx, 1 ; 
                            inc     cx  ; 

                            Call    Out_Print ; CX - Length Cell
                            .if     < c >
                                jmp     Error_PrtSc
                            .endif

                            inc     dx  ;increment the row count

                        .until  <dx ae [bp].Prt_rows> near ;all the lines are printed


;; CleanUp ESC Seq Data
                        Call    Out_Ptint_CleanUp ; 
                        .if     < c >
                            jmp     Error_PrtSc
                        .endif

                    .endif              ; Text Mode
                .endif                  ;D198
                xor     ax, ax          ; No Error
                jmp     Exit_PrtSc

Error_PrtSc:
                mov     ax, -1          ; Error
Exit_PrtSc:

IFNDEF          V20                     ;                               @KK1126
IFNDEF          INSTALL                 ;J-EA44
                                        ;; redraw XVIO         if real mode                          ;J-EA44

                les     di, [bp].Prt_EnvBufParm ; ES:DI -> environment buffer ;J-EA44
                test    byte ptr es:[di].EnvFlags,ENVFLAG_3xBOX ;        ;J-EA44
                .if     <nz>            ;if real mode,                   ;J-EA44
                    push    ax          ;save return code                ;J-EA44
                    mov     [bp].Ptr_XVS_LVBSelR,0 ; Store LVB Selector  ;J-EA44
                    mov     [bp].Ptr_XVS_StartRow,0 ; All Redraw         ;J-EA44
                    mov     [bp].Ptr_XVS_EndRow,-1 ;                     ;J-EA44
                    mov     byte ptr [bp].Ptr_XVS_Option,Suspend+Resume ; J-EA44
                    mov     ax,es:[di].SessionNum_Env ;Get Session ID    ;J-EA44
                    mov     [bp].Ptr_XVS_Session,al ;                    ;J-EA44
                    mov     [bp].Ptr_XVS_Length,8 ; Length for Redraw    ;J-EA44
                    push    XvsRedraw   ;                                ;J-EA44
                    push    ss          ;                                ;J-EA44
                    lea     ax,[bp].Ptr_XVS_Length ;                     ;J-EA44
                    push    ax          ;                                ;J-EA44
                    Call    XVIOVDHIF   ;                                ;J-EA44
                    pop     ax          ;restore return code             ;J-EA44
                .endif                  ;                                ;J-EA44
ENDIF                                   ;IFNDEF INSTALL                                                    ;J-EA44
ENDIF                                   ;                               @KK1126

                mov     [bp-2], ax      ; 
                pop     es              ; 
                pop     ds              ; 
                popa                    ; 
                pop     bp              ; 
                add     sp, Prt_WORK_END ; Deallocate local storage      J-KKJ
ENDIF
                ret     12              ; 

JVdhPrtSc       ENDP                    ;D198

IFDEF           PRTSC
To_Print_Attr   proc    near
                public  To_Print_Attr
;;---------------------------------------------------------------------------
;; Attribute Conversion
;;
;;  DS:[SI] - LVB             ES:[DI] - PrtSc_CellBuffer
;;   Epoch Mono
;;   Epoch Color
;;   ATLAS 82x25       ---->   Char/Prt Attr Pair
;;   Common
;;   DBCS VGA
;;
;; Attribute :  High Byte
;;                  Bit 7   - DBCS 2nd
;;                  Bit 6   - UnderScore
;;                  Bit 5   - H-Grid
;;                  Bit 4   - V-Grid
;;                  Bit 3   - H-Intensity
;;                  Bit 2   - User SBCS ( User SBCS Font )
;;                  Bit 1   - Extra SBCS
;;                  Bit 0   - DBCS
;;   note.
;;      Bit0(7),1 and 2 are exclusive respectively.
;;---------------------------------------------------------------------------
                push    bx              ;                               J-KK1110        J-KK1110

                .if     < [bp].Prt_UserFont e -1 > ; User Font Active   J-KK1110
                    mov     bl, USER_SBCS ; Mask for User Font          J-KK1110
                .else                   ;                               J-KK1110
                    xor     bl, bl      ;                               J-KK1110
                .endif                  ;                               J-KK1110

                .if     < [bp].Prt_Format e ATLASUS_Format > ; DBCS VGA Mode
                    .repeat             ; 
                        movsb           ; Copy Char
                        lodsb           ; Get Attr
                        and     al, 08h ; H-Int Mask
                        .if     < bit <byte ptr ds:[si+1000h-1]> and 81h > ; DBCS Bit On ?
                            or      al, DBCS_CHAR ; 
                            .if     < bit <byte ptr ds:[si+1000h-1]> and 80h > ; DBCS Bit On ?
                                or      al, DBCS_CHAR2 ; 
                            .endif      ; 
                        .else           ; SBCS                          J-KK1110
                            or      al, bl ; Mask                       J-KK1110
                        .endif          ; 
                        stosb           ; 
                    .loop               ; 

                .elseif < [bp].Prt_Format e COMMON_Format > ; Common
                    shl     si,1        ; 
                    .repeat             ; 
                        movsb           ; Copy Char
                        lodsb           ; Get Attr
                        and     al, 08h ; H-Int Mask
                        stosb           ; 

                        lodsb           ; 2nd Attribute
                        .if     < bit al and 80h > ;                    @kk0510
                            or      byte ptr es:[di-1], UNDERLINE ;     @kk0510
                        .endif          ;                               @kk0510
                        .if     < bit al and 08h > ;                    @kk0510
                            or      byte ptr es:[di-1], V_GRID ;        @kk0510
                        .endif          ;                               @kk0510
                        .if     < bit al and 04h > ;                    @kk0510
                            or      byte ptr es:[di-1], H_GRID ;        @kk0510
                        .endif          ;                               @kk0510

                        lodsb           ; 3rd Attribute
                        .if     < bit al and 81h > ; DBCS ?
                            or      byte ptr es:[di-1], DBCS_CHAR ; 
                            .if     < bit al and 80h > ; 
                                or      byte ptr es:[di-1], DBCS_CHAR2 ; 
                            .endif      ; 
                        .else           ; SBCS                          J-KK1110
                            or      byte ptr es:[di-1], bl ; Mask       J-KK1110
                        .endif          ; 
                    .loop               ; 

                .elseif < [bp].Prt_Format e ATLAS3_Format > ; 82x25
                    shl     si,1        ; 
                    .repeat             ; 
                        movsb           ; 
                        lodsb           ; 
                        and     al, 08h ; H-Int Mask
                        stosb           ; 

                        lodsb           ; 2nd Attribute
                        .if     < bit al and 40h > ;                    @kk0510
                            or      byte ptr es:[di-1], UNDERLINE ;     @kk0510
                        .endif          ;                               @kk0510
                        .if     < bit al and 01h > ;                    @kk0510
                            or      byte ptr es:[di-1], V_GRID ;        @kk0510
                        .endif          ;                               @kk0510
                        .if     < bit al and 02h > ;                    @kk0510
                            or      byte ptr es:[di-1], H_GRID ;        @kk0510
                        .endif          ;                               @kk0510

                        lodsb           ; 3rd Attribute
                        .if     < bit al and 81h > ; DBCS ?
                            or      byte ptr es:[di-1], DBCS_CHAR ; 
                            .if     < bit al and 80h > ; 
                                or      byte ptr es:[di-1], DBCS_CHAR2 ; 
                            .endif      ; 
                        .else           ; SBCS
                            and     al, 1eh ; Extra SBCS Bit On ?
                            .if     < al e 1eh > ; 
                                or      byte ptr es:[di-1], EXT_SBCS ; 
                            .else       ; Not Extra SBCS                J-KK1110
                                or      byte ptr es:[di-1], bl ; Mask   J-KK1110
                            .endif      ; 
                        .endif          ; 
                    .loop               ; 

                .else                   ; Epoch Format
                    .if     < [bp].Prt_colors e 1 > ;; Mono Epoch
                        .repeat         ; 
                            movsb       ; 
                            lodsb       ; 
                            mov     ah, al ; 
                            and     al, 78h ; Mask
                            and     ah, 3 ; 
                            .if     < ah e 2 >
                                or      al, EXT_SBCS
                            .elseif < ah e 1 > ; 
                                or      al, DBCS_CHAR ; 
                            .elseif < ah e 3 > ; 
                                or      al, DBCS_CHAR2 ; 
                            .else       ; SBCS
                                or      al, bl ; Mask                   J-KK1110
                            .endif      ; 
                            stosb       ; 
                        .loop           ; 
                    .else               ;; Color Epoch
                        .repeat         ; 
                            movsb       ; 
                            lodsb       ; 
                            mov     ah, al ; 
                            and     al, 30h ; Mask
                            and     ah, 3 ; 
                            .if     < ah e 2 > ; 
                                or      al, EXT_SBCS
                            .elseif < ah e 1 > ; 
                                or      al, DBCS_CHAR ; 
                            .elseif < ah e 3 > ; 
                                or      al, DBCS_CHAR2 ; 
                            .else       ; SBCS
                                or      al, bl ; Mask                   J-KK1110
                            .endif      ; 
                            stosb       ; 
                        .loop           ; 
                    .endif              ; 
                .endif

                pop     bx              ;                               J-KK1110J-KK1110
                ret
To_Print_Attr   endp

Out_Print       proc    near
                public  Out_Print
;;--------------------------------------------------------------------------
;; DS:[SI] - PrtSc Cell Buffer
;;      Attribute :
;;                  Bit 7   - DBCS 2nd
;;                  Bit 6   - UnderScore
;;                  Bit 5   - H-Grid
;;                  Bit 4   - V-Grid
;;                  Bit 3   - H-Intensity
;;                  Bit 2   - User SBCS
;;                  Bit 1   - Extra SBCS
;;                  Bit 0   - DBCS
;; ES:[DI] - PrtSc Work Buffer
;; CX - Length Cell
;;--------------------------------------------------------------------------

                mov     [bp].Prt_length, cx ; Length Cell
;;
;; Grid Line
;;
                mov     si, offset PrtSc_CellBuffer ; Grid att is there ?
                .repeat                 ; 
                    inc     si          ; 
                    test    byte ptr ds:[si], GRID ; 
                    .if     <nz>        ; 
                    .leave              ; 
                    .endif              ; 
                    inc     si          ; 
                .loop                   ; 
                .if     < nonzero cx >  ; Grid is there.
                    mov     si, offset cmn_uni_grid ; ESC Data
                    mov     di, offset PrtSc_Buffer ; 
                    mov     ax, [bp].Prt_length ; 
                    inc     ax          ; <=== Caution !!! (Inc for Reserved)
                    xchg    al, ah      ; <===
                    mov     [si+6],ax   ; Set grid line length
                    mov     cx, cmn_uni_grid_Len ; 
                    rep     movsb       ; 

                    mov     si, offset PrtSc_CellBuffer
                    mov     cx, [bp].Prt_length
                    .repeat
                        inc     si      ; 
                        lodsb           ; 
                        xor     ah, ah  ; Clear
                        .if     < bit AL and H_GRID > ; 
                            or      ah,10h ;set h-grid
                        .endif          ; 
                        .if     < bit AL and V_GRID > ; 
                            or      ah,01h ;set v-grid
                        .endif          ; 
                        xchg    ah,al   ; 
                        stosb           ;set attribute grid parameter
                    .loop

                    mov     cx, [bp].Prt_length ; 
                    add     cx, cmn_uni_grid_Len ; 
                    Call    DOSWRITE_ESC ; 
                    .if     < c >
                        jmp     Out_Print_Exit
                    .endif
                .endif

;;
;; Under Line, H-Int and Extra SBCS
;;
                mov     si, offset PrtSc_CellBuffer ; 
                mov     di, offset PrtSc_Buffer ; 
                mov     cx, [bp].Prt_length ; 

                .repeat
                    push    cx          ; 

                    lodsw               ; Get Char/Attr
                    .if     < zero al >
                        mov     al, 20h
                    .endif

;; UnderLine
                    .if     < bit AH and UNDERLINE > ; Under Line
                        test    byte ptr ds:[cmn_pmode], UNDERLINE
                        .if     < z >
                            push    Set_UL
                            Call    Out_ESC
                            .if     < c >
                                jmp     Out_Print_Exit
                            .endif
                            or      byte ptr ds:[cmn_pmode], UNDERLINE
                        .endif
                    .else
                        test    byte ptr ds:[cmn_pmode], UNDERLINE
                        .if     < nz >
                            push    Reset_UL
                            Call    Out_ESC
                            .if     < c >
                                jmp     Out_Print_Exit
                            .endif
                            and     byte ptr ds:[cmn_pmode],not UNDERLINE
                        .endif
                    .endif

;; Hi-Intensity
                    .if     < bit AH and H_INT     > ; High Intensity
                        test    byte ptr ds:[cmn_pmode], H_INT
                        .if     < z >
                            push    Set_DS
                            Call    Out_ESC
                            .if     < c >
                                jmp     Out_Print_Exit
                            .endif
                            or      byte ptr ds:[cmn_pmode], H_INT
                        .endif
                    .else
                        test    byte ptr ds:[cmn_pmode], H_INT
                        .if     < nz >
                            push    Reset_DS
                            Call    Out_ESC
                            .if     < c >
                                jmp     Out_Print_Exit
                            .endif
                            and     byte ptr ds:[cmn_pmode],not H_INT
                        .endif
                    .endif

;; Extra SBCS
                    .if     < bit AH and EXT_SBCS  > ; Extra SBCS
                        test    byte ptr ds:[cmn_pmode], EXT_SBCS
                        .if     < z >   ; ESC not set yet.
                            push    Set_EXT
                            Call    Out_ESC
                            .if     < c >
                                jmp     Out_Print_Exit
                            .endif
                            or      byte ptr ds:[cmn_pmode], EXT_SBCS
                        .endif
                    .else               ; Non Extra SBCS
                        test    byte ptr ds:[cmn_pmode], EXT_SBCS
                        .if     < nz >  ; ESC already set.
                            push    Reset_EXT
                            Call    Out_ESC
                            .if     < c >
                                jmp     Out_Print_Exit
                            .endif
                            and     byte ptr ds:[cmn_pmode],not EXT_SBCS
                        .endif
                    .endif

;; User  SBCS                                                           J-KK1110
                    .if     < bit AH and USER_SBCS  > ; User  SBCS
                        test    byte ptr ds:[cmn_pmode], USER_SBCS ; 
                        .if     < z >   ; ESC not set yet.
                            push    Set_UF ; 
                            Call    Out_ESC ; 
                            .if     < c > ; 
                                jmp     Out_Print_Exit ; 
                            .endif      ; 
                            or      byte ptr ds:[cmn_pmode], USER_SBCS
                        .endif          ; 
                    .else               ; Non User  SBCS
                        test    byte ptr ds:[cmn_pmode], USER_SBCS
                        .if     < nz >  ; ESC already set.
                            push    Reset_UF ; 
                            Call    Out_ESC ; 
                            .if     < c > ; 
                                jmp     Out_Print_Exit ; 
                            .endif      ; 
                            and     byte ptr ds:[cmn_pmode],not USER_SBCS
                        .endif          ; 
                    .endif              ; 

;; Transparent
                    .if     < bit AH nand DBCS_CHAR  > and ; Non DBCS Chars
                    .if     < AL b 20h > ; Control Character
;                                        ;--- Set transparent mode
                        push    Prt_Transp
                        Call    Out_ESC
                        .if     < c >
                            jmp     Out_Print_Exit
                        .endif
                    .endif


;; Copy Char
                    cmp     di, offset PrtSc_Buffer_End
                    .if     < ae >      ; 
                        push    cx
                        mov     cx, MAX_OUTBUF ; 
                        Call    DOSWRITE_ESC ; 
                        pop     cx
                        .if     < c >
                            jmp     Out_Print_Exit
                        .else
                            mov     di, offset PrtSc_Buffer ; Top of Buffer
                            stosb       ; Copy
                            clc
                        .endif
                    .else               ; 
                        stosb           ;ah=attribute, al=character
                    .endif

                    pop     cx          ; 
                    dec     cx          ; 
                .until  <zero cx > near ;all chars are printed

;--- 1 line process end
                                        ;--- set CR+LF & Bi-Direction
                push    CRLF_BI
                Call    Out_ESC
                .if     < c >
                    jmp     Out_Print_Exit
                .endif

                sub     di, offset PrtSc_Buffer ; Current Bytes
                mov     cx, di          ; 
                Call    DOSWRITE_ESC
                .if     < c >
                    jmp     Out_Print_Exit
                .endif
                clc                     ; No Error

Out_Print_Exit:
                ret
Out_Print       endp


Out_Ptint_CleanUp proc  near
;--- End process of under line, double strike and extension font

                mov     di, offset PrtSc_Buffer ; 

                .if     < bit <byte ptr ds:[cmn_pmode]> and UNDERLINE >
                    push    Reset_UL
                    Call    Out_ESC
                    .if     < c >
                        jmp     Out_Print_CExit
                    .endif
                .endif

                .if     < bit <byte ptr ds:[cmn_pmode]> and H_INT     >
                    push    Reset_DS
                    Call    Out_ESC
                    .if     < c >
                        jmp     Out_Print_CExit
                    .endif
                .endif

                .if     < bit <byte ptr ds:[cmn_pmode]> and EXT_SBCS  >
                    push    Reset_EXT
                    Call    Out_ESC
                    .if     < c >
                        jmp     Out_Print_CExit
                    .endif
                .endif

                .if     < bit <byte ptr ds:[cmn_pmode]> and USER_SBCS > ;J-KK1110
                    push    Reset_UF    ;                              ;J-KK1110
                    Call    Out_ESC     ;                              ;J-KK1110
                    .if     < c >       ;                              ;J-KK1110
                        jmp     Out_Print_CExit ;                      ;J-KK1110
                    .endif              ;                              ;J-KK1110
                .endif                  ;                              ;J-KK1110

                sub     di, offset PrtSc_Buffer ; Current Bytes
                mov     cx, di          ; 
                Call    DOSWRITE_ESC
                .if     < c >
                    jmp     Out_Print_CExit
                .endif

                clc                     ; No Error
Out_Print_CExit:
                ret
Out_Ptint_CleanUp endp


Out_ESC         proc    near
                public  Out_ESC

                push    bx
                mov     bx, sp
                push    cx
                push    si

                mov     bx, ss:[bx+4]   ; Get Request
                shl     bx, 2           ; BX * 4
                add     bx, offset ESC_Table
                mov     cx, [bx]        ; Length of ESC
                mov     si, [bx+2]      ; Offset of ESC Data

                push    di              ; 
                add     di, cx          ; Necessary Bytes
                cmp     di, offset PrtSc_Buffer_End ; 
                pop     di              ; 
                .if     < ae >          ; enough buffer space ?
                    sub     di, offset PrtSc_Buffer ; Current Bytes
                    push    cx          ; 
                    mov     cx, di      ; 
                    Call    DOSWRITE_ESC ; 
                    pop     cx          ; 
                    .if     < nc >      ; 
                        mov     di, offset PrtSc_Buffer ; Top of Buffer
                        rep     movsb   ; Copy
                        clc
                    .endif
                .else                   ; 
                    rep     movsb       ; Copy
                    clc                 ; 
                .endif                  ; 
                                        ; 
                pop     si              ; 
                pop     cx              ; 
                pop     bx              ; 
                ret     2               ; For Parameter
Out_ESC         endp                    ; 


DOSWRITE_ESC    proc    near
                public  DOSWRITE_ESC
;---------------------------------------------------------------------------
; Input:        CX              - Length Bytes
;               DS:PrtSc_Buffer - ESC Data
; output:       CF - Error
;               if no error, DI = PrtSc_Buffer
;---------------------------------------------------------------------------

                .if     < nonzero cx >  ; Check Nonzero CX           @KK0419


                    push    ax          ;<=== save                      J-KK1018

                    xor     ax, ax      ; Clear Error Code              @KK0419
                    .if     <bit <word ptr ds:[PrtSc_HandleType]> nand Remote_Handle> ;@KK0419
;                                       ; Check Local or Remote         @KK0419
                        mov     byte ptr ds:[cmn_prtsc_ioctl], 90h ; 
;                                       ; PreSet Comp.Value    J-KK1211 DCR28
                        mov     byte ptr ds:[cmn_prtsc_parm],00
                        push    ds      ; 
                        push    offset cmn_prtsc_ioctl ; 
                        push    ds      ; 
                        push    offset cmn_prtsc_parm ; 
                        push    66h     ;Get printer Stataus
                        push    05h     ; 
                        push    [bp].Prt_Handle ; Printer Handle
                        Call    DOSDEVIOCTL ; 

;;       If Spooler is active, ERROR_INVALID_FUNCTION is returned!!     @KK1126
                        .if     < ax e ERROR_INVALID_FUNCTION > ;       @KK1126
                                xor ax, ax ; Clear Error Code           @KK1126
                        .endif          ;                               @KK1126

                        .if     < nonzero ax > or
                        and     byte ptr ds:[cmn_prtsc_ioctl],38H       
                        .if     < <byte ptr ds:[cmn_prtsc_ioctl]> ne 10h > ;selected? J-KAZZ01(C)
;                                       ; if not ready, skip proc.
                            mov     ax, 1 ; Error
                        .endif          ; 
                    .endif              ; 

                    .if     < zero ax > ; Check Error Code          @KK0419
                        push    [bp].Prt_Handle ; Printer Handle
                        push    ds      ;selector for output buffer
                        push    offset PrtSc_Buffer ; 
                        push    cx      ;length
                        push    ss      ;selector where to put the return len.
                        lea     cx,[bp].Prt_RetLen ; offset
                        push    cx      ;offset
                        Call    DOSWRITE ; 
                        .if     < nonzero ax >
                            stc         ; Error
                        .else
                            clc         ; No Error
                        .endif
                    .else
                        clc             ; No Error to Skip
                    .endif

                    pop     ax          ;<=== restore                   J-KK1018

                .endif                  ;                               ;@KK0419

                ret
DOSWRITE_ESC    endp

Set_FontID      proc    near
                public  Set_FontID
;;-------------------------------------------------------------------------
;; Set Font ID
;; Input : AL - Session Number
;;         AH - Font Buf Type ( 1: Base Hankaku, 2: Extra Hankaku )
;;         DI - Offset to save Font-ID ( 4 words )                      J-KK1027
;;         DS & ES - = _DATA
;;-------------------------------------------------------------------------
IFDEF           FONT_SUPPORT
                push    bx              ; 
                push    cx              ; 
                push    si              ; 

                xor     bh, bh
                mov     bl, ah          ; BX - Font Buf Type
                xor     ah, ah          ; AX - Screen Group #
                push    ax              ; push SC Group Number
                push    ds              ; push the address of Work Buffer
                push    offset PrtSc_Buffer ; 
                push    bx              ; Font Buf Type
                call    FNTGETSOURCE    ; Call Font Manager
                .if     < zero ax >     ; 

;; Store Font-ID ( 4 words )                                            J-KK1027
                    mov     cx, 4       ; Font-ID 4 words
                    mov     si, Offset PrtSc_Buffer+8 ; 
                                        ; SI: Offset of Font-ID (last word)
                                        ; DI: Offset of ESC Seq Area
                    .repeat             ; 
                        lodsw           ; 
                        sub     si, 4   ;<===
                        xchg    ah,al   ;For printer command
                        stosw           ; 
                    .loop               ; 

                .endif                  ; 

                pop     si              ; 
                pop     cx              ; 
                pop     bx              ; 
ENDIF
                ret
Set_FontID      endp

ENDIF
R2CSEG          ENDS
                END
