;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE    60,132
        TITLE   VDHJIOPL.ASM -- Video Device Handler Japanese Ring 2 Routines

;/*****************************************************************************
;*
;* SOURCE FILE NAME = VDHJIOPL.ASM
;*
;* DESCRIPTIVE NAME = Video Device Handler Japanese Ring 2 Routines
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION
;*
;* FUNCTIONS
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES  NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVIY =
;*   DATE      FLAG       APAR    CHANGE DESCRIPTION
;*   --------  ---------- -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx xxxxx   xxxxxxx
;*   09/25/92   Before access CMOS register, you MUST check if current machine;j-@mh01
;*              is MCA or ISA. Otherwise some machine's CMOS, sach as           ;j-@mh01
;*              DynaBook, is brocken.                                           ;j-@mh01
;****************************************************************************/

.286p

        .xlist
        include vdh.inc                 ; Definitions
        include vdhequ.inc              ; Definitions
        INCLUDE strucJ.inc              ; Structured Macros
        INCLUDE phoenix.inc             ; Structured Macros     ;J-RH
        INCLUDE vdhstruc.inc            ; Structured Macros     ;J-KK1011
        .list
        include iodelay.inc             ; IODelay macro              ;J-IODelay

        extrn   DOSOPEN:far                                             ;j-@mh01
        extrn   DOSDEVIOCTL2:far                                        ;j-@mh01
        extrn   DOSCLOSE:far                                            ;j-@mh01
        INCL_DOSFILEMGR equ     1                                       ;j-@mh01

_DATA   SEGMENT WORD PUBLIC 'DATA'      ; Global Data Segment

;; Slot Number
;;              0       : On Planar
;;              1 <-> 8 : On Slot
;;              FF      : Not Exist
;;
;; if ATLAS# == SBCS# == 0, both are on planar.
;; if ATLAS# == SBCS# != 0, both are on the same slot.
;; if ATLAS# != SBCS#
;;  if ATLAS# != 0 & SBCS# == 0, SBCS is on planar and ATLAS on slot.
;;  if ATLAS# != 0 & SBCS# != 0, SBCS is on slot and ATLAS on another slot.

On_Planar       equ   0
Not_Exist       equ   0ffh

ATLAS_videoslot db  Not_Exist            ; ATLAS Adaptor Slot#           J-KKB12
SBCS_videoslot  db  Not_Exist            ; SBCS  Adaptor Slot#           J-KKB12

OEMHelp         db  'OEMHLP$'           ;Name of OEM Help Dev Drvr      ;j-@mh01
hOEM            dw  0                                                   ;j-@mh01
action          dw  0                                                   ;j-@mh01
                                                                        ;j-@mh01
_BIOSINFO       struc                                                   ;j-@mh01
        Model           dw      0                                       ;j-@mh01
        SubModel        dw      0                                       ;j-@mh01
        RevisionLevel   dw      0                                       ;j-@mh01
        ABIOS_Present   dw      0                                       ;j-@mh01
_BIOSINFO       ends                                                    ;j-@mh01
BIOSInfo        _BIOSINFO       <>      ;BIOS Level Information         ;j-@mh01
LEN_BIOSInfo    equ     $ - BIOSInfo                                    ;j-@mh01
                                                                        ;j-@mh01
OEM_BIOS_INFO   equ     5                                               ;j-@mh01
OEM_CATEGORY    equ     80h                                             ;j-@mh01

_DATA   ENDS

R2SEG   SEGMENT DWORD PUBLIC 'CODE'                                    ;J-IODlay
        ASSUME  CS: R2SEG, DS: DGROUP

;------------------------------------------------------------------------
; Function : Check if both ATLAS and SBCS video subsystem exist by reading
;            the card ID in CMOS. And their slot# are stored in the global
;            data area.
; OutPut   : ATLAS_videoslot   ATLAS slot number ( 1 - 8 )
;            SBCS_videoslot    SBCS video subsystem slot number         J-KKB13
;              Temporary 0
;            AX - 0: Exist,   -1: None
;------------------------------------------------------------------------
_CheckID PROC   FAR
        PUBLIC  _CheckID

        ; Before access CMOS register, you MUST check if current machine;j-@mh01
        ; is MCA or ISA. Otherwise some machine's CMOS, sach as         ;j-@mh01
        ; DynaBook, is brocken.                                         ;j-@mh01
        push    ds                                                      ;j-@mh01
        mov     ax,_DATA                                                ;j-@mh01
        mov     ds,ax                                                   ;j-@mh01
                                                                        ;j-@mh01
        mov     ds:BIOSInfo.ABIOS_Present, 0    ;assume not MCA machine ;j-@mh01
        push    ds                                                      ;j-@mh01
        push    offset OEMHelp                                          ;j-@mh01
        push    ds                                                      ;j-@mh01
        push    offset hOEM                                             ;j-@mh01
        push    ds                                                      ;j-@mh01
        push    offset action                                           ;j-@mh01
        push    0               ;push dword file size                   ;j-@mh01
        push    0                                                       ;j-@mh01
        push    0               ;push word fileattribute                ;j-@mh01
        push    1               ;push word OpenFlag                     ;j-@mh01
        push    40h             ;push word OpenMode                     ;j-@mh01
        push    0               ;push dword reserved 0                  ;j-@mh01
        push    0                                                       ;j-@mh01
        call    DosOpen                                                 ;j-@mh01
                                                                        ;j-@mh01
        .if <zero ax>                                                   ;j-@mh01
                push    ds                                              ;j-@mh01
                push    offset BIOSInfo                                 ;j-@mh01
                push    LEN_BIOSInfo                                    ;j-@mh01
                push    0               ;No parameter                   ;j-@mh01
                push    0                                               ;j-@mh01
                push    0               ;No param length                ;j-@mh01
                push    OEM_BIOS_INFO                                   ;j-@mh01
                push    OEM_CATEGORY                                    ;j-@mh01
                push    hOEM            ;Handle to OEM device driver    ;j-@mh01
                call    DosDevIOCtl2                                    ;j-@mh01
                                                                        ;j-@mh01
                push    hOEM                                            ;j-@mh01
                call    DosClose                                        ;j-@mh01
        .endif                                                          ;j-@mh01
                                                                        ;j-@mh01
        mov     ax,ds:BIOSInfo.ABIOS_Present                            ;j-@mh01
        pop     ds                                                      ;j-@mh01
        .if<nonzero ax> near            ;check if MCA machine           ;j-@mh01

        push    bx
        push    cx
        push    dx
        push    si                      ;                             J-IODelay
;
        mov     bx,0001h
        mov     cl,01h
        mov     dx,0074h                ;CMOS Address register
        .repeat
            mov     ax,bx               ;odd adrress
            out     dx,ax
            kIODelay si                 ; D1085                       J-IODelay
            add     dx,2
            in      al,dx               ;al high data
            sub     dx,2
            dec     bx                  ;even address
            xchg    ax,bx
            out     dx,ax
            kIODelay si                 ; D1085                       J-IODelay
            xchg    ax,bx
            inc     bx                  ;odd address
            mov     ah,al
            add     dx,2
            in      al,dx               ;al low  data
            sub     dx,2
            .if     <ax e AtlasId> or   ; ATLAS
            .if     <ax e AtlasKENT>    ; ATLAS-KENT                    J-KK0814
                push    ds
                mov     ax,_DATA
                mov     ds,ax
                mov     ds:ATLAS_videoslot, cl ; Slot Number
                mov     byte ptr ds:SBCS_videoslot, 0 ; Planar          J-KKB13
                pop     ds
                jmp     adaptor_exist

            .else
                IFDEF   IDS             
                    .if     <ax e AtlasIDS> or 
                ENDIF                   
                .if     <ax e AtlasSP2> or    
                .if     <ax ae AtlasII_Start> and 
                .if     <ax be AtlasII_End  > 
                    push    ds          
                    push    ax          
                    mov     ax,_DATA    
                    mov     ds,ax       
                    mov     ds:ATLAS_videoslot, cl 
                    mov     byte ptr ds:SBCS_videoslot, cl 
                    pop     ax          
                    pop     ds          
                    jmp     adaptor_exist 
                .else                   ; 
                    inc     cl          ; 
                    add     bx,0023H    ;next entry
                .endif                  ; 
            .endif                      
        .until  < cl e maxslot+1 >      ; Search all of 8 slots.        J-KK0208
        mov     ax, -1                  ; Japanese Adaptor Not Exist
        jmp     gethw_exit

adaptor_exist:
        xor     ax, ax                  ; Japanese Adaptor Exist
gethw_exit:
        pop     si                      ;                             J-IODelay
        pop     dx
        pop     cx
        pop     bx

        .else                                                           ;j-@mh01
        mov     ax, -1                  ; Japanese Adaptor Not Exist    ;j-@mh01
        .endif                                                          ;j-@mh01

        RET
_CheckID ENDP

;------------------------------------------------------------------------
; Function : Get H/W Configuration
; OutPut   : AX - Configuaration Data
;------------------------------------------------------------------------
_GetHWConf PROC FAR
        PUBLIC  _GetHWConf

        push    cx                      ;                             J-IODelay
        push    dx
;
;; Enable ATLAS
        call    vga2japan

;; Read Configuration Register
        mov     dx,3E0H                 ; Get ATLAS Config Data1
        mov     al,0AH                  ; 
        out     dx,al                   ; 
        kIODelay cx                     ; D1085                       J-IODelay
        inc     dx                      ; 
        in      al,dx                   ; 
        xchg    al,ah                   ; 
;
        mov     dx,3E0H                 ; 
        mov     al,0BH                  ; 
        out     dx,al                   ; 
        kIODelay cx                     ; D1085                       J-IODelay
        inc     dx                      ; 
        in      al,dx                   ; 
        xchg    al,ah                   ; 
;;                              AX - ATLAS Configuration Data

;
;; Enable VGA
        push    ax
        call    japan2vga
        pop     ax

        pop     dx                      ; 
        pop     cx                      ;                             J-IODelay
        ret
_GetHWConf ENDP

;---------------------------------------------------------------------------
;    Enable Atlas and Disable VGA
;---------------------------------------------------------------------------
vga2japan proc  near                    ; 
        public  vga2japan

        push    ds                      ;                               J-KKB13
        push    _DATA                   ; DS : Global Segment           J-KKB13
        pop     ds                      ;                               J-KKB13

        mov     al, ds:SBCS_videoslot   ; Get Slot Number               J-KKB13
        .if     < al ne <byte ptr ds:ATLAS_videoslot>> ; Both on Slot/Planar?J-KKB13
                                        ; Enable/Disable is necessary.  J-KKB13
;; Disable VGA
            mov     al, 70h             ; Set Slot POS into             @KIKO
            out     96h, al             ;   non-setup mode.             @KIKO

            xor     ax, ax              ; Disable VGA ( SBCS Adaptor )   J-KKB12
            CLI                         ; 
            Call    nSBCSAdaptor_Enb    ;                                J-KKB12

;; Enable ATLAS
            mov     ax, 1               ; Enable  ATLAS                  J-KKB12
            Call    nATLAS_Enb          ;                                J-KKB12
            STI                         ; 

        .endif                          ;                               J-KKB13

        pop     ds                      ;                               J-KKB13
        ret
vga2japan endp

;---------------------------------------------------------------------------
;  Disable Atlas, Enable VGA, and Enable ROS E000h.
;---------------------------------------------------------------------------
japan2vga   proc    near                ; 
            public  japan2vga

            push    bx                  ;                               J-KKB13
            push    ds                  ;                               J-KKB13
            push    _DATA               ; DS : Global Segment           J-KKB13
            pop     ds                  ;                               J-KKB13

            xor     bl, bl              ;               ; Clear Flag    J-KKB13
            mov     al, ds:SBCS_videoslot ; Get Slot Number             J-KKB13
            .if     < al ne <byte ptr ds:ATLAS_videoslot>> ; Both on Slot/PlanarJ-KKB13
                mov     bl, 1           ; Enable/Disable is necessary.  J-KKB13
            .endif                      ;                               J-KKB13

;; Check PD Busy
            Call    Check_PDBUSY        ; Fix ATLAS             ;;J-KK0128
                                        ; If DBCS video mode, CLI now.

            .if     < nonzero bl >      ; Enable/Disable is necessary.  J-KKB13

;; VGA Passthru Mode
                mov     dx,3e0h         ;Rout to VGA
                mov     ax,0302h        ;Mode Register
                out     dx,ax           ;Character/VGA passthru Mode

;; Disable ATLAS
                mov     al, 0ffh        ; Set Planer POS into           @KIKO
                out     94h, al         ;   non-setup mode.             @KIKO

                xor     ax, ax          ; Disable ATLAS                 J-KKB12
                CLI                     ; 
                Call    nATLAS_Enb      ;                               J-KKB12

;; Enable VGA
                mov     ax, 1           ; Enable VGA ( SBCS Adaptor )   J-KKB12
                Call    nSBCSAdaptor_Enb ;                              J-KKB12

            .else                       ; 
                mov     dx,3e0h         
                mov     ax,0100h        
                out     dx,ax           

            .endif                      ; 
            STI                         ; <=== Must be here.

            pop     ds                  ;                               J-KKB13
            pop     bx                  ;                               J-KKB13
            ret
japan2vga   endp

;;----------------------------------------------------------------------------
;; Function     : Enable/Disable SBCS Adaptor                           J-KKB12
;; Input        : AX - 0: Disable    1: Enable
;; Output       : AX - 0: No Error  Others: Error
;;----------------------------------------------------------------------------

nSBCSAdaptor_Enb proc near
        public  nSBCSAdaptor_Enb

        mov     ah, al                  ; AH : Enable or Disable
        mov     al, ds:SBCS_videoslot   ; Get SBCS Slot
        .if     < al ne Not_Exist >     ; Exist ?
            .if     < nonzero al >      ; On Slot

                Call    Slot_Enb        ; Enable/Disable for Slot

            .else                       ; On Planar
                mov     al,0dfh         ; To Setup Mode
                out     94h,al          ;                               @KIKO

                mov     dx,102h         ; 
                in      al, dx          ; 
                .if     < zero ah >     ; 
                    and     al, 0FEh    ; Disable
                .else                   ; 
                    or      al, 01h     ; Enable
                .endif                  ; 
                out     dx,al           ; 

                mov     al,0ffh         ; To non-setup mode
                out     94h,al          ;                               @KIKO
            .endif                      ; 
            xor     ax, ax              ; No Error
        .else                           ; 
            mov     ax, 1               ; Error
        .endif                          ; 

        ret
nSBCSAdaptor_Enb endp

;;----------------------------------------------------------------------------
;; Function     : Enable/Disable ATLAS                                  J-KKB12
;; Input        : AX - 0: Disable    1: Enable
;; Output       : AX - 0: No Error  Others: Error
;;----------------------------------------------------------------------------

nATLAS_Enb proc near
        public  nATLAS_Enb
                                        ; 
        mov     ah, al                  ; AH : Enable or Disable
        mov     al, ds:ATLAS_videoslot  ; Get Slot Number
        .if     < al ne Not_Exist >     ; Exist ?
            .if     < nonzero al >      ; On Slot
                Call    Slot_Enb        ; Enable/Disable for Slot
            .else                       ; On Planar
;;              Call    XXXX            ; ???? Not Implemented, yet.
            .endif                      ; 
            xor     ax, ax              ; No Error
        .else                           ; 
            mov     ax, 1               ; Error
        .endif                          ; 

        ret
nATLAS_Enb endp

;;----------------------------------------------------------------------------
;; Function     : Enable/Disable Slot                                   J-KKB12
;; Input        : AL - Slot# ( 1 - 8 )
;;              : AH - 0: Disable    1: Enable
;; Output       : none
;;----------------------------------------------------------------------------
Slot_Enb proc   near
        public  Slot_Enb

        dec     al                      ; To Zero Origin
        or      al,08h                  ; To Setup Mode for Slot      @MAINSALE
        out     96h,al                  ;                               @KIKO

        mov     dx,102h                 ; Get Pos Reg Data
        in      al, dx                  ; 
        .if     < zero ah >             ; 
            and     al, 0FEh            ; Disable
        .else                           ; 
            or      al, 01h             ; Enable
        .endif                          ; 
        out     dx,al                   ; 
        mov     al,00h                  ; To Non SetUp Mode           @MAINSALE
        out     96h,al                  ;                               @KIKO

        ret
Slot_Enb endp

;;-----------------------------------------------------------------------
;; Function : Check PD-Busy
;;
;;   At exit,
;;      If ATLAS is disabled, then STI.
;;      Otherwise CLI.
;;-----------------------------------------------------------------------
Check_PDBUSY proc near                  ;                               @IDS
        public  Check_PDBUSY            ;                               @IDS
        push    ax                      ;                               @IDS
        push    dx                      ;                               @IDS

        mov     dx, LS_PORT             ; select sequencer register     @IDS
        mov     al, 03h                 ; select PD status register     @IDS
        CLI                             ; <==== Caution !!!!!           @IDS
        out     dx, al                  ;                               @IDS
        inc     dx                      ;                               @IDS
        in      al, dx                  ; al = PD status                @IDS
        test    al, 00000001b           ; PD is busy?                   @IDS
        .if     < nz > and              ;                               @IDS
        STI                             ; <===                          @IDS
        .if     < al ne 0ffh >          ; ATLAS Disable?                @IDS
            push    cx                  ;                               @IDS
            xor     cx, cx              ; Max Loop Count                @IDS
            Call    Check_PDBUSY_LOOP   ; Check PD Busy                 @IDS
            pop     cx                  ;                               @IDS
            .if     < c >               ; Still Busy                    @IDS
                mov     dx, LF_PORT     ; Reset                         @IDS
                mov     al, 18h         ; PD Reset Register             @IDS
                CLI                     ; <===                          @IDS
                out     dx, al          ;                               @IDS
                inc     dx              ;                               @IDS
                mov     al, 7           ; FM, DRAW and FIFO Busy        @IDS
                out     dx, al          ;                               @IDS
                dec     dx              ;                               @IDS
                mov     al, 18h         ; PD Reset Register             @IDS
                out     dx, al          ;                               @IDS
                inc     dx              ;                               @IDS
                xor     al, al          ;                               @IDS
                out     dx, al          ;                               @IDS
            .endif                      ;                               @IDS
        .endif                          ;                               @IDS

        pop     dx                      ;                               @IDS
        pop     ax                      ;                               @IDS
        ret                             ;                               @IDS
Check_PDBUSY endp                       ;                               @IDS

Check_PDBUSY_LOOP proc near             ;                               @IDS
        public  Check_PDBUSY_LOOP       ;                               @IDS
        .repeat                         ;                               @IDS
            mov     dx, LS_PORT         ; select sequencer register     @IDS
            mov     al, 03h             ; select PD status register     @IDS
            CLI                         ; <==== Caution !!!!!           @IDS
            out     dx, al              ;                               @IDS
            inc     dx                  ;                               @IDS
            in      al, dx              ; al = PD status                @IDS
            test    al, 00000001b       ; PD is busy?                   @IDS
            .if     < z >               ; if so, wait until not busy    @IDS
                clc                     ; No Carry                      @IDS
                ret                     ;                               @IDS
            .endif                      ;                               @IDS
            STI                         ; <===== Important !!!          @IDS
            Call    justwait            ;                               @IDS
        .loop                           ;                               @IDS
        stc                             ; Carry                         @IDS
        ret                             ; Still Busy                    @IDS
Check_PDBUSY_LOOP endp                  ;                               @IDS

justwait proc   near                    ;SK0001
        pusha                           ;SK0001
        kIODelay                        ; D1085                       J-IODelay
        popa                            ;SK0001
        ret                             ;SK0001
justwait endp                           ;SK0001

R2SEG   ENDS
END
