/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = VdhGetCP.C
 *
 * DESCRIPTIVE NAME = Get CodePage Fonts from the Font File
 *
 *
 * VERSION      V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS    GetCodePage
 *
 * NOTES        NONE
 *
 * STRUCTURES   NONE
 *
 * EXTERNAL REFERENCES  CDIB
 *
 * EXTERNAL FUNCTIONS   DOSOPEN, DOSREAD, DOSCHGFILEPTR, DOSCLOSE,
 *                      DOSGETSHRSEG, DOSFREESEG, DOSALLOCSEG, DOSREALLOCSEG
 *
*/


/*********************** START OF SPECIFICATIONS ***********************/
/*                                                                     */
/* SUBROUTINE NAME:  GetCodePage                                       */
/*                                                                     */
/* DESCRIPTIVE NAME:   Get the Prepared CodePages for the VDH          */
/*                                                                     */
/* FUNCTION:   Get Valid Code Page List from DOSGETCP.                 */
/*                                                                     */
/* NOTES:  Executes on Level 3                                         */
/*                                                                     */
/* ENTRY POINT:  GetCodePage                                           */
/*   LINKAGE:  Call GetCodePage                                        */
/*                                                                     */
/* INPUT:                                                              */
/*                                                                     */
/* EXIT-NORMAL:  AX = 0                                                */
/*                                                                     */
/* EXIT-ERROR:  AX = DOSxxx return code                                */
/*                                                                     */
/* EFFECTS:  None                                                      */
/*                                                                     */
/* INTERNAL REFERENCES: None                                           */
/*                                                                     */
/* EXTERNAL REFERENCES:  None                                          */
/*   ROUTINES: DOSGETCP                                                */
/************************ END OF SPECIFICATIONS ************************/

#define INCL_BASE               /* ALL of OS/2 Base                */
#include <os2.h>
#include <cdib.h>               /* CDIB defines                    */

#include "vdhctl.h"             /* Conditional compilation control */
#include "vdh.h"                /* Type definitions                */

/*
 *  Externally defined global variables
 */

extern  USHORT CodePageTable[];

USHORT PASCAL near GetCodePage()
{
USHORT rc, i;
USHORT CodePage[3];

//
// Initialize CodePage Table.
//

  rc = DosGetCp( sizeof(CodePage), (PUSHORT)CodePage, (PUSHORT)&i );
  CodePageTable[0] = CodePage[1];
  CodePageTable[1] = CodePage[2];

  return(rc);
}

//---------------------------------------------------------------------------
