;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = VDHEQU.INC
;*
;* DESCRIPTIVE NAME = Macros, definitions for base video
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION  Macros, definitions for base video
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR   CHANGE DESCRIPTION
;*   --------  ----------  -----  --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx   xxxxxxx
;*   03/25/89              132     DCR 132 changes
;*   04/11/91              1348    NAKADA, Enable DBCS support in Vio-Window, DCR 1348
;*   09/25/91              B726706 WKB, OEM changes
;*   06/21/89  J-KKJ               KKJ, Norikae
;*   09/21/89  j-ys921             YS, Real Mode Support
;*   09/25/89  J-KK0925            KKJ, ROM Font -> RAM Font
;*   10/05/89  J-KK1005            KKJ, env_option
;*   10/12/89  J-KK1012            KKJ, Move STRUC into VDHSTRUC.INC
;*   10/16/89  J-KK1016            KKJ, Add EQU for Xvio Interface
;*   10/17/89  J-KK1017            KKJ, Add CLEARED_LVB EQU in Sub_Option and DBCSEvBuffSize.
;*   10/19/89  J-KK1019            KKJ,     CLEARED_LVB (3->4)
;*   10/20/89  j-ys1020,1027            for MS-Xvio support.
;*   10/26/89  J-KK1026            KKJ, Add CA_Request
;*   12/14/89  J-KK1214            KKJ, Add MemMap_GraphC2 for 1040x768
;*   01/10/90  J-KK0110            KKJ, Add Real_Mode flag in a Sub_Option field.
;*   01/25/90  J-KK0125            KKJ, Change Font Attribute for Install.
;*   02/06/90  J-KK0206            KKJ, Add ALL_REDRAWN bit in Sub_Option.
;*   02/20/90  J-KKB12             KKJ, Add Read_Ope bit.
;*   06/22/90  @KK0622             KKJ, Must not call DOSGETSEG at HardError. Fix AS/400 Problem.
;*                                      Add SPE_REDRAW equ. to request a special request.
;*
;*****************************************************************************/

        include vdhctl.inc              ; Conditional assembly control J-KK1002

;STJFMT,,16

;;-----------------------------------------
;; Max Slot Number
maxslot         equ     8
;;-----------------------------------------

ENVFLAG_3xBOX   equ     0001h           ;j-ys921

DBCSEvBuffSize  equ     10              ;J-KK1017

FUNC_NUM        EQU     256             ; BufferUpdate function number
GRAPHICS_MODE   EQU     0000000000000010b ; Mode type bit 1
PVB_SEL_BIT     EQU     0000000000000001b ; PVB flag bit
LVB_SEL_BIT     EQU     0000000000000010b ; LVB flag bit
CGAAttr         EQU     0000000000000100b ; passed attrs are CGA format ;@P1
RESERVED_FLAGS  EQU     1111111111111000b
I_ReadCellTypes equ     0               ; table for EGA format LVB      ;@P1
I_ReadCharStr   equ     1               ; Read characters               ;@P1
I_ReadCellStr   equ     2               ; Read character/attribute 's   ;@P1
I_ScrollUp      equ     3               ; Scroll window up              ;@P1
I_ScrollDown    equ     4               ; Scroll window down            ;@P1
I_ScrollLeft    equ     5               ; Scroll window left            ;@P1
I_ScrollRight   equ     6               ; Scroll window right           ;@P1
I_WrtCellStr    equ     7               ; Write character/attribute 's  ;@P1
I_WrtCharStr    equ     8               ; Write characters              ;@P1
I_WrtCharStrAt  equ     9               ; Write characters with attr    ;@P1
I_WrtNChar      equ     0ah             ; Write character N times       ;@P1
I_WrtNAttr      equ     0bh             ; Write attribute N times       ;@P1
I_WrtNCell      equ     0ch             ; Write cell N times            ;@P1
I_LVBToPVB      equ     0dh             ; Copy the LVB to the PVB       ;@P1
MIN_WRT_INDEX   EQU     7               ;@P1
MAX_INDEX       EQU     13              ; Max index value allowed       ;@P1
STATUS_PORT     EQU     3DAH            ; Video port for retrace status

WorldAttrCount  equ     3               ;@P1
WorldFMTATTR    equ     0370h           ;@P1
WorldCellSize   equ     4               ;@P1
DefaultCellSize equ     2               ;@P1
LEFT            equ     0001h           ;@P1
UP              equ     0002h           ;@P1
RIGHT           equ     0004h           ;@P1
DOWN            equ     0008h           ;@P1
LVBPVB          equ     0010h           ;@P1
DOMOVE          equ     0001h           ;@P1
DOFILL          equ     0002h           ;@P1

;;======================================= Following are Japanese Unique code.
ATLAS3AttrCount equ     3               ; ATLAS 3 byte format
ATLAS3FMTATTR   equ     0300h           ; 
ATLAS3CellSize  equ     4               ; 
;;------------------------------------------------------------------------
;; Japanese Video Mode Index Number
;;      This value must be set into env_jformat at setting Video Mode.
;;      This value relates to a function index in XGAWRITE/XGASCROL.
;;------------------------------------------------------------------------
EPOCH_Format    equ     0               ; Epoch Format
COMMON_Format   equ     2               ; Common Format
ATLAS3_Format   equ     COMMON_Format+2 ; Atlas 3 byte Attribute Format
ATLASUS_Format  equ     COMMON_Format+4 ; U.S. Emualtion Format

ATTR_INFORM     EQU     00000100b       ; ATTRIBUTE Information bit ;J-KKJ

;;------------- Japan Unique EQU ---------------------------------------
dbcsE1          equ     01              ;DBCS flag      for Epoch Format
dbcsE2          equ     02              ;DBCS 2nd flag  for Epoch Format
dbcsA1          equ     01              ;DBCS flag      for Atlas Format
dbcsA1H         equ     0100h           ;DBCS flag      for Atlas Format
dbcsA2          equ     80h             ;DBCS 2nd flag  for Atlas Format
dbcsA2H         equ     8000h           ;DBCS 2nd flag  for Atlas Format
TOEXT           equ     1000h           ;Extra Attribute Offset for Atlas Format
ATLAS_BLINK     equ     80h             ;Blink/H-Int bit in Attr0 for Atlas Format


;;ͻ
;; Must be identical with ones in VDH.H !!!!!                                
;; [bp].Sub_Option                                                           
;;ͼ
;; Following Global Bit
BLINK_STATE     equ     1               ;MSB in Attr0 means Blinking not H-Int for Atlas Format
                                        ;This bit is affected to "env_attr_state".
ALWAYS_FNTCALL  equ     2               ; Always Call Font SubSystem  J-KK1005
ALL_REDRAWN     equ     4               ; All screen is redrawn by Xvio.J-KK0206
SPE_REDRAWN     equ     8               ; Special Redraw Req. to Xvio.  @KK0622

;;----------------------------------------------------------------------------
;; Following Local Bit
CLEARED_LVB     equ     100h            ; LVB has been cleared.       J-KK1019
CA_Request      equ     200h            ; Request From MS-XVIO        J-KK1026
LVB_Changed     equ     400h            ; LVB Selector Changed        J-KK1026
f_restfromlvb   equ    0800h            ; restore form LVB ( XvioM )  ;j-ys111
f_end_adjust    equ    1000h            ; DBCS exception handling ( XVioM );j-ys111
Read_Ope        equ    4000h            ; Read Operation                J-KKB12
Real_Mode       equ    8000h            ; Real Mode Flag                J-KK0110


;; Extra Attribute 1 and 2 for Atlas
                IFDEF   FONT_SUPPORT    ; 
EXTRA_ATTR          equ     1C00h       ; RAM SBCS                    ;;J-KK0925
                ELSE
;;J-KK0125 EXTRA_ATTR          equ     0200h       ; Extra SBCS in ROM   <=== Dummy
EXTRA_ATTR      equ     0000h           ; Extra SBCS in ROM             J-KK0125
                ENDIF


EXTRA_ATTRHigh  equ     EXTRA_ATTR/ 256 ; RAM SBCS High             ;;J-KK0925
EXTRA_ATTR1     equ     EXTRA_ATTR+dbcsA1H ; DBCS 1st Attr for Extra Attr
EXTRA_ATTR2     equ     EXTRA_ATTR+dbcsA1H+dbcsA2H ; DBCS 2nd Attr for Extra Attr

TypeE           equ     EXTRA_ATTRHigh      ;Default Base      Hankaku
TypeF           equ     01EH                ;Default Extention Hankaku

SBCS_TYPE_MASK  equ     01Eh                ; SBCS type select bit mask ;J-TS00

CHANGE_BIT      equ     4000h               ; displayed char is changed ;J-TS00
CHANGE_BITHigh  equ     CHANGE_BIT/256      ; 
UNDERLINE_BIT   equ     80h                 ; attribute bits of common DBCS
REVERSE_BIT     equ     40h                 ; format attr1
BLINK_BIT       equ     20h                 ; 
TRANS_BIT       equ     10h                 ; 
VERT_BIT        equ     08h                 ; 
HORZ_BIT        equ     04h                 ; 

A_BLINK_BIT     equ     80h                 ; attribute bits of ATLAS 3 bytes ;J-TS00
A_UNDERLINE_BIT equ     40h                 ; format attr1              ;J-TS00
A_COLUMN_BIT    equ     20h                 ;                           ;J-TS00
A_TRANS_BIT     equ     08h                 ;                           ;J-TS00
A_RVERT_BIT     equ     04h                 ;                           ;J-TS00
A_HORZ_BIT      equ     02h                 ;                           ;J-TS00
A_VERT_BIT      equ     01h                 ;                           ;J-TS00

;;------------------------------------------------------------------------
;; Index Number
;;------------------------------------------------------------------------
RCELLT          equ     0               ;ReadCellTypes
RCHAR           equ     1               ;ReadCharStr
RCELL           equ     2               ;ReadCellStr
SCRUP           equ     3               ;ScrollUp
SCRDN           equ     4               ;ScrollDown
SCRL            equ     5               ;ScrollLeft
SCRR            equ     6               ;ScrollRight
WCELL           equ     7               ;WriteCellStr
WCHAR           equ     8               ;WriteCharStr
WCHARA          equ     9               ;WriteCharStrAttr
WNCHAR          equ     10              ;WriteNChar
WNATTR          equ     11              ;WriteNAttr
WNCELL          equ     12              ;WriteNCell
CLVBToPVB       equ     13              ;Copy the LVB to the PVB
;;----------------------------------------------------------------------

ls              equ     0e0h            ;sequencer
lf              equ     0e2h            ;font mover
lc              equ     0e4h            ;crtc
lv              equ     0e8h            ;video attr
lg              equ     0eah            ;graphics

;;----------------------------------------------------------------------
;; Memory Map Order Number
;;----------------------------------------------------------------------
MemMap_ATLAS80  equ     0
MemMap_ATLAS82  equ     1
MemMap_EPOCH80  equ     2
MemMap_EPOCH82  equ     3
MemMap_GraphM   equ     4
MemMap_GraphC   equ     5               ; 1024x768
MemMap_GraphC2  equ     6               ;Add 1040x768                   J-KK1214

MemMap_VGAGraphM equ    7
MemMap_VGAGraphC equ    8

;;----------------------------------------------------------------------
;; Order Number to FNTCALLS.
;;----------------------------------------------------------------------
Font_EPOCHT     equ     0               ; Epoch Text
Font_EPOCHG     equ     1               ; Mono  (Epoch) Graphics
;;J-KK0925 Font_PHOENIXT           equ  2          ; Phoenix Text (Only Color)
;;J-KK0925 Font_PHOENIXG           equ  3          ; Color Graphics
Font_ATLAS      equ     2               ; ATLAS Text
Font_ATLASG     equ     3               ; Color (ATLAS) Graphics
Font_VGA        equ     8000h


;;----------------------------------------------------------------------
;; Xvio Interface to Hide and Redraw                            J-KK1016
;;----------------------------------------------------------------------
Suspend         equ     1               ; Option
Resume          equ     2
NoOption        equ     0
HardErr_Redraw  equ     8          ; Redraw Request at HardError Popup. @KK0622

XvsInitialize   equ      0
XvsSuspend      equ      1
XvsResume       equ      2
XvsHide         equ      3
XvsRedraw       equ      4
XvsSetBuf       equ      5
XvsSetMode      equ      6
XvsSetState     equ      7
XvsSetCurPos    equ      8
XvsSetCurType   equ      9
XvsSetTimeout   equ     10
XvsSetCP        equ     11

;;----------------------------------------------------------------------
;; This Structure must be identical to VIDEOMODE in VDH.H.
;;----------------------------------------------------------------------
modedata        STRUC                   ;Mode data structure
mode_datalen    dw      14              ;Length of mode data
mode_type       db      ?               ;Type for Mode
mode_colors     db      ?               ;Colors for Mode
mode_cols       dw      ?               ;Number of screen columns for text
mode_rows       dw      ?               ;Number of screen rows for text
mode_gcols      dw      ?               ;Number of screen columns for graphics
mode_grows      dw      ?               ;Number of screen rows for graphics
mode_formatid   db      ?               ;Format ID
mode_attrcount  db      ?               ;Counts of attribute
mem_map         db      ?               ;Memory Map ID
format_index    dw      ?               ;Format Index Number
Font_index      dw      ?               ;Font   Index Number
proc_offset     dw      ?               ;Mode Procedure Offset
Default_data    dw      ?               ;Default Data Index
modedata        ENDS
