;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = VDHDATA.INC
;*
;* DESCRIPTIVE NAME = BASE VIDEO DEFINITIONS
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION  This file contains some of the definitions needed for
;*              different resolutions
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR    CHANGE DESCRIPTION
;*   --------  ----------  -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx   xxxxxxx
;*   04/14/89              B701111 Remove negative logic,
;*   06/10/89                      Init SCREEN$ handle to zero to avoid extra open
;*   08/22/89              B785343 Add unique code for CGA 8x8 fonts. B785343
;*   01/24/90              704     DCR 704 work
;*   07/08/91                      Reduce memory consumption
;*   06/21/89  J-KKJ               KKJ, Norikae
;*   09/01/89  J-KK0901            KKJ, Changed the palette registers' value for "MONO" mode
;*   09/25/89  J-KK0925            KKJ, Support FNTCALLS.
;*   09/26/89  J-KK0926            KKJ, Add Common Segment to communicate with Xvio.
;*   10/16/89  J-KK1016            KKJ, Changed Memmap_ATLAS82 -> ATLAS80
;*                                      ATLAS Mono 82x25 uses "atlasmono_text" to change a grid color.
;*   10/20/89  J-KK1020            KKJ, Delete lc_atlas_m3m4 data.
;*                                      Change ATLAS 82x25 Mono Grid Color to White from Green.
;*   10/23/89  J-KK1023            KKJ, Change Cursor Control Value from "Replace" to "Change".
;*   10/24/89  J-KK1024            KKJ, Change Cursor Color in Epoch Mono Mode (Real).
;*   10/27/89  J-KK1027            KKJ, Change Palette 1 value to Blck for Epoch Mono (OS/2).
;*   10/30/89  J-KK1030            KKJ, PTR130, Change Default Palette values for ATLAS Mono 82x25.
;*   12/01/89  J-KK1130&1201       KKJ, Support 256 Colors Graphics Mode.
;*   12/14/89  J-KK1214            KKJ, Change to MemMap_GraphC2
;*   01/09/90  J-KK0109            KKJ, Change Yellow Palette to the same as EPOCH.
;*   01/24/90  J-KK0112            KKJ, Change CRTC data for 256 Color Mode
;*   01/31/90  J-KK0131            KKJ, Change CRTC data for Dallas
;*   02/08/90  J-KK0208            KKJ, Add IFNDEF  INSTALLATION.
;*   03/08/90  J-KKB17             KKJ, Change MemMap_GraphC -> MemMap_GraphC2 for 256 colors.
;*   03/09/90                      KKJ, Change Grid Color in CO80 and Epoch Color. 07h -> 0Fh
;*                                      ( White -> Hint White )                    PTR0617
;*                                      Fix     : Defalut Cursor Length for Dallas.
;*   05/29/90  @KK0529             KKJ, Change Default DAC table value in Mono/Color graphic mode.
;*   06/08/90  @camel              KKJ, Change Default Palette01 value in Mono graphic mode.
;*   07/04/90  @camel2             KKJ, Fix H/W     for ATLAS-II
;*   08/15/90  @KK0815             KKJ, Change Temp. VGA Graphic Data. Not Use in Normal Case.
;*   11/29/90  @KK1129             KKJ, Should not set value in registers which are not in spec.
;*   12/13/90  @KK1213             KKJ, Change the mode register's value to 14h from 10h.
;*                                      Refer to Morimoto san's note. This is Wada san's request.
;*   12/17/90  @VGAG               KKJ, Delete data to support a VGA graphic mode.
;*             J-TS102291          TSO, PTR JS01738 During VioPopUp, Screen group ID is forced
;*                                      to No.3 with no notification.
;*
;*****************************************************************************/

_DATA   SEGMENT WORD PUBLIC 'DATA'


        PUBLIC  __acrtused
__acrtused equ  1                       ;C Comp puts out 'EXTRN __acrtused:ABS'

        public  _XGAExist, XGAExist                                     ;J-TS00
        public  _BlinkOption, BlinkOption                               ;J-TS00
        public  _VideoBuff, VideoBuff, VideoBuffSel                     ;J-TS00

        public  _HardwareScroll, HardwareScroll                         ;J-TS00
        public  PrevLineComp, MaxLineComp                               ;J-TS00

_HardwareScroll label   word                                            ;J-TS00
HardwareScroll  dw  PROTECT_HS_LC       ; hardware scroll option        ;J-TS00
PrevLineComp    dw  ?                   ; hardware scroll param         ;J-TS00
MaxLineComp     dw  ?                   ; hardware scroll param         ;J-TS00

_VideoBuff  label   dword                                               ;J-TS00
VideoBuff    dw     ?                   ; VGA text emulation buffer     ;J-TS00
VideoBuffSel dw     ?                   ; (selector part)               ;J-TS00

_XGAExist   label   word                ; dummy label for C             ;J-TS00
XGAExist    dw  ?                       ; XGA exist flag                ;J-TS00
_BlinkOption label  word                ; dummy label for C             ;J-TS00
BlinkOption dw  ?                       ; DBCS VGA mode blink flag      ;J-TS00

;--------------------------------------------------------------------------
; This is the default color lookup table used on a VGA when a color mode is
; specified via VioSetMode and the 'enable color burst' flag is specified.
;--------------------------------------------------------------------------

        PUBLIC  _ColorCLUT
_ColorCLUT db   00h,00h,00h,00h,00h,2Ah,00h,2Ah,00h,00h,2Ah,2Ah
        db      2Ah,00h,00h,2Ah,00h,2Ah,2Ah,2Ah,00h,2Ah,2Ah,2Ah
        db      00h,00h,15h,00h,00h,3Fh,00h,2Ah,15h,00h,2Ah,3Fh
        db      2Ah,00h,15h,2Ah,00h,3Fh,2Ah,2Ah,15h,2Ah,2Ah,3Fh

        db      00h,15h,00h,00h,15h,2Ah,00h,3Fh,00h,00h,3Fh,2Ah
        db      2Ah,15h,00h,2Ah,15h,2Ah,2Ah,3Fh,00h,2Ah,3Fh,2Ah
        db      00h,15h,15h,00h,15h,3Fh,00h,3Fh,15h,00h,3Fh,3Fh
        db      2Ah,15h,15h,2Ah,15h,3Fh,2Ah,3Fh,15h,2Ah,3Fh,3Fh

        db      15h,00h,00h,15h,00h,2Ah,15h,2Ah,00h,15h,2Ah,2Ah
        db      3Fh,00h,00h,3Fh,00h,2Ah,3Fh,2Ah,00h,3Fh,2Ah,2Ah
        db      15h,00h,15h,15h,00h,3Fh,15h,2Ah,15h,15h,2Ah,3Fh
        db      3Fh,00h,15h,3Fh,00h,3Fh,3Fh,2Ah,15h,3Fh,2Ah,3Fh

        db      15h,15h,00h,15h,15h,2Ah,15h,3Fh,00h,15h,3Fh,2Ah
        db      3Fh,15h,00h,3Fh,15h,2Ah,3Fh,3Fh,00h,3Fh,3Fh,2Ah
        db      15h,15h,15h,15h,15h,3Fh,15h,3Fh,15h,15h,3Fh,3Fh
        db      3Fh,15h,15h,3Fh,15h,3Fh,3Fh,3Fh,15h,3Fh,3Fh,3Fh

;-----------------------------------------------------------------------
; This is the default color lookup table used on a VGA when a monochrome
; mode is specified via VioSetMode.
;-----------------------------------------------------------------------

        PUBLIC  _MonoCLUT
_MonoCLUT db    00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
        db      00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
        db      2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah
        db      2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah

        db      00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
        db      00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
        db      3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh
        db      3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh

        db      00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
        db      00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
        db      2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah
        db      2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah,2Ah

        db      00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
        db      00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h,00h
        db      3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh
        db      3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh,3Fh

;--------------------------------------------------------------------------
; This is the default color lookup table used on a VGA when a color mode is
; specified via VioSetMode and the 'disable color burst' flag is specified.
;--------------------------------------------------------------------------

        PUBLIC  _SumCLUT
_SumCLUT db     00h,00h,00h,05h,05h,05h,19h,19h,19h,1Dh,1Dh,1Dh
        db      0Dh,0Dh,0Dh,11h,11h,11h,25h,25h,25h,2Ah,2Ah,2Ah
        db      02h,02h,02h,07h,07h,07h,1Bh,1Bh,1Bh,20h,20h,20h
        db      0Fh,0Fh,0Fh,14h,14h,14h,28h,28h,28h,2Ch,2Ch,2Ch

        db      0Ch,0Ch,0Ch,11h,11h,11h,25h,25h,25h,2Ah,2Ah,2Ah
        db      19h,19h,19h,1Eh,1Eh,1Eh,32h,32h,32h,36h,36h,36h
        db      0Fh,0Fh,0Fh,13h,13h,13h,27h,27h,27h,2Ch,2Ch,2Ch
        db      1Bh,1Bh,1Bh,20h,20h,20h,34h,34h,34h,39h,39h,39h

        db      06h,06h,06h,0Bh,0Bh,0Bh,1Fh,1Fh,1Fh,24h,24h,24h
        db      13h,13h,13h,18h,18h,18h,2Ch,2Ch,2Ch,30h,30h,30h
        db      09h,09h,09h,0Dh,0Dh,0Dh,21h,21h,21h,26h,26h,26h
        db      15h,15h,15h,1Ah,1Ah,1Ah,2Eh,2Eh,2Eh,33h,33h,33h

        db      13h,13h,13h,17h,17h,17h,2Bh,2Bh,2Bh,30h,30h,30h
        db      1Fh,1Fh,1Fh,24h,24h,24h,38h,38h,38h,3Dh,3Dh,3Dh
        db      15h,15h,15h,1Ah,1Ah,1Ah,2Eh,2Eh,2Eh,32h,32h,32h
        db      22h,22h,22h,26h,26h,26h,3Ah,3Ah,3Ah,3Fh,3Fh,3Fh


_DATA   ENDS

EXTRN   _HugeShift:WORD

INSTSEG SEGMENT WORD PUBLIC 'DATA'

        PUBLIC  _hScreenDD

_hScreenDD dw   0                       ;@S15

INSTSEG ENDS
