/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**************************************************************************
 *
 * SOURCE FILE NAME = VDHDATA.H
 *
 * DESCRIPTIVE NAME = Video Device Handler data include file
 *
 *
 * VERSION = V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS    NONE
 *
 * NOTES
 *
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*----------------------------------------------------------------------------*/
/* Global variables - data shared by more than one VDH routine                */
/*----------------------------------------------------------------------------*/
USHORT HugeShift = 0;   /* Amount added to a huge selector to get to the next */
USHORT DeviceDriver = 0;/* version number                                     */
UCHAR FIRST_ENTRY = TRUE; /* Flag to force only one device initialization     */
UCHAR FIRST_INIT = TRUE; /* Flag to force only one INIT device initialization */
UCHAR FIRST_RETCONFIG = TRUE; /* Flag to First RetConfigInfo entry.     J-KKJ */
USHORT IStart = 0;       /* Mode table starting point (memory-size dependent) */
UCHAR READABLE = 0;      /* Flag to determine if hardware is write-only */
USHORT ConfigFlag = 0;
ULONG PartialSaveSize=0;/* Room required to save entire PVB in the popup mode */
UCHAR DefaultAttribute[] = {0x07,0x0,0x0};/* default attribute used by WrtTTY */
CLUTDATA far *LCLUT = 0 ;                                              /*@S40f*/
USHORT CodePageZero = 437;   // VGA ROM Code Page                     J-KK1024
SEL   CommonSelector = 0;    /* Common Selector to Xvio               J-KK0929*/

VIDEOHARDWARE VideoHardware = {0};  /* installed video hardware */      /*@T39*/
#ifdef  J_INSTALL                                                       //J-TS00V
VIDEOHARDWAREJ VideoHardwareJ = {0};  /* installed video hardware */    //J-TS00V
#endif  //J_INSTALL                                                     //J-TS00V

USHORT InitPointerDone = FALSE; /* pointer initialization done flag */  //J-TS111692
DOSFSRSEM SemAccessAPA = {0};   /* APA exclusive access semaphore */    //J-TS011792

ENVIRONMENT Env1 = {0}; /* Popup environment */                   /*@T42,@T42f*/
ENVIRONMENT Env2 = {0}; /* Harderr environment */                 /*@T42,@T42f*/

UCHAR HarderrFlag = 0 ; // Hard Error Flag                              @KK0622

//@2KK0531 USHORT CodePageTable[MAX_CODEPAGES];              /* Code Page Table  J-KK1002*/
USHORT CodePageTable[MAX_CODEPAGES] = {0};     /* Code Page Table  @2KK0531*/

USHORT (APIENTRY *ChainedCallVectorTable[MaxFn])() = {0};            /* @T24 */

USHORT VGA_PRESENT = 0;  /* TRUE if VGA VDH has been installed */
VDHCONFIGINFO VGAConfigData = {0};

extern USHORT hScreenDD;     /* Handle to screen device driver ( for DosDevIOCtl ) */

// OEM Flags:
//      This word contains flags used to remember that an OEM video
//      adapter has been detected.  This may be used to control the
//      programming of features unique to a particular vendor's
//      implementation of one of the OS/2 supported video adapters.

USHORT  OEMFlags        = 0x0000;
USHORT  SVGAPresent     = FALSE;                // @drw

/*----------------------------------------------------------------------------*/
/* Table of VDH entry points                                                  */
/*                                                                            */
/* Device chaining is not implemented in these video device handlers.  If the */
/* VDH supports the VDH function, DevEnable will over-write the current       */
/* entry in the call vector table.  If the VDH does not support the VDH       */
/* function, the call vector table entry will not be touched.                 */
/*----------------------------------------------------------------------------*/
#ifdef  J_INSTALL                                                       //J-TS00
static USHORT far * far VDHEntryPoint[] = {

                             (USHORT far *)BufferUpdate,        /* 256 */
                             (USHORT far *)InitEnv,             /* 257 */
                             (USHORT far *)SaveEnv,             /* 258 */
                             (USHORT far *)RestoreEnv,          /* 259 */
                             (USHORT far *)RetConfigInfo,       /* 260 */
/* Get DBCS Display Info */  (USHORT far *)GetDBCSInfo,         /* 261  @P1 */
                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 262 */
                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 263 */
                             (USHORT far *)GetCursorInfo,       /* 264 */
                             (USHORT far *)SetCursorInfo,       /* 265 */
                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 266 */
                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 267 */
                             (USHORT far *)GetMode,             /* 268 */
                             (USHORT far *)SetMode,             /* 269 */
                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 270 */
                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 271 */
                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 272 */
                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 273 */
                             (USHORT far *)GetVariableInfo,     /* 274 */
                             (USHORT far *)SetVariableInfo,     /* 275 */
                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 276  @P1 */
                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 277 */ //J-TS00
                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 278  @P1 */
/* Get LVB size info     */  (USHORT far *)GetLVBInfo};         /* 279  @P1 */
#else   //J_INSTALL                                                     //J-TS00
static USHORT far * far VDHEntryPoint[] = {

                             (USHORT far *)BufferUpdate,        /* 256 */
                             (USHORT far *)InitEnv,             /* 257 */
                             (USHORT far *)SaveEnv,             /* 258 */
                             (USHORT far *)RestoreEnv,          /* 259 */
                             (USHORT far *)RetConfigInfo,       /* 260 */
/* Get DBCS Display Info */  (USHORT far *)GetDBCSInfo,         /* 261  @P1 */
                             (USHORT far *)GetColorLookup,      /* 262 */
                             (USHORT far *)SetColorLookup,      /* 263 */
                             (USHORT far *)GetCursorInfo,       /* 264 */
                             (USHORT far *)SetCursorInfo,       /* 265 */
                             (USHORT far *)GetCurrentFont,      /* 266 */
                             (USHORT far *)SetCurrentFont,      /* 267 */
                             (USHORT far *)GetMode,             /* 268 */
                             (USHORT far *)SetMode,             /* 269 */
                             (USHORT far *)GetPaletteReg,       /* 270 */
                             (USHORT far *)SetPaletteReg,       /* 271 */
                             (USHORT far *)GetPhysBuf,          /* 272 */
                             (USHORT far *)FreePhysBuf,         /* 273 */
                             (USHORT far *)GetVariableInfo,     /* 274 */
                             (USHORT far *)SetVariableInfo,     /* 275 */
                             (USHORT far *)CloseEnv,            /* 276  @P1 */ //J-TS00
                             (USHORT far *)PrintScreen,         /* 277 */ //J-TS00
                             (USHORT far *)UNSUPPORTED_FUNCTION,/* 278  @P1 */
/* Get LVB size info     */  (USHORT far *)GetLVBInfo};         /* 279  @P1 */
#endif  //J_INSTALL                                                     //J-TS00

//-----------------------------------------------------------------------------
// Video Mode Table
//
// typedef struct {
//           USHORT cb;              /* VioGetMode structure              */
//           UCHAR  fbType;
//           UCHAR  color;
//           USHORT col;
//           USHORT row;
//           USHORT hres;
//           USHORT vres;
//           UCHAR  fmt_ID;
//           UCHAR  attrib;
//
//           USHORT Format_Index;
//           USHORT HW_Index;
//           } VIDEOMODE;
//-----------------------------------------------------------------------------

    VIDEOMODE Modes[] = {

//  0 CO80 3+ Emulation Mode
        { 14, 1, 4, 80, 25,  720, 400,    0, 1, MemMap_ATLAS, ATLASUS_Format, HW_DBCS_VGA },

//  1 CO80 3* Emulation Mode
        { 14, 1, 4, 80, 25,  640, 350,    0, 1, MemMap_ATLAS, ATLASUS_Format, HW_DBCS_VGA },

//  2 CO80 3  Emualtion Mode
        { 14, 1, 4, 80, 25,  640, 200,    0, 1, MemMap_ATLAS, ATLASUS_Format, HW_DBCS_VGA },

//  3 MONO 7+ Emulation Mode
        { 14, 0, 0, 80, 25,  720, 400,    0, 1, MemMap_ATLAS, ATLASUS_Format, HW_DBCS_VGA },

//  4 MONO 7  Emulation Mode
        { 14, 0, 0, 80, 25,  720, 350,    0, 1, MemMap_ATLAS, ATLASUS_Format, HW_DBCS_VGA },

//  5 ATLAS   Common    Mode
        { 14, 1, 4, 80, 25, 1040, 725, 0x70, 3, MemMap_ATLAS, COMMON_Format,  HW_ATLAS    },

//  6 ATLAS Color 82x25 Mode
        { 14, 1, 4, 82, 25, 1066, 725,    0, 3, MemMap_ATLAS, ATLAS3_Format,  HW_ATLAS3_C },

//  7 ATLAS Mono  82x25 Mode
        { 14, 1, 1, 82, 25, 1066, 725,    0, 3, MemMap_ATLAS, ATLAS3_Format,  HW_ATLAS3_M },

//  8 EPOCH   Mono      Mode
        { 14, 1, 1, 80, 25, 1040, 725,    1, 1, MemMap_ATLAS, EPOCH_Format,   HW_EPOCH_M  },

//  9 EPOCH   Mono      Mode
        { 14, 1, 1, 80, 24, 1040, 696,    1, 1, MemMap_ATLAS, EPOCH_Format,   HW_EPOCH_M  },

// 10 EPOCH   Mono      Mode
        { 14, 1, 1, 80, 24, 1040, 725,    1, 1, MemMap_ATLAS, EPOCH_Format,   HW_EPOCH_M  },

// 11 EPOCH   Color     Mode
        { 14, 1, 4, 80, 25, 1040, 725,    1, 1, MemMap_ATLAS, EPOCH_Format,   HW_EPOCH_C  },

// 12 EPOCH   Color     Mode
        { 14, 1, 4, 80, 24, 1040, 696,    1, 1, MemMap_ATLAS, EPOCH_Format,   HW_EPOCH_C  },

// 13 EPOCH   Color     Mode
        { 14, 1, 4, 80, 24, 1040, 725,    1, 1, MemMap_ATLAS, EPOCH_Format,   HW_EPOCH_C  }
    };

//-----------------------------------------------------------------------------
//  Hardware Defaults Setting Values Table
//
// typedef struct {
//             UCHAR Palettes[0x0F+1];
//             UCHAR GridColor;
//             UCHAR CursorColor;
//             UCHAR CursorControl;
//             UCHAR CursorStart;
//             UCHAR CursorEnd;
//             UCHAR CursorLocHigh;
//             UCHAR CursorLocLow;
//             UCHAR CursorWidth;
//             REGCMD ModeRegs[MAX_MODE_CMDS+1];   /* Register command table */
//           } HW_DEFAULT;
//-----------------------------------------------------------------------------

    HW_DEFAULT HW_Default[] = {

// ATLAS Color ( 80x26 )  ; 80x26 Color Text For Protect Mode
        {
          0x0F, 0x0F, 0, 26, 27, 0, 0, 1,
          {
            { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
            { Sequencers_CMD, { "\x01\x01\x0F\x00\x06", 0x00, 0x04+1 } },
            { CRTCtlRegs_CMD, { "\x05", 0x11, 0x01 } },
            { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x54\x80\xB\x3E\x0\x40\x0\x0\x0\x0\x0\x0\xEA\x8C\xD3\x40\x0\xE7\x4\xC3\xFF", 0x00, 0x18+1 } },
            { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
            { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\x01\x0\x0F\x0\x0", 0x00, 0x15 } },
            { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x05\x0F\x0FF", 0x00, 0x09 } },
            { Terminate_CMD }
          }
        },

// ATLAS DBCS VGA ( 80x26 )  ; 80x26 Color Text For Protect Mode (VGA emulation)
        {
          0x0F, 0x0F, 0, 14, 15, 0, 0, 1,
          {
            { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
            { Sequencers_CMD, { "\x01\x01\x0F\x00\x06", 0x00, 0x04+1 } },
            { CRTCtlRegs_CMD, { "\x05", 0x11, 0x01 } },
            { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x54\x80\xB\x3E\x0\x40\x0\x0\x0\x0\x0\x0\xEA\x8C\xD3\x40\x0\xE7\x4\xC3\xFF", 0x00, 0x18+1 } },
            { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
            { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x14\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\x01\x0\x0F\x0\x0", 0x00, 0x15 } },
            { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x05\x0F\x0FF", 0x00, 0x09 } },
            { Terminate_CMD }
          }
        },

// ATLAS 3bytes Mono ( 82x26 )  ; 82x26 Color Text For Protect Mode
        {
          0x07, 0x02, 0, 26, 27, 0, 0, 1,
          {
            { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
            { Sequencers_CMD, { "\x01\x01\x0F\x00\x06", 0x00, 0x04+1 } },
            { CRTCtlRegs_CMD, { "\x05", 0x11, 0x01 } },
            { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x54\x80\xB\x3E\x0\x40\x0\x0\x0\x0\x0\x0\xEA\x8C\xD3\x40\x0\xE7\x4\xC3\xFF", 0x00, 0x18+1 } },
            { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
            { Attributes_CMD, { "\x0\x9\x12\x1B\x24\x2D\x36\x3F\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\x01\x0\x0F\x0\x0", 0x00, 0x15 } },
            { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x05\x0F\x0FF", 0x00, 0x09 } },
            { Terminate_CMD }
          }
        },

// ATLAS 3bytes Color ( 82x26 ) ; 82x26 Color Text For Protect Mode
        {
          0x07, 0x0F, 0, 26, 27, 0, 0, 1,
          {
            { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
            { Sequencers_CMD, { "\x01\x01\x0F\x00\x06", 0x00, 0x04+1 } },
            { CRTCtlRegs_CMD, { "\x05", 0x11, 0x01 } },
            { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x54\x80\xB\x3E\x0\x40\x0\x0\x0\x0\x0\x0\xEA\x8C\xD3\x40\x0\xE7\x4\xC3\xFF", 0x00, 0x18+1 } },
            { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
            { Attributes_CMD, { "\x0\x9\x12\x1B\x24\x2D\x36\x3F\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\x01\x0\x0F\x0\x0", 0x00, 0x15 } },
            { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x05\x0F\x0FF", 0x00, 0x09 } },
            { Terminate_CMD }
          }
        },

// 80x26 EPOCH Mono Emulation For Protect Mode
        {
          0x0A, 0x0E, 0, 26, 27, 0, 0, 1,
          {
            { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
            { Sequencers_CMD, { "\x01\x01\x0F\x00\x06", 0x00, 0x04+1 } },
            { CRTCtlRegs_CMD, { "\x05", 0x11, 0x01 } },
            { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x54\x80\xB\x3E\x0\x40\x0\x0\x0\x0\x0\x0\xEA\x8C\xD3\x40\x0\xE7\x4\xC3\xFF", 0x00, 0x18+1 } },
            { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
            { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x36\x7\x0\x39\x3A\x3B\x3C\x3D\x3A\x3F\x01\x0\x0F\x0\x0", 0x00, 0x15 } },
            { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x05\x0F\x0FF", 0x00, 0x09 } },
            { Terminate_CMD }
          }
        },

// 80x26 EPOCH Color Emulation For Protect Mode
        {
          0x0F, 0x0F, 0, 26, 27, 0, 0, 1,
          {
            { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
            { Sequencers_CMD, { "\x01\x01\x0F\x00\x06", 0x00, 0x04+1 } },
            { CRTCtlRegs_CMD, { "\x05", 0x11, 0x01 } },
            { CRTCtlRegs_CMD, { "\x5F\x4F\x50\x82\x54\x80\xB\x3E\x0\x40\x0\x0\x0\x0\x0\x0\xEA\x8C\xD3\x40\x0\xE7\x4\xC3\xFF", 0x00, 0x18+1 } },
            { RegOutput_CMD,  { "\xE3", MiscOutputRegWrite, 0x01 } },
            { Attributes_CMD, { "\x0\x1\x2\x3\x4\x5\x36\x7\x38\x39\x3A\x3B\x3C\x3D\x3E\x3F\x01\x0\x0F\x0\x0", 0x00, 0x15 } },
            { Graphics_CMD,   { "\x0\x0\x0\x0\x0\x0\x05\x0F\x0FF", 0x00, 0x09 } },
            { Terminate_CMD }
          }
        }
    };

/*----------------------------------------------------------------------------*/
/* Memory map table -                                                         */
/*    typedef struct {                                                        */
/*              ULONG      PageLength; ; Length of each page                  */
/*              USHORT     PageReal;   ; Length of each page (Real Mode)      */
/*              ULONG      TotalSize;  ; Total size of all pages combined     */
/*              ULONG      TotalReal;  ; Total size of all pages (Real Mode)  */
/*              USHORT     BitPlanes;  ; Flag byte of bit planes used         */
/*              FarAddress Start;                                             */
/*              } MEMORYMAPS;                                                 */
/*                                                                            */
/* These memory maps are used to save and restore the physical video buffer   */
/*----------------------------------------------------------------------------*/

MEMORYMAPS MemoryMaps[] = {
/*       {38400,0xA000, 153600,0x28000, 1+2+4+8, (char far *)0xA0000 }       */
/*@S4*/  {0x10000,0xA000, 0x40000,0x28000, 1+2+4+8, (char far *)0xA0000 } /* 12 */
        };

/*----------------------------------------------------------------------------*/
/* Color table for Palette handling                                           */
/*----------------------------------------------------------------------------*/

USHORT EpoPalette[16]
 = { BG_Color,BGH_Color,FG_Color,FGH_Color,0xFF,0xFF,0xFF,0xFF,Cur_Color,0xFF,
     0xFF,0xFF,0xFF,0xFF,0xFF,0xFF}; /*J-KK0905*/

//--- Epoch Mono Mode : Special Handling ---------------------------
// Normal Fore Color  attr=2h --> Palette  FG_Color    ( Ah --> 2h J-KK1027 )
// Normal Back Color  attr=0h --> Palette  BG_Color
// H-Int  Fore Color  attr=Fh --> Palette  FGH_Color
// H-Int  Back Color  attr=8h --> Palette  BGH_Color
// Cursor      Color  attr=Eh --> Palette  Cur_Color
//------------------------------------------------------------------

// Palette Registers Conversion Table                                 //J-KK1027
USHORT CnvPalette[16]={ 0,8,4,0xC,2,0xA,6,0xE,1,9,5,0xD,3,0xB,7,0xF}; //J-KK1027
//                    { 0,1,2,3,4,5,6,7,8,9,10,11,12,13,14,15      }; //J-KK1027
