;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = VDH.INC
;*
;* DESCRIPTIVE NAME = VDH macros and definitions
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION  VDH macros and definitions
;*
;* FUNCTIONS    NONE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*   DATE      FLAG        APAR    CHANGE DESCRIPTION
;*   --------  ----------  -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx  xxxxx   xxxxxxx
;*                         B726708 Removing IDC-specific code.  -AJP
;*   03/09/89                      Add new display type equates
;*   04/26/89              B701352 GET_ROMCP needed for accessfont routine
;*                         B701338
;*   08/04/89              B785016 Remove unnecessary reg saves in FixVGABug
;*                         B785017
;*   09/12/89              B708207 Fix from Steve Thompson for video buf
;*                         3789    corruption problem.
;*   06/21/89  J-KKJ               KKJ, Norikae 95
;*   09/12/89  J-KKJ               KKJ, Norikae 129
;*   09/25/89  J-KK0925            KKJ, Added ModeIndex_Real
;*   09/27/89  J-KK0927            KKJ, Expand HWCursor struct
;*   11/21/89  J-KKJ               KKJ, Norikae 161
;*   11/27/89  J-KK1127            KKJ, Changed AccessCursorPos and Type.
;*   11/30/89  J-KK1130            KKJ, Changed ModeIndex_VGA value for 256 Color mode.
;*   06/08/90   @camel2            KKJ, Copy ModeIndex definition from VDH.H
;*   12/26/90   @IDS               KKJ, Added IDS Mode Index
;*****************************************************************************/
;/**********************************************************************/
;/*  OCO  SOURCE  MATERIALS                                            */
;/*                                                                    */
;/*  WITH  THE  AGGREGATED  OCO  SOURCE  MODULES  FOR  THIS  PROGRAM)  */
;/**********************************************************************/
;SCCSID = @(#)vdh.inc   12.4 89/04/27
;STJFMT,,24                             ;Formatting parms for STJFMT

SHADOW_LENGTH   equ     82*26*4         ; physical video shadow buffer  ;J-TS00
FONT_HEIGHT     equ     18              ; font height (SBCS)            ;J-TS00
FONT_WIDTH      equ     8               ; font width (SBCS)             ;J-TS00
SCREEN_WIDTH    equ     80              ; screen size (width)           ;J-TS00
SCREEN_HEIGHT   equ     26              ; screen size (height)          ;J-TS00
APA_WIDTH       equ     128             ; APA line width                ;J-TS00

SRC_HEAD        equ     01h             ; source head dirty bit         ;J-TS00
SRC_TAIL        equ     02h             ; source tail dirty bit         ;J-TS00
DST_HEAD        equ     04h             ; target head dirty bit         ;J-TS00
DST_TAIL        equ     08h             ; target tail dirty bit         ;J-TS00

PROTECT_HS_ON   equ     2               ; hardware scroll on            ;J-TS00
PROTECT_HS_LC   equ     1               ; hardware scroll with lcomp    ;J-TS00
PROTECT_HS_OFF  equ     0               ; hardware scroll off           ;J-TS00

NOT_MONO                equ     1       ;xxxxxxxb b=0 Mono-compat, b=1 Other
GET_ROMCP               equ     2                                       ;@C17
GET                     equ     1
SET                     equ     0
SETWORD                 equ     2
WORDS                   equ     1
BYTES                   equ     0

COLOR_MODE              equ     1

TRUE                    equ     1
FALSE                   equ     0
NONE                    equ     0

SAVE                    equ     0
RESTORE                 equ     1

Attributes_CMD          equ     1
Sequencers_CMD          equ     2

CursorHidden            equ     00100000B

;
;ͻ
;  Display types                                                             
;ͼ
;
Mono8503                equ     03h     ;   VDHVGA, VDH8514A
Color8512_8513          equ     04h     ;   VDHVGA, VDH8514A
Color8514               equ     09h     ;   VDH8514A
Mono8507_8604           equ     0Bh     ;   VDH8514A ;D184
Color8515               equ     0Ch     ;   VDH8514A ;D184

MEM_1MB                 equ     1
VDHERROR_NO_ADAPTER     equ     0

CRTCtlAddressRegMono    equ     03B4h   ; CRT Controller Address Register (monochrome)
CRTCtlAddressRegColor   equ     03D4h   ; CRT Controller Address Register (color)


InputStatusReg1         equ     03BAh   ; Read input status register 1
SeqAddressPort          equ     03C4h
GraphAddressPort        equ     03CEh
FeatureControlWrite     equ     03BAh   ; Read Feature Control Register
ColorAdjustment         equ     20h
AttAddressPort          equ     03C0h
MiscOutputRegRead       equ     03CCh   ; Read Miscellaneous Output Register
MiscOutputRegWrite      equ     03C2h   ; Write Miscellaneous Output Register
MonoAdjustment          equ     0
CRTCtlAddressReg        equ     03B4h   ; CRT Controller Address Register
CRTCtlDataReg           equ     03B5h   ; CRT Controller Data Register
PELAddressRead          equ     03C7h   ; PEL Address Register for data read
PELAddressWrite         equ     03C8h   ; PEL Address Register for data write
SeqDataPort             equ     03C5h
AttCtlInitializeReg     equ     03BAh   ; Feature Control Register - init AttCtl flip-flop
IndClockModeReg         equ     01h     ; Address Clocking Mode in Sequencer
IndUnderlineLoc         equ     14h     ; Address Underline Location Register
AttDataReadPort         equ     03C1h
AttDataWritePort        equ     03C0h
IndOverscanColor        equ     11h     ; Address Overscan Color Register
IndCursorStart          equ     0Ah     ; Address Cursor Start Register
IndCursorEnd            equ     0Bh     ; Address Cursor End Register
IndAttModeCtl           equ     10h     ; Address Attribute Mode Control Register
PELDataRegister         equ     03C9h   ; PEL Data Register

IndCursorHighLoc        equ     0Eh     ; Address Cursor Location High Register
IndCursorLowLoc         equ     0Fh     ; Address Cursor Location Low Register


;;====================================== Following are Japanese Unique. ======

;;------------------------------------------------------------------------
;; Japanese Video Hardware Mode Index Number
;;      This value is set by access Hardware directly.
;; Caution !!!! This value must be identical to one in VDH.H.
;;------------------------------------------------------------------------
HWText    equ         1      ; Bit 0 - On: Text Mode
HWGraphic equ         2      ; Bit 1 - On: Graphic Mode
HWColor   equ         4      ; Bit 2 - On: Color / Off: Mono
HWEpoch   equ         8      ; Bit 4 - On: Epoch
HWAtlas   equ        10h     ; Bit 5 - On: ATLAS
HWCols82  equ       100h     ; Bit 9 - On: 82 cols / Off: 80 cols
HWVGA     equ      8000h     ; Bit 15 - On: VGA

;;----------------------------------------------------------------------------
;; Caution !!!! This value must be identical to ModeIndex_VGAMGAPHIC in VDH.H.
;; Caution !!!! This value must be identical to ModeIndex_RealMono   in VDH.H.
;;----------------------------------------------------------------------------
ModeIndex_ATLASCO80VGA  equ   0   ;  /* U.S. Emualtion Mode */
ModeIndex_ATLASCO80EGA  equ   1   ; 
ModeIndex_ATLASCO80CGA  equ   2   ; 
ModeIndex_ATLASMONOVGA  equ   3   ; 
ModeIndex_ATLASMONOEGA  equ   4   ; 
ModeIndex_ATLASUS       equ   4   ;  /* End of ATLAS US   Mode */
ModeIndex_ATLASCOMMON   equ   5   ;  /* ATLAS Common Mode */
ModeIndex_ATLASCOLR82   equ   6   ;  /* ATLAS 82 Mode *//*<== Don't Change*/
ModeIndex_ATLASMONO82   equ   7   ; 
ModeIndex_ATLAS         equ   7   ;  /* End of ATLAS Text Mode */

ModeIndex_EPOCHMONO80   equ   8   ;  /* Epoch Mode */
ModeIndex_EPOCHMONO80A  equ   9   ; 
ModeIndex_EPOCHMONO80B  equ   10  ; 
ModeIndex_EPOCHCOLR80   equ   11  ; 
ModeIndex_EPOCHCOLR80A  equ   12  ; 
ModeIndex_EPOCHCOLR80B  equ   13  ;                     /*<== Don't Change*/

ModeIndex_GRAPHIC_START equ   14  ;  /* Graphic Mode Start */
ModeIndex_MONOGRAPHIC   equ   14  ;  /* Graphic Mode */
ModeIndex_COLRGAPHIC    equ   15  ;  /* 1024x768 */
ModeIndex_COLRGAPHIC2   equ   16  ;  /* 1040x768 */
ModeIndex_COLR256       equ   17  ;  /* 1040x768 256 colors     J-KK1130*/
ModeIndex_GRAPHIC_END   equ   17  ;  /* Graphic Mode End  */

ModeIndex_VGAMGAPHIC    equ   18  ;  /* VGA PM Mono Graphic Mode <==== */
ModeIndex_VGACGAPHIC    equ   19  ;  /* VGA PM Color Graphic Mode */
ModeIndex_VGA       equ  18  ; <==================== KOKO

ModeIndex_Real      equ  ModeIndex_VGA + 2 ;                        J-KK0925
ModeIndex_REALMono      equ   20  ;  /* Real Mode - EPOCH Mono Text Mode  */
ModeIndex_REALColor     equ   21  ;  /* Real Mode - EPOCH Color Text Mode */

ModeIndex_IDS           equ   22  ;  /* 1280x1024 256 colors     @IDS

;;====================================== Above codes are Japanese Unique. =====

ColorMonoFixup          equ     WORD PTR [bp-2]

MapMask                 equ     <BYTE PTR [bp+6]>
ReadMap                 equ     <BYTE PTR [bp+8]>
TableIndex              equ     WORD PTR [bp+6]
fbType                  equ     WORD PTR [bp+6]
ParameterPacket         equ     DWORD PTR [bp+6]
Direction               equ     WORD PTR [bp+10]
ColorMode               equ     <WORD PTR [bp+12]>
SessionNum              equ     WORD PTR [bp+10]         ;;J-KK1127
ModeIndex               equ     WORD PTR [bp+12]         ;;J-KK
HWModeIndex             equ     WORD PTR [bp+12]         ;;J-KK
CharacterColumns        equ     WORD PTR [bp+10]         ;;J-KK1127
WordByte                equ     <WORD PTR [bp+14]>
AddressPacket           equ     DWORD PTR [bp+16]
AddressPkt              equ     DWORD PTR [bp+12]
ColorMonoMode           equ     <WORD PTR [bp+6]>

WriteFunction           equ     4

;STJFMT,                                ;Formatting parms for STJFMT

VioCursorType STRUC
        CursorTopScanLine dw ?
        CursorBottomScanLine dw ?
        CursorWidth dw ?
        CursorAttribute dw ?
VioCursorType ENDS

VioCursorPos STRUC
        CursorRow dw ?
        CursorColumn dw ?
VioCursorPos ENDS

HWCursor      STRUC                     ;;J-KKJ
              HWCursorStart      db ?   ;;J-KKJ
              HWCursorEnd        db ?   ;;J-KKJ
              HWCursorLocHigh    db ?   ;;J-KKJ
              HWCursorLocLow     db ?   ;;J-KKJ
              HWCursorWidth      db ?   ;;J-KKJ
              HWCursorColor      db ?   ;;J-KKJ
              HWCursorControl    db ?   ;;J-KKJ
              HWCursorWidthMask      db ?   ;;J-KK0927
              HWCursorControlMask    db ?   ;;J-KK0927
HWCursor      ENDS                      ;;J-KKJ

PaletteCLUT STRUC
        DataArea dd ?
        FirstEntry dw ?
        NumEntries dw ?
PaletteCLUT ENDS

RegAddress STRUC
        RegAddressPort dw ?
        RegDataPort dw ?
        RegColorAdjust dw ?
        RegFlags dw ?
RegAddress ENDS

Blink   equ     0
Overscan equ    0
Underscore equ  0
VideoEnable equ 0
DisplayMask equ 0

;
;ͻ
;  Macros                                                                    
;ͼ
;

@SwitchIfReverse macro
        .if     < Mode eq RESTORE >
            push    es
            push    di
            push    ds
            push    si
            pop     di
            pop     es
            pop     si
            pop     ds
        .endif
        endm

;-----------------------------------------------------------------------
; Ensure synchonization of Attribute flip-flop by reading both the Mono
;     and the Color ports, then set the Attribute Address port.
;-----------------------------------------------------------------------

@SetAttAddressPort macro

        mov     dx,3BAh                 ;Mono status register
        cli                             ;Disallow interrupts
        in      al,dx                   ;Read port to reset flip-flop
        mov     dx,3DAh                 ;Color status register
        in      al,dx                   ;Read port to reset flip-flop
        mov     dx,AttAddressPort       ;Get the Attribute Address Port

        endm

@VideoOn macro

        @SetAttAddressPort              ; Set EGA/VGA port
        mov     al, 20h                 ; Enable video for EGA/VGA
        out     dx, al                  ; Disable the video signal

        endm

;Fix a     in the VGA by writing to an undocumented I/O register.
;If this is not done, the video buffer will be randomly corrupted
;during a setmode.  This is not a problem using Bios since the
;screen is always cleared after the mode has been set.

@FixVGABug macro
;@B19   push    ax
;@B19   push    dx

        mov     dx,3c4h                 ; @@tb20
        mov     ax,7                    ; @@tb20
        out     dx,ax                   ; @@tb20

        mov     dx, MiscOutputRegRead   ; Read Miscellaneous Output Register
        in      al, dx
        mov     dx, CRTCtlAddressReg
        test    al, 1
        .if     < nz >
            add     dx, ColorAdjustment
        .endif
        mov     al, 03FH                ; set up index
        out     dx, al

        inc     dx                      ; point to the register
        mov     al, 1                   ; set up the data
        out     dx, al

;@B19   pop     dx
;@B19   pop     ax
        endm

_DATA   SEGMENT WORD PUBLIC 'DATA'
_DATA   ENDS

CONST   SEGMENT WORD PUBLIC 'CONST'
CONST   ENDS

_BSS    SEGMENT WORD PUBLIC 'BSS'
_BSS    ENDS

DGROUP  GROUP   CONST, _BSS, _DATA
