/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT (C) Microsoft Corporation, 1989                                 */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**************************************************************************
 *
 * SOURCE FILE NAME = VDH.H
 *
 * DESCRIPTIVE NAME = Video Device Handler include file
 *
 *
 * VERSION       V2.0
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS     NONE
 *
 * NOTES
 *
 *
 * STRUCTURES    NONE
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/
//---------------------------------------------------------------------------
// System reserved line #
//---------------------------------------------------------------------------
#define SystemReserveLine    1

//---------------------------------------------------------------------------
// DBCS Environment Buffer Size ===> Must be identical with the size of
//                                   DBCSEvBuff[] in XGABUFUP.ASM
//---------------------------------------------------------------------------
#define DBCSEvBuffSize       10

//---------------------------------------------------------------------------
// Epoch Mono Mode Emulation                    J-KK0905
#define FG_Color        4     // Change 5 --> 4 J-KK1027
#define BG_Color        0     /* Actual Palette Number */
#define FGH_Color      15
#define BGH_Color       1
#define Cur_Color       7

#define First_Grid_Color_Value    0x0A  // Set Value For 3E8(34)        //J-TS00

#define PMERR_DEV_FUNC_NOT_INSTALLED 1 

                                                        /*@T39 - Begin*/

typedef struct hardwareConfig { /* hardware configuration information */
/*
        WARNING: this structure is also defined in IDHEQU.INC, be sure
                 to update both structures when changing this one
*/
        USHORT fVideoType;      /* video adapter(s) and monitor(s) */
        USHORT display;         /* display type         not used by BVHINIT */
        unsigned long memory;   /* memory configuration */
        UCHAR  popupMode;       /* popup mode           not used by BVHINIT */
} VIDEOHARDWARE;

#ifdef  J_INSTALL                                                       //J-TS00V
typedef struct hardwareConfigJ { /* Actual H/W config information */    //J-TS00V
        USHORT Configuration;    /* Config Value of 3E0/1 0Ah and 0Bh *///J-TS00V
        UCHAR  MonitorID;        /* Monitor ID                    */    //J-TS00V
        UCHAR  ColorDisp;        /* Color = TRUE or Mono = FALSE  */    //J-TS00V
        USHORT Display;          /* display type                  */    //J-TS00V
        unsigned long Memory;    /* memory configuration          */    //J-TS00V
} VIDEOHARDWAREJ;                                                       //J-TS00V
                                                                        //J-TS00V
// Hardware Configuration Value                                         //J-TS00V
#define  OldLSI    0x0020                                               //J-TS00V
#define  Mon_ID3   0x0010                                               //J-TS00V
#define  FontCard  0x0008                                               //J-TS00V
#define  AddPage   0x0800                                               //J-TS00V
#define  Mon_ID2   0x0400                                               //J-TS00V
#define  Mon_ID1   0x0200                                               //J-TS00V
#define  Mon_ID0   0x0100                                               //J-TS00V
                                                                        //J-TS00V
// Monitor ID                                                           //J-TS00V
#define  StarbuckC     0x0A                                             //J-TS00V
#define  StarbuckM     0x09                                             //J-TS00V
#define  Lark_B        0x02                                             //J-TS00V
#define  Dallas        0x0B                                             //J-TS00V
                                                                        //J-TS00V
// Page Number Mask : Memory Size                                       //J-TS00V
#define  Page_One      0x06         /*  80000h */                       //J-TS00V
#define  Page_Two      0x05         /* 100000h */                       //J-TS00V
#define  Page_Four     0x03         /* 200000h */                       //J-TS00V
#endif  //J-INSTALL                                                     //J-TS00V

/* return values from getVideoType() */
#define MPA_BIT           1      /* bit 0, MPA adapter with MONO monitor */
#define CGA_BIT           2      /* bit 1, CGA adapter with COLOR monitor */
#define EGM_BIT           4      /* bit 2, EGA adapter with MONO monitor  */
#define EGC_BIT           8      /* bit 3, EGA adapter with COLOR monitor */
#define EGA_BIT           0x10   /* bit 4, EGA adapter with ENHANCED COLOR monitor */
#define VGP_BIT           0x20   /* bit 5, VGA plasma display */
#define VGM_BIT           0x40   /* bit 6, VGA adapter with MONO monitor */
#define VGC_BIT           0x80   /* bit 7, VGA adapter with COLOR monitor  */
#define A8514M_BIT        0x100  /* bit 8, 8514A with 8507 monitor */
#define A8514C_BIT        0x200  /* bit 9, 8514A with 8512/3 monitor */
#define A8514A_BIT        0x400  /* bit 10, 8514A with 8514 monitor */
#define A8514_15_BIT      0x800  /* bit 11, 8514A with 8515 monitor */
#define A8514_03_BIT      0x1000 /* bit 12, 8514A with Monochrome 8503 monitor */
#define NODISPLAY_BIT     0x2000 /* bit 13, no display present on VGA system */
#define XGA_BIT           0x4000 /* bit 14, XGA adapter                 @T72 */
#define MONO_DISPLAYS     VGP_BIT + VGM_BIT + A8514M_BIT + A8514_03_BIT /*@T73*/
/*
        Bits 0 and 1 reflect memory configuation for EGA or 8514A

                0 0 - minimum memory, EGA = 64K, 8514A = .5M
                0 1 - EGA = 128K
                1 0 - EGA = 192K
                1 1 - maximum memory, EGA = 256K, 8514A = 1M
*/
#define MEM_EGA64K       0x0000
#define MEM_EGA128K      0x0001
#define MEM_EGA192K      0x0002
#define MEM_EGA256K      0x0003
#define MEM_A85141MEG    0x0003

#define A8514_BITS       (A8514M_BIT|A8514C_BIT|A8514A_BIT|A8514_15_BIT|A8514_03_BIT)
#define VGA_BITS         (VGP_BIT|VGM_BIT|VGC_BIT|NODISPLAY_BIT)
#define EGA_BITS         (EGM_BIT|EGC_BIT|EGA_BIT)

/*
   +--------------------------------------------------------------------+
   |  REALTO32BITADDR - seg:offet -> 32 bit address conversion          |
   |           input:   a double word containing a segment:offset pair  |
   |          output:   32 bit address                                  |
   +--------------------------------------------------------------------+
*/
#define REALTO32BITADDR(a) ((ULONG)((HIUSHORT(a))<<4L) + (ULONG)(LOUSHORT(a)))

#define BIOSFONTSFOUND          0  /* return value from GetBiosFonts() */
#define NOBIOSFONTS             1  /* return value from GetBiosFonts() */
#define OEMHLP_FUNCTION_VIDEO   2  /* OEMHLP video type ioctl */
#define OEMHLP_FUNCTION_FONTS   3  /* OEMHLP.SYS returns font information */
#define OEMHLP_FUNCTION_MISC    6  /* OEMHLP.SYS get Misc. State info   @T71*/
#define OEMHLP_FUNCTION_ADAPTER 7  /* OEMHLP.SYS get adapter type */    //@T74
#define GETADAPTER_TYPE         6  /* parameter to DosDevIoctl */
#define VGA_MONO                7  /* return value of INT 10 function 1a */
#define VGA_COLOR               8  /* return value of INT 10 function 1a */
#define VGA_NODISPLAY           0  /* return value of INT 10 function 1a */

#define MPA_DEVICE              1  /* bit information returned from */  //@T74
#define CGA_DEVICE              2  /* OEMHLP_FUNCTION_ADAPTER call  */  //@T74
#define EGA_DEVICE              4  /* to OEMHLP$                    */  //@T74
#define VGA_DEVICE              8                                       //@T74

#define MEM_B000 0            /* memory test location indicators */
#define MEM_B800 1
#define MEM_A000 2

#define OEMHLP_CATEGORY      0x80  /* category number of OEMHLP.SYS IOCtl */
#define OEMHLPDD_NAME   "OEMHLP$"  /* name of OEMHLP device driver        */

#define MEMORY_TESTVALUE 0xAAAA /* used to dectect presence of video memory */

                                                        /*@T39 - End*/

#undef VIOMODEINFO
#undef PVIOMODEINFO
struct _VDHMODEINFO {
        USHORT cb;
        UCHAR  fbType;
        UCHAR  color;
        USHORT col;
        USHORT row;
        USHORT hres;
        USHORT vres;
        UCHAR  fmt_ID;
        UCHAR  attrib;
        UCHAR far *BufferAddress;
        ULONG  BufferLength;
        ULONG  FullBufferSize;
        ULONG  PartialBufferSize;
        UCHAR far *ExtDataArea;
        };
#define VIOMODEINFO struct _VDHMODEINFO
#define PVIOMODEINFO VIOMODEINFO FAR *

struct ABIOS_Request_Block {
        USHORT ABIOS_RB_Len;            /* +00h */
        USHORT ABIOS_DevId;             /* +02h */
        USHORT ABIOS_Unit;              /* +04h */
        USHORT ABIOS_Func;              /* +06h */
        USHORT ABIOS_RBFlags;           /* +08h */
        USHORT ABIOS_ELOff;             /* +0Ah */
        USHORT ABIOS_RetCode;           /* +0Ch */
        USHORT ABIOS_TimeOut;           /* +0Eh */
        USHORT ABIOS_DataPtr1x;         /* +10h */
        USHORT ABIOS_DataPtr1l;         /* +12h */
        USHORT ABIOS_DataPtr1h;         /* +14h */
        USHORT ABIOS_unknown;           /* +16h */
        USHORT ABIOS_Count;             /* +18h */
        USHORT ABIOS_DevCntlFlag;       /* +1Ah */
        UCHAR  ABIOS_ScanLines;         /* +1Ch */
        UCHAR  ABIOS_CharGenType;       /* +1Dh */
        USHORT ABIOS_VideoMode;         /* +1Eh */
        USHORT ABIOS_MonitorType;       /* +20h */
        USHORT ABIOS_CharHeight;        /* +22h */
        USHORT ABIOS_Map2Block;         /* +24h */
        USHORT ABIOS_UpdateFontFlag;    /* +26h */
        USHORT ABIOS_CharOffset;        /* +28h */
        USHORT ABIOS_FontDataSize;      /* +2Ah */
        USHORT ABIOS_Environment;       /* +2Ch */
        USHORT ABIOS_SR_Header_Size;    /* +2Eh */
        USHORT ABIOS_SR_Hdw_Size;       /* +30h */
        USHORT ABIOS_PaletteReg;        /* +32h */
        USHORT ABIOS_PaletteValue;      /* +34h */
        }; /* End of ABIOS_Request_Block */

#define ABIOS_SR_DB_Size  ABIOS_PaletteReg   /* +32h */
#define ABIOS_SR_DAC_Size ABIOS_PaletteValue /* +34h */

#undef VIOPHYSBUF
#undef PVIOPHYSBUF
struct _VDHVIOPHYSBUF {    /* viopb */
        PBYTE    pBuf;
        ULONG    cb;
        SEL      asel[4]; /* Definitely no greater than 4 selectors */
        };
#define VIOPHYSBUF struct _VDHVIOPHYSBUF
#define PVIOPHYSBUF VIOPHYSBUF FAR *

#define WorldFormat             0x70    /* world attribute format       @P1 */
#define DefaultFormat           0x00    /* default attribute format     @P1 */
#define WorldAttrCount          0x03    /* world attribute count        @P1 */
#define DefaultAttrCount        0x01    /* default attribute count @tb15  @P1 */
#define WorldAttrMult           0x02    /* world attr save size multiplier @P1 */

/*****************************************************************************/
/* Definitions */
/*****************************************************************************/
/*
 +----------------------------------------------------------------------------+
 |  Function numbers for VDH services                                         |
 +----------------------------------------------------------------------------+
*/
#define FnFillLogicalDevBlock    1L
#define FnFillInitDevBlock       3L                     /* DCR 203      @T15 */

#define FnTextBufferUpdate       256L
#define FnInitializeEnvironment  257L
#define FnSaveEnvironment        258L
#define FnRestoreEnvironment     259L
#define FnReturnConfigInfo       260L
#define FnGetDBCSDisplayInfo     261L
#define FnGetColorLookupTable    262L
#define FnSetColorLookupTable    263L
#define FnGetCursorInfo          264L
#define FnSetCursorInfo          265L
#define FnGetFont                266L
#define FnSetFont                267L
#define FnGetMode                268L
#define FnSetMode                269L
#define FnGetPaletteRegisters    270L
#define FnSetPaletteRegisters    271L
#define FnGetPhysBuf             272L
#define FnFreePhysBuf            273L
#define FnGetVariableInfo        274L
#define FnSetVariableInfo        275L
#define FnExtendedVioCall        276L
#define FnPrintScreen            277L                                   //J-TS00
#define FnReserved1              277L   /* print screen */
#define FnReserved2              278L   /* write TTY */
#define FnGetLVBInfo             279L                           /*      @P1 */

#define MaxFn                    FnGetLVBInfo-FnTextBufferUpdate+1  /* @T24 */

#define ChainedVDHBufferUpdate    (*ChainedCallVectorTable[0])
#define ChainedVDHInitEnv         (*ChainedCallVectorTable[1])
#define ChainedVDHSaveEnv         (*ChainedCallVectorTable[2])
#define ChainedVDHRestoreEnv      (*ChainedCallVectorTable[3])
#define ChainedVDHRetConfigInfo   (*ChainedCallVectorTable[4])
#define ChainedVDHGetDBCSInfo     (*ChainedCallVectorTable[5])
#define ChainedVDHGetColorLookup  (*ChainedCallVectorTable[6])
#define ChainedVDHSetColorLookup  (*ChainedCallVectorTable[7])
#define ChainedVDHGetCursorInfo   (*ChainedCallVectorTable[8])
#define ChainedVDHSetCursorInfo   (*ChainedCallVectorTable[9])
#define ChainedVDHGetCurrentFont  (*ChainedCallVectorTable[10])
#define ChainedVDHSetCurrentFont  (*ChainedCallVectorTable[11])
#define ChainedVDHGetMode         (*ChainedCallVectorTable[12])
#define ChainedVDHSetMode         (*ChainedCallVectorTable[13])
#define ChainedVDHGetPaletteReg   (*ChainedCallVectorTable[14])
#define ChainedVDHSetPaletteReg   (*ChainedCallVectorTable[15])
#define ChainedVDHGetPhysBuf      (*ChainedCallVectorTable[16])
#define ChainedVDHFreePhysBuf     (*ChainedCallVectorTable[17])
#define ChainedVDHGetVariableInfo (*ChainedCallVectorTable[18])
#define ChainedVDHSetVariableInfo (*ChainedCallVectorTable[19])
#define ChainedVDHExtendedVioCall (*ChainedCallVectorTable[20])      /* @T24 */
#define ChainedVDHPrintScreen     (*ChainedCallVectorTable[21])         //J-TS00
#define ChainedVDHReserved2       (*ChainedCallVectorTable[22])      /* @T24 */
#define ChainedVDHGetLVBInfo      (*ChainedCallVectorTable[23]) /*@T24, @P1 */

#define FnChainedBufUpdate        0
#define FnChainedRetConfigInfo    4
/*
 +----------------------------------------------------------------------------+
 |  Minimum structure lengths for VDH functions                               |
 +----------------------------------------------------------------------------+
*/
#define MinSLen_SaveRestoreEnv  4
#define MinSLen_Cursor_Pos      8
#define MinSLen_Cursor_Type     16
#define MinSLen_Var_Blink       6
#define MinSLen_Var_Overscan    8
#define MinSLen_Var_Underscore  10
#define MinSLen_Var_VideoEnable 12
#define MinSLen_Var_DisplayMask 16
#define MinSLen_Var_CodePage    18
#define MinSLen_Var_ScrollRect  26                              /*      @P1 */
#define MinSLen_Var_ScreenDim   30                              /*      @P1 */

#define MinGLen_LVB_Size        14                              /*      @P1 */
#define MinGLen_LVB_AttrBufSize 16                              /*      @P1 */
#define MinGLen_LVB_AttrBufAddr 20                              /*      @P1 */


/*
 +----------------------------------------------------------------------------+
 |  Minimum data lengths for VDH parameters                                   |
 +----------------------------------------------------------------------------+
*/
#define Config_Return_Length          2         /* RetConfigInfo */
#define MinDLen_Config_Adapter        4
#define MinDLen_Config_Display        6
#define MinDLen_Config_Memory         10
#define MinDLen_Config_ConfigNum      12
#define MinDLen_Config_Version        14
#define MinDLen_Config_Flag           16
#define MinDLen_Config_HWBufLen       20
#define MinDLen_Config_FullSaveSz     24
#define MinDLen_Config_PartSaveSz     28
#define MinDLen_Config_LEMAdapterdata 34        /* @BB7 */
#define MinDLen_Config_EMAdapter      36        /* @BB7 */
#define MinDLen_Config_LEMDisplaydata 38        /* @BB7 */
#define MinDLen_Config_EMDisplay      40        /* @BB7 */

#define Mode_Return_Length        2    /* Get/SetMode                   @@A */
#define MinDLen_Mode_Type         3
#define MinDLen_Mode_Color        4
#define MinDLen_Mode_Column       6
#define MinDLen_Mode_Row          8
#define MinDLen_Mode_Hres         10
#define MinDLen_Mode_Vres         12
#define MinDLen_Mode_FormatID     13
#define MinDLen_Mode_Attrib       14
#define MinDLen_Mode_BufStart     18
#define MinDLen_Mode_BufLen       22
#define MinDLen_Mode_FullBufSz    26
#define MinDLen_Mode_PartBufSz    30
#define MinDLen_Mode_ExtData      34

//----------------------------------------------------------------------------
// Japanese Unique Code

//
// Hardware scroll option
//

#define ENV_VAR_PROTECTHS       "PROTECTHS"
#define STR_PROTECT_HS_ON       "ON"
#define STR_PROTECT_HS_LC       "LC"
#define STR_PROTECT_HS_OFF      "OFF"
#define PROTECT_HS_ON           2
#define PROTECT_HS_LC           1
#define PROTECT_HS_OFF          0

//
//  JapanDataArea.Option
//
// Caution !!! Must be identical with ones in VDHEQU.INC !!!
  #define  Blink_State        1       /* Defaults is Blink.              J-KK*/
// SetState Req. Type = 2 :Change Blinking or High Intensity of MSB meaning
  #define  Always_FNTCall     2       /* Always Called Font Subsystem J-KK1005*/
// All screen must be redrawn.                                          J-KK0206
  #define  All_Redrawn        4       // All Screen is redrawn by Xvio. J-KK0206
  #define  Spe_Redrawn        8       // Special Redraw Req. to Xvio    @KK0622

//----- Japanese Hardware Default Setup Data Table --------------------------

#define HW_ATLAS                0       /* Atlas 80              80x26 */
#define HW_DBCS_VGA             1       /* DBCS VGA              80x26 */
#define HW_ATLAS3_M             2       /* Atlas 3 bytes         82x26 */
#define HW_ATLAS3_C             3       /* Atlas 3 bytes         82x26 */
#define HW_EPOCH_M              4       /* Epoch Mono  Emulation 80x26 */
#define HW_EPOCH_C              5       /* Epoch Color Emulation 80x26 */

//----- Japanese Video Mode Table -------------------------------------------

// For ATLAS
#define ModeIndex_ATLASCO80VGA   0      /* U.S. Emualtion Mode    */
#define ModeIndex_ATLASCO80EGA   1
#define ModeIndex_ATLASCO80CGA   2
#define ModeIndex_ATLASMONOVGA   3
#define ModeIndex_ATLASMONOEGA   4
#define ModeIndex_ATLASUS        4      /* End of ATLAS US   Mode */

#define ModeIndex_ATLASCOMMON    5      /* ATLAS Common Mode      */

#define ModeIndex_ATLASCOLR82    6      /* ATLAS 82 Mode          */
#define ModeIndex_ATLASMONO82    7
#define ModeIndex_ATLAS          7      /* End of ATLAS Text Mode */

#define ModeIndex_EPOCHMONO80    8      /* Epoch Mode             */
#define ModeIndex_EPOCHMONO80A   9
#define ModeIndex_EPOCHMONO80B  10
#define ModeIndex_EPOCHCOLR80   11
#define ModeIndex_EPOCHCOLR80A  12
#define ModeIndex_EPOCHCOLR80B  13
#define ModeIndex_EPOCH         13      /* End of EPOCH           */

#define ModeIndex_Real          14      /* 3.x box video mode */

//************************************************************************
//* Japanese Video Format Index Number                                   *
//*      This value must be set into env_jformat at setting Video Mode.  *
//*      This value relates to a function index in XGAWRITE/XGASCROL.    *
//*      These values must be identical to values in VDHEQU.INC.         *
//************************************************************************

#define EPOCH_Format      0               /* Epoch Format                   */
#define COMMON_Format     2               /* Common Format                  */
#define ATLAS3_Format     COMMON_Format+2 /* Atlas 3 byte Attribute Format  */
#define ATLASUS_Format    COMMON_Format+4 /* U.S. Emualtion Format          */

/*
 +----------------------------------------------------------------------------+
 |  Japanese Memory map table indices                                         |
 +----------------------------------------------------------------------------+
*/

#define MemMap_ATLAS            0

/*
 +----------------------------------------------------------------------------+
 |  Mode table index for each mode ( 0 based )                                |
 +----------------------------------------------------------------------------+
*/

  #define ModeIndex_VGA3p 0
  #define ModeIndex_VGP3p 1
  #define ModeIndex_VGM7p 2
  #define ModeIndex_VGC7p 3                                             /*@T71*/
  #define ModeIndex_VGP7p 4                                             /*@T71*/
  #define ModeIndex_VGA1p 5                                             /*@T71*/
  #define ModeIndex_VGP1p 6                                        /*@C29,@T71*/
  #define ModeIndex_VGE3  7                                        /*@C29,@T71*/
  #define ModeIndex_VGE1  8                                        /*@C29,@T71*/
  #define ModeIndex_VGA3  9                                             /*@T71*/
  #define ModeIndex_VGM7  10                                            /*@T71*/
  #define ModeIndex_VGA7p 11                                       /*@C29,@T71*/
  #define ModeIndex_VGA1  12                                       /*@C29,@T71*/
  #define ModeIndex_VGA4  13                                       /*@C29,@T71*/
  #define ModeIndex_VGA6  14                                       /*@C29,@T71*/
  #define ModeIndex_VGAD  15                                            /*@T71*/
  #define ModeIndex_VGAE  16                                       /*@C29,@T71*/
  #define ModeIndex_VGAF  17                                       /*@C29,@T71*/
  #define ModeIndex_VGA10 18                                            /*@T71*/
  #define ModeIndex_VGA11 19                                       /*@C29,@T71*/
  #define ModeIndex_VGA12 20                                       /*@C29,@T71*/
  #define ModeIndex_VGA13 21                                       /*@C29,@T71*/

  #define ModeIndex_EGA1   8
  #define ModeIndex_EGC1   10
  #define ModeIndex_EGA3   6
  #define ModeIndex_EGC3   9
  #define ModeIndex_EGA4   0
  #define ModeIndex_EGA4b  3
  #define ModeIndex_EGA6   11
  #define ModeIndex_EGM7   7
  #define ModeIndex_EGAD   12
  #define ModeIndex_EGAE   13
  #define ModeIndex_EGAF   1
  #define ModeIndex_EGAFm  4
  #define ModeIndex_EGA10  2
  #define ModeIndex_EGA10s 5

  #define ModeIndex_CGA3   0
  #define ModeIndex_CGA0   3
  #define ModeIndex_CGA1   2
  #define ModeIndex_CGA2   1
  #define ModeIndex_CGA4   4
  #define ModeIndex_CGA5   5
  #define ModeIndex_CGA6   6

/*
 +----------------------------------------------------------------------------+
 |  Command table indices for specific modes ( 0 based )                      |
 +----------------------------------------------------------------------------+
*/

  #define SeqRegs_VGA3p   0
  #define MiscOut_VGA3p   1
  #define CRTRegs_VGA3p   3
  #define AttRegs_VGA3p   4
  #define GraphRegs_VGA3p 5
  #define AttRegs_VGM7p   4
  #define AttRegs_VGA3    4
  #define AttRegs_VGAD    4
  #define GraphRegs_VGAD  5
  #define AttRegs_VGA10   4
  #define SeqRegs_VGM7    0
  #define SeqRegs_VGM7p   0
  #define SeqRegs_VGA1p   0

#define ROM_FONT              0
#define PHYSICAL_FONT_BUFFER  0
#define USER_FONT_SELECTABLE     (short)-1
#define USER_FONT_NOT_SELECTABLE (short)-2
#define MAX_CODEPAGES 2
#define CP_1st 0
#define CP_2nd 1

/*
 +----------------------------------------------------------------------------+
 |  Memory map table indices                                                  |
 +----------------------------------------------------------------------------+
*/
#define MemMap_Mono   0
#define MemMap_Text40 1
#define MemMap_Text80 2
#define MemMap_LoRes  3
#define MemMap_ModeD  4
#define MemMap_ModeE  5
#define MemMap_ModeF  6
#define MemMap_Mode10 7
#define MemMap_Mode11 8
#define MemMap_Mode12 9
#define MemMap_Mode13 10
#define MemMap_Text480 11               /*STJ*/

#define MIN_PVB_BOTTOM    0xA0000L
#define MAX_PVB_TOP       0xBFFFFL

#define BOTTOM_MONO_TEXT  0xB0000L
#define TOP_MONO_TEXT     0xB0F9FL

#define BOTTOM_COLOR_TEXT 0xB8000L
#define TOP_COLOR_TEXT    0xB8F9FL

#define BOTTOM_LORES1     0xB8000L
#define TOP_LORES1        0xB9F3FL

#define BOTTOM_LORES2     0xBA000L
#define TOP_LORES2        0xBBF3FL

#define BOTTOM_GRAPHICS   0xA0000L

#define TOP_GRAPHICS      0xAF9FFL

#define MAX_FONT_LEN   (32L*256L)

// #define NUM_MODES 24          /*STJ,@C45 # Modes supported by VGA     */
#define NUM_MODES 14          /* # Modes supported by DBCS VGA     */   //J-TS00

#define ROM_FONTS  5          /*@C7      # ROM fonts supported by VGA */
#define NUM_FONTS  5                  /* # fonts supported in a CP    */
#define MAX_MODE_CMDS 7               /* Max no. CMDs to set a mode   */
#define NUM_ATT_REGS 0x14+1

#define UNSUPPORTED_FUNCTION 0 /* VDH service is not supported by this adapter */

/* DosOpen parameters */
#define SCREENDD_NAME  (PSZ)"SCREEN$"
#define RETURN_ERROR   (USHORT)0x2000     /* OpenMode bit mask */
#define NO_INHERIT     (USHORT)0x0080                           /* @T5 */
#define DENY_NONE      (USHORT)0x0040                           /* @T5 */
#define READ_WRITE     (USHORT)0x0002
#define OPEN_IF_EXISTS 0x0001             /* OpenFlag bit mask */
#define NO_SIZE        0L
#define NO_ATTRIBUTES  0
#define RESERVED_LONG  0L

/*+--------------------------------------------------------------------------+*/
/*| Display types                                                            |*/
/*+--------------------------------------------------------------------------+*/
#define  PlasmaDisplay  0x0A    /*   VDHVGA               */
#define  Mono8503       0x03    /*   VDHVGA, VDH8514A     */
#define  Color8512_8513 0x04    /*   VDHVGA, VDH8514A     */
#define  Color8514      0x09    /*   VDH8514A             */
#define  EnColor5154    0x02    /*   VDHEGA               */
#define  Color5153      0x01    /*   VDHCGA, VDHEGA       */
#define  Mono5151       0x00    /*   VDHMPA, VDHEGA       */
#define  NoDisplay      -1      /*   VDHVGA with VDH8514A */
#define  Mono8507_8604  0x0B    /*   VDH8514A D184        */
#define  Color8515      0x0C    /*   VDH8514A D184        */
#define  EPOCHMono      0x05    /*   VDHEPOCH                            J-KKJ*/
#define  EPOCHColor     0x06    /*   VDHEPOCH                            J-KKJ*/
#define  Mono5574       0x07    /*   VDHATLAS  5574                      J-KKJ*/
#define  Color5574      0x08    /*   VDHATLAS  5574                      J-KKJ*/
#define  ColorLCD       Color8512_8513       //J-TS00
                                             //J-TS00
                                             //J-TS00

#define MEM_1MB 1
#define VDHERROR_NO_ADAPTER 0

/*+--------------------------------------------------------------------------+*/
/*| Adapter types                                                            |*/
/*+--------------------------------------------------------------------------+*/
#define UNKNOWN_ADAPTER -1                                              /*@T39*/
#define TYPE_MPA    0
#define TYPE_CGA    1
#define TYPE_EGA    2
#define TYPE_VGA    3
#define TYPE_EPOCH  4           /*J-KKJ*/
#define TYPE_PHOENIX 5          /*J-KKJ*/
#define TYPE_ATLAS  6           /*J-KKJ*/
#define TYPE_8514A  7

/*+--------------------------------------------------------------------------+*/
/*| Emulated Display types                                                   |*/
/*+--------------------------------------------------------------------------+*/
#define  EmDisp_8514A   0x1A18          /*D184*/
#define  EmDisp_8514L   0x0018          /*D184*/
#define  EmDisp_VGA     0x0418          /*D184*/
#define  EmDisp_EGA     0x0004          /*D184*/
#define  EmDisp_CGA     0x0002          /*D184*/
#define  EmDisp_MPA     0x0001          /*D184*/
#define  EmDisp_Mono74  0x0020                     /*J-KK0906*/
#define  EmDisp_Colo74  0x0040                     /*J-KK0906*/

/*+--------------------------------------------------------------------------+*/
/*| Emulated Adapter types                                                   |*/
/*+--------------------------------------------------------------------------+*/
#define EMULATE_TYPE_MPA    0x01
#define EMULATE_TYPE_CGA    0x02
#define EMULATE_TYPE_EGA    0x04
#define EMULATE_TYPE_VGA    0x08
#define EMULATE_TYPE_8514A  0x80
#define EMULATE_TYPE_ATLAS  0x10                  /*J-KK0906*/

#define POWERUP  1
#define PASSTHRU 2

#define PARTIAL 0x01
#define CODEPTS 0x02
#define FULL    0x00

#define WORDS 1
#define BYTES 0

#define TRUE  1
#define FALSE 0

#define U_FONT 1                                        /* User font         */
#define C_FONT 2                                        /* CodePage font     */
#define R_FONT 3                                        /* ROM font          */
#define GET 1
#define GET_ROMCP 2
#define SET 0
#define SETWORD 2

#define INIT_ERROR 1

#define GET_ROM_FONT     2                              /*              @T11 */
#define UPDATE_HARDWARE  1
#define BACKGROUND       0

#define INITENV_3xBOX    0x02           /*D198*/
#define VALID_INITENV_FLAG (UPDATE_HARDWARE+INITENV_3xBOX) /*D198*/

#define CURSOR_TYPE      4
#define CURSOR_POSITION  2
#define VALID_CURSOR_FLAG (UPDATE_HARDWARE+CURSOR_TYPE+CURSOR_POSITION)

#define VARIABLE_BLINK       0x02
#define VARIABLE_OVERSCAN    0x04
#define VARIABLE_UNDERSCORE  0x08
#define VARIABLE_VIDEOENABLE 0x10
#define VARIABLE_DISPLAYMASK 0x20
#define VARIABLE_CODEPAGE    0x40
#define VARIABLE_FORCECP     0x80                               /*      @P1 */
#define VARIABLE_SCROLLRECT  0x100                              /*      @P1 */
#define VARIABLE_SCREENDIM   0x200                              /*      @P1 */
#define VALID_VARIABLE_FLAG ( UPDATE_HARDWARE      + VARIABLE_BLINK      +\
                              VARIABLE_OVERSCAN    + VARIABLE_UNDERSCORE +\
                              VARIABLE_VIDEOENABLE + VARIABLE_DISPLAYMASK +\
                              VARIABLE_CODEPAGE    + VARIABLE_FORCECP    +\
                              VARIABLE_SCROLLRECT  + VARIABLE_SCREENDIM ) /* @P1 */

                                     /* InitEnvironment function */

#define bu_ReadCellStr          2                               /*      @P1 */
#define bu_WriteCellStr         7                               /*      @P1 */
#define BU_PVB_SEL_BIT        0x0001                            /*      @P1 */
#define BU_LVB_SEL_BIT        0x0002                            /*      @P1 */
#define BU_MAX_INDEX              12                            /*      @P1 */
#define BU_PARM_LENGTH            26                            /*      @P1 */

#define SAVEREST_HARDWARE 0x02
#define SAVEREST_FULLPVB  0x04
#define SAVEREST_PARTPVB  0x08
#define VALID_SAVEREST_FLAG ( SAVEREST_HARDWARE + SAVEREST_FULLPVB +\
                              SAVEREST_PARTPVB ) /*D198*/

#define SAVE    0
#define RESTORE 1

#define NOT_MONO    1    /*  xxxxxxxb b = 0 Mono-compatible, b = 1 Other      */
#define GRAPHICS    2    /*  xxxxxxbx b = 0 Text mode, b = 1 Graphics         */
#define NO_CLR_BRST 4    /*  xxxxxbxx b = 1 Color burst disabled              */
#define NATIVE      8    /*  xxxxbxxx b = 1 Native ( advanced function ) mode */
/* No Color burst on VGA, on CGA, color burst on modes 0,2,4 */

/* Flags used for mode data */
#define IGNORE_CLR_BRST  0x0001  /* Disable color burst doesn't make sense for this mode */
#define ENHANCED_MONITOR 0x0002  /* This mode works on EGA only with an enhanced monitor */
#define NOT_PLASMA       0x0008  /* This mode does not work on VGA with PDP monitor */

#define BLINK_BIT 0x08

#define SetMapMask      SETMAPMASK
#define WriteFunction 4

#define AttAddressPort      0x03C0
#define AttDataWritePort    0x03C0
#define AttDataReadPort     0x03C1

#define CRTAddressPort      0x03B4
#define CRTDataPort         0x03B5

#define SeqAddressPort      0x03C4
#define SeqDataPort         0x03C5

#define GraphAddressPort    0x03CE
#define GraphDataPort       0x03CF

#define MiscOutputRegRead   0x03CC
#define MiscOutputRegWrite  0x03C2
#define FeatureControlRead  0x03CA
#define FeatureControlWrite 0x03BA
#define VideoEnableReg      0x03C3

#define CRTCtlPort1 0x03B8

#define UNKNOWN 0

#define NONE             0x00
#define ColorAdjustment  0x20

#define Attributes_CMD 1
#define Sequencers_CMD 2
#define CRTCtlRegs_CMD 3
#define Graphics_CMD   4
#define RegOutput_CMD  5
#define ChangeMode_CMD 6
#define Terminate_CMD  0

// OEM Definitions                                             //MS32 - BEGIN

#define IDCDisplayType          0x1BC6  /* IDC Display type Register B724243 */
#define IDCEnvironReg           0x17C6  /* IDC Environment Register */
#define IDC_SIGNATURE           0xE6    /* IDC Environment Reg Data */
#define IDCMasterModeReg        0x13C6  /* IDC Master Mode Register */
#define IDCExtendedModeReg      0x23C6  /* IDC Extended Mode Register */
#define IDCEnableExtended       0x01    /* Enable Extended Mode bit */
#define IDCDisableTranslate     0x02    /* No CRT Data Translation bit */

#define PARADISE_ID             0x40    /* Paradise VGA Flag bit */


#define DACCmdReg               0x83C6  // STARDUST DAC command register

#define VGA_ENV_REG             0x0F    // Environment Status Reg Index
#define VGA_LOCK                0x00    // Value to lock VGA extended regs
#define VGA_UNLOCK              0x05    // Value to unlock VGA extended regs

#define VGA_CONFIG_REG          0x0B    // VGA Configuration Reg
#define LCD_EXTERNAL            0x08    // External/Internal monitor bit
#define LCD_GRAYSCALE_ADDR      0x09    // Gray scale address reg
#define LCD_GRAYSCALE_DATA      0x0A    // Gray scale data reg

#define VGA_VERSION_REG         0x0C    // Silicon Version Reg Index
#define PROJECT_MASK            0xF8    // Project number mask
#define STARLIGHT132_ID         0x1A    // Starlight132 project+version
#define STARDUST_ID             0x28    // Stardust project number

#define VST_EXTINT      0xCC02          // VioGet/SetState function # for
                                        // external monitor switching.
#define External_Monitor 1              // VioGet/SetState parameter values.
#define Internal_Monitor 0              // for external monitor switching.

#define VST_EXTFLG      0xCC08          // VioGet/SetState function # for
                                        // external monitor switching inquire.
#define Can_Switch    1                 // This device can switch.
#define Cannot_Switch 0                 // This device can not switch.

// OEMFlags bit definitions:
// WARNING: These are also defined in VDHEQU.INC, be sure to update both files
#define IDC_CGA         0x0001  // Dual Mode Plasma Controller
#define VDU_CGA         0x0002  // VDU Controller
#define DSM_MONITOR     0x0004  // Dual Scan Monitor
#define PARADISE_VGA    0x0008  // Paradise VGA adapter
#define PRISM_VGA       0x0010  // Prism LCD VGA adapter
#define CRYSTAL_VGA     0x0020  // Crystal LCD VGA adapter
#define STARLIGHT_VGA   0x0040  // Starlight 132 VGA adapter
#define STARDUST_VGA    0x0080  // Stardust VGA adapter
#define VGA_E           0x0100  // IBM VGA-E adapter
#define FAST_CGA        0x8000  // Don't wait on CGA retrace for screen update

// Internal/External switchable adapters:
#define INT_EXT_ADAPTER (PRISM_VGA | CRYSTAL_VGA)


#define OEM_132_COLUMNS (STARLIGHT_VGA | STARDUST_VGA)

// CMOS Configuration info
#define CMOS_VCFG        0x2D   // CMOS address for video config bits
#define DSM_VCFG         0x01   // High resolution monitor
#define VDU_VCFG         0x04   // CGA adapter
#define CMOS_SYS_ID      0x24   // CMOS address for system ID
#define TRIUMPH_ID       0x26   // Prism VGA system
#define TARGA_ID         0x52   // Prism VGA system
#define CALYPSO_ID       0x55   // Crystal VGA system

/*****************************************************************************/
/* Macros */
/*****************************************************************************/
#define MakeFarPTR(selector,offset) (UCHAR far *)((((long)selector)<<16)+(long)offset)
#define CHECKBUFFER(i) c = PVB.FullAddress[i]; PVB.FullAddress[i] = (c ^= 0xFF);
#define OFFSET(farpointer) (USHORT)(&(farpointer))
#define SEG(farpointer)    (*((USHORT *)&(farpointer) + 1))

/*****************************************************************************/
/* Type definitions */
/*****************************************************************************/

/* BIOS information for EGA */                                          /*@T39*/
typedef struct  {                                                       /*@T39*/
  UCHAR  BIOS_info;                    /* 0040:0087 */                  /*@T39*/
  UCHAR  BIOS_info3;                   /* 0040:0088 */                  /*@T39*/
} EGABIOSINFO;                                                          /*@T39*/


typedef struct {                                                /*      @P1 */
          USHORT Left;                                          /*      @P1 */
          USHORT Top;                                           /*      @P1 */
          USHORT Right;                                         /*      @P1 */
          USHORT Bottom;                                        /*      @P1 */
          } SCRLRECT;                                           /*      @P1 */

typedef struct {
          USHORT AddressPort;
          USHORT DataPort;
          USHORT ColorAdjust;
          USHORT Flags;
          } REGADDRESS;

typedef struct {
          UCHAR far *DataArea;
          USHORT FirstEntry;
          USHORT NumEntries;
          } REGDATA;

typedef struct {
          USHORT far *DataArea;
          USHORT FirstEntry;
          USHORT NumEntries;
          } REGDATA2;

typedef struct {
          UCHAR   Command;
          REGDATA RegData;
          } REGCMD;

typedef union {
          UCHAR far *FullAddress;
          struct {
            USHORT Offset;
            USHORT Selector;
            } part;
          } FarAddress;

typedef struct {
          USHORT Row;
          USHORT Column;
          } VIOCURSORPOS;

typedef struct {
          UCHAR Red;
          UCHAR Green;
          UCHAR Blue;
          } CLUTDATA;

typedef struct {
          FarAddress PVB;             /* Physical starting address       */
          USHORT     PVBLen;          /* Length                          */
          USHORT     Partner;         /* Table index to base font        */
          USHORT     PelColumns;
          USHORT     PelRows;
          USHORT     Flags;           /* PARTIAL: 1, CODEPTS: 2, FULL: 0 */
          USHORT     FirstCodePoint;
          USHORT     NumCodePoints;
          } FONTBUFFER;

#ifdef FONT_SUPPORT


typedef struct {
          USHORT     PelColumns;
          USHORT     PelRows;
          USHORT     FontData;
          } USERFONT;

typedef struct {
        USHORT  ffh_length;     /* Length of Header             */
        USHORT  ffh_flags;      /* CodePage File flags          */
        USHORT  ffh_ptroffset;  /* Offset of first font pointer */
        USHORT  ffh_numfonts;   /* Number of fonts in the file  */
        } FONTFILEHDR;

typedef struct {
        USHORT  fh_length;      /* Length of Font Entry         */
        USHORT  fh_hdrlen;      /* Length of Header             */
        USHORT  fh_cpid;        /* CodePage File flags          */
        USHORT  fh_type;        /* Font Type                    */
        USHORT  fh_flags;       /* Font Flags                   */
        UCHAR   fh_cellcols;    /* Columns in character cell    */
        UCHAR   fh_cellrows;    /* Rows in character cell       */
        UCHAR   fh_basecols;    /* Columns in base cell         */
        UCHAR   fh_baserows;    /* Rows in base cell            */
        USHORT  fh_dataoffset;  /* Font data offset from header */
        USHORT  fh_datalen;     /* Length of the font data      */
        USHORT  fh_numpoints;   /* Number of code points        */
        USHORT  fh_lowpoint;    /* Lowest code point            */
        USHORT  fh_highpoint;   /* Highest code point           */
        } FONTHDR;

struct part {                                                    /*@C10*/
  USHORT Offset;                                                 /*@C10*/
  USHORT Selector;                                               /*@C10*/
  };                                                             /*@C10*/

typedef union {                                                  /*@C10*/
          struct part p;                                         /*@C10*/
          UCHAR  *ptr;                                           /*@C10*/
          } cp_addr;                                             /*@C10*/

#endif /* FONT_SUPPORT */

typedef struct {
        ULONG   PageLength;     /* Length of each page                  *///J-TS00
        USHORT  PageReal;       /* Length of each page (Real Mode)   @S4*/
        ULONG   TotalSize;      /* Total size of all pages combined     */
        ULONG   TotalReal;      /* Total size of pages (Real Mode)   @S4*/
        USHORT  BitPlanes;      /* Flag byte of bit planes used         */
        FarAddress Start;
        } MEMORYMAPS;

typedef struct {
          USHORT cb;              /* VioGetMode structure              */
          UCHAR  fbType;
          UCHAR  color;
          USHORT col;
          USHORT row;
          USHORT hres;
          USHORT vres;
          UCHAR  fmt_ID;
          UCHAR  attrib;
          UCHAR  MemMap;          /* Index in memory map table         */

          USHORT Format_Index;  /* Format Index Number J-KK */          //J-TS00
          USHORT HW_Index;      /* HW Default Table Index J-KK */       //J-TS00
          } VIDEOMODE;

typedef struct {
          ULONG  far *Flags;              /* ULONG ? */
          USHORT far * far *CallVectorTable;
          } DEV_PARM2;

typedef struct {
          ULONG EngineVersion;
          ULONG TableSize;
          } DEV_PARM1;

typedef struct {                       /* Real Mode data area (based at 40:0) */
                UCHAR  BIOS_PrinterData[0x10];         /* 0040:0000 */
                USHORT BIOS_equipflag;                 /* 0040:0010 */
                UCHAR  BIOS_Miscellaneous[0x37];       /* 0040:0012 */
                UCHAR  BIOS_crtmode;                   /* 0040:0049 */
                USHORT BIOS_crtcols;                   /* 0040:004A */
                USHORT BIOS_crtlen;                    /* 0040:004C */
                USHORT BIOS_crtstart;                  /* 0040:004E */
                USHORT BIOS_cursorposn[8];             /* 0040:0050 */
                union {
                  USHORT Type;
                  struct {
                    UCHAR EndCursor;
                    UCHAR StartCursor;
                    } CRTReg;
                  } BIOS_cursormode;                   /* 0040:0060 */
                UCHAR  BIOS_activepage;                /* 0040:0062 */
                USHORT BIOS_addr6845;                  /* 0040:0063 */
                UCHAR  BIOS_crtmodeset;                /* 0040:0065 */
                UCHAR  BIOS_crtpalette;                /* 0040:0066 */
                UCHAR  BIOS_SystemData[0x1D];          /* 0040:0067 */
                UCHAR  BIOS_rows;                      /* 0040:0084 */
                USHORT BIOS_points;                    /* 0040:0085 */
                UCHAR  BIOS_info;                      /* 0040:0087 */
                UCHAR  BIOS_info3;                     /* 0040:0088 */
                UCHAR  BIOS_DiskData[0x1F];            /* 0040:0089 */
                struct _VIDEO_PARAMS {
                  char far *VideoTablePtr;
                  struct _EGA_PALETTE {
                    UCHAR Palettes[16]; /* bytes 0 - 15 = palette registers */
                    UCHAR Overscan;     /* byte 16 = overscan register */
                    } far *EGARegs;
                  } far *BIOS_saveptr;                 /* 0040:00A8 */
          } VIDEO_BIOS;

typedef struct {
        USHORT  cb     ;
        USHORT  adapter;
        USHORT  display;
        ULONG   cbMemory;
        USHORT  Configuration; /* 1.2 */
        USHORT  DeviceDriver;
        USHORT  Flags;
        ULONG   HWBufferSize;
        ULONG   FullSaveSize;
        ULONG   PartSaveSize;
        USHORT  EMAdaptersOFF;
        USHORT  EMDisplaysOFF;
        USHORT  LEMAdapterdata; /* @BB7 */
        USHORT  EMAdapters;
        USHORT  LEMDisplaydata; /* @BB7 */
        USHORT  EMDisplays;
        } VDHCONFIGINFO;

typedef struct {

          UCHAR MiscOutputReg;

          union {
            UCHAR All[0x04+1];
            struct {
              UCHAR Reset;
              UCHAR ClockingMode;
              UCHAR MapMask;
              } Regs;
            } Sequencers;

          union {
            UCHAR All[0x14+1];
            struct {
              UCHAR Palettes[0x0F+1];
              UCHAR ModeControl;
              UCHAR Overscan;
              UCHAR ColorPlane;
              } Regs;
            } Attributes;

          UCHAR GraphicsRegs[0x08+1];

          union {
            UCHAR All[0x18+1];
            struct {
              UCHAR Others1[10];
              UCHAR CursorStart;
              UCHAR CursorEnd;
              UCHAR Others2[2];
              UCHAR CursorLocHigh;
              UCHAR CursorLocLow;
              UCHAR Others3[4];
              UCHAR Underline;
              } Regs;
            } CRTCtlRegs;

            UCHAR Fore_Color;   /* 12H Default foreground color     */ /*J-KKJ*/
            UCHAR Fore_Int  ;   /* 3FH Default foreground intensity color */ /*J-KKJ*/

          } HWREGS;

typedef struct {      /* HW Defaults Setting Values Table */
            UCHAR GridColor;
            UCHAR CursorColor;
            UCHAR CursorControl;
            UCHAR CursorStart;
            UCHAR CursorEnd;
            UCHAR CursorLocHigh;
            UCHAR CursorLocLow;
            UCHAR CursorWidth;
            REGCMD ModeRegs[MAX_MODE_CMDS+1];   /* Register command table */
          } HW_DEFAULT;

/*----------------------------------------------------------------------*/
/* Definition of the Environment Block and its flags                    */
/*----------------------------------------------------------------------*/

#define ENVFLAG_3xBOX           0x0001  /*D198*/
#define DEFAULT_ENVFLAGS        0       /*D198*/

typedef struct {

          USHORT        ModeDataOFF;                                   /*J-KKJ*/
          UCHAR         ModeIndex;    /* Index in Mode table to current mode *//*J-KKJ*/
          ULONG         EnvBuffID;    // Environment Buffer ID          J-KK1120

          USHORT        EnvFlags;     /* Flag word for this environment, D198*/
          USHORT        SessionNum;   /* To support the Font and Xvio.J-KK0925*/

// To Support Real Mode.
          SEL           Physaddrsel[2];                              /*j-ys921*/
          SEL           Phxplanessel[8];                             /*j-ys921*/

// For BufferUpdate
          USHORT        FormatIndex; // Format Index for BufferUpdate  J-KK1017
          USHORT        ScreenSize;  // Screen Size 80*25*2            J-KK1017
          USHORT        Option;      // Blink/Hint & FontCall Option   J-KK1017
          UCHAR         FormatChanged; // Format Changed Flag          J-KK1017
          UCHAR         DBCSEvBuff[DBCSEvBuffSize]; // DBCS Ev Buffer  J-KK1017

// For Print Screen
          short         UserFont; // -1 -SELECTABLE, -2 -NOT_SELECTABLE J-KK1025
                                  //  0 - None                          J-KK1025

// To Support MS-XVIO
          SEL           LVB_Selector;                                //J-KK1026

//********************************************************************//*J-KKJ*/
//*    Above data area must not be changed !!!!!                     *//*J-KKJ*/
//*    If changed, must change ENV STRUC in VDHEQU.INC !!!           *//*J-KKJ*/
//********************************************************************//*J-KKJ*/

          VIOMODEINFO   ModeData;     /* ScrollRect must follow ModeData @P1 */
          SCRLRECT      ScrollRect;   /* Scrollable rectangle of text screen @P1 */
          USHORT        AttrBufSize;  /* Byte in an attribute for cur mode   @P1 */
          UCHAR         AttrBuf[4];   /* default attribute for current mode  @P1 */
          USHORT        NATIVE_MODE;  /* True if native mode, false if VGA passthru *//*J-KKJ*/

// Don't change the following cursor data order !!!                 /*J-KK1127*/
          USHORT        CursorRow;                                  /*J-KK1127*/
          USHORT        CursorCol;                                  /*J-KK1127*/
          USHORT        CursorStart;                                /*J-KK1127*/
          USHORT        CursorEnd;                                  /*J-KK1127*/
          USHORT        CursorWidth;                                /*J-KK1127*/
          USHORT        CursorAttribute;                            /*J-KK1127*/
          USHORT        CursorColor;                                    //J-TS00
          USHORT        GridColor;                                      //J-TS00

          HWREGS        Hardware;

          UCHAR         First_Grid_Color; // For Only EPOCH MONO Mode  J-KK0119

          CLUTDATA      LookupTable[0xFF+1];    /* 0x00 - 0xFF */

          USHORT        Overscan;                                      /*J-KKJ*/
          USHORT        Underscore;                                    /*J-KKJ*/
          USHORT        VideoEnable;
          USHORT        CodePageID;                                    /*J-KKJ*/

// Configuration Data
          USHORT DisplayType;     /* Display Type */
          USHORT DisplayAdapter;  /* Display Adapter */
          ULONG  MemorySize;      /* Amount of memory on display adapter */
          ULONG  PartialSaveSize; /* Room required to save entire PVB in the popup mode */
          ULONG  MaxFullSaveSize; /* Max Room required to save entire PVB */

                       // Start of VGA environment for chaining.
          USHORT        VGAEnvironment;                                /*J-KKJ*/
          } ENVIRONMENT;

/* @C10 #ifdef ROMFONT_SUPPORT */
#ifdef FONT_SUPPORT                                                     /*@C10*/

typedef struct {                /* PTM 2895                     */
                                /* To create table of ROM and   */
        USHORT  CodePageID;     /*  code page fonts to search   */
        USHORT  PelRows;        /*  to get a font               */
        USHORT  PelColumns;
/*************************************@C10 union {*/
        UCHAR far * FontPTR;                                            /*@C10*/
/*************************************@C10        FarAddress RFont_Address;*/
/*************************************@C10              } fontu;*/
        USHORT  BaseRows;                                               /*@C10*/
        USHORT  BaseColumns;                                            /*@C10*/
/*************************************@C10        union {*/
        UCHAR far * BaseFontPTR;                                        /*@C10*/
/*************************************@C10         FarAddress RBase_Address;*/
/*************************************@C10               } baseu;*/
        } ROMCP_TABLE;

typedef union {                                                      /*@C10*/
          struct part p;                                             /*@C10*/
          ROMCP_TABLE *ptr;                                          /*@C10*/
          } rcp_addr;                                                /*@C10*/

#endif

/*****************************************************************************/
/* VDH Routine Type Definitions */
/*****************************************************************************/

typedef struct {
          USHORT Length;
          USHORT Flags;
/* @P1    USHORT ByteTableLen; */
/* @P1    USHORT ByteTableOFF; */
          USHORT CellTableLen;
          USHORT CellTableOFF;
          } VDH_DBCS;

typedef struct {
          USHORT   Length;
          USHORT   Flags;
          CLUTDATA far *LookupTable; /* 0x00 - 0xFF */
          USHORT   FirstEntry;
          USHORT   NumEntries;
          } VDH_CLUT;

typedef struct {
          USHORT Length;
          USHORT Flags;
          USHORT Row;
          USHORT Column;
          USHORT TopScanLine;
          USHORT BottomScanLine;
          USHORT Width;
          USHORT Attribute;
          } VDH_CURSOR;

typedef struct {
          USHORT     Length;
          USHORT     Flags;
          UCHAR far *FontBuffer;
          USHORT     FontLength;
          USHORT     PelColumns;
          USHORT     PelRows;
          } VDH_FONT;

typedef struct {
          USHORT Length;
          USHORT Flags;
          USHORT Blink;
          USHORT Overscan;
          USHORT Underscore;
          USHORT VideoEnable;
          ULONG  DisplayMask;
          USHORT CodePageID;
          USHORT ScrlLeft;                                      /*      @P1 */
          USHORT ScrlTop;                                       /*      @P1 */
          USHORT ScrlRight;                                     /*      @P1 */
          USHORT ScrlBottom;                                    /*      @P1 */
          USHORT ScreenRows;                                    /*      @P1 */
          USHORT ScreenCols;                                    /*      @P1 */
          } VDH_VARIABLE;

typedef struct {
          USHORT       Length;
          USHORT       Flags;
          PVIOMODEINFO ModeDataPTR;
          } VDH_MODE;

typedef struct {
          USHORT     Length;
          USHORT     Flags;
          REGDATA2   PaletteBuffer;
          } VDH_PALETTE;

typedef struct {
          USHORT      Length;
          USHORT      Flags;
          PVIOPHYSBUF PVBDataPTR;
          } VDH_GETPVB;

typedef struct {                   /* alternate VIOPHYSBUF structure used */
          USHORT      cb;          /* if 0 length passed in primary       */
          SEL         asel[2];     /* VIOPHYSBUF structure                */
          } ALT_VIOPHYSBUF;

typedef struct {
          USHORT Length;
          USHORT Flags;
          USHORT LDTSelector;
          } VDH_FREEPVB;

typedef struct {
          USHORT         Length;
          USHORT         Flags;
          VDHCONFIGINFO far *ConfigDataPTR;
          } VDH_CONFIG;

typedef struct {
          USHORT Length;
          USHORT Flags;
          USHORT Env_Sel;              /*J-KK0926 Undocumented Parms*/
          USHORT SessionNum;           /*J-KK0926 Undocumented Parms*/
          } VDH_INITENV;

typedef struct {
          USHORT Length;
          USHORT Flags;
          USHORT PVBHugeSEL;
          } VDH_SAVEREST;

typedef struct {
          USHORT     Length;
          USHORT     Flags;
          UCHAR far *AppDataAddr;
          UCHAR far *AppCellAddr;
          USHORT     Index;
          USHORT     StartRow;
          USHORT     StartCol;
          USHORT     SecondRow;
          USHORT     SecondCol;
          USHORT     RepeatFactor;
          USHORT     LogicalBufSel;
          } VDH_BUFUP;

typedef struct {                                                /*      @P1 */
          USHORT     Length;                                    /*      @P1 */
          USHORT     Flags;                                     /*      @P1 */
          UCHAR      FormatId;                                  /*      @P1 */
          UCHAR      AttrCount;                                 /*      @P1 */
          USHORT     LVBWidth;                                  /*      @P1 */
          USHORT     LVBHeight;                                 /*      @P1 */
          ULONG      LVBSize;                                   /*      @P1 */
          USHORT     AttrBufSize;                               /*      @P1 */
          UCHAR far *AttrBufAddr;                               /*      @P1 */
          } VDH_LVB;                                            /*      @P1 */

typedef struct {                                                        //J-TS00
          USHORT     Length;                                            //J-TS00
          USHORT     Flags;                                             //J-TS00
          USHORT     LVBSel;                                            //J-TS00
          UCHAR      BugBug[6];                                         //J-TS00
          USHORT     HdPrt;                                             //J-TS00
          } VDH_PRINT;                                                  //J-TS00

typedef struct {                                                        //J-TS00
          USHORT     Length;                                            //J-TS00
          USHORT     Flags;                                             //J-TS00
          USHORT     LVBSel;                                            //J-TS00
          } VDH_CLOSEENV;                                               //J-TS00

/******************************************************************************/
/* VDH Routine Entry Points                                                   */
/******************************************************************************/
USHORT EXPENTRY DevEnable(       DEV_PARM2 far *,   DEV_PARM1 far *,    ULONG );
USHORT EXPENTRY BufferUpdate(    ENVIRONMENT far *, VDH_BUFUP far *,    ULONG );
USHORT EXPENTRY GetDBCSInfo(     ENVIRONMENT far *, VDH_DBCS far *,     ULONG );
USHORT EXPENTRY GetColorLookup(  ENVIRONMENT far *, VDH_CLUT far *,     ULONG );
USHORT EXPENTRY SetColorLookup(  ENVIRONMENT far *, VDH_CLUT far *,     ULONG );
USHORT EXPENTRY GetCursorInfo(   ENVIRONMENT far *, VDH_CURSOR far *,   ULONG );
USHORT EXPENTRY SetCursorInfo(   ENVIRONMENT far *, VDH_CURSOR far *,   ULONG );
USHORT EXPENTRY GetCurrentFont(  ENVIRONMENT far *, VDH_FONT far *,     ULONG );
USHORT EXPENTRY SetCurrentFont(  ENVIRONMENT far *, VDH_FONT far *,     ULONG );
USHORT EXPENTRY GetVariableInfo( ENVIRONMENT far *, VDH_VARIABLE far *, ULONG );
USHORT EXPENTRY SetVariableInfo( ENVIRONMENT far *, VDH_VARIABLE far *, ULONG );
USHORT EXPENTRY GetMode(         ENVIRONMENT far *, VDH_MODE far *,     ULONG );
USHORT EXPENTRY SetMode(         ENVIRONMENT far *, VDH_MODE far *,     ULONG );
USHORT EXPENTRY GetPaletteReg(   ENVIRONMENT far *, VDH_PALETTE far *,  ULONG );
USHORT EXPENTRY SetPaletteReg(   ENVIRONMENT far *, VDH_PALETTE far *,  ULONG );
USHORT EXPENTRY GetPhysBuf(      ENVIRONMENT far *, VDH_GETPVB far *,   ULONG );
USHORT EXPENTRY FreePhysBuf(     ENVIRONMENT far *, VDH_FREEPVB far *,  ULONG );
USHORT EXPENTRY RetConfigInfo(   ENVIRONMENT far *, VDH_CONFIG far *,   ULONG );
USHORT EXPENTRY InitEnv(         ENVIRONMENT far *, VDH_INITENV far *,  ULONG );
USHORT EXPENTRY CloseEnv(        ENVIRONMENT far *, VDH_CLOSEENV far *, ULONG ); //J-TS00
USHORT EXPENTRY SaveEnv(         ENVIRONMENT far *, VDH_SAVEREST far *, ULONG );
USHORT EXPENTRY RestoreEnv(      ENVIRONMENT far *, VDH_SAVEREST far *, ULONG );
USHORT EXPENTRY ChainRouter(     ENVIRONMENT far *, char far *,         ULONG );
USHORT EXPENTRY GetLVBInfo(      ENVIRONMENT far *, VDH_LVB far *,      ULONG );
USHORT EXPENTRY PrintScreen(     ENVIRONMENT far *, VDH_PRINT far *,    ULONG ); //J-TS00

/******************************************************************************/
/* Private interfaces                                                         */
/******************************************************************************/
USHORT        near     PhysToUVirt( FarAddress, FarAddress far *, USHORT );      /*@T30*/ /*@B15*/
void          near     FreePhysToUVirt( USHORT );                                         /*@B15*/
USHORT PASCAL near     SaveRestorePVB( VDH_SAVEREST far *, USHORT, UCHAR far *, ENVIRONMENT far * ); /*@B15*/
void   PASCAL near     SaveRestoreHW( ENVIRONMENT far *, USHORT ); /*@B15*/
USHORT PASCAL near     GetModeIndex( ENVIRONMENT far * ); /*@B15*/
void          Transfer( FarAddress *, FarAddress *, USHORT, USHORT ); /*@B15*/
USHORT        far      Query8514A( void );
USHORT        far      QueryXGA ( void );                               /*@T72*/
USHORT        far      HardwareRows( void );
USHORT        far      HardwareColumns( void );
USHORT        far      HardwareColor( void );
void          far      CharFontBegin( void );
void EXPENTRY CharFontEnd( UCHAR );
void EXPENTRY CharFontEnd2( UCHAR );
void          far      AccessFont( UCHAR far *, UCHAR far *, USHORT, USHORT, UCHAR far *, USHORT, UCHAR );
short  PASCAL near     ExamineConfig( void ); /*@B15*/
void   PASCAL near     LeaveNativeMode( void ); /*@B15*/
void   PASCAL near     SetHWMode( UCHAR, USHORT, ENVIRONMENT far * ); /*@B15*/
void   PASCAL near     SetHWFont( ENVIRONMENT far *, UCHAR far *, UCHAR far * ); /*@B15*/
void   PASCAL near     SetHWFontRegs( ENVIRONMENT far *, USHORT );   /*@tb35ff*/
void   PASCAL near     SetEnvMode( UCHAR, ENVIRONMENT far *, ENVIRONMENT far *, USHORT ); /*@B15,@T70*/
USHORT PASCAL near     BitNum( USHORT ); /*@B15*/
UCHAR  PASCAL near     FindFont( USHORT, USHORT, ENVIRONMENT far * ); /*@B15*/
USHORT PASCAL near     BIOSData( UCHAR, ENVIRONMENT far * );       /*@B15,@C35*/
void EXPENTRY SetMapMask( USHORT, USHORT );
void EXPENTRY AccessCursorPos(   USHORT, USHORT, USHORT, USHORT far * );
void EXPENTRY AccessCursorType(          USHORT, USHORT, USHORT far * );
void EXPENTRY AccessBlink(               USHORT, USHORT, USHORT far * );
void EXPENTRY AccessOverscan(            USHORT, USHORT, USHORT far * );
void EXPENTRY AccessUnderscore(          USHORT, USHORT, USHORT far * );
void EXPENTRY AccessVideoEnable(         USHORT, USHORT, USHORT far * );
void EXPENTRY AccessDisplayMask(                 USHORT, ULONG  far * );
void EXPENTRY AccessCLUT( USHORT, CLUTDATA far * far * );
void EXPENTRY AccessHardware( REGADDRESS far *, USHORT, USHORT, USHORT,  REGDATA far * );
void EXPENTRY AccessRegister( REGADDRESS far *, USHORT, UCHAR far * );
UCHAR  PASCAL  near    ReadCMOS (UCHAR);
USHORT        near getVideoType( void );                                /*@T39*/
#ifdef  J_INSTALL                                                       //J-TS00V
USHORT        near getVideoTypeJ( void );                               //J-TS00V
#endif  //J-INSTALL                                                     //J-TS00V
int    PASCAL near videoIoctl(UCHAR *, UCHAR *, unsigned);              /*@T39*/
USHORT PASCAL near getEGAinfo(EGABIOSINFO *);                           /*@T39*/
USHORT PASCAL near GetCodePage(void);                               /*J-KK1002*/
USHORT        near InitPointer(USHORT);                                 //J-TS00
USHORT        near InitVideoBuff(void);                                 //J-TS00
USHORT        near ClosePointer(USHORT);                                //J-TS00
USHORT        near strcmp(UCHAR *, UCHAR *);                            //J-TS00V


//---------------------------------------------------------------------------
// Japan Unique Code
//---------------------------------------------------------------------------

USHORT PASCAL near RestoreLVB( VDH_SAVEREST far *, ENVIRONMENT far * );  /*J-KKJ*/
USHORT PASCAL near ForceToVGA( ENVIRONMENT far * );                     //J-TS00
USHORT        near GetLimit( USHORT );                              /*J-KKJ*/
USHORT PASCAL near CLEAR_LVB( USHORT, SEL, USHORT );                //J-KK1117
void   PASCAL near Clear_PVB( ENVIRONMENT far * );                  /*J-KKJ*/
USHORT PASCAL near JBUFFERUPDATE( ENVIRONMENT far *, VDH_BUFUP far *, ULONG ); /*J-KKJ*/
USHORT PASCAL near JVDHPRTSC( ENVIRONMENT far *, VDH_PRINT far *, ULONG ); /*J-KK1011*/
void   PASCAL near SetCursorPos( USHORT, USHORT );                      //J-TS00
void   PASCAL near SetCursorType( SHORT, SHORT, USHORT, USHORT );       //J-TS00
void   PASCAL near SetCursorColor( SHORT );                             //J-TS00
void   PASCAL near CursorOff(void);                                     //J-TS00
USHORT PASCAL near GetCursorColor(void);                                //J-TS00
void   PASCAL near InitCursor( USHORT );                                //J-TS00
void   PASCAL near InitAPA(void);                                       //J-TS00
void   PASCAL near ClearShadowAPA( USHORT );                            //J-TS00
void   PASCAL near SetGridDrawColor( SHORT );                           //J-TS00
USHORT PASCAL near GetGridDrawColor(void);                              //J-TS00
#ifdef  J_INSTALL                                                       //J-TS00
USHORT far         CheckID( void );                                     //J-TS00
USHORT far         GetHWConf( void );                                   //J-TS00
#endif  //J_INSTALL                                                     //J-TS00
extern UCHAR shadow[];                                                  //J-TS00
extern UCHAR far *APAStart;                                             //J-TS00
extern UCHAR far *SBCSBaseImage;                                        //J-TS00
extern UCHAR far *SBCSExtraImage;                                       //J-TS00

#ifdef XVIO
//---------------------------------------------------------------------------
// XVIO Interface
//---------------------------------------------------------------------------
#define XvsInitialize    0
#define XvsSuspend       1
#define XvsResume        2
#define XvsHide          3
#define XvsRedraw        4
#define XvsSetBuf        5
#define XvsSetMode       6
#define XvsSetState      7
#define XvsSetCurPos     8
#define XvsSetCurType    9
#define XvsSetTimeout   10
#define XvsSetCP        11

#define Susp_TimeOut    0xFFFF                     /* Time Out Value */

// Option
#define Suspend          1
#define Resume           2
#define FG_Session       4                      // Foreground Session J-KK0213
#define HardErr_Redraw   8             // Redraw after HardError       @KK0622
#define NoOption         0


typedef struct {
          USHORT Length;
          UCHAR  Reserve;           /*J-KK0926*/
          UCHAR  Session;           /*J-KK0926*/
          ULONG  TimeOut;
          } XVS_SETTIMEOUT;

typedef struct {
          USHORT Length;
          UCHAR  Reserve;           /*J-KK0926*/
          UCHAR  Session;           /*J-KK0926*/
          SEL    CommonSel;         /*J-KK0929*/
          USHORT Option;            /*J-KK1002*/
          } XVS_INITIALIZE;

#define   XVS_Always_CallFNT   1         /*J-KK1005*/

typedef struct {
          USHORT Length;
//Del     ULONG  TimeOut;
          UCHAR  Reserve;           /*J-KK0926*/
          UCHAR  Session;           /*J-KK0926*/
          } XVS_SUSPEND;

typedef struct {
          USHORT Length;
          UCHAR  Reserve;           /*J-KK0926*/
          UCHAR  Session;           /*J-KK0926*/
          } XVS_RESUME;

typedef struct {
          USHORT Length;
          UCHAR  Option;
//J-KK0926UCHAR  Reserve;
          UCHAR  Session;           /*J-KK0926*/
          USHORT StartRow;
          USHORT EndRow;
          } XVS_HIDE;

typedef struct {
          USHORT Length;
          UCHAR  Option;
//J-KK0926UCHAR  Reserve;
          UCHAR  Session;           /*J-KK0926*/
          USHORT StartRow;
          USHORT EndRow;
          USHORT LVBSel;            //Pass LVB Selector J-KK0213
          } XVS_REDRAW;

typedef struct {
          USHORT Length;
          UCHAR  Option;
//J-KK0926UCHAR  Reserve;
          UCHAR  Session;           /*J-KK0926*/
          USHORT LVBSel;
// Del    USHORT LVBLen;
          } XVS_SETBUF;

typedef struct {
          USHORT Length;
          UCHAR  Option;
//J-KK0926UCHAR  Reserve;
          UCHAR  Session;           /*J-KK0926*/
          UCHAR  fbType;
          UCHAR  color;
          USHORT col;
          USHORT row;
          USHORT hres;
          USHORT vres;
          UCHAR  fmt_ID;
          UCHAR  attrib;
          UCHAR  far *BufferAddress;
          ULONG  BufferLength;
          USHORT SystemReserve;
          UCHAR  HWMode;
//J-KK1023UCHAR  Reserved;
          UCHAR  Default_CursorColor;    //Default Cursor Color J-KK1023
          } XVS_SETMODE;

typedef struct {
          USHORT Length;
          UCHAR  Option;
//J-KK0926UCHAR  Reserve;
          UCHAR  Session;           /*J-KK0926*/
//J-KK0911 USHORT ReqType;
          USHORT BlinkHInt;      /*J-KK0911*/
          USHORT NonScrRow;
          USHORT NonScrCol;      /*J-KK0928*/
          } XVS_SETSTATE;

typedef struct {
          USHORT Length;
          UCHAR  Option;
//J-KK0926UCHAR  Reserve;
          UCHAR  Session;           /*J-KK0926*/
          USHORT Row;
          USHORT Col;
          } XVS_SETCURPOS;

typedef struct {
          USHORT Length;
          UCHAR  Option;
//J-KK0926UCHAR  Reserve;
          UCHAR  Session;           /*J-KK0926*/
          USHORT Start;
          USHORT End;
          USHORT Width;
          USHORT Attribute;
          } XVS_SETCURTYPE;

typedef struct {
          USHORT Length;
          UCHAR  Option;
//J-KK0926UCHAR  Reserve;
          UCHAR  Session;           /*J-KK0926*/
          USHORT CodePage;
          } XVS_SETCP;

//@XVIO USHORT EXPENTRY XVIOVDHIF( USHORT, PUSHORT);
USHORT PASCAL NEAR XVIOVDHIF( USHORT, PUSHORT);                //@XVIO

// Common Data Area                                                  J-KK0927
typedef struct {                                                   /*J-KK0927*/
          UCHAR  CurLength;         /* Cursor Length Register        J-KK0929*/
          UCHAR  CurControl;        /* Cursor Control Register       J-KK0929*/
          } COMMONAREA;                                            /*J-KK0929*/

#endif  /*XVIO*/
