;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE    60,132
        TITLE   EPOCHLVB.ASM -- Buffer Write Routines for EPOCH

;/*****************************************************************************
;*
;* SOURCE FILE NAME = EPOCHLVB.ASM
;*
;* DESCRIPTIVE NAME = BUFFERUPDATE write routines
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION
;*
;* FUNCTIONS    WriteCellStrE, WriteCharStrE, WriteCharStrAttrE,
;*              WriteNCharE, WriteNAttrE, WriteNCellE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES  NONE
;*
;* EXTERNAL FUNCTIONS   UpdateRegenE    (in EPOCHPVB.ASM)
;*                      CheckDBCS       (in XGAWRITE.ASM)
;*
;* CHANGE ACTIVIY =
;*   DATE      FLAG       APAR    CHANGE DESCRIPTION
;*   --------  ---------- -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx xxxxx   xxxxxxx
;*   10/03/89  J-KK1003           KKJ, INSTALLATION and Change Attr Translation.
;*   10/24/89  J-KK1024           KKJ, Moved EPOCH_CFillR proc out
;*             j-ys1024,1026,1027,1102ms for MS-Xvio support.
;*   11/02/89  j-ys1102                Extension Hankaku support.
;*   11/06/89  j-ys1106                MS-XVIO Support.
;*   11/29/89  J-KK1129           KKJ, Limit Check for NCELL and NCHAR with DBCS.
;*   11/30/89  J-KK1130           KKJ, CLD is assumed in CFill.
;*   04/01/91  J-TS040191         T.Sobue  DBCS exceptional handling at string head & tail
;*                                         is not correct.
;*   06/16/93  J-TS0616           TSO, DBCS Exception handling of VioWrtNAttr
;*   07/07/93  J-TS0707           TSO, DBCS J-TS0616 doesn't take care of buffer end
;****************************************************************************/

        .286c                           ; 286 protect mode instructions

        .xlist
        INCLUDE struc.inc               ; Structure macro
        INCLUDE vdhequ.inc              ; Buffer update equates
        INCLUDE vdhstruc.inc            ; Buffer update data structures
        .list

        IFNDEF  INSTALLATION            ; Installation J-KK1003
            EXTRN   CheckDBCS:NEAR
            EXTRN   UpdateRegenE:NEAR
            EXTRN   UpdateAttrE:NEAR
            EXTRN   Translate:NEAR      ;J-KK0828

;;     For MS-XVIO
            EXTRN   UpdateCARegenE:NEAR ;                               j-ys1106
            EXTRN   UpdateCAAttrE:NEAR  ;                               j-ys1106

        ENDIF

R2CSEG  SEGMENT WORD    PUBLIC 'CODE'
        ASSUME  CS:R2CSEG,DS:NOTHING,ES:NOTHING

        IFDEF   INSTALLATION            ; Installation J-KK1003
Dummy       proc    near
WriteCStrE  label   byte
WriteNCellE label   byte
WriteNCharE label   byte
WriteNAttrE label   byte
EPOCH_UpLeft label  byte
EPOCH_DnRight label byte
EPOCH_CFill label   byte
EPOCH_CFillR label  byte
EPOCH_LVBrecttoPVB label byte           ;j-ys1026
EPOCH_CArecttoPVB label byte            ;j-ys111
            public  WriteCStrE
            public  WriteNCellE
            public  WriteNCharE
            public  WriteNAttrE
            public  EPOCH_UpLeft
            public  EPOCH_DnRight
            public  EPOCH_CFill
            public  EPOCH_CFillR
            public  EPOCH_LVBrecttoPVB  ;j-ys1026
            public  EPOCH_CArecttoPVB   ;j-ys111
            ret
Dummy       endp
        ELSE

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     WriteCStrE                                      *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler write cells/chars/charsA   *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGAWRITE.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
WriteCStrE  proc
            public  WriteCStrE

            mov     bx, [bp].Sub_index  ; Get Function Index

            .if     < bx e WCHARA >     ; CharStrAttr Request          ;J-KK0828
                test    [bp].Sub_Flags, CGAAttr ; CGA Translation          ;J-KK0828
                .if     nz              ;                              ;J-KK0828
                    mov     ax, [bp].Sub_attribute ; Get Attribute         ;J-KK1003
                    Call    Translate   ; Common AX -> Epoch AL        ;J-KK0828
                    mov     byte ptr [bp].Sub_attribute,al ; Save Attribute;J-KK0828
                .endif                  ;                              ;J-KK0828
            .endif                      ;                              ;J-KK0828

;;*** Update LVB
            Call    HeadBound           ; 
            xor     dx,dx               ;clear the char counter
            .while  ncxz  near          ; 
                xor     ax,ax
                .if     < bx e WCELL >  ;Cell ?
                    lodsw               ;get a next cell
                    and     ah,02h      ;get extention bit
                .elseif < bx e WCHAR >  ;Char ?
                    lodsb               ;get a next char
                .else                   ;CharAttribute
                    lodsb               ;get a next char
                    mov     ah,byte ptr [bp].Sub_attribute ;get attribute
                .endif                  ; 
                dec     cx              ;adjust the loop counter (CX)
                inc     dx              ;increment the char counter (DX)

                test    ah,2h
                .if     nz
;;              .if     <ah e 2>        ;extention hankaku  ?
                    clc                 ;reset DBCS check flag
                .else
                    call    CheckDBCS   ; 
                .endif
                .if     c               ;if char have DBCS lead byte
                    .if     < dx gt 1 > ; Hankaku Char Counter must be GT 1.
                        push    ax      ; save ax
                        dec     dx      ; Adjust
                        push    si      ; 
                        dec     si      ; Adjust
                        cmp     bx,WCELL ; 
                        .if     e       ; 
                            dec     si  ; adjust si for attr
                        .endif          ; 
                        call    Write   ; Write the leading Hankaku String
                        pop     si
                        pop     ax      ; 
                    .endif

                    xor     dx,dx       ;clear the char counter (DX)
                    .if     ncxz        ;   & cx > 0
                        mov     ah,al   ;ah is DBCS lead
                        lodsb
                        cmp     bx,WCELL
                        .if     e       ; 
                            inc     si  ;adust si for attr
                        .endif          ; 
                        dec     cx      ;adjust the loop counter (CX)

                        xchg    al,ah   ; 
                        call    PutDBCS ;write dbcs into LVB
                    .else               ; Terminate with DBCS leading byte
                                        ; Ignored the last byte
                        dec     [bp].Sub_length
                    .endif              ; 
                .endif                  ; End of DBCS Case
            .endwhile                   ; 

            call    Write               ;Write Hankaku Char to LVB
            call    TailBound

;;*** Update PVB
            .if     < bit [bp].Sub_Option nand CA_Request > ; CA Request ;j-ys111
                call    UpdateRegenE    ; For Not CA
            .else                       ;                              ;j-ys1024
                call    UpdateCARegenE  ; For CA
            .endif

            ret
WriteCStrE  endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     WriteNCharE                                     *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler write N chars              *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGAWRITE.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
WriteNCharE proc                        ; Epoch Format
            public  WriteNCharE

;;*** Update LVB
            pushf
            Call    HeadBound           ; 
            popf
            .if     c                   ;*** DBCS handling
                mov     ah,ds:[si]      ; Get 2nd Character
                .repeat                 ; 
                    stosb               ;Set the lead byte
                    and     byte ptr es:[di],not (dbcsE1+dbcsE2) ;reset dbcs
                    or      byte ptr es:[di],dbcsE1 ;Set 1'st attr
                    inc     di          ; 
                    mov     byte ptr es:[di],ah ;Store the second byte
                    inc     di          ; 
                    or      byte ptr es:[di],dbcsE1+dbcsE2 ;Set second attr
                    inc     di          ; 
                .loop
            .else                       ;*** SBCS handling
                .repeat                 ; 
                    stosb               ;Store character
                    and     byte ptr es:[di],not (dbcsE1+dbcsE2) ;clear dbcs flags
                    inc     di          ;Skip attribute
                .loop                   ; 
            .endif                      ; 
            call    TailBound

;;*** Update PVB
            .if     < bit [bp].Sub_Option nand CA_Request > ; CA Request ;j-ys111
                call    UpdateRegenE    ; For Not CA
            .else                       ;                              ;j-ys1024
                call    UpdateCARegenE  ; For CA
            .endif

            ret
WriteNCharE endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     WriteNAttrE                                     *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler write N attribute          *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGAWRITE.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;* AL     --->  Attribute Byte                  (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
WriteNAttrE proc                        ; Epoch Format
            public  WriteNAttrE

        mov     ah, es:[di+1]           ; First char is DBCS 2nd ?      ;J-TS0616
        and     ah, dbcsE1+dbcsE2                                       ;J-TS0616
        .if     <ah eq dbcsE1+dbcsE2>                                   ;J-TS0616
            inc     [bp].Sub_length                                     ;J-TS0616
            sub     [bp].Sub_offset, 2                                  ;J-TS0616
            sub     [bp].PVBOff, 2                                      ;J-TS0616
        .endif                                                          ;J-TS0616

;;*** Update LVB
            push    bx                  ;                              ;j-ys1102
            mov     bl,al               ;                              ;j-ys1102
            and     bl,dbcsE1+dbcsE2    ;                              ;j-ys1102
            .if     <  bl e dbcsE2 >    ; if extention hankaku         ;j-ys1102
                and     al, not dbcsE1  ;                              ;j-ys1102
            .else                       ;                              ;j-ys1102
                and     al,not (dbcsE1+dbcsE2) ;clear dbcs bits
            .endif                      ;                              ;j-ys1102
            pop     bx                  ;                              ;j-ys1102
            mov     ah,al               ;copy attribute to ah
            .repeat
                inc     di              ;Skip char byte
                mov     al,byte ptr es:[di] ;get target attribute
                and     al, dbcsE1+dbcsE2 ;get dbcs attribute bits of target
                or      al,ah           ;merge them
                stosb                   ;set attribute
            .loop

        mov     ah, es:[di-1]           ; Last char is DBCS 1st ?       ;J-TS0707
        and     ah, dbcsE1+dbcsE2                                       ;J-TS0616
        .if     <ah eq dbcsE1>                                          ;J-TS0707
            inc     [bp].Sub_length                                     ;J-TS0616
        .endif                                                          ;J-TS0616

;;*** Update PVB
            .if     < bit [bp].Sub_Option nand CA_Request > ;          ;j-ys111
                call    UpdateAttrE     ; For Not CA
            .else                       ;                              ;j-ys1024
                call    UpdateCAAttrE   ; For CA
            .endif                      ; 

            ret
WriteNAttrE endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     WriteNCellE                                     *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler write N cells              *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGAWRITE.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
WriteNCellE proc                        ; Epoch Format
            public  WriteNCellE

;;*** Update LVB
            .if     <nc>                ; SBCS Cell                    ;J-KK1129
                test    [bp].Sub_Flags, CGAAttr ; CGA Translation          ;J-KK0828
                .if     nz              ; From WrtTTY                  ;J-KK0828
                    push    cx          ;                              ;J-KK1003
                    push    ax          ;                              ;J-KK1003
                    mov     ax, [bp].Sub_attribute ; Get Attribute         ;J-KK1003
                    Call    Translate   ; Common AX -> Epoch AL        ;J-KK0828
                    mov     cl, al      ; CL=AL                        ;J-KK1003
                    pop     ax          ;                              ;J-KK1003
                    mov     ah, cl      ; AH=CL ( New Attr )           ;J-KK1003
                    pop     cx          ;                              ;J-KK1003
                .endif                  ;                              ;J-KK0828
                clc                     ; SBCS Cell                    ;J-KK0828
            .endif                      ; 

            pushf                       ; 
            Call    HeadBound           ; 
            popf                        ; 
            .if     c                   ;*** DBCS Cell
                mov     dx,ds:[si]      ;Get 2nd Cell
                and     ah,not (dbcsE1+dbcsE2) ;Reset all flags
                or      ah,dbcsE1       ;Set dbcs first
                or      dh,dbcsE1+dbcsE2 ;Set dbcs second
                .repeat                 ; 
                    stosw               ;Store 1st Cell
                    xchg    ax,dx       ; 
                    stosw               ;Store 2nd Cell
                    xchg    ax,dx       ; 
                .loop                   ; 
            .else                       ;*** SBCS Cell
                and     ah,not dbcsE1   ;Reset dbcs flag
                rep     stosw           ;Fill buffer with Cells
            .endif                      ; 
            call    TailBound

;;*** Update PVB
            .if     < bit [bp].Sub_Option nand CA_Request > ; CA Request ;j-ys111
                call    UpdateRegenE    ; For Not CA
            .else                       ;                              ;j-ys1024
                call    UpdateCARegenE  ; For CA
            .endif

            ret
WriteNCellE endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME: XXXXX                                               *
;*                                                                      *
;* DESCRIPTIVE NAME:    DBCS Exeption Handling Routine                  *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
;; OverWriting Handling
;; DS:SI - User Buffer
;; ES:DI - LVB
HeadBound   PROC    NEAR                ;OverWriting of Head DBCS Widow
            push    ax                                                  ;J-TS040191
            cmp     di,2                ;check start of screen or not ?
            .if     ge
                mov     al, es:[di+1]                                   ;J-TS040191
                and     al, dbcsE1+dbcsE2                               ;J-TS040191
                .if     <al eq dbcsE1+dbcsE2>                           ;J-TS040191
                    mov     byte ptr es:[di-2],20h ;set space
                    and     byte ptr es:[di-1],not (dbcsE1+dbcsE2) ;reset flag
                    inc     [bp].Sub_length ;adjust repeat count
                    sub     [bp].Sub_offset,2 ;adjust offset
                    sub     [bp].PVBOFF,2 ;adjust offset               ;j-ys1026
                .endif                  ; 
            .endif
            pop     ax                                                  ;J-TS040191
            ret                         ; 
HeadBound   ENDP                        ; 

TailBound   PROC    NEAR                ;Overwriting of Tail DBCS Widow
            push    ax                                                  ;J-TS040191
            cmp     di, [bp].Sub_Buffsize ;check end of screen or not ?
            .if     b
                mov     al, es:[di+1]                                   ;J-TS040191
                and     al, dbcsE1+dbcsE2                               ;J-TS040191
                .if     <al eq dbcsE1+dbcsE2>                           ;J-TS040191
                    mov     byte ptr es:[di],20h ;set space
                    inc     di          ; 
                    and     byte ptr es:[di],not (dbcsE1+dbcsE2) ;reset attr
                    inc     di          ; 
                    inc     [bp].Sub_length ;adjust repeat count
                .endif                  ; 
            .endif
            pop     ax                                                  ;J-TS040191
            ret                         ; 
TailBound   ENDP                        ; 

PutDBCS     PROC
;  al:lead   dbcs
;  ah:second dbcs
            cmp     bx,WCELL            ; 
            .if     e                   ;Cell ?
                stosb                   ;store dbcs lead byte
                mov     al,ds:[si-3]    ; 
                and     al,not (dbcsE1+dbcsE2) ;reset second bits
                or      al,dbcsE1       ; 
                stosb                   ;store dbcs lead byte attribute
                xchg    al,ah           ; 
                stosb                   ;store dbcs second byte
                mov     al,ds:[si-1]    ; 
                or      al,dbcsE1+dbcsE2 ; 
                stosb                   ;store dbcs second byte attribute
            .elseif < bx e WCHAR >      ;Char ?
                stosb                   ;store dbcs lead byte
                and     byte ptr es:[di],not (dbcsE1+dbcsE2) ;reset second bits
                or      byte ptr es:[di],dbcsE1
                inc     di
                xchg    al,ah
                stosb                   ;store dbcs second byte
                or      byte ptr es:[di],dbcsE1+dbcsE2
                inc     di
            .else                       ;Char Attribute
                push    ax              ;store dbcs first byte
                mov     ah,byte ptr [bp].Sub_attribute
                and     ah,not (dbcsE1+dbcsE2) ;reset second bits
                or      ah,dbcsE1       ;set first flag
                stosw
                pop     ax

                xchg    al,ah           ;store dbcs second byte
                mov     ah,byte ptr [bp].Sub_attribute
                or      ah,dbcsE1+dbcsE2 ;set second flag
                stosw
            .endif
            ret
PutDBCS     ENDP

Write       PROC                        ;Hankaku write routine
            Public  Write
            push    cx
            sub     si,dx               ;adjust si
            mov     cx,dx
            .if     ncxz
                .if     < bx e WCELL >  ;Cell ?
                    sub     si,dx       ;adjust si more!
                    .repeat
                        lodsw
                        and     ah,not dbcsE1 ;clear dbcs_flag
                        stosw
                    .loop
                .elseif < bx e WCHAR >  ;Char ?
                    .repeat
                        movsb
                        and     byte ptr es:[di],not (dbcsE1+dbcsE2) ;clear dbcs_flag
                        inc     di
                    .loop
                .else                   ;CharAttribute
                    mov     al,byte ptr [bp].Sub_attribute
                    and     al,not dbcsE1 ;clear dbcs_flag
                    .repeat
                        movsb
                        stosb
                    .loop
                .endif
            .endif
            pop     cx
            ret
Write       ENDP


;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     EPOCH_UpLeft                                    *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler Scroll Up/Left             *
;*                      Move a one line.                                *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGASCROL.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGASCROL.ASM)      *
;* CX     --->  Words (Cell) to be moved        (see XGASCROL.ASM)      *
;* Flag   --->  CLD                             (see XGASCROL.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
EPOCH_UpLeft proc
            public  EPOCH_UpLeft

            .if     < si ge 2 >  and    ; 
            test    byte ptr ds:[si+1],dbcsE2 ; Source Head is DBCS 2nd ?
            .if     nz                  ; 
                mov     byte ptr ds:[si], 20h ; Fill Blank to Second
                mov     byte ptr ds:[si-2], 20h ; Fill Blank to First
                and     byte ptr ds:[si+1], not (dbcsE1+dbcsE2) ;reset flag
                and     byte ptr ds:[si-1], not (dbcsE1+dbcsE2) ;reset flag
            .endif                      ; 

            .if     < di ge 2 >  and    ; 
            test    byte ptr es:[di+1],dbcsE2 ; Target Head is DBCS 2nd ?
            .if     nz                  ; Overwrite DBCS 1st
                mov     byte ptr es:[di-2],20h ;set space
                and     byte ptr es:[di-1],not (dbcsE1+dbcsE2) ;reset flag
            .endif                      ; 

            rep     movsw               ; Move Cells

;;                                      ; SI/DI-Pointed to Last+2 Cell
            .if     < si lt [bp].Sub_Buffsize > and
            test    byte ptr ds:[si+1],dbcsE2 ; Source Tail is DBCS 1st ?
            .if     nz                  ; Overwrite DBCS 2nd
                mov     byte ptr ds:[si], 20h ; Fill Blank to Second
                mov     byte ptr ds:[si-2], 20h ; Fill Blank to First
                and     byte ptr ds:[si+1], not (dbcsE1+dbcsE2) ;reset flag
                and     byte ptr ds:[si-1], not (dbcsE1+dbcsE2) ;reset flag
                mov     byte ptr es:[di-2],20h ;Change Copied Byte to Space
                and     byte ptr es:[di-1],not (dbcsE1+dbcsE2) ;reset flag
            .endif

            .if     < di lt [bp].Sub_Buffsize > and
            test    byte ptr es:[di+1],dbcsE2 ; Target Tail is DBCS 1st ?
            .if     nz                  ; Overwrite DBCS 2nd
                mov     byte ptr es:[di],20h ;set space
                and     byte ptr es:[di+1],not (dbcsE1+dbcsE2) ;reset flag
            .endif                      ; 

            ret
EPOCH_UpLeft endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     EPOCH_DnRight                                   *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler Scroll Down/Right          *
;*                      Move a one line.                                *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* DS:SI  --->  Source Buffer Address           (see XGASCROL.ASM)      *
;* ES:DI  --->  LVB Address                     (see XGASCROL.ASM)      *
;* CX     --->  Words (Cell) to be moved        (see XGASCROL.ASM)      *
;* Flag   --->  STD                             (see XGASCROL.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
EPOCH_DnRight proc
            public  EPOCH_DnRight
            push    ax

            mov     ax, [bp].Sub_Buffsize ; 
            sub     ax, 2               ; 
            push    ax                  ; Save Last Size
            .if     < si lt ax > and    ; 
            mov     al, ds:[si+1]       ; Source Head is DBCS 1st ?
            and     al, dbcsE1+dbcsE2   ; 
            .if     < al e dbcsE1 >     ; 
                mov     byte ptr ds:[si], 20h ; Fill Blank to First
                mov     byte ptr ds:[si+2], 20h ; Fill Blank to Second
                and     byte ptr ds:[si+1], not (dbcsE1+dbcsE2) ;reset flag
                and     byte ptr ds:[si+3], not (dbcsE1+dbcsE2) ;reset flag
            .endif
            pop     ax                  ; Restore Last Size

            .if     < di lt ax > and    ; 
            mov     al, es:[di+1]       ; Target Head is DBCS 1st ?
            and     al, dbcsE1+dbcsE2   ; 
            .if     < al e dbcsE1 >     ; Overwrite DBCS 2nd
                mov     byte ptr es:[di+2],20h ;set space
                and     byte ptr es:[di+3],not (dbcsE1+dbcsE2) ;reset flag
            .endif                      ; 


            rep     movsw               ; Move Cells except Last Cell

;;                                      ; SI/DI-Pointed to Last Cell-1
            .if     < si ge 0 > and     ; 
            mov     al, ds:[si+1]       ; Source Tail is DBCS 2nd ?
            and     al, dbcsE1+dbcsE2   ; 
            .if     < al e dbcsE1 >     ; 
                mov     byte ptr ds:[si], 20h ; Fill Blank to First
                mov     byte ptr ds:[si+2], 20h ; Fill Blank to Second
                and     byte ptr ds:[si+1], not (dbcsE1+dbcsE2) ;reset flag
                and     byte ptr ds:[si+3], not (dbcsE1+dbcsE2) ;reset flag
                mov     byte ptr es:[di+2],20h ; Change Copied byte to Space
                and     byte ptr es:[di+3],not (dbcsE1+dbcsE2) ;reset flag
            .endif

            .if     < di ge 0 > and     ; 
            mov     al, es:[di+1]       ; Target Tail is DBCS 2nd ?
            and     al, dbcsE1+dbcsE2   ; 
            .if     < al e dbcsE1 >     ; Overwrite DBCS 1st
                mov     byte ptr es:[di],20h ;set space
                and     byte ptr es:[di+1],not (dbcsE1+dbcsE2) ;reset flag
            .endif                      ; 

            pop     ax
            ret
EPOCH_DnRight endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     EPOCH_CFill                                     *
;*                                                                      *
;* DESCRIPTIVE NAME:    Video device handler Scroll Fill Cell           *
;*                      Fill one line with Cell into LVB & PVB          *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* ES:DI  --->  Tartget LVB Address             (see XGASCROL.ASM)      *
;* CX     --->  Words (Cell) to be moved        (see XGASCROL.ASM)      *
;* Flag   --->  CLD                             (see XGASCROL.ASM)      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
EPOCH_CFill proc
            public  EPOCH_CFill

            push    ax
            push    bx                  ;                              ;j-ys1106

            .if     < di ge 2 > and     ; 
            test    byte ptr es:[di+1],dbcsE2 ; Target Head is DBCS 2nd ?
            .if     nz                  ; Overwrite DBCS 1st
                mov     byte ptr es:[di-2],20h ;set space
                and     byte ptr es:[di-1],not (dbcsE1+dbcsE2) ;reset flag
            .endif                      ; 

            mov     ax,[bp].FillCellLow
            mov     bh,ah               ;                              ;j-ys1106
            and     bh, dbcsE1+dbcsE2   ;                              ;j-ys1106
            .if     < bh e dbcsE2 >     ; Check Extra Hankaku          ;j-ys1106
                and     ah,not dbcsE1   ;                              ;j-ys1106
            .else                       ;                              ;j-ys1106
                and     ah,not (dbcsE1+dbcsE2) ; reset flag
            .endif                      ;                              ;j-ys1106
            rep     stosw               ; Fill line with cell

            .if     < di lt [bp].Sub_Buffsize > and ; 
            test    byte ptr es:[di+1],dbcsE2 ; Target Tail is DBCS 1st ?
            .if     nz                  ; Overwrite DBCS 2nd
                mov     byte ptr es:[di],20h ;set space
                and     byte ptr es:[di+1],not (dbcsE1+dbcsE2) ;reset flag
            .endif                      ; 

            pop     bx                  ;                              ;j-ys1106
            pop     ax
            ret
EPOCH_CFill endp

        ENDIF

R2CSEG  ENDS
        END
