;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE    60,132
        TITLE   CURSOR.ASM -- OS/2V Cursor Control Routine

;/*****************************************************************************
;*
;* SOURCE FILE NAME = CURSOR.ASM
;*
;* DESCRIPTIVE NAME = Cursor Control Routine
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION
;*
;* FUNCTIONS
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES  NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVIY =
;*   DATE      FLAG       APAR    CHANGE DESCRIPTION
;*   --------  ---------- -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx xxxxx   xxxxxxx
;*   92/01/11  J-TS011792         T.Sobue PTR JS02380
;****************************************************************************/

        .286p                           ; 286 protect mode instructions

        .xlist
        INCLUDE struc.inc               ; Structure macro
        INCLUDE vdhequ.inc              ; Buffer update equates
        INCLUDE vdhstruc.inc            ; Buffer update data structures
        include vdh.inc                 ; Definitions
        include vgaemu.inc              ; VGA text emulation video buffer
        .list

        extrn   DOSFSRAMSEMREQUEST :FAR                                 ;J-TS011792
        extrn   DOSFSRAMSEMCLEAR   :FAR                                 ;J-TS011792

INSTSEG SEGMENT PARA PUBLIC 'DATA'
;************************************************************************
;*  Per process instance data                                           *
;************************************************************************
CursorOffset    dw      0
CursorSel       dw      0

        public  CursorOffset, CursorSel

INSTSEG ENDS

_DATA   SEGMENT WORD PUBLIC 'DATA'
;************************************************************************
;*  Global data                                                         *
;************************************************************************
        extrn   VideoBuffSel : word
        extrn   _SemAccessAPA : byte    ; APA exclusive access          ;J-TS011792

_DATA   ENDS

        extrn   DrawCursor       : far  ; cursor draw routine
        extrn   EraseCursor      : far  ; cursor draw routine
        extrn   _PhysToUVirt     : near ; Allocate PVB selector

R2CSEG  SEGMENT WORD    PUBLIC 'CODE'
        ASSUME  CS:R2CSEG,DS:NOTHING,ES:NOTHING

INITCURSOR      proc    near
        public  INITCURSOR

        push    bp                          ; setup stack frame
        mov     bp, sp

        push    ds                          ; save DS
        mov     ax, _DATA
        mov     ds, ax
        mov     ds, ds:VideoBuffSel

        mov     ds:VGA_CsrRow, 0            ; set cursor row position
        mov     ds:VGA_CsrCol, 0            ; set cursor column position
        mov     ds:VGA_CsrStart, 16         ; set cursor start line
        mov     ds:VGA_CsrEnd, 17           ; set cursor end line
        mov     ds:VGA_CsrWidth, 1          ; set cursor width
        mov     ds:VGA_CsrAttrib, 0         ; set cursor attribute
        mov     ds:VGA_CsrColor, 0fh        ; set default cursor color
        mov     ax, [bp+4]
        mov     ds:VGA_CsrScrWidth, ax      ; set screen width
        mov     ds:VGA_SaveFlag, 0          ; set no char is saved

        pop     ds                          ; restore DS
        pop     bp                          ; restore stack frame
        ret     2

INITCURSOR      endp

CheckCursorSel  proc    near
        public  CheckCursorSel

        mov     ax, INSTSEG                 ; set instance segment selector
        mov     es, ax

        verw    es:CursorSel                ; selector for cursor is valid ?

        .if     <nz>                        ; invalid ?
            push    0                       ; push APA length (64KB)
            push    es                      ; push selector address
            push    offset CursorOffset
            push    000ah                   ; push APA physical address
            push    0000h
            call    _PhysToUVirt            ; allocate new AAP selector
            add     sp, 10
        .else
            xor     ax, ax
        .endif

        ret

CheckCursorSel  endp


;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     CURSOROFF                                       *
;*                                                                      *
;* DESCRIPTIVE NAME:    Switch off cursor function for graphics mode    *
;*                                                                      *
;* INPUT:       None                                                    *
;*                                                                      *
;* INTERNAL REFERENCES: None                                            *
;*                                                                      *
;* EXTERNAL REFERENCES: None                                            *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
CURSOROFF   proc    near
        public  CURSOROFF

        push    ds
        mov     ax, _DATA
        mov     ds, ax
        mov     ds, ds:VideoBuffSel

        mov     ds:VGA_CsrAttrib, -1        ; set cursor mode hidden
        mov     ds:VGA_SaveFlag, 0          ; set no char is saved

        pop     ds
        ret

CURSOROFF   endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     SETCURSORPOS                                    *
;*                                                                      *
;* DESCRIPTIVE NAME:    Set cursor position                             *
;*                                                                      *
;* INPUT:       STACK FRAME on entry                                    *
;*                                                                      *
;* SS:SP  --->  ip              dw      Caller IP offset                *
;*              CursorCol       dw      Cursor column position          *
;*              CursorRow       dw      Cursor row position             *
;*                                                                      *
;* INTERNAL REFERENCES: None                                            *
;*                                                                      *
;* EXTERNAL REFERENCES: None                                            *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
SETCURSORPOS    proc    near
        public  SETCURSORPOS

        push    bp                          ; setup stack frame
        mov     bp, sp
        pusha
        push    ds
        mov     ax, _DATA
        mov     ds, ax
        mov     ds, ds:VideoBuffSel

        push    _DATA                                                   ;J-TS011792
        push    offset _SemAccessAPA                                    ;J-TS011792
        push    -1                                                      ;J-TS011792
        push    -1                                                      ;J-TS011792
        call    DOSFSRAMSEMREQUEST                                      ;J-TS011792

        call    HideCursor                  ; hide cursor

        mov     ax, [bp+6]                  ; copy row position
        mov     ds:VGA_CsrRow, ax

        mov     ax, [bp+4]                  ; copy column position
        mov     ds:VGA_CsrCol, ax

        call    ShowCursor                  ; show cursor again

        push    _DATA                                                   ;J-TS011792
        push    offset _SemAccessAPA                                    ;J-TS011792
        call    DOSFSRAMSEMCLEAR                                        ;J-TS011792

        pop     ds                          ; restore stack frame
        popa
        pop     bp
        ret     4

SETCURSORPOS    endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     SETCURSORTYPE                                   *
;*                                                                      *
;* DESCRIPTIVE NAME:    Set cursor height, width, attribute             *
;*                                                                      *
;* INPUT:       STACK FRAME on entry                                    *
;*                                                                      *
;* SS:SP  --->  ip              dw      Caller IP offset                *
;*              CursorAttribute dw      Cursor attribute                *
;*              CursorWidth     dw      Cursor width                    *
;*              CursorEnd       dw      Cursor end line                 *
;*              CursorStart     dw      Cursor start line               *
;*                                                                      *
;* INTERNAL REFERENCES: None                                            *
;*                                                                      *
;* EXTERNAL REFERENCES: None                                            *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
SETCURSORTYPE   proc    near
        public  SETCURSORTYPE

        push    bp                          ; setup stack frame
        mov     bp, sp
        pusha
        push    ds
        mov     ax, _DATA
        mov     ds, ax
        mov     ds, ds:VideoBuffSel

        push    _DATA                                                   ;J-TS011792
        push    offset _SemAccessAPA                                    ;J-TS011792
        push    -1                                                      ;J-TS011792
        push    -1                                                      ;J-TS011792
        call    DOSFSRAMSEMREQUEST                                      ;J-TS011792

        call    HideCursor                  ; hide cursor

        mov     ax, [bp+10]                 ; copy cursor start line
        mov     ds:VGA_CsrStart, ax

        mov     ax, [bp+8]                  ; copy cursor end line
        mov     ds:VGA_CsrEnd, ax

        mov     ax, [bp+6]                  ; copy cursor width
        mov     ds:VGA_CsrWidth, ax

        mov     ax, [bp+4]                  ; copy cursor attribute
        mov     ds:VGA_CsrAttrib, ax

        call    ShowCursor                  ; show cursor again

        push    _DATA                                                   ;J-TS011792
        push    offset _SemAccessAPA                                    ;J-TS011792
        call    DOSFSRAMSEMCLEAR                                        ;J-TS011792

        pop     ds                          ; restore stack frame
        popa
        pop     bp
        ret     8

SETCURSORTYPE   endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     SETCURSORCOLOR                                  *
;*                                                                      *
;* DESCRIPTIVE NAME:    Set cursor color                                *
;*                                                                      *
;* INPUT:       STACK FRAME on entry                                    *
;*                                                                      *
;* SS:SP  --->  ip              dw      Caller IP offset                *
;*              CursorColor     dw      Cursor color                    *
;*                                                                      *
;* INTERNAL REFERENCES: None                                            *
;*                                                                      *
;* EXTERNAL REFERENCES: None                                            *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
SETCURSORCOLOR  proc    near
        public  SETCURSORCOLOR

        push    bp                          ; setup stack frame
        mov     bp, sp
        pusha
        push    ds
        mov     ax, _DATA
        mov     ds, ax
        mov     ds, ds:VideoBuffSel

        push    _DATA                                                   ;J-TS011792
        push    offset _SemAccessAPA                                    ;J-TS011792
        push    -1                                                      ;J-TS011792
        push    -1                                                      ;J-TS011792
        call    DOSFSRAMSEMREQUEST                                      ;J-TS011792

        call    HideCursor                  ; hide cursor

        mov     ax, [bp+4]                  ; copy cursor color
        mov     ds:VGA_CsrColor, ax

        call    ShowCursor                  ; show cursor again

        push    _DATA                                                   ;J-TS011792
        push    offset _SemAccessAPA                                    ;J-TS011792
        call    DOSFSRAMSEMCLEAR                                        ;J-TS011792

        pop     ds                          ; restore stack frame
        popa
        pop     bp
        ret     2

SETCURSORCOLOR  endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     GETCURSORCOLOR                                  *
;*                                                                      *
;* DESCRIPTIVE NAME:    Get cursor color                                *
;*                                                                      *
;* INPUT:       None                                                    *
;*                                                                      *
;* OUTPUT:                                                              *
;*      AX   : cursor color                                             *
;*                                                                      *
;* INTERNAL REFERENCES: None                                            *
;*                                                                      *
;* EXTERNAL REFERENCES: None                                            *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
GETCURSORCOLOR  proc    near
        public  GETCURSORCOLOR

        push    ds
        mov     ax, _DATA
        mov     ds, ax
        mov     ds, ds:VideoBuffSel

        mov     ax, ds:VGA_CsrColor         ; get cursor color

        pop     ds

        ret     0

GETCURSORCOLOR  endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     SETGRIDDRAWCOLOR                                *
;*                                                                      *
;* DESCRIPTIVE NAME:    Set grid color                                  *
;*                                                                      *
;* INPUT:       STACK FRAME on entry                                    *
;*                                                                      *
;* SS:SP  --->  ip              dw      Caller IP offset                *
;*              CursorColor     dw      Grid color                      *
;*                                                                      *
;* INTERNAL REFERENCES: None                                            *
;*                                                                      *
;* EXTERNAL REFERENCES: None                                            *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
SETGRIDDRAWCOLOR    proc    near
        public  SETGRIDDRAWCOLOR

        push    bp                          ; setup stack frame
        mov     bp, sp
        pusha
        push    ds
        mov     ax, _DATA
        mov     ds, ax
        mov     ds, ds:VideoBuffSel

        mov     ax, [bp+4]                  ; copy cursor color
        mov     ds:VGA_GridColor, al

        pop     ds                          ; restore stack frame
        popa
        pop     bp
        ret     2

SETGRIDDRAWCOLOR    endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     GETGRIDDRAWCOLOR                                *
;*                                                                      *
;* DESCRIPTIVE NAME:    Get grid color                                  *
;*                                                                      *
;* INPUT:       None                                                    *
;*                                                                      *
;* OUTPUT:                                                              *
;*      AX   : grid color                                               *
;*                                                                      *
;* INTERNAL REFERENCES: None                                            *
;*                                                                      *
;* EXTERNAL REFERENCES: None                                            *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
GETGRIDDRAWCOLOR    proc    near
        public  GETGRIDDRAWCOLOR

        push    ds
        mov     ax, _DATA
        mov     ds, ax
        mov     ds, ds:VideoBuffSel

        mov     al, ds:VGA_GridColor        ; get grid color
        xor     ah, ah

        pop     ds

        ret     0

GETGRIDDRAWCOLOR    endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     ShowCursor                                      *
;*                                                                      *
;* DESCRIPTIVE NAME:    Show cursor if cursor attribute is 'show' and   *
;*                      now cursor isn't showed.                        *
;*                                                                      *
;* INPUT:       None                                                    *
;*                                                                      *
;* OUTPUT:      None                                                    *
;*                                                                      *
;* INTERNAL REFERENCES: CheckCursorSel, DrawCursor                      *
;*                                                                      *
;* EXTERNAL REFERENCES: None                                            *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
ShowCursor      proc    near
        public  ShowCursor

        pusha
        pushf
        push    ds
        push    es
        cld

        call    CheckCursorSel              ; check cursor selector

        .if     <ax eq 0>
            mov     ax, _DATA
            mov     ds, ax
            mov     ds, ds:VideoBuffSel

            .if     <ds:VGA_CsrAttrib ne -1>
                call    DrawCursor
            .endif
        .endif

        pop     es
        pop     ds
        popf
        popa
        ret

ShowCursor      endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     HideCursor                                      *
;*                                                                      *
;* DESCRIPTIVE NAME:    Hide cursor if cursor attribute is 'show' and   *
;*                      now cursor is showed.                           *
;*                                                                      *
;* INPUT:       None                                                    *
;*                                                                      *
;* OUTPUT:      None                                                    *
;*                                                                      *
;* INTERNAL REFERENCES: CheckCursorSel, EraseCursor                     *
;*                                                                      *
;* EXTERNAL REFERENCES: None                                            *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
HideCursor      proc    near
        public  HideCursor

        pusha
        pushf
        push    ds
        push    es
        cld

        call    CheckCursorSel              ; check cursor selector

        .if     <ax eq 0>
            mov     ax, _DATA
            mov     ds, ax
            mov     ds, ds:VideoBuffSel

            .if     <ds:VGA_CsrAttrib ne -1> and
            .if     <ds:VGA_SaveFlag eq 1>
                call    EraseCursor
            .endif
        .endif

        pop     es
        pop     ds
        popf
        popa
        ret

HideCursor      endp

R2CSEG  ENDS
        END
