;*DDK*************************************************************************/
;
; COPYRIGHT (C) Microsoft Corporation, 1989
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
        PAGE    60,132
        TITLE   COMMNPVB.ASM -- PVB Write Routines for COMMON Format

;/*****************************************************************************
;*
;* SOURCE FILE NAME = COMMNPVB.ASM
;*
;* DESCRIPTIVE NAME = Regen Buffer Update Routine
;*
;*
;* VERSION      V2.0
;*
;* DATE
;*
;* DESCRIPTION
;*
;* FUNCTIONS    WriteCellStrE, WriteCharStrE, WriteCharStrAttrE,
;*              WriteNCharE, WriteNAttrE, WriteNCellE
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES  NONE
;*
;* EXTERNAL REFERENCES  LocateBuffAddr  (in XGAREAD.ASM)
;*
;*              NONE
;*
;* CHANGE ACTIVIY =
;*   DATE      FLAG       APAR    CHANGE DESCRIPTION
;*   --------  ---------- -----   --------------------------------------
;*   mm/dd/yy  @Vr.mpppxx xxxxx   xxxxxxx
;*             J-KK0821           KKJ, Re-adjust the end offset value.
;*   09/13/89  j-ys913                     fix for P0014 sct$12cc. (The 2nd attribute of cell with
;*                                     which the scrolled area is filled was ignored.)
;*   09/25/89  J-KK0925           KKJ, ROM Font -> RAM Font
;*   09/27/89  J-KK0927           KKJ, PTR0012, Scroll Cell was wrong.
;*   10/17/89  J-KK1017           KKJ, Add Set_StartEndRow for Xvio Redraw.
;*   10/19/89  J-KK1019           KKJ, Re-adjust the end offset value for Redraw at WrtNAttr
;*             j-ys1020,1023           for MS-Xvio support.
;*   10/31/89  J-KK1031           KKJ, Delete FONTCALL.
;*   11/15/89  j-ys1115                MS-XVIO,     in WrtNattr (P0149 SCT$12CC) fix.
;*   11/16/89  j-ys1116                MS-XVIO, Avoid Trap-D in the edge.
;*   08/09/91  J-TS080991              VIO write over XVIO PS destroy screen. PTR JS01621
;*             J-TS100391         TSO, Fix Buf - JS01739
;*             J-TS011492         TSO, Fix     - JS02411
;****************************************************************************/

        .286c                           ; 286 protect mode instructions

        .xlist
        INCLUDE struc.inc               ; Structure macro
        INCLUDE vdhequ.inc              ; Buffer update equates
        INCLUDE vdhstruc.inc            ; Buffer update data structures
        include vdh.inc                 ; Definitions
        include vgaemu.inc              ; VGA text emulation video buffer
        .list

_DATA   SEGMENT WORD PUBLIC 'DATA'
;************************************************************************
;*  Global data                                                         *
;************************************************************************
        extrn   VideoBuffSel : word

_DATA   ENDS

INSTSEG SEGMENT PARA PUBLIC 'DATA'
;************************************************************************
;*  Per process instance data                                           *
;************************************************************************
INSTSEG ENDS

        EXTRN   Set_StartEndRow:NEAR    ; StartRow and EnsRow          J-KK1017

        extrn   SetupAPAWrite : far     ; setup APA write mode
        extrn   ShowCursor    : near    ; show cursor
        extrn   HideCursor    : near    ; hide cursor
        extrn   ShadowToAPA   : near    ; Update APA based on shadow buf
        extrn   FillWithSBCS  : near    ; fill shadow & APA with SBCS char

R2CSEG  SEGMENT WORD    PUBLIC 'CODE'
        ASSUME  CS:R2CSEG,DS:NOTHING,ES:NOTHING

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     UpdateRegenC                                    *
;*                                                                      *
;* DESCRIPTIVE NAME:    Call a Update Regen (PVB) routine               *
;*                      For COMMON DBCS mode.                           *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;* INTERNAL REFERENCES: UpdateRegenOneLineC                             *
;*                                                                      *
;* EXTERNAL REFERENCES: ShowCursor, HideCursor, SetupAPAWrite,          *
;*                      Set_StartEndRow                                 *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
UpdateRegenC    proc near
        public  UpdateRegenC

        .if     <[bp].PVB_Sel ne 0> and ; PVB Update ?
        .if     <[bp].Sub_length gt 0>  ; one or more character update?

            call    HideCursor          ; hide cursor

            call    SetupAPAWrite       ; setup APA write mode
            mov     [bp].APAPrevColor, -1   ; reset preset color

            mov     ds, [bp].LVB_Sel    ; setup LVB/Shadow PVB pointer
            mov     si, [bp].Sub_offset ; ds:si = LVB top
            mov     ax, _DATA           ; es:di = Shadow PVB top
            mov     es, ax              ; 
            mov     es, es:VideoBuffSel ; 
            mov     di, [bp].PVBOff     ; PVB buffer is 2 bytes/cell
            shl     di, 1               ; Shadow buffer is 4 bytes/cell

            mov     dx, [bp].Sub_length ; setup total cell count

            .if     <dx g [bp].FirstRow> ; Update region is included in a line?
                mov     cx, [bp].FirstRow ; No, set first row length
            .else
                mov     cx, dx          ; Yes, set total length
            .endif

UpdateRegenLoopC:
                push    cx                  ; save current line counter
                push    dx                  ; & total counter

                call    UpdateRegenOneLineC ; call one line update function

                pop     dx                  ; restore current line counter
                pop     cx                  ; & total counter

                sub     dx, cx          ; dec total length
                jz      UpdateRegenLoopExitC    ; end ? then exit the loop

                .if     <dx gt [bp].RowLength>  ; set next line length
                    mov     cx, [bp].RowLength  ; full line
                .else
                    mov     cx, dx              ; last line
                .endif
                add     di, [BP].PVBSkip        ; skip PVB pointer to next line
                add     di, [BP].PVBSkip        ; 2 times PVBSkip is 2 byte/cell
                jmp     UpdateRegenLoopC        ; goto next line

UpdateRegenLoopExitC:
            mov     al, 2               ; 4 bytes Cell
;J-TS080991 shr     di, 1               ; adjust ptr
            call    Set_StartEndRow     ; 

            call    ShowCursor          ; show cursor

        .endif
        ret
UpdateRegenC endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     UpdateRegenOneLineC                             *
;*                                                                      *
;* DESCRIPTIVE NAME:    Update shadow buffer & call APA update routine  *
;*                      For COMMON DBCS mode.                           *
;*                                                                      *
;* INPUT:                                                               *
;* CX           Cell Count                                              *
;* DS:SI  --->  LVB Address                                             *
;* ES:DI  --->  Shadow Buffer Address                                   *
;*                                                                      *
;* INTERNAL REFERENCES: CommonToAtlas3                                  *
;*                                                                      *
;* EXTERNAL REFERENCES: ShadowToAPA                                     *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
UpdateRegenOneLineC proc    near
        public  UpdateRegenOneLineC

        mov     [bp].APA_from, di       ; save shadow top pointer & char cnt
        mov     [bp].APA_cnt, cx        ; for latter use (update APA image)

        .if     <di ge 4> and           ; First character check
        mov     bl, es:shadow[di+3]     ; Target header is DBCS 2nd ?
        and     bl, dbcsA1+dbcsA2       ; 
        .if     <bl eq dbcsA1+dbcsA2>   ; Overwrite DBCS 1st
            mov     byte ptr es:shadow[di-4], 20h                   ; set space
            mov     byte ptr es:shadow[di-1], EXTRA_ATTRHigh+CHANGE_BITHigh ; reset flag
            sub     [bp].APA_from, 4    ; adjust APA update area
            inc     [bp].APA_cnt
        .endif                          ; 

        mov     bl, [si+3]              ; Source header is DBCS 2nd ?
        and     bl, dbcsA1+dbcsA2       ; 
        .if     <bl eq dbcsA1+dbcsA2>   ; 
            mov     al, 20h             ; Yes, then write SBCS space
            mov     dl, [si+2]          ; 
            mov     dh, EXTRA_ATTRHigh  ; 
        .else
            mov     al, [si]            ; No, get character code from LVB
            mov     dx, [si+2]          ; 
        .endif
        mov     ah, [si+1]              ; Get attribute

OneLineLoopC:

        .if     <cx eq 1>               ; Last character check

            .if     <di lt [bp].Sub_PVBend> and ; 
            mov     bl, es:shadow[di+3] ; Target tail is DBCS 1st ?
            and     bl, dbcsA1+dbcsA2   ; 
            .if     <bl eq dbcsA1>      ; Overwrite DBCS 2nd
                mov     byte ptr es:shadow[di+4], 20h           ; set space
                mov     byte ptr es:shadow[di+7], EXTRA_ATTRHigh+CHANGE_BITHigh ; reset flag
                inc     [bp].APA_cnt    ; adjust APA update area
            .endif                      ; 

            mov     bl, [si+3]          ; Source tail is DBCS 1st ?
            and     bl, dbcsA1+dbcsA2   ; 
            .if     <bl eq dbcsA1>      ; 
                mov     al, 20h         ; Yes, then write SBCS space
                mov     dh, EXTRA_ATTRHigh
            .endif

        .endif

        call    CommonToAtlas3          ; convert attribute

        .if     <ax ne <word ptr es:shadow[di  ]>> or ; displayed char
        .if     <dx ne <word ptr es:shadow[di+2]>>    ; is changed ?
            or      dx, CHANGE_BIT                    ; set change flag
            mov     word ptr es:shadow[di], ax        ; Copy char/attr0
            mov     word ptr es:shadow[di+2], dx      ; Store Extra Attr1/2
        .endif

        add     si, 4                       ; set pointer to next source
        add     di, 4                       ; set pointer to next target

        dec     cx                          ; check loop end
        jz      OneLineLoopExitC

        mov     ax, [si]                    ; get next char/attr0
        mov     dx, [si+2]                  ; get next attr1/attr2
        jmp     OneLineLoopC

OneLineLoopExitC:
        push    si                  ; save source & target pointer
        push    di
        push    ds
        push    es

        call    ShadowToAPA         ; Update APA based on shadow buf

        pop     es                  ; restore source & target pointer
        pop     ds
        pop     di
        pop     si

        ret

UpdateRegenOneLineC endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     CommontoAtlas3                                  *
;*                                                                      *
;* DESCRIPTIVE NAME:    Convert Common attribute to Atlas attribute     *
;*                                                                      *
;* INPUT:                                                               *
;* AX     = char/attr0  of common format                                *
;* DX     = attr1/attr2 of common format                                *
;*                                                                      *
;* OUTPUT:                                                              *
;* AX     = char/attr0  of atlas3 format                                *
;* DX     = attr1/attr2 of atlas3 format                                *
;*                                                                      *
;* INTERNAL REFERENCES: None                                            *
;*                                                                      *
;* EXTERNAL REFERENCES: None                                            *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
CommonToAtlas3  proc    near
        public  CommonToAtlas3
        push    bx                              ; save work register

        xor     bl, bl                          ; init work register

        .if     <bit dl and REVERSE_BIT>        ; check reverse bit
            ror     ah, 4
        .endif
        .if     <bit dl and UNDERLINE_BIT>      ; check underline bit
            or  bl, A_UNDERLINE_BIT
        .endif
        .if     <bit dl and VERT_BIT>           ; check vertical grid bit
            or  bl, A_VERT_BIT
        .endif
        .if     <bit dl and HORZ_BIT>           ; check horizontal grid bit
            or  bl, A_HORZ_BIT
        .endif

        mov     dl, bl                          ; store converted attribute

        .if     <bit dh and dbcsA1>             ; DBCS ?
            and     dh, dbcsA1+dbcsA2
            or      dx, EXTRA_ATTR
        .elseif <bit dh and 02h>                ; extention SBCS ?
            mov     dh, TypeF
        .else                                   ; base SBCS
            mov     dh, TypeE
        .endif

        pop     bx                              ; restore work register
        ret
CommonToAtlas3  endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     UpdateAttrC                                     *
;*                                                                      *
;* DESCRIPTIVE NAME:    Call a Update Regen (PVB) routine for Attribute *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;* INTERNAL REFERENCES: UpdateRegenC                                    *
;*                                                                      *
;* EXTERNAL REFERENCES: None                                            *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
UpdateAttrC proc near
        public  UpdateAttrC

        call    UpdateRegenC

        ret
UpdateAttrC endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     COMMON_CFillR                                   *
;*                                                                      *
;* DESCRIPTIVE NAME:    Update PVB for Filling Cell at Scrolling        *
;*                      This is called per line.                        *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* ES:DI  --->  PVB Address                                             *
;* CX     --->  Length Bytes                                            *
;* Flag   --->  CLD or STD                                              *
;*                                                                      *
;* INTERNAL REFERENCES: CommonToAtlas                                   *
;*                                                                      *
;* EXTERNAL REFERENCES: FillWithSBCS                                    *
;*                                                                      *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
COMMON_CFillR proc
        public  COMMON_CFillR

        ; get PVB format cell to fill in ax:char/attr0 & dx:attr1/attr2

        mov     ax, [bp].FillCellLow
        mov     dx, [bp].FillCellHigh
        and     dx, not (dbcsA2H+dbcsA1H)   ; clear DBCS bit
        call    CommonToAtlas3              ; convert attribute

        call    FillWithSBCS                ; call update routine

        ret

COMMON_CFillR endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     UpdateCARegenC                                  *
;*                                                                      *
;* DESCRIPTIVE NAME:    Call a Update Regen (PVB) routine for CA        *
;*                                                                      *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;* INTERNAL REFERENCES: UpadateRegenC                                   *
;*                                                                      *
;* EXTERNAL REFERENCES: None                                            *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
UpdateCARegenC proc near
        public  UpdateCARegenC
        call    UpdateRegenC
        ret
UpdateCARegenC endp

;********************** START OF SPECIFICATIONS *************************
;*                                                                      *
;* SUBROUTINE NAME:     UpdateCAAttrC                                   *
;*                                                                      *
;* DESCRIPTIVE NAME:    Call a Update Regen (PVB) routine for Attribute *
;*                         for CA                                       *
;* INPUT:                                                               *
;* SS:BP  --->  Stack frame                     (see VDHSTRUC.INC)      *
;* ES:DI  --->  LVB Address                     (see XGAWRITE.ASM)      *
;*                                                                      *
;* INTERNAL REFERENCES: UpdateRegenC                                    *
;*                                                                      *
;* EXTERNAL REFERENCES: None                                            *
;*                                                                      *
;********************** END OF SPECIFICATIONS ***************************
UpdateCAAttrc proc near
        public  UpdateCAAttrc
        call    UpdateRegenC
        ret
UpdateCAAttrc endp

COMMON_LVBrecttoPVB proc                ;j-ys1026
public      COMMON_LVBrecttoPVB         ;j-ys1026
                                                                        ;J-TS100391
        call    HideCursor                  ; hide cursor               ;J-TS100391
                                                                        ;J-TS100391
        call    SetupAPAWrite               ; setup APA write mode      ;J-TS100391
        mov     [bp].APAPrevColor, -1       ; reset preset color        ;J-TS100391
                                                                        ;J-TS100391
        mov     ds, [bp].LVB_SEL            ; setup selectors           ;J-TS100391
        mov     ax, _DATA                                               ;J-TS100391
        mov     es, ax                                                  ;J-TS100391
        mov     es, es:VideoBuffSel
                                                                        ;J-TS100391
        mov     si,[bp].LVBFillOff          ; setup ofsets              ;J-TS100391
        mov     di,[bp].PVBFillOff                                      ;J-TS100391
                                                                        ;J-TS100391
        mov     dx,[bp].RowsToFill          ; set row loop counter      ;J-TS100391
                                                                        ;J-TS100391
COMMNLPLoop:                                                            ;J-TS100391
        mov     cx,[bp].LVBFillCount        ; set column counter        ;J-TS100391
        shr     cx, 2                                                   ;J-TS100391
                                                                        ;J-TS100391
        mov     bx, [bp].LVBFillCount                                   ;J-TS100391
        add     bx, si                                                  ;J-TS100391
        .if     <bx b [bp].Sub_Buffsize> and ; last char is DBCS 1st ?  ;J-TS100391
;J-TS011492        mov     al, byte ptr ds:[bx+3]                                  ;J-TS100391
        mov     al, byte ptr ds:[bx+3-4]                                ;J-TS011492
        and     al, dbcsA1+dbcsA2                                       ;J-TS100391
        .if     <al e dbcsA1>                                           ;J-TS100391
            inc     cx                      ; include DBCS 2nd          ;J-TS100391
            or      [bp].Sub_Option, f_end_adjust ; set adjust flag     ;J-TS100391
        .endif                                                          ;J-TS100391
                                                                        ;J-TS100391
        .if     <si ge 4> and               ; first char is DBCS 2nd ?  ;J-TS100391
        mov     al, byte ptr ds:[si+3]                                  ;J-TS100391
        and     al, dbcsA1+dbcsA2                                       ;J-TS100391
        .if     <al e dbcsA1+dbcsA2>                                    ;J-TS100391
            sub     si, 4                   ; include DBCS 1st          ;J-TS100391
            sub     di, 4                                               ;J-TS100391
            inc     cx                                                  ;J-TS100391
        .endif                                                          ;J-TS100391
                                                                        ;J-TS100391
        push    dx                                                      ;J-TS100391
        call    UpdateRegenOneLineC         ; update one line           ;J-TS100391
        pop     dx                                                      ;J-TS100391
                                                                        ;J-TS100391
        add     si, [bp].LVBFillSkip        ; skip to next line         ;J-TS100391
        add     di, [bp].PVBFillSkip                                    ;J-TS100391
                                                                        ;J-TS100391
        .if     <bit [bp].Sub_Option and f_end_adjust>                  ;J-TS100391
            sub     si, 4                   ; adjust ptrs               ;J-TS100391
            sub     di, 4                   ;                           ;J-TS100391
            and     [bp].Sub_Option, not f_end_adjust ; clear adjust flag   ;J-TS100391
        .endif                                                          ;J-TS100391
                                                                        ;J-TS100391
        dec     dx                                                      ;J-TS100391
        jnz     COMMNLPLoop                                             ;J-TS100391
                                                                        ;J-TS100391
        call    ShowCursor                  ; show cursor               ;J-TS100391
                                                                        ;J-TS100391
            ret                         ;j-ys1026
COMMON_LVBrecttoPVB endp                ;j-ys1026

COMMON_CArecttoPVB proc                 ;j-ys111
public      COMMON_CArecttoPVB          ;j-ys111
            ret                         ;j-ys111
COMMON_CArecttoPVB endp                 ;j-ys111

R2CSEG  ENDS
        END
